
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>
   #include <hmpi.h>

   #define  HOSTNAMELENGTH   64
   #define  FILE_LENGTH      1024
   #define  ENV_VAR_LENGTH   1024

   int main(int argc, char **argv)
   {
      int i, rc, prank;

      char *mpcload_dir;
      char *hmpi_home;
      char file_remove[FILE_LENGTH];
      char hostname[HOSTNAMELENGTH];
      
      rc = HMPI_Init(
               &argc,
               &argv
      );

      if (rc != HMPI_OK)
      {
         printf(
             "Problems initializing HMPI runtime "
             "...Exiting...\n"
         );

         HMPI_Finalize(-1);
      }

      if (!HMPI_Is_member(HMPI_COMM_WORLD_GROUP))
      {
         HMPI_Finalize(0);
      }

      //
      // To print the hostname on which the error occurred
      gethostname(
          hostname,
          HOSTNAMELENGTH
      );

      prank = HMPI_Group_rank(
              HMPI_PROC_WORLD_GROUP
      );

      //
      // Get the HMPI installation directory
      hmpi_home = getenv("HMPI_HOME");

      if (hmpi_home == NULL)
      {
         printf("HMPI_HOME not set on machine %s\n", hostname);
         HMPI_Finalize(-2);
      }

      if (prank != 0)
      {
         HMPI_Finalize(0);
      }

      //
      // Get the MPC Load directory
      mpcload_dir = getenv("MPCLOAD");

      if (mpcload_dir == NULL)
      {
         printf("MPCLOAD not set\n");
         HMPI_Finalize(-3);
      }

      // Remove the run_hmpiload.sh file from the
      // $MPCLOAD directory
      strcpy(file_remove, "/bin/rm -f ");
      strcat(file_remove, mpcload_dir);
      strcat(file_remove, "/run_hmpiload.sh");

      system(file_remove);

      HMPI_Finalize(0);
   }
