
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>
   #include <hmpi.h>

   #define  HOSTNAMELENGTH   64
   #define  FILE_LENGTH      64
   #define  ENV_VAR_LENGTH   1024

   int main(int argc, char **argv)
   {
      int debug_mode = 0;
      int i, rc;

      char filename[FILE_LENGTH];
      FILE *foutput;

      char *hmpi_home;
      char *mpcload_dir;
      char hostname[HOSTNAMELENGTH];
      char script_perms[ENV_VAR_LENGTH];
      
      // This communicator consists of 
      // one process per processor node
      int prank;

      rc = HMPI_Init(
               &argc,
               &argv
      );

      if (rc != HMPI_OK)
      {
         printf(
             "Problems initializing HMPI runtime "
             "...Exiting...\n"
         );

         HMPI_Finalize(-1);
      }

      if (!HMPI_Is_member(HMPI_PROC_WORLD_GROUP))
      {
         HMPI_Finalize(0);
      }

      //
      // To print the hostname on which the error occurred
      gethostname(
          hostname,
          HOSTNAMELENGTH
      );

      prank = HMPI_Group_rank(
              HMPI_PROC_WORLD_GROUP
      );

      //
      // Get the HMPI installation directory
      hmpi_home = getenv("HMPI_HOME");

      if (hmpi_home == NULL)
      {
         printf("HMPI_HOME not set on machine %s\n", hostname);
         HMPI_Finalize(-2);
      }

      if (prank != 0)
      {
         HMPI_Finalize(0);
      }   

      //
      // Get the MPC Load directory
      mpcload_dir = getenv("MPCLOAD");

      if (hmpi_home == NULL)
      {
         printf("MPCLOAD not set\n");
         HMPI_Finalize(-3);
      }

      //Print the compilation command
      //to the terminal
      printf("mpcload -het ");
      printf("-I\\$HMPI_HOME/include ");

      for (i = 1; i < argc; i++)
      {
          printf(" ");
          printf("%s", argv[i]);
          printf(" ");
      }

      printf(" ");
      printf("%s\n", "-L\\$HMPI_HOME/lib -lhmpi");

      // Open the file
      // to write the mpcload 
      // command to
      strcpy(filename, mpcload_dir);
      strcat(filename, "/run_hmpiload.sh");
      foutput = fopen(filename, "w");

      if (foutput == NULL)
      {
         printf("Problems with opening a file for writing: %s\n", filename);
         HMPI_Finalize(-4);
      }

      // Print the compilation string to 
      // the file
      // cannot execute the mpcload command 
      // using system due to some issues
      fprintf(foutput, "%s\n", "#!/bin/sh");
      fprintf(foutput, "\n");
      fprintf(foutput, "%s", "mpcload -het ");
      fprintf(foutput, "%s", "-I\\$HMPI_HOME/include ");

      for (i = 1; i < argc; i++)
      {
          fprintf(foutput, " ");
          fprintf(foutput, "%s", argv[i]);
          fprintf(foutput, " ");
      }

      fprintf(foutput, " ");
      fprintf(foutput, "%s\n", "-L\\$HMPI_HOME/lib -lhmpi");
      fclose(foutput);

      // Make the script 
      // executable
      strcpy(script_perms, "chmod a+x ");
      strcat(script_perms, filename);

      system(script_perms);
      
      HMPI_Finalize(0);
   }
