
  #include <math.h>
  #include <stdio.h>

  #include <hmpi.h>

  #include "ParallelAxB.c"
  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, j, k, rc;

     {
        rc = HMPI_Init(
                 &argc,
                 &argv
        );

        if (rc != HMPI_OK)
        {
           printf(
               "Problems initializing HMPI runtime "
               "...Exiting...\n"
           );

           HMPI_Finalize(-1);
        }
     }

     if (HMPI_Is_recon_required)
     {
        rc = Do_recon();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems reconning the network"
              "...Exiting...\n"
           );

           HMPI_Finalize(-2);
        }
     }

     {
        n = N;
        rc = Timeof();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           HMPI_Finalize(-3);
        }
     }

     HMPI_Finalize(0);
   }
