
  #include "pdgemm_i.h"
  #include <cblas.h>

  /*-----------------------------------------------------*/

   int
   Input_recon
   (
      double *a,
      double *b,
      double *c
   )
   {
      int i, j;
      for (i = 0; i < recon_n; i++)
      {
          for (j = 0; j < recon_n; j++)
          {
             a[i*recon_n + j] = 2.0;
          }
      }

      for (i = 0; i < recon_n; i++)
      {
          for (j = 0; j < recon_n; j++)
          {
              b[i*recon_n + j] = 2.0;
          }
      }

      for (i = 0; i < recon_n; i++)
      {
          for (j = 0; j < recon_n; j++)
          {
              c[i*recon_n + j] = 0.0;
          }
      }

      return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int Perf_func
   (
       int x, /* --r-- */
       int y, /* --n-- */
       int z  /* --t-- */
   )
   {
      /*
       * Multiplication of r*n and n*t matrices.
       */
      int i,j,m,n,k,lda,ldb,ldc;
      double alpha=1.0, beta=0.0;

       a = (double*)malloc(
                    sizeof(double)
                    *
                    (recon_n*recon_n)
       );

       b = (double*)malloc(
                    sizeof(double)
                    *
                    (recon_n*recon_n)
       );

       c = (double*)malloc(
                    sizeof(double)
                    *
                    (recon_n*recon_n)
       );

       Input_recon(
         a,
         b,
         c
       );

      /*
       * call BLAS routine to compute C=A*B
       */
      m = nb;
      n = nb;
      k = recon_n;
      lda = k;
      ldb = k;
      ldc = m;
      cblas_dgemm(
           101,
           111,
           111,
           m,
           n,
           k,
           alpha,
           a,
           lda,
           b,
           ldb,
           beta,
           c,
           ldc
      );

       free(a);
       free(b);
       free(c);


      return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   void Benchmark_function
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   )
   {
      int* params = (int*)input_p;

      int result = Perf_func(
                       params[0],
                       params[1],
                       params[2]
      );

      *(int*)output_p = result;

      return;
   }

   /*-----------------------------------------------------*/

   int Do_recon()
   {
       if (HMPI_Is_member(HMPI_COMM_WORLD_GROUP))
       {
            int rc;
            int output_p;
            int input_p[3] =
                {
                   recon_n,
                   recon_n,
                   recon_n
            };

            rc = HMPI_Recon(
                     &Benchmark_function,
                     input_p,
                     3,
                     &output_p
            );

            if  (rc != HMPI_OK)
            {
                printf("Panic: HMPI_Recon failed\n");
                return rc;
            }
       }

       if ((VERBOSE > 0)
           && (HMPI_Is_host()
          )
       )
       {
          printf("Recon finished\n");
       }

       return HMPI_OK;
  }

   /*-----------------------------------------------------*/

