#include "simpleGrid.h"

int HMPI_NetType_simpleGrid_node 
(
    int pnum,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
)
{
    return 2;
}

int HMPI_NetType_simpleGrid_link 
(
    int pnum1,
    int pnum2,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
)
{
    return 0;
}

int HMPI_NetType_simpleGrid_parent
(
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
)
{
    int coordinate[2];
    coordinate[0] = 0;
    coordinate[1] = 0;
    return 
    HMPI_NetType_simpleGrid_coord2number
    (
        coordinate,
        ppar,
        ppower,
        pnodes,
        plinks
    );            
}

int HMPI_NetType_simpleGrid_power
(
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
)
{
    return * ppar *  * (ppar + 1);
}

void HMPI_NetType_simpleGrid_number2coord
(
     int pnum,
     const int *ppar,
     int *pcoord,
     int ppower,
     int **pnodes,
     int **plinks
)
{
  int tmp;
  tmp =  * (ppar + 1);
   * pcoord = pnum / tmp;
  pnum = pnum % tmp;
   * (pcoord + 1) = pnum;
}

int HMPI_NetType_simpleGrid_coord2number
(
    const int *pcoord,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
)
{
    return * pcoord *  * (ppar + 1) +  * (pcoord + 1);
}

HMPI_NetType HMPI_NetType_simpleGrid = 
                                 {
                                   2,
                                   HMPI_NetType_simpleGrid_node,
                                   HMPI_NetType_simpleGrid_link,
                                   HMPI_NetType_simpleGrid_parent,
                                   HMPI_NetType_simpleGrid_power,
                                   HMPI_NetType_simpleGrid_number2coord,
                                   HMPI_NetType_simpleGrid_coord2number,
                                   NULL
};

