
   #include <hmpi.h>
   #include "simpleGrid.c"

   #define  n  512
   #define  r  256
   #define  t  256

   #define  HOSTNAMELENGTH  64

   int Perf_func
   (
       int x,
       int y,
       int z
   );

   int
   Input
   (
      double *a,
      double *b,
      double *c
   )
   {
     int i, j;
     for (i = 0; i < r; i++)
     {
          for (j = 0; j < n; j++)
          {
              a[i*n + j] = 2.0;
          }
      }

      for (i = 0; i < n; i++)
      {
          for (j = 0; j < t; j++)
          {
              b[i*t + j] = 2.0;
          }
      }

      for (i = 0; i < r; i++)
      {
          for (j = 0; j < t; j++)
          {
              c[i*t + j] = 0.0;
          }
      }

      return 0;
   }

   void Benchmark_function
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   );

   static double *a, *b, *c;

   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Group gid;
       int net_params[2];
       int param_count;

       HMPI_Init(
           &argc, 
           &argv
       );

       a = (double*)malloc(
                    sizeof(double)
                    *
                    (r*n)
       );

       b = (double*)malloc(
                    sizeof(double)
                    *
                    (n*t)
       );

       c = (double*)malloc(
                    sizeof(double)
                    *
                    (r*t)
       );

       Input(
         a,
         b,
         c
       );

       if (HMPI_Is_host())
       {
          printf("Executing the benchmark code in call to HMPI_Recon\n");
       }

       if  (HMPI_Is_member(HMPI_COMM_WORLD_GROUP))
       {
            int rc;
            int output_p;
            int input_p[3] = 
                {
                   r,
                   n,
                   t
            };

            rc = HMPI_Recon(
                     &Benchmark_function,
                     input_p,
                     3,
                     &output_p
            );
 
            if  (rc != HMPI_OK)
            {
                printf("Panic: HMPI_Recon failed \n");
                HMPI_Abort(-1);
            } 
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          int gsize, p, q;

          param_count = 2;

          gsize = HMPI_Group_size(
                      HMPI_COMM_WORLD_GROUP
          );

          p = q = sqrt(gsize);

          if ((p == 0)
              && (q == 0
             )
          )
          {
             p = q = 1;
          }

          net_params[0] = p;
          net_params[1] = q;

          printf("Total number of processes available for computation is = %d\n", gsize);
          printf("Creating a grid (%d, %d) of processes\n", p, q);

          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       {
          int dummy, rc, i;
          int num_of_processors = HMPI_Get_number_of_processors();
          double *rperf = (double*)malloc(
                                   sizeof(double)
                                   *
                                   num_of_processors
          );

          rc = HMPI_Get_processors_info(
                   rperf
          );

          if (rc != HMPI_OK)
          {
             printf(
                "MAIN:Problems getting the performances"
                "...Exiting...\n"
             );
             HMPI_Abort(-2);
          }

          if (HMPI_Is_host())
          {
             printf("Updated processor performances are :\n");

             for (i = 0; i < num_of_processors; i++)
             {
                 printf("%0.2f ", rperf[i]);
             }

             printf("\n");
          }

          free(rperf);
       }

       if (HMPI_Is_member(&gid))
       {
          HMPI_Group_free(
             &gid
          );
       }

       free(a);
       free(b);
       free(c);

       HMPI_Finalize(0);      
   }

   int Perf_func 
   (
       int x, /* --r-- */
       int y, /* --n-- */
       int z  /* --t-- */
   )
   {
      /*
       * Multiplication of r*n and n*t matrices.
       */
      int i,j,k;
      for (i = 0; i < x; i++)
      {
          for (j = 0; j < z; j++)
          {
              for (k = 0; k < y; k++)
              {
                  c[i*z + j] += a[i*x + k] * b[k*z + j];
              }
          }
      }

      return 0;
   }

   void Benchmark_function 
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   )
   {
      int* params = (int*)input_p;

      int result = Perf_func(
                       params[0], 
                       params[1], 
                       params[2]
      );

      *(int*)output_p = result;

      return;
   }

