
   #include <math.h>
   #include <hmpi.h>
   #include "simpleGrid.c"

   #define  n               1000
   #define  HOSTNAMELENGTH  64

   int Perf_func
   (
       int x
   );

   int
   Input
   (
      double *A
   )
   {
     int i;
     for (i = 0; i < n*n; i++)
     {
         A[i] = n*n*10 - i*10;
     }
     return 0;
   }

   void Benchmark_function
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   );

   static double *a;

   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Group gid;
       int net_params[2];
       int param_count;

       HMPI_Init(
           &argc, 
           &argv
       );

       a = (double*)malloc(
                    sizeof(double)
                    *
                    (n*n)
       );

       Input(
         a
       );

       if (HMPI_Is_host())
       {
          printf("Executing benchmark code of cholesky factorization\n");
       }

       if  (HMPI_Is_member(HMPI_COMM_WORLD_GROUP))
       {
           int rc;
           int output_p;
           int input_p = n;

           rc = HMPI_Recon(
                    &Benchmark_function,
                    &input_p,
                    1,
                    &output_p
           );
 
           if  (rc != HMPI_OK)
           {
               printf("Panic: HMPI_Recon failed \n");
               HMPI_Abort(-1);
           } 
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          int gsize, p, q;

          param_count = 2;

          gsize = HMPI_Group_size(
                      HMPI_COMM_WORLD_GROUP
          );

          p = q = sqrt(gsize);

          if ((p == 0)
              && (q == 0
             )
          )
          {
             p = q = 1;
          }

          net_params[0] = p;
          net_params[1] = q;

          printf("Total number of processes available for computation is = %d\n", gsize);
          printf("Creating a grid (%d, %d) of processes\n", p, q);

          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               NULL,
               0
          );
       }

       {
          int dummy, rc, i;
          int num_of_processors = HMPI_Get_number_of_processors();
          double *rperf = (double*)malloc(
                                   sizeof(double)
                                   *
                                   num_of_processors
          );

          rc = HMPI_Get_processors_info(
                   rperf
          );

          if (rc != HMPI_OK)
          {
             printf(
                "MAIN:Problems getting the performances"
                "...Exiting...\n"
             );

             HMPI_Abort(-2);
          }

          if (HMPI_Is_host())
          {
             printf("Updated processor performances are :\n");

             for (i = 0; i < num_of_processors; i++)
             {
                 printf("%0.2f ", rperf[i]);
             }

             printf("\n");
          }

          free(rperf);
       }

       if (HMPI_Is_member(&gid))
       {
          HMPI_Group_free(
             &gid
          );
       }

       free(a);

       HMPI_Finalize(0);      
   }

   int Perf_func 
   (
       int x
   )
   {
      /*
       * Cholesky factorization of n*n matrix
       */
      int i,j,k;

      for (k = 0; k < x; k++)
      {
          double lkk;
          for (i = k, lkk = sqrt(a[k*x+k]); i < x; i++)
          {
              a[i*x+k] /= lkk;
          }

          for (j = k+1; j < x; j++)
          {
              for (i = j; i < x; i++)
              {
                  a[i*x+j] -= a[i*x+k]*a[j*x+k];
              }
          }
      }

      return 0;
   }

   void Benchmark_function 
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   )
   {
      int* params = (int*)input_p;

      int result = Perf_func(
                       params[0]
      );

      *(int*)output_p = result;

      return;
   }

