
   #include <hmpi.h>
   #include "simpleGrid.c"

   #define  HOSTNAMELENGTH  64
  
   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Group gid;
       int net_params[2];
       int param_count;
       int gsize;
       double *perf;

       HMPI_Init(
           &argc, 
           &argv
       );

       gsize = HMPI_Group_size(HMPI_COMM_WORLD_GROUP);
       perf = (double*)malloc(
                       sizeof(double)
                       *
                       gsize
       );

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          int gsize, p, q;

          param_count = 2;

          gsize = HMPI_Group_size(
                      HMPI_COMM_WORLD_GROUP
          );

          p = q = sqrt(gsize);

          if ((p == 0)
              && (q == 0
             )
          )
          {
             p = q = 1;
          }

          net_params[0] = p;
          net_params[1] = q;

          printf("Total number of processes available for computation is = %d\n", gsize);
          printf("Creating a grid (%d, %d) of processes\n", p, q);

          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_member(&gid))
       {
          int i, rc, me;;
          char hostname[HOSTNAMELENGTH];
          int power = HMPI_Group_size(&gid);
          int** my_coordinates = (int**)malloc(
                                   sizeof(int*)
          );
          int num_of_coordinates;
          
          double *rperf = (double*)malloc(
                                   sizeof(double)
			           *
			           power
          );

          double myperf;

          HMPI_Group_coordof(
              &gid,
              &num_of_coordinates,
              my_coordinates
          );

          rc = HMPI_Group_performances(
                   &gid,
                   rperf
          );
 
          if (rc != HMPI_OK)
          {
             printf("Problems getting the performances\n");
          }

          me = HMPI_Group_rank(&gid);
          myperf = rperf[me];

          gethostname(
             hostname,
             HOSTNAMELENGTH
          );

          {
             printf(
                 "My Group rank is %d, My Global rank is %d, My coordinates are (%d, %d) "
                 "My hostname is %s, My performance is %0.1f\n",
                 HMPI_Group_rank(&gid),
                 HMPI_Group_rank(HMPI_COMM_WORLD_GROUP),
                 (*my_coordinates)[0], 
                 (*my_coordinates)[1],
                 hostname,
                 myperf
             );
          }

          free(rperf);
          free(my_coordinates[0]);
          free(my_coordinates);
       }

       if (HMPI_Is_member(&gid))
       {
          HMPI_Group_free(
             &gid
          );
       }

       HMPI_Finalize(0);      
   }
