
   #include <hmpi.h>

   #include "usermetric.c"
   #include "mxm_data.c"
   #include "cholesky_data.c"

   int main(int argc, char **argv)
   {
      int i, j, rc;
      int *np;
      int *w;
      int n, pn;
      int *mlimits, *psizes;
      double *speeds;
      double metric;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing ordered sets with weighted elements     \n");
      printf("  Speeds are functions of problem size               \n");
      printf("  Processors have bounds on the number of elements   \n");
      printf("  that they can store                                \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, processor has bounds\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=2.0,...             \n",
        p, 
        (p*(p+1))/2
      );
      printf("========================================\n");
      {
         n = (p*(p+1))/2;
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = i+1;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
                printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d                     \n"
        " Speeds are constant functions of problem size              \n"
        " p1 speed = 27.0, p2 speed = 26.0, ..., pp speed = 1 \n"
        " Weight 1=2700, weight 2= 2600,...\n",
        p,
        (p*(p+1))/2
      );
      printf("========================================\n");
      {
         n = (p*(p+1))/2;
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = i+1;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d                     \n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n",
        p, 
        (p*(p+1))/2
      );
      printf("========================================\n");
      {
         n = (p*(p+1))/2;
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = 1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = i+1;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d                     \n"
        " Speeds are constant functions of problem size              \n"
        " processor speeds are:                                      \n"
        " 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13                  \n"
        " 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1              \n",
        p, 
        p
      );
      printf("========================================\n");
      {
         n = p;
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         for (i = (p/2); i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            w[i] = 100*(i+1.0);
         }

         for (i = (p/2); i < p; i++)
         {
            w[i] = 100*(p-i);
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = i+1;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are constant numbers                                \n",
        p, 
        10000
      );
      printf("========================================\n");
      {
         n = 10000;
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = 1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = (n/p);
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        10000
      );
      printf("========================================\n");
      {
         n = 10000;
         pn = NSTEPS_CHOLESKY;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         cholesky_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = (n/p);
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        10000
      );
      printf("========================================\n");
      {
         n = 10000;
         pn = NSTEPS_MXM;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         mxm_fill_input_parameters(
             p,
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = (n/p);
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_MXM;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         mxm_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = (n/p);
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_CHOLESKY;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         cholesky_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = (n/p);
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        "user defined metric function is used   \n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_MXM;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    n
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         mxm_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/3); i++)
         {
            mlimits[i] = (n/p) - (n%p);
         }

         for (i = (p/3); i < ((2*p)/3); i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         for (i = ((2*p)/3); i < p; i++)
         {
            mlimits[i] = (n/p) + 2*(n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_CHOLESKY;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         cholesky_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/3); i++)
         {
            mlimits[i] = (n/p) - (n%p);
         }

         for (i = (p/3); i < ((2*p)/3); i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         for (i = ((2*p)/3); i < p; i++)
         {
            mlimits[i] = (n/p) + 2*(n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        "user defined metric function is used   \n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_MXM;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         mxm_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/3); i++)
         {
            mlimits[i] = (n/p) - (n%p);
         }

         for (i = (p/3); i < ((2*p)/3); i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         for (i = ((2*p)/3); i < p; i++)
         {
            mlimits[i] = (n/p) + 2*(n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  USER_SPECIFIED,
                  &User_defined_metric_function,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        "User specified metric function is used \n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000
      );
      printf("========================================\n");
      {
         n = 100000;
         pn = NSTEPS_CHOLESKY;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         cholesky_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/3); i++)
         {
            w[i] = 100;
         }

         for (i = (n/3); i < ((2*n)/3); i++)
         {
            w[i] = 50;
         }

         for (i = ((2*n)/3); i < n; i++)
         {
            w[i] = 75;
         }

         for (i = 0; i < (p/3); i++)
         {
            mlimits[i] = (n/p) - (n%p);
         }

         for (i = (p/3); i < ((2*p)/3); i++)
         {
            mlimits[i] = (n/p) + (n%p);
         }

         for (i = ((2*p)/3); i < p; i++)
         {
            mlimits[i] = (n/p) + 2*(n%p);
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  USER_SPECIFIED,
                  &User_defined_metric_function,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(np);
         free(w);
         free(speeds);
         free(psizes);
      }
      
      free(mlimits);

      return 0;
   }

