
   #include <hmpi.h>
   #include "mxm_data.c"
   #include "cholesky_data.c"

   int main(int argc, char **argv)
   {
      int i, j, rc;
      int *np;
      int *w;
      int n, pn;
      int *mlimits, *psizes;
      double *speeds;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing nonordered sets with nonweighted elements  \n");
      printf("  Speeds are functions of problem size               \n");
      printf("  processors have upper bounds                       \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n"
        " processor14 speed=14.0, processor13 speed=13.0,...         \n"
        " all processors have an upper bound of 100                  \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 100;
         }

         for (i = (p/2); i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 100;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test PASSED\n");
         }
         else
         {
            printf("Test FAILED\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n"
        " processor14 speed=14.0, processor13 speed=13.0,...         \n"
        " All processors have an upper bound of 1400                 \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 1400;
         }

         for (i = (p/2); i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 1400;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=2.0,...             \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 100 + i*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=27.0, processor2 speed=26.0, ...          \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = (p-i)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = 1.0;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 1400;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n"
        " processor14 speed=14.0, processor13 speed=13.0,...         \n",
        p, 
        1400*(p/2) + 2000*(p - (p/2))
      );
      printf("========================================\n");
      {
         n = 1400*(p/2) + 2000*(p - (p/2));
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 1400;
         }

         for (i = (p/2); i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }

            mlimits[i] = 3000;
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      for (i = 10; i < 21; i++)
      {
          printf("========================================\n");
          printf(
            "Number of processes=%d, Set cardinal=%d\n"
            " speeds are non-constant functions of problem size          \n",
            p, 
            i*100000000
          );
          printf("========================================\n");

          {
             n = i*100000000;
             pn = NSTEPS_CHOLESKY;
             np = (int*)malloc(
                        sizeof(int)
                        *
                        p
             );

             if (np == NULL)
             {
                printf("No memory to allocate np\n");
                return -1;
             }

             speeds = (double*)malloc(
                        sizeof(double)
                        *
                        p
                        *
                        pn
             );

             if (speeds == NULL)
             {
                printf("No memory to allocate speeds\n");
                return -1;
             }

             psizes = (int*)malloc(
                        sizeof(int)
                        *
                        p
                        *
                        pn
             );

             if (psizes == NULL)
             {
                printf("No memory to allocate psizes\n");
                return -1;
             }

             cholesky_fill_input_parameters(
                p,            
                pn,
                speeds,
                psizes
             );

             mlimits[0] = cholesky_bcsserver;
             mlimits[1] = cholesky_bcsserver;
             mlimits[2] = cholesky_bcsserver;
             mlimits[3] = cholesky_bcsserver;
             mlimits[4] = cholesky_bpg1cluster01;
             mlimits[5] = cholesky_bpg1cluster01;
             mlimits[6] = cholesky_bpg1cluster02;
             mlimits[7] = cholesky_bpg1cluster02;
             mlimits[8] = cholesky_bpg1cluster03;
             mlimits[9] = cholesky_bpg1cluster03;
             mlimits[10] = cholesky_bpg1cluster04;
             mlimits[11] = cholesky_bpg1cluster04;
             mlimits[12] = cholesky_bcsultra01;
             mlimits[13] = cholesky_bcsultra02;
             mlimits[14] = cholesky_bcsultra03;
             mlimits[15] = cholesky_bcsultra04;
             mlimits[16] = cholesky_bcsultra05;
             mlimits[17] = cholesky_bcsultra06;
             mlimits[18] = cholesky_bcsultra07;
             mlimits[19] = cholesky_bcsultra08;
             mlimits[20] = cholesky_bcsultra09;
             mlimits[21] = cholesky_bcsultra10;
             mlimits[22] = cholesky_bzaphod;   
             mlimits[23] = cholesky_bcssparc01;
             mlimits[24] = cholesky_bafflatus;
             mlimits[25] = cholesky_bshelbourne2;
             mlimits[26] = cholesky_bmaxft;

             rc = HMPI_Partition_set(
                      p,
                      pn,
                      speeds,
                      psizes,
                      mlimits,
                      n,
                      NULL,
                      0,
                      -1,
                      -1,
                      NULL,
                      NULL,
                      np
             );

             if (rc != HMPI_OK)
             {
                printf("Test FAILED\n");
             }
             else
             {
                printf("Test PASSED\n");
                printf("The partitioning is \n");
                for (j = 0; j < p; j++)
                {
                   printf("%d, ", np[j]);
                }
                printf("\n");
             }

             free(np);
             free(speeds);
             free(psizes);
         }
      }

      for (i = 10; i < 21; i++)
      {
          printf("========================================\n");
          printf(
            "Number of processes=%d, Set cardinal=%d\n"
            " speeds are non-constant functions of problem size          \n",
            p, 
            i*100000000
          );
          printf("========================================\n");

          {
             n = i*100000000;
             pn = NSTEPS_MXM;     
             np = (int*)malloc(
                        sizeof(int)
                        *
                        p
             );

             if (np == NULL)
             {
                printf("No memory to allocate np\n");
                return -1;
             }

             speeds = (double*)malloc(
                        sizeof(double)
                        *
                        p
                        *
                        pn
             );

             if (speeds == NULL)
             {
                printf("No memory to allocate speeds\n");
                return -1;
             }

             psizes = (int*)malloc(
                        sizeof(int)
                        *
                        p
                        *
                        pn
             );

             if (psizes == NULL)
             {
                printf("No memory to allocate psizes\n");
                return -1;
             }

             mxm_fill_input_parameters(
                p,            
                pn,
                speeds,
                psizes
             );

             mlimits[0] = mxm_bcsserver;
             mlimits[1] = mxm_bcsserver;
             mlimits[2] = mxm_bcsserver;
             mlimits[3] = mxm_bcsserver;
             mlimits[4] = mxm_bpg1cluster01;
             mlimits[5] = mxm_bpg1cluster01;
             mlimits[6] = mxm_bpg1cluster02;
             mlimits[7] = mxm_bpg1cluster02;
             mlimits[8] = mxm_bpg1cluster03;
             mlimits[9] = mxm_bpg1cluster03;
             mlimits[10] = mxm_bpg1cluster04;
             mlimits[11] = mxm_bpg1cluster04;
             mlimits[12] = mxm_bcsultra01;
             mlimits[13] = mxm_bcsultra02;
             mlimits[14] = mxm_bcsultra03;
             mlimits[15] = mxm_bcsultra04;
             mlimits[16] = mxm_bcsultra05;
             mlimits[17] = mxm_bcsultra06;
             mlimits[18] = mxm_bcsultra07;
             mlimits[19] = mxm_bcsultra08;
             mlimits[20] = mxm_bcsultra09;
             mlimits[21] = mxm_bcsultra10;
             mlimits[22] = mxm_bzaphod;
             mlimits[23] = mxm_bcssparc01;
             mlimits[24] = mxm_bafflatus;
             mlimits[25] = mxm_bshelbourne2;
             mlimits[26] = mxm_bmaxft;

             rc = HMPI_Partition_set(
                      p,
                      pn,
                      speeds,
                      psizes,
                      mlimits,
                      n,
                      NULL,
                      0,
                      -1,
                      -1,
                      NULL,
                      NULL,
                      np
             );

             if (rc != HMPI_OK)
             {
                if ((n == 1900000000)
                    || (n = 2000000000
                   )
                )
                {
                   printf("Test PASSED\n");
                }
                else
                {
                   printf("Test FAILED\n");
                }
             }
             else
             {
                printf("Test PASSED\n");
                printf("The partitioning is \n");
                for (j = 0; j < p; j++)
                {
                   printf("%d, ", np[j]);
                }
                printf("\n");
             }

             free(np);
             free(speeds);
             free(psizes);
         }
      }

      free(mlimits);

      return 0;
   }

