
    #include "mxm_i.h"

    int GetStripes
    (
        int p,
        int n,
        int *np 
    )
    {
        int i, j, sum = 0;
        double *npp;

        npp = (double*)malloc(
                       sizeof(double)
                       *
                       p
        );

        if (npp == NULL)
        {
           printf("Can't allocate npp in Function Get_stripes\n");
           return -1;
        }
 
        for (i = 0; i < p; i++)
        {
            npp[i] = (double)(np[i])
                     /
                     (double)n;
        }

        for (i = 0; i < p; i++)
        {
            sum += floor(npp[i]);
        }

        if (sum == n)
        {
           for (i = 0; i < p; i++)
           {
               np[i] = floor(npp[i]);
           }

           return HMPI_OK;           
        }

        for (i = 0; i < p; i++)
        {
            npp[i] = ceil(npp[i]);

            sum = 0;

            for (j = 0; j < p; j++)
            {
                sum += floor(npp[j]);
            }

            if (sum == n)
            {
               break;
            }
        }

        for (i = 0; i < p; i++)
        {
            np[i] = floor(npp[i]);
        }

        free(npp);

        return HMPI_OK;
    }

    int InitializeMatrices
    (
        int n,
        double *a,
        double *b,
        double *c 
    )
    {
        int i;

        for (i = 0; i < n; i++)
        {
            a[i] = MXM_CONSTANT_NUMBER;
            b[i] = MXM_CONSTANT_NUMBER;            
            c[i] = 0.0;
        }
    
        return HMPI_OK; 
    }

    int GetPivotProcessor
    (
        int prow,
        int n,
        int p,
        int *np
    )
    {
        int i, j;
        int *cumnp = (int*)malloc(
                           sizeof(int)
                           *
                           (p+1)
        );

        if (cumnp == NULL)
        {
           printf("Can't allocate cumnp in Function GetPivotProcessor\n");
           return -1;
        }

        for (i = 0; i <= p; i++)
        {
            cumnp[i] = 0;
            for (j = 0; j < i; j++)
            {
                cumnp[i] += np[j];
            }
        }
        
        for (i = 0; i < p; i++)
        {
           if ((prow >= cumnp[i])
               && (prow < cumnp[i+1]
              )
           )
           {
              free(cumnp);
              return i;
           }
        }

        free(cumnp);

        return -1; 
    }
