
    #include <math.h>
    #include "mxm_i.h"

    int InitializeMatrices
    (
        int n,
        double *aa,
        double *bb,
        double *cc 
    )
    {
        int i;

        for (i = 0; i < n; i++)
        {
            aa[i] = MXM_CONSTANT_NUMBER;
            bb[i] = MXM_CONSTANT_NUMBER;            
            cc[i] = 0.0;
        }

        return HMPI_OK; 
    }

    /*
     * This one should probably be moved to HDPI library.
     */
    int GetPivotProcessor
    (
        int prow,
        int n,
        int p,
        int *np
    )
    {
        int i, j;
        int *cumnp = (int*)malloc(
                           sizeof(int)
                           *
                           (p+1)
        );

        if (cumnp == NULL)
        {
           printf("Can't allocate cumnp in Function GetPivotProcessor\n");
           return -1;
        }

        for (i = 0; i <= p; i++)
        {
            cumnp[i] = 0;
            for (j = 0; j < i; j++)
            {
                cumnp[i] += np[j];
            }
        }
        
        for (i = 0; i < p; i++)
        {
           if ((prow >= cumnp[i])
               && (prow < cumnp[i+1]
              )
           )
           {
              free(cumnp);
              return i;
           }
        }

        free(cumnp);

        return -1; 
    }
