
  #include <stdio.h>
  #include <math.h>
  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int rc, rank, size;
     int color = 0;

     double time_i;
     double time_f;
     double elapsed_time;

     {
        rc = MPI_Init(&argc, &argv);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems initializing MPI "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -1);
        }
     }

     {
        rc = MPI_Comm_rank(MPI_COMM_WORLD, &rank);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting rank "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -2);
        }
     }

     /*
      * Record the initial time.
      */
     if (rank == 0)
     {
        time_i = MPI_Wtime();
     }

     {
        rc = MPI_Comm_size(MPI_COMM_WORLD, &size);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting size of MPI_COMM_WORLD "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -3);
        }
     }

     if ((rank == (size - 1))
         || (rank >= (p*q))
     )
     {
        color = MPI_UNDEFINED;
     }

     rc = MPI_Comm_split(
             MPI_COMM_WORLD,
             color,
             rank,
             &algo_comm
     );

     if (rc != MPI_SUCCESS)
     {
        printf("Problems with MPI_Comm_split for MPI_COMM_WORLD\n");

        MPI_Abort(MPI_COMM_WORLD, -4);
     }

     if ((rank != (size - 1))
         && (rank < (p*q))
     )
     {
        rc = MPI_Comm_rank(algo_comm, &algo_comm_rank);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting algo comm rank "
              "...Exiting...\n"
           );

           MPI_Abort(algo_comm, -5);
        }

        rc = Execute_algorithm(&algo_comm);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -6);
        }

        rc = MPI_Comm_free(
                &algo_comm
        );

        if (rc != MPI_SUCCESS)
        {
           return rc;
        }
     }

     /*
      * Record the final time and record the elapsed time.
      */
     if (rank == 0)
     {
        time_f = MPI_Wtime();

        elapsed_time = (time_f
                        - time_i
                        - barrier_time
        );

        printf(
           "N=%d, p=%d, q=%d, r=%d, grow=%d, gcol=%d, time(sec)=%0.6f\n",
           N,
           p,
           q,
           r,
           generalised_block_size_row,
           generalised_block_size_col,
           elapsed_time
        );
     }

     MPI_Finalize();
  }
