
    #ifndef _MXM_HH
    #define _MXM_HH

    static int HMPI_Is_recon_required = 1;

    /*
     * Matrices for recon
     */
    static double *a, *b, *c;

    /*
     * Matrices used for multiplication.
     */
    static double *A, *B, *C;

    int VERBOSE = 0;

    double MXM_CONSTANT_NUMBER = 2.00;

    int InitializeMatrices
    (
        int n,
        double *aa,
        double *bb,
        double *cc 
    );

    int GetPivotProcessor
    (
        int prow,
        int n,
        int p,
        int *np
    );

    int Perf_func
    (
        int x,
        int y,
        int z
    );

    int
    Input_recon
    (
       double *aa,
       double *bb,
       double *cc
    );

    void Benchmark_function
    (
       const void* input_p,
       int num_of_p,
       void* output_p
    );

    int
    Do_recon();

    int
    MyPartition
    (
       int i,
       int p,
       const int *speeds,
       int n
    );

    int GetPartitions
    (
       int p,
       const int *speeds,
       int n,
       int *d
    );
    #endif
