
  #include <stdio.h>
  #include <math.h>
  #include <sys/time.h>

  #include <hmpi.h>
  #include "ParallelAxB.c"
  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, j, k, rc;

     struct timeval start, end;

     gettimeofday(&start, NULL);

     {
        rc = HMPI_Init(&argc, &argv);

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems initializing HMPI "
              "...Exiting...\n"
           );

           HMPI_Finalize(-1);
        }
     }

     if (HMPI_Is_recon_required)
     {
        rc = Do_recon();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems reconning the network"
              "...Exiting...\n"
           );

           HMPI_Finalize(-2);
        }
     }

     {
        n = N/r;
        rc = Execute_algorithm();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           HMPI_Finalize(-3);
        }
     }

     gettimeofday(&end, NULL);

     /*
      * Record the final time and record the elapsed time.
      */
     if (HMPI_Is_host())
     {
        double tstart = start.tv_sec + (start.tv_usec/pow(10, 6));
        double tend = end.tv_sec + (end.tv_usec/pow(10, 6));

        double elapsed_time = (tend
                               - tstart
                               - barrier_time
        );

        printf(
           "N=%d, p=%d, q=%d, r=%d, grow=%d, gcol=%d, time(sec)=%0.6f\n",
           N,
           p,
           q,
           r,
           Optimal_generalised_block_size_row,
           Optimal_generalised_block_size_col,
           elapsed_time
        );
     }

     HMPI_Finalize(0);

     return 0;
  }
