
  #ifndef _LOAD_BALANCE_HH
  #define _LOAD_BALANCE_HH

  #include <math.h>

  /*-----------------------------------------------------*/

  int getgcd
  (
    int m, 
    int n
  );

  /*-----------------------------------------------------*/

  int getlcm
  (
    int m, 
    int n
  );

  /*-----------------------------------------------------*/

  /*
   * Get gcd of a set of integers
   */
  int multiple_gcd
  (
    const int* ip, 
    int n
  );

  /*-----------------------------------------------------*/

  /*
   * Get lcm of a set of integers
   */
  int multiple_lcm
  (
    const int* ip, 
    int n
  );

  /*-----------------------------------------------------*/

  /*
   * Normalise the performances to simple integers.
   */
  int Normalise
  (
    double *rperf,
    int n,
    int *operf
  );

  /*-----------------------------------------------------*/

  /*
   * Calculate the row and column distributions 
   * of each processor. Determine the processor grid.
   * Each processor will have the processor grid.
   */
  int
  Determine_distribution_parameters
  (
     const int *perf, int p, int l, int *w, int *h, int *trow, int* tcolumn
  );

  /*-----------------------------------------------------*/

  /*
   * Distribute the load using HEHE algorithm.
   * (Heterogeneous data distribution over heterogeneous
   *  processors)
   */
  int Distribute_load(int nump, double* speeds, int p, int l, int *w, int *h, int *trow, int* tcolumn);

  /*-----------------------------------------------------*/

  #endif /* _LOAD_BALANCE_HH */
