
  #include <math.h>
  #include <stdio.h>
  #include <sys/time.h>

  #include <hmpi.h>
  #include "ParallelAxB.c"
  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, j, k, rc;

     struct timeval time_start, time_end;

     /*
      * Record the initial time.
      */
     if (HMPI_Is_host())
     {
        gettimeofday(&time_start, NULL);
     }

     {
        rc = HMPI_Init(
                 &argc,
                 &argv
        );

        if (rc != HMPI_OK)
        {
           printf(
               "Problems initializing HMPI runtime "
               "...Exiting...\n"
           );

           HMPI_Finalize(-1);
        }
     }

     if (HMPI_Is_recon_required)
     {
        rc = Do_recon();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems reconning the network"
              "...Exiting...\n"
           );

           HMPI_Finalize(-2);
        }
     }

     {
        n = N;
        rc = Execute_algorithm();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           HMPI_Finalize(-3);
        }
     }

     /*
      * Record the final time and record the elapsed time.
      */
     if (HMPI_Is_host())
     {
        double tstart, tend, elapsed_time;

        gettimeofday(&time_end, NULL);

        tstart = time_start.tv_sec + (time_start.tv_usec/pow(10, 6));
        tend = time_end.tv_sec + (time_end.tv_usec/pow(10, 6));

        elapsed_time = (tend
                        - tstart
                        - barrier_time
        );

        printf(
           "N=%d, p=%d, generalized block size=%d, time(sec)=%0.3f\n",
           N,
           p,
           Optimal_generalised_block_size,
           elapsed_time
        );
     }

     HMPI_Finalize(0);
   }
