
  #include <math.h>
  #include <stdio.h>

  #include <hmpi.h>
  #include "simple.c"
  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, j, k, rc;

     double time_i;
     double time_f;
     double elapsed_time;

     {
        rc = HMPI_Init(
                 &argc,
                 &argv
        );

        if (rc != HMPI_OK)
        {
           printf(
               "Problems initializing HMPI runtime "
               "...Exiting...\n"
           );

           HMPI_Finalize(-1);
        }
     }

     if (HMPI_Is_recon_required)
     {
        rc = Do_recon();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems reconning the network"
              "...Exiting...\n"
           );

           HMPI_Finalize(-2);
        }
     }

     /*
      * Record the initial time.
      */
     if (HMPI_Is_host())
     {
        time_i = MPI_Wtime();
     }

     {
        rc = Execute_algorithm();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           HMPI_Finalize(-3);
        }
     }

     /*
      * Record the final time and record the elapsed time.
      */
     if (HMPI_Is_host())
     {
        time_f = MPI_Wtime();

        elapsed_time = (time_f
                        - time_i
                        - barrier_time
        );

        printf(
           "N=%d, p=%d, block size=%d, time(sec)=%0.3f\n",
           N,
           p,
           Generalised_block_size,
           elapsed_time
        );
     }

     HMPI_Finalize(0);
  }
