
   #include "mxm_i.h"

   /*-----------------------------------------------------*/

   int
   Distribute_load
   (
      int p,
      const double *perf,
      int *block_allocations
   )
   {
      int i, x, y, temp;

      int rc = HMPI_Partition_set(
                 p,
                 1,
                 perf,
                 NULL,
                 NULL,
                 Generalised_block_size*Generalised_block_size,
                 NULL,
                 0,
                 0,
                 -1,
                 NULL,
                 NULL,
                 block_allocations
      );

      if (rc != HMPI_OK)
      {
         printf("Problems partitioning\n");
         MPI_Abort(MPI_COMM_WORLD, -1);
      }

      if ((VERBOSE > 0)
          && HMPI_Is_host())
      {
         printf("HMPI---LOAD BALANCE-->: Block allocations are: \n");
              
         for (i = 0; i < p; i++)
         {
             printf("%d ", block_allocations[i]);
         }   
          
         printf("\n");
      }

      Generalised_block = (int*)malloc(
                    sizeof(int)
                    *
                    (Generalised_block_size)*(Generalised_block_size)
      );

      for (x = 0, temp = 0; x < p; x++)
      {
          for (i = 0; i < block_allocations[x]; i++)
          {
              Generalised_block[temp + i] = x;
          }

          temp += i;
      }

      if (VERBOSE > 1)
      {
         for (x = 0; x < Generalised_block_size; x++)
         {
             for (y = 0; y < Generalised_block_size; y++)
             {
                 printf(
                   "Grid element(%d,%d): %d\n",
                   x,
                   y,
                   Generalised_block[(x*Generalised_block_size) + y]
                 );
             }
         }
      }

      return HMPI_OK;
   }

   /*-----------------------------------------------------*/

