
  #include <math.h>
  #include "qinv.c"

  int
  LowerCholesky
  (
    int num,
    double *l11
  )
  {
      int i, j, k;

      for (i = 0; i < num; i++)
      {
          double lkk = sqrt(l11[i*num + i]);

	  for (j = i; j < num; j++)
          {
              l11[j*num + i] = (double)l11[j*num + i]
		               /
		               (double)lkk;
          }

	  for (j = i+1; j < num; j++)
          {
              for (k = j; k < num; k++)
              {
                  l11[k*num + j] -= l11[k*num + i]
			            *
				    l11[j*num + i]; 
              }
          }
      }

      for (i = 0; i < num; i++)
      {
          for (j = i+1; j < num; j++)
          {
              l11[i*num + j] = 0.0;
          }
      }

      return 0;
  }

  #define    r   4

  int main()
  { 
      int i, j, rc;
      double a[r*r], transpose_a[r*r], inverse_a[r][r];
     
      for (i = 0; i < r*r; i++)
      {
          a[i] = r*r*r*10 - i*10;
      }

      LowerCholesky(
           r,
	   a
      );

      printf("Cholesky factorization yields:\n");

      for (i = 0; i < r; i++)
      {
          for (j = 0; j < r; j++)
          {
              printf("%0.6f ", a[i*r+j]);
          }

	  printf("\n");
      }

      printf("\n");

      for (i = 0; i < r; i++)
      {
          for (j = 0; j < r; j++)
          {
              transpose_a[i*r+j] = a[j*r + i];
          }
      }

      {
          double given[r][r];
          double working[r][r];

          for (i = 0; i < r; i++)
          {
              for (j = 0; j < r; j++)
              {
                  given[i][j] = transpose_a[i*r+j];
              }
          }     

          rc = invns(
                r, 
	        inverse_a,
	        given,
	        working
         );

         if (rc != 0)
         {
            printf("Inverse failed\n");
	    return 1;
         }
      }

      printf("Inverse of tranpose of Lower Cholesky factors:\n");

      for (i = 0; i < r; i++)
      {
          for (j = 0; j < r; j++)
          {
              printf("%0.6f ", inverse_a[i*r+j]);
          }

	  printf("\n");
      }

      printf("\n");

      return 0;
  }
