

/* mat.h - Routines to handle matrices.
 */

#ifndef MAT 
#define MAT 1

/* Version of September 6th, 1999 */

#include "errors.h"
 /* We return package standard error codes. */
 /* All of the routines can return:
  * ERRnil - You can't pass nil pointers to the routines.
  * ERRsize - Matrices have to have positive numbers of rows and columns.
  *
  * matscl can return
  * ERRmeaning - The operation is meaningless (scaling by zero for example)
  */

/* What does a matrix look like? */
typedef double matrix[][];

/* --------------   Routines    ---------------------------- */

/* Make a matrix be the zero matrix */
extern error matzero (int rows, int cols, matrix result);
/* Make a matrix be the identity */
extern error matidn (int size, matrix result);

/* Copy */
    /* regular */
extern error matcpy  (int rows, int cols, matrix result, matrix source);
    /* transpose */
extern error matcpyt (int rows, int cols,  matrix result, matrix source);
    /* rows and columns refer to result.*/

/* Scale a matrix */
extern
 error matscl (int rows, int cols,  matrix result, matrix given, double scalar);
/* Scalar must be non-zero */

/* Add */
error matadd (int rows, int cols, matrix result, matrix A, matrix B);
error matsub (int rows, int cols, matrix result, matrix A, matrix B);

/* Multiply */

/* Multiply  matrices.   result = matrix a multiplied by matrix b;  */
extern error matmul (int rrows, int rcols, matrix result,
                     int isize, matrix A, matrix B);
                  /* result is rrows x rcols */
                  /* A      is rrows x isize */
                  /* B      is isize x rcols */
/* result MUST be a matrix distinct from either A or B. */


/* Multiply a matrix by the transpose of another matrix. */
extern error matmult (int rrows, int rcols, matrix result,
                      int isize, matrix A, matrix B);
                      /* result is rrows x rcols        */
                      /* A      is rrows x isize        */
                      /* B      is rcols x isize < ===  */
/* result MUST be a matrix distinct from either A or B. */

#endif

