

/* errors.c */

#include <stdio.h>

#include "errors.h"
/* Let us get the error codes */

/* Revision history
 * Version 0.6, August 24th, 1999
 *   Added the abort routine.
 * Version 0.5, August 12th, 1999
 *   Added error history.
 * Version 0.4, July 16th, 1999
 *   Added "false" error code.
 *   Added "notfound" error code.
 * Version 0.3, June 29th, 1999
 *   Added error codes.
 * Version 0.2, June 25th, 1999
 *   made routine name agree with .h file. *** ARGH ***
 * Version 0.1, June 5th, 1999
 *   Initial creation.
 */

/* visible error history */
error lasterror   = NoError;
char *lastfile    = 0;
int   lastline    = 0;
char *lastmessage = 0;

char *errormessages[] = {
  "(0)NoError: Everything OK",
  "(1)ERRfalse: Condition was false",
  "(2)ERRnotfound: Not found",
  "(3)ERRnil: pointers must be non nil",
  "(4)ERRsame: arrays must be distinct",
  "(5)ERRsize: arrays must have positive sizes",
  "(6)ERRrange: indices must be within array",
  "(7)ERRnumeric: result is not numericly significant",
  "(8)ERRconform: arguments don't conform correctly",
  "(9)ERRnomem: out of memory",
  "(10)ERRnodisk: out of disk",
  "(11)ERRsysIO: Some system I/O error",
  "(12)ERRnotimplemented: Execution of unimplemented code",
  "(13)ERRmeaning: Meaningless operation",
  "(14)ERRvalue: Value out of range",
  "(15)ERRuninitialized: Use of uninitialized value or package",
  "(16)ERRreinitialized: Attempt to initialize package twice",
  "(17)ERRbaddata: Data given was bad.",
  "(18)ERRempty: Empty list or omitted list",
  "(19)ERRnesting: Calls badly nested",
  "(20)ERRendoffile: No more characters left",
  "(21)ERRoverflow: No more data space available",
  "(22)ERRcorrupt: Internal error, possibly corrupt data????",
  "(23)ERRendofline: End of line seen while expecting more?"
};

/* Canned routine to dump error messages. */
error printerror (error whichone) {

   if (whichone < 0 || whichone > maxERR) {
      printf ("Unknown error code: (%d) ???\n", whichone);
      return ERRnotfound;
   }

   printf ("%s\n",errormessages[whichone]);
   return NoError;
}

/* internal dump routine */
static error mydumperror
      (error which, char *kind, char *text, char *file, int line)
{
  if (!kind)         printf ("***[]\a");
  else if (!*kind)   printf ("***\"\"\a");
  else               printf ("%s", kind);
  if (text && *text) printf (" %s", text);
                     printf ("\n");
  if (file && *file) printf ("In file \"%s\", ", file);
  if (line)          printf ("at line %d", line);
  return             printerror (which);
}

/* Output text of last error, if any.  (No print if NoError)  */
extern error dumperror() {
  if (lasterror) {
     return mydumperror (lasterror, "ERROR:", lastmessage, lastfile, lastline);
  } else return ERRnotfound;
}

/* Note where an error occurred */
error seterror (error Which, char *whichfile, int line, char *text) {
  lasterror = Which;
  lastfile  = whichfile;
  lastline  = line;
  lastmessage = text;
  return Which;
}

/* Clear an error status */
error clearerror() {
  lasterror   = NoError;
  lastfile    = 0;
  lastline    = 0;
  lastmessage = 0;
  return NoError;
}

extern error aborterror (error whichone, char *text) {
   mydumperror (whichone, "***\a ABORT:", text, 0, 0);
   exit (whichone);
}

