

  #include <stdio.h>
  #include <math.h>
  #include <sys/time.h>

  #include <hmpi.h>
  #include "qinv.c"
  #include "simpleGrid.c"
  #include "Load_balance.c"
  #include "cholesky_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, j, k, rc;

     struct timeval start, end;
     struct timeval startb, endb;

     {
        rc = HMPI_Init(
                 &argc,
                 &argv
        );

        if (rc != HMPI_OK)
        {
           printf(
               "Problems initializing HMPI runtime "
               "...Exiting...\n"
           );

           HMPI_Finalize(-1);
        }
     }

     if (HMPI_Is_recon_required)
     {
        rc = Do_recon();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems reconning the network"
              "...Exiting...\n"
           );

           HMPI_Finalize(-6);
        }
     }

     /*
      * Record the initial time.
      */
     if (HMPI_Is_host())
     {
        gettimeofday(&start, NULL);
     }

     /*
      * Calculate the barrier time for possible use.
      */
     {
        double tstart, tend;

        gettimeofday(&startb, NULL);

        for (i = 0; i < BARRIER_ITERATIONS; i++)
        {
           rc = HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

           if (rc != MPI_SUCCESS)
           {  
              return rc;
           }
        }
        
        gettimeofday(&endb, NULL);
        
        tstart = startb.tv_sec + (startb.tv_usec/pow(10, 6));
        tend = endb.tv_sec + (endb.tv_usec/pow(10, 6));
        
        /* 
         * There is a barrier at the end
         */
        barrier_time = (tend - tstart)/(BARRIER_ITERATIONS+1);
     }

     {
        rc = Execute_algorithm();

        if (rc != HMPI_OK)
        {
           printf(
              "MAIN:Problems Factorizing Matrix A"
              "...Exiting...\n"
           );

           HMPI_Finalize(-2);
        }
     }

     if (HMPI_Is_host())
     {
        gettimeofday(&end, NULL);
     }

     /*
      * Record the final time and record the elapsed time.
      */
     if (HMPI_Is_host())
     {
        double tstart = start.tv_sec + (start.tv_usec/pow(10, 6));
        double tend = end.tv_sec + (end.tv_usec/pow(10, 6));
        
        double elapsed_time = (tend
                               - tstart
                               - barrier_time
        );                     
        
        printf(
           "N=%d, p=%d, q=%d, r=%d, block size=%d, time(sec)=%0.3f\n",
           N,
           p,
           q,
           r,
           g,
           elapsed_time
        ); 
     }

     HMPI_Finalize(0);
  }
