
   #include <hmpi.h>

   #define  HOSTNAMELENGTH  64

   int main
   (
       int argc,
       char **argv
   )
   {
       int grank;
       int gsize, gsize_from_mpi_comm;
       char hostname[HOSTNAMELENGTH];
       char pname[MPI_MAX_PROCESSOR_NAME];
       int plen;

       gethostname(
          hostname,
          HOSTNAMELENGTH
       );

       HMPI_Init(
           &argc, 
           &argv
       );

       grank = HMPI_Group_rank(
                   HMPI_COMM_WORLD_GROUP
       );

       gsize = HMPI_Group_size(
                   HMPI_COMM_WORLD_GROUP
       );

       MPI_Comm_size(
          HMPI_COMM_WORLD,
          &gsize_from_mpi_comm
       );

       MPI_Get_processor_name(
          pname,
          &plen
       );

       HMPI_Printf(
           "My hostname is %s, My processor name is %s, My global rank is %d, global size from mpi comm is %d, global size is %d\n",
           hostname,
           pname,
           grank,
           gsize_from_mpi_comm,
           gsize
       );

       HMPI_Finalize(0);      
   }

