/*****************************************************************************/
/* mpCtype - MPC_Rts_datatype constructors. Called by MPCtree                */
/* Coded by Dm. Arapov for A.Lastovtsky 1995-1996                            */
/* Release 1.10.96                                                           */
/*****************************************************************************/
/********** mpCtype.c $Author: kusic $ $Revision: 1.2 $ $State: Exp $ $Date: 1998/01/28 14:13:28 $ $Locker:  $ **************/
#include <stdlib.h>
#include <stdio.h>
#include "mpC.h"
#include "mpCtype.h"
#include <mpi.h>

/******************* iMPC_Datatype_array *************************************/
Int iMPC_Datatype_array(
  Int count,
  Int stride,
  MPC_Datatype elemtype,
  MPC_Rts_datatype* pnewtype )
  { 
    Int RC;
    MPC_Rts_datatype oldtype;
    MPI_Datatype mpi_type;
    MPI_Datatype new_mpi_type;
    
    oldtype = MPC_Get_datatype( elemtype );
    mpi_type = *(MPI_Datatype*)oldtype;    
    /*  if ((*pnewtype = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM; */
    if ((*pnewtype = (MPC_Rts_datatype)((MPI_Datatype *)malloc(sizeof(MPI_Datatype)))) == NULL) return MPC_ERR_NOMEM;
    RC = I2C(MPI_Type_vector(count,1,stride,mpi_type,&new_mpi_type));   
    if (RC!=MPC_OK) return RC;
    *(MPI_Datatype*)(*pnewtype) = new_mpi_type;
    return MPC_OK;
  } /* iMPC_Type_array */ 

/******************* MPC_Datatype_array **************************************/
Int MPC_Datatype_array(
  Int count,
  Int stride,
  MPC_Datatype elemtype,
  MPC_Rts_datatype* pnewtype )
  {
    Int RC;

    if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Datatype_array, count = %d, stride = %d, elemtype = %s\n", MPC_Global_rank(), count, stride, MPC_Get_typename(elemtype));
    RC = iMPC_Datatype_array( count, stride, elemtype, pnewtype );
    if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Datatype_array, RC  = %d, rtstype = %p\n", MPC_Global_rank(),RC,*pnewtype);
    return RC;
  } /* iMPC_Datatype_array */
  
/******************* iMPC_Datatype_record ************************************/
Int iMPC_Datatype_record(
  Int count,
  const MPC_Datatype* datatypes,
  MPC_Rts_datatype* pnewtype )
  {                   
    Int RC;
    Int* ones;
    Int* displs;
    Int  position;
    Int i;
    Int extent;
    MPI_Datatype* array_of_types;
    MPI_Datatype new_mpi_type;

    if (( array_of_types = malloc(sizeof(MPI_Datatype)*count)) == NULL) return MPC_ERR_NOMEM;     
    if ((ones = malloc((int)(sizeof(Int)*count))) == NULL) return MPC_ERR_NOMEM;
    if ((displs = malloc((int)(sizeof(Int)*count))) == NULL) return MPC_ERR_NOMEM;
    position = 0;
    for (i=0;i<count;i++) {
      displs[i] = position;
      ones[i] = 1;
      extent = MPC_Type_size( datatypes[i] );
      if (extent == MPC_UNDEFINED_SIZE) return MPC_ERR_UNDEFSIZE;
      array_of_types[i] = *(MPI_Datatype*)(MPC_Get_datatype( datatypes[i]));
      position += extent;
    } /* for */
    if ((*pnewtype = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    RC = I2C(MPI_Type_struct(count,ones,(MPI_Aint*)displs,array_of_types,&new_mpi_type));
    if (RC!=MPC_OK) return RC;
    *(MPI_Datatype*)(*pnewtype) = new_mpi_type;
    free(ones);
    free(displs);
    free(array_of_types); 
    return MPC_OK;
  } /* iMPC_Datatype_record */  

/******************* MPC_Datatype_record *************************************/
Int MPC_Datatype_record(
  Int count,
  const MPC_Datatype* datatypes,
  MPC_Rts_datatype* pnewtype )
  {                   
    Int RC;
    if (MPC_DEBUG > 1) MPC_Debug_printf("---[%2d]-> MPC_Datatype_record, count = %d\n", MPC_Global_rank(),count);
    RC = iMPC_Datatype_record( count, datatypes, pnewtype );
    if (MPC_DEBUG > 1) MPC_Debug_printf("<--[%2d]-- MPC_Datatype_record, RC = %d, newtype = %p\n", MPC_Global_rank(),RC, *pnewtype);
    return RC; 
  } /* MPC_Datatype_record */
  
/******************* iMPC_Type_commit ****************************************/
Int iMPC_Type_commit( MPC_Rts_datatype * pdatatype )
  {               
    Int RC;    
    
    RC = I2C(MPI_Type_commit((MPI_Datatype*)(*pdatatype)));
    if (RC!=MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Type_commit */

/******************* iMPC_Type_commit ****************************************/
Int MPC_Type_commit( MPC_Rts_datatype * pdatatype )
  {               
    Int RC;   
 
    if (MPC_DEBUG > 1) MPC_Debug_printf("---[%2d]-> MPC_Type_commit, rts_datatype = %p\n", MPC_Global_rank(), *pdatatype);
    RC = iMPC_Type_commit( pdatatype ); 
    if (MPC_DEBUG > 1) MPC_Debug_printf("<--[%2d]-- MPC_Type_commit, RC = %d, rts_datatype = %p\n", MPC_Global_rank(), RC, *pdatatype);
    return RC;
  } /* MPC_Type_commit */  

/******************* iMPC_Type_free ******************************************/  
Int iMPC_Type_free(MPC_Rts_datatype* pdatatype)
  {
    Int RC;
    
    RC = I2C(MPI_Type_free((MPI_Datatype*)(*pdatatype)));
    free(*pdatatype);
    *pdatatype = MPC_DATATYPE_NULL;
    if (RC!=MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Type_free */

/******************* MPC_Type_free *******************************************/  
Int MPC_Type_free(MPC_Rts_datatype* pdatatype)
  {
    Int RC;
    if (MPC_DEBUG > 1) MPC_Debug_printf("---[%2d]-> MPC_Type_free\n", MPC_Global_rank()); 
    RC = iMPC_Type_free(pdatatype);
    if (MPC_DEBUG > 1) MPC_Debug_printf("<--[%2d]-- MPC_Type_free, RC = %d\n", MPC_Global_rank(), RC); 
    return RC;
  } /* MPC_Type_free */

/******************* MPC_Get_element_type ************************************/
MPC_Rts_datatype MPC_Get_element_type(MPC_Datatype datatype)
  {
    MPC_Rts_datatype elem_type;
    MPC_Datatype elem_datatype;

    elem_datatype = MPC_Get_element( datatype );
    elem_type = MPC_Get_datatype( elem_datatype );    
    return elem_type;
  } /* MPC_Get_element_type */
  
