/*****************************************************************************/
/* mpCttopo - contains trivial topology functions                            */
/* Coded by Dm. Arapov for A.Lastovetsky 1995-1996                            */
/* Release 1.10.96                                                           */    
/*****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include "mpCttopo.h"
#include "mpC.h"

static Int MPC_Zero_topology[1] = {0};

/******************* iMPC_Trivial_free_topology ******************************/
Int iMPC_Trivial_free_topology(MPC_Net* net)
  {
    return MPC_OK;
  } /* iMPC_Trivial_free_topology */

/******************* MPC_Trivial_free_topology *******************************/
Int MPC_Trivial_free_topology(MPC_Net* net)
  {
    Int RC;

    if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Trivial_free_topology\n", MPC_Net_global.rank ); 
    RC = iMPC_Trivial_free_topology(net);
    if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Trivial_free_topology, RC = %d\n", MPC_Net_global.rank, RC ); 
    return RC;
  } /* MPC_Trivial_free_topology */
  
/******************* iMPC_Trivial_topology_data ******************************/  
Int iMPC_Trivial_topology_data(
    MPC_Net* net,          /* net for which we need topology encoded */
    Int *plenght,
    MPC_Topology *atopology,
    MPC_Topology_free *afreetopology)
    {
      *plenght = 1;
      *atopology = MPC_Zero_topology;
      *afreetopology = MPC_Trivial_free_topology;
      return MPC_OK;
    } /* iMPC_Trivial_topology_data */

/******************* MPC_Trivial_topology_data *******************************/  
Int MPC_Trivial_topology_data(
    MPC_Net* net,          /* net for which we need topology encoded */
    Int *plenght,
    MPC_Topology *atopology,
    MPC_Topology_free *afreetopology)
    {
      Int RC;

      if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Trivial_topology_data\n", MPC_Net_global.rank ); 
      RC = iMPC_Trivial_topology_data(net,plenght,atopology,afreetopology);
      if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Trivial_topology_data, RC = %d\n", MPC_Net_global.rank, RC ); 
      return RC;
    } /* MPC_Trivial_topology_data */

/******************* iMPC_Trivial_init_strategy ******************************/
Int iMPC_Trivial_init_strategy(void)
  {
    Int RC;
    Int env_length;
    Int* env_buffer;

    RC = MPC_Env_recv( &env_length, &env_buffer );   
    if (RC != MPC_OK) return RC;
    free(env_buffer);
    return MPC_OK;
  } /* iMPC_Trivial_init_strategy */

/******************* MPC_Trivial_init_strategy *******************************/
Int MPC_Trivial_init_strategy(void)
  {
    Int RC;

    if (MPC_DEBUG > 1) MPC_Debug_printf("---[%2d]-> MPC_Trivial_init_strategy\n",MPC_Net_global.rank);
    RC = iMPC_Trivial_init_strategy();
    if (MPC_DEBUG > 1) MPC_Debug_printf("<--[%2d]-- MPC_Trivial_init_strategy, RC = %d\n",MPC_Net_global.rank, RC); 
    return RC;
  } /* MPC_Trivial_init_strategy */

/******************* iMPC_Trivial_strategy ***********************************/      
Int iMPC_Trivial_strategy(
  MPC_Node parent,               /* absolute number of the node, which will be parent of the net */
  Int parent_rank,               /* linear number of the parent in the net */
  Int power,                     /* number of nodes to allocate+1 */
  Int topology_length,           /* size of topology info for requested net */
  MPC_Topology topology,         /* the requested net topology */
  Int total_nodes,               /* number of nodes in the computational space */
  Int* map)                      /* inout parameter. global map, at the start */
  {
    MPC_Node i;
    Int j;
    
    j = 0;
    if (j == parent) j++;
    for (i=0;i<total_nodes;i++)
      {
        if (j < power)
          {
            if (map[i] == MPC_EMPTY_NODE) 
              {
                map[i] = j;
                j++;
                if (j==parent) j++;
              } /* if */ 
           } /* if */
      } /* for */
    return MPC_OK;
  } /* iMPC_Trivial_strategy */

/******************* MPC_Trivial_strategy ************************************/      
Int MPC_Trivial_strategy(
  MPC_Node parent,               /* absolute number of the node, which will be parent of the net */
  Int parent_rank,               /* linear number of the parent in the net */
  Int power,                     /* number of nodes to allocate+1 */
  Int topology_length,           /* size of topology info for requested net */
  MPC_Topology topology,         /* the requested net topology */
  Int total_nodes,               /* number of nodes in the computational space */
  Int* map)                      /* inout parameter. global map, at the start */
  {
    Int RC;

    if (MPC_DEBUG > 1) MPC_Debug_printf("---[%2d]-> MPC_Trivial_strategy\n",MPC_Net_global.rank);
    RC = iMPC_Trivial_strategy(parent,parent_rank,power,topology_length,topology,total_nodes,map);
    if (MPC_DEBUG > 1) MPC_Debug_printf("<--[%2d]-- MPC_Trivial_strategy, RC = %d\n",MPC_Net_global.rank, RC); 
    return RC;
  } /* MPC_Trivial_strategy */

/******************* iMPC_Trivial_processors_info ****************************/
Int iMPC_Trivial_processors_info(
  Int* num_of_processors,
  double** relative_performance )
  {
    double* rperf;
    (*num_of_processors) = 1;
    if ((rperf = malloc(sizeof(double))) == NULL) return MPC_ERR_NOMEM;
    (*rperf) = 1.0; 
    (*relative_performance) = rperf; 
    return MPC_OK;
  } /* iMPC_Trivial_processors_info */

/******************* MPC_Trivial_processors_info *****************************/
Int MPC_Trivial_processors_info(
  Int* num_of_processors,
  double** relative_performance )
  {
    Int RC;
    if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Trivial_processors_info\n", MPC_Net_global.rank );
    RC = iMPC_Trivial_processors_info( num_of_processors, relative_performance );
    if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Trivial_processors_info, RC = %d\n", MPC_Net_global.rank, RC );
    return RC;
  } /* MPC_Trivial_processors_info */

/******************* iMPC_Trivial_get_env ************************************/
Int iMPC_Trivial_get_env( Int power, int* argc, LPPSTR* argv, Int* penv_length, Int** penvironment )
  {    
    (*penv_length) = 1;
    if (((*penvironment) = malloc(sizeof(Int)*(*penv_length))) == NULL) return MPC_ERR_NOMEM;
    return MPC_OK;
  } /* iMPC_Trivial_get_env */

/******************* MPC_Trivial_get_env *************************************/
Int MPC_Trivial_get_env( Int power, int* argc, LPPSTR* argv, Int* penv_length, Int** penvironment )
  {
    Int RC;
    if (MPC_DEBUG > 1) MPC_Debug_printf ("---[%2d]-> MPC_Trivial_get_env\n", MPC_Net_global.rank );
    RC = iMPC_Trivial_get_env( power, argc, argv, penv_length, penvironment );
    if (MPC_DEBUG > 1) MPC_Debug_printf ("<--[%2d]-- MPC_Trivial_get_env, RC = %d \n", MPC_Net_global.rank, RC );
    return RC;
  } /* MPC_Trivial_get_env */
 
