#ifndef _MPC_TOPO
#define _MPC_TOPO
/*****************************************************************************/
/* mpCtopo.h - contains all declarations of topology functions, we recommend */
/*             to use.                                                       */
/* Coded by Dm. Arapov for A.Lastovetsky 1995-1996                           */
/* Release 1.10.96                                                           */
/*****************************************************************************/
#include "mpC.h"

Int MPC_The_topology_data(       /* topology info encoding, used by MPC_Net_create */
  MPC_Net* net,                  /* the net which topology is encoded */
  Int* plength,                  /* size of the message, containing  topo info in ints */
  MPC_Topology *atopology,       /* message containing encoded topology info */
  MPC_Topology_free *afree_topology); /* function to free topology info pointed by atopology */

Int MPC_The_strategy( 
  MPC_Node parent,               /* absolute number of the node, which will be parent of the net */
  Int parent_rank,               /* linear number of the parent in the net */
  Int power,                     /* number of nodes to allocate+1 */
  Int topology_length,           /* size of topology info for requested net */
  MPC_Topology topology,         /* the requested net topology */
  Int total_nodes,               /* number of nodes in the computational space */
  Int* map);

Int MPC_The_init_strategy(void); /* used to initialize topology handling module */

Int MPC_The_get_env(             /* function, which retrieves structure of environment */
    Int power,                   /* total number of nodes */
    int* pargc,                  /* main arguments counter */
    LPPSTR* pargv,               /* main arguments list */
    Int* penv_length,            /* size of coded environment in ints */
    Int** penvironment );        /* coded environment topology (array of penv_length) */

Int MPC_The_processors_info(     /* function, which returns phisical reformance info */
    Int* num_of_processors,
    double** relative_performance );

Int MPC_Get_number_of_processors(void);    /* function, which returns the number of phisical processors */

void MPC_Get_processors_info(     /* function, which returns phisical processors dispatcher' map */
    Int* imap,
    double* map );

Int MPC_Set_processors_info(      /* replaces the dispatcher' map by the given one on the host */
    Int  *map );

#endif
