/*****************************************************************************/
/* mpCstd - contains MPC functions which stands for malloc, free and others  */
/*          from stdlib called in generated C programs                       */ 
/* Coded by Dm. Arapov for A.Lastovtsky 1995-1996                            */
/* Release 1.10.96                                                           */
/*****************************************************************************/
#include "stdlib.h"
#include "mpC.h"
#include <mpi.h>
/*********************** MPC_Wtime *******************************************/
double MPC_Wtime( void )
  {
    return MPI_Wtime();
  } /* MPC_Wtime */

/*********************** MPC_Malloc ******************************************/
void* MPC_Malloc(Int size)
  {
    void* ptr;
    ptr = malloc(size);
    if (ptr == NULL) 
      {
        MPC_Error_raise("Can not allocate memory MPC_Malloc returned NULL");
        MPC_Abort(MPC_ERR_NOMEM);
      } /* if */
    return ptr;
  } /* MPC_Malloc */

/*********************** MPC_Free ********************************************/
void MPC_Free(void* ptr)
  {
     free(ptr);
  } /* MPC_Free */

/*********************** MPC_Realloc *****************************************/
void* MPC_Realloc(void* ptr, Int size)
  {
    void* temp = realloc(ptr,size);
    if (temp == NULL) {
      MPC_Error_raise("Can not allocate memory MPC_Realloc returned NULL");
      MPC_Abort(MPC_ERR_NOMEM);
    } /* if */	
    return (temp);
  } /* MPC_Realloc */
  
