/*****************************************************************************/
/* mpCerr - contains all error messages                                      */
/* Coded by Dm. Arapov for A.Lastovtsky 1995-1996                            */
/* Release 1.10.96                                                           */
/* 10.07.97 -- sequence of error messages correted                           */
/*****************************************************************************/
#include <string.h>
#include "mpC.h"
typedef char* MPC_ERRMSG;
static MPC_ERRMSG MPC_Messages[MPC_ERR_LAST] = {
"MPC_OK",
"MPC_ERR_BREAK",
"MPC_ERR_BUFFER",
"MPC_ERR_COUNT",
"MPC_ERR_TYPE",
"MPC_ERR_TAG",                                  
"MPC_ERR_COMM",
"invalid node rank",                                   /* "MPC_ERR_RANK", */
"MPC_ERR_REQUEST",
"MPC_ERR_ROOT",
"MPC_ERR_GROUP",
"invalid reduction operation",                         /* "MPC_ERR_OP", */
"MPC_ERR_TOPOLOGY",
"MPC_ERR_DIMS",
"MPC_ERR_ARG",
"MPC_ERR_MPI",
"MPC_ERR_TRUNCATE",
"not enough memory",                                   /* "MPC_ERR_NOMEM", */
"internal run-time error",                             /* "MPC_ERR_INTERNAL", */
"operation is allowed on the host node only",          /* "MPC_ERR_PRIV", */
"too long source file name",                           /*"MPC_ERR_TOOLONGFILENAME", */
"MPC_ERR_BURSTCODE",
"invalid net of subnet used in operation", /* "MPC_ERR_INVNET", */
"too small computing space, resource deadlock detected",   /* "MPC_ERR_DEADLOCK", */
"MPC_ERR_BURST",
"attempt to create net with non-positive number of nodes", /* "MPC_ERR_POWER", */
"no file specified by MPCTOPOFILE environment variable", /* "MPC_ERR_ENVPARAM", */
"cannot read topology file specified by MPCTOPOFILE environment variable", /* "MPC_ERR_FILE", */
"MPC_ERR_DUPPROCESS",
"MPC_ERR_MISSEDPROCESS",
"invalid subnet to net mapping",                       /* "MPC_ERR_INVALIDMAPPING", */           
"twice entering a wating point",                       /* "MPC_ERR_TWICEWAITBEGIN", */
"net create request received outside a waiting point", /* "MPC_ERR_INVALIDRECONFIG",*/
"in operation used type with undefined size",          /* "MPC_ERR_UNDEFSIZE",      */
"dispatcher received request of unknown type",         /* "MPC_ERR_UNKNOWNREQUEST"  */
"cannot write to file specified by MPCTRACEMAPFILE environment variable" /* MPC_ERR_TRACEFILE */
 };

/******************* RC2STR **************************************************/
void RC2STR(char* message, Int RC )
  {
     if (RC >= MPC_ERR_LAST) message = "invalid retcode";
     else strcpy(message,MPC_Messages[RC]);     
  }; /* RC2STR */  

