/* mpCdisp - contains all net manipulators                                   */
/*  Coded by Dm.Arapov for A.Lastovetsky 1996                                */
/* Release 1.10.96                                                           */
/* 11.11.96 -- MPC_DEBUG converted from compile-time variable to run-time.   */
/* 13.11.96 -- error in MPC_Coord_set for nested subnets corrected.          */
/* 09.12.96 -- out-of-waiting point net free corrected, MPC_OUT dropped      */
/* 10.12.96 -- Local barrier added in MPC_Net_free                           */
/* 05.01.97 -- pargv and pargc arguments for MPI_Init are to be not NULL     */
/* 29.01.97 -- duplicates in debugging varibles removed                      */
/* 31.01.97 -- error in free_net corrected. now parent waits for free space  */
/*             restucturing.                                                 */
/* 10.04.97 -- error in Create_web, Free_web corrected.                      */
/* 04.07.97 -- wait_point_begin now waits for a reply from the dispatcher.   */
/* 07.07.97 -- MPC_Net_create for 1-node net now waits for a reply from      */
/*             dispatcher.                                                   */
/* 07.07.97 -- MPC_Web_create call missed in MPC_Subnet_create               */
/*---------------------------------------------------------------------------*/
/* June 14th, 1999 ******** Revised by A.Lastovetsky *************************/
/* 10/03/2000 * Added MPC_Translation_from_rank and changed iMPC_Node_hire ***/
/*              and iMPC_Net_free                                          ***/
/*---------------------------------------------------------------------------*/
#include <stdarg.h> 
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "mpC.h"
#include <mpi.h>
#include "mpCtriv.h"
#include "mpCttopo.h"
#include "mpCtags.h"

#define MAX_DISPMSG_SIZE 8

const char MPC_Debug_env[] = "MPCDEBUGMODE";
int MPC_DEBUG = 0;

extern Int *MPC_Environment_buffer; /***new***@@@***/
extern Int MPC_Size_of_environment_buffer; /***new***@@@***/

#define MPC_Debug_printf printf

/******************** offsets for MPC_ERRHEAD message ************************/
#define MSG_LINE              0
#define MSG_COLUMN            1
#define MSG_FILENAME_LENGTH   2
#define MSG_ERRMSG_LENGTH     3

/******************** offsets for MPC_PRINTFHEAD message *********************/
#define MSG_PRINTF_LENGTH     0

/******************** offsets for MPC_ENDWORK message ************************/
#define MSG_EXITCODE          0

/******************** offsets for MPC_CREATENET message **********************/

#define MSG_NETNAME           0
#define MSG_TOPOLEN           1
#define MSG_PARAMLEN          2
#define MSG_PARENTRANK        3
#define MSG_POWER             4
#define MSG_ISSTATIC          5

/******************** offsets for MPC_BURSTCREATE message ********************/
#define MSG_BURSTNUMBER       0

/******************** offsets for MPC_FREENET message ************************/
#define MSG_LEADER            0
#define MSG_COUNTTOFREE       1

/******************** offsets for MPC_WAITBEGIN message **********************/
#define MSG_NETSTOFREE        0
#define MSG_NETSTOCREATE      1

/******************** offsets for the dispatcher messages ********************/
#define DSP_CMD               0
#define DSP_RANK              1
#define DSP_NAME              2
#define DSP_PARENT            3
#define DSP_PARAMLEN          4
#define DSP_LEADER            1
#define DSP_RUNOUT            2

/******************** offsets for the Set/Update processors'info messages ****/
#define MSG_SET_UPDATE        0

/*****************************************************************************/
#define MPC_NULL_LEADER      -1

/*****************************************************************************/
typedef struct 
  {
    MPC_Name name;               /* static identifier of the net */
    Int  numofnodes;             /* number of nodes requested */
    Int  numofparams;            /* number of parameters for this type of nets */
    Int  length;                 /* size of topology info */
    MPC_Topology topology;       /* dynamic array of topology info */ 
    Int  parent_rank;            /* requested rank of parent */
    Int  is_static;              /* is the requested net static or not */
  } MPC_Request;

/* typedef struct MPC_QUEUE_ELEMENT MPC_Queue_element; */
typedef struct MPC_QUEUE_ELEMENT
  {
    MPC_Node parent;             /* absolute number of parent */
    Int  numofreqs;              /* number of requests in packet */
    MPC_Request* requests;       /* array of requests numofreqs size */
    struct MPC_QUEUE_ELEMENT* next;     /* next in the dispatcher queue */
  } MPC_Queue_element;
  
typedef struct                   /* iff parent == -1 then the element is free */
  {
    MPC_Node parent;             /* number of element, which is parent of the net */   	
    Int is_static;               /* 1 iff this node is in static net */
    MPC_Node leader;             /* global (in MPI_COMM_WORLD) number of leader of this group */
    Int numofreqs;               /* total requests to brothers and child */
  } MPC_Table_element;

/******************* type constants *******************************************/
MPC_Rts_datatype MPC_CHAR; 
MPC_Rts_datatype MPC_SHORT; 
MPC_Rts_datatype MPC_INT; 
MPC_Rts_datatype MPC_LONG; 
MPC_Rts_datatype MPC_UNSIGNED_CHAR; 
MPC_Rts_datatype MPC_UNSIGNED_SHORT; 
MPC_Rts_datatype MPC_UNSIGNED; 
MPC_Rts_datatype MPC_UNSIGNED_LONG; 
MPC_Rts_datatype MPC_FLOAT; 
MPC_Rts_datatype MPC_DOUBLE; 
MPC_Rts_datatype MPC_LONG_DOUBLE; 

/******************* operation constants *************************************/
MPC_Op     MPC_SUM;
MPC_Op     MPC_PROD;
MPC_Op     MPC_BAND;
MPC_Op     MPC_BOR;
MPC_Op     MPC_BXOR;
MPC_Op     MPC_MAX;
MPC_Op     MPC_MIN;
MPC_Op     MPC_LAND;
MPC_Op     MPC_LOR;

/******************* debugging variables *************************************/
static char source_filename[MAX_FILENAME_LENGTH]; 
static Int  source_line;
static Int  source_column;

/******************* process variables ***************************************/
char* MPC_Debug_source_name = NULL;
static MPC_Parameters MPC_Net_global_parameters[1];
MPC_Net MPC_Net_global;
MPC_Net MPC_Net_host;
static MPC_Parameters MPC_Net_recon_parameters[1];
MPC_Net MPC_Net_recon;
Int* _iMPC_recon_net_MASK = NULL;
Int  _iMPC_recon_net_V;
#define recon_net_MASK  _iMPC_recon_net_MASK
#define recon_net_V  _iMPC_recon_net_V
MPC_Command MPC_command;
Int MPC_count;
Int MPC_num;
Int MPC_Error_test;
static MPC_Net* static_stack = NULL;
static FILE *NULLDEV = NULL;  
static FILE *ERROR_LOG = NULL;
static MPI_Errhandler Err_handler;
static MPI_Handler_function MPC_ErrorHandler;
static Int  dispatcher;
static MPI_Comm              free_comm = MPI_COMM_NULL;
static MPI_Comm              exit_comm = MPI_COMM_NULL; /** Addition 09.12.1999 **/
static Int                   free_size;
static MPI_Comm              special_comm;
static MPI_Comm              log_comm;
static MPI_Comm              return_comm = MPI_COMM_NULL;
static double*               info_relative_performance = NULL;
static Int                   info_num_of_processors;

static MPC_Topology_data     the_topology_data;
static Int                   skip_waiting_point = 0;

/* rreddy
 * Variables for HMPI library
 */
MPC_Net MPC_Net_free_procs;
static MPI_Comm  hmpi_free_comm = MPI_COMM_NULL;
static MPI_Comm  hmpi_return_comm = MPI_COMM_NULL;
static int hmpi_free_comm_size = 0;

/*
 * The processor number on which this process is launched.
 */
Int MPC_Processor_number;

#ifndef HOSTNAMELENGTH
#define  HOSTNAMELENGTH      128
#endif

/***new***MPC_Hierarchy_descr*****@@@*******************************/
typedef struct MPC_Link_hierarchy_descr {
  Int level;                                 /* Level of link hierarchy */
  double linkspeed[MPC_TRANSFER_DATA_RANGE]; /* 1.0/(link speed) on different sizes of */
                                             /* transferred data messages, sec/byte */
  struct MPC_Link_hierarchy_descr *top;      /* points to higher link descriptor */
} MPC_Hi_descr;

typedef struct MPC_GROUP_DESCR {
  Int maxproc;
  Int numproc;
  Int scalability;
  Int processor_power; 
  double max_nodepower;
  double* nodeweights;
  Int*    nodenumbers;
  MPC_Hi_descr *link_descr;     /* points to link descriptor for the group @@@*/
  } MPC_Group_descr; 

extern Int _iMPC_NGroups;
extern MPC_Group_descr* _iMPC_Groups;

extern Int _iMPC_NProcs;
extern double* _iMPC_rperformance;

#define ngroups      _iMPC_NGroups
#define groups       _iMPC_Groups

#define nprocs       _iMPC_NProcs
#define rperformance _iMPC_rperformance

/******************* dispatcher only variables *******************************/
static MPC_Error_print       dsp_error_print;
static MPC_Init_strategy     dsp_init_strategy;
static MPC_Topology_strategy dsp_topology_strategy;
/* static MPC_Get_env           dsp_environment_get; */
static MPC_Table_element*    dsp_table;
static MPC_Queue_element*    dsp_queue;
static MPC_Processors_info   dsp_processors_info;
static Int                   dsp_table_size;
static Int                   dsp_free_counter = MPC_OUT_OF_POINT;
static Int                   dsp_create_counter = MPC_OUT_OF_POINT;
static Int                   dsp_wait_point_counter = 0;

static MPC_NetType MPC_Trivial_type= {1,
                                     MPC_NetType_trivial_node,
                                     MPC_NetType_trivial_link,
                                     MPC_NetType_trivial_parent,
                                     MPC_NetType_trivial_power,
                                     MPC_NetType_trivial_num2coord,
                                     MPC_NetType_trivial_coord2num};
                                     
/******************* I2C *****************************************************/

Int I2C(Int mpi_error)
  {
    switch (mpi_error) {
        case MPI_SUCCESS     : {return MPC_OK; break;}
        case MPI_ERR_BUFFER  : {return MPC_ERR_BUFFER; break;}
        case MPI_ERR_COUNT   : {return MPC_ERR_COUNT; break;}
        case MPI_ERR_TYPE    : {return MPC_ERR_TYPE; break;}
        case MPI_ERR_TAG     : {return MPC_ERR_TAG; break;}
        case MPI_ERR_COMM    : {return MPC_ERR_COMM; break;}
        case MPI_ERR_RANK    : {return MPC_ERR_RANK; break;}
        case MPI_ERR_REQUEST : {return MPC_ERR_REQUEST; break;}
        case MPI_ERR_ROOT    : {return MPC_ERR_ROOT; break;}
        case MPI_ERR_GROUP   : {return MPC_ERR_GROUP; break;}
        case MPI_ERR_OP      : {return MPC_ERR_OP; break;}
        case MPI_ERR_TOPOLOGY: {return MPC_ERR_TOPOLOGY; break;}
        case MPI_ERR_DIMS    : {return MPC_ERR_DIMS; break;}
        case MPI_ERR_ARG     : {return MPC_ERR_ARG; break;}
        case MPI_ERR_UNKNOWN : {return MPC_ERR_MPI; break;}
        case MPI_ERR_TRUNCATE: {return MPC_ERR_TRUNCATE; break;}
        case MPI_ERR_OTHER   : {return MPC_ERR_MPI; break;}
        case MPI_ERR_INTERN  : {return MPC_ERR_MPI; break;}
        default : return MPC_ERR_INTERNAL;
    } /* switch */
  } /* I2C */

Int MPC_Trivial_error_print
  ( const char* filename,        /* source fileneme */
    Int line,                    /* line of the source file, where error occured */
    Int column,                  /* column of the source file, where error occured */
    const char* msg )            /* error message */
  {
    printf("%s %4d %3d %s\n", filename, line, column, msg );
    return MPC_OK;
  }

/*********************** Environment information ******************************/
Int  MPC_Processor_number = 0;
Int* MPC_Processor_scalability = NULL;  
Int* MPC_Processor_weight = NULL;
Int* MPC_Processor_number_of_nodes = NULL;
Int** MPC_Processor_nodes_indexes = NULL;
Int* MPC_Link_weight = NULL;  

Int MPC_NetType_env_node( Int num, const Int* aparams )
  {
    if (num >= aparams[0]) return 0;
    return 256; 
  }  /* MPC_NetType_env_node */

Int MPC_NetType_env_link(Int fromnum, Int tonum, const Int* aparams )
  {
    if ((fromnum >= aparams[0]) || (tonum >= aparams[0])) return 0;
    return (fromnum==tonum) ? MPC_SHORTEST_LINK : MPC_NORMAL_LINK; 
  } /* MPC_NetType_env_link */
                                    
Int MPC_NetType_env_parent(const Int* params) 
  { 
    return 0;
  } /* MPC_NetType_env_parent */

Int MPC_NetType_env_power(const Int *params) 
  {
    return params[0];
  } /* MPC_NetType_env_power */

void MPC_NetType_env_num2coord(Int num, const Int* params, Int *coord) 
  {        
    coord[0] = num;
    return;
  } /* MPC_NetType_env_coord */

Int MPC_NetType_env_coord2num(const Int* coords, const Int* params) 
  { 
    return coords[0];
  } /* MPC_NetType_env_number */

/******************* iMPC_Env_send *******************************************/
Int iMPC_Env_send(Int env_length, Int* env_buffer)
  {
    Int RC;

    RC = I2C(MPI_Send(&env_length,1,MPI_INT,dispatcher,MPC_ENVSIZE_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) return RC;
    if (env_length == 0) return MPC_OK;
    RC = I2C(MPI_Send(env_buffer,env_length,MPI_INT,dispatcher,MPC_ENVBODY_TAG,MPI_COMM_WORLD)); 
    if (RC != MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Env_send */ 

/******************* MPC_Env_send ********************************************/
Int MPC_Env_send(Int env_length, Int* env_buffer)
  {
    Int RC;
    Int rank;

    RC = MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Env_send\n", rank ); 
    RC = iMPC_Env_send( env_length, env_buffer );
    if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Env_send, RC = %d\n", rank, RC ); 
    return RC;
  } /* MPC_Env_send */

/******************* iMPC_Env_recv *******************************************/
Int iMPC_Env_recv(Int* penv_length, Int** penv_buffer)
  {
    Int RC;
    Int* temp;
    MPI_Status status;

    RC = I2C(MPI_Recv(penv_length,1,MPI_INT,0,MPC_ENVSIZE_TAG,MPI_COMM_WORLD, &status));
    if (RC != MPC_OK) return RC;
    if ((*penv_length) == 0) return MPC_OK; 
    if ((temp = malloc((*penv_length)*sizeof(Int))) == NULL) return MPC_ERR_NOMEM;
    RC = I2C(MPI_Recv(temp,(*penv_length),MPI_INT,0,MPC_ENVBODY_TAG,MPI_COMM_WORLD, &status));
    if (RC != MPC_OK) return RC;
    (*penv_buffer) = temp;
    return MPC_OK; 
  } /* iMPC_Env_recv */

/******************* MPC_Env_recv ********************************************/
Int MPC_Env_recv(Int* penv_length, Int** penv_buffer)
  {
    Int RC;
    Int rank;

    RC = MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    if (MPC_DEBUG > 1) MPC_Debug_printf( "---[%2d]-> MPC_Env_recv\n", rank ); 
    RC = iMPC_Env_recv( penv_length, penv_buffer );
    if (MPC_DEBUG > 1) MPC_Debug_printf( "<--[%2d]-- MPC_Env_recv, RC = %d\n", rank, RC ); 
    return RC;
  } /* MPC_Env_recv */                                                                          
/******************* iMPC_Comm_unite *****************************************/ 
struct ah_desc {			/* hash table descriptor */
	int		ah_maxnelem;	/* maximum nbr. elements */
	int		ah_nelem;	/* current nbr. elements */
	int		ah_elemsize;	/* size of element */
	int		ah_nullkey;	/* null hash key value */
	int		ah_mode;	/* mode of operation */
	int		*ah_lru;	/* table of LRU counters */
	void		*ah_table;	/* ptr to the hash table */
	int		(*ah_cmp)();	/* comparison function */
};
struct _comm {
	int		c_flags;
#define LAM_CINTER	0x02			/* intercommunicator? */
#define LAM_CLDEAD	0x04			/* local group dead? */
#define LAM_CRDEAD	0x08			/* remote group dead? */	
	int		c_contextid;		/* context ID */
	int		c_refcount;		/* reference count */
	int		c_cube_dim;		/* inscribing cube dim. */
	MPI_Group	c_group;		/* local group */
	MPI_Group	c_rgroup;		/* remote group */
	MPI_Errhandler	c_errhdl;		/* error handle */
	struct ah_desc		*c_keys;		/* keys cache hash table */
	int		c_topo_type;		/* topology type */
	int		c_topo_nprocs;		/* # topo. processes */
	int		c_topo_ndims;		/* # cart. dimensions */
	int		c_topo_nedges;		/* # graph edges */
	int		*c_topo_dims;		/* cart. dimensions */
	int		*c_topo_coords;		/* cart. coordinates */
	int		*c_topo_index;		/* graph indices */
	int		*c_topo_edges;		/* graph edges */
};

Int iMPC_Comm_unite( 
  MPI_Comm local_comm, 
  Int high, 
  MPC_Node remote_rank, 
  MPI_Comm* punited_comm, 
  Int local_leader_rank )
  {
    Int RC;
    MPI_Comm inter_comm;
 
    RC = I2C(MPI_Intercomm_create(local_comm,local_leader_rank,
                                  special_comm,remote_rank,0, &inter_comm));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Intercomm_merge(inter_comm,high,punited_comm));
    if (RC != MPC_OK) return RC;
    RC = MPI_Comm_free(&inter_comm);
    if (RC != MPC_OK) return RC;
    return MPC_OK;
  }  /* iMPC_Comm_unite */

/******************* MPC_Comm_unite ******************************************/
Int MPC_Comm_unite( 
  MPI_Comm local_comm, 
  Int high, 
  MPC_Node remote_rank, 
  MPI_Comm* punited_comm,
  Int local_leader_rank  )
  {
    Int RC;
  
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]->MPC_Comm_unite, high=%d, remote_rank=%d, local_leader_rank=%d\n",
                        MPC_Net_global.rank, high, remote_rank, local_leader_rank );
    RC = iMPC_Comm_unite( local_comm, high, remote_rank,
                          punited_comm, local_leader_rank );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("<--[%2d]-- MPC_Comm_unite, RC = %d\n",
                        MPC_Net_global.rank, RC );
    return RC;     
  } /* MPC_Comm_unite */
  
/******************* iMPC_Translate_from_rank ***added*10/03/2000**********/
Int iMPC_Translate_from_rank( MPC_Node* number, MPI_Comm comm, Int rank )
  { 
    Int RC;
    MPI_Group world_group;
    MPI_Group local_group;
    
    RC = I2C(MPI_Comm_group(MPI_COMM_WORLD,&world_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Comm_group(comm,&local_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_translate_ranks(local_group,1,&rank,world_group,number));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_free(&world_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_free(&local_group));
    if (RC != MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Translate_from_rank */

/******************* MPC_Translate_from_rank ***added*10/03/2000*********/
Int MPC_Translate_from_rank( MPC_Node* number, MPI_Comm comm, Int rank )
  { 
    Int RC;
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("---[%2d]-> MPC_Translate_from_rank, rank = %d\n",
                        MPC_Net_global.rank, rank );
    RC = iMPC_Translate_from_rank( number, comm, rank );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("<--[%2d]-- MPC_Translate_from_rank, RC = %d, number = %d\n",
                        MPC_Net_global.rank, RC, (*number) );
    return RC;     
  } /* MPC_Translate_from_rank */
  
/******************* iMPC_Translate_rank *************************************/
Int iMPC_Translate_rank( MPC_Node number, MPI_Comm comm, Int* rank )
  { 
    Int RC;
    MPI_Group world_group;
    MPI_Group local_group;
    
    RC = I2C(MPI_Comm_group(MPI_COMM_WORLD,&world_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Comm_group(comm,&local_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_translate_ranks(world_group,1,&number,local_group,rank));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_free(&world_group));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Group_free(&local_group));
    if (RC != MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Translate_rank */

/******************* MPC_Translate_rank **************************************/
Int MPC_Translate_rank( MPC_Node number, MPI_Comm comm, Int* rank )
  { 
    Int RC;
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("---[%2d]-> MPC_Translate_rank, number = %d\n",
                        MPC_Net_global.rank, number );
    RC = iMPC_Translate_rank( number, comm, rank );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("<--[%2d]-- MPC_Translate_rank, RC = %d, rank = %d\n",
                        MPC_Net_global.rank, RC, (*rank) );
    return RC;     
  } /* MPC_Translate_rank */
  
/******************* iMPC_Dispatcher_table_init ******************************/
Int iMPC_Dispatcher_table_init(void)
  {
    Int RC;                     
    Int size;
    Int i;
    
    RC = I2C(MPI_Comm_size(MPI_COMM_WORLD,&size));
    if (RC != MPC_OK) return RC;
    size--;
    dsp_table_size = size;
    if ((dsp_table = malloc((int)(size*sizeof(MPC_Table_element)))) == NULL)
      return MPC_ERR_NOMEM;
    dsp_table[0].parent = 0;
    dsp_table[0].is_static = 1;
    dsp_table[0].leader = 0;  
    dsp_table[0].numofreqs = 0;
    for (i=1;i<size;i++) {
      dsp_table[i].parent =-1;
      dsp_table[i].is_static = 0;
      dsp_table[i].leader = 0;
      dsp_table[i].numofreqs = 0;
    } /* for */
    return MPC_OK;
  } /* iMPC_Dispatcher_table_init */

/******************* MPC_Dispatcher_table_init *******************************/
Int MPC_Dispatcher_table_init(void)
  {
    Int RC;        
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("---[%2d]-> MPC_Dispatcher_table_init\n",
                        MPC_Net_global.rank );
    RC = iMPC_Dispatcher_table_init();
    if (MPC_DEBUG > 1)
      MPC_Debug_printf ("<--[%2d]-- MPC_Dispatcher_table_init, RC = %d\n",
                        MPC_Net_global.rank, RC );
    return RC;                  
  } /* MPC_Dispatcher_table_init */ 

/******************* iMPC_Dispatcher_table_done ******************************/ 
Int iMPC_Dispatcher_table_done(void)
  {  
    if (dsp_table != NULL) free(dsp_table);
    return MPC_OK;
  } /* iMPC_Dispatcher_table_done */

/******************* MPC_Dispatcher_table_done *******************************/ 
Int MPC_Dispatcher_table_done(void)
  {  
    Int RC;
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_table_done\n",
                       MPC_Net_global.rank ); 
    RC = iMPC_Dispatcher_table_done();
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_table_done, RC = %d\n",
                       MPC_Net_global.rank, RC ); 
    return RC;  
  } /* MPC_Dispatcher_table_done */
  
/******************* iMPC_Dispatcher_table_add *******************************/
Int iMPC_Dispatcher_table_add( MPC_Node parent, Int is_static,
                               const Int* full_map, MPC_Node* pleader )
  { 
    Int leader;
    Int i;
    
    leader = dsp_table_size+1;
    for (i=0;i<dsp_table_size;i++) {
      if (full_map[i] >= 0) {
        if (leader == dsp_table_size+1)
          leader = i;
        dsp_table[i].parent = parent;
        dsp_table[i].is_static = is_static;
        dsp_table[i].leader = leader;
        dsp_table[i].numofreqs = 0;
      } /* if */
    } /* for */    
    *pleader = leader;  
    return MPC_OK;
  } /* iMPC_Dispatcher_table_add */

/******************* MPC_Dispatcher_table_add ********************************/
Int MPC_Dispatcher_table_add( MPC_Node parent, Int is_static,
                              const Int* full_map, MPC_Node* pleader )
  {
    Int RC;
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_table_add parent = %d, is_static = %d\n",
                       MPC_Net_global.rank, parent, is_static);
    RC = iMPC_Dispatcher_table_add( parent, is_static, full_map, pleader );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_table_add, RC = %d, leader = %d\n", 
                       MPC_Net_global.rank, RC, *pleader);
    return RC;    
  } /* MPC_Dispatcher_table_add */

/******************* iMPC_Dispatcher_table_query *****************************/ 
Int iMPC_Dispatcher_table_query( Int* empty_map )
  {
    Int i;
    
    for(i=0;i<dsp_table_size;i++) {          
      empty_map[i] = (dsp_table[i].parent == -1) ?(MPC_EMPTY_NODE):(MPC_USED_NODE);
    } /* for */
    return MPC_OK;
  } /* iMPC_Dispatcher_table_query */

/******************* MPC_Dispatcher_table_query ******************************/ 
Int MPC_Dispatcher_table_query( Int* empty_map )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_table_query\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_table_query( empty_map );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_table_query, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;
  } /* MPC_Dispatcher_table_query */

/******************* iMPC_Dispatcher_table_free ******************************/  
Int iMPC_Dispatcher_table_free( MPC_Node leader )
  {       
    Int i;
    
    for (i=0;i<dsp_table_size;i++) {
      if (dsp_table[i].leader == leader) {
        dsp_table[i].parent = -1;
        dsp_table[i].is_static = 0;
        dsp_table[i].leader = 0;
        dsp_table[i].numofreqs = 0;
      } /* if */
    } /* for */
    return MPC_OK;  
  } /* iMPC_Dispatcher_table_free */     

/******************* MPC_Dispatcher_table_free *******************************/  
Int MPC_Dispatcher_table_free( MPC_Node leader )
  {       
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_table_free leader = %d\n",
                       MPC_Net_global.rank, leader);
    RC = iMPC_Dispatcher_table_free( leader );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_table_free, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_table_free */ 

/*****************************************************************************/
 Int MPC_Dispatcher_table_request( MPC_Node parent, Int increase);
 
/******************* iMPC_Dispatcher_table_request ***************************/
Int iMPC_Dispatcher_table_request( MPC_Node parent, Int increase)
  {
    Int i;
    MPC_Node leader;
    
    leader = dsp_table[parent].leader;
    for (i = 0;i<dsp_table_size;i++)
      if ((dsp_table[i].leader == leader) && (dsp_table[i].parent != -1))
        { 
          if (increase)
            dsp_table[i].numofreqs++;
          else
            dsp_table[i].numofreqs--;
        } /* if */ 
    if (parent != 0)
      MPC_Dispatcher_table_request( dsp_table[parent].parent, increase );   
    return MPC_OK;
  } /* iMPC_Dispatcher_table_request */ 

/******************* MPC_Dispatcher_table_request ****************************/
Int MPC_Dispatcher_table_request( MPC_Node parent, Int increase)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_table_request, increase = %d\n", 
                       MPC_Net_global.rank, increase);
    RC = iMPC_Dispatcher_table_request( parent, increase );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_table_request, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_table_request */ 
  
/******************* iMPC_Element_init ***************************************/
Int iMPC_Element_init(Int aparent, Int anumofreqs, MPC_Queue_element* element)
  {
    element->parent = aparent;
    element->numofreqs = anumofreqs;
    if (((element->requests) = malloc((int)(sizeof(MPC_Request)*anumofreqs))) == NULL)
      return MPC_ERR_NOMEM;
    return MPC_OK;
  } /* iMPC_Element_init */ 

/******************* MPC_Element_init ****************************************/
Int MPC_Element_init(Int aparent, Int anumofreqs, MPC_Queue_element* element)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Element_init, parent = %d, anumofreqs = %d\n", 
                       MPC_Net_global.rank, aparent, anumofreqs);
    RC = iMPC_Element_init( aparent, anumofreqs, element );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Element_init, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Element_init */ 
  
/******************* iMPC_Request_set ****************************************/  
Int iMPC_Request_set(
  const MPC_Queue_element* element, 
  Int  reqno,
  MPC_Name aname,
  Int  anumofnodes,      /* number of nodes requested */
  Int  anumofparams,     /* number of parameters in topo functions */
  Int  alength,          /* size of topology info */
  MPC_Topology atopology, /* dynamic array of topology info */ 
  Int  aparent_rank,     /* requested rank of parent */
  Int  ais_static)       /* is the requested net static or not */
  { 
    (element->requests)[reqno].name = aname;
    (element->requests)[reqno].numofnodes = anumofnodes;
    (element->requests)[reqno].numofparams = anumofparams;
    (element->requests)[reqno].length = alength;
    (element->requests)[reqno].parent_rank = aparent_rank;
    (element->requests)[reqno].is_static = ais_static;
    (element->requests)[reqno].topology = (alength == 0) ? NULL : atopology;
    return MPC_OK;
  } /* iMPC_Request_set */

/******************* MPC_Request_set *****************************************/  
Int MPC_Request_set(
  const MPC_Queue_element* element, 
  Int  reqno,
  MPC_Name aname,
  Int  anumofnodes,      /* number of nodes requested */
  Int  anumofparams,     /* number of parameters in topo functions */
  Int  alength,          /* size of topology info */
  MPC_Topology atopology, /* dynamic array of topology info */ 
  Int  aparent_rank,     /* requested rank of parent */
  Int  ais_static)       /* is the requested net static or not */
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Request_set\n",
                       MPC_Net_global.rank);
    RC = iMPC_Request_set( element, reqno, aname, anumofnodes,anumofparams,
                           alength, atopology, aparent_rank, ais_static );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Request_set, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;
  } /* MPC_Request_set */
  
/******************* MPC_Element_power ***************************************/
Int MPC_Element_power( const MPC_Queue_element* element )
  {
    Int i;
    Int power;
    
    power = 0;
    for (i = 0;i<element->numofreqs;i++) {
      power += ((element->requests[i].numofnodes)-1);
    } /* for */
    return power;  
  } /* MPC_Element_power */

/******************* iMPC_Element_done ***************************************/
Int iMPC_Element_done( MPC_Queue_element* element )
  {
    Int i;
    
    for (i=0;i<(element->numofreqs);i++) {
      if (element->requests[i].topology != NULL)
        free(element->requests[i].topology);
    } /* for */
    free(element->requests);
    return MPC_OK;
  } /* iMPC_Element_done */

/******************* MPC_Element_done ****************************************/
Int MPC_Element_done( MPC_Queue_element* element )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Element_done\n",
                       MPC_Net_global.rank);
    RC = iMPC_Element_done( element );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Element_done, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;     
  } /* MPC_Element_done */
  
/******************* iMPC_Dispatcher_queue_init ******************************/
Int iMPC_Dispatcher_queue_init( void )
  {
    dsp_queue = NULL;
    return MPC_OK;
  } /* iMPC_Dispatcher_queue_init */

/******************* MPC_Dispatcher_queue_init *******************************/
Int MPC_Dispatcher_queue_init( void )
  {
    Int RC;

    if (MPC_DEBUG > 1)
        MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_queue_init\n",
                         MPC_Net_global.rank);
    RC = iMPC_Dispatcher_queue_init();
    if (MPC_DEBUG > 1)
    MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_queue_init, RC = %d\n",
                     MPC_Net_global.rank, RC);
    return RC;     
  } /* MPC_Dispatcher_queue_init */
  
/******************* iMPC_Dispatcher_queue_done ******************************/
Int iMPC_Dispatcher_queue_done( void )
  { 
    Int RC;
    MPC_Queue_element* temp;
    
    while (dsp_queue != NULL) {
      temp = dsp_queue;
      dsp_queue = temp->next;
      RC = MPC_Element_done( temp );
      if (RC != MPC_OK) return RC;
      free(temp);
    } /* while */
    return MPC_OK;
  } /* iMPC_Dispatcher_queue_done */  

/******************* MPC_Dispatcher_queue_done *******************************/
Int MPC_Dispatcher_queue_done( void )
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_queue_done\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_queue_done();
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_queue_done, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;     
  } /* MPC_Dispatcher_queue_done */

/******************* MPC_Dispatcher_leave_waiting_point **********************/
Int MPC_Dispatcher_leave_waiting_point( void )
  {
    dsp_free_counter = MPC_OUT_OF_POINT;
    dsp_create_counter = MPC_OUT_OF_POINT;     
    return MPC_OK;
  } /* MPC_Dispatcher_leave_waiting_point */
  
/******************* iMPC_Dispatcher_hire ************************************/
Int iMPC_Dispatcher_hire(Int* scatter_map)
  { 
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Comm temp_comm;

    RC = I2C(MPI_Scatter(scatter_map,MAX_DISPMSG_SIZE,MPI_INT,dummy,
                         MAX_DISPMSG_SIZE,MPI_INT, free_size-1, free_comm));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Comm_split(free_comm, 0, 1, &temp_comm));
    if (RC != MPC_OK)
      return RC;

    /* rreddy
     * Free the free_comm before moving the temp_comm
     */
    {
       int result = MPI_Comm_free(
                       &free_comm
       );

       result = I2C(result);

       if (result != MPC_OK)
       {
          return result;
       }
    }

    free_comm = temp_comm;

    RC = I2C(MPI_Comm_size(free_comm,&free_size));
    if (RC != MPC_OK)
      return RC;

    /* rreddy
     * hmpi_free_comm -- communicator containing only the 
     * free processes.
     */
    {
       int free_comm_rank;
       int result = MPI_Comm_rank(
                       free_comm,
                       &free_comm_rank
       );

       result = I2C(result);

       if (result != MPC_OK)
       {
          return result;
       }

       result = MPI_Comm_split(
                   free_comm,
                   MPI_UNDEFINED,
                   free_comm_rank - 1,
                   &hmpi_return_comm
       );

       result = I2C(result);

       if (result != MPC_OK)
       {
          return result;
       }
    }

    return MPC_OK;
  } /* iMPC_Dispatcher_hire */

/******************* MPC_Dispatcher_hire *************************************/
Int MPC_Dispatcher_hire(Int* scatter_map)
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_hire\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_hire( scatter_map );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_hire, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_hire */

/******************* iMPC_Dispatcher_fire *************************************/  
Int iMPC_Dispatcher_fire(MPC_Node leader, Int run_out)
  { 
    Int RC;
    Int* scatter_map;
    MPI_Comm united_comm;
    Int dummy[MAX_DISPMSG_SIZE];
    Int i;

    if ((scatter_map = malloc((int)(MAX_DISPMSG_SIZE*sizeof(Int)*free_size))) == NULL)
      return MPC_ERR_NOMEM;
    for (i=0;i<free_size;i++) {
      scatter_map[(MAX_DISPMSG_SIZE*i)+DSP_CMD] = MPC_FIRED;
      scatter_map[(MAX_DISPMSG_SIZE*i)+DSP_LEADER] = leader;
      scatter_map[(MAX_DISPMSG_SIZE*i)+DSP_RUNOUT] = run_out;
    } /* for */
    RC = I2C(MPI_Scatter(scatter_map,MAX_DISPMSG_SIZE,MPI_INT,dummy,
                         MAX_DISPMSG_SIZE,MPI_INT,free_size-1,free_comm));
    if (RC != MPC_OK)
      return RC;
    free(scatter_map);
    if (leader != MPC_NULL_LEADER) {
      RC = MPC_Comm_unite(free_comm,1,leader,&united_comm,free_size-1);
      if (RC != MPC_OK)
        return RC;

      /* rreddy
       * Free the free_comm before moving the temp_comm
       */
      {
         int result = MPI_Comm_free(
                         &free_comm
         );

         result = I2C(result);

         if (result != MPC_OK)
         {
            return result;
         }
      }

      free_comm = united_comm; 

      RC = I2C(MPI_Comm_size(free_comm,&free_size));
      if (RC != MPC_OK)
        return RC;

      /* rreddy
       * hmpi_free_comm -- communicator containing only the
       * free processes.
       */
      {
         int free_comm_rank;
         int result = MPI_Comm_rank(
                         free_comm,
                         &free_comm_rank
         );

         result = I2C(result);

         if (result != MPC_OK)
         {
            return result;
         }

         result = MPI_Comm_split(
                     free_comm,
                     MPI_UNDEFINED,
                     free_comm_rank - 1, 
                     &hmpi_return_comm
         );

         result = I2C(result);

         if (result != MPC_OK)
         {
            return result;
         }
      }

    } /* if */
    return MPC_OK;    
  } /* iMPC_Dispatcher_fire */

/******************* MPC_Dispatcher_fire *************************************/  
Int MPC_Dispatcher_fire(MPC_Node leader, Int run_out)
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_fire, leader = %d, run_out = %d\n", 
                       MPC_Net_global.rank, leader, run_out);
    RC = iMPC_Dispatcher_fire( leader, run_out );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_fire, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_fire */
  
/******************* iMPC_Dispatcher_notify_free_processes *************************************/  
Int iMPC_Dispatcher_notify_free_processes( Int source )
  { 
    Int RC;
    Int* scatter_map;
    Int dummy[MAX_DISPMSG_SIZE];
    Int i;             
    Int dum;

    RC = MPC_Dispatcher_leave_waiting_point();
    if (RC != MPC_OK) return RC;         
    if ((scatter_map = malloc((int)(MAX_DISPMSG_SIZE*sizeof(Int)*free_size))) == NULL)
      return MPC_ERR_NOMEM;
    for (i=0;i<free_size;i++)
      scatter_map[MAX_DISPMSG_SIZE*i] = MPC_OUT;
    RC = I2C(MPI_Scatter(scatter_map,MAX_DISPMSG_SIZE,MPI_INT,dummy,
                         MAX_DISPMSG_SIZE,MPI_INT,free_size-1,free_comm));
    free(scatter_map);
    if (RC != MPC_OK)
      return RC;

    RC = MPI_Send(
            &dum,
            1,
            MPI_INT,
            source,
            MPC_NOTIFY_FREE_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    return MPC_OK;
  } /* iMPC_Dispatcher_notify_free_processes */

/******************* MPC_Dispatcher_out **************************************/  
Int MPC_Dispatcher_notify_free_processes( Int source )
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_out\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_notify_free_processes(source);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_out, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_notify_free_processes */

/******************* iMPC_Dispatcher_out *************************************/  
Int iMPC_Dispatcher_out( void )
  { 
    Int RC;
    Int* scatter_map;
    Int dummy[MAX_DISPMSG_SIZE];
    Int i;             

    RC = MPC_Dispatcher_leave_waiting_point();
    if (RC != MPC_OK) return RC;         
    if ((scatter_map = malloc((int)(MAX_DISPMSG_SIZE*sizeof(Int)*free_size))) == NULL)
      return MPC_ERR_NOMEM;
    for (i=0;i<free_size;i++)
      scatter_map[MAX_DISPMSG_SIZE*i] = MPC_OUT;
    RC = I2C(MPI_Scatter(scatter_map,MAX_DISPMSG_SIZE,MPI_INT,dummy,
                         MAX_DISPMSG_SIZE,MPI_INT,free_size-1,free_comm));
    free(scatter_map);
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_out */

/******************* MPC_Dispatcher_out **************************************/  
Int MPC_Dispatcher_out( void )
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_out\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_out();
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_out, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC; 
  } /* MPC_Dispatcher_out */

/******************* iMPC_Dispatcher_reply ***********************************/
Int iMPC_Dispatcher_reply(MPC_Queue_element* elem, MPC_Node* leaders)
  {
    Int RC;       
    Int i;
    MPC_Node leader;

    for (i=0;i<elem->numofreqs;i++) {
      leader = leaders[i];
      RC = I2C(MPI_Send(&leader,1,MPI_INT,elem->parent,
                        MPC_REPLY_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
    } /* for */
    return MPC_OK;
  } /* iMPC_Dispatcher_reply */

/******************* MPC_Dispatcher_reply ************************************/
Int MPC_Dispatcher_reply(MPC_Queue_element* elem, MPC_Node* leaders)
  {
    Int RC;    

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_reply, leader = %d\n",
                       MPC_Net_global.rank, *leaders);
    RC = iMPC_Dispatcher_reply( elem, leaders);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_reply, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Dispatcher_reply */

/******************* iMPC_Queue_serve ****************************************/
Int iMPC_Queue_serve(MPC_Queue_element* elem, Int* scatter_map, Int* leaders)   
  {
    Int RC;
    Int i;     
    Int j;
    Int k;
    Int* map;
    Int run_out;

    if ((map = malloc((int)(dsp_table_size* sizeof(Int)))) == NULL)
      return MPC_ERR_NOMEM;   

    for (k=0;k<free_size;k++) {
      scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_CMD] = MPC_SKIP;
      scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_RUNOUT] = run_out;
    } /* for */
    for (i = 0;i<elem->numofreqs;i++) {
      RC = MPC_Dispatcher_table_query( map );
      if (RC != MPC_OK)
        return RC;
      RC = (*dsp_topology_strategy)
        (elem->parent,
         elem->requests[i].parent_rank,
         elem->requests[i].numofnodes,
         elem->requests[i].length,
         elem->requests[i].topology,
         dsp_table_size,
         map);
      if (RC != MPC_OK) return RC;
      RC = MPC_Dispatcher_table_add(elem->parent,elem->requests[i].is_static,
                                    map,&(leaders[i]));
      if (RC != MPC_OK) return RC;
      for (j = 0;j<dsp_table_size;j++) {
        if (map[j] >= 0) { 
          RC = MPC_Translate_rank(j,free_comm,&k);               
          if (RC != MPC_OK) return RC;
          scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_CMD] = MPC_HIRED ;
          scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_RANK] = map[j] ;
          scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_NAME] = elem->requests[i].name;
          scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_PARENT] = elem->parent;
          scatter_map[(k*MAX_DISPMSG_SIZE)+DSP_PARAMLEN] = elem->requests[i].numofparams;
        } /* if */  
      } /* for */
    } /* for */        
    free(map);  

    return MPC_OK;
  } /* iMPC_Queue_serve */  

/******************* MPC_Queue_serve *****************************************/   
Int MPC_Queue_serve(MPC_Queue_element* elem, Int* scatter_map, Int* leaders)   
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Queue_serve, free_counter = %d, create_counter = %d\n",
                       MPC_Net_global.rank, dsp_free_counter, dsp_create_counter);
    RC = iMPC_Queue_serve( elem, scatter_map, leaders);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]--MPC_Queue_serve,leader=%d,RC=%d,free_counter=%d,create_counter=%d\n",
                       MPC_Net_global.rank, *leaders, RC, dsp_free_counter, dsp_create_counter);
    return RC;    
  } /* MPC_Queue_serve */  

/******************* iMPC_Queue_process **************************************/
Int iMPC_Queue_process( void )
  { 
    Int RC;
    MPC_Queue_element* temp;
    MPC_Queue_element* prev;
    MPC_Node* leaders;
    Int* scatter_map;
    Int empty_nodes;
    Int freeable_nodes;
    Int power;
    Int min_power;
    Int progress_detected;
    Int i;
 
    empty_nodes = 0;
    freeable_nodes = 0;
    for (i=0;i<dsp_table_size;i++) {
      if (dsp_table[i].parent == -1)
        empty_nodes++;
      if ((dsp_table[i].numofreqs == 0) && (dsp_table[i].is_static==0))
        freeable_nodes++;
    } /* for */     
    min_power = dsp_table_size;              
    prev = NULL;
    temp = dsp_queue;
    
    progress_detected = 0;
    while (temp != NULL) {         
      power = MPC_Element_power(temp);        
      if (power>empty_nodes) { 
        prev = temp;
        temp = temp->next;
        if (power < min_power)
          min_power = power;
      }  
      else { 
        progress_detected = 1;
        if ((leaders=malloc((int)(sizeof(MPC_Node)*(temp->numofreqs))))==NULL)
          return MPC_ERR_NOMEM;
        if ((scatter_map = malloc((int)(sizeof(Int)*MAX_DISPMSG_SIZE*free_size)))==NULL)
          return MPC_ERR_NOMEM;
        RC = MPC_Queue_serve(temp,scatter_map,leaders);
        if (RC != MPC_OK)
          return RC;
        RC = MPC_Dispatcher_table_request(temp->parent,0);
        if (RC != MPC_OK)
          return RC;
        RC = MPC_Dispatcher_hire(scatter_map);
        if (RC != MPC_OK)
          return RC;
        free(scatter_map);
        RC = MPC_Dispatcher_reply(temp,leaders);
        if (RC != MPC_OK)
          return RC;
        empty_nodes -= power;
        free( leaders );  
        if (prev == NULL)
          dsp_queue = temp->next;
        else
          prev->next = temp->next; 
        MPC_Element_done( temp );
        free(temp);
        if (prev == NULL)
          temp = dsp_queue;
        else
          temp = prev->next;
      } /* if */
    } /* while */
    if ((!progress_detected) && (min_power>freeable_nodes))
      return MPC_ERR_DEADLOCK; 
    return MPC_OK;
  } /* iMPC_Queue_process */

/******************* MPC_Queue_process ***************************************/
Int MPC_Queue_process( void )
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Queue_process\n",
                       MPC_Net_global.rank);
    RC = iMPC_Queue_process();
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Queue_process, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Queue_process */

/******************* iMPC_Dispatcher_init ************************************/  
Int iMPC_Dispatcher_init(
  MPC_Error_print error_print,
  MPC_Init_strategy init_strategy,
  MPC_Topology_strategy strategy,
  MPC_Processors_info processors_info )
  {
    Int RC;       
    
    dsp_error_print = error_print;
    dsp_init_strategy = (init_strategy == NULL) ?
      MPC_Trivial_init_strategy : init_strategy;
    dsp_topology_strategy = (strategy == NULL) ?
      MPC_Trivial_strategy : strategy;
    dsp_processors_info = (processors_info == NULL) ?
      MPC_Trivial_processors_info: processors_info;
    RC = MPC_Dispatcher_table_init();
    if (RC != MPC_OK)
      return RC;
    RC = MPC_Dispatcher_queue_init();
    if (RC != MPC_OK)
      return RC;

    RC = (*dsp_init_strategy)();
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_init */

/******************* MPC_Dispatcher_init *************************************/  
Int MPC_Dispatcher_init(
  MPC_Error_print error_print,
  MPC_Init_strategy init_strategy,
  MPC_Topology_strategy strategy,
  MPC_Processors_info processors_info )
  {
    Int RC;       

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_init\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_init(error_print, init_strategy, strategy, processors_info);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_init, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Dispatcher_init */

/******************* iMPC_Dispatcher_done ************************************/
extern void MPC_Dispatcher_local_error(Int,const char*);

Int iMPC_Dispatcher_done(Int exitcode)      
  { 
    Int RC;
    MPC_Dispatcher_table_done();
    MPC_Dispatcher_queue_done();

    RC = I2C(MPI_Barrier(/*MPI_COMM_WORLD*/exit_comm)); /* This barrier is also in MPC_Exit */
    /** Addition 09.12.1999 **/
    if (RC != MPC_OK) return RC;

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * comm free exit_comm
    */
    RC = I2C(MPI_Comm_free(&exit_comm));
    if (RC != MPC_OK) return RC;

    RC = I2C(MPI_Comm_free(&free_comm));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Comm_free(&special_comm));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Comm_free(&log_comm));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Barrier(MPI_COMM_WORLD));
    if (RC != MPC_OK)
      return RC;

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * free the types
    */
    RC = MPC_Done_types();
    if (RC != MPC_OK) return RC;

    if (info_relative_performance != NULL) 
    {
       free(info_relative_performance);
    }

    RC = I2C(MPI_Finalize());

    exit(exitcode);
    return MPC_OK;
  } /* iMPC_Dispatcher_done */

    /******************* MPC_Dispatcher_done *************************************/
    
Int MPC_Dispatcher_done(Int exitcode)      
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_done\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_done( exitcode );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_done, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Dispatcher_done */
  
/******************* MPC_Dispatcher_print_error ******************************/
  Int MPC_Dispatcher_print_error(const char* filename, Int line,
                                 Int column, const char* msg)
  { 
    Int RC;                       
    if (dsp_error_print == NULL)
      printf("%d %d %s %s\n", (int)line, (int)column, filename, msg);
    else
      {         
        RC =(*dsp_error_print)(filename, line, column, msg);
        if (RC != MPC_OK)
          return RC;          
      } /* if */
    return MPC_OK;     
  } /* MPC_Dispatcher_print_error */  
  
/******************* MPC_Dispatcher_error ************************************/
Int MPC_Dispatcher_error(MPC_Node source, const Int* message)
  {
    Int RC;
    MPI_Status status;
    char buffer[MAX_ERRMSG_SIZE];
    char ret_buffer[MPC_ERRRETURN_SIZE]="out ";
    Int line;
    Int column;
    Int filename_length;
    Int error_message_length;

    line = message[MSG_LINE];
    column = message[MSG_COLUMN];
    filename_length = message[MSG_FILENAME_LENGTH];
    error_message_length = message[MSG_ERRMSG_LENGTH];
    RC = I2C(MPI_Recv(buffer,filename_length+error_message_length,MPI_CHAR,
             source,MPC_ERRBODY_TAG,MPI_COMM_WORLD,&status));
    if (RC != MPC_OK) MPC_Exit(RC);
    RC = MPC_Dispatcher_print_error(buffer,line,column,
                                    buffer+(int)(filename_length));
    RC = I2C(MPI_Send(ret_buffer,MPC_ERRRETURN_SIZE,MPI_CHAR,
                      source,MPC_ERRRETURN_TAG,MPI_COMM_WORLD));
    /*MPC_Abort(-1);*/

    return RC;
  } /* MPC_Dispatcher_error */

 
/******************* iMPC_Dispatcher_free_net ********************************/  
Int iMPC_Dispatcher_free_net( Int source, const Int* message )
  { 
    Int RC;
    Int leader;
    Int run_out;
    Int dummy;
    leader = message[MSG_LEADER];
    RC = MPC_Dispatcher_fire(leader, 0);
    if (RC != MPC_OK)
      return RC;
    if (leader != MPC_NULL_LEADER) {
      RC = MPC_Dispatcher_table_free( leader );
      if (RC != MPC_OK) return RC;
    }

    RC = I2C(MPI_Send(&dummy,1,MPI_INT,source,MPC_REPLY_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK)
      return RC;    

    if (dsp_queue != NULL)
      RC = MPC_Queue_process();
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_free_net */

/******************* MPC_Dispatcher_free_net *********************************/  
Int MPC_Dispatcher_free_net( Int source, const Int* message )
  { 
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]->MPC_Dispatcher_free_net parent=%d, free_counter=%d, create_counter=%d\n",
                       MPC_Net_global.rank, source, dsp_free_counter,
                       dsp_create_counter);
    RC = iMPC_Dispatcher_free_net( source, message );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_free_net, RC = %d, free_counter = %d, create_counter = %d\n",
                       MPC_Net_global.rank, RC, dsp_free_counter,
                       dsp_create_counter);
    return RC;    
  } /* MPC_Dispatcher_free_net */

/******************* iMPC_Fill_request ***************************************/
  Int iMPC_Fill_request(MPC_Queue_element* queue_element,
                        Int req_number,MPC_Node parent, const Int* message )
  {
    Int RC;
    Int parent_rank;
    Int param_length;
    Int power;
    Int is_static;
    MPC_Name netname;
    MPC_Topology topology_buffer;
    Int topology_length;
    MPI_Status status;
        
    topology_buffer = NULL;
    netname = message[MSG_NETNAME];
    parent_rank = message[MSG_PARENTRANK];
    topology_length = message[MSG_TOPOLEN];
    param_length = message[MSG_PARAMLEN];
    power = message[MSG_POWER];
    is_static = message[MSG_ISSTATIC];
    if (topology_length > 0) {
      if((topology_buffer = malloc((int)(sizeof(Int)*topology_length))) == NULL)
        return MPC_ERR_NOMEM;
      RC = I2C(MPI_Recv(topology_buffer,topology_length,MPI_INT,
                        parent,MPC_TOPOINF_TAG,MPI_COMM_WORLD,&status));
      if (RC != MPC_OK) return RC;
    } /* if */
    RC = MPC_Request_set(queue_element,req_number,netname,power,param_length,
                         topology_length,topology_buffer,parent_rank,is_static);
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;     
  } /* iMPC_Fill_request */

/******************* MPC_Fill_request ****************************************/
  Int MPC_Fill_request(MPC_Queue_element* queue_element, Int req_number,
                       MPC_Node parent, const Int* message )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Fill_request\n",
                       MPC_Net_global.rank);
    RC = iMPC_Fill_request( queue_element, req_number, parent, message );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Fill_request, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Fill_request */
  
/******************* iMPC_Dispatcher_create_net ******************************/
Int iMPC_Dispatcher_create_net(MPC_Node parent, const Int* message)
  {
    Int RC;
    MPC_Queue_element* queue_element;
    
    if((queue_element=malloc((int)sizeof(MPC_Queue_element)))==NULL)
      return MPC_ERR_NOMEM;
    RC = MPC_Element_init(parent, 1, queue_element);    
    if (RC != MPC_OK)
      return RC;
    RC = MPC_Fill_request(queue_element,0,parent,message);
    if (RC != MPC_OK)
      return RC;
    queue_element->next = dsp_queue;
    dsp_queue = queue_element;    
    RC = MPC_Dispatcher_table_request(parent,1); 
    if (RC != MPC_OK)
      return RC;
    RC = MPC_Queue_process(); 
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_create_net */

/******************* MPC_Dispatcher_create_net *******************************/
Int MPC_Dispatcher_create_net(MPC_Node parent, const Int* message)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Dispatcher_create_net\n",
                       MPC_Net_global.rank);
    RC = iMPC_Dispatcher_create_net( parent, message );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Dispatcher_create_net, RC = %d\n",
                       MPC_Net_global.rank, RC);
    return RC;    
  } /* MPC_Dispatcher_create_net */

/******************* MPC_Dispatcher_printf ***********************************/
Int MPC_Dispatcher_printf(MPC_Node parent, const Int* message)
  {
    Int RC;    
    Int buffer_length;
    MPI_Status status;
    char* buffer;

    buffer_length = message[MSG_PRINTF_LENGTH];
    if ((buffer = malloc(sizeof(char)*buffer_length)) == NULL)
      return MPC_ERR_NOMEM;
    RC = I2C(MPI_Recv(buffer,buffer_length,MPI_CHAR,parent,
                      MPC_PRINTFBODY_TAG,MPI_COMM_WORLD,&status));
    if (RC != MPC_OK)
      return RC;
    printf("%s",buffer);
    fflush(stdout);
    free(buffer);
    return MPC_OK;
  } /* MPC_Dispatcher_printf */  

/*******************  iMPC_Dispatcher_info ***********************************/
Int iMPC_Dispatcher_info(Int source)
  {
    Int RC;

    if (info_relative_performance == NULL) { 
      RC = (dsp_processors_info)(&info_num_of_processors,&info_relative_performance);
      if (RC != MPC_OK)
        return RC; 
    } /* if */
    RC = I2C(MPI_Send(&info_num_of_processors,1,MPI_INT,source,
                      MPC_INFONUM_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Send(info_relative_performance, info_num_of_processors,
                      MPI_DOUBLE, source, MPC_INFOBODY_TAG, MPI_COMM_WORLD));
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_info */

/******************* MPC_Dispatcher_info *************************************/
Int MPC_Dispatcher_info(Int source)
  {
    Int RC;

    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "---[%2d]-> MPC_Dispatcher_info requested by = %d\n",
                        MPC_Net_global.rank, source );
    RC = iMPC_Dispatcher_info(source);
    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "<--[%2d]-- MPC_Dispatcher_info requested by = %d, RC = %d\n",
                        MPC_Net_global.rank, source, RC );
    return RC;
  } /* MPC_Dispatcher_info */

/*******************  iMPC_Dispatcher_free_processes_info *******************/

/* rreddy
 * Requesting the number of free processes
 */
Int iMPC_Dispatcher_free_processes_info
(
    Int source
)
{
    Int i, RC;

    int number_of_free_nodes = MPC_Total_nodes();

    for (i = 0; i < ngroups; i++)
    {
       number_of_free_nodes -= groups[i].numproc;
    }

    RC = MPI_Send(
            &number_of_free_nodes,
            1,
            MPI_INT,
            source,
            MPC_NUMFREEPROCS_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    return MPC_OK;
}

/******************* MPC_Dispatcher_free_processes_info *************************************/
Int MPC_Dispatcher_free_processes_info(Int source)
  {
    Int RC;

    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "---[%2d]-> MPC_Dispatcher_info requested by = %d\n",
                        MPC_Net_global.rank, source );
    RC = iMPC_Dispatcher_free_processes_info(source);
    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "<--[%2d]-- MPC_Dispatcher_info requested by = %d, RC = %d\n", MPC_Net_global.rank, source, RC );
    return RC;
  } /* MPC_Dispatcher_processes_info */

/*******************  MPC_Dispatcher_processes_info *******************/

/* rreddy
 * Messages to get relative performances of the processors
 */
Int iMPC_Dispatcher_processes_info
(
    Int source
)
{
    int RC;
    int i, j, number_of_processes = 0, nump = 0;
    double *relative_performances;

    for (i = 0; i < ngroups; i++)
    {
        number_of_processes += groups[i].maxproc;
    }

    RC = MPI_Send(
            &number_of_processes,
            1,
            MPI_INT,
            source,
            MPC_INFOPROCESSES_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    relative_performances = (double*)malloc(
		                     sizeof(double)
				     *
				     number_of_processes
    );

    if (relative_performances == NULL)
    {
       return MPC_ERR_NOMEM;
    }

    for (i = 0; i < ngroups; i++)
    {
        for (j = 0; j < groups[i].maxproc; j++)
        {
            /*
             * This assumes that paging does not occur.
             * The problem size that each process executes
             * must fit into main memory
             */
	    relative_performances[nump] = (groups[i].processor_power)/(groups[i].maxproc);
	    nump++;
        }
    }

    RC = MPI_Send(
            relative_performances,
            number_of_processes,
            MPI_DOUBLE,
            source,
            MPC_INFOPROCESSES_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    free(relative_performances);

    return MPC_OK;
}

/******************* MPC_Dispatcher_processes_info *************************************/
Int MPC_Dispatcher_processes_info(Int source)
  {
    Int RC;

    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "---[%2d]-> MPC_Dispatcher_info requested by = %d\n",
                        MPC_Net_global.rank, source );
    RC = iMPC_Dispatcher_processes_info(source);
    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "<--[%2d]-- MPC_Dispatcher_info requested by = %d, RC = %d\n", MPC_Net_global.rank, source, RC );
    return RC;
  } /* MPC_Dispatcher_processes_info */

/*******************  MPC_Dispatcher_sync *******************/

/* rreddy
 * Messages to sync the nodes
 */

Int iMPC_Dispatcher_sync
(
    Int source
)
{
    int RC, dummy;

    RC = MPI_Send(
            &dummy,
            1,
            MPI_INT,
            source,
            MPC_SYNC_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    RC = MPI_Send(
            &dummy,
            1,
            MPI_INT,
            0,
            MPC_SYNC_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    return MPC_OK;
}

/******************* MPC_Dispatcher_sync *************************************/
Int MPC_Dispatcher_sync(Int source)
  {
    Int RC;

    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "---[%2d]-> MPC_Dispatcher_info requested by = %d\n",
                        MPC_Net_global.rank, source );
    RC = iMPC_Dispatcher_sync(source);
    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "<--[%2d]-- MPC_Dispatcher_info requested by = %d, RC = %d\n", MPC_Net_global.rank, source, RC );
    return RC;
  } /* MPC_Dispatcher_sync */

/*******************  iMPC_Dispatcher_info_body *********Addition 09.12.1999************/
Int iMPC_Dispatcher_info_body(Int source)
  {
    Int RC;

    if (info_relative_performance == NULL) { 
      RC = (dsp_processors_info)(&info_num_of_processors,&info_relative_performance);
      if (RC != MPC_OK)
        return RC; 
    } /* if */
    RC = I2C(MPI_Send(info_relative_performance, info_num_of_processors,
                      MPI_DOUBLE, source, MPC_HAVEBODY_TAG, MPI_COMM_WORLD));
    if (RC != MPC_OK)
      return RC;
    return MPC_OK;
  } /* iMPC_Dispatcher_info_body */

/******************* MPC_Dispatcher_info_body ************Addition 09.12.1999*************/
Int MPC_Dispatcher_info_body(Int source)
  {
    Int RC;

    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "---[%2d]-> MPC_Dispatcher_info_body requested by = %d\n",
                        MPC_Net_global.rank, source );
    RC = iMPC_Dispatcher_info_body(source);
    if (MPC_DEBUG > 2)
      MPC_Debug_printf( "<--[%2d]-- MPC_Dispatcher_info_body requested by = %d, RC = %d\n",
                        MPC_Net_global.rank, source, RC );
    return RC;
  } /* MPC_Dispatcher_info_body */


/******************* MPC_Dispatcher_local_error ******************************/
void MPC_Dispatcher_local_error( Int RC, const char* operation_name )
  {
    char buffer[255];
    char err_str[MAX_ERR_STR];    

    RC2STR( err_str, RC );
    sprintf(buffer,"Error %s during %s",err_str, operation_name );
    MPC_Dispatcher_print_error( "Dispatcher",0,0,buffer );
    MPC_Abort(RC);    
  } /* MPC_Dispatcher_local_error */
  
/******************* MPC_Dispatcher_run **************************************/

Int MPC_Dispatcher_run(Int* pexitcode)   
  {
    Int RC;
    Int message[MAX_DISPMSG_SIZE];
    Int done, ndones;
    Int tag;    
    Int source;
    MPI_Status status;
    
    done = 0;
    ndones=MPC_Total_nodes();
    while (!done)
      {

        RC = I2C(MPI_Recv(message,MAX_DISPMSG_SIZE,MPI_INT,
               MPI_ANY_SOURCE,MPI_ANY_TAG,MPI_COMM_WORLD,&status));

        tag = status.MPI_TAG;
        source = status.MPI_SOURCE;
        switch(tag)
          {
            case MPC_ERRHEAD_TAG  : 
              {
                RC = MPC_Dispatcher_error(source, message);
                if (RC != MPC_OK) return RC;
                break;
              }
            case MPC_PRINTFHEAD_TAG :
              {
                RC = MPC_Dispatcher_printf(source,message);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "printing a message" );
                break;
              }
            case MPC_CREATENET_TAG :
              {
                RC = MPC_Dispatcher_create_net( source, message );
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "creating a net" );
                break;
              }
            case MPC_FREENET_TAG :
              { 
                RC = MPC_Dispatcher_free_net( source, message );
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "deallocation of a net" );
                break;
              }  
            case MPC_HOSTOUT_TAG :
              { 
                RC = MPC_Dispatcher_out();
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "leaving a waiting point" );
                break;  
              }
            case MPC_ENDWORK_TAG : 
              {
                ndones--;
                *pexitcode = message[MSG_EXITCODE];
                if(ndones==0)
                  done = 1; 
                break;
              }
            case MPC_INFOPROC_TAG:
              {
                RC = MPC_Dispatcher_info(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "requesting processors' information" );
                break;                
              }
            case MPC_GIVEBODY_TAG:
              {
                RC = MPC_Dispatcher_info_body(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "requesting processors' information" );
                break;                
              }
            case MPC_INFOPROCSET_TAG:
              {
                RC = MPC_Dispatcher_set_info(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "requesting topology information" );
                break;                
              }
            case MPC_REQUEST_FOR_ENV_TAG:
              {
                RC = MPC_Dispatcher_send_env(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "requesting topology information" );
                break;                
              }
            case MPC_REQUEST_FOR_REFRESH_TAG:
              {
                RC = MPC_Dispatcher_send_refresh(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "requesting topology information" );
                break;                
              }
            /*
             * Messages to sync the nodes
             */
            case MPC_SYNC_TAG:
              {
                RC = MPC_Dispatcher_sync(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "syncing the nodes" );
                break;                
              }
            /*
	     * Get the relative performances of the processes
	     */
            case MPC_INFOPROCESSES_TAG:
              {
                RC = MPC_Dispatcher_processes_info(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "Requesting relative performances of the processes" );
                break;                
              }
            case MPC_NUMFREEPROCS_TAG:
              {
                RC = MPC_Dispatcher_free_processes_info(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "Requesting number of free processes" );
                break;                
              }
            case MPC_NOTIFY_FREE_TAG:
              {
                RC = MPC_Dispatcher_notify_free_processes(source);
                if (RC != MPC_OK)
                  MPC_Dispatcher_local_error( RC, "Requesting number of free processes" );
                break;                
              }
            default :
              {
                MPC_Dispatcher_local_error( MPC_ERR_UNKNOWNREQUEST, "processing requests" );
              }  
          } /* switch */
      } /* while */
    return MPC_OK;       
  } /* MPC_Dispatcher_run */

/******************* MPC_Init_types ******************************************/
Int MPC_Init_types( void )
  {    
    if ((MPC_CHAR = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_SHORT = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_INT = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_LONG = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_UNSIGNED_CHAR = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_UNSIGNED_SHORT = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_UNSIGNED_LONG = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_UNSIGNED = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_FLOAT = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_DOUBLE = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_LONG_DOUBLE = malloc(sizeof(MPI_Datatype))) == NULL) return MPC_ERR_NOMEM;
    *(MPI_Datatype*)MPC_CHAR = MPI_CHAR;
    *(MPI_Datatype*)MPC_SHORT = MPI_SHORT;
    *(MPI_Datatype*)MPC_INT = MPI_INT;
    *(MPI_Datatype*)MPC_LONG = MPI_LONG;
    *(MPI_Datatype*)MPC_UNSIGNED_CHAR = MPI_UNSIGNED_CHAR;
    *(MPI_Datatype*)MPC_UNSIGNED_SHORT = MPI_UNSIGNED_SHORT;
    *(MPI_Datatype*)MPC_UNSIGNED = MPI_UNSIGNED;
    *(MPI_Datatype*)MPC_UNSIGNED_LONG = MPI_UNSIGNED_LONG;
    *(MPI_Datatype*)MPC_FLOAT = MPI_FLOAT;
    *(MPI_Datatype*)MPC_DOUBLE = MPI_DOUBLE;
#ifndef MPI_LONG_DOUBLE
    *(MPI_Datatype*)MPC_LONG_DOUBLE = MPI_DOUBLE;
#else
    *(MPI_Datatype*)MPC_LONG_DOUBLE = MPI_LONG_DOUBLE;
#endif
    if ((MPC_SUM = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_PROD = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_BOR = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_BXOR = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_MAX = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_MIN = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_LAND = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    if ((MPC_LOR = malloc(sizeof(MPI_Op))) == NULL) return MPC_ERR_NOMEM;
    *(MPI_Op*)MPC_SUM = MPI_SUM;
    *(MPI_Op*)MPC_PROD = MPI_PROD;
    *(MPI_Op*)MPC_BOR = MPI_BOR;
    *(MPI_Op*)MPC_BXOR = MPI_BXOR;
    *(MPI_Op*)MPC_MAX = MPI_MAX;
    *(MPI_Op*)MPC_MIN = MPI_MIN;
    *(MPI_Op*)MPC_LAND = MPI_LAND;
    *(MPI_Op*)MPC_LOR = MPI_LOR;  
    return MPC_OK;    
  } /* MPC_Init_types */

/******************* MPC_Done_types ******************************************/
Int MPC_Done_types( void )
  {
    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * Free all the initialized types
    */
    free(MPC_CHAR);
    free(MPC_SHORT);
    free(MPC_INT);
    free(MPC_LONG);
    free(MPC_UNSIGNED_CHAR);
    free(MPC_UNSIGNED_SHORT);
    free(MPC_UNSIGNED_LONG);
    free(MPC_UNSIGNED);
    free(MPC_FLOAT);
    free(MPC_DOUBLE);
    free(MPC_LONG_DOUBLE);
    free(MPC_SUM);
    free(MPC_PROD);
    free(MPC_BOR);
    free(MPC_BXOR);
    free(MPC_MAX);
    free(MPC_MIN);
    free(MPC_LAND);
    free(MPC_LOR);

    return MPC_OK;     
  } /* MPC_Done_types */

/********************** MPC_Debug_mode *****************************************/
Int MPC_Debug_mode( void )
  {
    char* mode;
    int m;

    mode = getenv(MPC_Debug_env);
    if (mode == NULL) return 0; else return (((m=atoi(mode)) < 4) && (m >= 0))?m:0;     
  } /* MPC_Debug_mode */
  
/******************* iMPC_Init ***********************************************/
Int iMPC_Init( 
  int* pargc, 
  LPPSTR* pargv, 
  MPC_Init_strategy init_strategy,
  MPC_Error_print error_print,
  MPC_Get_env get_env,
  MPC_Topology_strategy strategy,
  MPC_Topology_data topology_data,
  MPC_Processors_info processors_info)
  { 
    Int RC;
    Int pnum;
    Int rank;
    Int size;
    Int color;
    MPI_Comm temp_comm;
    Int exitcode;
    Int env_length;
    Int* environment;
    MPC_Get_env temp_get_env;
    int dummyargc = 0;
    LPPSTR dummyargv = NULL;
    /* !!! */ NULLDEV=fopen("/dev/null","w");
    MPC_DEBUG = MPC_Debug_mode();    
    the_topology_data = (topology_data == NULL) ?  MPC_Trivial_topology_data  : topology_data;
    error_print = (error_print == NULL) ? MPC_Trivial_error_print : error_print;    
    if (pargc == NULL) pargc = &dummyargc;
    if (pargv == NULL) pargv = &dummyargv;

    RC = I2C(MPI_Init( pargc, pargv ));
    if (RC != MPC_OK)
      return RC;

    /* rreddy
     * Each of the processes in MPI_COMM_WORLD sends
     * its processor name using MPI_Get_processor_name to the host.
     * The host allocates a unique integer to each processor name
     * and sends the integer to the process launched on that
     * particular processor.
     */
    
    {
       int gsize;
       int grank;
       char pname[MPI_MAX_PROCESSOR_NAME];

       {
           int i, j, rc;
           int *counts, *displs;
           int plen;
           char *proc_str;
           char (*proc_table)[MPI_MAX_PROCESSOR_NAME];
           int proc_table_size;
           int *proc_array;

           rc = MPI_Comm_size(
                   MPI_COMM_WORLD,
                   &gsize
           );

           rc = I2C(rc);

           if (rc != MPC_OK)
           {
              return rc;
           }

           rc = MPI_Comm_rank(
                   MPI_COMM_WORLD,
                   &grank
           );

           rc = I2C(rc);

           if (rc != MPC_OK)
           {
              return rc;
           }

           if (grank == 0)
           {
              proc_str = (char*)malloc(
                         sizeof(char)
                         *
                         (MPI_MAX_PROCESSOR_NAME)*(gsize)
              );

              if (proc_str == NULL)
              {
                 return MPC_ERR_NOMEM;
              }

              proc_table = (char (*) [MPI_MAX_PROCESSOR_NAME])malloc(
                           sizeof(char[MPI_MAX_PROCESSOR_NAME])
                           *
                           gsize
              );

              if (proc_table == NULL)
              {
                 return MPC_ERR_NOMEM;
              }

              proc_array = (int*)malloc(
                           sizeof(int)
                           *
                           gsize
              );

              if (proc_array == NULL)
              {
                 return MPC_ERR_NOMEM;
              }

           }

           rc = MPI_Get_processor_name(
                   pname,
                   &plen
           );

           rc = I2C(rc);

           if (rc != MPC_OK)
           {
              return rc;
           }

           if (grank == 0)
           {
              counts = (int*)malloc(
                               sizeof(int)
                               *
                               gsize
              );

              if (counts == NULL)
              {
                 return MPC_ERR_NOMEM;
              }

              displs = (int*)malloc(
                               sizeof(int)
                               *
                               gsize
              );

              if (displs == NULL)
              {
                 return MPC_ERR_NOMEM;
              }

              for (i = 0; i < gsize; i++)
              {
                  counts[i] = MPI_MAX_PROCESSOR_NAME;
                  displs[i] = (i*MPI_MAX_PROCESSOR_NAME);
              }
           }

           if (grank == 0)
           {
              rc = MPI_Gatherv(
                      &pname,
                      MPI_MAX_PROCESSOR_NAME,
                      MPI_CHAR,
                      proc_str,
                      counts,
                      displs,
                      MPI_CHAR,
                      0,
                      MPI_COMM_WORLD
              );

              rc = I2C(rc);

              if (rc != MPC_OK)
              {
                 return rc;
              }
           }
           else
           {
              rc = MPI_Gatherv(
                      &pname,
                      MPI_MAX_PROCESSOR_NAME,
                      MPI_CHAR,
                      NULL,
                      NULL,
                      NULL,
                      MPI_CHAR,
                      0,
                      MPI_COMM_WORLD
              );

              rc = I2C(rc);

              if (rc != MPC_OK)
              {
                 return rc;
              }
           }

           if (grank == 0)
           {
              strncpy(
                 proc_table[0],
                 proc_str,
                 MPI_MAX_PROCESSOR_NAME
              );

              proc_table_size = 1;
              for (i = 0; i < gsize; i++)
              {
                  int entry_found = 0;
                  char* tmp = proc_str
                              +
                              (i)*(MPI_MAX_PROCESSOR_NAME)
                  ;

                  for (j = 0; j < proc_table_size; j++)
                  {
                      if (strncmp(
                             tmp,
                             proc_table[j],
                             MPI_MAX_PROCESSOR_NAME
                         )
                         == 0
                      )
                      {
                         entry_found = 1;
                         break;
                      }
                  }

                  if (!entry_found)
                  {
                     proc_table_size++;

                     strncpy(
                        proc_table[(proc_table_size - 1)],
                        tmp,
                        MPI_MAX_PROCESSOR_NAME
                     );
                  }
              }

              for (i = 0; i < gsize; i++)
              {
                  char* tmp = proc_str
                              +
                              (i)*(MPI_MAX_PROCESSOR_NAME)
                  ;

                  for (j = 0; j < proc_table_size; j++)
                  {
                      if (strncmp(
                             tmp,
                             proc_table[j],
                             MPI_MAX_PROCESSOR_NAME
                         )
                         == 0
                      )
                      {
                         proc_array[i] = j;
                      }
                  }
              }
           }

           if (grank == 0)
           {
              for (i = 0; i < gsize; i++)
              {
                  counts[i] = 1;
                  displs[i] = i;

              }

              rc = MPI_Scatterv(
                      proc_array,
                      counts,
                      displs,
                      MPI_INT,
                      &pnum,
                      1,
                      MPI_INT,
                      0,
                      MPI_COMM_WORLD
              );

              rc = I2C(rc);

              if (rc != MPC_OK)
              {
                 return rc;
              }
           }
           else
           {
              rc = MPI_Scatterv(
                      NULL,
                      NULL,
                      NULL,
                      MPI_INT,
                      &pnum,
                      1,
                      MPI_INT,
                      0,
                      MPI_COMM_WORLD
              );

              rc = I2C(rc);

              if (rc != MPC_OK)
              {
                 return rc;
              }
           }

           if (grank == 0)
           {
              free(counts);
              free(displs);
              free(proc_str);
              free(proc_table);
              free(proc_array);
           }
       }
    }
    
    /*
     * The processor number of the VPM is now known
     */
    MPC_Processor_number = pnum;

    RC = MPC_Init_types();
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Comm_rank(MPI_COMM_WORLD,&rank));
    if (RC != MPC_OK)
      return RC;
    RC = I2C(MPI_Comm_size(MPI_COMM_WORLD,&size));
    if (RC != MPC_OK)
      return RC;
    dispatcher = size-1;
    if ((recon_net_MASK = malloc(sizeof(Int)*size)) == NULL)
      return MPC_ERR_NOMEM;

    /* creating special comm aimed for intercommunicators */
       {
	  int ierr;
	  
	  ierr=MPI_Comm_dup(MPI_COMM_WORLD,&special_comm);
	  RC=I2C(ierr);
          if (RC != MPC_OK) return RC;
        }
    
    /* communicator for parallel exit barrier */
    RC = I2C(MPI_Comm_dup(MPI_COMM_WORLD,&exit_comm));
    if (RC != MPC_OK) return RC;
    
    /* creating special comm aimed for log messages */
    RC = I2C(MPI_Comm_dup(MPI_COMM_WORLD,&log_comm));
    if (RC != MPC_OK) return RC;
    
    /* creating free_comm dispatcher+all free nodes */    
    color = (rank==0)? MPI_UNDEFINED : 0;
    
    RC = I2C(MPI_Comm_split(MPI_COMM_WORLD,color,rank-1,&free_comm));
    if (RC != MPC_OK) return RC;
    if (rank != 0) {
      RC = I2C(MPI_Comm_size(free_comm,&free_size));
      if (RC != MPC_OK) return RC;
    } /* if */
    /* creating MPC_Global_net = host+all free nodes. */
    MPC_Net_global.type = &MPC_Trivial_type;
    MPC_Net_global.count = 1;
    MPC_Net_global.params = MPC_Net_global_parameters;
    MPC_Net_global.params[0] = size-1;
    MPC_Net_global.is_static = 1;
    MPC_Net_global.rank = rank;
    MPC_Net_global.power = size-1;
    MPC_Net_global.supernet = NULL;
    MPC_Net_global.mapping = NULL;
    if ((MPC_Net_global.pweb = malloc(sizeof(MPI_Comm))) == NULL)
      return MPC_ERR_NOMEM;
    color = (rank==(size-1))? MPI_UNDEFINED : 0;
    RC = I2C(MPI_Comm_split(MPI_COMM_WORLD,color,rank,(MPI_Comm*)(MPC_Net_global.pweb)));
    if (RC != MPC_OK)
      return RC;
    /* creating MPC_Net_recon = 1 process for each physical processor node. */
    MPC_Net_recon.type = &MPC_Trivial_type;
    MPC_Net_recon.count = 1;
    MPC_Net_recon.params = MPC_Net_recon_parameters;
    MPC_Net_recon.is_static = 1;
    MPC_Net_recon.supernet = NULL;
    MPC_Net_recon.mapping = NULL;
    /* creating MPC_Host_net */
    if (rank != 0)
      MPC_Net_host.pweb = MPC_NULL_WEB;
    else {
      if ((MPC_Net_host.pweb = malloc(sizeof(MPI_Comm))) == NULL)
        return MPC_ERR_NOMEM;
      (*(MPI_Comm*)(MPC_Net_host.pweb)) = MPI_COMM_SELF;
      MPC_Net_host.type = &MPC_Trivial_type;
      MPC_Net_host.count = 0;
      MPC_Net_host.params = NULL;
      MPC_Net_host.is_static = 1;
      MPC_Net_host.rank = 0;
      MPC_Net_host.power = 1;
      MPC_Net_host.supernet = NULL;
      MPC_Net_host.mapping = NULL;
    } /* if */

    /* Error Handling */

    RC = MPI_Errhandler_create(MPC_ErrorHandler,&Err_handler);
    if (RC != MPC_OK)
      return RC;
    RC = MPI_Errhandler_set(MPI_COMM_WORLD,Err_handler);
    if (RC != MPC_OK)
      return RC;
    
    /* -------------- */
    
    if (rank == 0) 
      {
        temp_get_env = (get_env == NULL) ? MPC_Trivial_get_env : get_env;        
        RC = (*temp_get_env) (size-1,pargc,pargv,&env_length,&environment);
        if (RC != MPC_OK)
          return RC;
        RC = MPC_Env_send(env_length,environment);
        if (RC != MPC_OK)
          return RC;
        free(environment);
      } /* if */  
    if (rank != dispatcher) { 
      Int num_of_processors;
      double* relative_performance;
      Int r_net_S = -1;

      RC = I2C(MPI_Barrier(MPI_COMM_WORLD));
      if (RC != MPC_OK)
        return RC;

      if ((MPC_Net_recon.pweb = malloc(sizeof(MPI_Comm))) == NULL)
        return MPC_ERR_NOMEM;
      
      RC=I2C(MPI_Scatter((void*)recon_net_MASK,1,MPI_INT,&recon_net_V,1,
                         MPI_INT,dispatcher,MPI_COMM_WORLD));
      if (RC != MPC_OK)
        return RC;
      if (recon_net_V != 1)
        recon_net_V = MPI_UNDEFINED;
      
      if (MPC_DEBUG)
        MPC_Debug_printf( "---[%2d]-: MPC_Net_recon trace 1: recon_net_V=%d\n",
                          MPC_Net_global.rank,recon_net_V);
      RC = I2C(MPI_Comm_split(MPI_COMM_WORLD,recon_net_V,rank,
                              (MPI_Comm*)(MPC_Net_recon.pweb)));
      if (RC != MPC_OK)
        return RC;
      if (recon_net_V != 1)
      {
        /*
        * Fixing Memory Leaks
        * rreddy BUG# 00003 MODULE MPC
        * Heterogeneous ScaLAPACK
        * free recon for processes not part of recon
        */
        free(MPC_Net_recon.pweb);

        MPC_Net_recon.pweb = MPC_NULL_WEB;
      }
      else {
        RC = I2C(MPI_Comm_size(*(MPI_Comm*)(MPC_Net_recon.pweb),&r_net_S));
        if (RC != MPC_OK)
          return RC;
        MPC_Net_recon.power = MPC_Net_recon.params[0] = r_net_S;
        RC = I2C(MPI_Comm_rank(*(MPI_Comm*)(MPC_Net_recon.pweb),&MPC_Net_recon.rank));
        if (RC != MPC_OK)
          return RC;
      }
      RC = MPC_Processors_static_info( &num_of_processors, &relative_performance );
      if (RC != MPC_OK)
        return RC;

      if (MPC_DEBUG)
        MPC_Debug_printf( "---[%2d]-:MPC_Net_recon trace 2: r_net_S=%d,num_of_processors=%d\n",
                          MPC_Net_global.rank,r_net_S,num_of_processors);
      RC = MPC_Local_barrier(&MPC_Net_global);
      if (RC != MPC_OK)
        return RC;
    }
    else {

      RC = MPC_Dispatcher_init( error_print, init_strategy, strategy, processors_info );
      if (RC != MPC_OK)
        return RC;
      
      RC = I2C(MPI_Barrier(MPI_COMM_WORLD));
      if (RC != MPC_OK)
        return RC;         

      if ((MPC_Net_recon.pweb = malloc(sizeof(MPI_Comm))) == NULL)
        return MPC_ERR_NOMEM;
      
      RC=I2C(MPI_Scatter((void*)recon_net_MASK,1,MPI_INT,&recon_net_V,1,
                         MPI_INT,dispatcher,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;

      if (MPC_DEBUG)
        MPC_Debug_printf( "-d-[%2d]-: MPC_Net_recon trace 1: recon_net_V=%d\n",
                          MPC_Net_global.rank,recon_net_V);
      
      RC = I2C(MPI_Comm_split(MPI_COMM_WORLD,MPI_UNDEFINED,
                              rank,(MPI_Comm*)(MPC_Net_recon.pweb)));
      if (RC != MPC_OK)
        return RC;

      /*
      * Fixing Memory Leaks
      * rreddy BUG# 00003 MODULE MPC
      * Heterogeneous ScaLAPACK
      * free recon for dispatcher
      */
      free(MPC_Net_recon.pweb);

      MPC_Net_recon.pweb = MPC_NULL_WEB;

      RC = MPC_Dispatcher_run(&exitcode);
      if (RC != MPC_OK)
        return RC;

      if (MPC_DEBUG)
        MPC_Debug_printf( "-d-[%2d]-: MPC_Net_recon trace 2: next - _done\n",
                          MPC_Net_global.rank,recon_net_V);
      
      RC = MPC_Dispatcher_done(exitcode);
      if (RC != MPC_OK)
        return RC;
    } /* if */

    /*
     * rreddy: Abstract network for all free processes.
     */
    {
       int global_rank;
       int free_rank;
       MPI_Comm comm = *(MPI_Comm*)(MPC_Net_global.pweb);
       int color;

       {
          int result = MPI_Comm_rank(
                          comm,
                          &global_rank
          );

          result = I2C(result);

          if (result != MPC_OK)
          {
             return result;
          }
       }

       color = (rank == 0)
                ?
                MPI_UNDEFINED
                :
                0
       ;

       {
          int result = MPI_Comm_split(
                          comm,
                          color,
                          global_rank - 1,
                          &hmpi_free_comm
          );

          result = I2C(result);

          if (result != MPC_OK)
          {
             return result;
          }
       }

       /*
        * All free processes except the host are part of 
        * abstract network HMPI_FREE.
        */
       if (rank == 0)
       {
          return MPC_OK;
       }

       {
          int result = MPI_Comm_size(
                          hmpi_free_comm,
                          &hmpi_free_comm_size
          );

          result = I2C(result);

          if (result != MPC_OK)
          {
             return result;
          }
       }

       {
          int result = MPI_Comm_rank(
                          hmpi_free_comm,
                          &free_rank
          );

          result = I2C(result);

          if (result != MPC_OK)
          {
             return result;
          }
       }

       /*
        * Net parameters, net type, net count probably
        * should have some trivial values.
        */
       MPC_Net_free_procs.type = &MPC_Trivial_type;
       MPC_Net_free_procs.count = 1;
       MPC_Net_free_procs.params = NULL;
       MPC_Net_free_procs.is_static = 1;
       MPC_Net_free_procs.rank = free_rank;
       MPC_Net_free_procs.power = hmpi_free_comm_size;
       MPC_Net_free_procs.supernet = NULL;
       MPC_Net_free_procs.mapping = NULL;
       MPC_Net_free_procs.pweb = (MPI_Comm*)malloc(sizeof(MPI_Comm));

       if (MPC_Net_free_procs.pweb == NULL)
       {
          return MPC_ERR_NOMEM;
       }

       (*(MPI_Comm*)(MPC_Net_free_procs.pweb)) = hmpi_free_comm;

    }

    return MPC_OK;
  } /* iMPC_Init */

/******************* MPC_Init ************************************************/
Int MPC_Init( 
  int* pargc, 
  LPPSTR* pargv, 
  MPC_Init_strategy init_strategy,
  MPC_Error_print error_print,
  MPC_Get_env get_env,
  MPC_Topology_strategy strategy,
  MPC_Topology_data topology_data,
  MPC_Processors_info processors_info)
  { 
    Int RC;
    char err_str[MAX_ERR_STR];

    RC = iMPC_Init(pargc, pargv, init_strategy, error_print,
                   get_env, strategy, topology_data, processors_info);
    if ((RC != MPC_OK) && (MPC_Error_test))
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<======== MPC error %s during MPC_Init\n", err_str );
        MPC_Abort(RC);        
        exit(RC);
      } /* if */
    if (MPC_DEBUG) 
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Init\n", MPC_Net_global.rank );
      }
    return RC;
  } /* MPC_Init */

/******************* iMPC_Abort **********************************************/
Int iMPC_Abort( Int errcode )
  {
    MPI_Abort(MPI_COMM_WORLD, errcode);
    return MPC_OK;
  } /* iMPC_Abort */   

/******************* MPC_Abort ***********************************************/
Int MPC_Abort( Int errcode )
  {
    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "---[%2d]-> MPC_Abort\n",MPC_Net_global.rank);
      } /* if */
    return iMPC_Abort( errcode );
  } /* MC_Init */
  
/******************* iMPC_Host_out *******************************************/
/*
 * Parent of a group notifies dispatcher to command the free processes
 * to exit waiting point
 */
Int iMPC_Notify_free_processes( void )
  { 
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    Int dum;
    MPI_Status status;
    
    RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                      MPC_NOTIFY_FREE_TAG,MPI_COMM_WORLD ));

    if (RC != MPC_OK) return RC; 

    RC = I2C(MPI_Recv(&dum, 1, MPI_INT, dispatcher,
                      MPC_NOTIFY_FREE_TAG, MPI_COMM_WORLD, &status ));

    if (RC != MPC_OK) return RC; 

    return MPC_OK;
  } /* iMPC_Notify_free_processes */ 

/******************* MPC_Notify_free_processes ********************************************/
Int MPC_Notify_free_processes( void )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "---[%2d]-> MPC_Notify_free_processes\n",MPC_Net_global.rank);
      } /* if */
    RC = iMPC_Notify_free_processes();
    if (RC != MPC_OK) 
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Notify_free_processes\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "<--[%2d]-- MPC_Notify_free_processes\n",MPC_Net_global.rank);
      } /* if */
    return RC;
  } /* MPC_Notify_free_processes */

/******************* iMPC_Host_out *******************************************/
Int iMPC_Host_out( void )
  { 
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    
    if (!MPC_Is_host()) return MPC_ERR_PRIV;
    RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                      MPC_HOSTOUT_TAG,MPI_COMM_WORLD ));
    if (RC != MPC_OK) return RC; 
    return MPC_OK;
  } /* iMPC_Host_out */ 

/******************* MPC_Host_out ********************************************/
Int MPC_Host_out( void )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "---[%2d]-> MPC_Host_out\n",MPC_Net_global.rank);
      } /* if */
    RC = iMPC_Host_out();
    if (RC != MPC_OK) 
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Host_out\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "<--[%2d]-- MPC_Host_out\n",MPC_Net_global.rank);
      } /* if */
    return RC;
  } /* MPC_Host_out */

/******************* iMPC_Send_end ********************************************/
Int iMPC_Send_end( void )
  {
    Int RC;    

    RC = I2C(MPI_Send(NULL,0,MPI_INT,0,MPC_SENDEND_TAG,MPI_COMM_WORLD));
    return RC; 
  } /* iMPC_Send_end( void ) */

/******************* MPC_Send_end *********************************************/
Int MPC_Send_end( void )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "---[%2d]-> MPC_Send_end\n",MPC_Net_global.rank);
      } /* if */
    RC = iMPC_Send_end();
    if (RC != MPC_OK) 
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Send_end\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "<--[%2d]-- MPC_Send_end\n",MPC_Net_global.rank);
      } /* if */
    return RC;
  } /* MPC_Send_end */

/******************* iMPC_Recv_end ********************************************/
Int iMPC_Recv_end( Int count )
  {
    Int RC;
    MPI_Status status;
    Int i;

    for (i=0;i<count;i++) {
      RC = I2C(MPI_Recv(NULL,0,MPI_INT,MPI_ANY_TAG,MPC_SENDEND_TAG,
                        MPI_COMM_WORLD,&status));
      if (RC != MPC_OK)
        return RC;
    } /* for */
    return MPC_OK;
  } /* iMPC_Recv_end( void ) */

/******************* MPC_Recv_end *********************************************/
Int MPC_Recv_end( int count )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "---[%2d]-> MPC_Recv_end\n",MPC_Net_global.rank);
      } /* if */
    RC = iMPC_Recv_end( count );
    if (RC != MPC_OK) 
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Recv_end\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG) 
      {
         MPC_Debug_printf( "<--[%2d]-- MPC_Recv_end\n",MPC_Net_global.rank);
      } /* if */
    return RC;
  } /* MPC_Recv_end */

/******************* MPC_Free_static_nets *************************************/
Int MPC_Free_static_nets( void )
  {
    Int RC;
    MPC_Net* temp;
    Int cmd;

    RC = MPC_Global_barrier();
    if (RC != MPC_OK) return RC;
    RC = MPC_Waiting_point_begin( MPC_UNDEFINED_COUNT, MPC_UNDEFINED_COUNT);
    while (static_stack != NULL) {    
      temp = static_stack->subnet_next;
      RC = MPC_Net_free( static_stack );
      if (RC != MPC_OK) return RC;
      static_stack = temp;
    } /* while */
    if (!MPC_Is_busy()) {
      RC = MPC_Offer(&cmd,NULL,NULL,0);
      if (RC != MPC_OK) return RC;
    } /* if */
    if (MPC_Is_host()) {
      RC = MPC_Host_out();
      if (RC != MPC_OK) return RC;
    } /* if */
    RC = MPC_Waiting_point_end();
    if (RC != MPC_OK) return RC;
    return MPC_OK; 
  } /* MPC_Free_static_nets */
  
/******************* iMPC_Exit ************************************************/
Int iMPC_Exit( Int exitcode )
  {     
    Int RC;
    Int message[MAX_DISPMSG_SIZE];
    Int rank;
    RC = I2C(MPI_Comm_rank(MPI_COMM_WORLD,&rank));
    if (RC != MPC_OK) return RC;
    /*if (MPC_Is_host()) **09.12.1999*/ {
      MPI_Request     rq;      
      message[MSG_EXITCODE]=exitcode;
      RC = I2C(MPI_Send(message,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                        MPC_ENDWORK_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
    } /* if */
    /*RC = I2C(MPI_Barrier(MPI_COMM_WORLD));**09.12.1999*/  /* This barrier is also in MPC_Dispatcher_Done */

    RC = I2C(MPI_Barrier(exit_comm));/**Addition 09.12.1999**/
    if (RC != MPC_OK) return RC;  

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * comm free exit_comm
    */
    RC = I2C(MPI_Comm_free(&exit_comm));
    if (RC != MPC_OK) return RC;

    if (!MPC_Is_busy()) {
      RC = I2C(MPI_Comm_free(&free_comm));     
      if (RC != MPC_OK) return RC;
    } /* if */

    RC = I2C(MPI_Comm_free(MPC_Net_global.pweb));
    if (RC != MPC_OK) return RC;

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * Freeing recon
    */
    free(MPC_Net_global.pweb);

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * Freeing host
    */
    if (MPC_Net_host.pweb != MPC_NULL_WEB) {
       free(MPC_Net_host.pweb);
    }
    
    if (MPC_Net_recon.pweb != MPC_NULL_WEB) {
      RC = I2C(MPI_Comm_free(MPC_Net_recon.pweb));
      if (RC != MPC_OK) return RC;

      /*
      * Fixing Memory Leaks
      * rreddy BUG# 00003 MODULE MPC
      * Heterogeneous ScaLAPACK
      * Freeing recon
      */
      free(MPC_Net_recon.pweb);

    }
    RC = I2C(MPI_Comm_free(&special_comm));
    if (RC != MPC_OK) return RC;
    
    RC = I2C(MPI_Comm_free(&log_comm));
    if (RC != MPC_OK) return RC;

    /* rreddy
     * Free the communicator associated with abstract network
     * HMPI_FREE
     */
    if (rank != 0)
    {
       int result = MPI_Comm_free(&hmpi_free_comm);

       result = I2C(result);

       if (result != MPC_OK)
       {
          return result;
       }

       /*
       * Fixing Memory Leaks
       * rreddy BUG# 00003 MODULE MPC
       * Heterogeneous ScaLAPACK
       * Freeing the mask
       */
       free(MPC_Net_free_procs.pweb);
    }

    RC = MPC_Done_types();
    if (RC != MPC_OK) return RC;  

    if (info_relative_performance != NULL)
    {
       free(info_relative_performance);
    }

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * Freeing the mask
    */
    free(recon_net_MASK);

    RC = I2C(MPI_Barrier(MPI_COMM_WORLD));
    if (RC != MPC_OK) return RC;  
    RC = I2C(MPI_Finalize());
    fclose(NULLDEV);
    exit((int)exitcode);
    return MPC_OK;
  } /* iMPC_Exit */

/******************* MPC_Exit ************************************************/
Int MPC_Exit( Int exitcode )
  {     
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG) 
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Exit, exitcode = %d\n",
                          MPC_Net_global.rank, exitcode);
      } /* if */
    RC = iMPC_Exit( exitcode );
    if (RC != MPC_OK) 
      {
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Exit\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    return MPC_OK;
  } /* MPC_Exit */
  
/******************* MPC_Test_net*********************************************/
Int MPC_Test_net(const MPC_Net* net)
  {
    if (net == NULL) return MPC_ERR_INVNET;
    if (net->rank < 0) return MPC_ERR_INVNET;
    if (net->pweb == MPC_NULL_WEB) return MPC_ERR_INVNET;
    if ((*(MPI_Comm*)(net->pweb)) == MPI_COMM_NULL)
      return MPC_ERR_INVNET;
    return MPC_OK;
  } /* MPC_Test_net */

/******************* iMPC_Net_info_send **************************************/
Int iMPC_Net_info_send(
  MPC_Name name,
  MPC_Net* net )
  {
    Int RC;
    Int topology_length;
    Int* topology_buffer;
    MPC_Topology_free free_function;
    Int request[MAX_DISPMSG_SIZE];

    RC = the_topology_data( net, &topology_length,
                            &topology_buffer, &free_function);
    if (RC != MPC_OK) return RC;
    request[MSG_NETNAME] = name;  
    request[MSG_PARENTRANK] = MPC_Parent(net);
    request[MSG_TOPOLEN] = topology_length;
    request[MSG_PARAMLEN] = net->count;
    request[MSG_POWER] = MPC_Power(net);
    request[MSG_ISSTATIC] = net->is_static;
    RC = I2C(MPI_Send(request,MAX_DISPMSG_SIZE,MPI_INT,
                      dispatcher,MPC_CREATENET_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) return RC;
    if (topology_length != 0) {
      RC = I2C(MPI_Send(topology_buffer,topology_length,
                        MPI_INT,dispatcher,MPC_TOPOINF_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      (*free_function)( net );
    } /* if */
    return MPC_OK; 
  } /* iMPC_Net_info_send */

/******************* MPC_Net_info_send ***************************************/
Int MPC_Net_info_send(
  MPC_Name name,
  MPC_Net* net )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Net_info_send\n",
                                         MPC_Global_rank());
    RC = iMPC_Net_info_send(name, net);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Net_info_send, RC = %d\n",
                        MPC_Global_rank(), RC);
    return RC;
  } /* MPC_Net_info_send */

/******************* iMPC_Net_info_recv **************************************/
Int iMPC_Net_info_recv(
  MPC_Net* net )
  {
    Int RC;
    Int leader;
    MPI_Status status;

    RC = I2C(MPI_Recv(&leader,1,MPI_INT,dispatcher,
                      MPC_REPLY_TAG,MPI_COMM_WORLD,&status));
    if (RC != MPC_OK) return RC;
    net->leader = leader;
    return MPC_OK;
  } /* iMPC_Net_info_recv */

/******************* MPC_Net_info_recv ***************************************/
Int MPC_Net_info_recv(
  MPC_Net* net )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Net_info_recv\n",MPC_Global_rank());
    RC = iMPC_Net_info_recv( net );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Net_info_recv, leader = %d, RC = %d\n",
                        MPC_Global_rank(), net->leader, RC);
    return RC;
  } /* MPC_Net_info_recv */

/******************* iMPC_Web_create *****************************************/
Int iMPC_Web_create( 
  MPC_Net* net, 
  MPI_Comm comm )
  {
    Int i;
    Int cachesize;

    cachesize = (net->oldroot != MPC_MULTI_ROOT) ? 0 : net->power;
    if ((net->pweb = malloc(sizeof(MPI_Comm)*(1+cachesize))) == NULL)
      return MPC_ERR_NOMEM;
    (*(MPI_Comm*)(net->pweb)) = comm;
    for(i=1;i<cachesize+1;i++)
      ((MPI_Comm*)(net->pweb))[i] = MPI_COMM_NULL;
    return MPC_OK;
  } /* iMPC_Web_create */

/******************* MPC_Web_create ******************************************/
Int MPC_Web_create( 
  MPC_Net* net, 
  MPI_Comm comm )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Web_create\n", MPC_Global_rank());
    RC = iMPC_Web_create( net, comm );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Web_create, RC = %d\n",
                       MPC_Global_rank(), RC);
    return RC;
  } /* MPC_Web_create */ 

/******************* iMPC_Web_free *******************************************/
Int iMPC_Web_free( MPC_Net* net ) 
  {
    Int RC;
    Int i;

    Int cachefrom;
    Int cacheto;

    if (net->pweb != MPC_NULL_WEB) {
      cachefrom = (net->oldroot != MPC_MULTI_ROOT) ? 0 : 1;
      cacheto   = (net->oldroot != MPC_MULTI_ROOT) ? 1 : net->power+1;
      for(i=cachefrom;i<cacheto;i++) {
        if (
             (
              ((MPI_Comm*)(net->pweb))[i] != MPI_COMM_NULL
             ) &&
             (
              ((MPI_Comm*)(net->pweb))[i] != MPI_COMM_SELF
             )
           ) {
          RC = I2C(MPI_Comm_free(((MPI_Comm*)(net->pweb))+i));
          if (RC != MPC_OK) return RC;
        }  
        ((MPI_Comm*)(net->pweb))[i] = MPI_COMM_NULL;
      } /* for */
      free( net->pweb );
      net->pweb = MPC_NULL_WEB;
    }
    return MPC_OK;    
  } /* iMPC_Web_free */ 

/******************* MPC_Web_free ********************************************/
Int MPC_Web_free(
  MPC_Net* net )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Web_free, power = %d, net->pweb = %p\n",
                       MPC_Global_rank(), net->power, net->pweb);
    RC = iMPC_Web_free(net);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Web_free, RC = %d\n",
                       MPC_Global_rank(), RC);
    return RC;
  } /* MPC_Web_free */ 

/******************* iMPC_Net_info_process ***********************************/
Int iMPC_Net_info_process(
  MPC_Net* net )
  {
    Int RC;
    MPI_Comm united_comm;
    MPI_Comm ordered_comm;

    RC = MPC_Comm_unite( MPI_COMM_SELF, 0, net->leader, &united_comm, 0);
    if (RC != MPC_OK) return RC;

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    * The ordered_comm here must be freed somewhere
    * It is resulting in leaks
    */
    RC = I2C(MPI_Comm_split( united_comm, 1, net->rank, &ordered_comm ));
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Comm_free( &united_comm ));
    if (RC != MPC_OK) return RC;
    if (net->count > 0) {
      RC = I2C(MPI_Bcast(net->params,net->count,MPI_INT,
                         net->rank,ordered_comm));
      if (RC != MPC_OK) return RC;
    } /* if */
    RC = MPC_Web_create( net, ordered_comm );
    if (RC != MPC_OK) return RC;
    if (net->count>0) {
      RC = MPC_Set_web_root(net, MPC_Parent(net));
      if (RC != MPC_OK) return RC;
    }
    return MPC_OK;    
  } /* iMPC_Net_info_process */

/******************* MPC_Net_info_process ************************************/
Int MPC_Net_info_process(
  MPC_Net* net )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Net_info_process\n",
                       MPC_Global_rank());
    RC = iMPC_Net_info_process(net);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Net_info_process, RC = %d\n",
                       MPC_Global_rank(), RC);
    return RC;
  } /* MPC_Net_info_process */


/******************* iMPC_Net_create *****************************************/  
Int iMPC_Net_create(
  MPC_Name name,           /* static identifier of the net to create */
  MPC_Net* net )           /* net descriptor */
  { 
    Int RC;

    if (MPC_Power(net) <= 0) return MPC_ERR_POWER;

    RC = MPC_Net_info_send(name,net);
    if (RC != MPC_OK) return RC;
    net->rank = MPC_Parent(net);
    net->power = MPC_Power(net);
    if ((net->power) == 1) {
      RC = MPC_Net_info_recv(net);
      if (RC != MPC_OK) return RC;
      RC = MPC_Web_create( net, MPI_COMM_SELF );
      net->leader = MPC_NULL_LEADER;
    }
    else { 

      RC = MPC_Net_info_recv(net);
      if (RC != MPC_OK) return RC;

      RC = MPC_Net_info_process(net);
      if (RC != MPC_OK) return RC;          
    } /* if */
    MPC_Coord_set( net, net->rank );
    if (net->is_static) {  
      net->subnet_next = static_stack;
      static_stack = net;
    } /* if */
    return MPC_OK;
  } /* iMPC_Net_create */

/******************* MPC_Net_create ******************************************/
Int MPC_Net_create(
  MPC_Name name,           /* static identifier of the net to create */
  MPC_Net* net )           /* net descriptor */
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Net_create, name = %d\n",
                          MPC_Net_global.rank, name );
      } /* if */
    RC = iMPC_Net_create(name,net);
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Net_create\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Net_create\n",
                          MPC_Net_global.rank );
      } /* if */
    return RC; 
  } /* MPC_Net_create */
  
/******************* iMPC_Net_free *******************************************/
Int iMPC_Net_free( MPC_Net* net )
  {
    Int RC;                 
    Int am_parent;
    Int message[MAX_DISPMSG_SIZE];
    MPC_Net* temp; 
    MPC_Net* tempnext;
    Int dummy;
    MPI_Status status;
    
    temp = net->subnet_list;
    while (temp != NULL) {
      tempnext = temp->subnet_next;
      MPC_Net_free( temp );
      temp = tempnext;
    } /* while */   
    if (MPC_Is_subnet( net )) {
      if (net->pweb != MPC_NULL_WEB)  MPC_Web_free( net );
      net->rank = MPC_UNINITED_RANK;
      if ((net->mapping) != NULL) {
        free(net->mapping);
        net->mapping = NULL;
      } /* if */
    }
    else {
      RC = MPC_Test_net( net );
      if (RC != MPC_OK) return RC;
      am_parent = MPC_Is_parent(net); 
      if (net->pweb != MPC_NULL_WEB) {
        RC = MPC_Local_barrier(net);
        if (RC != MPC_OK) return RC;        
        RC = MPC_Web_free(net);
        if (RC != MPC_OK) return RC;
      } /* if */
      net -> rank = MPC_UNINITED_RANK;        
      if (am_parent) { 
        message[MSG_LEADER] = net->leader;
        RC = I2C(MPI_Send(message,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                          MPC_FREENET_TAG,MPI_COMM_WORLD ));
        if (RC != MPC_OK) return RC;

        RC = I2C(MPI_Recv(&dummy,1,MPI_INT,dispatcher,MPC_REPLY_TAG,

                          MPI_COMM_WORLD,&status));
        if (RC != MPC_OK) return RC;

      }  
      else {

        /*10/03/2000**Make (local) leader the same as parent expects (not 0-th)*****/
        Int leader_local_rank;
        Int leader_global_rank;
        Int return_size;
        Int global_rank;
        Int local_rank;

        MPI_Comm_size(return_comm, &return_size);
        MPI_Comm_size(MPI_COMM_WORLD, &leader_global_rank);
        for(local_rank=0; local_rank<return_size; local_rank++) {
          MPC_Translate_from_rank(&global_rank, return_comm, local_rank);
          if(global_rank < leader_global_rank) {
            leader_local_rank=local_rank;
            leader_global_rank=global_rank;
          }
        }
        /*********************************************************************************/

        if (net->params != NULL) free( net->params );
        RC = MPC_Comm_unite( return_comm, 0, dispatcher, &free_comm,/*0*/leader_local_rank );
        if (RC != MPC_OK) return RC;

        /* rreddy
         * hmpi_free_comm -- communicator for the free processes
         */
        {
           int free_comm_rank;
           int result = MPI_Comm_rank(
                           free_comm,
                           &free_comm_rank
           );

           result = I2C(result);

           if (result != MPC_OK)
           {
              return result;
           }
        
           result = MPI_Comm_split(
                       free_comm,
                       0,
                       free_comm_rank - 1,
                       &hmpi_return_comm
           );

           result = I2C(result);

           if (result != MPC_OK)
           {
              return result;
           }

           hmpi_free_comm = hmpi_return_comm;

           (*(MPI_Comm*)(MPC_Net_free_procs.pweb)) = hmpi_free_comm;
        }

      } /* if */
    } /* if */
    net->subnet_list = NULL;
    net->subnet_next = NULL;

    /*
    * Fixing Memory Leaks
    * rreddy BUG# 00003 MODULE MPC
    * Heterogeneous ScaLAPACK
    */
    if (net->links != NULL)
    {
       free(net->links);
       net->links = NULL;
    }

    return MPC_OK;  
  } /* iMPC_Net_free */

/******************* MPC_Net_free ********************************************/
Int MPC_Net_free( MPC_Net* net )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Net_free\n", MPC_Net_global.rank );
      } /* if */
    RC = iMPC_Net_free(net);
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Net_free\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Net_free\n", MPC_Net_global.rank );
      } /* if */         
    return RC;
  } /* MPC_Net_free */ 
  
/******************* iMPC_Node_hire ******************************************/  
  Int iMPC_Node_hire(MPC_Net* net, Int future_rank,
                     MPC_Node future_parent, Int param_length)
  {
    Int RC; 
    MPI_Comm united_comm;
    MPI_Comm ordered_comm;
    Int* params;          
    Int parent_rank;
    Int power;   
    
    /*10/03/2000**Make (local) leader the same as parent expects (not 0-th)*****/
    Int leader_local_rank;
    Int leader_global_rank;
    Int return_size;
    Int global_rank;
    Int local_rank;

    MPI_Comm_size(return_comm, &return_size);
    MPI_Comm_size(MPI_COMM_WORLD, &leader_global_rank);
    for(local_rank=0; local_rank<return_size; local_rank++) {
      MPC_Translate_from_rank(&global_rank, return_comm, local_rank);
      if(global_rank < leader_global_rank) {
        leader_local_rank=local_rank;
        leader_global_rank=global_rank;
      }
    }
    RC=MPC_Comm_unite(return_comm,1,future_parent,&united_comm,/*0*/leader_local_rank);
    /*********************************************************************************/

    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Comm_split(united_comm,1,future_rank,&ordered_comm)); 
    if (RC != MPC_OK) return RC;
    RC = I2C(MPI_Comm_free(&united_comm));
    if (RC != MPC_OK) return RC;
    RC = MPC_Translate_rank( future_parent, ordered_comm, &parent_rank);
    if (RC != MPC_OK) return RC;
    if (param_length == 0) params = NULL;
      else 
        {
          if ((params = malloc((int)param_length*sizeof(Int))) == NULL)
            return MPC_ERR_NOMEM;
          RC = I2C(MPI_Bcast(params,param_length,MPI_INT,
                             parent_rank,ordered_comm));
          if (RC != MPC_OK)
            return RC;
        } /* if */
    RC = I2C(MPI_Comm_size(ordered_comm,&power));   
    if (RC != MPC_OK) return RC;

     /*
      * rreddy
      * Fillin of param count missing
      */
     net->count = param_length;

    net->params = params;
    net->rank = future_rank;
    net->power = power;
    MPC_Coord_set( net, future_rank );
    if (net->is_static) {
      net->subnet_next = static_stack;
      static_stack = net;
    } /* if */   
    RC = MPC_Web_create( net, ordered_comm );
    if (RC != MPC_OK) return RC;
    if (param_length != 0) {
      RC = MPC_Set_web_root(net, MPC_Parent(net));
      if (RC != MPC_OK) return RC;
    }
    return MPC_OK;
  }  /* iMPC_Node_hire */

/******************* MPC_Node_hire *******************************************/  
  Int MPC_Node_hire(MPC_Net* net, Int future_rank, MPC_Node future_parent,
                    Int param_length)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Node_hire\n", MPC_Net_global.rank );      
    RC = iMPC_Node_hire(net,future_rank,future_parent,param_length);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Node_hire, RC = %d\n",
                        MPC_Net_global.rank, RC );      
    return RC;
  } /* MPC_Node_hire */

  
/******************* iMPC_Offer **********************************************/  
Int iMPC_Offer(
  MPC_Command* command,       /* MPC_HIRED, MPC_OUT, MPC_SKIP */
  const MPC_Name* names,      /* array of static identifiers of nets */
  MPC_Net** nets_voted, /* array of pointers to nets voting  */
  Int voted_count)            /* number of the net voted */
  {
    Int RC;
    Int mapsize;
    Int cmd;
    Int message[MAX_DISPMSG_SIZE];
    Int done = 0;

    /*  if (skip_waiting_point) {done = 1; *command = MPC_OUT;} */
    while (!done) {
      RC = I2C(MPI_Comm_size(free_comm,&mapsize));
      if (RC != MPC_OK) return RC;
      RC = I2C(MPI_Scatter(NULL,0,MPI_INT,message,MAX_DISPMSG_SIZE,
                           MPI_INT,mapsize-1,free_comm));
      if (RC != MPC_OK) return RC;
      cmd = message[DSP_CMD];
    
    if (MPC_DEBUG > 2) {
      MPC_Debug_printf( "---[%2d]-- MPC_Offer got command = %d\n",
                        MPC_Net_global.rank, cmd );
      } /* if */

      switch (cmd) {
        case MPC_SKIP:
          { 
            Int run_out;
        
            run_out = message[DSP_RUNOUT];
            RC = I2C(MPI_Comm_split(free_comm,0,1,&return_comm));
            if (RC != MPC_OK) return RC;

            /* rreddy
             * Free the free_comm.
             */
            {
               int result = MPI_Comm_free(
                               &free_comm
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }
            }

            free_comm = return_comm;

            /* rreddy
             * hmpi_free_comm for HMPI library
             */
            {
               int free_comm_rank;
               int result = MPI_Comm_rank(
                               free_comm,
                               &free_comm_rank
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }

               result = MPI_Comm_split(
                           free_comm,
                           0,
                           free_comm_rank - 1,
                           &hmpi_return_comm
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }

               /*
                * Free the hmpi_free_comm before updation.
                */
               {
                  int result = MPI_Comm_free(
                                  &hmpi_free_comm
                  );

                  result = I2C(result);

                  if (result != MPC_OK)
                  {
                     return result;
                  }
               }

               hmpi_free_comm = hmpi_return_comm;

               (*(MPI_Comm*)(MPC_Net_free_procs.pweb)) = hmpi_free_comm;
            }

            break;
          } 
        case MPC_HIRED :
          {
            Int future_rank;
            Int future_name;
            Int future_parent;
            Int param_length;
            Int i;

            future_rank = message[DSP_RANK];
            future_name = message[DSP_NAME];
            future_parent = message[DSP_PARENT];
            param_length = message[DSP_PARAMLEN];

            RC = I2C(MPI_Comm_split(free_comm,future_name,1,&return_comm));
            if (RC != MPC_OK) return RC;

            /* rreddy
             * Free the free_comm.
             */
            {
               int result = MPI_Comm_free(
                               &free_comm
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }
            }

            free_comm = MPI_COMM_NULL;

            for( i=0;i<voted_count;i++) {
              if (names[i] == future_name) {
                nets_voted[i]->pweb = MPC_NULL_WEB;
                if (cmd==MPC_HIRED)
                  MPC_Node_hire(nets_voted[i],future_rank,
                                future_parent,param_length );
              } /* if */ 
            } /* for */
            done = 1;
            *command = MPC_HIRED;

            /*
             * Free the hmpi_free_comm
             */
            {
               int result = MPI_Comm_free(
                               &hmpi_free_comm
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }
            
               hmpi_free_comm = MPI_COMM_NULL;
            }

            break;            
          }

        case MPC_FIRED:
	  {
	    Int leader;
	    Int run_out;
	    MPI_Comm united_comm;

            leader = message[DSP_LEADER]; 
            run_out = message[DSP_RUNOUT];
            if (leader != MPC_NULL_LEADER) {
              RC = MPC_Comm_unite(free_comm,1,leader,&united_comm,mapsize-1);
              if (RC != MPC_OK) return RC;

              /* rreddy
               * Free the free_comm before moving the temp_comm
               */
              {
                 int result = MPI_Comm_free(
                                 &free_comm
                 );

                 result = I2C(result);

                 if (result != MPC_OK)
                 {
                    return result;
                 }
              }

              free_comm = united_comm;
	    } /* if */

            /* rreddy
             * hmpi_free_comm for HMPI library
             */
            {
               int free_comm_rank;
               int result = MPI_Comm_rank(
                               free_comm,
                               &free_comm_rank
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }

               result = MPI_Comm_split(
                           free_comm,
                           0,
                           free_comm_rank - 1,
                           &hmpi_return_comm
               );

               result = I2C(result);

               if (result != MPC_OK)
               {
                  return result;
               }

               /*
                * free the hmpi_free_comm
                */
               {
                  int result = MPI_Comm_free(
                                  &hmpi_free_comm
                  );

                  result = I2C(result);

                  if (result != MPC_OK)
                  {
                     return result;
                  }
               }

               hmpi_free_comm = hmpi_return_comm;

               (*(MPI_Comm*)(MPC_Net_free_procs.pweb)) = hmpi_free_comm;
            }

            break;	
          }
        case MPC_OUT :
          {
            done = 1;
            *command = MPC_OUT;
            break;
          }  
        default :
          return MPC_ERR_INTERNAL;  
      } /* switch */
    } /* while */
    return MPC_OK;
  } /* iMPC_Offer */

/******************* MPC_Offer ***********************************************/
Int MPC_Offer(
  MPC_Command* command,       /* MPC_HIRED, MPC_OUT, MPC_SKIP */
  const MPC_Name* names,      /* array of static identifiers of nets */
  MPC_Net** nets_voted,       /* array of pointers to nets voting  */
  Int voted_count)            /* number of the net voted */
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Offer, voted_count = %d\n",
                          MPC_Net_global.rank, voted_count );
      } /* if */
    RC = iMPC_Offer(command,names,nets_voted,voted_count);
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Offer\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Offer, command = %d\n",
                          MPC_Net_global.rank, *command );
      } /* if */
    return RC;
  } /* MPC_Offer */

/****************** iMPC_Reconfig ********************************************/
Int iMPC_Reconfig( void )
  {
    Int RC; 
    Int cmd;

    RC = MPC_Offer(&cmd,NULL,NULL,0);
    if (RC != MPC_OK) return RC;
    if (cmd != MPC_OUT) return MPC_ERR_INVALIDRECONFIG;
    return MPC_OK;
  } /* iMPC_Reconfig */

/******************* MPC_Reconfig ********************************************/
Int MPC_Reconfig( void )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Reconfig\n", MPC_Net_global.rank );
      } /* if */
    RC = iMPC_Reconfig();
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Reconfig\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Reconfig\n", MPC_Net_global.rank );
      } /* if */
    return RC;
  } /* MPC_Reconfig */

/******************* MPC_Set_created *****************************************/
Int MPC_Set_created( MPC_Net* net )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Set_created\n", MPC_Global_rank());
    if ((net->rank) == MPC_UNINITED_RANK)
      net->rank = MPC_UNVOTED_RANK; 
    RC = MPC_OK;
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Set_created, RC = %d\n",
                        MPC_Global_rank(), RC);
    return RC;
  } /* MPC_Set_created */

/******************* iMPC_Subnet_create **************************************/  
Int iMPC_Subnet_create( 
  MPC_Net* subnet,
  Int is_flexible)  
  {
    Int RC;

    if (is_flexible) subnet->pweb = MPC_NULL_WEB;  
    else {
      Int color;
      Int testrank;
      MPI_Comm subweb;

      color = (subnet->rank >= 0) ? 0 : MPI_UNDEFINED;
      RC = I2C(MPI_Comm_split((*(MPI_Comm*)(subnet->supernet->pweb)),
                              color,subnet->rank,&subweb));
      if (RC != MPC_OK) return RC;
      if (subweb == MPI_COMM_NULL) subnet->pweb = MPC_NULL_WEB;
      else {
        RC = MPC_Web_create(subnet,subweb);
        if (RC != MPC_OK) return RC;
        RC = I2C(MPI_Comm_rank((*(MPI_Comm*)(subnet->pweb)),&testrank));
        if (RC != MPC_OK) return RC;
	if (testrank != subnet->rank) return MPC_ERR_RANK;
      }; 
    } /* if */
    if ((subnet->rank) >= 0 ) {      
      subnet->count = subnet->supernet->count;
      subnet->params = subnet->supernet->params;
      subnet->coord = subnet->supernet->coord;
      subnet->type = subnet->supernet->type;
      if (subnet->is_static) {
        subnet->subnet_next = subnet->supernet->subnet_list;
        subnet->supernet->subnet_list = subnet; 
      } /* if */
    }
    else if(subnet->is_static)
      subnet->rank = MPC_UNVOTED_RANK;  
    return MPC_OK;
  } /* iMPC_Subnet_create */

/******************* MPC_Subnet_create ***************************************/
Int MPC_Subnet_create( 
  MPC_Net* subnet,
  Int is_flexible )  
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Subnet_create, rank=%d, is_flexible=%d\n",
                          MPC_Net_global.rank, subnet->rank, is_flexible );
      } /* if */
    RC = iMPC_Subnet_create(subnet, is_flexible);
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Subnet_create\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Subnet_create\n", MPC_Net_global.rank );
      } /* if */
    return RC;
  } /* MPC_Subnet_create */

/****************** MPC_Waiting_point_begin **********************************/
Int MPC_Waiting_point_begin(
  Int number_of_nets_to_create,
  Int number_of_nets_to_free)
  {
    return MPC_OK;
  } /* MPC_Waiting_point_begin */

/****************** iMPC_Waiting_point_end ***********************************/
Int iMPC_Waiting_point_end( void )
  {
    Int RC;

    skip_waiting_point = 0;

    RC = MPC_Global_barrier();
    if (RC != MPC_OK) return RC;
    return MPC_OK;
  } /* iMPC_Waiting_point_end */

/****************** MPC_Waiting_point_end ************************************/
Int MPC_Waiting_point_end( void )
  {
    Int RC;
    char err_str[MAX_ERR_STR];

    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "---[%2d]-> MPC_Waiting_point_end\n",
                          MPC_Net_global.rank );
      } /* if */
    RC = iMPC_Waiting_point_end();
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Waiting_point_end\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Waiting_point_end\n",
                          MPC_Net_global.rank );
      } /* if */
     return RC;
  } /* MPC_Waiting_point_end */

/******************* MPC_Is_subnet *******************************************/
Int MPC_Is_subnet( const MPC_Net* net )
  {
    return ((net->supernet) != NULL);
  } /* MPC_Is_subnet */                       
  
/******************* MPC_Is_host *********************************************/
Int MPC_Is_host(void)
  { 
    return (MPC_Net_host.pweb != MPC_NULL_WEB);
  } /* MPC_Is_host */   
  
/******************* MPC_Is_static *******************************************/

Int MPC_Is_static(const MPC_Net* net)
  {
    return net->is_static;
  } /* MPC_Is_static */ 

/******************* MPC_Global_rank *****************************************/
Int MPC_Global_rank( void )
  {
    return MPC_Net_global.rank;
  } /* MPC_Global_rank */
  
/******************* MPC_Node_rank *******************************************/
Int MPC_Node_rank(const MPC_Net* net)
  {
    return net->rank;
  } /* MPC_Node_rank */ 
  
/******************* MPC_Is_busy *********************************************/
Int MPC_Is_busy(void)
  {
    return (free_comm == MPI_COMM_NULL);
  } /* MPC_Is_busy */  
  
/******************* MPC_Is_free *********************************************/
Int MPC_Is_free(void)
  {
    return (free_comm != MPI_COMM_NULL);
  } /* MPC_Is_free */

/******************* MPC_Is_member *******************************************/
Int MPC_Is_member(const MPC_Net* net)
  {
    Int is_member;

    is_member = (MPC_Is_subnet(net)) ?
      (net->rank >= 0) : (net->pweb != MPC_NULL_WEB);  
    return(is_member) ;
  } /* MPC_Is_member */

/******************* MPC_Is_member_of_anynet *********************************/
Int MPC_Is_member_of_anynet( MPC_Net** nets, Int count)
  {
    Int i;
    Int temp = 0;   
    for (i=0;i<count;i++) temp = temp || MPC_Is_member( nets[i] );
    return temp;
  } /* MPC_Is_member_of_anynet */

/******************* MPC_Is_parent *******************************************/
Int MPC_Is_parent(MPC_Net* net)
  {
    return (MPC_Parent(net)==net->rank);
  } /* MPC_Is_parent */
  
/******************* MPC_Is_created ******************************************/ 
Int MPC_Is_created(const MPC_Net* net)
  {                  
    return (net->rank != MPC_UNINITED_RANK) ;
  } /* MPC_Is_created */
  
/******************* MPC_Parent **********************************************/
Int MPC_Parent(MPC_Net* net )
  {
    return(net->type->parent)(net->params,
                              net->power, &(net->nodes), &(net->links));
  } /* MPC_Parent */

/******************* MPC_Power ***********************************************/
Int MPC_Power( MPC_Net* net )
  {
    if (net->power==MPC_INIT_POWER)
      net->power = ( net->type->power )(net->params,
                                        net->power, &(net->nodes), &(net->links));
    return (net->power);
  } /* MPC_Power */

/******************* MPC_Coord ***********************************************/
void MPC_Coord(
  MPC_Net* net, 
  Int number, 
  Int* coord)
  {
    (net->type->num2coord)(number,net->params,coord,
                           net->power, &(net->nodes), &(net->links));
  } /* MPC_Coord */

/******************* MPC_Coord_set *******************************************/
void MPC_Coord_set(
  MPC_Net* net, 
  Int number)
  {  
    MPC_Net* curr;
    Int n;

    curr = net;
    n = number;
    while (curr->mapping != NULL) { 
      n = curr->mapping[n]; 
      curr = curr->supernet;
    }
    (net->type->num2coord)(n,net->params,net->coord,
                           net->power, &(net->nodes), &(net->links));
  } /* MPC_Coord_set */

/******************* MPC_Total_nodes *****************************************/
Int MPC_Total_nodes( void )
  {
    return MPC_Net_global.power;
  } /* MPC_Total_nodes */

/******************* iMPC_Find_number ****************************************/
Int iMPC_Find_number( 
  const MPC_Net* net,
  Int supernumber,
  Int* number )
  {
    Int i;
    for (i=0;i<net->power;i++)
      if ((net->mapping[i]) == supernumber)
        {*number = i; return MPC_OK;}
    return MPC_ERR_INVALIDMAPPING;
  } /* iMPC_Find_number */

/******************* MPC_Find_number *****************************************/
Int MPC_Find_number( 
  const MPC_Net* net,
  Int supernumber,
  Int* number )
  {
    Int RC;
    char err_str[MAX_ERR_STR];
     
    if (MPC_DEBUG > 1)
      {
        MPC_Debug_printf("---[%2d]-> MPC_Find_number\n",
                         MPC_Net_global.rank);
      } /* if */
    RC = iMPC_Find_number(net, supernumber, number);
    if (RC != MPC_OK)
      {        
        RC2STR( err_str, RC );
        MPC_Debug_printf( "<==[%2d]== MPC error %s during MPC_Find_number\n",
                          MPC_Net_global.rank, err_str );
        exit(RC);
      } /* if */
    if (MPC_DEBUG > 1)
      {
        MPC_Debug_printf( "<--[%2d]-- MPC_Find_number\n",
                          MPC_Net_global.rank );
      } /* if */ 
    return RC;    
  } /* MPC_Find_number */

/******************* MPC_Number **********************************************/
Int MPC_Number(
  MPC_Net* net,
  const Int* coord)
  {    
    if ((net->supernet) == NULL)
      return (net->type->coord2num)((Int*)coord,net->params,net->power,
                                    &(net->nodes), &(net->links));
    else
      { 
        Int i;
        Int supernumber = MPC_Number(net->supernet, coord);
        MPC_Find_number(net,supernumber,&i);
        return i;        
      } /* if */
  } /* MPC_Number */

/*********************** MPC_My_number ***************************************/
Int MPC_My_number( MPC_Net* net )
  {
    return MPC_Number(net,net->coord);
  } /* MPC_My_number */

/*****very*new******** MPC_Updated_local_processors_info ******01.03.2000********/
Int MPC_Updated_local_processors_info(
  Int* num_of_processors, 
  double** relative_performance )
  {
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    MPI_Request     rq;
    int i;

    for(i=0;i<MAX_DISPMSG_SIZE;i++) dummy[i]=0;

    {
      RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                        dispatcher,MPC_INFOPROC_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      RC = I2C(MPI_Recv(&info_num_of_processors, 1 , MPI_INT,
                        dispatcher, MPC_INFONUM_TAG, MPI_COMM_WORLD, &status));
      if (RC != MPC_OK) return RC;
      if (info_num_of_processors <= 0) return MPC_ERR_INTERNAL;
      if ((info_relative_performance == NULL)&&
          ((info_relative_performance =
            malloc(sizeof(double)*info_num_of_processors))==NULL))
        return MPC_ERR_NOMEM;        
      RC = I2C(MPI_Recv(info_relative_performance, info_num_of_processors, MPI_DOUBLE,
                        dispatcher, MPC_INFOBODY_TAG, MPI_COMM_WORLD, &status));
      if (RC != MPC_OK) return RC;
    }
    (*num_of_processors) = info_num_of_processors;
    (*relative_performance) = info_relative_performance;
    
    return MPC_OK;
  } /* MPC_Updated_local_processors_info */

/*********************** MPC_Send_sync_message_to_dispatcher *************************/

Int MPC_Send_sync_message_to_dispatcher()
{
    Int RC, dummy;

    RC = MPI_Send(
            &dummy,
            1,
            MPI_INT,
            dispatcher,
            MPC_SYNC_TAG,
            MPI_COMM_WORLD
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }

    return MPC_OK;
}

/*********************** MPC_Recv_sync_message_from_dispatcher *************************/

Int MPC_Recv_sync_message_from_dispatcher()
{
    Int RC, dummy;
    MPI_Status status;

    RC = MPI_Recv(
            &dummy,
            1,
            MPI_INT,
            dispatcher,
            MPC_SYNC_TAG,
            MPI_COMM_WORLD,
            &status
    );

    RC = I2C(RC);

    if (RC != MPC_OK)
    {
       return RC;
    }
    return MPC_OK;
}

/*********************** iMPC_Processors_static_info *************************/
Int iMPC_Processors_static_info(
  Int* num_of_processors, 
  double** relative_performance )
  {
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    MPI_Request     rq;
    int i;

    for(i=0;i<MAX_DISPMSG_SIZE;i++) dummy[i]=0;

    if (1) {
      RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                        dispatcher,MPC_INFOPROC_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      RC = I2C(MPI_Recv(&info_num_of_processors, 1 , MPI_INT,
                        dispatcher, MPC_INFONUM_TAG, MPI_COMM_WORLD, &status));
      if (RC != MPC_OK) return RC;
      if (info_num_of_processors <= 0) return MPC_ERR_INTERNAL;
      if ((info_relative_performance == NULL)&&
          ((info_relative_performance =
            malloc(sizeof(double)*info_num_of_processors))==NULL))
        return MPC_ERR_NOMEM;        
      RC = I2C(MPI_Recv(info_relative_performance, info_num_of_processors, MPI_DOUBLE,
                        dispatcher, MPC_INFOBODY_TAG, MPI_COMM_WORLD, &status));
      if (RC != MPC_OK) return RC;
      RC=MPC_Global_barrier();    /** Addition 08.12.1999 **/
    } /* if */
    (*num_of_processors) = info_num_of_processors;
    (*relative_performance) = info_relative_performance;

    
    return MPC_OK;
  } /* iMPC_Processors_static_info */

/*********************** MPC_Processors_static_info ***************************/

Int MPC_Processors_static_info(
  Int* num_of_processors, 
  double** relative_performance )
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Processors_static_info\n",
                       MPC_Net_global.rank);
    RC = iMPC_Processors_static_info( num_of_processors, relative_performance );    
    if (MPC_DEBUG > 1)
      MPC_Debug_printf
        ("<--[%2d]-- MPC_Processors_static_info, RC=%d, num_of_processors=%d\n",
         MPC_Net_global.rank, RC, (*num_of_processors));
    return RC;
  } /* MPC_Processors_static_info */

/*********************** MPC_Get_number_of_processors *****************************/
Int MPC_Get_number_of_processors(void) /* returns the number of physical processors */
  {  
    Int RC;
    /*    Int prnum; */ /* Addition 09.12.1999 */
    /*    double* r_perf; */ /* Addition 09.12.1999 */
    
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Get_number_of_processors\n",
                        MPC_Global_rank());
    /*    RC = MPC_Processors_static_info(&prnum,&r_perf); */ /* Addition 09.12.1999 */
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]--MPC_Get_number_of_processors,num_of_processors=%d\n",
                       MPC_Global_rank(), info_num_of_processors);
    /*    return prnum; */ /* Addition 09.12.1999 */
    return info_num_of_processors;
  } /* MPC_Get_number_of_processors */

/*********************** iMPC_Free_processes_info *************************/
  Int 
  iMPC_Free_processes_info
  (
    int* number_of_free_processes
  )
  {
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    MPI_Request rq;
    int i;
    int number_of_processes;

    for (i=0; i < MAX_DISPMSG_SIZE; i++) 
    {
	dummy[i]=0;
    }

    RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                      dispatcher,MPC_NUMFREEPROCS_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) return RC;

    RC = I2C(MPI_Recv(number_of_free_processes, 1 , MPI_INT,
                      dispatcher, MPC_NUMFREEPROCS_TAG, MPI_COMM_WORLD, &status));
    if (RC != MPC_OK) return RC;

    return MPC_OK;
  } /* iMPC_Free_processes_info */

/*********************** MPC_Free_processes_info ***************************/

  Int 
  MPC_Free_processes_info
  (
    int* number_of_free_processes
  )
  {
    Int RC;

    if (MPC_DEBUG > 1)
    {
       MPC_Debug_printf("---[%2d]-> MPC_Free_processes_info\n",
                       MPC_Net_global.rank);
    }

    RC = iMPC_Free_processes_info(number_of_free_processes);    

    if (MPC_DEBUG > 1)
    {
       MPC_Debug_printf
        ("<--[%2d]-- MPC_Free_processes_info, RC=%d\n",
         MPC_Net_global.rank, RC);
    }

    return RC;
  } /* MPC_Processes_static_info */

/*********************** iMPC_Processes_static_info *************************/
  Int 
  iMPC_Processes_static_info
  (
    double* relative_performances 
  )
  {
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    MPI_Request rq;
    int i;
    int number_of_processes;

    for (i=0; i < MAX_DISPMSG_SIZE; i++) 
    {
	dummy[i]=0;
    }

    RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                      dispatcher,MPC_INFOPROCESSES_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) return RC;

    RC = I2C(MPI_Recv(&number_of_processes, 1 , MPI_INT,
                      dispatcher, MPC_INFOPROCESSES_TAG, MPI_COMM_WORLD, &status));
    if (RC != MPC_OK) return RC;

    RC = I2C(MPI_Recv(relative_performances, number_of_processes, MPI_DOUBLE,
                      dispatcher, MPC_INFOPROCESSES_TAG, MPI_COMM_WORLD, &status));
    if (RC != MPC_OK) return RC;

    RC=MPC_Global_barrier();

    return MPC_OK;
  } /* iMPC_Processes_static_info */

/*********************** MPC_Processes_static_info ***************************/

  Int 
  MPC_Processes_static_info
  (
    double* relative_performance 
  )
  {
    Int RC;

    if (MPC_DEBUG > 1)
    {
       MPC_Debug_printf("---[%2d]-> MPC_Processes_static_info\n",
                       MPC_Net_global.rank);
    }

    RC = iMPC_Processes_static_info(relative_performance);    

    if (MPC_DEBUG > 1)
    {
       MPC_Debug_printf
        ("<--[%2d]-- MPC_Processes_static_info, RC=%d\n",
         MPC_Net_global.rank, RC);
    }

    return RC;
  } /* MPC_Processes_static_info */

/*********************** MPC_Get_processors_info **********************************-/
void MPC_Get_processors_info(     /-* returns physical processors dispatcher's map *-/
    Int* imap,
    double* map )
  {  
    Int RC;
    Int prnum;
    double* r_perf;
    int i;
    
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Get_processors_info\n", MPC_Global_rank());
    RC = MPC_Processors_static_info(&prnum,&r_perf);
    for (i=0;i<prnum;i++) {
     if(map)  map[i]  = r_perf[i];
     if(imap) imap[i] = (Int)r_perf[i];
    }
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Get_processors_info\n, RC = %d",
                        MPC_Global_rank(), RC);
    return; 
  } /-* MPC_Get_processors_info */ /* Addition 09.12.1999 */

/*********************** MPC_Get_processors_info **** Addition 09.12.1999 *********/
void MPC_Get_processors_info(     /* returns physical processors dispatcher's map */
                             Int* imap,
                             double* map )
{  
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    MPI_Request     rq;
    int i;

    for(i=0;i<MAX_DISPMSG_SIZE;i++)
      dummy[i]=0;
    MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
             dispatcher,MPC_GIVEBODY_TAG,MPI_COMM_WORLD);
    MPI_Recv(info_relative_performance, info_num_of_processors, MPI_DOUBLE,
             dispatcher, MPC_HAVEBODY_TAG, MPI_COMM_WORLD, &status);
    MPC_Global_barrier();

    for (i=0;i<info_num_of_processors;i++) {
      if(map)
        map[i]=info_relative_performance[i];
      if(imap)
        imap[i]=(Int)info_relative_performance[i];
    }
    return;
} /* MPC_Get_processors_info */ /* Addition 09.12.1999 */

/*********************** MPC_Set_processors_info *************************-/
Int MPC_Set_processors_info(Int *map)
  {
    Int RC, rank, index=0;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;

    RC = I2C(MPI_Comm_rank(MPI_COMM_WORLD,&rank));
    if (RC != MPC_OK) return RC;
    
    if (rank == 0){ /-* host *-/
      RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                        dispatcher,MPC_INFOPROCSET_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      RC = MPC_Env_send(nprocs,map);
      if (RC != MPC_OK) return RC;
    }
    return MPC_OK; 
  } /-* iMPC_Set_processors_info */

/*********************** iMPC_Dispatcher_set_info *************************/
Int MPC_Dispatcher_set_info(Int source)
  {
    Int RC;
    Int *lmap;
    int i, j, k=0;

    if (MPC_DEBUG > 1) MPC_Debug_printf("-d-[ d]-> MPC_Dispatcher_set_info\n");
    RC = MPC_Env_recv(&ngroups,&lmap);
    if (RC == MPC_OK) {
      for(i=0;i<ngroups;i++) {
        groups[i].processor_power = lmap[i];
        groups[i].max_nodepower = groups[i].processor_power/MPC_POWER_COEFF;
        for(j=0; j<groups[i].scalability; j++)
          info_relative_performance[k++]=(double)lmap[i];
      }
    }
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<d-[ d]-- MPC_Dispatcher_set_info, RC = %d\n",RC);
    return RC;
    
  }

/******************** iMPC_Update_computers_info *****************@@@***/
Int iMPC_Update_computers_info(
    double MPC_bench_times,
    double *dmap
)
  {
    Int i, RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    Int *lmap;

    
    if (MPC_Net_recon.rank == 0) { /* host */
      if ((lmap = malloc(MPC_Net_recon.power*sizeof(Int))) == NULL)
        return MPC_ERR_NOMEM;
    }

    RC = I2C(MPI_Allgather((void*)&MPC_bench_times,1,MPI_DOUBLE,dmap,
                        1,MPI_DOUBLE,*(MPI_Comm*)(MPC_Net_recon.pweb)));
    if (RC != MPC_OK) return RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-: MPC_Update_computers_info dmap[0]=%d\n",
                                        MPC_Net_recon.rank,(int)dmap[0]);
    
    if (MPC_Net_recon.rank == 0){ /* host */
      int i;
      for(i=0;i<MPC_Net_recon.power;i++)
        {
          lmap[i] = (dmap[i]==0)?MPC_MAX_WEIGHT:(Int)(MPC_POWER_COEFF/dmap[i]);
        }

      RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                        dispatcher,MPC_INFOPROCSET_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      
      RC = MPC_Env_send(MPC_Net_recon.power,lmap);
      if (RC != MPC_OK) return RC;

      free(lmap);
    }

    for (i = 0; i < MPC_Net_recon.power; i++)
    {
       dmap[i] = (dmap[i]==0)?MPC_MAX_WEIGHT:(Int)(MPC_POWER_COEFF/dmap[i]);
    }

    return MPC_OK;
  }

/******************** MPC_Update_computers_info ********************************/
Int MPC_Update_computers_info(
       double MPC_bench_times,
       double *relative_performance
)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Update_computers_info\n", MPC_Net_recon.rank);
    RC = iMPC_Update_computers_info( 
             MPC_bench_times,
             relative_performance
    );    
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Update_computers_info, RC = %d\n",
                       MPC_Net_recon.rank, RC);
    return RC;
  }

/******************** iMPC_Update_Processors_info *****************@@@***/
Int iMPC_Update_Processors_info(double MPC_bench_times)
  {
    Int RC;
    Int dummy[MAX_DISPMSG_SIZE];
    MPI_Status status;
    Int *lmap;
    double *dmap;

    
    if (MPC_Net_recon.rank == 0) { /* host */
      if ((dmap = malloc(MPC_Net_recon.power*sizeof(double))) == NULL)
        return MPC_ERR_NOMEM;
      if ((lmap = malloc(MPC_Net_recon.power*sizeof(Int))) == NULL)
        return MPC_ERR_NOMEM;
    }

    RC = I2C(MPI_Gather((void*)&MPC_bench_times,1,MPI_DOUBLE,dmap,
                        1,MPI_DOUBLE,0,*(MPI_Comm*)(MPC_Net_recon.pweb)));
    if (RC != MPC_OK) return RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-: MPC_Update_Processors_info dmap[0]=%d\n",
                                        MPC_Net_recon.rank,(int)dmap[0]);
    
    if (MPC_Net_recon.rank == 0){ /* host */
      int i;
      for(i=0;i<MPC_Net_recon.power;i++)
        {
          lmap[i] = (dmap[i]==0)?MPC_MAX_WEIGHT:(Int)(MPC_POWER_COEFF/dmap[i]);
        }

      RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,
                        dispatcher,MPC_INFOPROCSET_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;
      
      RC = MPC_Env_send(MPC_Net_recon.power,lmap);
      if (RC != MPC_OK) return RC;

      free(lmap);free(dmap);
    }

    return MPC_OK;
  }

/******************** MPC_Update_Processors_info ********************************/
Int MPC_Update_Processors_info(double MPC_bench_times)
  {
    Int RC;

    if (MPC_DEBUG > 1)
      MPC_Debug_printf("---[%2d]-> MPC_Update_Processors_info\n", MPC_Net_recon.rank);
    RC = iMPC_Update_Processors_info( MPC_bench_times );    
    if (MPC_DEBUG > 1)
      MPC_Debug_printf("<--[%2d]-- MPC_Update_Processors_info, RC = %d\n",
                       MPC_Net_recon.rank, RC);
    return RC;
  }

/******************** MPC_Source_filename_set ********************************/
Int MPC_Source_filename_set( const char* filename )
  {
    if (strlen(filename)+1 > MAX_FILENAME_LENGTH) return MPC_ERR_TOOLONGFILENAME;
    strcpy( source_filename, filename );
    return MPC_OK;
  } /* MPC_Source_filename_set */ 

/******************** MPC_Source_position_set ********************************/
Int MPC_Source_position_set( Int column, Int line )
  {
    source_line = line;
    source_column = column;
    return MPC_OK;
  } /* MPC_Source_position_set */ 
  
/******************** MPC_Error_raise ****************************************/
Int MPC_Error_raise( const char* error_message )
  {
    Int RC;
    char buffer[MAX_ERRMSG_SIZE];
    char ret_buffer[MPC_ERRRETURN_SIZE];
    Int header[4];
    Int error_msg_length;
    Int filename_length;
    Int buffer_length;
    MPI_Status status;

    error_msg_length = strlen(error_message)+1;
    filename_length = strlen(MPC_Debug_source_name/*source_filename*/)+1;
    if ((buffer_length = (error_msg_length+filename_length)) > MAX_ERRMSG_SIZE)
      return MPC_ERR_NOMEM;
    strcpy(buffer,MPC_Debug_source_name/*source_filename*/);
    strcpy(buffer+filename_length,error_message);
    header[MSG_LINE] = source_line;
    header[MSG_COLUMN] = source_column;
    header[MSG_FILENAME_LENGTH] = filename_length;
    header[MSG_ERRMSG_LENGTH] = error_msg_length;
    RC = I2C(MPI_Send(header,MAX_DISPMSG_SIZE,MPI_INT,
                      dispatcher,MPC_ERRHEAD_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) MPC_Exit(RC);
    RC = I2C(MPI_Send(buffer,buffer_length,MPI_CHAR,
                      dispatcher,MPC_ERRBODY_TAG,MPI_COMM_WORLD));
    if (RC != MPC_OK) MPC_Exit(RC);
    RC = I2C(MPI_Recv(ret_buffer,MPC_ERRRETURN_SIZE,MPI_CHAR,
             dispatcher,MPC_ERRRETURN_TAG,MPI_COMM_WORLD,&status));

    MPC_Abort(-1);
    return MPC_OK;
  } /* MPC_Error_raise */

/********************** MPC_Warning_raise **************************************/
Int MPC_Warning_raise( const char* warning_message ) 
  {  
    return (MPC_Debug_printf("Warning %s\n", warning_message ));
  } /* MPC_Warning_raise */

/********************** MPC_Printf *********************************************/

Int MPC_Printf( const char* format, ... )
  {
    Int RC;
    char* buffer;
    Int buffer_length;    
    va_list args;
    Int header[MAX_DISPMSG_SIZE];

    va_start(args,format);
    buffer_length = vfprintf(NULLDEV,format,args)+1;
    va_end(args);
    if ((buffer = malloc(sizeof(char)*buffer_length)) == NULL) return MPC_ERR_NOMEM;
    va_start (args,format);
    vsprintf(buffer,format,args);
    va_end(args);
    buffer[buffer_length-1]='\0';
    if (MPC_Is_host()||MPC_Global_rank()==dispatcher) { /* it's host, my Lord! */
      printf("%s", buffer); fflush(stdout);
      free( buffer );
    } else { /* send the message */
      
      header[MSG_PRINTF_LENGTH] = buffer_length;
      
      RC=I2C(MPI_Send(header,MAX_DISPMSG_SIZE,MPI_INT,
                      dispatcher,MPC_PRINTFHEAD_TAG,MPI_COMM_WORLD));
      if (RC != MPC_OK) return RC;    
      RC=I2C(MPI_Send(buffer,buffer_length,MPI_CHAR,
                      dispatcher,MPC_PRINTFBODY_TAG,MPI_COMM_WORLD));
      free(buffer);
      if (RC != MPC_OK) return RC;
      /**/
    }
    return MPC_OK;
  } /* MPC_Printf */

/******new********** iMPC_Local_env_recv *****************@@@**************/
Int iMPC_Local_env_recv(Int* penv_length, Int** penv_buffer)
  {
    Int RC;
    Int* temp;
    MPI_Status status;

    if(MPC_DEBUG==1)
      MPC_Debug_printf("iMPC_Local_env_recv: enter\n");
    RC = I2C(MPI_Recv(penv_length,1,MPI_INT,dispatcher,MPC_ENVSIZE_TAG,
                      MPI_COMM_WORLD, &status));
    if(MPC_DEBUG==1)
      MPC_Debug_printf("iMPC_Local_env_recv: *penv_length=%d\n", *penv_length);
    if (RC != MPC_OK) return RC;
    if ((*penv_length) == 0) return MPC_OK; 
    if ((temp = malloc((*penv_length)*sizeof(Int))) == NULL) return MPC_ERR_NOMEM;
    RC = I2C(MPI_Recv(temp,(*penv_length),MPI_INT,dispatcher,
                      MPC_ENVBODY_TAG,MPI_COMM_WORLD, &status));
    if(MPC_DEBUG==1)
      MPC_Debug_printf("iMPC_Local_env_recv: temp[0]=%d\n", temp[0]);
    if (RC != MPC_OK) return RC;
    (*penv_buffer) = temp;
    return MPC_OK; 
  } /* iMPC_Local_env_recv */

/********new******** MPC_Local_env_recv ***********************@@@*****/
Int MPC_Local_env_recv(Int* penv_length, Int** penv_buffer)
  {
    Int RC;
    Int rank;

    RC = MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "---[%2d]-> MPC_Local_env_recv\n", rank ); 
    RC = iMPC_Local_env_recv( penv_length, penv_buffer );
    if (MPC_DEBUG > 1)
      MPC_Debug_printf( "<--[%2d]-- MPC_Local_env_recv, RC = %d\n", rank, RC ); 
    return RC;
  } /* MPC_Local_env_recv */

/**********new**** MPC_Send_request_for_env *********@@@*********************/
Int MPC_Send_request_for_env(void)
{
  Int RC;
  Int dummy[MAX_DISPMSG_SIZE];
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_env: enter\n");
  RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                    MPC_REQUEST_FOR_ENV_TAG,MPI_COMM_WORLD));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_env: sent, RC=%d\n", RC);
  if (RC != MPC_OK) return RC;
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_env: sent, RC==MPC_OK\n");
  return MPC_OK;
} /* MPC_Send_request_for_env */

/**********new**** MPC_Send_request_for_refresh *********@@@*********************/
Int MPC_Send_request_for_refresh(void)
{
  Int RC;
  Int dummy[MAX_DISPMSG_SIZE];
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_refresh: enter\n");
  RC = I2C(MPI_Send(dummy,MAX_DISPMSG_SIZE,MPI_INT,dispatcher,
                    MPC_REQUEST_FOR_REFRESH_TAG,MPI_COMM_WORLD));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_refresh: sent, RC=%d\n", RC);
  if (RC != MPC_OK) return RC;
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Send_request_for_refresh: sent, RC==MPC_OK\n");
  return MPC_OK;
} /* MPC_Send_request_for_refresh */

/**********new**** MPC_Dispatcher_send_env *********@@@*********************/
Int MPC_Dispatcher_send_env(Int source)
{
  Int RC;
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Dispatcher_send_env: enter\n");
  RC = I2C(MPI_Send(&MPC_Size_of_environment_buffer,1,MPI_INT,source,
                    MPC_ENVSIZE_TAG,MPI_COMM_WORLD));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Dispatcher_send_env: Size (%d) sent to %d\n",
           MPC_Size_of_environment_buffer, source);
  if (RC != MPC_OK) return RC;
  RC = I2C(MPI_Send(MPC_Environment_buffer,MPC_Size_of_environment_buffer,
                    MPI_INT,source, MPC_ENVBODY_TAG,MPI_COMM_WORLD));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Dispatcher_send_env: Buffer sent\n");
  if (RC != MPC_OK) return RC;
  return MPC_OK;
} /* MPC_Dispatcher_send_env */

/**********new**** MPC_Dispatcher_send_refresh *********@@@*********************/
Int MPC_Dispatcher_send_refresh(Int source)
{
  Int RC;
  int i, nprocs, k, j, l;
  int blocklengths[2];
  MPI_Aint displs[2];
  MPI_Datatype types[2];
  int *intbuf;
  double *doublebuf;
  MPI_Datatype Intpart;
  MPI_Datatype Doublepart;
  MPI_Datatype IntDouble;

  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Dispatcher_send_refresh: enter\n");
  
  for(i=0, nprocs=0; i<ngroups; i++)
    nprocs+=groups[i].maxproc;
  intbuf=calloc(nprocs+ngroups, sizeof(int));
  if(intbuf==NULL)
    return MPC_ERR_NOMEM;
  doublebuf=calloc(nprocs, sizeof(double));
  if(doublebuf==NULL)
    {
      free(intbuf);
      return MPC_ERR_NOMEM;
    }
  RC=MPI_Type_contiguous(nprocs+ngroups, MPI_INT, &Intpart);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      return RC;
    }
  RC=MPI_Type_contiguous(nprocs, MPI_DOUBLE, &Doublepart);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      return RC;
    }
  blocklengths[0]=1;
  blocklengths[1]=1;
  types[0]=Intpart;
  types[1]=Doublepart;
  
  RC=MPI_Address(intbuf, displs);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  RC=MPI_Address(doublebuf, displs+1);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  
  RC=MPI_Type_struct(2, blocklengths, displs, types, &IntDouble);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  RC=MPI_Type_commit(&IntDouble);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      MPI_Type_free(&IntDouble);
      return RC;
    }
  
  for(i=0, k=0, l=0; i<ngroups; i++)
    {
      intbuf[k++]=groups[i].numproc;
      for(j=0; j<groups[i].maxproc; j++)
        {
          intbuf[k++]=groups[i].nodenumbers[j];
          doublebuf[l++]=groups[i].nodeweights[j];
        }
    }
  RC = I2C(MPI_Send(MPI_BOTTOM,1,IntDouble,source,
                    MPC_ENVREFRESH_TAG,MPI_COMM_WORLD));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Dispatcher_send_refresh: sent to %d (k=%d, l=%d)\n",
           source, k, l);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      MPI_Type_free(&IntDouble);
      return RC;
    }
  free(intbuf);
  free(doublebuf);
  MPI_Type_free(&Intpart);
  MPI_Type_free(&Doublepart);
  MPI_Type_free(&IntDouble);
  return MPC_OK;
} /* MPC_Dispatcher_send_refresh */

/**********new**** MPC_Local_env_refresh *********@@@*********************/
Int MPC_Local_env_refresh(void)
{
  Int RC;
  int i, nprocs, k, j, l;
  int blocklengths[2];
  MPI_Aint displs[2];
  MPI_Datatype types[2];
  int *intbuf;
  double *doublebuf;
  MPI_Datatype Intpart;
  MPI_Datatype Doublepart;
  MPI_Datatype IntDouble;
  MPI_Status status;

  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Local_env_refresh: enter\n");
  
  for(i=0, nprocs=0; i<ngroups; i++)
    nprocs+=groups[i].maxproc;
  intbuf=calloc(nprocs+ngroups, sizeof(int));
  if(intbuf==NULL)
    return MPC_ERR_NOMEM;
  doublebuf=calloc(nprocs, sizeof(double));
  if(doublebuf==NULL)
    {
      free(intbuf);
      return MPC_ERR_NOMEM;
    }
  RC=MPI_Type_contiguous(nprocs+ngroups, MPI_INT, &Intpart);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      return RC;
    }
  RC=MPI_Type_contiguous(nprocs, MPI_DOUBLE, &Doublepart);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      return RC;
    }
  blocklengths[0]=1;
  blocklengths[1]=1;
  types[0]=Intpart;
  types[1]=Doublepart;
  
  RC=MPI_Address(intbuf, displs);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  RC=MPI_Address(doublebuf, displs+1);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  
  RC=MPI_Type_struct(2, blocklengths, displs, types, &IntDouble);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      return RC;
    }
  RC=MPI_Type_commit(&IntDouble);
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      MPI_Type_free(&IntDouble);
      return RC;
    }
  RC = I2C(MPI_Recv(MPI_BOTTOM,1,IntDouble,dispatcher,
                    MPC_ENVREFRESH_TAG,MPI_COMM_WORLD, &status));
  if(MPC_DEBUG==1)
    MPC_Debug_printf("MPC_Local_env_refresh: received\n");
  if (RC != MPC_OK)
    {
      free(intbuf);
      free(doublebuf);
      MPI_Type_free(&Intpart);
      MPI_Type_free(&Doublepart);
      MPI_Type_free(&IntDouble);
      return RC;
    }
  for(i=0, k=0, l=0; i<ngroups; i++)
    {
      groups[i].numproc=intbuf[k++];
      for(j=0; j<groups[i].maxproc; j++)
        {
          groups[i].nodenumbers[j]=intbuf[k++];
          groups[i].nodeweights[j]=doublebuf[l++];
        }
      groups[i].max_nodepower=groups[i].processor_power/MPC_POWER_COEFF;
    }
  free(intbuf);
  free(doublebuf);
  MPI_Type_free(&Intpart);
  MPI_Type_free(&Doublepart);
  MPI_Type_free(&IntDouble);
  return MPC_OK;
} /* MPC_Local_env_refresh */

/*************** MPC_Get_processor_number *********************/

Int MPC_Get_processor_number()
{
    return MPC_Processor_number;
}

/********************** MPC_Debug_printf ****************************************/

typedef struct MPC_prn_ElList {
  Int*            Hdr;
  MPI_Request     HRq;
  char*           Bfr;
  MPI_Request     BRq;
  struct MPC_prn_ElList* next;

} MPC_prn_ElList;

MPC_prn_ElList *MPC_prn_List = NULL;

#undef MPC_Debug_printf

Int MPC_Debug_printf( const char* format, ... )
  {
    Int RC;
    char* buffer;
    Int buffer_length;    
    va_list args;
    Int *header;
    MPC_prn_ElList *cPrRq;
    int flag;
    MPI_Status status;

    return MPC_OK;

    /* free the received requests from the list */
    
    cPrRq = MPC_prn_List;
    while(cPrRq) {
      if(cPrRq->Hdr) {
        MPI_Test(&(cPrRq->HRq),&flag,&status);
        if(flag){ free(cPrRq->Hdr); cPrRq->Hdr=NULL; }
      }
      if(cPrRq->Bfr) {
        MPI_Test(&(cPrRq->BRq),&flag,&status);
        if(flag){ free(cPrRq->Bfr); cPrRq->Bfr=NULL; }
      }
      cPrRq=cPrRq->next;
    }
    
    va_start(args,format);
    buffer_length = vfprintf(NULLDEV,format,args)+1;
    va_end(args);
    if ((buffer = malloc(sizeof(char)*buffer_length)) == NULL)
      return MPC_ERR_NOMEM;
    va_start (args,format);
    vsprintf(buffer,format,args);
    va_end(args);
    buffer[buffer_length-1]='\0';
    if (MPC_Is_host()||MPC_Global_rank()==dispatcher) { /* it's host, my Lord! */
      printf("%s",buffer);fflush(stdout);
      free( buffer );
    } else { /* send the message */
      if ((cPrRq = malloc(sizeof(MPC_prn_ElList))) == NULL)
        return MPC_ERR_NOMEM;
      if ((header = malloc(sizeof(Int)*MAX_DISPMSG_SIZE)) == NULL)
        return MPC_ERR_NOMEM;
      cPrRq->Hdr  = header;
      cPrRq->Bfr  = buffer;
      cPrRq->next = MPC_prn_List;
      MPC_prn_List = cPrRq;
      
      header[MSG_PRINTF_LENGTH] = buffer_length;
      
      RC=I2C(MPI_Isend(header,MAX_DISPMSG_SIZE,MPI_INT,
                       dispatcher,MPC_PRINTFHEAD_TAG,log_comm,&(cPrRq->HRq)));
      if (RC != MPC_OK) return RC;    
      RC=I2C(MPI_Isend(buffer,buffer_length,MPI_CHAR,
                       dispatcher,MPC_PRINTFBODY_TAG,log_comm,&(cPrRq->BRq)));
      if (RC != MPC_OK) return RC;
      /**/
    }
    return MPC_OK;
} /* MPC_Debug_printf */

void MPC_ErrorHandler (MPI_Comm *comm, int *err_code, ...) {

  int  l;
  char mpI_err_str[MPI_MAX_ERROR_STRING+1];
  char *mpC_err_str = "Lesha error coordinates.";
  char *errfn;
  char tbuf[12];
  
  if (!ERROR_LOG) {
    errfn = (char *)malloc(strlen("log_%*d.err"));
    sprintf(errfn,"log_%*d.err", MPC_Net_global.rank);
    ERROR_LOG=fopen(errfn,"w");
  }
    
  (void)MPI_Error_string(*err_code,&mpI_err_str[0],&l);
  mpI_err_str[l+1]='\0';
 
  fprintf(ERROR_LOG, "!==[%2d]== MPI error:\n %s\n at: %s\n",
          MPC_Net_global.rank, &mpI_err_str[0], mpC_err_str);

  fclose(ERROR_LOG);
}

