#include <stdarg.h>
#include <stdio.h>
#include <mpi.h>
#include "mpC.h"
#include "mpCdbg.h"
#define  MPC_MAX_RECURSE_LEVEL 16

static char   dbg_filename[255];
static FILE*  dbg_file;
static Int    dbg_rank;
static char*  dbg_format = "%16s %5d %3d %10.5f %7.5f 1s -[%2d (%8s)]- %s %1s %20s %s\n";
static char   dbg_processorname[MPI_MAX_PROCESSOR_NAME];
static Int    dbg_level = 0;

static double starttime = 0.0;
static double timestack[MPC_MAX_RECURSE_LEVEL]; 

Int MPC_Debug_init(Int rank,char* program) {
  Int processor_name_size;
  Int i;
  dbg_level = 0;
  dbg_rank = rank;
  MPI_Barrier(MPI_COMM_WORLD);
  starttime = MPI_Wtime();
  MPI_Get_processor_name(dbg_processorname, &processor_name_size);
  dbg_processorname[processor_name_size] = (char)0;
  sprintf( dbg_filename,"%s_%d_%s.trc", program, rank, dbg_processorname );
  dbg_file = fopen(dbg_filename, "w" );
  for(i=0;i<MPC_MAX_RECURSE_LEVEL;i++) timestack[i] = 0.0;     
  return MPC_OK;
}

Int MPC_Debug_done(void) {
  fclose(dbg_file);
}

Int MPC_Debug_print(Int direction, const char* funcname, const char* format, ...) {
  va_list args;
  double currtime;
  double optime;
  char* left_arrow  = "<";
  char* right_arrow = ">";
  char* no_arrow    = "-";
  char* ruler = "----------------";
  char* buffer;
  Int buffer_length;
  
  char* left_string;
  char* right_string;
  char* level;

  va_start(args,format);
  buffer_length = vsprintf(NULL,format,args)+1;
  va_end(args);
  if ((buffer = (char*)malloc(sizeof(char)*buffer_length)) == NULL) return MPC_ERR_NOMEM;    
  va_start (args,format);
  vsprintf(buffer,format,args);
  
  if (dbg_filename == NULL) return;
  if (dbg_format == 0) return;

  dbg_level += (!direction);
  
  currtime = MPI_Wtime()-starttime;

  if (!direction) 
    timestack[dbg_level] = currtime; 
  else 
    optime = currtime-timestack[dbg_level];
  if (!direction) {
    left_string = no_arrow;
    right_string = right_arrow;
  }
  else {
    left_string = left_arrow;
    right_string = no_arrow;
  }
  level = ruler+(16-dbg_level);  
    
  fprintf( dbg_file, dbg_format, 
    MPC_Debug_source_name, 
    MPC_Debug_source_line, 
    MPC_Debug_source_column, 
    currtime,
    optime,
    left_string,
    dbg_rank,
    dbg_processorname, 
    level,
    right_string,
    funcname,
    buffer );
  fflush(dbg_file);
  
  dbg_level -= (direction);
  return MPC_OK;
}




