#ifndef _TOPO
#define _TOPO
#include "mpC.h"

Int MPC_The_topology_data(                  /* topology info encoding in int array format */
    MPC_Net* net,                           /* the net which topology is described */
    Int* plength,                           /* size of message in ints */
    MPC_Topology *atopology,                /* message containing topology info */
    MPC_Topology_free *afree_topology);

Int MPC_The_strategy( 
  MPC_Node parent,               /* absolute number of the node, which will be parent of the net */
  Int parent_rank,               /* linear number of the parent in the net */
  Int power,                     /* number of nodes to allocate+1 */
  Int topology_length,           /* size of topology info for requested net */
  MPC_Topology topology,         /* the requested net topology */
  Int total_nodes,               /* number of nodes in the computational space */
  Int* map );

Int MPC_The_init_strategy(void); 

Int MPC_The_get_env(
    Int power,
    int* pargc, 
    LPPSTR* pargv, 
    Int* penv_length,
    Int** penvironment );

Int MPC_The_processors_info(
    Int* num_of_processors,
    double** relative_performance );

#endif
