/*
 *  Function   - abnormal terminate whole the MPC run-time. No buffer or 
 *               process cleanup assumed.
 *  Invoked by - any node, including the disptcher.
 *  Parameters - error code.
 *  Exceptions - none
 */
int [*]MPC_Abort( repl errcode );

/*
 *  Function   - terminate the MPC run-time.
 *  Invoked by - every process at the end of the work. 
 *               It is point of global syncronization.
 *  Parameters - exit code for a shell.
 *  Exceptions -
 */
int [*]MPC_Exit( repl exitcode );

/*
 * Function    - prints from any node, using dispatcer print service
 * Invoked by - any node
 * Parameters - 
 */

int MPC_Printf( const char* format, ... );

/*
 * Function - returns floating-point number of seconds, representing elapsed 
 *            wall-clock time since some time in the past.
 * Invoked by - any node
 * Parameters - none
 */

double MPC_Wtime(void);

/*
 *  Function   - returns number of nodes in computational space
                 (maximum number of processes of a parallel program)
 *  Invoked by - any node
 *  Parameters - none
 *  Exceptions - none
 */
repl int MPC_Total_nodes(void);


void MPC_Refresh_landscape(void);


nettype SimpleNet(n) { coord I=n; };

int [net SimpleNet(n) w] MPC_Assign( repl const * source,
                                     void * s_buffer,
                                     int const s_step,
                                     repl const count,
                                     repl const * destination,
                                     void * d_buffer,
                                     int const d_step);

int [net SimpleNet(n) w] MPC_Bcast( repl const * source,
                                    void * s_buffer,
                                    int const s_step,
                                    repl const count,
                                    void * d_buffer,
                                    int const d_step);

int [net SimpleNet(n) w] MPC_Scatter( repl const * source,
                                      void * s_buffer,
                                      int const *disps,
                                      int const *lens,
                                      const count,
                                      void * d_buffer);

int [net SimpleNet(n) w] MPC_Gather( repl const * source,
                                     void * d_buffer,
                                     int const *disps,
                                     int const *lens,
                                     const count,
                                     void * s_buffer);

int [net SimpleNet(n) w] MPC_Barrier( void );

int [*]MPC_Global_barrier(void);

/*
 *  Function - returns number of phisical processors and their performances.
 */
int [*]MPC_Processors_static_info( repl int* num_of_processors, 
                               repl double** performances );
#define MPC_Processors MPC_Processors_static_info

/*
 *  Function - returns performances of processes
 */
int [*]MPC_Processes_static_info(repl double* performances);
#define MPC_Get_processes_info MPC_Processes_static_info

/*
 *  Function - returns number of phisical processors.
 */
repl int MPC_Get_number_of_processors(void);

/*
 *  Function - returns performances of phisical processors in 
               integer array imap (if imap!=NULL) and/or double
               array dmap (if dmap!=NULL).
 */
void [*]MPC_Get_processors_info( repl int* imap,
                              repl double* dmap );

/*
 *  Function - set performances of phisical processors to values
               defined by array map.
 */
/* int [*]MPC_Set_processors_info( int  *map ); */





