/* mpC-compiler, pass 2:               "SEMANTICS"                  */
/* ====================                 =========                   */
/*                                                                  */
/* Copyright (c) 1995-1999      Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*     =============== Initial revision, 1999/06/09 ==========      */


#include "context.h"
#include "Tree.h"
#include "mpc_diag.h"
#include "options.h"
#include "mpc_pass1.h"
#include "mpc_pass2.h"
#include "topo_fun.h"

#include "Errors.h"

/*********/extern FILE *tree; extern char *treefile; /*** for MPCC_DEBUG; ***/

     /* Global definitions used by attribute evaluation: */

tTree	TopoParams;	/* = MPC_NetType.ParamList  -- for coord,node,link & parent; */
tTree	Coords;		/* = MPC_NetType.CoordDecl  -- for node, link & parent;      */
tTree	FreeCoords;	/* = MPC_LinkDecl.FreeCoord -- for link;		     */

extern
bool    AbsoluteNodes,
	RelativeNodes;


     /* Work data definitions for generation of topo-functions: */

tTree	Pointer_To_Int,		/* int * ...;		     */
	Pointer_To_ConstInt,	/* const int * ...; 	     */
        Point_To_Point_To_Int,  /* int ** ...;               */
	Pointer_To_Void,        /* void * ...;               */
	VoidPoint_Function,	/* void *f();                */
	TopoGraph_Type,	/* typedef void *MPC_Topo_graph;     */
	Point_To_Point_To_TopoGraph, /* MPC_Topo_graph **...;*/
	MPI_Int_Type;	/* typedef int Int;		     */
tTree	node_Type,	/* type of topo-function 'node()',   */
	link_Type,	/*                       'link()',   */
	parent_Type,	/*                       'parent()', */
	power_Type,	/*                       'power()',  */
	number_Type,    /*                       'number()', */
	coord_Type,	/*                       'coord()',  */
	mapping_Type;	/*                       'mapping()';*/

static
tString MINUS_ONE = "-1",	/* for generation of n_init_TopoPattern; */
	Symbolic_IntConst[] = {"0",   "1",   "2",   "3",   "4",   "5",   "6",   "7",
                               "8",   "9",   "10",  "11",  "12",  "13",  "14",  "15",
                               "16",  "17",  "18",  "19",  "20",  "21",  "22",  "23",
                               "24",  "25",  "26",  "27",  "28",  "29",  "30",  "31",
                               "32",  "33",  "34",  "35",  "36",  "37",  "38",  "39",
                               "40",  "41",  "42",  "43",  "44",  "45",  "46",  "47",
                               "48",  "49",  "50",  "51",  "52",  "53",  "54",  "55",
                               "56",  "57",  "58",  "59",  "60",  "61",  "62",  "63",
                               "64",  "65",  "66",  "67",  "68",  "69",  "70",  "71",
                               "72",  "73",  "74",  "75",  "76",  "77",  "78",  "79",
                               "80",  "81",  "82",  "83",  "84",  "85",  "86",  "87",
                               "88",  "89",  "90",  "91",  "92",  "93",  "94",  "95",
                               "96",  "97",  "98",  "99",  "100", "101", "102", "103",
                               "104", "105", "106", "107", "108", "109", "110", "111",
                               "112", "113", "114", "115", "116", "117", "118", "119",
                               "120", "121", "122", "123", "124", "125", "126", "127",
                               "128", "129", "130", "131", "132", "133", "134", "135",
                               "136", "137", "138", "139", "140", "141", "142", "143",
                               "144", "145", "146", "147", "148", "149", "150", "151",
                               "152", "153", "154", "155", "156", "157", "158", "159",
                               "160", "161", "162", "163", "164", "165", "166", "167",
                               "168", "169", "170", "171", "172", "173", "174", "175",
                               "176", "177", "178", "179", "180", "181", "183", "183",
                               "184", "185", "186", "187", "188", "189", "190", "191",
                               "192", "193", "194", "195", "196", "197", "198", "199",
                               "200", "201", "202", "203", "204", "205", "206", "207",
                               "208", "209", "210", "211", "212", "213", "214", "215",
                               "216", "217", "218", "219", "220", "221", "222", "223",
                               "224", "225", "226", "227", "228", "229", "230", "231",
                               "232", "233", "234", "235", "236", "237", "238", "239",
                               "240", "241", "242", "243", "244", "245", "246", "247",
                               "248", "249", "250", "251", "252", "253", "254", "255"
        };


  static
  tString Symbolic_100 = "100";



tTypeFlags	FuncType_TopoFlags	/* default for type of topo-functions; */
			= { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, YES, NO, NO, NO, NO, NO, };
tDeclFlags	Local_TopoFlags 	/* default for local vars; */
			= { YES, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, 0 };
tDeclFlags	Param_TopoFlags		/* default for parameters; */
			= { NO, NO, NO, YES, NO, NO, NO, NO, NO, NO, NO, NO, 0 };
tStatFlags	Stat_TopoFlags		/* default for statements; */
			= { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, 0 };
tExprFlags	Expr_TopoFlags		/* default for expression; */
			= { NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, NO, 0 };

extern char EmptyString[];

extern void *malloc();

int No_VoidNodes  ARGS((tTree Node));



/***********************************************************************/
/************************ F U N C T I O N S ****************************/
/***************** for generation of topo-function *********************/

/*******************/
void Emit_TopoTypes()
/*******************/
{
  tTree param, tmp;
  tTree Emit_NumberParam  ARGS((void)),
	Emit_Pparameters  ARGS((void)),
	Emit_CoordParam   ARGS((void)),
	Emit_RootParam    ARGS((void)),
        Emit_CommonParams ARGS((tTree prev_params));

  Push_Pattern(
    Clean_OutAttributes(
	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, IntType
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Pointer_To_Int = Make_Type();
  Push_Pattern(
    Clean_OutAttributes(
    	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, ConstIntType
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Pointer_To_ConstInt = Make_Type();
  Push_Pattern(
    Clean_OutAttributes(
    	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, Pointer_To_Int
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Point_To_Point_To_Int = Make_Type();
  Push_Pattern(
    Clean_OutAttributes(
    	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, VoidType
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Pointer_To_Void = Make_Type();
  TopoGraph_Type = mMPC_Typedef(NoPosition, NoTree, NoTree, NoTypeFlag,
			MakeIdent("MPC_Topo_graph", 14), Pointer_To_Void
		   );
  Clean_OutAttributes(TopoGraph_Type);
  TopoGraph_Type->MPC_Type.Next = TopoGraph_Type->MPC_Type.Prev = mMPC_FreeNode(NoTree);
  Push_Pattern(
    Clean_OutAttributes(
    	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, NoTree
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Push_Pattern(
    Clean_OutAttributes(
    	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag,  1, 1, TopoGraph_Type
	)
    )
  );
  TopType()->MPC_PointerType.DynStep = nMPC_FreeNode();
  Point_To_Point_To_TopoGraph = Make_Type();

  tmp = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			Pointer_To_Void, NoTree, NO_NET, NoTree, param=nMPC_FreeNode()
	);
  Clean_OutAttributes(tmp);
  param->MPC_FreeNode.Parent = tmp;
  Push_Pattern(tmp);
  VoidPoint_Function = Make_Type();


	/* types of topo-functions: */


		/* node() : */

  tmp = nMPC_FreeNode();
  param = Emit_NumberParam();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  tmp = param;
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  node_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			IntType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		);
  Clean_OutAttributes(node_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = node_Type;
  Push_Pattern(node_Type);
  node_Type = Make_Type();

		/* link() : */

  tmp = nMPC_FreeNode();
  param = Emit_NumberParam();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("pnum1",5);
  tmp = param;
  param = Emit_NumberParam();
  param->MPC_VarDecl.Next =
	param->MPC_VarDecl.Prev = tmp;
  param->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("pnum2",5);
  tmp = param;
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  link_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			IntType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		);
  Clean_OutAttributes(link_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = link_Type;
  Push_Pattern(link_Type);
  link_Type = Make_Type();

		/* parent() : */

  tmp = nMPC_FreeNode();
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  parent_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			IntType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		);
  Clean_OutAttributes(parent_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = parent_Type;
  Push_Pattern(parent_Type);
  parent_Type = Make_Type();

		/* power() : */

  power_Type = parent_Type;

		/* number() : */

  tmp = nMPC_FreeNode();
  param = Emit_CoordParam();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  tmp = param;
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  number_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			IntType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		);
  Clean_OutAttributes(number_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = number_Type;
  Push_Pattern(number_Type);
  number_Type = Make_Type();

		/* coord() : */

  tmp = nMPC_FreeNode();
  param = Emit_NumberParam();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  tmp = param;
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  tmp = param;
  param = Emit_CoordParam();
  param->MPC_VarDecl.DeclSpecifier = IntType;
  param->MPC_VarDecl.Var->MPC_Var.Type = Pointer_To_Int;
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  coord_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			VoidType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		);
  Clean_OutAttributes(coord_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = coord_Type;
  Push_Pattern(coord_Type);
  coord_Type = Make_Type();



		/* mapping() : */

  tmp = nMPC_FreeNode();
  param = Emit_RootParam();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  tmp = param;
  param = Emit_Pparameters();
  param->MPC_VarDecl.Next =
	 param->MPC_VarDecl.Prev = tmp;
  param = Emit_CommonParams(param);
  mapping_Type = mMPC_FunctionType(
			NoPosition, NoTree, NoTree, FuncType_TopoFlags, 0, NODAL,
			DoubleType, NoTree, NO_NET, NoTree, param=ReverseTree(param)
		 );
  Clean_OutAttributes(mapping_Type);
  param->MPC_VarDecl.Prev->MPC_FreeNode.Parent = mapping_Type;
  Push_Pattern(mapping_Type);
  mapping_Type = Make_Type();



}

/***************/
tTree Emit_Header
/***************/
#if defined __STDC__ | defined __cplusplus
	(int func)
#else
	(func)
	int func;
#endif
{
  tTree root, name, param=NoTree, body, tmp;
  tTree Emit_NumberParam  ARGS((void)),
	Emit_Pparameters  ARGS((void)),
	Emit_CoordParam   ARGS((void)),
	Emit_RootParam    ARGS((void)),
	Emit_CommonParams ARGS((tTree prev_params));

	/* emit name and parameters: */

  root = mMPC_Function(
		NoPosition, NoTree, NoTree, NODAL, NoDeclFlag, SINGLE_NODE,
		NoTree, NoTree, NoTree, NoTree
	 );
  tmp = mMPC_FreeNode(root);  /* for 'name'; */

  root->MPC_Function.Name = name =
	mMPC_Var(
		NoPosition, NoIdent, NoDeclFlag, tmp, tmp,
		NoTree, SINGLE_NODE, NoTree
	);
  root->MPC_Function.Flag.Exported = YES;
  name->MPC_Var.Flag.Exported = YES;
  root->MPC_Function.Flag.Source = NO;
  name->MPC_Var.Flag.Source = NO;

  tmp = mMPC_FreeNode(root);  /* for 'param'; */

  switch(func) {
    case NODE_FUNC:
	name->MPC_Var.Ident = MakeIdent("node",4);
	name->MPC_Var.Type =
		root->MPC_Function.Type = node_Type;
	param = Emit_NumberParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;
    case LINK_FUNC:
	name->MPC_Var.Ident = MakeIdent("link",4);
	name->MPC_Var.Type =
		root->MPC_Function.Type = link_Type;
	param = Emit_NumberParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("pnum1",5);
	tmp = param;
	param = Emit_NumberParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("pnum2",5);
	tmp = param;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;
    case PARENT_FUNC:
	name->MPC_Var.Ident = MakeIdent("parent",6);
	name->MPC_Var.Type =
		root->MPC_Function.Type = parent_Type;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;
    case POWER_FUNC:
	name->MPC_Var.Ident = MakeIdent("power",5);
	name->MPC_Var.Type =
		root->MPC_Function.Type = power_Type;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;
    case NUMBER_FUNC:
	name->MPC_Var.Ident = MakeIdent("coord2number",12);
	name->MPC_Var.Type =
		root->MPC_Function.Type = number_Type;
	param = Emit_CoordParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;
    case COORD_FUNC:
	name->MPC_Var.Ident = MakeIdent("number2coord",12);
	name->MPC_Var.Type =
		root->MPC_Function.Type = coord_Type;
	param = Emit_NumberParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_CoordParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	param = Emit_CommonParams(param);
	break;


    case MAPPING_FUNC:
	name->MPC_Var.Ident = MakeIdent("mapping",7);
	name->MPC_Var.Type =
		root->MPC_Function.Type = mapping_Type;
	param = Emit_RootParam();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_Pparameters();
	param->MPC_VarDecl.Next =
		param->MPC_VarDecl.Prev = tmp;
	tmp = param;
	param = Emit_CommonParams(param);
	break;

    default:
	CompilerError("Pass 2, Emit_Header()", NoPosition);
  } /*** end switch ***/

  root->MPC_Function.ParamList = ReverseTree(param);

	/* emit pattern for body of function: */

  tmp = mMPC_FreeNode(root);

  root->MPC_Function.Stats = body =
	Clean_OutAttributes(
		mMPC_Compound(
			NoPosition, tmp, tmp, Stat_TopoFlags, NoTree, YES, NoTree, NoTree
		)
	);
  tmp = mMPC_FreeNode(body);
  body->MPC_Compound.ExecNet = SINGLE_NODE_LIST;
  body->MPC_Compound.UniqueNumber = Make_UniqueNumber(body);
  body->MPC_Compound.Flag.Source = NO;

  return root;
}

/*************/
tTree Emit_Node
/*************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, current, result, stat, lop, rop, tmp, vardecl;
  tTree coord_func, coord_array, pnum, pparam, ppower, pnodes, plinks;
  tTree	Copy_TopoExpr ARGS((tTree expr, tTree coord, tTree pparam)),
	Emit_CoordArray ARGS((tTree coord));
  int All_ScalarNodes ARGS((tTree Node));
  int node_type;
  tString node_code;

  root = Emit_Header(NODE_FUNC);

  body = root->MPC_Function.Stats;

  tmp = mMPC_FreeNode(body);  /* for Stats; */

  if(!NetType->MPC_NetType.NodeDecl ||
     All_ScalarNodes(NetType->MPC_NetType.NodeDecl)) {  /* all scalar nodes: */
    node_type = SCALAR_NODE;
    node_code = (tString)malloc(SCALAR_NODE/10+2);
    sprintf(node_code, "%1d\0", SCALAR_NODE);
    result = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, node_code, SCALAR_NODE
	     );
    Clean_OutAttributes(result);
    stat = Clean_OutAttributes(
		mMPC_Return(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, result)
	   );
    body->MPC_Compound.Decls = mMPC_FreeNode(body);
  }
  else {  /* The topology has explicit node declaration: */

    pnum = root->MPC_Function.ParamList->MPC_VarDecl.Var;
    vardecl = root->MPC_Function.ParamList->MPC_VarDecl.Next;  /* int *pparam */
    pparam = root->MPC_Function.ParamList->MPC_VarDecl.Next->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    ppower = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    pnodes = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    plinks = vardecl->MPC_VarDecl.Var;

    if( No_VoidNodes(NetType->MPC_NetType.NodeDecl) ) {
      coord_func = NetType->MPC_NetType.TopoFunctions->
		   MPC_TopoFunctions.Node_Coord_Def->MPC_Function.Name;
      current = body->MPC_Compound.Decls = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
      current->MPC_VarDecl.Next =
	  current->MPC_VarDecl.Prev = mMPC_FreeNode(body);
      coord_array = current->MPC_VarDecl.Var;

      /* 1) call number2coord(num,ppar,coords): */
      result = mMPC_CallExpr(
		  NoPosition, Expr_TopoFlags, EmptyString, VoidType,
		  SINGLE_NODE_LIST, SINGLE_NODE, NoTree, NoTree, NoTree
	       );
      Clean_OutAttributes(result);
      result->MPC_CallExpr.Function =
    	Clean_OutAttributes(
	     mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
		coord_func->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
		coord_func->MPC_Var.Ident, coord_func
	     )
	);
      {
        tTree tmp;
        tmp = mMPC_FreeNode(result);
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* num: */
	        Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, root->MPC_Function.ParamList->
			MPC_VarDecl.Var->MPC_Var.Ident, root->MPC_Function.ParamList->
			MPC_VarDecl.Var
		  )
		)
	      );
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* ppar: */
	        Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, pparam->MPC_Var.Ident, pparam
		  )
		)
	      );
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* coords: */
    		Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, coord_array->MPC_Var.Ident, coord_array
		  )
		)
	      );
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* ppower: */
    		Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, ppower->MPC_Var.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower
		  )
		)
	      );
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* pnodes: */
    		Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, pnodes->MPC_Var.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes
		  )
		)
	      );
        tmp = mMPC_Exprs(NoPosition, tmp, tmp, /* plinks: */
    		Clean_OutAttributes(
		  mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, plinks->MPC_Var.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks
		  )
		)
	      );
        result->MPC_CallExpr.ArgList = ReverseTree(tmp);
      }
      stat = mMPC_ExprStat(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, result);
      Clean_OutAttributes(stat);

      /* 2) emit 'if(...) return...' for explicit nodes and 'return...' for default; */

      {
        tTree cond, ret_stat;
        bool no_default=true;
        current = NetType->MPC_NetType.NodeDecl;
        while(current->Kind==kMPC_Node) {
          node_type = current->MPC_Node.NodeType;
	  if(current->MPC_Node.DynamicType &&  /** and 'bench' specifier with const expr: **/
	     current->MPC_Node.NodeQual->Kind==kMPC_BenchQual &&
	     current->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->Kind==kMPC_FloatConst)
	    node_type = 100 * current->MPC_Node.NodeQual->MPC_BenchQual.Capacity;
          node_code = (tString)malloc(node_type/10+3);
          sprintf(node_code, "%1d\0", node_type);
	  if(current->MPC_Node.DynamicType &&  /** and common form of 'bench' specifier: **/
	     current->MPC_Node.NodeQual->Kind==kMPC_BenchQual &&
	     current->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->Kind!=kMPC_FloatConst) {
	    rop = Copy_TopoExpr(
		     current->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr,
		     coord_array, pparam
		  );
	    /** -- Float point node capacity ? -- **/
	    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, MakeIdent("MPC_FIXPOINT_SCALE",18), nMPC_FreeNode()
		  );
    	    Clean_OutAttributes(lop);
	    rop->MPC_Expr.Flag.InParentheses = YES;
	    result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString,
			current->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->MPC_Expr.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
		     );
    	    Clean_OutAttributes(result);
	    result->MPC_Expr.Flag.InParentheses = YES;
	    result = mMPC_CastExpr(NoPosition, Expr_TopoFlags, EmptyString,
			IntType, SINGLE_NODE_LIST, SINGLE_NODE, IntType, result
		     );
	  }
	  else   /* old fashioned node type or constant 'bench' specifier: */
            result =  mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, node_code, node_type
		      );
    	  Clean_OutAttributes(result);
	  if(current->MPC_Node.DynamicType &&
	     current->MPC_Node.NodeQual->Kind==kMPC_NodeTypeQual) {
	    int fast_or_slow;
	    tString fast_or_slow_code;
	    fast_or_slow = current->MPC_Node.NodeQual->MPC_NodeTypeQual.Fast ? FAST : SLOW;
	    fast_or_slow_code = (tString)malloc(3);
	    sprintf(fast_or_slow_code, "%1d\0", fast_or_slow);
	    lop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, fast_or_slow_code, fast_or_slow
		  );
    	    Clean_OutAttributes(lop);
	    rop = Copy_TopoExpr(
		     current->MPC_Node.NodeQual->MPC_NodeTypeQual.CapacityExpr,
		     coord_array, pparam
		  );
	    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
		  );
    	    Clean_OutAttributes(rop);
	    result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, result, rop
		     );
    	    Clean_OutAttributes(result);
	  }
          ret_stat = mMPC_Return(
			NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, result
		     );
    	  Clean_OutAttributes(ret_stat);
          if(!current->MPC_Node.Predicate) {  /* default-predicate: */
	    no_default = false;
	    ret_stat->MPC_Stat.Next = ret_stat->MPC_Stat.Prev = stat;
	    stat = ret_stat;
          }
          else {  /* expr-predicate: */
	    cond = Copy_TopoExpr(current->MPC_Node.Predicate, coord_array, pparam);
	    stat =  mMPC_If(
		       NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, cond, ret_stat
		    );
    	    Clean_OutAttributes(stat);
	    ret_stat->MPC_Stat.Next = ret_stat->MPC_Stat.Prev = mMPC_FreeNode(stat);
          }
          current = current->MPC_Node.Next;
        } /* end while */

        /* 3) emit 'return VOID_NODE' if default-predicate is omitted: */

        if(no_default) {
          node_code = (tString)malloc(VOID_NODE/10+2);
          sprintf(node_code, "%1d\0", VOID_NODE);
	  result = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, node_code, VOID_NODE
	           );
    	  Clean_OutAttributes(result);
          stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);
    	  Clean_OutAttributes(stat);
        }
      } /* end block */

    } /* end if-then: no void nodes */

    else {  /* void nodes in topology: */
      tTree Emit_FirstPowerCall ARGS((tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks));

      stat = Emit_FirstPowerCall(NetType, pparam, ppower, pnodes, plinks);
      stat->MPC_Stat.Next = stat->MPC_Stat.Prev = tmp;  /* MPC_FreeNode */

      lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		       SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnodes", 6), pnodes);
      Clean_OutAttributes(lop);
      lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
      Clean_OutAttributes(lop);
      lop->MPC_Expr.Flag.InParentheses = YES;
      tmp = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		          SINGLE_NODE_LIST, SINGLE_NODE, Symbolic_IntConst[2], 2);
      Clean_OutAttributes(tmp);
      rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnum", 4), pnum);
      Clean_OutAttributes(rop);
      rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			    SINGLE_NODE_LIST, SINGLE_NODE, MULT, tmp, rop);
      Clean_OutAttributes(rop);
      result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			       SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
      Clean_OutAttributes(result);
      stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);
      Clean_OutAttributes(stat);

    }  /*end else: void nodes in topology */

  } /* end else: explicit nodes */

  body->MPC_Compound.Stats = ReverseTree(stat);
  return root;
}

/*************/
tTree Emit_Link
/*************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, current, result, stat, lop, rop, tmp, tmp1, vardecl, var;
  tTree number_func, pnum1, pnum2, pparam, ppower, pnodes, plinks, calloc;
  tTree coordinate, coord_array1, coord_array2, n1, n2, free_coords=NoTree;
  tTree Emit_FirstPowerCall ARGS((tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks));
  tTree Emit_CoordLoops ARGS((tTree coord, tTree stat, tTree pparam, tTree coordinate));
  tTree Emit_FreeCoord ARGS((tTree coord)),
	Emit_FreeCoordLoops ARGS((tTree coord, tTree stat, tTree coordinate, tTree free_coords, tTree pparam));
  tTree Emit_LinkIfGroup ARGS((tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks, tTree coordinate, tTree coord_array1, tTree coord_array2, tTree free_coords, tTree pnum1, tTree pnum2, tTree number_func));
  tTree Copy_TopoExpr ARGS((tTree expr, tTree coord, tTree pparam)),
	Emit_CoordArray ARGS((tTree coord));
  tTree Emit_PairCheck(tTree,tTree,tTree,tTree,tTree);				/* -- ??? */
  int   Reset_FreeCoord_Store(tTree,tTree);					/* -- ??? */
  int link_type = NORMAL_LINK;
  tString link_code;

  root = Emit_Header(LINK_FUNC);

  body = root->MPC_Function.Stats;

  stat = mMPC_FreeNode(body);  /* for Stats; */


  if(RelativeNodes || !AbsoluteNodes) {

    link_type = NO_LINK;
    link_code = (tString)malloc(link_type/10+3);
    sprintf(link_code, "%1d\0", link_type);
    stat = mMPC_Return(
		NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST,
		mMPC_IntConst(
			NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, link_code, link_type
		)
	   );
    Clean_OutAttributes(stat);
  }
  else if(!NetType->MPC_NetType.LinkDecl) {  /* all normal links: */

    link_type = NO_LINK; /*NORMAL_LINK in previous version */
    link_code = (tString)malloc(NO_LINK/10+2);  /*NORMAL_LINK in previous version */
    sprintf(link_code, "%1d\0", NO_LINK);       /*NORMAL_LINK in previous version */
    result = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, link_code, NO_LINK /*NORMAL_LINK in previous version */
	     );
    Clean_OutAttributes(result);
    stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);
    Clean_OutAttributes(stat);
    body->MPC_Compound.Decls = mMPC_FreeNode(body);

  }
  else {  /* there are links of different length or nodes without links: */

    vardecl = root->MPC_Function.ParamList;
    pnum1 = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    pnum2 = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    pparam = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    ppower = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    pnodes = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    plinks = vardecl->MPC_VarDecl.Var;
    number_func = NetType->MPC_NetType.TopoFunctions->
		 MPC_TopoFunctions.Node_Number_Def->MPC_Function.Name;

    current = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
    coordinate = current->MPC_VarDecl.Var;
    current->MPC_VarDecl.Next = current->MPC_VarDecl.Prev = mMPC_FreeNode(body);
    tmp = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
    tmp->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("c1",2);
    n1 = mMPC_Var(NoPosition, MakeIdent("n1",2), Local_TopoFlags,
		  tmp->MPC_VarDecl.Var, tmp->MPC_VarDecl.Var, IntType,
		  SINGLE_NODE, nMPC_FreeNode()
	 );
    n1->MPC_Var.Init->MPC_FreeNode.Parent = n1;
    tmp->MPC_VarDecl.Var = ReverseTree(n1);
    tmp->MPC_VarDecl.Next = tmp->MPC_VarDecl.Prev = current;
    coord_array1 = tmp->MPC_VarDecl.Var;
    vardecl = tmp;
    tmp = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
    tmp->MPC_VarDecl.Var->MPC_Var.Ident = MakeIdent("c2",2);
    n2 = mMPC_Var(NoPosition, MakeIdent("n2",2), Local_TopoFlags,
		  tmp->MPC_VarDecl.Var, tmp->MPC_VarDecl.Var, IntType,
		  SINGLE_NODE, nMPC_FreeNode()
	 );
    n2->MPC_Var.Init->MPC_FreeNode.Parent = n2;
    tmp->MPC_VarDecl.Var = ReverseTree(n2);
    tmp->MPC_VarDecl.Next = tmp->MPC_VarDecl.Prev = vardecl;
    coord_array2 = tmp->MPC_VarDecl.Var;
    current = Emit_FreeCoord(NetType->MPC_NetType.LinkDecl->MPC_LinkDecl.FreeCoord);
    if(current) {
      current->MPC_VarDecl.Next = current->MPC_VarDecl.Prev = tmp;
      free_coords = current->MPC_VarDecl.Var;
    }
    else
      current = tmp;
    current = mMPC_VarDecl(NoPosition, current, current, EXTERN, Local_TopoFlags, VoidType, NoTree);
    var = mMPC_FreeNode(current);
    var = mMPC_Var(NoPosition, MakeIdent("calloc", 6), Local_TopoFlags, var, var,
		   VoidPoint_Function, SINGLE_NODE, nMPC_FreeNode());
    calloc = var;
    var->MPC_Var.Init->MPC_FreeNode.Parent = var;
    current->MPC_VarDecl.Var = var;
    body->MPC_Compound.Decls = ReverseTree(current);


    /* 1. emit 'if(...) power(...)' : */

    /* stat is MPC_FreeNode */
    tmp1 = Emit_FirstPowerCall(NetType, pparam, ppower, pnodes, plinks);
    tmp1->MPC_Stat.Next = tmp1->MPC_Stat.Prev = stat;			/* if(...) ppower=power(...); */


    /* 2. emit '*plinks = (int*)calloc(...);' */

    stat = nMPC_FreeNode();
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower);
    Clean_OutAttributes(lop);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower);
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop);		/* ppower*ppower */
    Clean_OutAttributes(lop);
    tmp = nMPC_FreeNode();
    lop = mMPC_Exprs(NoPosition, tmp, tmp, lop);
    rop = mMPC_Size_Of_Type(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			    SINGLE_NODE_LIST, SINGLE_NODE, false, sizeof(int), IntType);
    Clean_OutAttributes(rop);
    rop = mMPC_Exprs(NoPosition, lop, lop, rop);
    rop = ReverseTree(rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, VoidPoint_Function,
		     SINGLE_NODE_LIST, SINGLE_NODE, calloc->MPC_Var.Ident, calloc);
    Clean_OutAttributes(lop);
    rop = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Void,
			  SINGLE_NODE_LIST, SINGLE_NODE, lop, rop, nMPC_FreeNode()); /* calloc(2*pow*...) */
    Clean_OutAttributes(rop);
    tmp->MPC_FreeNode.Parent = rop;
    rop->MPC_CallExpr.NetworkArgList->MPC_FreeNode.Parent = rop;
    rop = mMPC_CastExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			  SINGLE_NODE_LIST, SINGLE_NODE, Pointer_To_Int, rop);       /* (int*)malloc(...) */
    Clean_OutAttributes(rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks);
    Clean_OutAttributes(lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);		     /* *plinks */
    Clean_OutAttributes(lop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		          SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(lop);
    tmp = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop); /* *plinks=(int*)... */
    Clean_OutAttributes(tmp);


    /* 3. emit 'if( <predicate> ) { ... }' groups : */

    stat = Emit_LinkIfGroup(NetType, pparam, ppower, pnodes, plinks, coordinate,
			    coord_array1, coord_array2, free_coords, n1/*pnum1*/, n2/*pnum2*/,
			    number_func);


    /* 4. emit for-loops for every coordinate (incl. free coordinate): */

    stat = Emit_CoordLoops(NetType->MPC_NetType.CoordDecl, stat, pparam, coordinate);     /* recursive call */
    stat = Emit_FreeCoordLoops(NetType->MPC_NetType.LinkDecl->MPC_LinkDecl.FreeCoord,
			       stat, coordinate, free_coords, pparam); /* returns 'stat' when no free coords */
    stat->MPC_Stat.Next = stat->MPC_Stat.Prev = tmp;


    /* 5. emit 'if(!(*plinks)) { ... }' : */

    tmp = nMPC_FreeNode();
    stat = mMPC_Compound(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST,
			 NO, NoTree, ReverseTree(stat));
    Clean_OutAttributes(stat);
    stat->MPC_Compound.Decls = mMPC_FreeNode(stat);
    stat->MPC_Compound.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks);
    Clean_OutAttributes(lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
    Clean_OutAttributes(lop);
    lop->MPC_Expr.Flag.InParentheses = YES;
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, LOG_NOT, lop);			  /* !(*plinks) */
    Clean_OutAttributes(lop);
    stat = mMPC_If(NoPosition, tmp1/* power call */, tmp1, Stat_TopoFlags, SINGLE_NODE_LIST, lop, stat);
    Clean_OutAttributes(stat);
    stat->MPC_If.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;


    /* 6. emit 'return (*plinks)[pnum1*ppower + pnum2];' */

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks);
    Clean_OutAttributes(lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
    Clean_OutAttributes(lop);
    lop->MPC_Expr.Flag.InParentheses = YES;					/* (*plinks) */
    tmp = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnum1->MPC_Var.Ident, pnum1);
    Clean_OutAttributes(tmp);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower);
    Clean_OutAttributes(rop);
    tmp = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, tmp, rop);
    Clean_OutAttributes(tmp);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnum2->MPC_Var.Ident, pnum2);
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, tmp, rop);	/* pnum1*ppower + pnum2 */
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
    Clean_OutAttributes(rop);
    stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, rop);
    Clean_OutAttributes(stat);

  }  /* end if-else */

  /* Release 'Init' by all 'free_coords' : */
  while(free_coords!=NoTree && free_coords->Kind==kMPC_Var) {
    free_coords->MPC_Var.Init = NoTree;
    free_coords = free_coords->MPC_Var.Next;
  }

  body->MPC_Compound.Stats = ReverseTree(stat);
  return root;
}

/***************/
tTree Emit_Parent
/***************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, current, result, stat, lop, rop, tmp;
  tTree number_func, coord_array, coord_expr, pparam, ppower, pnodes, plinks, vardecl;
  tTree Copy_TopoExpr(tTree,tTree,tTree), Emit_CoordArray(tTree);

  root = Emit_Header(PARENT_FUNC);

  number_func = NetType->MPC_NetType.TopoFunctions->
		MPC_TopoFunctions.Node_Number_Def->MPC_Function.Name;
  vardecl = root->MPC_Function.ParamList;
  pparam = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  ppower = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  pnodes = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  plinks = vardecl->MPC_VarDecl.Var;
  body = root->MPC_Function.Stats;
  current = body->MPC_Compound.Decls = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
  current->MPC_VarDecl.Next = current->MPC_VarDecl.Prev = mMPC_FreeNode(body);
  coord_array = current->MPC_VarDecl.Var;
  stat = mMPC_FreeNode(body);  /* end of statement list; */

  current = NetType->MPC_NetType.CoordDecl;
  coord_expr = NetType->MPC_NetType.StartDecl;
  if(Tree_IsType(coord_expr, kMPC_FreeNode)) coord_expr = NoTree;

  do {   /* initialize array of coord. of parent node: */
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, coord_array->MPC_Var.Type,
		SINGLE_NODE_LIST, SINGLE_NODE, coord_array->MPC_Var.Ident, coord_array
	  );
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType, CONST_NET_LIST,
		CONST_NET, Symbolic_IntConst[current->MPC_CoordDecl.CoordNumber],
		current->MPC_CoordDecl.CoordNumber
	  );
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop
	  );
    Clean_OutAttributes(lop);
    if(coord_expr!=NoTree && coord_expr->Kind==kMPC_Exprs)  /* parent declaration is present: */
      rop = Copy_TopoExpr(coord_expr->MPC_Exprs.Expr, NoTree/*coord*/, pparam);
    else    /* default parent node - [ 0, ... ,0 ] */
      rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0
	    );
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
		);
    Clean_OutAttributes(lop);
    stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(stat);
    current = current->MPC_CoordDecl.Next;
    if(coord_expr!=NoTree && coord_expr->Kind==kMPC_Exprs)
      coord_expr = coord_expr->MPC_Exprs.Next;
  } while(Tree_IsType(current,kMPC_CoordDecl) /*** &&
          coord_expr!=NoTree && coord_expr->Kind==kMPC_Exprs ***/ );

  result = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, NoTree, NoTree, NoTree
	   );
  Clean_OutAttributes(result);
  result->MPC_CallExpr.Function =
      	Clean_OutAttributes(
		mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
			number_func->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
			number_func->MPC_Var.Ident, number_func
		)
	);
  tmp = mMPC_FreeNode(result);
  tmp = mMPC_Exprs(NoPosition, tmp, tmp,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
				coord_array->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
				coord_array->MPC_Var.Ident, coord_array
			)
		)
	);
  tmp = mMPC_Exprs(NoPosition, tmp, tmp,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
				pparam->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
				pparam->MPC_Var.Ident, pparam
			)
		)
	);
  tmp = mMPC_Exprs(NoPosition, tmp, tmp,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
				ppower->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
				ppower->MPC_Var.Ident, ppower
			)
		)
	);
  tmp = mMPC_Exprs(NoPosition, tmp, tmp,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
				pnodes->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
				pnodes->MPC_Var.Ident, pnodes
			)
		)
	);
  tmp = mMPC_Exprs(NoPosition, tmp, tmp,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
				plinks->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
				plinks->MPC_Var.Ident, plinks
			)
		)
	);
  result->MPC_CallExpr.ArgList = ReverseTree(tmp);

  stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);
  Clean_OutAttributes(stat);

  body->MPC_Compound.Stats = ReverseTree(stat);

  return root;
}

/**************/
tTree Emit_Power
/**************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, vardecl, var;
  tTree pparam, ppower, pnodes, plinks;     /* parameters of generated function; */
  tTree coordinate, malloc, pow, shift, i;  /* local vars of generated function; */
  tTree p, e1, e2, e3, lop, rop, stat, tmp;
  tTree Emit_CoordArray ARGS((tTree coord));
  tTree Copy_TopoExpr ARGS((tTree expr, tTree coord, tTree pparam));
  tTree Emit_NodeIfGroup ARGS((tTree NetType, tTree pparam, tTree pnodes, tTree coordinate, tTree pow, tTree shift, tTree i));
  tTree Emit_CoordLoops ARGS((tTree coord, tTree stat, tTree pparam, tTree coordinate));

  root = Emit_Header(POWER_FUNC);

  vardecl = root->MPC_Function.ParamList;
  pparam = vardecl->MPC_VarDecl.Var;

  if( !NetType->MPC_NetType.NodeDecl || No_VoidNodes(NetType->MPC_NetType.NodeDecl) ) {

    p = NetType->MPC_NetType.CoordDecl;
    lop = Copy_TopoExpr(p->MPC_CoordDecl.Range, NoTree, pparam);
  
    while(Tree_IsType(p->MPC_CoordDecl.Next, kMPC_CoordDecl)) {
      p = p->MPC_CoordDecl.Next;
      rop = Copy_TopoExpr(p->MPC_CoordDecl.Range, NoTree, pparam);
      lop = mMPC_BinaryExpr(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
	    );
      Clean_OutAttributes(lop);
    }
    p = mMPC_FreeNode(root->MPC_Function.Stats);
    p = mMPC_Return(NoPosition, p, p, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(p);
    root->MPC_Function.Stats->MPC_Compound.Stats = ReverseTree(p);

  }
  else {  /* void nodes in topology */

    vardecl = vardecl->MPC_VarDecl.Next;
    ppower = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    pnodes = vardecl->MPC_VarDecl.Var;
    vardecl = vardecl->MPC_VarDecl.Next;
    plinks = vardecl->MPC_VarDecl.Var;

    /* 1. declarations: */
    vardecl = Emit_CoordArray(NetType->MPC_NetType.CoordDecl);
    vardecl->MPC_VarDecl.Next = vardecl->MPC_VarDecl.Prev =
			 mMPC_FreeNode(root->MPC_Function.Stats);
    coordinate = vardecl->MPC_VarDecl.Var;
    var = vardecl->MPC_VarDecl.Var;
    var = mMPC_Var(NoPosition, MakeIdent("pow",3), Local_TopoFlags, var, var, IntType, SINGLE_NODE, NoTree);
    pow = var;
    var->MPC_Var.Init = mMPC_FreeNode(var);
    var = mMPC_Var(NoPosition, MakeIdent("shift",5), Local_TopoFlags, var, var, IntType, SINGLE_NODE, NoTree);
    shift = var;
    var->MPC_Var.Init = mMPC_FreeNode(var);
    var = mMPC_Var(NoPosition, MakeIdent("i",1), Local_TopoFlags, var, var, IntType, SINGLE_NODE, NoTree);
    i = var;
    var->MPC_Var.Init = mMPC_FreeNode(var);
    vardecl->MPC_VarDecl.Var = ReverseTree(var);
    vardecl = mMPC_VarDecl(NoPosition, vardecl, vardecl, EXTERN, Local_TopoFlags, VoidType, NoTree);
    var = mMPC_FreeNode(vardecl);
    var = mMPC_Var(NoPosition, MakeIdent("malloc", 6), Local_TopoFlags, var, var,
		   VoidPoint_Function, SINGLE_NODE, nMPC_FreeNode());
    malloc = var;
    var->MPC_Var.Init->MPC_FreeNode.Parent = var;
    vardecl->MPC_VarDecl.Var = var;
    root->MPC_Function.Stats->MPC_Compound.Decls = ReverseTree(vardecl);

    /* 2. emit initial checks & actions for 2-iteration loop */
    stat = nMPC_FreeNode();
    lop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, Symbolic_IntConst[2], 2);
    Clean_OutAttributes(lop);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop);		/* 2*pow */
    Clean_OutAttributes(lop);
    rop = mMPC_Size_Of_Type(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			    SINGLE_NODE_LIST, SINGLE_NODE, false, sizeof(int), IntType);
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop);		/* 2*pow*sizeof(int) */
    Clean_OutAttributes(rop);
    tmp = nMPC_FreeNode();
    rop = mMPC_Exprs(NoPosition, tmp, tmp, rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, VoidPoint_Function,
		     SINGLE_NODE_LIST, SINGLE_NODE, malloc->MPC_Var.Ident, malloc);
    Clean_OutAttributes(lop);
    rop = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Void,
			  SINGLE_NODE_LIST, SINGLE_NODE, lop, rop, nMPC_FreeNode()); /* malloc(2*pow*...) */
    Clean_OutAttributes(rop);
    tmp->MPC_FreeNode.Parent = rop;
    rop->MPC_CallExpr.NetworkArgList->MPC_FreeNode.Parent = rop;
    rop = mMPC_CastExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			  SINGLE_NODE_LIST, SINGLE_NODE, Pointer_To_Int, rop);       /* (int*)malloc(...) */
    Clean_OutAttributes(rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes);
    Clean_OutAttributes(lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);		     /* *pnodes */
    Clean_OutAttributes(lop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		          SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(lop);
    tmp = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop); /* *pnodes=(int*)... */
    Clean_OutAttributes(tmp);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, i->MPC_Var.Ident, i);
    Clean_OutAttributes(lop);
    stat = nMPC_FreeNode();
    stat = mMPC_If(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop, tmp); /* if(i) ... */
    Clean_OutAttributes(stat);
    tmp->MPC_Stat.Next->MPC_FreeNode.Parent = stat;
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0);
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		          SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(lop);
    stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(stat);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, shift->MPC_Var.Ident, shift);
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0);
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		          SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(lop);
    stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(stat);

    /* 3. if()...else if()...else... : */
    tmp = Emit_NodeIfGroup(NetType, pparam, pnodes, coordinate, pow, shift, i);

    /* 4. emit for(coordinate[...]...) for every coordinate: */
    tmp = Emit_CoordLoops(NetType->MPC_NetType.CoordDecl, tmp, pparam, coordinate);  /* recursive call */
    tmp->MPC_Stat.Next = tmp->MPC_Stat.Prev = stat;
    stat = tmp;

    /* 5. emit 2-iteration loop: */

    tmp = nMPC_FreeNode();
    stat = mMPC_Compound(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST,
			 NO, NoTree,ReverseTree(stat));
    Clean_OutAttributes(stat);
    stat->MPC_Compound.Decls = mMPC_FreeNode(stat);
    stat->MPC_Compound.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, i->MPC_Var.Ident, i);
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0);
    Clean_OutAttributes(rop);
    e1 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		         SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(e1);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, i->MPC_Var.Ident, i);
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, Symbolic_IntConst[2], 2);
    Clean_OutAttributes(rop);
    e2 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		         SINGLE_NODE_LIST, SINGLE_NODE, LESS_THEN, lop, rop);
    Clean_OutAttributes(e2);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, i->MPC_Var.Ident, i);
    Clean_OutAttributes(lop);
    e3 = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		        SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, lop);
    Clean_OutAttributes(e3);

    tmp = nMPC_FreeNode();
    stat = mMPC_For(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3, stat);
    Clean_OutAttributes(stat);
    stat->MPC_For.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;

    /* 6. emit 'return pow;' and compound stat : */

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
    Clean_OutAttributes(lop);
    stat = mMPC_Return(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(stat);

    tmp = nMPC_FreeNode();
    stat = mMPC_Compound(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST,
			 NO, NoTree,ReverseTree(stat));
    Clean_OutAttributes(stat);
    stat->MPC_Compound.Decls = mMPC_FreeNode(stat);
    stat->MPC_Compound.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;

    /* 7. emit 'if(!*pnodes) {...} else return ppower;' */

    tmp = mMPC_FreeNode(root->MPC_Function.Stats);

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("ppower", 6), ppower);
    Clean_OutAttributes(lop);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("MPC_INIT_POWER", 14), nMPC_FreeNode());
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			  SINGLE_NODE_LIST, SINGLE_NODE, EQUAL, lop, rop);
    Clean_OutAttributes(lop);
    /*** old version: ***
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		         SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		         SINGLE_NODE_LIST, SINGLE_NODE, LOG_NOT, lop);
    ********************/
    stat = mMPC_IfElse(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST,
		       lop, ReverseTree(stat), NoTree);
    Clean_OutAttributes(stat);
    stat->MPC_IfElse.Then->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;
    tmp = mMPC_FreeNode(stat);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower);
    Clean_OutAttributes(lop);
    stat->MPC_IfElse.Else = mMPC_Return(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, lop);
    Clean_OutAttributes(stat);


    root->MPC_Function.Stats->MPC_Compound.Stats = ReverseTree(stat);  /* also correct without Reverse... */

  }

  return root;
}

/***************/
tTree Emit_Number
/***************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, coord, current, result;
  tTree p, lop=NoTree, rop=NoTree, e1, e2, e3, stat, tmp;
  tTree vardecl, pcoord, pparam, ppower, pnodes, plinks;
  tTree Emit_ShiftOnCoord(tTree, tTree, tTree);
  tTree Emit_NumberParam(),
	Emit_Pparameters(),
	Emit_CoordParam(),
	Emit_n_init();
  tTree Emit_FirstPowerCall ARGS((tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks));
  tTree Emit_ShiftOnVoidNodes ARGS((tTree, tTree));
  int   No_VoidNodes(tTree);

  root = Emit_Header(NUMBER_FUNC);

  vardecl = root->MPC_Function.ParamList;
  pcoord = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  pparam = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  ppower = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  pnodes = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  plinks = vardecl->MPC_VarDecl.Var;

  body = root->MPC_Function.Stats;

  tmp = mMPC_FreeNode(body);	/* for Stats; */

  coord = NetType->MPC_NetType.CoordDecl;

  if( !NetType->MPC_NetType.NodeDecl || No_VoidNodes(NetType->MPC_NetType.NodeDecl) )  {
    body->MPC_Compound.Decls = mMPC_FreeNode(body);
    p = coord;
    lop = Emit_ShiftOnCoord(coord, pcoord, pparam);
    while(Tree_IsType(p->MPC_CoordDecl.Next, kMPC_CoordDecl)) {
      p = p->MPC_CoordDecl.Next;
      rop = Emit_ShiftOnCoord(p, pcoord, pparam);
      lop = mMPC_BinaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString,
			IntType, SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
	    );
      Clean_OutAttributes(lop);
    } /* end while */
  }
  else {  /* This net topology has void nodes: */
    body->MPC_Compound.Decls = 
	  mMPC_VarDecl(NoPosition, NoTree, NoTree, AUTO, Local_TopoFlags, IntType, NoTree);
    body->MPC_Compound.Decls->MPC_VarDecl.Var = result =
	  mMPC_Var(NoPosition, MakeIdent("n",1), Local_TopoFlags,
		   NoTree, NoTree, IntType, SINGLE_NODE, NoTree
	  );
    body->MPC_Compound.Decls->MPC_VarDecl.Var->MPC_Var.Next =
	  body->MPC_Compound.Decls->MPC_VarDecl.Var->MPC_Var.Prev = mMPC_FreeNode(body->MPC_Compound.Decls);
    body->MPC_Compound.Decls->MPC_VarDecl.Next =
	  body->MPC_Compound.Decls->MPC_VarDecl.Prev = mMPC_FreeNode(body);
    body->MPC_Compound.Decls->MPC_VarDecl.Var->MPC_Var.Init =
	  mMPC_FreeNode(body->MPC_Compound.Decls->MPC_VarDecl.Var);

    stat = Emit_FirstPowerCall(NetType, pparam, ppower, pnodes, plinks);
    stat->MPC_Stat.Next = stat->MPC_Stat.Prev = mMPC_FreeNode(body);

    /* emit 'if(...) return num;' : */

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, result->MPC_Var.Ident, result
	  );
    Clean_OutAttributes(lop);
    rop = Emit_ShiftOnVoidNodes(result, pnodes);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
          );
    Clean_OutAttributes(lop);
    rop = Emit_ShiftOnCoord(coord, pcoord, pparam);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, EQUAL, lop, rop
          );
    Clean_OutAttributes(lop);
    current = nMPC_FreeNode();  /* for If.Then */
    tmp = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, result->MPC_Var.Ident, result
	  );
    Clean_OutAttributes(tmp);
    current = mMPC_Return(NoPosition, current, current, Stat_TopoFlags, SINGLE_NODE_LIST, tmp);
    Clean_OutAttributes(current);
    current = mMPC_If(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, lop, current);
    Clean_OutAttributes(current);
    current->MPC_If.Stats->MPC_Stat.Next->MPC_FreeNode.Parent = current;

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, result->MPC_Var.Ident, result
	  );
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0
	  );
    Clean_OutAttributes(rop);
    e1 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
         );
    Clean_OutAttributes(e1);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, result->MPC_Var.Ident, result
	  );
    Clean_OutAttributes(lop);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower
	  );
    Clean_OutAttributes(rop);
    e2 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, LESS_THEN, lop, rop
         );
    Clean_OutAttributes(e2);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, result->MPC_Var.Ident, result
	  );
    Clean_OutAttributes(lop);
    e3 = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, lop
         );
    Clean_OutAttributes(e3);

    stat = mMPC_For(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3, current);
    Clean_OutAttributes(stat);

    /* ... ++++++++++++++++++++++++++++++++++++++++++++++++++ ... */
    current->MPC_If.Next = current->MPC_If.Prev = mMPC_FreeNode(stat);

    /* make the special value returned when error: */
    lop = mMPC_IntConst(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, MINUS_ONE, -1
	  );
    Clean_OutAttributes(lop);
    tmp = stat;  /* for correct list generation (see 'mMPC_Return()' below); */
  } /* end if */

  body->MPC_Compound.Stats =
      	Clean_OutAttributes(
		mMPC_Return(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, lop)
	);
  body->MPC_Compound.Stats = ReverseTree(body->MPC_Compound.Stats);

  return root;
}

/**************/
tTree Emit_Coord
/**************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, current, tmp=NoTree;
  tTree coord, p, lop, rop;
  tTree pnum, pcoord, pparam, ppower, pnodes, plinks, vardecl;
  tTree Copy_TopoExpr ARGS((tTree expr, tTree coord, tTree pparam));
  tTree Emit_FirstPowerCall ARGS((tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks));
  tTree Emit_ShiftOnVoidNodes ARGS((tTree pnum, tTree pnodes));
  int   No_VoidNodes ARGS((tTree Node));

  root = Emit_Header(COORD_FUNC);
  pnum = root->MPC_Function.ParamList->MPC_VarDecl.Var;
  pparam = root->MPC_Function.ParamList->MPC_VarDecl.Next->MPC_VarDecl.Var;
  pcoord = root->MPC_Function.ParamList->MPC_VarDecl.Next->MPC_VarDecl.Next->MPC_VarDecl.Var;
  vardecl = root->MPC_Function.ParamList->MPC_VarDecl.Next->MPC_VarDecl.Next->MPC_VarDecl.Next;
  ppower = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  pnodes = vardecl->MPC_VarDecl.Var;
  vardecl = vardecl->MPC_VarDecl.Next;
  plinks = vardecl->MPC_VarDecl.Var;

  body = root->MPC_Function.Stats;

  if(/*** No_VoidNodes(NetType->MPC_NetType.NodeDecl) && ***/
     NetType->MPC_NetType.CoordDecl->MPC_CoordDecl.Next->Kind!=kMPC_FreeNode) { /* > 1 coord: */
    tmp = mMPC_FreeNode(body);
    body->MPC_Compound.Decls = 
	  mMPC_VarDecl(NoPosition, tmp, tmp, AUTO, Local_TopoFlags,IntType, NoTree);
    tmp = mMPC_FreeNode(body->MPC_Compound.Decls);
    body->MPC_Compound.Decls->MPC_VarDecl.Var = tmp =
	  mMPC_Var(NoPosition, MakeIdent("tmp",3), Local_TopoFlags,
		   tmp, tmp, IntType, SINGLE_NODE, NoTree
	  );
  }

  current = mMPC_FreeNode(body);	/* for 'Stats' */

  if(!No_VoidNodes(NetType->MPC_NetType.NodeDecl)) {
    tTree free_node = current;
    current = Emit_FirstPowerCall(NetType, pparam, ppower, pnodes, plinks);
    current->MPC_Stat.Next = current->MPC_Stat.Prev = free_node;
  }

  coord = p = NetType->MPC_NetType.CoordDecl;

  while(coord->MPC_CoordDecl.Next->Kind==kMPC_CoordDecl) {

    /* Emit 3-statement groups for eval. of coord (except last coordinate): */

    lop = NoTree;
    while(p->MPC_CoordDecl.Next->Kind==kMPC_CoordDecl) {
      p = p->MPC_CoordDecl.Next;
      if(!lop)
	lop = Copy_TopoExpr(p->MPC_CoordDecl.Range, pcoord, pparam);
      else {
	rop = Copy_TopoExpr(p->MPC_CoordDecl.Range, pcoord, pparam);
	lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop);
        Clean_OutAttributes(lop);
      }
    } /* end while */

    rop = lop;
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, tmp->MPC_Var.Ident, tmp
	  );
    Clean_OutAttributes(lop);
    lop =  mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
	   );
    Clean_OutAttributes(lop);
    current = mMPC_ExprStat(
		  NoPosition, current, current, Stat_TopoFlags, SINGLE_NODE_LIST, lop
	      );	/* 1 statement ready; */
    Clean_OutAttributes(current);

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, pnum->MPC_Var.Ident, pnum
	  );
    Clean_OutAttributes(lop);
    if(!No_VoidNodes(NetType->MPC_NetType.NodeDecl)) {
      rop = Emit_ShiftOnVoidNodes(pnum, pnodes);
      lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
	    );
      Clean_OutAttributes(lop);
      lop->MPC_Expr.Flag.InParentheses = YES;
    }
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, tmp->MPC_Var.Ident, tmp
	  );
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, DIV, lop, rop
	  );
    Clean_OutAttributes(rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, coord->MPC_CoordDecl.Ident, coord
	  );
    Clean_OutAttributes(lop);
    lop = Copy_TopoExpr(lop, pcoord, pparam);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
	  );
    Clean_OutAttributes(lop);
    current = mMPC_ExprStat(
		  NoPosition, current, current, Stat_TopoFlags, SINGLE_NODE_LIST, lop
	      );	/* 2 statement ready; */
    Clean_OutAttributes(current);

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, pnum->MPC_Var.Ident, pnum
	  );
    Clean_OutAttributes(lop);
    if(!No_VoidNodes(NetType->MPC_NetType.NodeDecl)) {
      rop = Emit_ShiftOnVoidNodes(pnum, pnodes);
      lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
	    );
      Clean_OutAttributes(lop);
      lop->MPC_Expr.Flag.InParentheses = YES;
    }
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, tmp->MPC_Var.Ident, tmp
	  );
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, MOD, lop, rop
	  );
    Clean_OutAttributes(rop);
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, pnum->MPC_Var.Ident, pnum
	  );
    Clean_OutAttributes(lop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
	  );
    Clean_OutAttributes(lop);
    current = mMPC_ExprStat(
		  NoPosition, current, current, Stat_TopoFlags, SINGLE_NODE_LIST, lop
	      );	/* 3 statement ready; */
    Clean_OutAttributes(current);

    coord = p = coord->MPC_CoordDecl.Next;

  } /* end while */

  /* Emit evaluation of the last coordinate: */
  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, coord->MPC_CoordDecl.Ident, coord
	);
  Clean_OutAttributes(lop);
  lop = Copy_TopoExpr(lop, pcoord, pparam);
  rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, pnum->MPC_Var.Ident, pnum
	);
  Clean_OutAttributes(rop);
  if(NetType->MPC_NetType.CoordDecl->MPC_CoordDecl.Next->Kind==kMPC_FreeNode) { /* only one coordinate: */
    tTree shift;
    if(!No_VoidNodes(NetType->MPC_NetType.NodeDecl)) {
      shift = Emit_ShiftOnVoidNodes(pnum, pnodes);
      rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, rop, shift
	    );
      Clean_OutAttributes(rop);
    }
  }

  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		  SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop
	);
  Clean_OutAttributes(lop);
  current = mMPC_ExprStat(
		  NoPosition, current, current, Stat_TopoFlags, SINGLE_NODE_LIST, lop
	    );	/* evaluation of last coordinate ready; */
  Clean_OutAttributes(current);

  body->MPC_Compound.Stats = ReverseTree(current);
  return root;
}



/****************/
tTree Emit_Mapping
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType)
	tTree NetType;
#endif
{
  tTree root, body, current, tmp=NoTree;
  tTree coord, p, lop, rop;
  tTree /*pnum, pcoord,*/ pparam, /*ppower, pnodes, plinks,*/ vardecl;
  tTree Emit_CoordVars  ARGS((tTree NetType)),
	Emit_TopoParams ARGS((tTree NetType, tTree ppar)),
	Copy_TopoExpr   ARGS((tTree expr, tTree coord, tTree pparam));

  if(NetType->MPC_NetType.SchemeDecl==NoTree)
    root = NoTree;
  else {
    root = Emit_Header(MAPPING_FUNC);
    pparam = root->MPC_Function.ParamList->MPC_VarDecl.Next->MPC_VarDecl.Var;

    body = root->MPC_Function.Stats;

    tmp = mMPC_FreeNode(body);

    /* 1.Emit variables for each of coordinates:  */

    vardecl = Emit_CoordVars(NetType);
    vardecl->MPC_VarDecl.Next = vardecl->MPC_VarDecl.Prev = tmp;
    tmp = vardecl;

    /* 2.Emit variables with initialization for each of topology parameters: */

    vardecl = Emit_TopoParams(NetType, pparam);
    vardecl->MPC_VarDecl.Next = vardecl->MPC_VarDecl.Prev = tmp;

    body->MPC_Compound.Decls = ReverseTree(vardecl);
    body->MPC_Compound.Stats = NetType->MPC_NetType.SchemeDecl->MPC_Scheme.Body;
    body->MPC_Compound.Stats->MPC_Stat.Next =
           body->MPC_Compound.Stats->MPC_Stat.Prev = mMPC_FreeNode(body);

  }  /* end if...else... */

  return root;
}




/************************************************************************/
/*******************   W O R K   F U N C T I O N S   ********************/
/******************** for topo-function generation **********************/

/*********************/
tTree Emit_ShiftOnCoord
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord, tTree pcoord, tTree pparam)
#else
	(coord, pcoord, pparam)
	tTree coord, pcoord, pparam;
#endif
{
  tTree p, lop, rop;
  tTree Copy_TopoExpr(tTree, tTree, tTree);

  p = coord->MPC_CoordDecl.Next;
  lop = mMPC_Ident(  /***!!!!!!***/
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, coord->MPC_CoordDecl.Ident, coord
	);
  Clean_OutAttributes(lop);
  lop = Copy_TopoExpr(lop, pcoord, pparam);
  
  while(Tree_IsType(p, kMPC_CoordDecl)) {
    rop = Copy_TopoExpr(p->MPC_CoordDecl.Range, pcoord, pparam);
    lop = mMPC_BinaryExpr(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
	  );
    Clean_OutAttributes(lop);
    p = p->MPC_CoordDecl.Next;
  }

  return lop;
}

/**************/
int No_VoidNodes
/**************/
#if defined __STDC__ | defined __cplusplus
	(tTree Node)
#else
	(Node)
	tTree Node;
#endif
{
  while(Tree_IsType(Node, kMPC_Node)) {
    if(BasicNodeType(Node->MPC_Node.NodeType)==VOID_NODE) return NO;
    Node = Node->MPC_Node.Next;
  }
  return YES;
}

/*****************/
int All_ScalarNodes
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree Node)
#else
	(Node)
	tTree Node;
#endif
{
  while(Tree_IsType(Node, kMPC_Node)) {
    if(Node->MPC_Node.NodeType!=SCALAR_NODE ||
       Node->MPC_Node.DynamicType) return NO;
    Node = Node->MPC_Node.Next;
  }
  return YES;
}

/**********************/
tTree Emit_NumberParam()
/**********************/
{
  tTree tree, tmp;

  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Param_TopoFlags, IntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("pnum",4), Param_TopoFlags, tmp, tmp,
	  IntType, SINGLE_NODE, NoTree
	);
  return tree;

}

/**********************/
tTree Emit_Pparameters()
/**********************/
{
  tTree tree, tmp;

  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Param_TopoFlags, ConstIntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("ppar",4), Param_TopoFlags, tmp, tmp,
	  Pointer_To_ConstInt, SINGLE_NODE, NoTree
	);
  return tree;

}

/*********************/
tTree Emit_CoordParam()
/*********************/
{
  tTree tree, tmp;

  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Param_TopoFlags, ConstIntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("pcoord",6), Param_TopoFlags, tmp, tmp,
	  Pointer_To_ConstInt, SINGLE_NODE, NoTree
	);
  return tree;

}

/********************/
tTree Emit_RootParam()
/********************/
{
  tTree tree, tmp;

  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Param_TopoFlags, TopoGraph_Type, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("root",4), Param_TopoFlags, tmp, tmp,
	  Point_To_Point_To_TopoGraph, SINGLE_NODE, NoTree
	);
  return tree;
}

/*********************/
tTree Emit_CommonParams
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree prev_params)
#else
	(prev_params) tTree prev_params;
#endif
{
  tTree tree, tmp;

  /** power **/
  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, prev_params, prev_params, AUTO, Param_TopoFlags, IntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("ppower",6), Param_TopoFlags, tmp, tmp,
	  IntType, SINGLE_NODE, NoTree
	);

  /** nodes: **/
  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, tree, tree, AUTO, Param_TopoFlags, IntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("pnodes",6), Param_TopoFlags, tmp, tmp,
	  Point_To_Point_To_Int, SINGLE_NODE, NoTree
	);

  /** links: **/
  tmp = mMPC_FreeNode( tree =
	  mMPC_VarDecl(
		NoPosition, tree, tree, AUTO, Param_TopoFlags, IntType, NoTree
	  )
	);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
	  NoPosition, MakeIdent("plinks",6), Param_TopoFlags, tmp, tmp,
	  Point_To_Point_To_Int, SINGLE_NODE, NoTree
	);
  return tree;
}

/***********************/
tTree Emit_FirstPowerCall
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks)
#else
	(NetType, pparam, ppower, pnodes, plinks)
	tTree NetType, pparam, ppower, pnodes, plinks;
#endif
{
  tTree tmp, stat, expr, lop, rop, call, exprs, power_func;

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("ppower", 6), ppower);
  Clean_OutAttributes(lop);
  rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("MPC_INIT_POWER", 14), nMPC_FreeNode());
  Clean_OutAttributes(rop);
  expr = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			 SINGLE_NODE_LIST, SINGLE_NODE, EQUAL, lop, rop);
  Clean_OutAttributes(expr);
  /*** prev. version: ***
  expr = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		    SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnodes", 6), pnodes);
  expr = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, STAR, expr);
  expr->MPC_Expr.Flag.InParentheses = YES;
  expr = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, LOG_NOT, expr);
  **********************/

  exprs = nMPC_FreeNode();
  exprs = mMPC_Exprs(NoPosition, exprs, exprs,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_ConstInt,
		           SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pparam", 6), pparam)
		)
	  );
  exprs = mMPC_Exprs(NoPosition, exprs, exprs,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		           SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("ppower", 6), ppower)
		)
	  );
  exprs = mMPC_Exprs(NoPosition, exprs, exprs,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		           SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnodes", 6), pnodes)
		)
	  );
  exprs = mMPC_Exprs(NoPosition, exprs, exprs,
      		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		           SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("plinks", 6), plinks)
		)
	  );
  power_func = NetType->MPC_NetType.TopoFunctions->
		 MPC_TopoFunctions.Power_Def->MPC_Function.Name;
  call = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, NoTree, ReverseTree(exprs), NoTree);
  Clean_OutAttributes(call);
  call->MPC_CallExpr.ArgList->MPC_Exprs.Prev->MPC_FreeNode.Parent = call;
  call->MPC_CallExpr.Function =
      	Clean_OutAttributes(
	     mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString,
		power_func->MPC_Var.Type, SINGLE_NODE_LIST, SINGLE_NODE,
		power_func->MPC_Var.Ident, power_func
	     )
	);
  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
	            SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("ppower", 6), ppower);
  Clean_OutAttributes(lop);
  call = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		         SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, call);
  Clean_OutAttributes(call);
  tmp = nMPC_FreeNode();
  call = mMPC_ExprStat(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, call);
  Clean_OutAttributes(call);

  stat = mMPC_If(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, expr, call);
  Clean_OutAttributes(stat);
  call->MPC_ExprStat.Next->MPC_FreeNode.Parent = stat;

  return stat;
}

/*************************/
tTree Emit_ShiftOnVoidNodes
/*************************/
#if defined __STDC__ | defined __cplusplus
	(tTree pnum, tTree pnodes)
#else
	(pnum, pnodes)
#endif
{
  tTree lop, rop, constant;

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnodes", 6), pnodes);
  Clean_OutAttributes(lop);
  lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
  Clean_OutAttributes(lop);
  lop->MPC_Expr.Flag.InParentheses = YES;

  rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, MakeIdent("pnum", 4), pnum);
  Clean_OutAttributes(rop);
  constant = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, Symbolic_IntConst[2], 2);
  Clean_OutAttributes(constant);
  rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, MULT, rop, constant);
  Clean_OutAttributes(rop);
  constant = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, Symbolic_IntConst[1], 1);
  Clean_OutAttributes(constant);
  rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, rop, constant);
  Clean_OutAttributes(rop);

  return Clean_OutAttributes(
		mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
				SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop)
	 );
}

/*****************/
tTree Emit_n_init()
/*****************/
{
  tTree tree, tmp;
  
  tree = mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Local_TopoFlags, IntType, NoTree
	 );
  tmp = mMPC_FreeNode(tree);
  tree->MPC_VarDecl.Var =
	mMPC_Var(
		NoPosition, MakeIdent("n",1), Local_TopoFlags,
		tmp, tmp, IntType, SINGLE_NODE, NoTree
	);
  tmp = mMPC_FreeNode(tree->MPC_VarDecl.Var);
  tree->MPC_VarDecl.Var->MPC_Var.Init =
	mMPC_SimpleInit(
		NoPosition, tmp, tmp,
      		Clean_OutAttributes(
		  mMPC_IntConst(
			NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, MINUS_ONE, -1
		  )
		)
	);
  return tree;

}

/********************************************************/
#define  PARAM_WIDE  3  /* size of param number + '\0'; */
#define  COORD_WIDE  2	/* size of coord number + '\0'; */
static int IndexLevel = 0;
/********************************************************/

/*****************/
tTree Copy_TopoExpr
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr, tTree coord, tTree pparam)
#else
	(expr, coord, pparam)
	tTree expr, coord, pparam;
#endif
{
  tTree tree, Copy_TopoSubExpr(tTree expr, tTree coord, tTree pparam);
  tree = Copy_TopoSubExpr(expr, coord, pparam);
  return tree;
  if(!Is_ArithmeticType(tree->MPC_Expr.Type) && tree->MPC_Expr.Type!=ErrorType) {
    Make_Message(483, xxError, expr->MPC_Expr.Pos, expr);
		/* "Invalid (not arithmetical) type of expression inside of nettype declaration" */
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
  }
  return tree;
}

/********************/
tTree Copy_TopoSubExpr
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr, tTree coord, tTree pparam)
#else
	(expr, coord, pparam)
	tTree expr, coord, pparam;
#endif
{
  tTree tree=NoTree, lop, rop, type, A_Shift=NoTree;
  char * cp=NULL;
  int n, ParamNumber(tTree);
  tTree ArrayParamShift(tTree, tTree, tTree);
  bool free_coord=false;

  type = expr->MPC_Expr.Type;

  switch(expr->Kind) {
    case kMPC_IntConst:
	tree =  mMPC_IntConst(
			NoPosition, Expr_TopoFlags, EmptyString, IntType, CONST_NET_LIST,
			CONST_NET, expr->MPC_IntConst.SymbolicForm, expr->MPC_IntConst.Value
		);
        Clean_OutAttributes(tree);
	break;
    case kMPC_UIntConst:
	tree =  mMPC_UIntConst(
			NoPosition, Expr_TopoFlags, EmptyString, IntType, CONST_NET_LIST,
			CONST_NET, expr->MPC_UIntConst.SymbolicForm, expr->MPC_UIntConst.Value
		);
        Clean_OutAttributes(tree);
	break;
    case kMPC_FloatConst:
	tree =  mMPC_FloatConst(
			NoPosition, Expr_TopoFlags, EmptyString, DoubleType, CONST_NET_LIST,
			CONST_NET, expr->MPC_FloatConst.SymbolicForm, expr->MPC_FloatConst.Value
		);
        Clean_OutAttributes(tree);
	break;
    case kMPC_FreeNode:
	tree = nMPC_FreeNode();
	break;
    case kMPC_StringLiteral:
	lop = Copy_TopoSubExpr(expr->MPC_StringLiteral.Next, coord, pparam);
	tree =  mMPC_StringLiteral(
			NoPosition, Expr_TopoFlags, EmptyString, expr->MPC_StringLiteral.Type,
			CONST_NET_LIST, CONST_NET, expr->MPC_StringLiteral.String,
			expr->MPC_StringLiteral.FullSize, lop, lop
		);
        Clean_OutAttributes(tree);
	break;
    case kMPC_Ident:
	if(expr->MPC_Ident.Store->Kind==kMPC_Var &&
	    expr->MPC_Ident.Store->MPC_Var.Flag.Parameter) {	/* parameter, evaluate shift: */
	  type = expr->MPC_Ident.Store->MPC_Var.Type;
	  cp = (char*) malloc(PARAM_WIDE);
	  sprintf(cp, "%1d\0", n=ParamNumber(expr->MPC_Ident.Store));
	  lop = mMPC_Ident(
			NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, pparam->MPC_Var.Ident, pparam
		);
	  Clean_OutAttributes(lop);

	  /* The previous parameters may have array type => prepare additional shift: */
	  A_Shift = ArrayParamShift(expr->MPC_Ident.Store, coord, pparam);
	}
	else if(expr->MPC_Ident.Store->Kind==kMPC_CoordDecl) {	/* coordinate: */
	  type = IntType;
	  cp = (char*) malloc(COORD_WIDE);
	  sprintf(cp, "%1d\0", n=expr->MPC_Ident.Store->MPC_CoordDecl.CoordNumber);
	  lop = mMPC_Ident(
			NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, coord->MPC_Var.Ident, coord
		);
          Clean_OutAttributes(lop);
	}
	else {  /* MPC_Var - free coordinate ( after Reset_FreeCoord_Store() ): */
	  free_coord = true;
	  type = expr->MPC_Ident.Store->MPC_Var.Type;
	  lop = expr;
	  n = 0;
	}   /* left operand and its shift ready; */
	if(n) {
	  rop = mMPC_IntConst(
			NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, cp, n
		);
	  Clean_OutAttributes(rop);
	  if(A_Shift!=NoTree) {
	    rop = mMPC_BinaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, rop, A_Shift
		 );
	    Clean_OutAttributes(rop);
	  }
	  tree = mMPC_BinaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
		 );
          Clean_OutAttributes(tree);
	  tree->MPC_Expr.Flag.InParentheses = YES;
	  }
	else  /* first coordinate or parameter: */
	  tree = lop;
	if(type->Kind!=kMPC_ArrayType && !free_coord) /*coord or scalar param, emit unary '*':*/
	  tree = mMPC_UnaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, STAR, tree
		 );
          Clean_OutAttributes(tree);
	break;
    case kMPC_CastExpr:
	tree = mMPC_CastExpr(
			NoPosition, Expr_TopoFlags, EmptyString, expr->MPC_Expr.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_Expr.Type,
			Copy_TopoSubExpr(expr->MPC_CastExpr.Operand,coord,pparam)
	       );
        Clean_OutAttributes(tree);
	break;
    case kMPC_Size_Of_Value:
	tree = mMPC_Size_Of_Value(
			NoPosition, Expr_TopoFlags, EmptyString, expr->MPC_Expr.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_SizeofExpr.CompileTime,
			expr->MPC_SizeofExpr.Value,
			Copy_TopoSubExpr(expr->MPC_Size_Of_Value.Operand,coord,pparam)
		);
        Clean_OutAttributes(tree);
	break;
    case kMPC_Size_Of_Type:
	tree = mMPC_Size_Of_Type(
			NoPosition, Expr_TopoFlags, EmptyString, expr->MPC_Expr.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_SizeofExpr.CompileTime,
			expr->MPC_SizeofExpr.Value, expr->MPC_Size_Of_Type.Operand
	);
        Clean_OutAttributes(tree);
	break;
    case kMPC_UnaryExpr:
	type = expr->MPC_Expr.Type;
	tree = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_UnaryExpr.OpCode,
			Copy_TopoSubExpr(expr->MPC_UnaryExpr.Operand,coord,pparam)
	       );
        Clean_OutAttributes(tree);
	break;
    case kMPC_BinaryExpr:
	type = expr->MPC_Expr.Type;
	if(expr->MPC_BinaryExpr.OpCode==INDEX && /** coordinate in index: **/
	   expr->MPC_BinaryExpr.Roperand->Kind==kMPC_Ident &&
	   expr->MPC_BinaryExpr.Roperand->MPC_Ident.Store->Kind==kMPC_CoordDecl){
	  IndexLevel++;
	  lop = Copy_TopoSubExpr(expr->MPC_BinaryExpr.Loperand,coord,pparam);
	  rop = Emit_ShiftOnCoord(
			expr->MPC_BinaryExpr.Roperand->MPC_Ident.Store, coord, pparam
		);
	  IndexLevel--;
	  tree = mMPC_BinaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop			
	         );
          Clean_OutAttributes(tree);
	  tree->MPC_Expr.Flag.InParentheses = YES;
	  if(IndexLevel==0)
	    tree = mMPC_UnaryExpr(
			NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, STAR, tree
		   );
          Clean_OutAttributes(tree);
	}
	else {
	  lop = Copy_TopoSubExpr(expr->MPC_BinaryExpr.Loperand,coord,pparam);
	  rop = Copy_TopoSubExpr(expr->MPC_BinaryExpr.Roperand,coord,pparam);
/***	  type = expr->MPC_Expr.Type;  ***/
	  tree = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_BinaryExpr.OpCode,
			lop, rop			
	         );
          Clean_OutAttributes(tree);
	}
	break;
    case kMPC_TernaryExpr:
	type = expr->MPC_Expr.Type;
	tree = mMPC_TernaryExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_TernaryExpr.OpCode,
			Copy_TopoSubExpr(expr->MPC_TernaryExpr.Foperand,coord,pparam),
			Copy_TopoSubExpr(expr->MPC_TernaryExpr.Soperand,coord,pparam),
			Copy_TopoSubExpr(expr->MPC_TernaryExpr.Toperand,coord,pparam)
	       );
        Clean_OutAttributes(tree);
	break;
    case kMPC_QuaternaryExpr:
	type = expr->MPC_Expr.Type;
	tree = mMPC_QuaternaryExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			SINGLE_NODE_LIST, SINGLE_NODE, expr->MPC_QuaternaryExpr.OpCode,
			Copy_TopoSubExpr(expr->MPC_QuaternaryExpr.Operand1,coord,pparam),
			Copy_TopoSubExpr(expr->MPC_QuaternaryExpr.Operand2,coord,pparam),
			Copy_TopoSubExpr(expr->MPC_QuaternaryExpr.Operand3,coord,pparam),
			Copy_TopoSubExpr(expr->MPC_QuaternaryExpr.Operand4,coord,pparam)
	       );
        Clean_OutAttributes(tree);
	break;
    case kMPC_CallExpr:
	type = expr->MPC_Expr.Type;
	tree = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			SINGLE_NODE_LIST, SINGLE_NODE,
			Copy_TopoSubExpr(expr->MPC_CallExpr.Function, coord, pparam),
			ReverseTree( Copy_TopoSubExpr(expr->MPC_CallExpr.ArgList, coord, pparam) ),
			Copy_TopoSubExpr(expr->MPC_CallExpr.NetworkArgList, coord, pparam)
	       );
        Clean_OutAttributes(tree);
	break;
    case kMPC_Exprs:
	lop = Copy_TopoSubExpr(expr->MPC_Exprs.Next, coord, pparam);
	tree = mMPC_Exprs(NoPosition, lop, lop,
			Copy_TopoSubExpr(expr->MPC_Exprs.Expr, coord, pparam)
	       );
	break;
    default:
	SPEC_Warning((41, xxWarning, expr->MPC_Expr.Pos, expr));
		/* "Sorry, this is not implemented currently (topo-functions not generated)" */
  }

  if(Tree_IsType(tree,kMPC_Expr)) {
    tree->MPC_Expr.Flag.InParentheses |= expr->MPC_Expr.Flag.InParentheses;

    if(type->Kind==kMPC_BasicType &&
       type->MPC_BasicType.TypeConstructor==DOUBLE &&
       (expr->Kind==kMPC_Ident || expr->Kind==kMPC_BinaryExpr &&
				  expr->MPC_BinaryExpr.OpCode==INDEX)) {
      /** convert 'fixed-coded-by-int' back to 'double': **/
      tTree rop;
      tree = mMPC_CastExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			   SINGLE_NODE_LIST, SINGLE_NODE, type, tree
	     );
      Clean_OutAttributes(tree);
      rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			CONST_NET_LIST, CONST_NET, MakeIdent("MPC_FIXPOINT_SCALE", 18), nMPC_FreeNode()
	    );
      Clean_OutAttributes(rop);
      tree = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, type,
			     SINGLE_NODE_LIST, SINGLE_NODE, DIV, tree, rop);
      Clean_OutAttributes(tree);
      tree->MPC_Expr.Flag.InParentheses = YES;
    }
  }

  return tree;
}
/*************/
int ParamNumber
/*************/
#if defined __STDC__ | defined __cplusplus
	(tTree param)
#else
	(param)
	tTree param;	/* pointer to MPC_Var/MPC_VarDecl node; */
#endif
{
  int num=0;

  param = param->MPC_Var.Prev; /* MPC_Var or MPC_FreeNode; */
 		/* count previous parameters: */ ;
  while(Tree_IsType(param,kMPC_Var)) param=param->MPC_Var.Prev, num++;
  
  return num;
}

/*******************/
tTree ArrayParamShift
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree param, tTree coord, tTree pparam)
#else
	(param, coord, pparam)
	tTree param,     /* pointer to MPC_Var node; */
              coord, pparam;
#endif
{
  int anum=0;
  tTree tree=NoTree, lop=NoTree, rop=NoTree;
  tTree ArrayParamSize ARGS((tTree Type, tTree coord, tTree pparam));

  param = param->MPC_Var.Prev;   /* count previous parameters, that have array type: */
  while(param->Kind==kMPC_Var) {
    if(param->MPC_Var.Type->Kind==kMPC_ArrayType) {
      anum++;
      if(rop!=NoTree) lop=rop;
      rop = ArrayParamSize(param->MPC_Var.Type, coord, pparam);
      if(lop!=NoTree) {
        rop = mMPC_BinaryExpr(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, PLUS, lop, rop
              );
        Clean_OutAttributes(rop);
      }
    }
    param = param->MPC_Var.Prev;
  }

  if(rop!=NoTree) {  /* ... minus anum: */
    char *cp;
    lop = rop;
    cp = (char*) malloc(PARAM_WIDE);
    sprintf(cp, "%1d\0", anum);
    rop = mMPC_IntConst(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, cp, anum
          );
    lop = mMPC_BinaryExpr(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, MINUS, lop, rop
          );
    Clean_OutAttributes(lop);
    lop->MPC_Expr.Flag.InParentheses = YES;
  }

  return lop;
}

/******************/
tTree ArrayParamSize
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, tTree coord, tTree pparam)
#else
	(Type, coord, pparam)
        tTree Type, coord, pparam;
#endif
{
  tTree lop=NoTree, rop=NoTree;
  char *cp;

  while(Type->Kind==kMPC_ArrayType){
    if(rop!=NoTree) lop = rop;
    if(Type->MPC_ArrayType.NumberOfComponents!=0) {  /* constant size: */
      cp = (char*) malloc(PARAM_WIDE);
      sprintf(cp, "%1d\0", Type->MPC_ArrayType.NumberOfComponents);
      rop = mMPC_IntConst(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, cp, Type->MPC_ArrayType.NumberOfComponents
            );
      Clean_OutAttributes(rop);
    }
    else {  /* dynamic size: */
      rop = Copy_TopoExpr(Type->MPC_ArrayType.ArraySize, coord, pparam);
    }
    if(lop!=NoTree) {
      rop = mMPC_BinaryExpr(
		NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
            );
      Clean_OutAttributes(rop);
    }
    Type = Type->MPC_ArrayType.ElementType;
  }

  return rop;
}

/*******************/
tTree Emit_CoordArray
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord)
#else
	(coord)
	tTree coord;	/* pointer to first MPC_CoordDecl node of NetType; */
#endif
{
  tTree decl, type;
  int dim=1;  /* number of coord. variables; */

  while(Tree_IsType(coord->MPC_CoordDecl.Next,kMPC_CoordDecl)) {
    dim++;
    coord = coord->MPC_CoordDecl.Next;
  }
  type = mMPC_ArrayType(NoPosition, NoTree, NoTree, NoTypeFlag, dim, 1, IntType);
  Clean_OutAttributes(type);
  type->MPC_ArrayType.ArraySize = nMPC_FreeNode();
  type->MPC_ArrayType.DynStep = nMPC_FreeNode();
  Push_Pattern(type);
  type = Make_Type();

  decl = mMPC_VarDecl(NoPosition, NoTree, NoTree, AUTO, Local_TopoFlags, IntType,
		mMPC_Var(NoPosition, MakeIdent("coordinate",10), Local_TopoFlags,
			NoTree, NoTree, type, SINGLE_NODE, NoTree
		)
	 );
  decl->MPC_VarDecl.Var->MPC_Var.Next =
	decl->MPC_VarDecl.Var->MPC_Var.Prev = mMPC_FreeNode(decl);

  return decl;
}

/******************/
tTree Emit_FreeCoord
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord)
#else
	(coord)
	tTree coord;	/* pointer to first MPC_CoordDecl node of free coord list; */
#endif
{
  tTree root, list;
  if(!coord || coord->Kind==kMPC_FreeNode) return NoTree;
  root = mMPC_VarDecl(
		NoPosition, NoTree, NoTree, AUTO, Local_TopoFlags, IntType, NoTree
	 );
  list = mMPC_FreeNode(root);
  while(coord->Kind==kMPC_CoordDecl) {
    list = mMPC_Var(
		NoPosition, coord->MPC_CoordDecl.Ident, Local_TopoFlags,
		list, list, IntType, SINGLE_NODE, NoTree
	   );
    list->MPC_Var.Init = mMPC_SimpleInit(coord->MPC_CoordDecl.Range->MPC_Expr.Pos,
				NoTree, NoTree, coord->MPC_CoordDecl.Range
			 );
    coord = coord->MPC_CoordDecl.Next;
  }
  root->MPC_VarDecl.Var = ReverseTree(list);
  return root;
}

/***********************/
int Reset_FreeCoord_Store
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr, tTree coord)
#else
	(expr, coord)
	tTree expr,
	      coord;	/* pointer to MPC_Var node for free coords; */
#endif
{
  int found=0;
  tTree c;
  if(!coord) return found;
  switch(expr->Kind) {   /*** ADD OTHER NODES !!!!!!!!!!!!!!!!!!!!!!!!! ***/
    case kMPC_IntConst:
    case kMPC_UIntConst:
    case kMPC_FloatConst:
    case kMPC_StringLiteral:	break;
    case kMPC_Ident:		/* find identifier in list of free coordinates: */
				c = coord;
				while(c->Kind==kMPC_Var) {
				  if(expr->MPC_Ident.Ident==c->MPC_Var.Ident) {
				    found = 1;
				    expr->MPC_Ident.Store = c;
				    break;
				  }
				  c = c->MPC_Var.Next;
				}
				break;
    case kMPC_CastExpr:		found = Reset_FreeCoord_Store(expr->MPC_CastExpr.Operand, coord);
				break;
    case kMPC_Size_Of_Value:	found = Reset_FreeCoord_Store(expr->MPC_Size_Of_Value.Operand, coord);
				break;
    case kMPC_Size_Of_Type:	break;
    case kMPC_UnaryExpr:	found = Reset_FreeCoord_Store(expr->MPC_UnaryExpr.Operand, coord);
				break;
    case kMPC_BinaryExpr:	found =  Reset_FreeCoord_Store(expr->MPC_BinaryExpr.Loperand, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_BinaryExpr.Roperand, coord);
				break;
    case kMPC_TernaryExpr:	found =  Reset_FreeCoord_Store(expr->MPC_TernaryExpr.Foperand, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_TernaryExpr.Soperand, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_TernaryExpr.Toperand, coord);
				break;
    case kMPC_QuaternaryExpr:	found =  Reset_FreeCoord_Store(expr->MPC_QuaternaryExpr.Operand1, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_QuaternaryExpr.Operand2, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_QuaternaryExpr.Operand3, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_QuaternaryExpr.Operand4, coord);
				break;
    case kMPC_CallExpr:		found = Reset_FreeCoord_Store(expr->MPC_CallExpr.Function, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_CallExpr.ArgList, coord);
				break;
    case kMPC_Exprs:		found = Reset_FreeCoord_Store(expr->MPC_Exprs.Expr, coord);
				found |= Reset_FreeCoord_Store(expr->MPC_Exprs.Next, coord);
				break;
    default:  SPEC_Warning((42, xxWarning, expr->MPC_Expr.Pos, expr));
		/* "Unimplemented operator in expression inside of topology" */
  }
  return found;
}

/*******************/
tTree Emit_VoidAction
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree shift)
#else
	(shift) tTree shift;
#endif
{
  tTree tree;
  tree = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		    SINGLE_NODE_LIST, SINGLE_NODE, shift->MPC_Var.Ident, shift);
  Clean_OutAttributes(tree);
  tree = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		        SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, tree);
  Clean_OutAttributes(tree);
  return Clean_OutAttributes(
		mMPC_ExprStat(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, tree)
	 );
}

/*******************/
tTree Emit_NodeAction
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree node, tTree pparam, tTree pnodes,
	 tTree coordinate, tTree pow, tTree shift, tTree i)
#else
	(node, pparam, pnodes, coordinate, pow, shift, i)
	tTree node,	/* node declarator      */
	      pparam,   /* topology parameters  */
	      pnodes,   /* parameter of 'power' */
	      coordinate, /* power's local var  */
	      pow,        /* power's local var  */
	      shift,	  /* power's local var  */
	      i;	  /* power's local var  */
#endif
{
  tTree lop, rop, result, stat, tmp;
  int node_type;
  char *node_code;

  /* 1. prapare node type & code: */

  node_type = node->MPC_Node.NodeType;
  if(node_type==VOID_NODE)
    return Emit_VoidAction(shift); /* no further generation; */
  if(node->MPC_Node.DynamicType &&  /** and 'bench' specifier with const expr: **/
     node->MPC_Node.NodeQual->Kind==kMPC_BenchQual &&
     node->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->Kind==kMPC_FloatConst)
    node_type = 100 * node->MPC_Node.NodeQual->MPC_BenchQual.Capacity;
  node_code = (tString)malloc(node_type/10+3);
  sprintf(node_code, "%1d\0", node_type);
  if(node->MPC_Node.DynamicType &&  /** and common form of 'bench' specifier: **/
     node->MPC_Node.NodeQual->Kind==kMPC_BenchQual &&
     node->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->Kind!=kMPC_FloatConst) {
    rop = Copy_TopoExpr(
	     node->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr,
	     coordinate, pparam
	  );
    /** -- Float point node capacity ? -- **/
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, MakeIdent("MPC_FIXPOINT_SCALE",18), nMPC_FreeNode()
	  );
    Clean_OutAttributes(lop);
    rop->MPC_Expr.Flag.InParentheses = YES;
    result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString,
		node->MPC_Node.NodeQual->MPC_BenchQual.CapacityExpr->MPC_Expr.Type,
		SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
	     );
    Clean_OutAttributes(result);
    result->MPC_Expr.Flag.InParentheses = YES;
    result = mMPC_CastExpr(NoPosition, Expr_TopoFlags, EmptyString,
		IntType, SINGLE_NODE_LIST, SINGLE_NODE, IntType, result
	     );
  }
  else  /* old fashioned node type or constant 'bench' specifier: */
    result =  mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, node_code, node_type
	      );
  Clean_OutAttributes(result);
  if(node->MPC_Node.DynamicType &&
     node->MPC_Node.NodeQual->Kind==kMPC_NodeTypeQual) {
    int fast_or_slow;
    tString fast_or_slow_code;
    fast_or_slow = node->MPC_Node.NodeQual->MPC_NodeTypeQual.Fast ? FAST : SLOW;
    fast_or_slow_code = (tString)malloc(3);
    sprintf(fast_or_slow_code, "%1d\0", fast_or_slow);
    lop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, fast_or_slow_code, fast_or_slow
	  );
    Clean_OutAttributes(lop);
    rop = Copy_TopoExpr(
	     node->MPC_Node.NodeQual->MPC_NodeTypeQual.CapacityExpr,
	     coordinate, pparam
	  );
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, MULT, lop, rop
	  );
    Clean_OutAttributes(rop);
    result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, PLUS, result, rop
	     );
    Clean_OutAttributes(result);
  }


  /* 2. emit expression statements for (*pnodes): */

  stat = nMPC_FreeNode();
  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes);
  Clean_OutAttributes(lop);
  lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		       SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
  Clean_OutAttributes(lop);
  lop->MPC_Expr.Flag.InParentheses = YES;					/* (*pnodes) */
  tmp = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
  Clean_OutAttributes(tmp);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[2], 2);
  Clean_OutAttributes(rop);
  rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, MULT, tmp, rop);
  Clean_OutAttributes(rop);
  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);	/* (*pnodes)[pow*2] */
  Clean_OutAttributes(lop);
  result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, result);
  Clean_OutAttributes(result);
  stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);   /* 1st ready; */
  Clean_OutAttributes(stat);
  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes);
  Clean_OutAttributes(lop);
  lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		       SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
  Clean_OutAttributes(lop);
  lop->MPC_Expr.Flag.InParentheses = YES;					/* (*pnodes) */
  tmp = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
  Clean_OutAttributes(tmp);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[2], 2);
  Clean_OutAttributes(rop);
  rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, MULT, tmp, rop);
  Clean_OutAttributes(rop);
  tmp = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[1], 1);
  Clean_OutAttributes(tmp);
  rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, PLUS, rop, tmp);
  Clean_OutAttributes(rop);
  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);	/* (*pnodes)[pow*2+1] */
  Clean_OutAttributes(lop);
  rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, shift->MPC_Var.Ident, shift);
  Clean_OutAttributes(rop);
  result = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
  Clean_OutAttributes(result);
  stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, result);   /* 2nd ready; */
  Clean_OutAttributes(stat);


  /* 3. emit if(i) {...}   and   pow++;  : */

  tmp = nMPC_FreeNode();
  stat = mMPC_Compound(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST,
		       NO, NoTree, ReverseTree(stat));
  Clean_OutAttributes(stat);
  stat->MPC_Compound.Decls = mMPC_FreeNode(stat);
  stat->MPC_Compound.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;
  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, i->MPC_Var.Ident, i);
  Clean_OutAttributes(lop);
  stat = tmp->MPC_FreeNode.Parent =
        Clean_OutAttributes(
		mMPC_If(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, lop, stat)
	);  /* if(){...} */
  stat->MPC_Stat.Next = stat->MPC_Stat.Prev = nMPC_FreeNode();

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, pow->MPC_Var.Ident, pow);
  Clean_OutAttributes(lop);
  lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, lop);
  Clean_OutAttributes(lop);
  stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);	   /* pow++; */
  Clean_OutAttributes(stat);


  /* 4. emit resulting compound statement: */

  stat = mMPC_Compound(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST,
		       NO, NoTree, ReverseTree(stat));
  Clean_OutAttributes(stat);
  stat->MPC_Compound.Decls = mMPC_FreeNode(stat);

  return stat;

}

/********************/
tTree Emit_NodeIfGroup   /* for 'power' function */
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType, tTree pparam, tTree pnodes,
	 tTree coordinate, tTree pow, tTree shift, tTree i)
#else
	(NetType, pparam, pnodes, coordinate, pow, shift, i)
	tTree NetType,	/* topology declaration */
	      pparam,   /* topology parameters  */
	      pnodes,   /* parameter of 'power' */
	      coordinate, /* power's local var  */
	      pow,        /* power's local var  */
	      shift,	  /* power's local var  */
	      i;	  /* power's local var  */
#endif
{
  tTree node, default_node = NoTree;
  tTree root_stat, stat, upper_stat, action, *else_action;

  node = NetType->MPC_NetType.NodeDecl;
  if(node->MPC_Node.Predicate==NoTree) { /* default: */
    default_node = node;
    node = node->MPC_Node.Next;
  }

  /* 1. emit 'if() and actions' for 1st explicit (not 'default') node declarator: */

  stat =
  root_stat = mMPC_IfElse(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST,
			  Copy_TopoExpr(node->MPC_Node.Predicate, coordinate, pparam),
			  NoTree, NoTree);
  Clean_OutAttributes(root_stat);
  root_stat->MPC_IfElse.Then = action = Emit_NodeAction(node, pparam, pnodes, coordinate, pow, shift, i);
  action->MPC_Stat.Next = action->MPC_Stat.Prev = mMPC_FreeNode(root_stat);
  else_action = &(root_stat->MPC_IfElse.Else);
  node = node->MPC_Node.Next;


  /* 2. emit 'else if() and actions' for any node declarator except 'default' */

  upper_stat = root_stat;
  while(node->Kind!=kMPC_FreeNode) {
    if(node->MPC_Node.Predicate==NoTree) { /* default: */
      default_node = node;
    }
    else {
      stat = *else_action =
	     mMPC_IfElse(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST,
			 Copy_TopoExpr(node->MPC_Node.Predicate, coordinate, pparam),
			 NoTree, NoTree);
      Clean_OutAttributes(stat);
      stat->MPC_Stat.Next = stat->MPC_Stat.Prev = mMPC_FreeNode(upper_stat);
      stat->MPC_IfElse.Then = action = Emit_NodeAction(node, pparam, pnodes, coordinate, pow, shift, i);
      action->MPC_Stat.Next = action->MPC_Stat.Prev = mMPC_FreeNode(stat);
      else_action = &(stat->MPC_IfElse.Else);
      upper_stat = stat;
    } /* end if-else */
    node = node->MPC_Node.Next;
  } /* end while(node->Kind!=kMPC_FreeNode) */


  /* 3. emit 'else actions' for 'default' node declarator (also when 'default' isn't present) */

  if(default_node) /* explicit default nodes: */
    *else_action = Emit_NodeAction(default_node, pparam, pnodes, coordinate, pow, shift, i);
  else   /* implicit:  default: void; */
    *else_action = Emit_VoidAction(shift);
  (*else_action)->MPC_Stat.Next = (*else_action)->MPC_Stat.Prev = mMPC_FreeNode(stat);

  return root_stat;
}

/*******************/
tTree Emit_LinkAction
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree link, tTree pparam, tTree ppower, tTree pnodes, tTree plinks,
	 tTree coordinate, tTree coord_array1, tTree coord_array2,
	 tTree free_coords, tTree pnum1, tTree pnum2, tTree number_func)
#else
	(link, pparam, ppower, pnodes, plinks, coordinate,
	 coord_array1, coord_array2, free_coords,
	 pnum1, pnum2, number_func)
	tTree link,	/* Link declaring list (with one predicate) */
	      pparam,   /* topology parameters  */
	      ppower,   /* parameter of 'link'  */
	      pnodes,   /* parameter of 'link'  */
	      plinks,	/* parameter of 'link'  */
	      coordinate,   /* link's local var */
	      coord_array1, /* link's local var */
	      coord_array2, /* link's local var */
	      free_coords,  /* link's local var */
	      pnum1,	    /* link's local var */
	      pnum2,        /* link's local var */
	      number_func;  /* link's local var */
#endif
{
  tTree stat, tmp, lop, rop, expr, arg;
  tTree linkdecl, prev_linkdecl = NoTree;
  tTree pn1 = pnum1, pn2 = pnum2;

  stat = tmp = nMPC_FreeNode();
  linkdecl = link->MPC_LinkDeclaringList.LinkDeclarator;

  /* 1. loop on link declarators: */

  while(linkdecl!=NoTree && linkdecl->Kind==kMPC_LinkDeclarator) {

    if(prev_linkdecl==NoTree ||
       linkdecl->MPC_LinkDeclarator.LeftNode!=prev_linkdecl->MPC_LinkDeclarator.RightNode ||
       linkdecl->MPC_LinkDeclarator.RightNode!=prev_linkdecl->MPC_LinkDeclarator.LeftNode)   {  /* not <-> */

      /* 1.1. fill coord_array1 and coord_array2 : */

      {
	tTree Lexpr = linkdecl->MPC_LinkDeclarator.LeftNode,
	      Rexpr = linkdecl->MPC_LinkDeclarator.RightNode;
	int i;
	for(i=0; Lexpr->Kind!=kMPC_FreeNode && Rexpr->Kind!=kMPC_FreeNode;
	    Lexpr=Lexpr->MPC_Exprs.Next, Rexpr=Rexpr->MPC_Exprs.Next ,i++) {
	  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, coord_array1->MPC_Var.Ident, coord_array1);
	  Clean_OutAttributes(lop);
	  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[i], i);
	  Clean_OutAttributes(rop);
	  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
	  Clean_OutAttributes(lop);
	  (void)Reset_FreeCoord_Store(Lexpr->MPC_Exprs.Expr, free_coords);
	  rop = Copy_TopoExpr(Lexpr->MPC_Exprs.Expr, coordinate, pparam);
	  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
	  Clean_OutAttributes(lop);
	  stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);  /* c1[i]=...; */
	  Clean_OutAttributes(stat);
	  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, coord_array2->MPC_Var.Ident, coord_array2);
	  Clean_OutAttributes(lop);
	  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[i], i);
	  Clean_OutAttributes(rop);
	  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
	  Clean_OutAttributes(lop);
	  (void)Reset_FreeCoord_Store(Rexpr->MPC_Exprs.Expr, free_coords);
	  rop = Copy_TopoExpr(Rexpr->MPC_Exprs.Expr, coordinate, pparam);
	  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
	  Clean_OutAttributes(lop);
	  stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, lop);  /* c2[i]=...; */
	  Clean_OutAttributes(stat);
	}
      }


      /* 1.2. emit 2 calls of coord2number() : */

      arg = nMPC_FreeNode();
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, coord_array1->MPC_Var.Ident, coord_array1)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, pparam->MPC_Var.Ident, pparam)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks)
		)
	    );
      expr = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, number_func->MPC_Var.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, number_func->MPC_Var.Ident, number_func);
      Clean_OutAttributes(expr);
      rop = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, expr, ReverseTree(arg), NoTree);
      Clean_OutAttributes(rop);
      rop->MPC_CallExpr.NetworkArgList = mMPC_FreeNode(rop);
      rop->MPC_CallExpr.ArgList->MPC_Exprs.Prev->MPC_FreeNode.Parent = rop;  /* coord2number(...) ready; */
      lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, pnum1->MPC_Var.Ident, pnum1);
      Clean_OutAttributes(lop);
      expr = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			     SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
      Clean_OutAttributes(expr);
      stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, expr);  /* pnum1 = ... ; */
      Clean_OutAttributes(stat);

      arg = nMPC_FreeNode();
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, coord_array2->MPC_Var.Ident, coord_array2)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, pparam->MPC_Var.Ident, pparam)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, pnodes->MPC_Var.Ident, pnodes)
		)
	    );
      arg = mMPC_Exprs( NoPosition, arg, arg,
		Clean_OutAttributes(
			mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
			   SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks)
		)
	    );
      expr = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, number_func->MPC_Var.Type,
			SINGLE_NODE_LIST, SINGLE_NODE, number_func->MPC_Var.Ident, number_func);
      Clean_OutAttributes(expr);
      rop = mMPC_CallExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, expr, ReverseTree(arg), NoTree);
      Clean_OutAttributes(rop);
      rop->MPC_CallExpr.NetworkArgList = mMPC_FreeNode(rop);
      rop->MPC_CallExpr.ArgList->MPC_Exprs.Prev->MPC_FreeNode.Parent = rop;  /* coord2number(...) ready; */
      lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, pnum2->MPC_Var.Ident, pnum2);
      Clean_OutAttributes(lop);
      expr = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			     SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
      Clean_OutAttributes(expr);
      stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, expr);  /* pnum1 = ... ; */
      Clean_OutAttributes(stat);

    } /* end if( ! <-> ) */


    /* 1.3. emit assignment(s) to (*plinks)[...] : */

    if(prev_linkdecl!=NoTree &&
       linkdecl->MPC_LinkDeclarator.LeftNode==prev_linkdecl->MPC_LinkDeclarator.RightNode &&
       linkdecl->MPC_LinkDeclarator.RightNode==prev_linkdecl->MPC_LinkDeclarator.LeftNode) {  /* <-> */
      /* change pnum1 to pnum2 and pnum2 to pnum1: */
      pnum1 = pn2;
      pnum2 = pn1;
    } /* end if(<->) */

    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Point_To_Point_To_Int,
		     SINGLE_NODE_LIST, SINGLE_NODE, plinks->MPC_Var.Ident, plinks);
    Clean_OutAttributes(lop);
    lop = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
			 SINGLE_NODE_LIST, SINGLE_NODE, STAR, lop);
    Clean_OutAttributes(lop);
    lop->MPC_Expr.Flag.InParentheses = YES;
    tmp = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnum1->MPC_Var.Ident, pnum1);
    Clean_OutAttributes(tmp);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, ppower->MPC_Var.Ident, ppower);
    Clean_OutAttributes(rop);
    tmp = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, MULT, tmp, rop);
    Clean_OutAttributes(tmp);
    rop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		     SINGLE_NODE_LIST, SINGLE_NODE, pnum2->MPC_Var.Ident, pnum2);
    Clean_OutAttributes(rop);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, PLUS, tmp, rop);
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			  SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);  /* (*plinks)[...] ready; */
    Clean_OutAttributes(lop);
    expr = link->MPC_LinkDeclaringList.LinkLengthSpecifier->
			 MPC_LinkLengthSpecifier.LinkLengthExpr;
    Reset_FreeCoord_Store(expr, free_coords);
    rop = Copy_TopoExpr(expr, coordinate, pparam);
    expr = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			   SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);
    Clean_OutAttributes(expr);
    stat = mMPC_ExprStat(NoPosition, stat, stat, Stat_TopoFlags, SINGLE_NODE_LIST, expr);
    Clean_OutAttributes(stat);

    /* restore pnum1 and pnum2  and  prepare to next iteration : */

    pnum1 = pn1;
    pnum2 = pn2;
    prev_linkdecl = linkdecl;
    linkdecl = linkdecl->MPC_LinkDeclarator.Next;

  } /* end while */


  /* 2. emit compound statement: */

  stat = mMPC_Compound(NoPosition, NoTree, NoTree, Stat_TopoFlags,
		       SINGLE_NODE_LIST, NO, NoTree, ReverseTree(stat));
  Clean_OutAttributes(stat);
  stat->MPC_Compound.Decls = mMPC_FreeNode(stat);
  stat->MPC_Compound.Stats->MPC_Stat.Prev->MPC_FreeNode.Parent = stat;


  return stat;
}

/********************/
tTree Emit_LinkIfGroup   /* for 'power' function */
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType, tTree pparam, tTree ppower, tTree pnodes, tTree plinks,
	 tTree coordinate, tTree coord_array1, tTree coord_array2,
	 tTree free_coords, tTree pnum1, tTree pnum2, tTree number_func)
#else
	(NetType, pparam, ppower, pnodes, plinks, coordinate,
         coord_array1, coord_array2, free_coords, pnum1, pnum2,
	 number_func)
	tTree NetType,	/* topology declaration */
	      pparam,   /* topology parameters  */
	      ppower,   /* parameter of 'link'  */
	      pnodes,   /* parameter of 'link'  */
	      plinks,	/* parameter of 'link'  */
	      coordinate,   /* link's local var */
	      coord_array1, /* link's local var */
	      coord_array2, /* link's local var */
	      free_coords,  /* link's local var */
	      pnum1,	    /* link's local var */
	      pnum2,        /* link's local var */
	      number_func;  /* link's local var */
#endif
{
  tTree link, default_link = NoTree;
  tTree root_stat, stat, upper_stat, action, *else_action;

  link = NetType->MPC_NetType.LinkDecl->MPC_LinkDecl.LinkDeclaringList;
  if(link->MPC_LinkDeclaringList.Predicate==NoTree) { /* default: */
    default_link = link;
    link = link->MPC_LinkDeclaringList.Next;
  }

  /* 1. emit 'if() and actions' for 1st explicit (not 'default') link declarator: */

  (void)Reset_FreeCoord_Store(link->MPC_LinkDeclaringList.Predicate, free_coords);
  stat =
  root_stat = mMPC_IfElse(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST,
			  Copy_TopoExpr(link->MPC_LinkDeclaringList.Predicate, coordinate, pparam),
			  NoTree, NoTree);
  Clean_OutAttributes(stat);
  root_stat->MPC_IfElse.Then = action = Emit_LinkAction(link, pparam, ppower, pnodes, plinks, coordinate,
							coord_array1, coord_array2, free_coords,
							pnum1, pnum2, number_func);
  action->MPC_Stat.Next = action->MPC_Stat.Prev = mMPC_FreeNode(root_stat);
  else_action = &(root_stat->MPC_IfElse.Else);
  link = link->MPC_LinkDeclaringList.Next;


  /* 2. emit 'else if() and actions' for any node declarator except 'default' */

  upper_stat = root_stat;
  while(link->Kind!=kMPC_FreeNode) {
    if(link->MPC_LinkDeclaringList.Predicate==NoTree) { /* default: */
      default_link = link;
    }
    else {
      (void)Reset_FreeCoord_Store(link->MPC_LinkDeclaringList.Predicate, free_coords);
      stat = *else_action =
	     mMPC_IfElse(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST,
			 Copy_TopoExpr(link->MPC_LinkDeclaringList.Predicate, coordinate, pparam),
			 NoTree, NoTree);
      Clean_OutAttributes(stat);
      stat->MPC_Stat.Next = stat->MPC_Stat.Prev = mMPC_FreeNode(upper_stat);
      stat->MPC_IfElse.Then = action = Emit_LinkAction(link, pparam, ppower, pnodes, plinks,
						       coordinate, coord_array1, coord_array2,
						       free_coords, pnum1, pnum2, number_func);
      action->MPC_Stat.Next = action->MPC_Stat.Prev = mMPC_FreeNode(stat);
      else_action = &(stat->MPC_IfElse.Else);
      upper_stat = stat;
    } /* end if-else */
    link = link->MPC_LinkDeclaringList.Next;
  } /* end while(link->Kind!=kMPC_FreeNode) */


  /* 3. emit 'else actions' for 'default' link declarator (also when 'default' isn't present) */

  if(default_link) /* explicit default links: */
    *else_action = Emit_LinkAction(default_link, pparam, ppower, pnodes, plinks,
				   coordinate, coord_array1, coord_array2,
				   free_coords, pnum1, pnum2, number_func);
  else  { /* no work: */
    *else_action = mMPC_ExprStat(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, NoTree);
    Clean_OutAttributes(*else_action);
  }
  (*else_action)->MPC_Stat.Next = (*else_action)->MPC_Stat.Prev = mMPC_FreeNode(stat);

  return root_stat;
}


/*******************/
tTree Emit_CoordLoops
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord, tTree stat, tTree pparam, tTree coordinate)
#else
	(coord, stat, pparam, coordinate)
	tTree coord,	   /* topology's coordinates; */
	      stat,	   /* body of generated loop; */
	      coordinate,  /* pointer to MPC_Var node for local var 'coordinate'; */
	      pparam;      /* topology parameters */
#endif
{
  tTree e1, e2, e3, lop, rop, for_loop, tmp;

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, coordinate->MPC_Var.Ident, coordinate);
  Clean_OutAttributes(lop);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[coord->MPC_CoordDecl.CoordNumber],
		      coord->MPC_CoordDecl.CoordNumber);
  Clean_OutAttributes(rop);
  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
  Clean_OutAttributes(lop);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0);
  Clean_OutAttributes(rop);
  e1 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);         /* e1 ready; */
  Clean_OutAttributes(e1);

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, coordinate->MPC_Var.Ident, coordinate);
  Clean_OutAttributes(lop);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[coord->MPC_CoordDecl.CoordNumber],
		      coord->MPC_CoordDecl.CoordNumber);
  Clean_OutAttributes(rop);
  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
  Clean_OutAttributes(lop);
  rop = Copy_TopoExpr(coord->MPC_CoordDecl.Range, coordinate, pparam);
  e2 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, LESS_THEN, lop, rop);         /* e2 ready; */
  Clean_OutAttributes(e2);

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		   SINGLE_NODE_LIST, SINGLE_NODE, coordinate->MPC_Var.Ident, coordinate);
  Clean_OutAttributes(lop);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[coord->MPC_CoordDecl.CoordNumber],
		      coord->MPC_CoordDecl.CoordNumber);
  Clean_OutAttributes(rop);
  lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
			SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop);
  Clean_OutAttributes(lop);
  e3 = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, lop);
  Clean_OutAttributes(e3);

  tmp = nMPC_FreeNode();

  if(coord->MPC_CoordDecl.Next!=NoTree &&
     coord->MPC_CoordDecl.Next->Kind==kMPC_CoordDecl) {  /* make recursive call: */
    for_loop = mMPC_For(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3,
			Emit_CoordLoops(coord->MPC_CoordDecl.Next, stat, pparam, coordinate)
	       );
  }
  else {
    for_loop = mMPC_For(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3, stat);
  }
  Clean_OutAttributes(for_loop);
  for_loop->MPC_For.Stats->MPC_Stat.Next =
    for_loop->MPC_For.Stats->MPC_Stat.Prev = mMPC_FreeNode(for_loop);

  return for_loop;
}

/***********************/
tTree Emit_FreeCoordLoops
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord, tTree stat, tTree coordinate, tTree free_coord, tTree pparam)
#else
	(coord, stat, coordinate, free_coord, pparam)
	tTree coord,
	      stat,		/* body of generated loop; */
	      coordinate,	/* pointer to MPC_Var node for coords; */
	      free_coord,	/* pointer to MPC_Var node for free coords; */
	      pparam;		/* pointer to MPC_Var node for topology parameters; */
#endif
{
  tTree e1, e2, e3, lop, rop, for_loop, tmp;

  if(!free_coord || free_coord->Kind==kMPC_FreeNode)
    return stat;

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, free_coord->MPC_Var.Ident, free_coord);
  Clean_OutAttributes(lop);
  rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[0], 0);
  Clean_OutAttributes(rop);
  e1 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, ASSIGN, lop, rop);         /* e1 ready; */
  Clean_OutAttributes(e1);

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, free_coord->MPC_Var.Ident, free_coord);
  Clean_OutAttributes(lop);
  rop = Copy_TopoExpr(coord->MPC_CoordDecl.Range, coordinate, pparam);
  e2 = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		       SINGLE_NODE_LIST, SINGLE_NODE, LESS_THEN, lop, rop);         /* e2 ready; */
  Clean_OutAttributes(e2);

  lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		   SINGLE_NODE_LIST, SINGLE_NODE, free_coord->MPC_Var.Ident, free_coord);
  Clean_OutAttributes(lop);
  e3 = mMPC_UnaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		      SINGLE_NODE_LIST, SINGLE_NODE, POST_INC, lop);
  Clean_OutAttributes(e3);

  tmp = nMPC_FreeNode();

  if(coord->MPC_CoordDecl.Next!=NoTree &&
     coord->MPC_CoordDecl.Next->Kind==kMPC_CoordDecl) {  /* make recursive call: */
    for_loop = mMPC_For(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3,
			Emit_FreeCoordLoops(coord->MPC_CoordDecl.Next, stat, coordinate,
					    free_coord->MPC_Var.Next, pparam)
	       );
  }
  else {
    for_loop = mMPC_For(NoPosition, tmp, tmp, Stat_TopoFlags, SINGLE_NODE_LIST, e1, e2, e3, stat);
  }
  Clean_OutAttributes(for_loop);
  for_loop->MPC_For.Stats->MPC_Stat.Next =
    for_loop->MPC_For.Stats->MPC_Stat.Prev = mMPC_FreeNode(for_loop);

  return for_loop;
}

/******************/
tTree Emit_PairCheck	/* make 'MPC_If' without 'Stats' : */
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree LinkDeclarator, tTree coord1, tTree coord2, tTree fcoord, tTree pparam)
#else
	(LinkDeclarator, coord1, coord2, fcoord, pparam)
	tTree LinkDeclarator,
	      coord1,
	      coord2,
	      fcoord,	/* pointer to MPC_Var node for free coords; */
	      pparam;
#endif
{
  tTree stat, root, lop, rop, exprs;
  int i;
  exprs = LinkDeclarator->MPC_LinkDeclarator.LeftNode;
  root = NoTree;
  for(i=0;exprs->Kind==kMPC_Exprs;i++) {
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		SINGLE_NODE_LIST, SINGLE_NODE, coord1->MPC_Var.Ident, coord1
	  );
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[i], i
	  );
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop
	  );
    Clean_OutAttributes(lop);
    Reset_FreeCoord_Store(exprs->MPC_Exprs.Expr, fcoord);
    rop = Copy_TopoExpr(exprs->MPC_Exprs.Expr, coord1, pparam);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, EQUAL, lop, rop
	  );
    Clean_OutAttributes(rop);
    if(root)
      root = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, LOG_AND, root, rop
	  );
    else
      root = rop;
    Clean_OutAttributes(root);
    exprs = exprs->MPC_Exprs.Next;
  }
  exprs = LinkDeclarator->MPC_LinkDeclarator.RightNode;
  for(i=0;exprs->Kind==kMPC_Exprs;i++) {
    lop = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, Pointer_To_Int,
		SINGLE_NODE_LIST, SINGLE_NODE, coord2->MPC_Var.Ident, coord2
	  );
    Clean_OutAttributes(lop);
    rop = mMPC_IntConst(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		CONST_NET_LIST, CONST_NET, Symbolic_IntConst[i], i
	  );
    Clean_OutAttributes(rop);
    lop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, INDEX, lop, rop
	  );
    Clean_OutAttributes(lop);
    Reset_FreeCoord_Store(exprs->MPC_Exprs.Expr, fcoord);
    rop = Copy_TopoExpr(exprs->MPC_Exprs.Expr, coord2, pparam);
    rop = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, EQUAL, lop, rop
	  );
    Clean_OutAttributes(rop);
    if(root)
      root = mMPC_BinaryExpr(NoPosition, Expr_TopoFlags, EmptyString, IntType,
		SINGLE_NODE_LIST, SINGLE_NODE, LOG_AND, root, rop
	  );
    else
      root = rop;
    exprs = exprs->MPC_Exprs.Next;
  }
  Clean_OutAttributes(root);
  stat = mMPC_If(NoPosition, NoTree, NoTree, Stat_TopoFlags, SINGLE_NODE_LIST, root, NoTree);
  Clean_OutAttributes(stat);
  return stat;
}

/******************/
tTree Emit_CoordVars
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType)
#else
	(NetType) tTree NetType;
#endif
{
  tTree vardecl, var, coord;
  
  coord = NetType->MPC_NetType.CoordDecl;
  var = nMPC_FreeNode();

  while(coord!=NoTree && coord->Kind==kMPC_CoordDecl){
    var = mMPC_Var(NoPosition, coord->MPC_CoordDecl.Ident, Local_TopoFlags,
		   var, var, IntType, SINGLE_NODE, NoTree);
    coord = coord->MPC_CoordDecl.Next;
  }
  vardecl = mMPC_VarDecl(NoPosition, NoTree, NoTree, AUTO,
			 Local_TopoFlags, IntType, ReverseTree(var));
  vardecl->MPC_VarDecl.Var->MPC_Var.Prev->MPC_FreeNode.Parent = vardecl;
  return vardecl; 
}

#define Reeval_ParamType(type)  (type->Kind==kMPC_BasicType&&type->MPC_BasicType.TypeConstructor==INT?ConstIntType:Pointer_To_ConstInt)

/*******************/
tTree Emit_TopoParams
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetType, tTree ppar)
#else
	(NetType, ppar) tTree NetType, ppar;
#endif
{
  tTree vardecl, var, param, init_expr, expr;

  param = NetType->MPC_NetType.ParamList;
  var = nMPC_FreeNode();

  while(param!=NoTree && param->Kind==kMPC_Var){
    var = mMPC_Var(NoPosition, param->MPC_Var.Ident, Local_TopoFlags,
		   var, var, Reeval_ParamType(param->MPC_Var.Type), SINGLE_NODE, NoTree/**tmp**/);

    /* Make the corresponding initialization: */
    expr = mMPC_Ident(NoPosition, Expr_TopoFlags, EmptyString, var->MPC_Var.Type,
		      SINGLE_NODE_LIST, SINGLE_NODE, var->MPC_Var.Ident, param);
    Clean_OutAttributes(expr);
    init_expr = Copy_TopoExpr(expr, NoTree, ppar);
    var->MPC_Var.Init = mMPC_SimpleInit(NoPosition, NoTree, NoTree, init_expr);;

    param = param->MPC_Var.Next;
  }
  vardecl = mMPC_VarDecl(NoPosition, NoTree, NoTree, AUTO,
			 Local_TopoFlags, ConstIntType, ReverseTree(var));
  return vardecl;
}



