/* mpC-compiler, pass 2:     Relations between all (sub)nets        */
/* ====================      ===============================        */
/*                                                                  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*         =============== Initial revision, 1996/09/.. ==========  */

#ifndef _NET_REL
#define _NET_REL

#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif

#include "DynArray.h"
#include "Idents.h"

#include "context.h"
#include "mpc_sn_rel.h"
#include "options.h"
#include "mpc_diag.h"
#include "mpc_pass1.h"


extern tTree  ErrorNet, ErrorNetList;


/* Table of nets and subnets */

typedef struct {
  tTree Net;
  long NetSize;
  short ParentIndex;
  char *Rel;
} tNetRecord;


static unsigned long NetTable_Size;
static tNetRecord *NetTable;
static long        Max_NetNumber;  /* number of curr. existing net/subnet; */


/* Declaration of work functions: */

static long  Eval_NetOrSubnet_Size ARGS((tTree Net));
static char  Eval_SubnetRelation   ARGS((tTree Net1, tTree Net2));
static int   Eval_TopoExpr	   ARGS((tTree Expr, int*Coord, tTree Param, tTree Arg));
static int   Inc_Coordinates	   ARGS((int coord_number, int *coord, int *coord_range));
static bool  Is_LayerPredicate	   ARGS((tTree Expr));
static int   Layer_Size		   ARGS((tTree Subnet, tTree coords, int *coord_range));


/******************/
void Init_NetTable()
/******************/
{
  static int IsAllocated = NO;
  int i,j;

  NetTable_Size = MAX_NET;
  Max_NetNumber = 0;

  if(!IsAllocated)  {
    MakeArray((char **)&NetTable, &NetTable_Size, sizeof(tNetRecord));
    for(i=0; i<NetTable_Size; i++) {
      MakeArray(&(NetTable[i].Rel), &NetTable_Size, sizeof(char));
    }
    IsAllocated = YES;
  }

  for(i=0; i<NetTable_Size; i++) {
    NetTable[i].Net = NoTree;
    NetTable[i].NetSize = NOT_SET;
    NetTable[i].ParentIndex = UNDEFINED;
    for(j=0; j<NetTable_Size; j++) {
      NetTable[i].Rel[j] = NOT_SET;
    }
  }
}

/*********/
int Add_Net
/*********/
#if defined __STDC__ | defined __cplusplus
	(tTree Net)
#else
	(Net)
	tTree Net;
#endif
{
  tTree net2;
  int net_num, net2_num=0;

  if(Net->MPC_NetOrSubnet.UniqueNumber==NetTable_Size) {
    Make_Message(25, xxRestriction, Net->MPC_NetOrSubnet.Pos, NoTree);
		/* "Too many nets (subnets) declared in program; you can avoid this exception using -netNN option (where NN is number of nets or subnets in this program);" */
    Make_MessageI(26, xxInformation, Net->MPC_NetOrSubnet.Pos, xxLong,
		  (char*)&Max_NetNumber, NoTree);
		/* "Number of currently declared nets/subnets" */
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
		  
    exit(1);
  }

  net_num = Net->MPC_NetOrSubnet.UniqueNumber;
  if(NetTable[net_num].NetSize!=NOT_SET) return 0;  /* net is already in table; */
  Max_NetNumber = Max(net_num,Max_NetNumber+1);
  NetTable[net_num].Net = Net;
  net2 = Net->MPC_NetOrSubnet.Distribution;
  if(net2) net2_num = net2->MPC_NetOrSubnet.UniqueNumber;
  NetTable[net_num].NetSize = Eval_NetOrSubnet_Size(Net);

  /* 'lazy' evaluation of some relations: */

  if(net2)  /* Net!=HOST && Net!=SINGLE_NODE && ... */
    if(Net->Kind==kMPC_Net)  /* net2 is subnet of Net: */
      NetTable[net2_num].Rel[net_num] = SUBNET;
    else {  /* if(Net->Kind==kMPC_Subnet) */
      while(net2->Kind==kMPC_Subnet) {
        if(NetTable[net_num].NetSize==NetTable[net2_num].NetSize &&
	   NetTable[net_num].NetSize!=UNDEFINED) /* => predicate==1; */
          NetTable[net_num].Rel[net2_num] =
	    NetTable[net2_num].Rel[net_num] = EQUAL_NET;
        else
          NetTable[net_num].Rel[net2_num] = SUBNET;
        net2 = net2->MPC_Subnet.Distribution;
        net2_num = net2->MPC_NetOrSubnet.UniqueNumber;
      }
      /* net2->Kind==kMPC_Net */
      if(NetTable[net_num].NetSize==NetTable[net2_num].NetSize &&
	   NetTable[net_num].NetSize!=UNDEFINED) /* => predicate==1; */
        NetTable[net_num].Rel[net2_num] =
	   NetTable[net2_num].Rel[net_num] = EQUAL;
      else
        NetTable[net_num].Rel[net2_num] = SUBNET;
    }
  if(Net!=CONST_NET)
    Set_Relation(SUBNET, Net, CONST_NET, Net->MPC_NetOrSubnet.Pos);
  if(Net!=COMPUTING_SPACE)
    Set_Relation(SUBNET, Net, COMPUTING_SPACE, Net->MPC_NetOrSubnet.Pos);

  return 0;
}

/**************/
int Set_Relation
/**************/
#if defined __STDC__ | defined __cplusplus
	(int Rel, tTree Net1, tTree Net2, tPosition Pos)
#else
	(Rel, Net1, Net2, Pos)
	int Rel;
	tTree Net1, Net2;
	tPosition Pos;
#endif
{
  int num1, num2, old_rel;
  num1 = Net1->MPC_NetOrSubnet.UniqueNumber;
  num2 = Net2->MPC_NetOrSubnet.UniqueNumber;
  if(Rel==SUPERNET) {
    Rel = SUBNET;
    num1 = Net2->MPC_NetOrSubnet.UniqueNumber;
    num2 = Net1->MPC_NetOrSubnet.UniqueNumber;
  }
  old_rel = NetTable[num1].Rel[num2];
  switch(Rel) {
    case NO_RELATION:
    case NOT_SET:
	NetTable[num1].Rel[num2] = Rel;  /* no check for this 2 cases; */
	break;
    case EQUAL_NET:
	if(old_rel && old_rel!=EQUAL_NET) {
	  CompilerError("Reevaluation of subnet/supernet relation", Pos);
	  return 1;
	}
	NetTable[num1].Rel[num2] = EQUAL_NET;
	NetTable[num2].Rel[num1] = EQUAL_NET;
	break;
    case COMPATIBLE:
	if(old_rel && old_rel!=COMPATIBLE) {
	  CompilerError("Reevaluation of subnet/supernet relation", Pos);
	  return 1;
	}
	NetTable[num1].Rel[num2] = COMPATIBLE;
	break;
    case SUBNET:
	if(old_rel && old_rel!=SUBNET) {
	  CompilerError("Reevaluation of subnet/supernet relation", Pos);
	  return 1;
	}
	else if(old_rel && old_rel==SUBNET) {
	  DECL_Warning((484, xxWarning, Pos, NoTree));
		/* "Redeclaration of subnet/supernet relation" */
	}
	NetTable[num1].Rel[num2] = SUBNET;
	break;
    default:
	CompilerError(
		"Invalid relation between two nets/subnets evaluated", Pos);
  }
  return 0;
}

/************/
bool Is_Subnet
/************/
#if defined __STDC__ | defined __cplusplus
	(tTree subnet, tTree supernet)
#else
	(subnet, supernet)
	tTree subnet, supernet;
#endif
{
  extern int Reduce_NetList;    /* Flag of general(1)/special(0) case  */
				/* - treat parent net as subnet or no; */
  int sub_num, super_num;

  if(supernet==CONST_NET || supernet==COMPUTING_SPACE) return true;
  if(subnet==RECON_NET && supernet==COMPUTING_SPACE) return true;

  if(subnet==NoTree || supernet==NoTree) {
    /******/
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
    if(DEBUG)
      /**QueryTree(TreeRoot),**/CompilerError("Empty subnet or supernet in call to Is_Subnet()", NoPosition);
    exit(1);
    /******/
  }

  sub_num = subnet->MPC_NetOrSubnet.UniqueNumber;
  super_num = supernet->MPC_NetOrSubnet.UniqueNumber;

  if(!Reduce_NetList && supernet->Kind==kMPC_Net &&
     supernet->MPC_Net.Distribution==subnet)  /* subnet is parent of supernet; */
    return false;
  if(subnet==supernet || Is_Equal_Net(subnet,supernet) || supernet==COMPUTING_SPACE ||
     NetTable[sub_num].Rel[super_num]==SUBNET ||
     supernet->Kind==kMPC_Net && supernet->MPC_Net.Distribution!=NoTree && /*FKind!=NETWORK:*/
        supernet->MPC_Net.Distribution!=SINGLE_NODE /*!!!*/ && Reduce_NetList &&
	(supernet->MPC_Net.Distribution==subnet ||
	 Is_Subnet(subnet,supernet->MPC_Net.Distribution)) ||
     supernet==SINGLE_NODE) return true;
  if(subnet->Kind != kMPC_Subnet) return false;

  while(subnet->Kind==kMPC_Subnet) {
    subnet = subnet->MPC_NetOrSubnet.Distribution;
    if(subnet==supernet || Is_Equal_Net(subnet,supernet)) return true;
  }

  return false;
}

/***************/
bool Is_Equal_Net
/***************/
#if defined __STDC__ | defined __cplusplus
	(tTree net1, tTree net2)
#else
	(net1, net2)
	tTree net1, net2;
#endif
{
  int num1, num2;

  if(net1==NoTree || net2==NoTree) {
    /******/
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
    if(DEBUG)
      /**QueryTree(TreeRoot),**/CompilerError("Empty net in call to Is_Equal_Net()",NoPosition);
    exit(1);
    /******/
  }
  num1 = net1->MPC_NetOrSubnet.UniqueNumber;
  num2 = net2->MPC_NetOrSubnet.UniqueNumber;

  if(net1==net2 ||
     NetTable[num1].Rel[num2]==EQUAL_NET || NetTable[num2].Rel[num1]==EQUAL_NET)
    return true;
  if(net1->Kind==kMPC_Subnet && net1->MPC_Subnet.IsParent &&
     net2->Kind==kMPC_Subnet && net2->MPC_Subnet.IsParent &&
     net1->MPC_Subnet.Distribution==net2->MPC_Subnet.Distribution) {
    Set_Relation(EQUAL_NET, net1, net2, net1->MPC_Subnet.Pos);
    return true;
  }

  return false;
}

/********************/
bool Is_Compatible_Net
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree net1, tTree net2)
#else
	(net1, net2)
	tTree net1, net2;
#endif
{
  int num1, num2;

  if(net1==NoTree || net2==NoTree) {
    /******/
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
    if(DEBUG)
      /**QueryTree(TreeRoot),**/CompilerError("Empty net in call to Is_Equal_Net()",NoPosition);
    exit(1);
    /******/
  }

  num1 = net1->MPC_NetOrSubnet.UniqueNumber;
  num2 = net2->MPC_NetOrSubnet.UniqueNumber;

  /* 1. check on single node subnet: */
  if((net1==HOST || net1==SINGLE_NODE ||
      net1->Kind==kMPC_Subnet && net1->MPC_Subnet.SingleNode) &&
     (net2==HOST || net2==SINGLE_NODE ||
      net2->Kind==kMPC_Subnet && net2->MPC_Subnet.SingleNode)) return true;
  /* 2. check on relation: */
  if(NetTable[num1].Rel[num2]==COMPATIBLE) return true;
  return false; /*tmp*/
}

/*********/
int NetSize
/*********/
#if defined __STDC__ | defined __cplusplus
	(tTree net)
#else
	(net)
	tTree net;
#endif
{
  return NetTable[net->MPC_NetOrSubnet.UniqueNumber].NetSize;
}

/******************/
void NetTable_Dump()
/******************/
{
  int i,j;
  printf("Table of relations between nets and subnets:\n"
	 "============================================\n");
  for(i=0; i<NetTable_Size; i++) {
    char Name[128];
    if(!NetTable[i].Net) continue;
    GetString(NetTable[i].Net->MPC_NetOrSubnet.Ident, Name);
    printf("%3d:%16s (%3ld) : ",i,Name,NetTable[i].NetSize);
    for(j=0; j<NetTable_Size; j++)
      printf(" %d", NetTable[i].Rel[j]);
    printf("\n");
  }
}

/*********************/
void Release_NetTable()
/*********************/
{
  /**int i;**/
  if(DEBUG) NetTable_Dump(); /********/
  /****
  for(i=0; i<NetTable_Size; i++) {
    ReleaseArray(&(NetTable[i].Rel), &NetTable_Size, sizeof(tNetRecord));
    NetTable[i].Rel = NULL;
  }
  ReleaseArray(&NetTable, &NetTable_Size, sizeof(char));
  NetTable = NULL;
  ****/
  Max_NetNumber = 0;
}


#define      USE_FLAG  SHRT_MAX/2  /* Contains the current predicate this coordinate? */

static tTree CurrCoord;  /* Is set by Maybe_SingleNode_Predicate(); */

/**************************/
bool Is_SingleNode_Predicate
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Subnet)
#else
	(Subnet)
	tTree Subnet;
#endif
{
  tTree Parent;
  bool result=false;
  bool Maybe_SingleNode_Predicate	ARGS((tTree Expr));

if(Subnet->MPC_Subnet.Pos.Line==344 && Subnet->MPC_Subnet.Pos.Column==29)BreakParser();/******/
  if(!Maybe_SingleNode_Predicate(Subnet->MPC_Subnet.Predicate))
    return false;

  Parent = Subnet;
  while(Parent->Kind==kMPC_Subnet) {
    (void)Maybe_SingleNode_Predicate(Parent->MPC_Subnet.Predicate);
    Parent = Parent->MPC_Subnet.Distribution;
  }

  if(CurrCoord!=NoTree)
    result = true;
  while(CurrCoord!=NoTree && CurrCoord->MPC_CoordDecl.Prev->Kind==kMPC_CoordDecl)
    CurrCoord = CurrCoord->MPC_CoordDecl.Prev;  /* find first CoordDecl node; */
  while(CurrCoord!=NoTree && CurrCoord->Kind==kMPC_CoordDecl) {
    if(CurrCoord->MPC_CoordDecl.CoordNumber >= USE_FLAG)
      CurrCoord->MPC_CoordDecl.CoordNumber -= USE_FLAG;  /* Restore CoordNumber; */
    else
      result = false;  /* The predicate don't contains this coordinate; */
    CurrCoord = CurrCoord->MPC_CoordDecl.Next;
  }

  return result;
}

/*****************************/
bool Maybe_SingleNode_Predicate
/*****************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr)
	tTree Expr;
#endif
{
  tTree lop, rop;
  bool No_CoordInExpr(tTree Expr);
  if(Expr->Kind==kMPC_BinaryExpr && Expr->MPC_BinaryExpr.OpCode==LOG_AND)
    return Maybe_SingleNode_Predicate(Expr->MPC_BinaryExpr.Loperand) &&
		Maybe_SingleNode_Predicate(Expr->MPC_BinaryExpr.Roperand);
  if(Expr->Kind==kMPC_BinaryExpr && Expr->MPC_BinaryExpr.OpCode==EQUAL) {
    lop = Expr->MPC_BinaryExpr.Loperand;
    rop = Expr->MPC_BinaryExpr.Roperand;
    if((lop->Kind==kMPC_Ident && lop->MPC_Ident.Store->Kind==kMPC_CoordDecl ||
	lop->Kind==kMPC_CoordExpr && lop->MPC_CoordExpr.Operand->Kind==kMPC_Ident &&
	lop->MPC_CoordExpr.Operand->MPC_Ident.Store->Kind==kMPC_CoordDecl)  &&
       (rop->MPC_Expr.Flag.Const || No_CoordInExpr(rop))) {
      if(lop->Kind==kMPC_Ident)     CurrCoord = lop->MPC_Ident.Store;
      if(lop->Kind==kMPC_CoordExpr) CurrCoord = lop->MPC_CoordExpr.Operand->MPC_Ident.Store;
      if(CurrCoord->MPC_CoordDecl.CoordNumber < USE_FLAG)
	CurrCoord->MPC_CoordDecl.CoordNumber += USE_FLAG;
      return true;
    }
    if((rop->Kind==kMPC_Ident && rop->MPC_Ident.Store->Kind==kMPC_CoordDecl ||
	rop->Kind==kMPC_CoordExpr && rop->MPC_CoordExpr.Operand->Kind==kMPC_Ident &&
	rop->MPC_CoordExpr.Operand->MPC_Ident.Store->Kind==kMPC_CoordDecl)  &&
       (lop->MPC_Expr.Flag.Const || No_CoordInExpr(lop))) {
      if(rop->Kind==kMPC_Ident)     CurrCoord = rop->MPC_Ident.Store;
      if(rop->Kind==kMPC_CoordExpr) CurrCoord = rop->MPC_CoordExpr.Operand->MPC_Ident.Store;
      if(CurrCoord->MPC_CoordDecl.CoordNumber < USE_FLAG)
	CurrCoord->MPC_CoordDecl.CoordNumber += USE_FLAG;
      return true;
    }
  }
  return false;
}

/*****************/
bool No_CoordInExpr
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr)
	tTree Expr;
#endif
{
  switch(Expr->Kind) {
    case kMPC_IntConst:
    case kMPC_UIntConst:
    case kMPC_FloatConst:
    case kMPC_StringLiteral:
	return true;
    case kMPC_Ident:
	if(Expr->MPC_Ident.Store->Kind!=kMPC_CoordDecl) return true; break;
    case kMPC_CastExpr:
	return No_CoordInExpr(Expr->MPC_CastExpr.Operand);
    case kMPC_NetCastExpr:
	return No_CoordInExpr(Expr->MPC_NetCastExpr.Operand);
    case kMPC_CoordExpr:
	return false;
    case kMPC_Size_Of_Value:
    case kMPC_Size_Of_Type:
	return true;
    case kMPC_UnaryExpr:
	return No_CoordInExpr(Expr->MPC_UnaryExpr.Operand);
    case kMPC_BinaryExpr:
	return  No_CoordInExpr(Expr->MPC_BinaryExpr.Loperand) &&
		No_CoordInExpr(Expr->MPC_BinaryExpr.Roperand);
    case kMPC_TernaryExpr:
	return  No_CoordInExpr(Expr->MPC_TernaryExpr.Foperand) &&
		No_CoordInExpr(Expr->MPC_TernaryExpr.Soperand) &&
		No_CoordInExpr(Expr->MPC_TernaryExpr.Toperand);
    case kMPC_CallExpr:
	{
	  tTree arg;
	  arg = Expr->MPC_CallExpr.ArgList;
	  while(arg->Kind==kMPC_Exprs) {
	    if(!No_CoordInExpr(arg->MPC_Exprs.Expr)) return false;
	    arg = arg->MPC_Exprs.Next;
	  }
	}
	return true;
    default:
	CompilerError("Not expression tree passed as predicate in subnet specifier",
		      Expr->MPC_Expr.Pos);
  }
  return false;
}

/********************/
bool Is_DistributedNet
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Net)
#else
	(Net) tTree Net;
#endif
{
  while(Net->Kind==kMPC_Subnet) Net = Net->MPC_Subnet.Distribution;
  if(Net->MPC_Net.Distribution==HOST ||
     Net->MPC_Net.Distribution==SINGLE_NODE ||
     Net->MPC_Net.Distribution->MPC_NetOrSubnet.SingleNode) return false;
  return true;
}



/****************************************************************/
/*********************** WORK FUNCTIONS: ************************/
/****************************************************************/

/********************************/
static long  Eval_NetOrSubnet_Size
/********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Net)
#else
	(Net)
	tTree Net;
#endif
{
  /*** WARNING: node type VOID is currently not implemented, =>, ***/
  /*** this function don't check node types (only the predicate) ***/

  int size = UNDEFINED;
  tTree parent, nettype, coordlist, parlist, arglist, tmp;
  int	coord_number, *coord, *coord_range;
  int   cn, MORE=YES;

  if(Net->MPC_NetOrSubnet.SingleNode) return 1;
  if(Net==COMPUTING_SPACE || Net==CONST_NET || Net==RECON_NET || Net==ErrorNet)
    return UNDEFINED;
	/* maybe 'Net' is net parameter of network function? */
  if(Net->Kind==kMPC_Net && Net->MPC_Net.Topology==PARAMETER) return UNDEFINED;
	/* maybe 'Net' is subnet of net parameter of network function? */
  if(Net->Kind==kMPC_Subnet) {
    tTree supernet;
    int sn_number;
    supernet = Net->MPC_Subnet.Distribution;
    sn_number = supernet->MPC_NetOrSubnet.UniqueNumber;
    if(supernet->Kind==kMPC_Net && supernet->MPC_Net.Topology==PARAMETER)
      return UNDEFINED;
    if(sn_number && /* supernet is in NetTable: */
       NetTable[sn_number].NetSize==UNDEFINED) return UNDEFINED;
  }

/***return size;***/
  for(parent=Net; parent->Kind==kMPC_Subnet;
      parent=parent->MPC_Subnet.Distribution);  /* find MPC_Net and its topology: */
  nettype = parent->MPC_Net.NetType;		/* MPC_NetTypeSpecifier; */
  arglist = nettype->MPC_NetTypeSpecifier.ArgList;
  nettype = nettype->MPC_NetTypeSpecifier.NetType;  /* MPC_NetType; */
  parlist = nettype->MPC_NetType.ParamList;
  coordlist = nettype->MPC_NetType.CoordDecl;

  /* Eval coord_range for every coordinate: */

  tmp = coordlist;
  while(tmp->MPC_CoordDecl.Next->Kind==kMPC_CoordDecl)
    tmp = tmp->MPC_CoordDecl.Next;
  coord_number = tmp->MPC_CoordDecl.CoordNumber + 1;
  coord_range = (int*)malloc(coord_number*sizeof(int));
  coord       = (int*)malloc(coord_number*sizeof(int));
  for(cn=0,tmp=coordlist; cn<coord_number; cn++,tmp=tmp->MPC_CoordDecl.Next) {
    coord_range[cn] =
	  Eval_TopoExpr(tmp->MPC_CoordDecl.Range, NULL, parlist, arglist);
    if(coord_range[cn]==UNDEFINED)
      return UNDEFINED;   /* This is a dynamic net; */
  }

  /* Count number of processors: */

  if(Net->Kind==kMPC_Net) {
    size = 1;
    for(cn=0; cn<coord_number; cn++)
      size *= coord_range[cn];
  }
  else {  /* We have the chain of subnets: */
    size = 0;

    /* check the case of [Net:I==expr], where Net has { coord I=M, J=N,...; } : */

    parent = Net->MPC_Subnet.Distribution;
    if(NetSize(parent)==UNDEFINED) return UNDEFINED;
    if(parent->Kind==kMPC_Net && Is_LayerPredicate(Net->MPC_Subnet.Predicate))
      return Layer_Size(Net, coordlist, coord_range);

    /* the generic case: */

    for(cn=0; cn<coord_number; cn++) coord[cn] = 0; /* initial coordinates (0, ... ,0); */
    while(MORE) {
      tTree N=Net;
      int curr_node=1, p_value;
      for(; N->Kind==kMPC_Subnet && curr_node; N=parent) {
	parent = N->MPC_Subnet.Distribution;
	if(NetTable[parent->MPC_NetOrSubnet.UniqueNumber].NetSize==UNDEFINED)
	  return UNDEFINED;  /* This subnet has dynamic supernet(s); */
	p_value = Eval_TopoExpr(N->MPC_Subnet.Predicate,coord,parlist,arglist);
	if(p_value==UNDEFINED) return UNDEFINED;  /* This subnet has dynamic predicate; */
	curr_node = curr_node && p_value;
      }
      size += curr_node ;
      MORE = Inc_Coordinates(coord_number, coord, coord_range);
    }
  } /* end if */

  free(coord);
  free(coord_range);

  return size;
}

/************************/
static int Inc_Coordinates
/************************/
#if defined __STDC__ | defined __cplusplus
	(int coord_number, int *coord, int *coord_range)
#else
	(coord_number, coord, coord_range)
#endif
{
  int SHIFT = 1;
  while(SHIFT && coord_number) {
    coord_number--;
    coord[coord_number] = (coord[coord_number]+1) % coord_range[coord_number] ;
    SHIFT = !coord[coord_number];
  }
  if(SHIFT)
    return 0;  /* no more coordinates; */
  else
    return 1;
}

/******************************/
static char  Eval_SubnetRelation
/******************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Net1, tTree Net2)
#else
	(Net1, Net2)
	tTree Net1,Net2;
#endif
{
  return NO_RELATION; /* tmp */
}

/***********************/
static int  Eval_TopoExpr
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr, int *Coord, tTree Param, tTree Arg)
#else
	(Expr, Coord, Param, Arg)
	tTree Expr, Param, Arg;
	int *Coord;
#endif
{
  int fop, sop, top;

  if(!Expr->MPC_Expr.Flag.Ignore)
    switch(Expr->Kind) {
      case kMPC_IntConst:   return Expr->MPC_IntConst.Value;
      /*****************/
      case kMPC_UIntConst:  return Expr->MPC_UIntConst.Value;
      /******************/
      case kMPC_Ident:
      /**************/
	if(Expr->MPC_Ident.Store->Kind==kMPC_CoordDecl)
	  return Coord[Expr->MPC_Ident.Store->MPC_CoordDecl.CoordNumber];
	else {  /* Check: Topo parameter or other variable? */
	  tTree par=Param, arg=Arg;
	  while(par->Kind==kMPC_Var) {
	    if(Expr->MPC_Ident.Store==par &&
	       par->MPC_Var.Type->Kind==kMPC_BasicType &&
	       par->MPC_Var.Type->MPC_BasicType.TypeConstructor==INT
	       )  /* eval argument value: */
	      return Eval_TopoExpr(arg->MPC_Exprs.Expr, Coord, Param, Arg);
	    par = par->MPC_Var.Next;
	    arg = arg->MPC_Exprs.Next;
	  }
	}
	break;
      case kMPC_NetCastExpr:
      /********************/
	return Eval_TopoExpr(Expr->MPC_NetCastExpr.Operand, Coord, Param, Arg);
      case kMPC_CoordExpr:
      /******************/
	if(Expr->MPC_CoordExpr.Operand->Kind==kMPC_Ident &&
	   Expr->MPC_CoordExpr.Operand->MPC_Ident.Store->Kind==kMPC_CoordDecl &&
	   Expr->MPC_CoordExpr.CoordName==Expr->MPC_CoordExpr.Operand->MPC_Ident.Ident)
	  return Eval_TopoExpr(Expr->MPC_CoordExpr.Operand, Coord, Param, Arg);
	else
	  SPEC_Warning(( 42, xxWarning, Expr->MPC_Expr.Pos, Expr));
		/* "Can't use this predicate for semantic checks; more errors possible" */
	break;
      case kMPC_Size_Of_Value:
      /**********************/
	return Eval_SizeofExpr(Expr->MPC_Size_Of_Value.Operand, Expr->MPC_Expr.Pos);
      case kMPC_Size_Of_Type:
      /*********************/
	return Eval_SizeofExpr(Expr->MPC_Size_Of_Type.Operand, Expr->MPC_Expr.Pos);
      case kMPC_UnaryExpr:
      /******************/
	fop = Eval_TopoExpr(Expr->MPC_UnaryExpr.Operand, Coord, Param, Arg);
	if(fop==UNDEFINED) return UNDEFINED;
	return Eval_UnaryExpr(Expr->MPC_UnaryExpr.OpCode, fop, Expr->MPC_Expr.Pos);
      case kMPC_BinaryExpr:
      /*******************/
	fop = Eval_TopoExpr(Expr->MPC_BinaryExpr.Loperand, Coord, Param, Arg);
	sop = Eval_TopoExpr(Expr->MPC_BinaryExpr.Roperand, Coord, Param, Arg);
	if(fop==UNDEFINED || sop==UNDEFINED) return UNDEFINED;
	return Eval_BinaryExpr(
			Expr->MPC_BinaryExpr.OpCode, fop, sop, Expr->MPC_Expr.Pos);
      case kMPC_TernaryExpr:
      /********************/
	if(Expr->MPC_TernaryExpr.OpCode==CONDITION) {
	  fop = Eval_TopoExpr(Expr->MPC_TernaryExpr.Foperand, Coord, Param, Arg);
	  sop = Eval_TopoExpr(Expr->MPC_TernaryExpr.Soperand, Coord, Param, Arg);
	  top = Eval_TopoExpr(Expr->MPC_TernaryExpr.Toperand, Coord, Param, Arg);
	  if(fop==UNDEFINED || sop==UNDEFINED || top==UNDEFINED) return UNDEFINED;
	  return fop?sop:top ;
	}
      case kMPC_CallExpr:
      /*****************/
	return UNDEFINED;
      default:
      /******/
	SPEC_Warning(( 42, xxWarning, Expr->MPC_Expr.Pos, Expr));
		/* "Can't use this predicate for semantic checks; more errors possible" */
	break;
    }
  return UNDEFINED;
}

/****************************/
static bool  Is_LayerPredicate
/****************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr) tTree Expr;
#endif
{
 bool result=false;
  bool Maybe_SingleNode_Predicate	ARGS((tTree Expr));

  if(Maybe_SingleNode_Predicate(Expr)) {
    while(CurrCoord!=NoTree && CurrCoord->MPC_CoordDecl.Prev->Kind==kMPC_CoordDecl)
      CurrCoord = CurrCoord->MPC_CoordDecl.Prev;  /* find first CoordDecl node; */
    result = true;
    while(CurrCoord!=NoTree && CurrCoord->Kind==kMPC_CoordDecl) {
      if(CurrCoord->MPC_CoordDecl.CoordNumber >= USE_FLAG)
	CurrCoord->MPC_CoordDecl.CoordNumber -= USE_FLAG;  /* Restore CoordNumber; */
      CurrCoord = CurrCoord->MPC_CoordDecl.Next;
    }
  }

  return result;  
}

/*********************/
static int   Layer_Size
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Subnet, tTree coords, int *coord_range)
#else
	(Subnet, coords, coord_range)
	tTree Subnet, coords;
	int *coord_range;
#endif
{
  int size=UNDEFINED;
  if(Maybe_SingleNode_Predicate(Subnet->MPC_Subnet.Predicate)) {
    size = NetSize(Subnet->MPC_Subnet.Distribution);
    while(coords!=NoTree && coords->Kind==kMPC_CoordDecl) {
      if(coords->MPC_CoordDecl.CoordNumber >= USE_FLAG) {
	coords->MPC_CoordDecl.CoordNumber -= USE_FLAG;  /* Restore CoordNumber; */
	size /= coord_range[coords->MPC_CoordDecl.CoordNumber];
      }
      coords = coords->MPC_CoordDecl.Next;
    }
  }
  return size;
}


#endif
