/* mpC-compiler, pass 2:               "SEMANTICS"                  */
/* ====================                 =========                   */
/*                                                                  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*         =============== Initial revision, 1995/12/.. ==========  */

#ifndef _PASS2
#define _PASS2

#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif

#include "context.h"
#include "Tree.h"


	/* Values of 'Context' and 'agContext': */

#define GLOBAL_DECLS		1
#define LOCAL_DECLS		2
#define PROTOTYPE		3
#define PARAM_DECLS		4
#define TOPO_PARAMS		5
#define ARG_LIST		6
#define NETWORK_ARG_LIST	7
#define NET_ARG_LIST		8
#define STATS			9
#define NET_TYPE		10
#define COORD_DECL		11
#define NODE_DECL		12
#define LINK_DECL		13
#define PARENT_DECL		14
#define SCHEME_DECL		15
#define PREDICATE		16


	/* machine-dependent macros for type evaluation: */

#define PTRDIFF_T	LongType
#define SIZE_T		UnsignedType
#define NULL_POINTER	0


static tTree Pure_Type(tTree type) {
  while(type!=NoTree && type->Kind==kMPC_Typedef)
    type = type->MPC_Typedef.Type;
  return type;
}

static bool Is_VoidType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    (type->Kind==kMPC_BasicType&&type->MPC_BasicType.TypeConstructor==VOID);
}

static bool Is_IntegralType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    (type->Kind==kMPC_BasicType&&type->MPC_BasicType.TypeConstructor<VOID&&type->MPC_BasicType.TypeConstructor>FLOAT);
}

static bool Is_ArithmeticType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    (type->Kind==kMPC_BasicType&&type->MPC_BasicType.TypeConstructor<VOID);
}

static bool Is_ScalarType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    (type->Kind==kMPC_BasicType&&type->MPC_BasicType.TypeConstructor<VOID||type->Kind==kMPC_PointerType);
}

static bool Is_PointerType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    type->Kind==kMPC_PointerType;
}

static bool Is_VoidPointerType(tTree type) {
  type = Pure_Type(type);
  return type==NoTree ? false :
    type->Kind==kMPC_PointerType && Is_VoidType(type->MPC_PointerType.ElementType);
}

static bool Is_NULL(tTree expr) {   /** IMPLEMENTATION-DEPENDENT !!!!! **/
  if(expr!=NoTree && expr->Kind==kMPC_CastExpr &&
     Is_VoidPointerType(expr->MPC_CastExpr.TypeName) &&
     expr->MPC_CastExpr.Operand->Kind==kMPC_IntConst &&
     expr->MPC_CastExpr.Operand->MPC_IntConst.Value==NULL_POINTER) return true;
  return false;
}

/*****************************************/

int Semantics		ARGS((tTree Tree));
int Go			ARGS((tTree Tree,int Context,bool NetPossible,tTree NetContext,int FKind));
int Check_SelfAccess		ARGS((tTree Type, tTree Pattern, tPosition Pos)); 
void Set_ConstDistribution	ARGS((tTree Expr, tTree Net));
int Make_UniqueNumber		ARGS((tTree Node));
void Check_On_NetDefinitions	ARGS((tTree Block));
tTree Eval_Block_Distribution	ARGS((tTree Block));
tTree  Replace_Coords		ARGS((tTree Expr));

tTree TerminalType			ARGS((tTree type));
tTree NewVectorType			ARGS((tTree old_type, tTree new_element_type));
int   Is_CorrectBlockedType		ARGS((tTree type));
int   Is_CorrectBlockedExpr		ARGS((tTree expr));

#define REMAKE_IF_BLOCKING(treeptr)  if((*treeptr)->Kind==kMPC_UnaryExpr && (*treeptr)->MPC_UnaryExpr.OpCode==BRACKETS) *treeptr = Remake_BlockingExpr(treeptr);

tTree Remake_BlockingExpr		ARGS((tTree *TreePtr));

int   Is_CorrectBinaryVectorExpr	ARGS((tTree operand1, tTree operand2));
tTree Type_Of_LvectorIndexedByScalar	ARGS((tTree type, int *IsLvalue));
tTree Type_Of_VectorIndexedByScalar	ARGS((tTree type, int *IsLvalue));
tTree Type_Of_ScalarIndexedByVector	ARGS((tTree type, tTree index_type, int *IsLvalue));
tTree Type_Of_LvectorIndexedByVector	ARGS((tTree type, tTree index_type, int *IsLvalue));
tTree Type_Of_VectorIndexedByVector	ARGS((tTree type, tTree index_type, int *IsLvalue));
void  Eval_TypeOfIndexExpr		ARGS((tTree expr));
void  Eval_TypeOfUnaryExpr		ARGS((tTree expr));
void  Eval_TypeOfBinaryExpr		ARGS((tTree expr));
void  Eval_TypeOfTernaryExpr		ARGS((tTree expr));
void  Eval_TypeOfGridExpr		ARGS((tTree expr));
tTree Eval_TypeConversion		ARGS((tTree type1, tTree type2));
tTree ResultVectorType			ARGS((tTree type1, tTree type2));
int   Check_ArgumentType		ARGS((int context, tTree par, tTree arg));
int   Check_Expression			ARGS((tTree expr));
void  Eval_Distribution			ARGS((tTree expr));
void  Eval_AssignDistribution		ARGS((tTree expr));
int   Eval_CoordNumber			ARGS((tTree expr, short *num));
bool  Is_Equal_NetList			ARGS((tTree list1, tTree list2));
tTree Join_NetList			ARGS((tTree list1, tTree list2));
void  Release_NetList			ARGS((tTree list));
bool  Is_SubnetList			ARGS((tTree subnetlist, tTree supernetlist));

void  Eval_StatDistribution	ARGS((tTree stat, bool repl, tTree expr_net, tTree expr_evalnet, tExprFlags *expr_flag, tTree body_net, tStatFlags *body_flag));
bool  PartAsynchr_Possible		ARGS((tTree parent_net_list, tTree net_list));

bool  Check_NetTypeSpecifier	ARGS((tTree NetDecl));
int   Check_NodeSpecifier	ARGS((tTree Exprs, tTree Coords, tTree PrevExprs));
bool  Check_SingleNodeParent	ARGS((tTree NetDecl));
int   Check_UniqueCaseLabel	ARGS((tTree Label));
int   Check_SingleDefaultLabel	ARGS((tTree Label));

tTree Reduce_TypePattern	ARGS((tTree TypePattern));
int   Check_InitList		ARGS((tTree List, tTree TypePattern));

#endif
