# ifndef _OPERATOR

# define _OPERATOR

/*************** operator' codes ****************/


#define   LINEAR		64	/* group of vector linear operator; */
#define   DISTRIBUTED		128	/* group of spec. distr.  operator; */

#define   NO_OPERATOR          0     /*  empty   */
#define   VECT_CONCAT          1     /*   <+> ------------------------   */
#define   VECT_EVAL            2     /*   [#] ------------------------   */
#define   VECT_VALUE           3     /*  {[ ]} -----------------------   */
#define   BRACKETS             4     /*    []    */
#define   INDEX                5     /* op1[op2] */
#define   GRID                 6     /*   [:]    */
#define   DOT                  7     /*    .     */
#define   ARROW                8     /*    ->    */
#define   POST_INC             9     /*   op++   */
#define   POST_DEC            10     /*   op--   */
#define   PRE_INC             11     /*   ++op   */
#define   PRE_DEC             12     /*   --dec  */
#define   ADDRESS             13     /*    &     */
#define   STAR                14     /*    *     */
#define   NEG                 15     /*   -op    */
#define   NOT                 16     /*    ~     */
#define   LOG_NOT             17     /*    !     */
#define   MULT                21     /*    *     */
#define   DIV                 22     /*    /     */
#define   MOD                 23     /*    %     */

#if defined MAX
#undef	MAX
#endif

#if defined MIN
#undef	MIN
#endif

#define   MAX                 24     /*    ?>    */
#define   MIN                 25     /*    ?<    */

#define   PLUS                26     /*    +     */
#define   MINUS               27     /*    -     */
#define   LEFT_SHIFT          28     /*    <<    */
#define   RIGHT_SHIFT         29     /*    >>    */
#define   LESS_THEN           30     /*    <     */
#define   GREAT_THEN          31     /*    >     */
#define   LESS_OR_EQ          32     /*    <=    */
#define   GREAT_OR_EQ         33     /*    >=    */
#define   EQUAL               34     /*    ==    */
#define   NOT_EQUAL           35     /*    !=    */
#define   AND                 36     /*    &     */
#define   EXCL_OR             37     /*    ^     */
#define   INCL_OR             38     /*    |     */
#define   LOG_AND             39     /*    &&    */
#define   LOG_OR              40     /*    ||    */
#define   CONDITION           41     /*    ?:    */
#define   ASSIGN              42     /*    =     */
#define   MULT_ASSIGN         43     /*    *=    */
#define   DIV_ASSIGN          44     /*    /=    */
#define   MOD_ASSIGN          45     /*    %=    */
#define   PLUS_ASSIGN         46     /*    +=    */
#define   MINUS_ASSIGN        47     /*    -=    */
#define   LSHIFT_ASSIGN       48     /*    <<=   */
#define   RSHIFT_ASSIGN       49     /*    >>=   */
#define   AND_ASSIGN          50     /*    &=    */
#define   EXCL_OR_ASSIGN      51     /*    ^=    */
#define   INCL_OR_ASSIGN      52     /*    |=    */
#define   SCAT_ASSIGN         53     /*    =::   */
#define   GATH_ASSIGN         54     /*    ::=   */
#define   COMMA               55     /*    ,     */

	/*** vector linear operators: ***/

#define   LIN_MULT		MULT+LINEAR		/*  [*]op   */
#define   LIN_MAX		MAX+LINEAR		/*  [?>]op  */
#define   LIN_MIN		MIN+LINEAR		/*  [?<]op  */
#define   LIN_PLUS		PLUS+LINEAR		/*  [+]op   */
#define   LIN_AND		AND+LINEAR		/*  [&]op   */
#define   LIN_EXCL_OR		EXCL_OR+LINEAR		/*  [^]op   */
#define   LIN_INCL_OR		INCL_OR+LINEAR		/*  [|]op   */
#define   LIN_LOG_AND		LOG_AND+LINEAR		/*  [&&]op  */
#define   LIN_LOG_OR		LOG_OR+LINEAR		/*  [||]op  */

	/*** distributed linear operators: ***/

#define   DISTR_LIN_MULT	MULT+DISTRIBUTED	/*  op[*]   */
#define   DISTR_LIN_MAX		MAX+DISTRIBUTED		/*  op[?>]  */
#define   DISTR_LIN_MIN		MIN+DISTRIBUTED		/*  op[?<]  */
#define   DISTR_LIN_PLUS	PLUS+DISTRIBUTED	/*  op[+]   */
#define   DISTR_LIN_AND		AND+DISTRIBUTED		/*  op[&]   */
#define   DISTR_LIN_EXCL_OR	EXCL_OR+DISTRIBUTED	/*  op[^]   */
#define   DISTR_LIN_INCL_OR	INCL_OR+DISTRIBUTED	/*  op[|]   */
#define   DISTR_LIN_LOG_AND	LOG_AND+DISTRIBUTED	/*  op[&&]  */
#define   DISTR_LIN_LOG_OR	LOG_OR+DISTRIBUTED	/*  op[||]  */

#define   DISTR_ASS_CALL	DISTR_LIN_LOG_OR+1	/* de[>fp<] */
#define   DISTR_COMM_CALL	DISTR_ASS_CALL+1	/* de[<fp>] */

# endif
