#ifndef _DIAGNOSTIC

#define _DIAGNOSTIC

/* Error diagnostic and message generation functions for mpc-compiler: */
/* ==================================================================  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*            =============== Initial revision, 1995/09/04 ==========  */

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

#include "context.h"
#include "Errors.h"
#include "Tree.h"

extern bool IgnoreAll;    /* Set to TRUE when syntax error detected and  *
			   * error repair is done; restore to FALSE when *
			   * starting to parse new item of constr. list. */

void Make_ErrorMessage	ARGS((int ErrorCode, int ErrorClass, tPosition Position));
void Make_ErrorMessageI	ARGS((int ErrorCode, int ErrorClass, tPosition Position, int InfoClass, tString Info));
void Make_Message	ARGS((short ErrorNumber, int ErrorClass, tPosition Position, tTree Tree));
void Make_MessageI	ARGS((short ErrorNumber, int ErrorClass, tPosition Position, int InfoClass, tString Info, tTree Tree));
void CompilerError	ARGS((tString ErrorText, tPosition Position));

void Sort_Messages	();
void Print_Message	ARGS((tTree Mess));
void Print_Messages	();
int  Scan_Messages	();
tPosition SourcePosition  ARGS((tPosition Pos, tTree Tree));


#define		WNG_OFF		0
#define		WNG_ALL		1
#define		WNG_SOME	2

extern int WngMode;
typedef struct {
  unsigned	Decl:1,
		Scope:1,
		Sizes:1,
		Init:1,
		Distr:1,
		Stats:1,
		Label:1,
		Args:1;
} WngKinds;
extern WngKinds NoWngs, ActualWng;

#define		DECL_Warning(args)   {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Decl)Make_Message args;}
#define		SCOPE_Warning(args)  {if(WngMode==WNG_ALL||ActualWng.Scope)Make_Message args;}
#define		SIZE_Warning(args)   {if(WngMode==WNG_ALL||ActualWng.Sizes)Make_Message args;}
#define		INIT_Warning(args)   {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Init)Make_Message args;}
#define		DISTR_Warning(args)  {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Distr)Make_Message args;}
#define		STATS_Warning(args)  {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Stats)Make_Message args;}
#define		LABEL_Warning(args)  {if(WngMode==WNG_ALL||ActualWng.Label)Make_Message args;}
#define		ARGS_Warning(args)   {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Args)Make_Message args;}
#define		SPEC_Warning(args)   {if(WngMode==WNG_ALL||WngMode==WNG_SOME)Make_Message args;}

#define		DECL_WarningI(args)  {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Decl)Make_MessageI args;}
#define		SCOPE_WarningI(args) {if(WngMode==WNG_ALL||ActualWng.Scope)Make_MessageI args;}
#define		SIZE_WarningI(args)  {if(WngMode==WNG_ALL||ActualWng.Sizes)Make_MessageI args;}
#define		INIT_WarningI(args)  {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Init)Make_MessageI args;}
#define		DISTR_WarningI(args) {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Distr)Make_MessageI args;}
#define		STATS_WarningI(args) {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Stats)Make_MessageI args;}
#define		LABEL_WarningI(args) {if(WngMode==WNG_ALL||ActualWng.Label)Make_MessageI args;}
#define		ARGS_WarningI(args) {if(WngMode==WNG_ALL/**||WngMode==WNG_SOME**/||\
ActualWng.Args)Make_MessageI args;}
#define		SPEC_WarningI(args)  {if(WngMode==WNG_ALL||WngMode==WNG_SOME)Make_MessageI args;}


void New_SourceFile	ARGS((tString FileName,tPosition VirtPos,tPosition RealPos));
tPosition RealPosition	ARGS((tPosition VirtPos));
tString SourceFile	ARGS((tPosition VirtPos));
tPosition VirtPosition	ARGS((tString FileName,tPosition RealPos));

#endif
