
/* mpC-compiler, pass 1:              "SEMANTICS"                 */
/* ====================                =========                  */
/*                                                                */
/*            1.Error diagnostics (for all pass of compiler);     */
/*            2.Type structure analyse and AST generation;        */
/*            3.AST generation (without attribute computation);   */
/*                                                                */
/* Copyright (c) 1995,1996,1997 Institute for System Programming, */
/*                              Russian Academy of Sciences.      */
/*       =============== Initial revision, 1995/09/.. ==========  */


#include "context.h"
#include "Tree.h"
#include "mpc_diag.h"
#include "options.h"
#include "mpc_pass1.h"
#include "mpc_pass2.h"
#include "mpcAttr.h"

#include "mpC_Porting.h"

   /* include files from cocktail'Reuse: */

#include "Errors.h"
#include "DynArray.h"

#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif



/********************************************************/
/****************** DATA DEFINITIONS: *******************/
/********************************************************/

tPosition CurrentPosition;
		/* for diagnostic of  compiler errors   *
		 * ( set in parser  for pass 1 and in   *
		 * attribute evaluator for pass 2 );    */

#ifndef MAX_BIT_FIELD
#define MAX_BIT_FIELD 32
#endif

tQual NoQual = {false, false, false}; /* for decl.specifier parsing; */

	/* empty flags for SOURCE (.Source = YES) constructions: */

tDeclFlags NoDeclFlag = {NO, NO,NO,NO,NO,NO,NO,NO,NO,NO,YES,NO,0};

tTypeFlags NoTypeFlag = {NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NATIVE_MPC,NO,YES,NO
#ifndef __WRK
  , 0
#endif
};

tStatFlags NoStatFlag = {NO,NO,NO,NO,NO,NO,NO,NO,YES,NO,0};

tExprFlags NoExprFlag = {NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,NO,YES,NO
#ifdef __WRK
  , 0
#endif
};

int NativeMode;		/* for MPC_FunctionType.Flag.Native, may be mpC, C[], C ; */

#ifdef __WRK
  static word32 native_mask = 0xffff0fff;  /* MUST be changed if flag(s) added or removed... */
#else  /* for optimized memory allocation: */
  static word32 native_mask = 0xfff3ffff;  /* MUST be changed if flag(s) added or removed... */
#endif


	/* temporary table of types: */

unsigned long	TypeStack_Size = 32,	/* initial size */
		TypeTable_Size = 1024,	/* -----//----- */
		ScopeStack_Size = 1024;	/* -----//----- */

tTree  *TypeStack, *TypeTable;

long	TypeStack_Top,
	TypeTable_Top;

static bool Remove_SUE_Typedef = false;


	/* pointers to MPC_BasicType for constant expression: */

tTree	VoidType,
	CharType,
	IntType,
	ConstIntType,
	ReplIntType,
	ReplConstIntType,
	UnsignedType,
	LongType,
	UnsignedLongType,
	FloatType,
	DoubleType,
        ReplConstDoubleType,
	LongDoubleType,		/* -- rapidly used basic types;                       */

	LongLongType,		/* -- extension: 'long long int' type;                */
	UnsignedLongLongType,	/* -- extension: 'unsigned long long int' type;       */

	ErrorType;		/* -- "basic type" for recovery after SEMANT. errors; */

tTree Default_FunctionType,	/* type of implicitly declared function; */
      Barrier_FunctionType;	/* type of [*]MPC_Global_barrier(void);  */

tTree	ErrorNet, ErrorNetList;	/* -- for recovery of mpcAttr() after SEMANT. errors; */


	/* scope stack - temporary table of identifiers: */

typedef struct {
	  tIdent Ident;
	  int NameSpace; /* or Scope_UniqueNumber when Ident==NoIdent; */
	  tTree Decl;
} tScopeStack_Element;

tScopeStack_Element *ScopeStack;

int ScopeStack_Top;

static bool ExprScope_Opened = false,
	    ExprScope_Closed = false;  /* Special 'Scope' only for dyn.types */

static
int Scope_UniqueNumber=0,  /* used for dynamic array types (MPC_Type.UniqueNumber); 0 - global scope; */
    PrevScope_Top;	   /* used by Restore_ExprScope()  after (expression); */
static tTree FreeNode;

	/* Table of subnetworks -- work table of parser: */

unsigned long	SubnetTable_Size = 64;	/* initial size */

tTree  *SubnetTable;

int	SubnetTable_Top;


/*** Declarations of work functions: ***/

int   Size_Of          ARGS((int Type));
static
bool  Operand_IsIdent  ARGS((tTree Operand));


/********************************************************/
/**************** FUNCTION DEFINITIONS: *****************/
/********************************************************/

#include "mpc_diag.c"

/****************/   /*********************************************************/
tTree Copy_mpcList   /* currently - only lists of  MPC_VarDecl & MPC_Var !!!! */
/****************/   /*********************************************************/
#if defined __STDC__ | defined __cplusplus
	(tTree tree)
#else
	(tree)
	tTree tree;
#endif
{
  tTree item, tmp;

  if(tree==NoTree || tree->Kind==kMPC_FreeNode) return tree;

  item = nMPC_FreeNode();
  while(tree->Kind!=kMPC_FreeNode) {
    tmp = MakeTree(tree->Kind);
    *tmp = *tree;
    switch(tree->Kind) {
      case kMPC_VarDecl:
	tmp->MPC_VarDecl.Next = tmp->MPC_VarDecl.Prev = item;
	tmp->MPC_VarDecl.Var = Copy_mpcList(tree->MPC_VarDecl.Var);
	tmp->MPC_VarDecl.EndPos = tree->MPC_VarDecl.EndPos;  /*K*/
	tmp->MPC_VarDecl.Var->MPC_Var.EndPos =   /*K*/
		tree->MPC_VarDecl.Var->MPC_Var.EndPos;  /*K*/
	tmp->MPC_VarDecl.Pos = tree->MPC_VarDecl.Pos;  /*K*/
	tmp->MPC_VarDecl.Var->MPC_Var.Pos =   /*K*/
		tree->MPC_VarDecl.Var->MPC_Var.Pos;  /*K*/
	if(tmp->MPC_VarDecl.Var!=NoTree && tmp->MPC_VarDecl.Var->Kind==kMPC_Var)
	  tmp->MPC_VarDecl.Var->MPC_Var.Prev->MPC_FreeNode.Parent = tmp;
	else /* tmp->MPC_VarDecl.Var->Kind==kMPC_FreeNode: */
	  tmp->MPC_VarDecl.Var->MPC_FreeNode.Parent = tmp;
	tree = tree->MPC_VarDecl.Next;
	break;
      case kMPC_Var:
	tmp->MPC_Var.Next = tmp->MPC_Var.Prev = item;
	tmp->MPC_Var.Init = Copy_mpcList(tree->MPC_Var.Init);
	tmp->MPC_Var.EndPos = tree->MPC_Var.EndPos;  /*K*/
	tmp->MPC_Var.Pos = tree->MPC_Var.Pos;  /*K*/
	tree = tree->MPC_Var.Next;
	break;
      case kMPC_Ellipsis:
	tmp->MPC_Ellipsis.Next = tmp->MPC_Ellipsis.Prev = item;
	tmp->MPC_Ellipsis.EndPos = tree->MPC_Ellipsis.EndPos;  /*K*/
	tmp->MPC_Ellipsis.Pos = tree->MPC_Ellipsis.Pos;  /*K*/
	tree = tree->MPC_Ellipsis.Next;
	break;
      default:
	CompilerError("Unexpected node in source list", tree->MPC_Decls.Pos);
	return tree;
    }
    item = tmp;
  }

  return ReverseTree(item);
}

/***************/
int BasicTypeName
/***************/
#if defined __STDC__ | defined __cplusplus
	(int TypeSpec, int TypeName)
#else
	(TypeSpec,TypeName)
	int TypeSpec;
	int TypeName;
#endif
{
  switch(TypeName) {
    case CHAR:
	if(TypeSpec==SIGNED) return SIGNED_CHAR;
	if(TypeSpec==UNSIGNED) return UNSIGNED_CHAR;
	break;
    case SHORT:
	if(TypeSpec==INT) return SIGNED_SHORT_INT;
	if(TypeSpec==SIGNED) return SIGNED_SHORT;
	if(TypeSpec==UNSIGNED) return UNSIGNED_SHORT;
	break;
    case INT:
	switch(TypeSpec) {
	  case SIGNED: return SIGNED_INT;
	  case UNSIGNED: return UNSIGNED_INT;
	  case SHORT:
	  case SIGNED_SHORT: return SIGNED_SHORT_INT;
	  case UNSIGNED_SHORT: return UNSIGNED_SHORT_INT;
	  case LONG:
	  case SIGNED_LONG: return SIGNED_LONG_INT;
	  case UNSIGNED_LONG: return UNSIGNED_LONG_INT;
	  case LONG_LONG:
	  case SIGNED_LONG_LONG: return SIGNED_LONG_LONG_INT;
	  case UNSIGNED_LONG_LONG: return UNSIGNED_LONG_LONG_INT;
	  default: break;
	}
	break;
    case LONG:
	if(TypeSpec==INT) return SIGNED_LONG_INT;
	if(TypeSpec==SIGNED) return SIGNED_LONG;
	if(TypeSpec==UNSIGNED) return UNSIGNED_LONG;
	if(TypeSpec==DOUBLE) return LONG_DOUBLE;
	if(TypeSpec==LONG) return LONG_LONG;
	if(TypeSpec==SIGNED_LONG) return SIGNED_LONG_LONG;
	if(TypeSpec==UNSIGNED_LONG) return UNSIGNED_LONG_LONG;
	break;
    case LONG_LONG:
	if(TypeSpec==INT) return SIGNED_LONG_LONG_INT;
	if(TypeSpec==SIGNED) return SIGNED_LONG_LONG;
	if(TypeSpec==UNSIGNED) return UNSIGNED_LONG_LONG;
     /**if(TypeSpec==DOUBLE) return LONG_DOUBLE;**/
	break;
    case SIGNED:
	switch(TypeSpec) {
	  case CHAR: return SIGNED_CHAR;
	  case SHORT: return SIGNED_SHORT;
	  case INT: return SIGNED_INT;
	  case LONG: return SIGNED_LONG;
	  case LONG_LONG: return SIGNED_LONG_LONG;
	  case SIGNED_SHORT_INT: return SIGNED_SHORT_INT;
	  case SIGNED_LONG_INT: return SIGNED_LONG_INT;
	  case SIGNED_LONG_LONG_INT: return SIGNED_LONG_LONG_INT;
	  default: break;
	}
    case UNSIGNED:
	switch(TypeSpec) {
	  case CHAR: return UNSIGNED_CHAR;
	  case SHORT: return UNSIGNED_SHORT;
	  case INT: return UNSIGNED_INT;
	  case LONG: return UNSIGNED_LONG;
	  case LONG_LONG: return UNSIGNED_LONG_LONG;
	  case SIGNED_SHORT_INT: return UNSIGNED_SHORT_INT; /*SIGNED_SHORT_INT==SHORT_INT!!!*/
	  case SIGNED_LONG_INT: return UNSIGNED_LONG_INT;   /*SIGNED_LONG_INT==LONG_INT!!!*/
	  case SIGNED_LONG_LONG_INT: return UNSIGNED_LONG_LONG_INT;
							    /*SIGNED_LONG_INT==LONG_INT!!!*/
	  default: break;
	}
    case DOUBLE:
	if(TypeSpec==LONG) return LONG_DOUBLE;
	break;
    default: break;
  } /* end switch */
  return NO_TYPE;  /* Error: Invalid basic type/declaration specifier */
}

/**********************/
int BasicTypeConstructor
/**********************/
#if defined __STDC__ | defined __cplusplus
	(int TypeName)
#else
	(TypeName)
	int TypeName;
#endif
{
  switch(TypeName) {
    case SIGNED_SHORT:
    case SIGNED_SHORT_INT:
	return SHORT;
    case UNSIGNED_SHORT_INT:
	return UNSIGNED_SHORT;
    case SIGNED:
    case SIGNED_INT:
	return INT;
    case UNSIGNED_INT:
	return UNSIGNED;
    case SIGNED_LONG:
    case SIGNED_LONG_INT:
	return LONG;
    case UNSIGNED_LONG_INT:
	return UNSIGNED_LONG;
    case SIGNED_LONG_LONG:
    case SIGNED_LONG_LONG_INT:
	return LONG_LONG;
    case UNSIGNED_LONG_LONG_INT:
	return UNSIGNED_LONG_LONG;
    default: break;  /* return any other TypeName "as is"; */
  } /* end switch */
  return TypeName;
}

/******************/
tQual JoinQualifiers
/******************/
#if defined __STDC__ | defined __cplusplus
	(tQual List, tQual Qual, bool *Ignore, tPosition Pos)
#else
	(List, Qual, Ignore, Pos)
	tQual List;
	tQual Qual;
	bool *Ignore;
	tPosition Pos;
#endif
{
  if(List.Const && Qual.Const ||
     List.Volatile && Qual.Volatile ||
     List.Repl && Qual.Repl) {
    *Ignore = true;
    Make_Message(400, xxError, Pos, NoTree);
	/* "Type qualifier duplicated" */
  }
  else {
    List.Const = List.Const || Qual.Const;
    List.Volatile = List.Volatile || Qual.Volatile;
    List.Repl = List.Repl || Qual.Repl;
  }
  return List;
}

/*******************/
void Init_TypeTable()
/*******************/
{
  MakeArray((char **)&TypeStack, &TypeStack_Size, sizeof(tTree));
  MakeArray((char **)&TypeTable, &TypeTable_Size, sizeof(tTree));
  TypeStack_Top = 0;
  TypeStack[0] = NoTree; /* bottom marker of flexible stack; */
  TypeTable_Top = -1;
  Remove_SUE_Typedef = false;
}

/***************/
void Push_Pattern
/***************/
#if defined __STDC__ | defined __cplusplus
	(register tTree Pattern)
#else
	(Pattern)
	register tTree Pattern;
#endif
{
  if(!Pattern) return; /* Maybe incorrect error repair, => invalid reduce; */
  Clean_OutAttributes(Pattern);  /* clean garbage; */

  if(!(Pattern->Kind==kMPC_Typedef || Pattern->Kind==kMPC_StructType ||
       Pattern->Kind==kMPC_UnionType || Pattern->Kind==kMPC_EnumType))
    Pattern->MPC_Type.Pos = NoPosition;  /* Only in initial revision of front-end, *
					  * for correct work of Make_Type();       */

  if(!Pattern->MPC_Type.ScopeNumber) /* set this attribute to current scope number: */
    Pattern->MPC_Type.ScopeNumber = Scope_UniqueNumber;

  TypeStack_Top++;
  if(TypeStack_Top==TypeStack_Size)
    ExtendArray((char **)&TypeStack, &TypeStack_Size, sizeof(tTree));
  TypeStack[TypeStack_Top] = Pattern;
}

/********************/
bool Typedef_Dependent
/********************/
#if defined __STDC__ | defined __cplusplus
	(register tTree Pattern)
#else
	(Pattern)
	register tTree Pattern;
#endif
{
  if(Pattern->Kind==kMPC_Typedef) return true;
  if(Pattern->Kind==kMPC_ArrayType)
    return Typedef_Dependent(Pattern->MPC_ArrayType.ElementType);
  if(Pattern->Kind==kMPC_VectorType)
    return Typedef_Dependent(Pattern->MPC_VectorType.ElementType);
  if(Pattern->Kind==kMPC_PointerType)
    return Typedef_Dependent(Pattern->MPC_PointerType.ElementType);
  return false;
}

/********************/
bool Pointer_Dependent
/********************/
#if defined __STDC__ | defined __cplusplus
	(register tTree Pattern)
#else
	(Pattern)
	register tTree Pattern;
#endif
{

  switch(Pattern->Kind) {
    case kMPC_PointerType: return true;
    case kMPC_Typedef:
	return Pointer_Dependent(Pattern->MPC_Typedef.Type);
    case kMPC_ArrayType:
	return Pointer_Dependent(Pattern->MPC_ArrayType.ElementType);
    case kMPC_VectorType:
    	return Pointer_Dependent(Pattern->MPC_VectorType.ElementType);
    case kMPC_StructType:
    case kMPC_UnionType:
	{
    	  tTree member_decl, member;
    	  member_decl = Pattern->MPC_StructType.MemberDecls;
    	  while(member_decl!=NoTree && member_decl->Kind==kMPC_SU_MemberDecl) {
      	    member = member_decl->MPC_SU_MemberDecl.Member;
     	    while(member!=NoTree && member->Kind==kMPC_SU_Member) {
	      if(Pointer_Dependent(member->MPC_SU_Member.Type)) return true;
              member = member->MPC_SU_Member.Next;
            }
	    member_decl = member_decl->MPC_SU_MemberDecl.Next;
    	  }
  	}
    default:
	return false;
  }  /* end switch */

}

/*******************/
void Push_PurePattern
/*******************/
#if defined __STDC__ | defined __cplusplus
	(register tTree Pattern)
#else
	(Pattern)
	register tTree Pattern;
#endif
{
  if(!Pattern) return; /* Maybe incorrect error repair, => invalid reduce; */

  /* NOTE: OUT attributes must not be cleaned because they may contain info and   *
   *       'Pattern' is previously cleaned when  Push_Pattern() was called;       *
   *       Pattern->MPC_Type.ScopeNumber is also already set by Push_Pattern().   */


  if(Pattern->Kind==kMPC_Typedef &&
     /**!Pattern->MPC_Typedef.Flag.DynArray *** dyn-array-typedefs must be saved?  &&**/
     Pattern->MPC_Typedef.Type->Kind!=kMPC_EnumType &&
     Pattern->MPC_Typedef.Type->Kind!=kMPC_StructType &&
     Pattern->MPC_Typedef.Type->Kind!=kMPC_UnionType &&
     !(Pattern->MPC_Typedef.Type->Kind==kMPC_PointerType &&
       (Pattern->MPC_Typedef.Type->MPC_PointerType.ElementType->Kind==kMPC_StructType ||
	Pattern->MPC_Typedef.Type->MPC_PointerType.ElementType->Kind==kMPC_UnionType ||
	Pattern->MPC_Typedef.Type->MPC_PointerType.ElementType->Kind==kMPC_EnumType)
      ))  /*** FUNCTION ???? ***/
    Push_PurePattern(Pattern->MPC_Typedef.Type);
  else if(Pattern->Kind==kMPC_Typedef && Remove_SUE_Typedef)  /* remove ALL MPC_Typedef:  */
    Push_PurePattern(Pattern->MPC_Typedef.Type);
  else {
    tTree NewPattern;
    TypeStack_Top++;
    if(TypeStack_Top==TypeStack_Size)
      ExtendArray((char **)&TypeStack, &TypeStack_Size, sizeof(tTree));
    if(Pattern->Kind==kMPC_ArrayType &&
       Typedef_Dependent(Pattern->MPC_ArrayType.ElementType)) {
      TypeStack[TypeStack_Top] = NewPattern = MakeTree(kMPC_ArrayType);
      *NewPattern = *Pattern;
    }
    else if(Pattern->Kind==kMPC_VectorType &&
       Typedef_Dependent(Pattern->MPC_VectorType.ElementType)) {
      TypeStack[TypeStack_Top] = NewPattern = MakeTree(kMPC_VectorType);
      *NewPattern = *Pattern;
    }
    else if(Pattern->Kind==kMPC_PointerType &&
       Typedef_Dependent(Pattern->MPC_PointerType.ElementType)) {
      TypeStack[TypeStack_Top] = NewPattern = MakeTree(kMPC_PointerType);
      *NewPattern = *Pattern;
    }
    else if(Pattern->Kind==kMPC_FunctionType &&
       Typedef_Dependent(Pattern->MPC_FunctionType.ResultType)) {
      TypeStack[TypeStack_Top] = NewPattern = MakeTree(kMPC_FunctionType);
      *NewPattern = *Pattern;
    }
    else if(Pattern->Kind==kMPC_EnumType) {
      TypeStack[TypeStack_Top] = IntType;
    }
    else
      TypeStack[TypeStack_Top] = Pattern;
    if(Pattern->Kind==kMPC_PointerType)  Push_PurePattern(Pattern->MPC_PointerType.ElementType);
    if(Pattern->Kind==kMPC_ArrayType)	 Push_PurePattern(Pattern->MPC_ArrayType.ElementType);
    if(Pattern->Kind==kMPC_VectorType)	 Push_PurePattern(Pattern->MPC_VectorType.ElementType);
    if(Pattern->Kind==kMPC_FunctionType) Push_PurePattern(Pattern->MPC_FunctionType.ResultType);
  }
}

/***********************/
void Enable_SUE_Typedef()
/***********************/
{
  Remove_SUE_Typedef = false;
}

/************************/
void Disable_SUE_Typedef()
/************************/
{
  Remove_SUE_Typedef = true;
}

/******************/
void NestedType_ON()
/******************/
{
  TypeStack_Top++;
  if(TypeStack_Top==TypeStack_Size)
    ExtendArray((char **)&TypeStack, &TypeStack_Size, sizeof(tTree));
  TypeStack[TypeStack_Top] = NoTree;
}

/*******************/
void NestedType_OFF()
/*******************/
{
  if(TypeStack_Top && TypeStack[TypeStack_Top]==NoTree)
    TypeStack_Top--;
  else {
    printf("--- TypeStack_Top=%d\n",TypeStack_Top);
    CompilerError("Wrong state of TypeStack",CurrentPosition);
  }
}

/*************/
tTree TopType()
/*************/
{
  return TypeStack[TypeStack_Top];
}

/***********************/
tTree Find_FunctionType()
/***********************/
{
  int i=TypeStack_Top;
  tTree func = NoTree;
  while(TypeStack[i]) {
    if(TypeStack[i]->Kind==kMPC_FunctionType) func = TypeStack[i];
    i--;
  }
  return func;
}

/********************/
void Clean_TypeStack()
/********************/
{
  while(TypeStack[TypeStack_Top]) TypeStack_Top--;
}

/***************/
tTree Make_Type()
/***************/
{
  tTree type=NoTree;


  while(TypeStack[TypeStack_Top]) {
    /* move type structure to TypeTable: */
    if(!(type = Find_Type(TypeStack[TypeStack_Top]))) {
      TypeTable_Top++;
      if(TypeTable_Top==TypeTable_Size)
	ExtendArray((char**)&TypeTable, &TypeTable_Size, sizeof(tTree));
      type = TypeTable[TypeTable_Top] = TypeStack[TypeStack_Top];
    }
    if(type->Kind==kMPC_PointerType && type->MPC_PointerType.DynStep==NoTree)
      type->MPC_PointerType.DynStep = nMPC_FreeNode();
    TypeStack_Top--;
    if(TypeStack[TypeStack_Top])
      switch(TypeStack[TypeStack_Top]->Kind) {
	case kMPC_ArrayType:
	  TypeStack[TypeStack_Top]->MPC_ArrayType.ElementType = type;
	  break;
	case kMPC_VectorType:
	  TypeStack[TypeStack_Top]->MPC_VectorType.ElementType = type;
	  break;
	case kMPC_PointerType:
	  TypeStack[TypeStack_Top]->MPC_PointerType.ElementType = type;
	  break;
	case kMPC_FunctionType:
	  TypeStack[TypeStack_Top]->MPC_FunctionType.ResultType = type;
	  break;
	default:
	  CompilerError("Invalid type structure in TypeStack", CurrentPosition);
      } /* end switch */
  } /* end while */
  return type;
}

/*****************/
bool EqualTypeFlags
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTypeFlags yyf1, tTypeFlags yyf2)
#else
	(yyf1,yyf2)
	tTypeFlags yyf1, yyf2;
#endif
{
    register word32 *yyp1, *yyp2;

    yyp1 = (word32 *) &yyf1;
    yyp2 = (word32 *) &yyf2;

# ifdef __WRK

    if(*yyp1 == *yyp2 &&
       (*(++yyp1) & native_mask) == (*(++yyp2) & native_mask) )
      return true;

# else  /* optimized memory allocation: */

    if((*yyp1 & native_mask) == (*yyp2 & native_mask) )
      return true;    

# endif
    else 
      return false;
}

/*****************/
bool EqualDeclFlags
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tDeclFlags yyf1, tDeclFlags yyf2)
#else
	(yyf1,yyf2)
	tDeclFlags yyf1, yyf2;
#endif
{
  if( yyf1.Auto != yyf2.Auto )			  return false;
  if( yyf1.Static != yyf2.Static )		  return false;
  if( yyf1.Register != yyf2.Register )		  return false;
  if( yyf1.Parameter != yyf2.Parameter )	  return false;
  if( yyf1.Extern != yyf2.Extern )		  return false;
  if( yyf1.Exported != yyf2.Exported )		  return false;
  if( yyf1.Distributed != yyf2.Distributed )	  return false;
  if( yyf1.FC_Generated != yyf2.FC_Generated )	  return false;
  if( yyf1.DistrLabel != yyf2.DistrLabel )	  return false;		/*** ??? ***/
  if( yyf1.Source != yyf2.Source )		  return false;		/*** ? ***/
  if( yyf1.Ignore != yyf2.Ignore )		  return false;		/*** ? ***/
  return true;
}

/************************/
bool IsCommutativeOperator
/************************/
#if defined __STDC__ | defined __cplusplus
	(register int op)
#else
	(op)
	register int op;
#endif
{
  switch(op) {
    case INDEX:
    case MULT:
    case MAX:
    case MIN:
    case PLUS:
    case EQUAL:
    case NOT_EQUAL:
    case AND:
    case EXCL_OR:
    case INCL_OR:
    case LOG_AND:
    case LOG_OR:
      return true;
    default: break;
  }
  return false;
}

/**************/
bool IsEqualExpr
/**************/
#if defined __STDC__ | defined __cplusplus
	(register tTree yyt1, register tTree yyt2)
#else
	(yyt1,yyt2)
	register tTree yyt1, yyt2;
#endif
{
  bool IsEqualType();

  if (yyt1 == yyt2) return true;
  if (yyt1 == NoTree || yyt2 == NoTree || yyt1->Kind != yyt2->Kind) return false;

  switch(yyt1->Kind) {
    case kMPC_FreeNode:
	return true;
    case kMPC_IntConst:
	return yyt1->MPC_IntConst.Value==yyt2->MPC_IntConst.Value;
    case kMPC_UIntConst:
	return yyt1->MPC_UIntConst.Value==yyt2->MPC_UIntConst.Value;
    case kMPC_Ident:
	return yyt1->MPC_Ident.Store==yyt2->MPC_Ident.Store;   /** !!! **/
    case kMPC_CastExpr:
	return IsEqualType(yyt1->MPC_CastExpr.TypeName, yyt2->MPC_CastExpr.TypeName) &&
	       IsEqualExpr(yyt1->MPC_CastExpr.Operand, yyt2->MPC_CastExpr.Operand);
    case kMPC_NetCastExpr:
	return yyt1->MPC_Expr.StoreNet==yyt2->MPC_Expr.StoreNet &&
	       IsEqualExpr(yyt1->MPC_NetCastExpr.Operand, yyt2->MPC_NetCastExpr.Operand);
    case kMPC_Size_Of_Value:
	if(yyt1->MPC_SizeofExpr.CompileTime && yyt2->MPC_SizeofExpr.CompileTime &&
	   yyt1->MPC_SizeofExpr.Value==yyt2->MPC_SizeofExpr.Value)
	  return true;
	return IsEqualExpr(yyt1->MPC_Size_Of_Value.Operand, yyt2->MPC_Size_Of_Value.Operand);
    case kMPC_Size_Of_Type:
	if(yyt1->MPC_SizeofExpr.CompileTime && yyt2->MPC_SizeofExpr.CompileTime &&
	   yyt1->MPC_SizeofExpr.Value==yyt2->MPC_SizeofExpr.Value)
	  return true;
	return IsEqualType(yyt1->MPC_Size_Of_Type.Operand, yyt2->MPC_Size_Of_Type.Operand);
    case kMPC_UnaryExpr:
	return  yyt1->MPC_UnaryExpr.OpCode==yyt2->MPC_UnaryExpr.OpCode &&
		IsEqualExpr(yyt1->MPC_UnaryExpr.Operand, yyt2->MPC_UnaryExpr.Operand);
    case kMPC_BinaryExpr:
	return  yyt1->MPC_BinaryExpr.OpCode==yyt2->MPC_BinaryExpr.OpCode &&
		( IsEqualExpr(yyt1->MPC_BinaryExpr.Loperand, yyt2->MPC_BinaryExpr.Loperand) &&
		    IsEqualExpr(yyt1->MPC_BinaryExpr.Roperand, yyt2->MPC_BinaryExpr.Roperand)  ||
		  IsCommutativeOperator(yyt1->MPC_BinaryExpr.OpCode) &&
		    IsEqualExpr(yyt1->MPC_BinaryExpr.Loperand, yyt2->MPC_BinaryExpr.Roperand) &&
		    IsEqualExpr(yyt1->MPC_BinaryExpr.Roperand, yyt2->MPC_BinaryExpr.Loperand)
		);
    case kMPC_TernaryExpr:
	return  yyt1->MPC_TernaryExpr.OpCode==yyt2->MPC_TernaryExpr.OpCode &&
		IsEqualExpr(yyt1->MPC_TernaryExpr.Foperand, yyt2->MPC_TernaryExpr.Foperand) &&
		IsEqualExpr(yyt1->MPC_TernaryExpr.Soperand, yyt2->MPC_TernaryExpr.Soperand) &&
		IsEqualExpr(yyt1->MPC_TernaryExpr.Toperand, yyt2->MPC_TernaryExpr.Toperand);
    default:
      CompilerError("Invalid or unimplemented expression in size of dynamic array",yyt1->MPC_Expr.Pos);
  }

  return false;
}

/******************/
bool IsEqualDynArray
/******************/
#if defined __STDC__ | defined __cplusplus
	(register tTree yyt1, register tTree yyt2)
#else
	(yyt1,yyt2)
	register tTree yyt1, yyt2;
#endif
{
  if (yyt1 == yyt2) return true;
  if (yyt1 == NoTree || yyt2 == NoTree || yyt1->Kind != yyt2->Kind) return false;
  if (yyt1->MPC_DerivedType.NumberOfComponents!=0 ||
      yyt2->MPC_DerivedType.NumberOfComponents!=0) return false;
  if(yyt1->MPC_Type.ScopeNumber!=yyt2->MPC_Type.ScopeNumber) return false;

  if(yyt1->Kind==kMPC_VectorType)
    if(IsEqualExpr(yyt1->MPC_VectorType.VectorSize, yyt2->MPC_VectorType.VectorSize)) return true;
  else
    return false;

  if(!IsEqualExpr(yyt1->MPC_ArrayType.ArraySize, yyt2->MPC_ArrayType.ArraySize)) return false;
  if(!IsEqualExpr(yyt1->MPC_ArrayType.DynStep, yyt2->MPC_ArrayType.DynStep)) return false;

  return true;
}

/**************/
bool IsEqualType
/**************/
#if defined __STDC__ | defined __cplusplus
	(register tTree yyt1, register tTree yyt2)
#else
	(yyt1,yyt2)
	register tTree yyt1, yyt2;
#endif
{
  if (yyt1 == yyt2) return true;
  if (yyt1 == NoTree || yyt2 == NoTree || yyt1->Kind != yyt2->Kind) return false;
  switch (yyt1->Kind) {
    case kMPC_FreeNode:
	return true;
    case kMPC_BasicType:
	return  yyt1->MPC_BasicType.TypeConstructor==yyt2->MPC_BasicType.TypeConstructor &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) ;
    case kMPC_EnumType:
	return  yyt1->MPC_EnumType.EnumTag!=NoIdent && yyt2->MPC_EnumType.EnumTag!=NoIdent &&
		yyt1->MPC_EnumType.EnumTag==yyt2->MPC_EnumType.EnumTag &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) ;
    case kMPC_Typedef:
	return  yyt1->MPC_Typedef.TypedefName==yyt2->MPC_Typedef.TypedefName &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) &&
		IsEqualType(yyt1->MPC_Typedef.Type,yyt2->MPC_Typedef.Type) /***&&
		IsEqualType(yyt1->MPC_Type.Next,yyt2->MPC_Type.Next)***/ ;
    case kMPC_ArrayType:
	return  (yyt1->MPC_DerivedType.NumberOfComponents &&   /* if 0 - dyn. topo parameter; */
		 yyt2->MPC_DerivedType.NumberOfComponents &&   /* -------------"------------- */
		 yyt1->MPC_DerivedType.NumberOfComponents==
			yyt2->MPC_DerivedType.NumberOfComponents &&
		 yyt1->MPC_ArrayType.Step==yyt2->MPC_ArrayType.Step  ||
		 IsEqualDynArray(yyt1, yyt2) ) &&
		yyt1->MPC_ArrayType.ElementType==yyt2->MPC_ArrayType.ElementType &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) ;
    case kMPC_VectorType:
	return	(yyt1->MPC_DerivedType.NumberOfComponents &&
		 yyt2->MPC_DerivedType.NumberOfComponents &&
		 yyt1->MPC_DerivedType.NumberOfComponents==
			yyt2->MPC_DerivedType.NumberOfComponents ||
		 IsEqualDynArray(yyt1, yyt2) ) && 
		yyt1->MPC_VectorType.ElementType==yyt2->MPC_VectorType.ElementType &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) ;
    case kMPC_PointerType:
	return	/**yyt1->MPC_DerivedType.NumberOfComponents==
			yyt2->MPC_DerivedType.NumberOfComponents &&**/
		yyt1->MPC_PointerType.Step==yyt2->MPC_PointerType.Step &&
		yyt1->MPC_PointerType.ElementType==yyt2->MPC_PointerType.ElementType &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) ;
    case kMPC_StructType:	/****************/
    case kMPC_UnionType:	/****************/
	return	yyt1->MPC_DerivedType.NumberOfComponents==
			yyt2->MPC_DerivedType.NumberOfComponents &&
		yyt1->MPC_StructType.SU_Tag!=NoIdent && yyt2->MPC_StructType.SU_Tag!=NoIdent &&
		yyt1->MPC_StructType.SU_Tag==yyt2->MPC_StructType.SU_Tag &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) &&
		IsEqualType(yyt1->MPC_StructType.MemberDecls,yyt2->MPC_StructType.MemberDecls) ;
    case kMPC_FunctionType:
	return  yyt1->MPC_FunctionType.Kind==yyt2->MPC_FunctionType.Kind &&
		yyt1->MPC_DerivedType.NumberOfComponents==
			yyt2->MPC_DerivedType.NumberOfComponents &&
		EqualTypeFlags(yyt1->MPC_Type.Flag, yyt2->MPC_Type.Flag) &&
		IsEqualType(yyt1->MPC_FunctionType.ResultType,
				yyt2->MPC_FunctionType.ResultType) &&
	/***/	yyt1->MPC_FunctionType.NetParamType==yyt2->MPC_FunctionType.NetParamType &&
	/***/	yyt1->MPC_FunctionType.NetParam==yyt2->MPC_FunctionType.NetParam &&
		IsEqualType(yyt1->MPC_FunctionType.NetworkParamList, yyt2->MPC_FunctionType.NetworkParamList) &&
		IsEqualType(yyt1->MPC_FunctionType.ParamList, yyt2->MPC_FunctionType.ParamList) ;
    case kMPC_VarDecl:
	return  yyt1->MPC_VarDecl.Class==yyt2->MPC_VarDecl.Class &&
		EqualDeclFlags(yyt1->MPC_VarDecl.Flag, yyt2->MPC_VarDecl.Flag) &&
		IsEqualType(yyt1->MPC_VarDecl.DeclSpecifier,yyt2->MPC_VarDecl.DeclSpecifier) &&
		IsEqualType(yyt1->MPC_VarDecl.Var,yyt2->MPC_VarDecl.Var) &&
		IsEqualType(yyt1->MPC_VarDecl.Next,yyt2->MPC_VarDecl.Next) ;
    case kMPC_Var:
	return	yyt1->MPC_Var.Ident==yyt2->MPC_Var.Ident &&
		EqualDeclFlags(yyt1->MPC_Var.Flag, yyt2->MPC_Var.Flag) &&
		Compare(yyt1->MPC_Var.Pos, yyt2->MPC_Var.Pos)==0 && /** for func. definitions **/
		IsEqualType(yyt1->MPC_Var.Type,yyt2->MPC_Var.Type) &&
	/***/	yyt1->MPC_Var.Distribution==yyt2->MPC_Var.Distribution &&
		IsEqualType(yyt1->MPC_Var.Next,yyt2->MPC_Var.Next) ;
    case kMPC_Ellipsis:
		return true ;
    case kMPC_SU_MemberDecl:
	return	IsEqualType(yyt1->MPC_SU_MemberDecl.Member,yyt2->MPC_SU_MemberDecl.Member) &&
		IsEqualType(yyt1->MPC_SU_MemberDecl.Next,yyt2->MPC_SU_MemberDecl.Next) ;
    case kMPC_SU_Member:
	return	yyt1->MPC_SU_Member.Name==yyt2->MPC_SU_Member.Name &&
		yyt1->MPC_SU_Member.BitFieldLength==yyt2->MPC_SU_Member.BitFieldLength &&
		IsEqualType(yyt1->MPC_SU_Member.Type,yyt2->MPC_SU_Member.Type) &&
		IsEqualType(yyt1->MPC_SU_Member.Next,yyt2->MPC_SU_Member.Next) ;
    /***********
    case kMPC_:
	return ;
    case kMPC_:
	return ;
    ***********/
    default:
	CompilerError("IsEqualType: Invalid kind of tree node",NoPosition);
  }
  return false;
}

/**************/
tTree Find_Type
/**************/
#if defined __STDC__ | defined __cplusplus
	(register tTree TypePattern)
#else
	(TypePattern)
	register tTree TypePattern;
#endif
{
  int i;
  /********** SOMETIMES AN ERROR OCCURS IN FUNCTION IsEqualTree(), generated by AST,
              if one of arguments is type of topological function (usually, number());
              in this case the following check must be turned on:
  **********/
  if(TypePattern->Kind==kMPC_FunctionType &&
     !TypePattern->MPC_FunctionType.Flag.Source) /** types of topo-functions are unique; **/
    return NoTree;
  /**********/

  for(i=0; i<=TypeTable_Top; i++)
    if(IsEqualType(TypePattern, TypeTable[i])) /***** IsEqualTree *****/
      return TypeTable[i];

  return NoTree;
}

/******************/
bool Is_FunctionType	/**  Is typedef... pointer... to function ?  **/
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type)
#else
	(Type)
	tTree Type;
#endif
{
  switch(Type->Kind) {
    case kMPC_FunctionType:	return true;
    case kMPC_PointerType:	return Is_FunctionType(Type->MPC_PointerType.ElementType);
    case kMPC_ArrayType:	return Is_FunctionType(Type->MPC_ArrayType.ElementType);
    case kMPC_VectorType:	return Is_FunctionType(Type->MPC_VectorType.ElementType);
    case kMPC_Typedef:		return Is_FunctionType(Type->MPC_Typedef.Type);
    default:			return false;
  }
}

/*******************/
void Set_FunctionKind
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, int Kind)
#else
	(Type, Kind)
	tTree TypePattern;
	int Kind;
#endif
{
  if(Type->Kind==kMPC_FunctionType)
    Type->MPC_FunctionType.Kind = Kind;

  if(Kind==BASIC)
    Type->MPC_Type.Flag.Basic = YES;
  else if(Kind==NODAL)
    Type->MPC_Type.Flag.Nodal = YES;
  else if(Kind==NETWORK)
    Type->MPC_Type.Flag.Network = YES;

  switch(Type->Kind) {
    case kMPC_Typedef:		Set_FunctionKind(Type->MPC_Typedef.Type, Kind);
				break;
    case kMPC_PointerType:	Set_FunctionKind(Type->MPC_PointerType.ElementType, Kind);
				break;
    case kMPC_ArrayType:	Set_FunctionKind(Type->MPC_ArrayType.ElementType, Kind);
				break;
    case kMPC_VectorType:	Set_FunctionKind(Type->MPC_VectorType.ElementType, Kind);
				break;
  }
}

/***************/
tTree Find_Member
/***************/
#if defined __STDC__ | defined __cplusplus
	(tIdent Ident, tTree Member)
#else
	(Ident, Member)
	tIdent Ident;
	tTree Member;
#endif
{
  tTree result;
  if(Member==NoTree) return NoTree;
  switch(Member->Kind) {
    case kMPC_SU_MemberDecl:
	if(result=Find_Member(Ident, Member->MPC_SU_MemberDecl.Member)) return result;
	return Find_Member(Ident, Member->MPC_SU_MemberDecl.Next);
    case kMPC_SU_Member:
	if(Ident==Member->MPC_SU_Member.Name) return Member;
	return Find_Member(Ident, Member->MPC_SU_Member.Next);
    case kMPC_FreeNode:
	break;
    default:
	CompilerError("Unexpected node kind in Find_Member()", NoPosition);
  }
  return NoTree;
}

/****************/
void Add_EquivType
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, tTree Equiv)
#else
	(Type, Equiv)
	tTree Type;
	tTree Equiv;
#endif
{
  tTree first = Equiv;
  while(first->MPC_Type.EquivType!=NoTree && first->MPC_Type.EquivType!=Equiv)
    first = first->MPC_Type.EquivType;  /* find 'place to break' the ring; */
  Type->MPC_Type.EquivType = Equiv;
  first->MPC_Type.EquivType = Type;  /* new ring ready; */
}


static bool CompatibleBasicTypes(tTree,tTree);

/***************/
bool Is_EqualType  /* for type checkin redeclaration of variable -- strict==true !!!! */
/***************/  /* (for pointer's ElementType in '=' and in par/arg check - false) */
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2, bool strict)
#else
	(type1, type2, strict)
	tTree type1, type2;
	bool strict;
#endif
{
  tTree tmp = type1;
  bool strict_correction;

  if(type1==type2) return true;
  /*if(type1->Kind!=type2->Kind) return false;*/

  strict_correction = strict ? EqualTypeFlags(type1->MPC_Type.Flag,
					      type2->MPC_Type.Flag)
			     : true;

  if(type1->Kind==type2->Kind) {
    switch(type1->Kind) {
	case kMPC_BasicType:
		if(strict) return false; /* -- MUST BE the same trees!!! */
		else if(!CompatibleBasicTypes(type1, type2)) return false;
		else return true;
		break;
	case kMPC_StructType:
	case kMPC_UnionType:
		while(tmp->MPC_Type.EquivType!=NoTree && tmp->MPC_Type.EquivType!=type1) {
		  tmp = tmp->MPC_Type.EquivType;
		  if(tmp==type2) return true;
		}
		break;
	case kMPC_PointerType:
		return strict_correction &&
		       Is_EqualType(type1->MPC_PointerType.ElementType,
				    type2->MPC_PointerType.ElementType, strict);
	case kMPC_ArrayType:
		if(type1->MPC_ArrayType.NumberOfComponents==UNDEFINED ||
		   type2->MPC_ArrayType.NumberOfComponents==UNDEFINED ||
	/***/	   type1->MPC_ArrayType.NumberOfComponents==0 &&
	/***/	   type1->MPC_ArrayType.ArraySize->Kind!=kMPC_FreeNode)
		  return strict_correction &&
			 Is_EqualType(type1->MPC_ArrayType.ElementType,
				      type2->MPC_ArrayType.ElementType, strict);
    }
  }

  if(type1->Kind==kMPC_ArrayType && type2->Kind==kMPC_PointerType)
    return strict_correction &&
	   Is_EqualType(type1->MPC_ArrayType.ElementType,
			type2->MPC_PointerType.ElementType,strict);
  if(type2->Kind==kMPC_ArrayType && type1->Kind==kMPC_PointerType)
    return strict_correction &&
	   Is_EqualType(type2->MPC_ArrayType.ElementType,
			type1->MPC_PointerType.ElementType,strict);

  return false;
}

/******************************/
static bool CompatibleBasicTypes
/******************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2)
#else
	(type1, type2)
	tTree type1, type2;
#endif
{
  /** WANING: this function allows non-ANSI assignments of pointers to some basic   **
   ** types; she is added for compatibility with other compilers which allows this. **/
  if(type1->MPC_BasicType.TypeConstructor==type2->MPC_BasicType.TypeConstructor)
    return true;
  if(type1->MPC_BasicType.TypeConstructor<=CHAR &&
     type1->MPC_BasicType.TypeConstructor>=UNSIGNED_CHAR &&
     type2->MPC_BasicType.TypeConstructor<=CHAR &&
     type2->MPC_BasicType.TypeConstructor>=UNSIGNED_CHAR)
    return true;
  if(type1->MPC_BasicType.TypeConstructor<=SHORT &&
     type1->MPC_BasicType.TypeConstructor>=UNSIGNED_SHORT &&
     type2->MPC_BasicType.TypeConstructor<=SHORT &&
     type2->MPC_BasicType.TypeConstructor>=UNSIGNED_SHORT)
    return true;
  if(type1->MPC_BasicType.TypeConstructor<=INT &&
     type1->MPC_BasicType.TypeConstructor>=UNSIGNED &&
     type2->MPC_BasicType.TypeConstructor<=INT &&
     type2->MPC_BasicType.TypeConstructor>=UNSIGNED)
    return true;
  if(type1->MPC_BasicType.TypeConstructor<=LONG &&
     type1->MPC_BasicType.TypeConstructor>=UNSIGNED_LONG &&
     type2->MPC_BasicType.TypeConstructor<=LONG &&
     type2->MPC_BasicType.TypeConstructor>=UNSIGNED_LONG)
    return true;
  return false;
}


/**********************/
void Release_TypeTable()
/**********************/
{
  Remove_SUE_Typedef = false;
  ReleaseArray((char **)&TypeTable, &TypeTable_Size, sizeof(tTree));
  ReleaseArray((char **)&TypeStack, &TypeStack_Size, sizeof(tTree));
}

/********************/
void Init_ScopeStack()
/********************/
{
  MakeArray((char **)&ScopeStack, &ScopeStack_Size, sizeof(tScopeStack_Element));
  ScopeStack_Top = 0;
  ScopeStack[0].Ident = NoIdent;  /* global scope marker; */
  ExprScope_Opened = false;
  Scope_UniqueNumber = 0;
  ScopeStack[0].NameSpace = Scope_UniqueNumber;
  FreeNode = nMPC_FreeNode();  /* for the next calls of Make_UniqueNumber(FreeNode); */
}

/********************/
void ScopeStack_Dump()
/********************/
{
  int i;
  printf("====================================\n");
  printf("========     SCOPE_STACK    ========\n");
  printf("====================================\n");
  for(i=ScopeStack_Top; i>=0; i--) {
    printf(" %d      ", i);
    WriteIdent(stdout, ScopeStack[i].Ident);
    printf("\n");
  }
  printf("====================================\n");
}

/***************/
void Open_Scope()
/***************/
{
  ScopeStack_Top++;
  if(ScopeStack_Top == ScopeStack_Size)
    ExtendArray((char **)&ScopeStack, &ScopeStack_Size, sizeof(tScopeStack_Element));
  ScopeStack[ScopeStack_Top].Ident = NoIdent;                /* current scope marker; */
  ScopeStack[ScopeStack_Top].NameSpace = Scope_UniqueNumber; /* old scope number; */
  Scope_UniqueNumber = Make_UniqueNumber(FreeNode);          /* new scope number; */
}

/****************/
void Close_Scope()
/****************/
{
  PrevScope_Top = ScopeStack_Top;   /* because Restore_ExprScope() is possible... */
  while(ScopeStack_Top && ScopeStack[ScopeStack_Top].Ident!=NoIdent)
    ScopeStack_Top--;
  Scope_UniqueNumber = ScopeStack[ScopeStack_Top].NameSpace; /* restore the previous scope number; */
  if(ScopeStack_Top && ScopeStack[ScopeStack_Top].Ident==NoIdent) {
    ScopeStack_Top--;
  }
  else
    CompilerError("Bad state of ScopeStack in Close_Scope()", CurrentPosition);
}

/***********************/
void Try_ExprScopeBegin()
/***********************/
{
  int i=TypeStack_Top;

  if(!ExprScope_Opened) {
    Open_Scope();
    ExprScope_Opened = true;
    ExprScope_Closed = false;
  }

  /* Reevaluate Type.ScopeNumber for type declared in cast or sizeof expression: */
  while(TypeStack[i]) {
    if(TypeStack[i]->Kind==kMPC_ArrayType ||
       TypeStack[i]->Kind==kMPC_VectorType ||
       TypeStack[i]->Kind==kMPC_PointerType)
      TypeStack[i]->MPC_Type.ScopeNumber = Scope_UniqueNumber;
    else
      break;
    i--;
  }
}

/*****************/
bool ExprScopeEnd()
/*****************/
{

  if(ExprScope_Opened) {
    Close_Scope();
    ExprScope_Opened = false;
    ExprScope_Closed = true;
    return true;
  }
  return false;
}

/**********************/
void Restore_ExprScope()
/**********************/
{ 
  /*return;*/  /** currently the case of ...(expr)... **/
  if(ExprScope_Closed) {
    Scope_UniqueNumber = ScopeStack[ ScopeStack_Top + 1 ].NameSpace;
    ScopeStack_Top = PrevScope_Top;
    ExprScope_Opened = true;
  }
  ExprScope_Closed = false;
}

/******************/
void Save_SUE_Tags()
/******************/
{
/** This function moves ALL NSUE_TAG-idents from current scope to prev. scope  **/
/** IMMEDIATELY BEFORE call Close_Scope() for sue_declaration_specifier-scope. **/

  int scope_bottom, i;

  for(scope_bottom=ScopeStack_Top; ScopeStack[scope_bottom].Ident!=NoIdent; scope_bottom--);
  for(i=scope_bottom; i<=ScopeStack_Top; i++) {
    if(ScopeStack[i].NameSpace==NSUE_TAG) {
      ScopeStack[scope_bottom++] = ScopeStack[i]; /* move ident; */
      ScopeStack[i].NameSpace = NONE;             /* to avoid errors during next call; */
      ScopeStack[scope_bottom].Ident = NoIdent;
      ScopeStack[scope_bottom].NameSpace = NONE;  /* move scope marker; */
    }
  }

}

/**************/
tTree Find_Ident
/**************/
#if defined __STDC__ | defined __cplusplus
	(tIdent Ident, int NameSpace)
#else
	(Ident, NameSpace)
	tIdent Ident;
	int NameSpace;
#endif
{
  int i;

  if(Ident==NoIdent)
    return NoTree;
  for(i=ScopeStack_Top; i>0; i--)
    if(Ident == ScopeStack[i].Ident &&
       NameSpace == ScopeStack[i].NameSpace)
      return ScopeStack[i].Decl;
  return NoTree;
}

/*************/
tTree Add_Ident
/*************/
#if defined __STDC__ | defined __cplusplus
	(tIdent Ident, int NameSpace, tTree Decl)
#else
	(Ident, NameSpace, Decl)
	tIdent Ident;
	int NameSpace;
	tTree Decl;
#endif
{
  int i;


  /* Check on error repair: */
  if(!Decl || Decl->Kind==kMPC_Var && !Decl->MPC_Var.Type ||
     Decl->Kind==kMPC_Function && !Decl->MPC_Function.Type) {
    Make_Message(1, xxInformation, Decl->MPC_Decls.Pos, Decl);
	/* "Compilation continued after errors" */
    return Decl;
  }

  if(Ident!=NoIdent) {

    /* check on redeclaration in the same scope: */

    for(i=ScopeStack_Top; ScopeStack[i].Ident!=NoIdent; i--) {
      int ERROR=0;
      if(ERROR=(Ident==ScopeStack[i].Ident && NameSpace==IDENT &&
	 ScopeStack[i].NameSpace==IDENT &&
	 !Is_CorrectRedeclaration(ScopeStack[i].Decl,Decl))) {
	tPosition prev_pos;
	prev_pos = RealPosition(ScopeStack[i].Decl->MPC_Decls.Pos);
	Make_MessageI(401, xxError, Decl->MPC_Decls.Pos, xxIdent,
		      (char*)&Ident, Decl);
		/* "Invalid redeclaration of identifier" */
	Make_MessageI(2,
		      xxInformation, Decl->MPC_Decls.Pos, xxString,
		      SourceFile(ScopeStack[i].Decl->MPC_Decls.Pos), Decl);
		/* "   Previous declaration of this identifier is located in file" */
	Make_MessageI(3, xxInformation, Decl->MPC_Decls.Pos,
		       xxShort, (char*)&(prev_pos.Line), Decl);
		/* "   and starts in line" */
	if(Decl->Kind==kMPC_Var) Decl->MPC_Var.Flag.Ignore = YES;
	if(Decl->Kind==kMPC_Function) Decl->MPC_Function.Flag.Ignore = YES;
	return Decl;
      }
      if(Ident==ScopeStack[i].Ident && NameSpace==NSUE_MEMBER &&
	 ScopeStack[i].NameSpace==NSUE_MEMBER) {
	Make_MessageI(402, xxError,
		      Decl->MPC_SU_Member.Pos, xxIdent, (char*)&Ident, Decl);
		/* "Redeclaration of struct/union member" */
	return Decl;
      }
      if(Ident==ScopeStack[i].Ident && NameSpace==NSUE_TAG &&
	 ScopeStack[i].NameSpace==NSUE_TAG) {
	if(Decl->MPC_StructType.MemberDecls!=NoTree &&
	   ScopeStack[i].Decl->MPC_StructType.MemberDecls!=NoTree) {
	  Make_MessageI(403, xxError,
			Decl->MPC_Decls.Pos, xxIdent, (char*)&Ident, Decl);
		/* "Invalid redeclaration of struct/union/enum/nettype" */
	  if(Tree_IsType(Decl,kMPC_Type)) Decl->MPC_Type.Flag.Ignore = YES;
	}
	else /* ScopeStack[i].Decl->MPC_StructType.MemberDecl==NoTree, replace ... */
	  ScopeStack[i].Decl = Decl;
	return Decl;
      }
    }

    ScopeStack_Top++;
    if(ScopeStack_Top==ScopeStack_Size)
      ExtendArray((char**)&ScopeStack, &ScopeStack_Size, sizeof(tScopeStack_Element));
    ScopeStack[ScopeStack_Top].Ident = Ident;
    ScopeStack[ScopeStack_Top].NameSpace = NameSpace;
    ScopeStack[ScopeStack_Top].Decl = Decl;

  }
  return Decl;
}

/**************************/
bool Is_CorrectRedeclaration
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree decl1, tTree decl2)
#else
	(decl1, decl2)
	tTree decl1, decl2;
#endif
	/* decl2 is new declaration, decl1 - previous declaration; */
{
  tTree type1=NoTree, type2=NoTree;
  bool  ident1_extern_link = false,
	ident2_extern_link = false,
	ident1_static = false,
	ident2_static = false,
	function = false;

  if(decl1->Kind != decl2->Kind) return false;
  if(decl1->Kind==kMPC_Var &&
     (decl1->MPC_Var.Flag.Exported || decl1->MPC_Var.Flag.Extern))
    type1 = decl1->MPC_Var.Type, ident1_extern_link = true;
  if(decl2->Kind==kMPC_Var &&
     (decl2->MPC_Var.Flag.Exported || decl2->MPC_Var.Flag.Extern))
    type2 = decl2->MPC_Var.Type, ident2_extern_link = true;
  if(decl1->Kind==kMPC_Var && decl1->MPC_Var.Flag.Static)
    ident1_static = true;
  if(decl2->Kind==kMPC_Var && decl2->MPC_Var.Flag.Static)
    ident2_static = true;
  if(decl1->Kind==kMPC_Var && decl1->MPC_Var.Type->Kind==kMPC_FunctionType &&
     decl2->Kind==kMPC_Var && decl2->MPC_Var.Type->Kind==kMPC_FunctionType) {
    function = true;
    type1 = decl1->MPC_Var.Type;
    type2 = decl2->MPC_Var.Type;
  }

  if(type1==NoTree || type2==NoTree) return false;

  if(function) { /* compare function types */
    bool Is_CorrectParamRedecl(tTree type1, tTree type2, int Verbose);
    if(type1->MPC_FunctionType.ResultType !=
       type2->MPC_FunctionType.ResultType) {
/***BreakParser();***/
      Make_MessageI(404, xxError, decl2->MPC_Var.Pos,
		/* "Conflicting types in redeclaration of function" */
		    xxIdent, (char*)&decl2->MPC_Var.Ident, decl2);
      return false;
    }
    if(type1->MPC_FunctionType.Kind != type2->MPC_FunctionType.Kind) {
      Make_MessageI(405, xxError, decl2->MPC_Var.Pos, xxIdent, (char*)&decl2->MPC_Var.Ident, decl2);
		/* "Function was previously declared with another function kind" */
      return false;
    }
    if(ident1_static && !ident2_static) {
      Make_Message(406, xxError, decl2->MPC_Var.Pos, decl2);
		/* "Function was previously declared 'static'" */
      return false;
    }
    if(ident2_static && !ident1_static) {
      Make_Message(407, xxError, decl2->MPC_Var.Pos, decl2);
		/* "Function is declared 'static' and has non-static prototype(s)" */
      return false;
    }
    if(type1->MPC_FunctionType.ParamList->Kind!=kMPC_FreeNode &&
       type2->MPC_FunctionType.ParamList->Kind==kMPC_FreeNode &&
       type1->MPC_FunctionType.NumberOfComponents!=0 /* not (void) !!! */
       && type2->MPC_FunctionType.NumberOfComponents==0) {
      Make_MessageI(408, xxError, decl2->MPC_Var.Pos,
		    xxIdent, (char*)&(decl2->MPC_Var.Ident), decl2);
		/* "Function is declared without parameters and previously was declared with parameter list" */
      return false;
    }
    return Is_CorrectParamRedecl(type1, type2, YES);
  }
  else if(decl1->Kind==kMPC_Var && decl2->Kind==kMPC_Var &&
	  ident1_extern_link && ident2_extern_link &&
	  (type1==type2 || Is_EqualType(type1,type2,true/*strict*/)))
    return true;
  else
    return false;
}

/************************/
bool Is_CorrectParamRedecl
/************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2, int Verbose)
#else
	(type1, type2, Verbose)
	tTree type1, type2;
#endif
	/* type1 is type of previously declared function, type2 - of new declaration; */
{
  tTree par1, par2, par2_Prev=NoTree;
  bool err_flag = false;

  if(type1->MPC_FunctionType.NumberOfComponents==UNDEFINED ||
     type2->MPC_FunctionType.NumberOfComponents==UNDEFINED ||
     type1->MPC_FunctionType.NumberOfComponents==0 &&
     type2->MPC_FunctionType.NumberOfComponents==0)
    return true;
  /**else if(type2->MPC_FunctionType.NumberOfComponents==UNDEFINED)
    return false; *** type1 - with param_type_list, type2 - without !!! **/
  else {
    par1 = type1->MPC_FunctionType.ParamList;
    par2 = type2->MPC_FunctionType.ParamList;
    while(par1!=NoTree && par2!=NoTree &&
	  par1->Kind!=kMPC_FreeNode && par2->Kind!=kMPC_FreeNode) {

      tTree pt1=NoTree, pt2=NoTree;

      if(par1->Kind==kMPC_Ellipsis)
	goto NextIteration;

      /* compare types: */
      if(par1->Kind==kMPC_VarDecl && par1->MPC_VarDecl.Var!=NoTree &&
	 par1->MPC_VarDecl.Var->Kind==kMPC_Var)
	pt1 = par1->MPC_VarDecl.Var->MPC_Var.Type;
      else if(par1->Kind==kMPC_VarDecl)  /* only type declared: */
	pt1 = par1->MPC_VarDecl.DeclSpecifier;
      if(Typedef_Dependent(pt1)) {
	Remove_SUE_Typedef = YES;
	Push_PurePattern(pt1);
	Remove_SUE_Typedef = NO;
	pt1 = Make_Type();
      }
      if(par2->Kind==kMPC_VarDecl && par2->MPC_VarDecl.Var!=NoTree &&
	 par2->MPC_VarDecl.Var->Kind==kMPC_Var)
	pt2 = par2->MPC_VarDecl.Var->MPC_Var.Type;
      else if(par2->Kind==kMPC_VarDecl)  /* only type declared: */
	pt2 = par2->MPC_VarDecl.DeclSpecifier;
      if(Typedef_Dependent(pt2)) {
	Remove_SUE_Typedef = YES;
	Push_PurePattern(pt2);
	Remove_SUE_Typedef = NO;
	pt2 = Make_Type();
      }

      if( !(par1->Kind==kMPC_VarDecl && par2->Kind==kMPC_VarDecl &&
	    (pt1==pt2 || Is_Same_PointerToFunction(pt1,pt2) ||
	     Is_EqualType(pt1,pt2,true/*strict*/)
	     /* array/pointer parameter's: */
	     /******************************
	     pt1->Kind==kMPC_ArrayType &&
	     (pt2->Kind==kMPC_ArrayType &&
	      pt1->MPC_ArrayType.ElementType==pt2->MPC_ArrayType.ElementType ||
	      pt2->Kind==kMPC_PointerType &&
	      pt1->MPC_ArrayType.ElementType==pt2->MPC_PointerType.ElementType
	     ) ||
	     pt2->Kind==kMPC_ArrayType &&
	     (pt1->Kind==kMPC_PointerType &&
	      pt2->MPC_ArrayType.ElementType==pt1->MPC_PointerType.ElementType
	     )****************************/
	    ) ||
	    par1->Kind==kMPC_Ellipsis && par2->Kind==kMPC_Ellipsis) ) {
	if(Verbose)
	  Make_Message(409, xxError, par2->MPC_Decls.Pos, par2);
		/* "Conflicting types in function parameter declaration" */
	err_flag = true;
        type2->MPC_Type.Flag.Ignore = YES;
      }

      NextIteration:
      par1 = par1->MPC_Decls.Next;
      par2_Prev = par2;
      par2 = par2->MPC_Decls.Next;

    }
    if(par1->Kind==kMPC_FreeNode && par2->Kind!=kMPC_FreeNode) {
      if(Verbose)
        Make_Message(410, xxError, par2->MPC_Decls.Pos, par2);
		/* "List of parameters is too long" */
      err_flag = true;
      type2->MPC_Type.Flag.Ignore = YES;
    }
    if(par2->Kind==kMPC_FreeNode && par1->Kind!=kMPC_FreeNode) {
      if(Verbose)
        Make_Message(411, xxError, par2_Prev->MPC_Decls.Pos, par2_Prev);
		/* "List of parameters is too short" */
      err_flag = true;
      type2->MPC_Type.Flag.Ignore = YES;
    }
  }

  return !err_flag;
}

/***************************/
int Is_Same_PointerToFunction
/***************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2)
#else
	(type1, type2)
	tTree type1, type2;
#endif
{
  extern bool Is_CorrectParamRedecl();

  if( !type1 || !type2 ) return NO;
  if(Is_PointerType(type1)) type1 = type1->MPC_PointerType.ElementType;
  if(Is_PointerType(type2)) type2 = type2->MPC_PointerType.ElementType;
  if(type1->Kind!=kMPC_FunctionType) return NO;
  if(type2->Kind!=kMPC_FunctionType) return NO;

  if( !(type1->MPC_FunctionType.ResultType==type2->MPC_FunctionType.ResultType ||
	Is_EqualType(type1->MPC_FunctionType.ResultType,
		     type2->MPC_FunctionType.ResultType, true/*strict*/)) )
    return NO;

  return Is_CorrectParamRedecl(type1, type2, NO /*Verbose*/);
}

/***********************/
void Release_ScopeStack()
/***********************/
{
  ReleaseArray((char **)&ScopeStack, &ScopeStack_Size, sizeof(tScopeStack_Element));
  Scope_UniqueNumber = 0;
}


/*********************/
void Init_SubnetTable()
/*********************/
{
  MakeArray((char **)&SubnetTable, &SubnetTable_Size, sizeof(tTree));
  SubnetTable_Top = -1;
}

/*************/
void Add_Subnet
/*************/
#if defined __STDC__ | defined __cplusplus
	(tTree Subnet)
#else
	(Subnet)
	tTree Subnet;
#endif
{
  if(!Subnet) return; /* Maybe incorrect error repair, => invalid reduce; */

  SubnetTable_Top++;
  if(SubnetTable_Top==SubnetTable_Size)
    ExtendArray((char **)&SubnetTable, &SubnetTable_Size, sizeof(tTree));
  SubnetTable[SubnetTable_Top] = Subnet;
}

/***************/
tTree Find_Subnet
/***************/
#if defined __STDC__ | defined __cplusplus
	(tTree Subnet)
#else
	(Subnet)
	tTree Subnet;
#endif
{
  tTree found=NoTree;
  int i;

  for(i=0; i<=SubnetTable_Top; i++) {
    if(Subnet==SubnetTable[i]                     /* The same subnetwork is in table: */
       ||
       Subnet->MPC_Subnet.Distribution==
         SubnetTable[i]->MPC_Subnet.Distribution &&
       Subnet->MPC_Subnet.IsParent &&
       SubnetTable[i]->MPC_Subnet.IsParent  /* Parents of the same network */
    )
      found = SubnetTable[i];
  } /*end for*/
  return found;
}

/*********************/
tTree Find_ParentSubnet
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Net)
#else
	(Net)
	tTree Net;
#endif
{
  tTree found=NoTree;
  int i;

  for(i=0; i<=SubnetTable_Top; i++) {
    if(Net==SubnetTable[i]->MPC_Subnet.Distribution &&
       SubnetTable[i]->MPC_Subnet.IsParent)
      found = SubnetTable[i];
  }
  return found;
}
/************************/
void Release_SubnetTable()
/************************/
{
  ReleaseArray((char **)&SubnetTable, &SubnetTable_Size, sizeof(tTree));
}



/**********************/
tDeclFlags Make_DeclFlag
/**********************/
#if defined __STDC__ | defined __cplusplus
	(int Auto, int Static, int Register, int Parameter, int Extern,
	 int Exported, int Distributed, int FC_Generated, int Source, int Ignore)
#else
	(Auto, Static, Register, Parameter, Extern,
	 Exported, Distributed, FC_Generated, Source, Ignore)
	int Auto, Static, Register, Parameter, Extern,
	    Exported, Distributed, FC_Generated, Source, Ignore;
#endif
{
  tDeclFlags res;

  res.Auto = Auto;
  res.Static = Static;
  res.Register = Register;
  res.Parameter = Parameter;
  res.Extern = Extern;
  res.Exported = Exported;
  res.Distributed = Distributed;
  res.ExplDistr = NO;  /* not initialized by this function; */
  res.DistrLabel = NO; /* not initialized by this function; */
  res.FC_Generated = FC_Generated;
  res.Source = Source;
  res.Ignore = Ignore;
  res.DUMMY = 0;

  return res;
}

/**********************/
tTypeFlags Make_TypeFlag
/**********************/
#if defined __STDC__ | defined __cplusplus
	(int Const, int Volatile, int Repl, int BitArray, int TypedefList,
	 int Basic, int Nodal, int Network, int Source, int Ignore)
#else
	(Const, Volatile, Repl, BitArray, TypedefList,
	 Basic, Nodal, Network, Source, Ignore)
	int Const, Volatile, Repl, BitArray, TypedefList,
	    Basic, Nodal, Network, Source, Ignore;
#endif
{
  tTypeFlags res;

  res.Const = Const;
  res.Volatile = Volatile;
  res.Repl = Repl;
  res.BitArray = BitArray;
  res.DynArray = NO;	/** this flag must be initialized 'by hand'             **/
  res.ExplStep = NO;	/** this flag must be initialized 'by hand' in mpc.pars **/
  res.DynStep = NO;	/** this flag must be initialized 'by hand'             **/
  res.MemCopy = NO;	/** this flag must be initialized 'by hand'             **/
  res.TypedefList = TypedefList;
  res.Basic = Basic;
  res.Nodal = Nodal;
  res.Network = Network;
  res.Checked = NO;	/** this flag must be initialized 'by hand' in eval_ast.c **/
  res.Native = NativeMode;  /** NativeMode is a global variable; **/
  res.Source = Source;
  res.Ignore = Ignore;
  
#ifndef __WRK
  res.DUMMY = 0;
#endif

  return res;
}

/**********************/
tStatFlags Make_StatFlag
/**********************/
#if defined __STDC__ | defined __cplusplus
	(int Distributed, int Asynchr, int PartAsynchr, int CreateAutoNet,
	 int CreateStaticNet, int Source, int Ignore)
#else
	(Distributed, Asynchr, PartAsynchr, CreateAutoNet,
	 CreateStaticNet, Source, Ignore)
	int Distributed, Asynchr, PartAsynchr, CreateAutoNet,
	    CreateStaticNet, Source, Ignore;
#endif
{
  tStatFlags res;

  res.Distributed = Distributed;
  res.Asynchr = Asynchr;
  res.PartAsynchr = PartAsynchr;
  res.DistrLabel = NO;   /** should be turned on manually... **/
  res.CreateAutoNet = CreateAutoNet;
  res.CreateStaticNet = CreateStaticNet;
  res.CreateSubnet = NO; /* not initialized by this function; */
  res.CtrlSend = NO;     /* not initialized by this function; */
  res.Source = Source;
  res.Ignore = Ignore;
  res.DUMMY = 0;

  return res;
}

/**********************/
tExprFlags Make_ExprFlag
/**********************/
#if defined __STDC__ | defined __cplusplus
	(int Lvalue, int Const, int Distributed, int Asynchr,
	 int PartAsynchr, int InParentheses, int Generated,
	 int Peculiarity, int Defer, int SideEffects, int Source, int Ignore)
#else
	(Lvalue, Const, Distributed, Asynchr, PartAsynchr, InParentheses,
	 Generated, Peculiarity, Defer, SideEffects, Source, Ignore)
	int Lvalue, Const, Distributed, Asynchr, PartAsynchr, InParentheses,
	    Generated, Peculiarity, Defer, SideEffects, Source, Ignore;
#endif
{
  tExprFlags res;

  res.Lvalue        = Lvalue;
  res.Const         = Const;
  res.Distributed   = Distributed;
  res.Asynchr       = Asynchr;
  res.PartAsynchr   = PartAsynchr;
  res.InParentheses = InParentheses;
  res.Generated     = Generated;
  res.Peculiarity   = Peculiarity;
  res.Defer         = Defer;
  res.SideEffects   = SideEffects;
  res.FixPoint      = NO;
  res.DistrComma    = NO;
  res.Source        = Source;
  res.Ignore        = Ignore;
#ifdef __WRK
  res.DUMMY         = 0;
#endif

  return res;
}

/****************/
int Eval_UnaryExpr
/****************/
#if defined __STDC__ | defined __cplusplus
	(int OpCode, int Operand, tPosition Position)
#else
	(OpCode, Operand, Position)
	int OpCode, Operand;
	tPosition Position;
#endif
{
  switch(OpCode) {
    case PLUS: return Operand;
    case NEG:  return -Operand;
    case NOT:  return ~Operand;
    case LOG_NOT: return !Operand;
    default: Make_MessageI(200, xxRestriction, Position, xxInteger,
			   (char*)&OpCode, NoTree);
		/* "Invalid or unimplemented code of unary operator in constant subexpression (operator ignored);  OpCode" */
  }
  return UNDEFINED; /*** TMP and default for NOT CONSTANT expression !!! ***/
}

/*****************/
int Eval_SizeofExpr
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree Operand, tPosition Position)
#else
	(Operand, Position)
	tTree Operand;
	tPosition Position;
#endif
{
  if(Tree_IsType(Operand,kMPC_Expr)) {
    agContext = GLOBAL_DECLS;        /* tmp */
    agNetContext = COMPUTING_SPACE;  /* tmp */
    agFKind = BASIC;                 /* all this values are tmp; */
    mpcAttr(Operand);
    if(Operand->MPC_Expr.Flag.Ignore)
      Make_Message(201, xxInformation, Position, Operand);
		/* "Error in operand of 'sizeof', sizeof-expression not evaluated" */
    else
      return Eval_SizeofExpr(Operand->MPC_Expr.Type, Position);
  }
  else if(Tree_IsType(Operand,kMPC_Type)) {
    switch(Operand->Kind) {
      case kMPC_BasicType:
	if(Operand->MPC_BasicType.TypeConstructor==VOID) {
	  Make_Message(202, xxError, Position, Operand);
		/* "void operand of 'sizeof' expression" */
          return UNDEFINED;
        }
	else
	  return Size_Of(Operand->MPC_BasicType.TypeConstructor);
      case kMPC_Typedef:	return Eval_SizeofExpr(Operand->MPC_Typedef.Type,Position);
      case kMPC_PointerType:	return sizeof(void *);
      case kMPC_ArrayType:	if(Operand->MPC_Type.Flag.BitArray)
				  return (Operand->MPC_ArrayType.NumberOfComponents /
					 MAX_BIT_FIELD*sizeof(int) +
					 (Operand->MPC_ArrayType.NumberOfComponents %
					 MAX_BIT_FIELD ? 1 : 0 ));
				return  (1 + (Operand->MPC_ArrayType.NumberOfComponents-1) *
					Operand->MPC_ArrayType.Step) *
					Eval_SizeofExpr(Operand->MPC_ArrayType.ElementType,
							Position);
      case kMPC_VectorType:	return  Operand->MPC_VectorType.NumberOfComponents *
					Eval_SizeofExpr(Operand->MPC_ArrayType.ElementType,
							Position);
      case kMPC_StructType:	{
				  tTree mdp, mp,  ring_begin=Operand;
				  int size = 0;
    				  /*** align = Align_Of(Type); -- not used; ***/
				  if(!Operand->MPC_StructType.MemberDecls)
				    do {  /* find complete StructType: */
				      Operand = Operand->MPC_StructType.EquivType;
				    } while(Operand!=NoTree && 
                                            Operand->MPC_StructType.MemberDecls==NoTree &&
					    Operand!=ring_begin);
				  if(Operand==NoTree ||
                                     Operand->MPC_StructType.MemberDecls==NoTree) {
				    Make_Message(203, xxError, Position, Operand);
				/* "Incomplete struct type as an operand of 'sizeof'" */
				    return UNDEFINED;
				  }
    				  mdp = Operand->MPC_StructType.MemberDecls;
				  while(mdp->Kind==kMPC_SU_MemberDecl){
				    mp = mdp->MPC_SU_MemberDecl.Member;
				    while(mp->Kind==kMPC_SU_Member) {
				      size += mp->MPC_SU_Member.BitFieldLength==UNDEFINED ?
						Eval_SizeofExpr(mp->MPC_SU_Member.Type,
						Position) : sizeof(int);
				      mp = mp->MPC_SU_Member.Next;
				    }
				    mdp = mdp->MPC_SU_MemberDecl.Next;
    				  }
     				  return size;
    				}
      case kMPC_UnionType:	{
    				  int size = 0, m_size;
				  tTree ring_begin=Operand;
    				  tTree mdp, mp;
				  if(!Operand->MPC_UnionType.MemberDecls)
				    do {  /* find complete UnionType: */
				      Operand = Operand->MPC_UnionType.EquivType;
				    } while(Operand!=NoTree &&
                                            !Operand->MPC_UnionType.MemberDecls &&
 					    Operand!=ring_begin);
				  if(Operand==NoTree ||
                                     !Operand->MPC_UnionType.MemberDecls) {
				    Make_Message(204, xxError, Position, Operand);
				/* "Incomplete union type as an operand of 'sizeof'" */
				    return UNDEFINED;
				  }
    				  mdp = Operand->MPC_UnionType.MemberDecls;
				  while(mdp->Kind==kMPC_SU_MemberDecl){
				    mp = mdp->MPC_SU_MemberDecl.Member;
				    while(mp->Kind==kMPC_SU_Member) {
				      m_size =  mp->MPC_SU_Member.BitFieldLength==UNDEFINED ?
						Eval_SizeofExpr(mp->MPC_SU_Member.Type,
						Position) : sizeof(int);
				      size = Max(size,m_size);
				      mp = mp->MPC_SU_Member.Next;
				    }
				    mdp = mdp->MPC_SU_MemberDecl.Next;
				  }
    				  return size;
    				}
      default: Make_Message(205, xxRestriction, Position, Operand);
		/* "Sorry, 'sizeof' is not implemented for this operand" */
    }
  }
  else
    CompilerError("Invalid tree generated", Position);
  return UNDEFINED;
}

/*********/
int Size_Of
/*********/
#if defined __STDC__ | defined __cplusplus
	(int Type)
#else
	(Type)
	int Type;
#endif
{
  switch(Type) {
    case CHAR:
    case SIGNED_CHAR:		return sizeof(signed char);
    case UNSIGNED_CHAR:		return sizeof(unsigned char);
    case SHORT:			return sizeof(short);
    case UNSIGNED_SHORT:	return sizeof(unsigned short);
    case INT:			return sizeof(int);
    case UNSIGNED:		return sizeof(unsigned int);
    case LONG:			return sizeof(long);
    case UNSIGNED_LONG:		return sizeof(unsigned long);
    case FLOAT:			return sizeof(float);
    case DOUBLE:		return sizeof(double);
    case LONG_DOUBLE:		return sizeof(long double);
    default:
		printf("\n\n SIZE_OF(%d)\n\n", Type);
		CompilerError("Invalid argument of Size_Of()",NoPosition);
  }
  return 0;
}

/*****************/
int Eval_BinaryExpr
/*****************/
#if defined __STDC__ | defined __cplusplus
	(int OpCode, int Loperand, int Roperand, tPosition Position)
#else
	(OpCode, Loperand, Roperand, Position)
	int OpCode, Loperand, Roperand;
	tPosition Position;
#endif
{
  switch(OpCode) {
    case MULT:		return Loperand * Roperand;
    case DIV:		return Loperand / Roperand;
    case MOD:		return Loperand % Roperand;
    case MAX:		return Loperand>Roperand ? Loperand : Roperand ;
    case MIN:		return Loperand<Roperand ? Loperand : Roperand ;
    case PLUS:		return Loperand + Roperand;
    case MINUS:		return Loperand - Roperand;
    case LEFT_SHIFT:	return Loperand << Roperand;
    case RIGHT_SHIFT:	return Loperand >> Roperand;
    case LESS_THEN:	return Loperand < Roperand;
    case GREAT_THEN:	return Loperand > Roperand;
    case LESS_OR_EQ:	return Loperand <= Roperand;
    case GREAT_OR_EQ:	return Loperand >= Roperand;
    case EQUAL:		return Loperand == Roperand;
    case NOT_EQUAL:	return Loperand != Roperand;
    case AND:		return Loperand & Roperand;
    case EXCL_OR:	return Loperand ^ Roperand;
    case INCL_OR:	return Loperand | Roperand;
    case LOG_AND:	return Loperand && Roperand;
    case LOG_OR:	return Loperand || Roperand;
    default: Make_MessageI(206, xxRestriction, Position, xxInteger, (char*)&OpCode, NoTree);
		/* "Invalid or unimplemented code of binary operator in constant subexpression (operator ignored);  OpCode" */
  }
  return UNDEFINED; /*** TMP and default for NOT CONSTANT expression !!! ***/
}

/*****************/
tTree Make_IntConst
/*****************/
#if defined __STDC__ | defined __cplusplus
	(int Value)
#else
	(Value)
#endif
{
  extern char EmptyString[];
  tString SymForm;
  int v=Value, len=2;  /* sign and '\0' ; */

  do
    len++;
  while(v=v/10);
  SymForm = (tString)malloc(len);
  sprintf(SymForm, "%1d", Value);
  return   mMPC_IntConst(NoPosition, NoExprFlag, EmptyString, IntType,
			 CONST_NET_LIST, CONST_NET, SymForm, Value
	   );

}


static tTree Make_EQUAL ARGS((tTree coord, tTree expr, tTree args, tTree params, tPosition pos, tPosition begpos));  /*K*/
static tTree Make_ParentCoord ARGS((tTree expr, tTree args, tTree params, tPosition pos, tPosition begpos));  /*K*/


/*********************/
tTree Make_ParentSubnet
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree net, tPosition pos, tPosition endpos)  /*K*/
#else
	(net, pos, endpos)  /*K*/
	tTree net;
	tPosition pos,endpos;  /*K*/
#endif
{
  tTree ResultingSubnet, Predicate=NoTree;
  tTree NetType, ArgList, ParamList, CoordDecl, ParentExprs;
  tTree Coord;
  static tString Zero = "0";
  static char EmptyString[]="";

  /* Is this subnetwork already declared? */

  if( (ResultingSubnet=Find_ParentSubnet(net)) != NoTree )
    return ResultingSubnet;

  NetType = net->MPC_Net.NetType->MPC_NetTypeSpecifier.NetType;
  ArgList = net->MPC_Net.NetType->MPC_NetTypeSpecifier.ArgList;
  ParamList = NetType->MPC_NetType.ParamList;
  CoordDecl = NetType->MPC_NetType.CoordDecl;
  ParentExprs = NetType->MPC_NetType.StartDecl;

  if(!ParentExprs || ParentExprs->Kind!=kMPC_Exprs) {  /* make [0, ... ,0] for parent: */
    Coord = CoordDecl;
    ParentExprs = nMPC_FreeNode();
    while(Coord!=NoTree && Coord->Kind==kMPC_CoordDecl) {
      ParentExprs = mMPC_Exprs(
			NoPosition, ParentExprs, ParentExprs,  /*K*/
			mMPC_IntConst(NoPosition, NoExprFlag, EmptyString, IntType,  /*K*/
				CONST_NET_LIST, CONST_NET, Zero, 0
			)
		    );
      Coord = Coord->MPC_CoordDecl.Next;
      ParentExprs->MPC_Exprs.BegPos = ParentExprs->MPC_Exprs.Expr->
      				MPC_IntConst.BegPos = NoPosition;  /*K*/
    }
    ParentExprs = ReverseTree(ParentExprs);
  }  /* default parent coordinates ready; */

  /* Emit predicate: */
  while(CoordDecl!=NoTree && CoordDecl->Kind==kMPC_CoordDecl) {
    if(Predicate)
      Predicate = mMPC_BinaryExpr(NoPosition, NoExprFlag, Predicate->MPC_Expr.TmpName,  /*K*/
			IntType, NoTree, NoTree, LOG_AND, Predicate,
			Make_EQUAL(CoordDecl,ParentExprs->MPC_Exprs.Expr,ArgList,ParamList,NoPosition,NoPosition)  /*K*/
		  );
    else
      Predicate = Make_EQUAL(CoordDecl,ParentExprs->MPC_Exprs.Expr,ArgList,ParamList,NoPosition,NoPosition);  /*K*/
    Predicate->MPC_Expr.BegPos = NoPosition;  /*K*/
    CoordDecl = CoordDecl->MPC_CoordDecl.Next;
    ParentExprs = ParentExprs->MPC_Exprs.Next;
  }

  /* Emit subnet: */
  ResultingSubnet = mMPC_Subnet(pos, NoIdent, PRAGMA_BIG, net, NoTree, NoTree,
			net->MPC_Net.Ident, true/*Flexible*/, Predicate
		    );
  ResultingSubnet->MPC_Subnet.SingleNode = true;
  ResultingSubnet->MPC_Subnet.IsParent = true;
  ResultingSubnet->MPC_Subnet.EndPos = endpos;  /*K*/

  Add_Subnet(ResultingSubnet);

  return ResultingSubnet;
}

/*********************/
static tTree Make_EQUAL
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree coord, tTree expr, tTree args, tTree params, tPosition pos,
	 tPosition begpos)  /*K*/
#else
	(coord, expr, args, params, pos, begpos)  /*K*/
	tTree coord, expr, args, params;
	tPosition pos,begpos;  /*K*/
#endif
{
  tTree result, parent_coord;

  parent_coord = Make_ParentCoord(expr, args, params, pos, begpos);  /*K*/
  result = mMPC_BinaryExpr(pos, NoExprFlag, parent_coord->MPC_Expr.TmpName,
		IntType, NoTree, NoTree, EQUAL,
		mMPC_Ident(pos, NoExprFlag, parent_coord->MPC_Expr.TmpName, IntType,
			NoTree, NoTree, coord->MPC_CoordDecl.Ident, coord
		), parent_coord
	   );
  result->MPC_BinaryExpr.BegPos = begpos;  /*K*/

  return result;
}

/***************************/
static tTree Make_ParentCoord
/***************************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr, tTree args, tTree params, tPosition pos, tPosition begpos)  /*K*/
#else
	(expr, args, params, pos, begpos)  /*K*/
	tTree expr, args, params;
	tPosition pos,begpos;  /*K*/
#endif
{
  tTree Tree, actual_arg=NoTree;
  bool Ignore=false;
  switch(expr->Kind) {
    case kMPC_IntConst:
	Tree = mMPC_IntConst(pos, NoExprFlag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_Const.SymbolicForm,
			expr->MPC_IntConst.Value
	       );
	Tree->MPC_IntConst.BegPos = begpos;  /*K*/
	break;
    case kMPC_Ident:
	/* Maybe topology parameter or simple ident (after recursive call): */
	if(expr->MPC_Ident.Store!=NoTree && 
	   expr->MPC_Ident.Store->MPC_Var.Flag.Parameter) {
	  while(params!=NoTree && params->Kind==kMPC_Var) {
	    if( expr->MPC_Ident.Store!=NoTree &&
	        expr->MPC_Ident.Store->Kind==kMPC_Var &&
	        expr->MPC_Ident.Store==params) {
	       actual_arg = args->MPC_Exprs.Expr;
	      break; /*while*/
	    }
	    params = params->MPC_Var.Next;
	    args = args->MPC_Exprs.Next;
	  }
	  if(actual_arg!=NoTree)
	    Tree = Make_ParentCoord(actual_arg, args, params, pos, begpos);  /*K*/
	  else {
	    /* errors in net type declaration: */
	    Make_Message(412, xxError, pos, expr);
		/* "Cannot evaluate parent node of this network" */
	    Make_Message(4, xxInformation, pos, NoTree);
		/* "   (Errors possible in declaration of net type)" */
	    Tree = nMPC_Expr(), Ignore = true;
	  }
	}
	else  /* simple ident: */
	  Tree = mMPC_Ident(pos, expr->MPC_Expr.Flag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_Ident.Ident,
			expr->MPC_Ident.Store
		 );
	  Tree->MPC_Ident.BegPos = begpos;  /*K*/
	break;
    case kMPC_Size_Of_Value:
	Tree = mMPC_Size_Of_Value(pos, expr->MPC_Expr.Flag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_SizeofExpr.CompileTime,
			expr->MPC_SizeofExpr.Value,
			Make_ParentCoord(expr->MPC_Size_Of_Value.Operand, args, params, pos, begpos)  /*K*/
	       );
	Tree->MPC_Size_Of_Value.BegPos = begpos;  /*K*/
	break;
    case kMPC_Size_Of_Type:
	Tree = mMPC_Size_Of_Type(pos, expr->MPC_Expr.Flag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_SizeofExpr.CompileTime,
			expr->MPC_SizeofExpr.Value, expr->MPC_Size_Of_Type.Operand
	       );
	Tree->MPC_Size_Of_Type.BegPos = begpos;  /*K*/
	break;
    case kMPC_UnaryExpr:
	Tree = mMPC_UnaryExpr(pos, expr->MPC_Expr.Flag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_UnaryExpr.OpCode,
			Make_ParentCoord(expr->MPC_UnaryExpr.Operand, args, params, pos, begpos)  /*K*/
	       );
	Tree->MPC_UnaryExpr.BegPos = begpos;  /*K*/
	break;
    case kMPC_BinaryExpr:
	Tree = mMPC_BinaryExpr(pos, expr->MPC_Expr.Flag, expr->MPC_Expr.TmpName,
			expr->MPC_Expr.Type, expr->MPC_Expr.EvalNet,
			expr->MPC_Expr.StoreNet, expr->MPC_BinaryExpr.OpCode,
			Make_ParentCoord(expr->MPC_BinaryExpr.Loperand, args, params, pos, begpos),  /*K*/
			Make_ParentCoord(expr->MPC_BinaryExpr.Roperand, args, params, pos, begpos)  /*K*/
	       );
	Tree->MPC_BinaryExpr.BegPos = begpos;  /*K*/
	break;
    default:
	Make_Message(413, xxRestriction, pos, expr);
		/* "Sorry, the compiler cannot evaluate the parent node of this network" */
	SPEC_Warning((33, xxWarning, pos, NoTree));
		/* "More errors possible" */
	Tree = nMPC_Expr(); /* for correct error handling; */
	Ignore = true;
  }
  Tree->MPC_Expr.Flag.Ignore = Ignore;
  return Tree;
}


/****************/
tTree Make_NetList
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree net)
#else
	(net)
	tTree net;
#endif
{
  tTree tmp;

  if(net==HOST)	           return HOST_LIST;
  if(net==COMPUTING_SPACE) return COMPUTING_SPACE_LIST;
  if(net==SINGLE_NODE)     return SINGLE_NODE_LIST;
  if(net==CONST_NET)       return CONST_NET_LIST;
  if(net==RECON_NET)       return RECON_NET_LIST;
  if(net==ErrorNet)        return ErrorNetList;

  tmp = nMPC_FreeNode();
  tmp = mMPC_NetList(tmp, tmp, net);
  tmp->MPC_NetList.UnReduceable = false;

  return tmp;
}

/****************************/
tTree Make_UnreduceableNetList
/****************************/
#if defined __STDC__ | defined __cplusplus
	(tTree net)
#else
	(net)
	tTree net;
#endif
{
  tTree tmp;

  tmp = nMPC_FreeNode();
  tmp = mMPC_NetList(tmp, tmp, net);
  tmp->MPC_NetList.UnReduceable = true;

  return tmp;
}

/*********************/
tTree Make_FunctionType
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree TypeSpec, tTree Distribution, tPosition Pos, tTree Old_F_Decls)
#else
	(TypeSpec, Distribution, Pos, Old_F_Decls)
	tTree TypeSpec, Distribution, Old_F_Decls;
	tPosition Pos;
#endif
{
  tTree Type;
  void Make_OldFunc_Params ARGS((tTree Type, tTree Decls));

  if(Type=Find_FunctionType()) {
    if(Type->MPC_FunctionType.NumberOfComponents==UNDEFINED ||
       Type->MPC_FunctionType.NumberOfComponents==1 &&
       Type->MPC_FunctionType.ParamList->Kind==kMPC_VarDecl &&
       Type->MPC_FunctionType.ParamList->
		MPC_VarDecl.DeclSpecifier==VoidType &&
       Type->MPC_FunctionType.ParamList->
		MPC_VarDecl.Var->Kind==kMPC_FreeNode)
      Type->MPC_FunctionType.NumberOfComponents = 0; /*no parameters!*/

    Type->MPC_FunctionType.Kind =
	Distribution==COMPUTING_SPACE ? BASIC :
		(Distribution==NO_NET ? NODAL : NETWORK);

    Type->MPC_FunctionType.NetParam = Distribution;
    if(Distribution!=NoTree && Distribution->Kind==kMPC_Net &&
       Distribution->MPC_Net.Topology==PARAMETER)
      Type->MPC_FunctionType.NetParamType =
					Distribution->MPC_Net.NetType;

    if(Type->MPC_FunctionType.NetParamType!=NoTree &&
       Type->MPC_FunctionType.NetParamType->
		MPC_NetTypeSpecifier.ArgList!=NoTree &&
       Type->MPC_FunctionType.NetParamType->
		MPC_NetTypeSpecifier.ArgList->Kind==kMPC_Exprs) {
      Type->MPC_FunctionType.NetworkParamList =
	    Rebuild_NetworkParamList(
		Type->MPC_FunctionType.NetParamType->
		MPC_NetTypeSpecifier.ArgList,
		Type->MPC_FunctionType.NetParam
	    );
      Type->MPC_FunctionType.Flag.Ignore |=
	    CheckAndReset_NetworkParamTypes(
		Type->MPC_FunctionType.NetworkParamList,
		Type->MPC_FunctionType.NetParamType->
		  MPC_NetTypeSpecifier.NetType->MPC_NetType.ParamList, Pos
	    );
    }
    if(Old_F_Decls)
      Make_OldFunc_Params(Type, Old_F_Decls);
    Push_Pattern(TypeSpec);
    Type = Make_Type();
    if(Type->Kind!=kMPC_FunctionType) {
      Make_Message(414, xxError, Pos, NoTree);
		/* "Invalid declarator in function definition" */
      Type = NoTree;
    }
    else if(Type->MPC_FunctionType.NetParam!=NoTree &&
	    Type->MPC_FunctionType.NetParam->Kind==kMPC_Net &&
	    Type->MPC_FunctionType.NetParam->MPC_Net.Ident==NoIdent) {
      Make_Message(415, xxError, Pos, NoTree);
		/* "Definition of network function without net parameter" */
      Type = NoTree;
    }
  }
  else {
    Make_Message(416, xxError, Pos, NoTree);
		/* "Invalid declarator in function definition (without parameter list)" */
    Make_Message(5, xxInformation, Pos, NoTree);
		/* "   (Possibly this is syntax error)" */
    Type = NoTree;
    Clean_TypeStack();  /**** ?????? ****/
  }
  return Type;
}

/**********************/
void Make_OldFunc_Params
/**********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, tTree Decls)
#else
	(Type, Decls)
	tTree Type, Decls;
#endif
{
  tTree ipar,     /* VarDecl from identifier_list;  */
	dpar,     /* VarDecl from declaration_list; */
        dpar_var; /* Var from 'dpar';               */

  dpar = Decls;
  while(dpar!=NoTree && dpar->Kind!=kMPC_FreeNode) {
    if(dpar->Kind!=kMPC_VarDecl) {
      Make_Message(417, xxError, dpar->MPC_Decls.Pos, dpar);
		/* "Invalid declaration (not variable) in old-fashioned definition of function" */
      Type->MPC_Type.Flag.Ignore = YES;
      break;
    }
    dpar_var = dpar->MPC_VarDecl.Var;
    while(dpar_var!=NoTree && dpar_var->Kind!=kMPC_FreeNode) {
      ipar = Type->MPC_FunctionType.ParamList;
      while(ipar!=NoTree && ipar->Kind!=kMPC_FreeNode) {
        if(ipar->MPC_VarDecl.Var->MPC_Var.Ident==dpar_var->MPC_Var.Ident) {
	  ipar->MPC_VarDecl.Class = dpar->MPC_VarDecl.Class;
	  if(dpar->MPC_VarDecl.Class!=AUTO && dpar->MPC_VarDecl.Class!=REGISTER) {
	    Make_Message(418, xxError, dpar->MPC_VarDecl.Pos, dpar);
		/* "Invalid storage class in parameter declaration" */
	    ipar->MPC_VarDecl.Flag.Ignore = Type->MPC_Type.Flag.Ignore = YES;
	  }
	  ipar->MPC_VarDecl.Pos = dpar->MPC_VarDecl.Pos;
	  ipar->MPC_VarDecl.EndPos = dpar->MPC_VarDecl.EndPos;  /*K*/
	  ipar->MPC_VarDecl.Flag = dpar->MPC_VarDecl.Flag;
	  ipar->MPC_VarDecl.DeclSpecifier = dpar->MPC_VarDecl.DeclSpecifier;
	  ipar->MPC_VarDecl.Var->MPC_Var.Pos = dpar_var->MPC_Var.Pos;
	  ipar->MPC_VarDecl.Var->MPC_Var.EndPos = dpar_var->MPC_Var.EndPos;  /*K*/
	  ipar->MPC_VarDecl.Var->MPC_Var.Flag = dpar_var->MPC_Var.Flag;
	  ipar->MPC_VarDecl.Var->MPC_Var.Type = dpar_var->MPC_Var.Type;
	  ipar->MPC_VarDecl.Var->MPC_Var.Distribution =
			  dpar_var->MPC_Var.Distribution;
	  break;  /* ...find next 'dpar_var' in 'ipar'; */
        }
        ipar = ipar->MPC_Decls.Next;
      }
      if(ipar->Kind==kMPC_FreeNode) {
        Make_MessageI(419, xxError, dpar_var->MPC_Var.Pos, xxIdent,
		      (char *)&(dpar_var->MPC_Var.Ident), dpar);
		/* "No such identifier in list of parameters" */
      }
      dpar_var = dpar_var->MPC_Var.Next;
    }
    dpar = dpar->MPC_Decls.Next;
  }
}

/****************************/
tTree Rebuild_NetworkParamList
/****************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Exprs, tTree NetParam)
#else
	(Exprs, NetParam)
	tTree Exprs, NetParam;
#endif
{
  tTree Convert_ExprToVar ARGS((tTree Expr, tTree NetParam));
  tTree list=NoTree, var;

  if(Exprs!=NoTree && Exprs->Kind==kMPC_Exprs) list = nMPC_FreeNode();

  while(Exprs!=NoTree && Exprs->Kind==kMPC_Exprs) {
    if(!Exprs->MPC_Exprs.Expr->MPC_Expr.Flag.Ignore) {
      NestedType_ON();
      var = Convert_ExprToVar(Exprs->MPC_Exprs.Expr, NetParam);
      NestedType_OFF();
      if(var) {
	var->MPC_Var.Next = var->MPC_Var.Prev = list;
	list = var;
      }
    }
    Exprs = Exprs->MPC_Exprs.Next;
    /*** ADD: make ReleaseTree() for used 'Exprs' !!! ***/
  }
  return ReverseTree(list);
}

/*********************/
tTree Convert_ExprToVar
/*CHANGE!*/

/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr, tTree NetParam)
#else
	(Expr, NetParam)
	tTree Expr, NetParam;
#endif
{
  tDeclFlags flags = { NO, NO, NO, YES, NO, NO, YES, NO, NO, NO, YES, NO };
  int Make_ArrayParamType ARGS((tTree *Expr));

  /* get name of special parameter and make its type: */

  flags.Ignore = Make_ArrayParamType(&Expr);
  if(Expr!=NoTree && Expr->Kind==kMPC_Ident) {
    Push_Pattern(ReplConstIntType);
    return Add_Ident(
	     Expr->MPC_Ident.Ident, IDENT,
	     mMPC_Var(
		Expr->MPC_Expr.Pos, Expr->MPC_Ident.Ident, flags,
		NoTree, NoTree, Make_Type(), NetParam, NoTree
	     )
	   );
  }
  else if(Tree_IsType(Expr,kMPC_Const)) {
    Push_Pattern(ReplConstIntType);
    return mMPC_Var(
		Expr->MPC_Expr.Pos, NoIdent, flags,
		NoTree, NoTree, Make_Type(), NetParam, Expr
	   );
  }
  else {
    Make_Message(420, xxError, Expr->MPC_Expr.Pos, Expr);
		/* "Invalid declaration of network parameter" */
    return NoTree;
  }
}

/*********************/
int Make_ArrayParamType		/* return 1 when error, otherwise 0; */
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree *Expr)
#else
	(Expr)
	tTree *Expr;
#endif
{
  tTree expr;
  int Eval_ArrayParamSize ARGS((tTree Expr));

  expr = *Expr;
  
  if(expr->Kind==kMPC_BinaryExpr && expr->MPC_BinaryExpr.OpCode==INDEX) {
    *Expr = expr->MPC_BinaryExpr.Loperand;
    if(expr->MPC_BinaryExpr.Loperand->Kind!=kMPC_Ident) {
      Make_ArrayParamType(Expr);
    }
    Push_Pattern(
	mMPC_ArrayType(
		expr->MPC_Expr.Pos, NoTree, NoTree, NoTypeFlag,
		Eval_ArrayParamSize(expr->MPC_BinaryExpr.Roperand), 1, NoTree
	)
    );
    TopType()->MPC_ArrayType.ArraySize = expr->MPC_BinaryExpr.Roperand;
  }
  else if(!(Tree_IsType(expr,kMPC_Const) || expr->Kind==kMPC_Ident)) {
    Make_Message(421, xxError, expr->MPC_Expr.Pos, expr);
		/* "Invalid declaration of special network parameter (only scalar or array without step is possible)" */
    return 1;
  }
  return 0;
}

/*********************/
int Eval_ArrayParamSize
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr)
	tTree Expr;
#endif
{
  switch(Expr->Kind) {
    case kMPC_IntConst:
	return Expr->MPC_IntConst.Value;
    case kMPC_UIntConst:
	return Expr->MPC_UIntConst.Value;
    case kMPC_FloatConst:
    case kMPC_StringLiteral:
	Make_Message(422, xxError, Expr->MPC_Expr.Pos, Expr);
		/* "Invalid (not integral) type of constant in size of special parameter" */
	break;
    case kMPC_Ident:
	Expr->MPC_Ident.Store = Find_Ident(Expr->MPC_Ident.Ident, IDENT);
	break;
    case kMPC_UnaryExpr:
	return  Eval_UnaryExpr(
			Expr->MPC_UnaryExpr.OpCode,
			Eval_ArrayParamSize(Expr->MPC_UnaryExpr.Operand),
			Expr->MPC_Expr.Pos
		);
    case kMPC_BinaryExpr:
	return  Eval_BinaryExpr(
			Expr->MPC_BinaryExpr.OpCode,
			Eval_ArrayParamSize(Expr->MPC_BinaryExpr.Loperand),
			Eval_ArrayParamSize(Expr->MPC_BinaryExpr.Roperand),
			Expr->MPC_Expr.Pos
		);
    default:  /*** ADD THIS EXPRESSIONS !!! ***/
	Make_Message(423, xxRestriction, Expr->MPC_Expr.Pos, Expr);
		/* "Unimplemented kind of expression in declaration of special parameter" */
  }
  return UNDEFINED;
}

/*********************************/
int CheckAndReset_NetworkParamTypes
/*********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Param, tTree Pattern, tPosition ParamPos)
#else
	(Param, Pattern, ParamPos)
	tTree Param, Pattern;
	tPosition ParamPos;
#endif
{
  int RC=0;

  while(Param!=NoTree && Pattern!=NoTree &&
	Param->Kind==kMPC_Var && Pattern->Kind==kMPC_Var) {
    if(Param->MPC_Var.Type->Kind==kMPC_ArrayType &&
       Pattern->MPC_Var.Type->Kind!=kMPC_ArrayType) {
      Make_Message( 424, xxError, Param->MPC_Var.Pos, Param);
		/* "Invalid type of network parameter (the corresponding topo-parameter is scalar)" */
      Param->MPC_Var.Flag.Ignore = YES;
      RC = 1;
    }
    else
      Param->MPC_Var.Type = Pattern->MPC_Var.Type;
    Param = Param->MPC_Var.Next;
    Pattern = Pattern->MPC_Var.Next;
  }

  if((!Param || Param->Kind!=kMPC_Var) && Pattern!=NoTree && Pattern->Kind==kMPC_Var) {
    Make_Message(425, xxError, ParamPos, NoTree);
		/* "List of network parameters is too short (compare to nettype declaration)" */
    RC = 1;
  }
  if((!Pattern || Pattern->Kind!=kMPC_Var) && Param!=NoTree && Param->Kind==kMPC_Var) {
    Make_Message(426, xxError, Param->MPC_Var.Pos, Param);
		/* "List of network parameters is too long (compare with nettype declaration)" */
    Param->MPC_Var.Flag.Ignore = YES;
    RC = 1;
  }

  return RC;
}

/*****************/
int Check_LabelList
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree List)
#else
	(List) tTree List;
#endif
{	/* return YES (error flag) if List contains duplicated labels; */
  tTree tail;
  tPosition prev_pos;

  while(List){
    tail = List->MPC_Label.NextLabel;
    while(tail) {
      if(List->MPC_IdentLabel.Ident==tail->MPC_IdentLabel.Ident) {
        prev_pos = RealPosition(List->MPC_Label.Pos);
        Make_MessageI(600, xxError, tail->MPC_Label.Pos,
		      xxIdent, (char*)&(tail->MPC_IdentLabel.Ident), tail);
		/* "Label duplicated" */
	Make_MessageI(6, xxInformation, tail->MPC_Label.Pos, xxString,
		      SourceFile(List->MPC_Label.Pos), List);
		/* "   Previous declaration of this label is located in file" */
	Make_MessageI(3, xxInformation, tail->MPC_Label.Pos,
		       xxShort, (char*)&(prev_pos.Line), List);
		/* "   and starts in line" */
	return YES;
      }
      tail = tail->MPC_Label.NextLabel;
    }	
    List = List->MPC_Label.NextLabel;
  }

  return NO;
}

static tTree *ExprPtr;  /* for Recurse_DistrLabel() : pointer to parent of processed expr. */

/********************/
int Recurse_DistrLabel     /*CHANGE*/
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Stat, tTree Net, tPosition Pos)
#else
	(Stat, Net, Pos)
	tTree Stat, Net;
	tPosition Pos;
#endif
{
  int RC=0;

  if(Stat==NoTree || Stat->Kind==kMPC_FreeNode) return 0; /***TMP***/

  if(Tree_IsType(Stat,kMPC_Label))
    return Recurse_DistrLabel(Stat->MPC_Label.Next, Net, Pos);

  if(Tree_IsType(Stat,kMPC_Decls) || Stat->Kind==kMPC_Var /***|| Stat->Kind==kMPC_Subnet***/) {
#   define  Decl  Stat
    if(Decl->Kind==kMPC_VarDecl && Decl->MPC_VarDecl.Flag.DistrLabel  ||
       Decl->Kind==kMPC_NetDecl && Decl->MPC_NetDecl.Flag.DistrLabel  ||
       Decl->Kind==kMPC_Var && Decl->MPC_Var.Flag.DistrLabel) {
      return 0;  /* the comp.statement containing this decl. is already labeled; */
    }
    switch(Decl->Kind) {
      case kMPC_Type:
	return Recurse_DistrLabel(Decl->MPC_Decls.Next, Net, Pos);
	break;
      case kMPC_VarDecl:
        Decl->MPC_VarDecl.Flag.DistrLabel = YES;
	RC = Recurse_DistrLabel(Decl->MPC_VarDecl.Var, Net, Pos);
	RC |= Recurse_DistrLabel(Decl->MPC_Decls.Next, Net, Pos);
	break;
      case kMPC_NetDecl:
        Make_Message(491, xxError, Decl->MPC_NetDecl.Pos, Decl);
                     /* "Network declaration inside of compound statement labeled by distribution specifier" */
        Decl->MPC_NetDecl.Flag.Ignore = YES;
        RC = 1;
	RC |= Recurse_DistrLabel(Decl->MPC_Decls.Next, Net, Pos);
        break;
      case kMPC_SubnetDecl:
        Decl->MPC_SubnetDecl.Flag.DistrLabel = YES;
      case kMPC_RelDecl:
	/***RC = Recurse_DistrLabel(Decl->MPC_SubnetDecl.Subnet, Net, Pos);***/
	RC |= Recurse_DistrLabel(Decl->MPC_Decls.Next, Net, Pos);
	break;
      /***
      case kMPC_Subnet:
        {
          tTree ParentArea=Decl->MPC_Subnet.Distribution;
          while(ParentArea->Kind==kMPC_Subnet && ParentArea!=Net)
            ParentArea = ParentArea->MPC_Subnet.Distribution;
          if(ParentArea!=Net) {
            Make_Message(492, xxError, Decl->MPC_Subnet.Pos, Decl);
                         ** "Only subnetwork of special label may be declared" **
            RC = 1;
          }
        } 
        RC |= Recurse_DistrLabel(Decl->MPC_Subnet.Next, Net, Pos);
        break;
      ***/
      case kMPC_Var:
        Decl->MPC_Var.Flag.DistrLabel = YES;
	if(Decl->MPC_Var.Distribution==NoTree ||
	   Decl->MPC_Var.Distribution==COMPUTING_SPACE ||	/*** TMP ***/
	   Decl->MPC_Var.Distribution==SINGLE_NODE		/*** TMP ***/
	/*******************************************************************/
	/*** ALTERNATIVE - to add NEW Flag.ExlpDistribution to DeclFlags ***/
	/*******************************************************************/
	   /**|| Is_Subnet(Net, Decl->MPC_Var.Distribution) -- Is_Subnet() don't works on the 1st pass. **/)
	  Decl->MPC_Var.Distribution = Net;
	RC = Recurse_DistrLabel(Decl->MPC_Var.Init, Net, Pos);
	RC |= Recurse_DistrLabel(Decl->MPC_Var.Next, Net, Pos);
	break;
      /***
      default:
	return 0;
      ***/
    }

#   undef   Decl
  }
  else if(Stat->Kind==kMPC_SimpleInit) {
    ExprPtr = &(Stat->MPC_SimpleInit.Expr);
    RC = Recurse_DistrLabel(Stat->MPC_SimpleInit.Expr, Net, Pos);
    RC |= Recurse_DistrLabel(Stat->MPC_SimpleInit.Next, Net, Pos);
    return RC;
  }
  else if(Stat->Kind==kMPC_InitList) {
    RC = Recurse_DistrLabel(Stat->MPC_InitList.List, Net, Pos);
    RC |= Recurse_DistrLabel(Stat->MPC_InitList.Next, Net, Pos);
    return RC;
  }
  else if(Tree_IsType(Stat,kMPC_Stats)) {
    if(Stat->MPC_Stat.Flag.DistrLabel)
      return 0;  /* This stat is already labeled, and it's label should be Subnet(Net); */
    Stat->MPC_Stat.Flag.DistrLabel = YES;
    Stat->MPC_Stat.ExecNet = Make_NetList(Net);
    Stat->MPC_Stat.ExecNet->MPC_NetList.Pos = Pos;
    switch(Stat->Kind) {
      case kMPC_ExprStat:
	ExprPtr = &(Stat->MPC_ExprStat.Expr);
	return Recurse_DistrLabel(Stat->MPC_ExprStat.Expr, Net, Pos);
      case kMPC_If:
	ExprPtr = &(Stat->MPC_If.Expr);
	RC =  Recurse_DistrLabel(Stat->MPC_If.Expr, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_If.Stats, Net, Pos);
	return RC;
      case kMPC_IfElse:
	ExprPtr = &(Stat->MPC_IfElse.Expr);
	RC =  Recurse_DistrLabel(Stat->MPC_IfElse.Expr, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_IfElse.Then, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_IfElse.Else, Net, Pos);
	return RC;
      case kMPC_Switch:
	ExprPtr = &(Stat->MPC_Switch.Expr);
	RC =  Recurse_DistrLabel(Stat->MPC_Switch.Expr, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_Switch.Stats, Net, Pos);
	return RC;
      case kMPC_While:
	ExprPtr = &(Stat->MPC_While.Expr);
	RC =  Recurse_DistrLabel(Stat->MPC_While.Expr, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_While.Stats, Net, Pos);
	return RC;
      case kMPC_DoWhile:
	ExprPtr = &(Stat->MPC_DoWhile.Expr);
	RC =  Recurse_DistrLabel(Stat->MPC_DoWhile.Expr, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_DoWhile.Stats, Net, Pos);
	return RC;
      case kMPC_For:
	ExprPtr = &(Stat->MPC_For.Init);
	RC =  Recurse_DistrLabel(Stat->MPC_For.Init, Net, Pos);
	ExprPtr = &(Stat->MPC_For.Cond);
	RC |=  Recurse_DistrLabel(Stat->MPC_For.Cond, Net, Pos);
	ExprPtr = &(Stat->MPC_For.Reinit);
	RC |=  Recurse_DistrLabel(Stat->MPC_For.Reinit, Net, Pos);
	RC |= Recurse_DistrLabel(Stat->MPC_For.Stats, Net, Pos);
	return RC;
      case kMPC_Goto:
      case kMPC_Continue:
      case kMPC_Break:
	return RC;
      case kMPC_Return:
	if(Stat->MPC_Return.Expr!=NoTree && Stat->MPC_Return.Expr->Kind!=kMPC_FreeNode) {
	  ExprPtr = &(Stat->MPC_Return.Expr);
	  RC = Recurse_DistrLabel(Stat->MPC_Return.Expr, Net, Pos);
	}
	return RC;
      case kMPC_Compound:
	{
	  tTree cstat;  /* current statement */
	  RC = Recurse_DistrLabel(Stat->MPC_Compound.Decls, Net, Pos);
	  cstat = Stat->MPC_Compound.Stats;
	  while(cstat!=NoTree && cstat->Kind!=kMPC_FreeNode) {
	    while(Tree_IsType(cstat, kMPC_Label)) cstat = cstat->MPC_Label.Next;
	    RC |= Recurse_DistrLabel(cstat, Net, Pos);
	    cstat = cstat->MPC_Stat.Next;
	  }
	}
	return RC;
	/********
	SPEC_Warning(("Special label is not implemented yet for this statement",
		      xxWarning, Stat->MPC_Stat.Pos, Stat));
	break;
	********/
      default:
	Make_Message(601, xxError, Stat->MPC_Stat.Pos, Stat);
		/* "Invalid statement labeled with distribution specifier" */
	return 1;
    }
  }
  else if(Tree_IsType(Stat,kMPC_Expr)) {
#   define Expr  Stat
    switch(Expr->Kind) {
      case kMPC_Const:
      case kMPC_IntConst:
      case kMPC_UIntConst:
      case kMPC_FloatConst:
      case kMPC_StringLiteral:
	return RC;
      case kMPC_Ident:
	if(Expr->MPC_Ident.Flag.Ignore) RC = 1;
	*ExprPtr = mMPC_NetCastExpr(/*!!!*/Pos/*!!!*/,  Expr->MPC_Expr.Flag,
				Expr->MPC_Expr.TmpName, Expr->MPC_Expr.Type,
				NoTree/*EvalNet*/, Net, Net->Kind==kMPC_Net?false:
					Net->MPC_Subnet.Flexible, Expr
		   );
	(*ExprPtr)->MPC_NetCastExpr.ExprPtr = ExprPtr;
	(*ExprPtr)->MPC_Expr.Flag.Source = NO;  /*!!!*/
	(*ExprPtr)->MPC_Expr.Flag.Ignore = Expr->MPC_Expr.Flag.Ignore;
	return RC;
      case kMPC_CastExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_CastExpr.Operand);
	RC |= Recurse_DistrLabel(Expr->MPC_CastExpr.Operand, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_NetCastExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	if(Operand_IsIdent(Expr->MPC_NetCastExpr.Operand)) {
	  *ExprPtr = mMPC_NetCastExpr(/*!!!*/Pos/*!!!*/,  Expr->MPC_Expr.Flag,
				      Expr->MPC_Expr.TmpName, Expr->MPC_Expr.Type,
				      NoTree/*EvalNet*/, Net, Net->Kind==kMPC_Net?false:
								Net->MPC_Subnet.Flexible, Expr
		     );
	  (*ExprPtr)->MPC_NetCastExpr.ExprPtr = ExprPtr;
	  (*ExprPtr)->MPC_Expr.Flag.Source = NO;  /*!!!*/
	  (*ExprPtr)->MPC_Expr.Flag.Ignore = Expr->MPC_Expr.Flag.Ignore;
	}
	else {
	  ExprPtr = &(Expr->MPC_NetCastExpr.Operand);
	  RC |= Recurse_DistrLabel(Expr->MPC_NetCastExpr.Operand, Net, Pos);
	}
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_CoordExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	/******* ?????? This may cause some errors ?????? *******/
	if(Expr->MPC_CoordExpr.Operand->Kind==kMPC_Ident &&
	     Expr->MPC_CoordExpr.Operand->MPC_Ident.Ident==NoIdent) { /* I coordof <netname> */
          if(Expr->MPC_CoordExpr.Operand->MPC_Ident.StoreNet!=Net) {
            Make_Message(111, xxError, Expr->MPC_Expr.Pos, Expr);
                        /*"This expression cannot be implicitly labeled by distibution specifier"*/
            RC = 1;
          }
        }
        else {
	  ExprPtr = &(Expr->MPC_CoordExpr.Operand);
	  RC |= Recurse_DistrLabel(Expr->MPC_CoordExpr.Operand, Net, Pos);
	  Expr->MPC_Expr.Flag.Ignore |= RC;
	}
	/********************************************************/
	return RC;
      case kMPC_Size_Of_Value:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_Size_Of_Value.Operand);
	RC |= Recurse_DistrLabel(Expr->MPC_Size_Of_Value.Operand, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_Size_Of_Type:
	return RC;
      case kMPC_UnaryExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_UnaryExpr.Operand);
	RC |= Recurse_DistrLabel(Expr->MPC_UnaryExpr.Operand, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_BinaryExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_BinaryExpr.Loperand);
	RC |= Recurse_DistrLabel(Expr->MPC_BinaryExpr.Loperand, Net, Pos);
	if(Expr->MPC_BinaryExpr.OpCode!=DOT && Expr->MPC_BinaryExpr.OpCode!=ARROW) {
	  ExprPtr = &(Expr->MPC_BinaryExpr.Roperand);
	  RC |= Recurse_DistrLabel(Expr->MPC_BinaryExpr.Roperand, Net, Pos);
	}
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_TernaryExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_TernaryExpr.Foperand);
	RC |= Recurse_DistrLabel(Expr->MPC_TernaryExpr.Foperand, Net, Pos);
	ExprPtr = &(Expr->MPC_TernaryExpr.Soperand);
	RC |= Recurse_DistrLabel(Expr->MPC_TernaryExpr.Soperand, Net, Pos);
	ExprPtr = &(Expr->MPC_TernaryExpr.Toperand);
	RC |= Recurse_DistrLabel(Expr->MPC_TernaryExpr.Toperand, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_QuaternaryExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_QuaternaryExpr.Operand1);
	RC |= Recurse_DistrLabel(Expr->MPC_QuaternaryExpr.Operand1, Net, Pos);
	ExprPtr = &(Expr->MPC_QuaternaryExpr.Operand2);
	RC |= Recurse_DistrLabel(Expr->MPC_QuaternaryExpr.Operand2, Net, Pos);
	ExprPtr = &(Expr->MPC_QuaternaryExpr.Operand3);
	RC |= Recurse_DistrLabel(Expr->MPC_QuaternaryExpr.Operand3, Net, Pos);
	ExprPtr = &(Expr->MPC_QuaternaryExpr.Operand4);
	RC |= Recurse_DistrLabel(Expr->MPC_QuaternaryExpr.Operand4, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      case kMPC_CallExpr:
	if(Expr->MPC_Expr.Flag.Ignore) RC = 1;
	ExprPtr = &(Expr->MPC_CallExpr.Function);
	if(Expr->MPC_CallExpr.Function->Kind!=kMPC_Ident /* common form of func. call */ ||
	   Expr->MPC_CallExpr.Function->MPC_Ident.Store!=NoTree &&
	   Expr->MPC_CallExpr.Function->MPC_Ident.Store->MPC_Var.Type->Kind==kMPC_PointerType)
	  RC |= Recurse_DistrLabel(Expr->MPC_CallExpr.Function, Net, Pos);
	RC |= Recurse_DistrLabel(Expr->MPC_CallExpr.ArgList, Net, Pos);
	RC |= Recurse_DistrLabel(Expr->MPC_CallExpr.NetworkArgList, Net, Pos);
	Expr->MPC_Expr.Flag.Ignore |= RC;
	return RC;
      default:
	return 0;
    }
#   undef  Expr
  }
  else if(Stat->Kind==kMPC_Exprs) {
#   define Exprs  Stat
    while(Exprs->Kind==kMPC_Exprs) {
      ExprPtr = &(Exprs->MPC_Exprs.Expr);
      RC |= Recurse_DistrLabel(Exprs->MPC_Exprs.Expr, Net, Pos);
      Exprs = Exprs->MPC_Exprs.Next;
    }
    return RC;
#   undef  Exprs
  }
  else {
    CompilerError("Invalid tree node in call to Recurse_DistrLabel()", Stat->MPC_Stat.Pos);
    return 1;
  }

  return RC;
}

/*************************/
static bool Operand_IsIdent
/*************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Operand)
#else
	(Operand)
	tTree Operand;
#endif
{
  if(Operand->Kind==kMPC_Ident)
    return true;
  else if(Operand->Kind==kMPC_NetCastExpr)
    return Operand_IsIdent(Operand->MPC_NetCastExpr.Operand);
  else return false;
}

/*****************/
tTree Make_Epilogue   /*Make_Barrier*/
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tPosition Pos)
#else
	(Pos)
	tPosition Pos;
#endif
{
  tTree tmp;
  extern char EmptyString[];

  tmp = mMPC_Ident(Pos, NoExprFlag, EmptyString, Barrier_FunctionType,
		   COMPUTING_SPACE_LIST, COMPUTING_SPACE,
		   MakeIdent("MPC_Recon_epilogue",18), NoTree/*Store*/
	);
  tmp->MPC_Expr.Flag.Source = NO;
  tmp = mMPC_CallExpr(Pos, NoExprFlag, EmptyString, IntType,
		      COMPUTING_SPACE_LIST, COMPUTING_SPACE,
		      tmp, NoTree, NoTree
	);
  tmp->MPC_Expr.Flag.Source = NO;
  return mMPC_ExprStat(Pos, NoTree, NoTree, NoStatFlag, COMPUTING_SPACE_LIST, tmp);
}


/*******DEBUG*******/
void BreakParser() {} 
/******FUNCTION*****/

/* ++++++++++++++++++++++++++++++++++++++++++++++ */
