/* mpC-compiler, pass 2:               "SEMANTICS"                  */
/* ====================                 =========                   */
/*                                                                  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*     =============== Initial revision, 1995/12/.. ==========      */


#include "context.h"
#include "Tree.h"
#include "mpc_diag.h"
#include "options.h"
#include "mpc_pass1.h"
#include "mpc_pass2.h"
#include "mpcAttr.h"

#ifndef __CB_COMPILER__
# include "mpc_demo.h"
# include "topo_fun.h"
#endif

#include "mpc_sn_rel.h"

#include "Errors.h"

/*********/extern FILE *tree; extern char *treefile; /*** for DEBUG; ***/

#define TRACE(mess)		if(DEBUG){printf("===>%s,NetContext=%p\n",mess,NetContext);fflush(stdout);}
#define CHECK_TRANSIT(node)	if(node.Flag.Ignore){RC=1;Go(node.Next,Context,NetPossible,NetContext,FKind);break;}
#define CHECK_STAT_TRANSIT(node)	if(node.Flag.Ignore){RC=1;Go2Stats(node.Next,Context,NetContext,Total);break;}
#define CHECK_BREAK(node)	if(node.Flag.Ignore){RC=1;break;}
#define Set_Total(stat)		Total=(stat->MPC_Stat.ExecNet==COMPUTING_SPACE_LIST?YES:Total)


     /* The vars for emulation of INH-attributes of attribute evaluator 'mpcAttr()': */

int	agContext;
int	agFKind;
bool	agNetPossible;
tTree	agNetContext;
tTree	agNetworkParamList;
	/* and one SYN-attribute for checking of parameter list: */
tTree	Current_FunctionType;

#define GO_TO_EXPR(expr,context,net)  {agContext=context;agNetContext=net;agFKind=FKind;mpcAttr(expr);RC|=expr->MPC_Expr.Flag.Ignore;if(expr->MPC_Expr.StoreNet==SINGLE_NODE){expr->MPC_Expr.StoreNet=net;expr->MPC_Expr.EvalNet=Make_NetList(net);}}

#define GO_TO_TYPE(type,context,net)  {agContext=context;agNetContext=net;agFKind=FKind;Current_FunctionType=NoTree;mpcAttr(type);RC|=type->MPC_Type.Flag.Ignore;}

     /* Global declarations for checks on correct usage of dyn.arrays: */

static int IsTypedef = 0;		/* counter (++/--) of nested typedef declarations; */
static int DeclSpecifier_OK = YES;	/* if NO, don't print messages for any declarator; */
static int Check_Type  ARGS((tTree Type, int Context));
					      /* -- check types on dyn.arrays declaration; */

     /* Work functions used by checks of statements: */
static void Set_StatErrorFlag	ARGS((tTree Stat));
static tTree PureStat		ARGS((tTree Stat));



     /* Global definitions used by attribute evaluation: */

tTree	Pattern;	/* This tree must be compared to current evaluated subtree;  */
tTree	PatternRoot;    /* Same as Pattern but without recursion...                  */
tTree   CurrentFunction;/* = MPC_Function   -- for some checks inside function body; */
tTree	TopoParams;	/* = MPC_NetType.ParamList  -- for coord,node,link & parent; */
tTree	Coords;		/* = MPC_NetType.CoordDecl  -- for node, link & parent;      */
tTree	FreeCoords;	/* = MPC_LinkDecl.FreeCoord -- for link;		     */
int 	CurrentTopology;/* Topology of current 'net_declaring_list';		     */
int	CurrentClass;	/* 'Class' from MPC_SubnetDecl node, used by 'Subnet' check; */
bool    Inside_TimeofExpr = false;
bool    Inside_FuncDef = false;


bool    AbsoluteNodes = false,
	RelativeNodes = false;

static
int	ContinuePossible = 0,	/* COUNTERS  of level                                */
	BreakPossible 	 = 0,	/*     of  'switch'  or iteration statement          */
	BreakFanPossible = 0,	/*         for check of 'continue','break'&'break?'. */

	No_ReturnStats	 = NO;  /* selection statement (dependend on distribution of */
				/* control expression) -- also COUNTERS !!!          */
static
tTree	ControlExpr = NoTree,   /* -- for No_ReturnStats;                            */
	tmpexpr;		/* -- for correct use of some work functions;        */


int	Reduce_NetList=YES;	/* Opt. for Join_NetList() a.o.: reduce parent network? */

     /* Work data definitions for generation of topo-functions: */

tTree	Pointer_To_Int,		/* int * ...;		     */
	Pointer_To_ConstInt,	/* const int * ...; 	     */
	MPI_Int_Type;	/* typedef int Int;		     */
tTree	node_Type,	/* type of topo-function 'node()',   */
	link_Type,	/*                       'link()',   */
	parent_Type,	/*                       'parent()', */
	power_Type,	/*                       'power()',  */
	number_Type,    /*                       'number()', */
	coord_Type;	/*                       'coord()';  */

static
tString Symbolic_IntConst[] = {"0","1","2","3","4","5","6","7","8","9"};


extern char EmptyString[];


     /* Work functions (local in this file): */

int Go2Stats                   ARGS((tTree Tree, int Context, tTree NetContext, int Total));
static
int NetOrSubnet_Class          ARGS((tTree Net));
int CompatibleVectorsInAssign  ARGS((tTree op1, tTree op2));


/************/
int Semantics
/************/ 
#if defined __STDC__ | defined __cplusplus
	(tTree Tree)
#else
	(Tree)
	tTree Tree;
#endif
{
  int RC;

  Init_NetTable();
  tmpexpr = mMPC_Expr(NoPosition, NoExprFlag, EmptyString,
		      NoTree, SINGLE_NODE_LIST, SINGLE_NODE);
  tmpexpr->MPC_Expr.Flag.Lvalue = YES;

  RC = Go(Tree,UNDEFINED,false,NO_NET,UNDEFINED);

  Release_TypeTable();
  Release_ScopeStack();
  Release_NetTable();
  Release_SubnetTable();
/*ReleaseTree(tmpexpr);****/

#ifndef __CB_COMPILER__
  if(DEMO_MODE)
    WL_Close();
#endif

  return RC;
}

/****/
int Go
/****/
#if defined __STDC__ | defined __cplusplus
	(tTree Tree, int Context, bool NetPossible, tTree NetContext, int FKind)
#else
	(Tree, Context, NetPossible, NetContext, FKind)
	tTree Tree, NetContext;
	bool NetPossible;
	int Context, FKind;
#endif
{
  int RC=0, local_RC=0;
  int  Save_ReturnStatus;   /* for safety of global variable 'No_ReturnStats'; */
  bool Save_Inside_FuncDef; /* for safety of global variable 'Inside_FuncDef'  *
                             *             and to avoid incorrect diagnostics; */

  if(Tree==NoTree) {
    TRACE("NO_TREE__LINK")
    return RC;
  }

  switch(Tree->Kind) {

    case kMPC_Root:
    /*************/
	TRACE("MPC_Root")
	Tree->MPC_Root.ComputingSpace->MPC_Net.UniqueNumber =
					Make_UniqueNumber(Tree->MPC_Root.ComputingSpace);
	(void)Add_Net(COMPUTING_SPACE);
	Tree->MPC_Root.Const->MPC_Net.UniqueNumber =
					Make_UniqueNumber(Tree->MPC_Root.Const);
	(void)Add_Net(CONST_NET);
	Tree->MPC_Root.Host->MPC_Net.UniqueNumber =
					Make_UniqueNumber(Tree->MPC_Root.Host);
	(void)Add_Net(HOST);
	Tree->MPC_Root.Recon->MPC_Net.UniqueNumber =
					Make_UniqueNumber(Tree->MPC_Root.Recon);
	(void)Add_Net(RECON_NET);
	Tree->MPC_Root.SingleNode->MPC_Net.UniqueNumber =
					Make_UniqueNumber(Tree->MPC_Root.SingleNode);
	(void)Add_Net(SINGLE_NODE);
	ErrorNet->MPC_Net.UniqueNumber = Make_UniqueNumber(ErrorNet);
	(void)Add_Net(ErrorNet);
	RC = Go(Tree->MPC_Root.Decls, GLOBAL_DECLS, true, HOST, UNDEFINED);
	break;
    case kMPC_FreeNode:
    /*****************/
	TRACE("MPC_FreeNode")
	break;
    case kMPC_UncompString:
    /*********************/
	TRACE("MPC_UncompString")
	RC |= Go(Tree->MPC_Decls.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_EnumType:
    /*****************/
	TRACE("MPC_EnumType")
	CHECK_TRANSIT(Tree->MPC_EnumType)
	RC |= Go(Tree->MPC_EnumType.EnumList, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_Decls.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_Typedef:
    /****************/
	TRACE("MPC_Typedef")
	CHECK_TRANSIT(Tree->MPC_Typedef)
	GO_TO_TYPE(Tree->MPC_Typedef.Type,Context,NetContext);
	if(Current_FunctionType!=NoTree) {
	  int Kind = Current_FunctionType->MPC_FunctionType.Kind;
	  tTree NetContext = Current_FunctionType->MPC_FunctionType.NetParam;
	  if(Current_FunctionType->MPC_FunctionType.NetParam==NoTree)
	    Kind = NODAL, NetContext = SINGLE_NODE;
	  RC = Go(Current_FunctionType->MPC_FunctionType.ParamList,
		  PARAM_DECLS, false, NetContext, Kind);
	}
	Current_FunctionType = NoTree;
	IsTypedef++;
	(void)Check_Type(Tree, Context);
	IsTypedef--;
	RC |= Tree->MPC_Typedef.Flag.Ignore;
	RC |= Go(Tree->MPC_Decls.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_StructType:
    /*******************/
	TRACE("MPC_StructType")
	CHECK_TRANSIT(Tree->MPC_StructType)
	Pattern = Tree;
	RC |= Go(Tree->MPC_StructType.MemberDecls, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_Decls.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_UnionType:
    /******************/
	TRACE("MPC_UnionType")
	CHECK_TRANSIT(Tree->MPC_UnionType)
	Pattern = Tree;
	RC |= Go(Tree->MPC_UnionType.MemberDecls, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_Decls.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_VarDecl:
    /****************/
	while(Tree->Kind==kMPC_VarDecl) {
	  TRACE("MPC_VarDecl")
	  CHECK_TRANSIT(Tree->MPC_VarDecl)
	  GO_TO_TYPE(Tree->MPC_VarDecl.DeclSpecifier,Context,NetContext);
	  if(Tree->MPC_VarDecl.DeclSpecifier->Kind==kMPC_StructType ||
	     Tree->MPC_VarDecl.DeclSpecifier->Kind==kMPC_UnionType)
	    RC |= Go(Tree->MPC_VarDecl.DeclSpecifier, Context, false, NetContext, FKind);
	  local_RC = Check_Type(Tree->MPC_VarDecl.DeclSpecifier, Context);
	  if(local_RC && Context==GLOBAL_DECLS) {
	    RC = 1;
	    Tree->MPC_VarDecl.Flag.Ignore = YES;
	    Make_Message(427, xxError, Tree->MPC_VarDecl.Pos, Tree);
		/* "The global declaration introduces array or pointer type, " "which has dynamic size or step" */
	    DeclSpecifier_OK = NO;  /* don't print messages about dyn.array for any MPC_Var; */
	  }
	  if(Inside_FuncDef && Context==PARAM_DECLS &&
             Tree->MPC_VarDecl.Var!=NoTree && Tree->MPC_VarDecl.Var->Kind==kMPC_FreeNode &&
             Tree->MPC_VarDecl.DeclSpecifier!=VoidType) {
	    tPosition ErrPos=Tree->MPC_VarDecl.EndPos;
	    RC = 1;
	    Tree->MPC_VarDecl.Flag.Ignore = YES;
	    ErrPos.Column++;
	    Make_Message(490, xxError, /*Tree->MPC_VarDecl.EndPos*/ErrPos, Tree);
                /* "Parameter name expected" */
          }
          Save_Inside_FuncDef = Inside_FuncDef;
          Inside_FuncDef = false;
	  RC |= Go(Tree->MPC_VarDecl.Var, Context, false, NetContext, FKind);
          Inside_FuncDef = Save_Inside_FuncDef;
	  DeclSpecifier_OK = YES;
	  if(Tree->MPC_VarDecl.Next!=NoTree && Tree->MPC_VarDecl.Next->Kind==kMPC_VarDecl)
	    Tree = Tree->MPC_VarDecl.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_VarDecl.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_Function:
    /*****************/
	TRACE("MPC_Function")
	CHECK_TRANSIT(Tree->MPC_Function)
	{
	  tTree NetContext;
	  tTree tmp;
	  int Kind;
	  int local_rc;

	  Kind = Tree->MPC_Function.Kind;
	  if(Kind==BASIC) Tree->MPC_Function.Name->MPC_Var.Distribution = COMPUTING_SPACE;
	  NetContext  =  Kind==BASIC ? COMPUTING_SPACE
				     : (Kind==NODAL ?
					SINGLE_NODE : Tree->MPC_Function.Distribution);
	  tmp = mMPC_FreeNode(Tree->MPC_Function.Stats);
	  Tree->MPC_Function.Stats-> MPC_Compound.ExecNet =
		Tree->MPC_Function.Kind==NODAL ? SINGLE_NODE_LIST :
			( Tree->MPC_Function.Kind==BASIC ? COMPUTING_SPACE_LIST :
			  Clean_OutAttributes(mMPC_NetList(tmp,tmp,Tree->MPC_Function.Distribution)) );
	  GO_TO_TYPE(Tree->MPC_Function.Type,Context,NetContext);
	  Current_FunctionType = NoTree;
	  RC |= Go(Tree->MPC_Function.Name, GLOBAL_DECLS, false, NetContext, UNDEFINED);
	  Tree->MPC_Function.Flag.Static = Tree->MPC_Function.Name->MPC_Var.Flag.Static;
	  Tree->MPC_Function.Flag.Exported = Tree->MPC_Function.Name->MPC_Var.Flag.Exported;
	  Tree->MPC_Function.Flag.Distributed =
				  Tree->MPC_Function.Name->MPC_Var.Flag.Distributed;
	  if(!Tree->MPC_Function.Distribution)
	    Tree->MPC_Function.Distribution = Tree->MPC_Function.Name->MPC_Var.Distribution;
	  local_rc = Go(Tree->MPC_Function.Type->MPC_FunctionType.ParamList,
			PARAM_DECLS, false, NetContext, Kind);
	  RC |= local_rc;

	  Inside_FuncDef = true;
	  if(!local_rc)    /* messages for parameter list should be not duplicated: */
	    RC |= Go(Tree->MPC_Function.ParamList,
		     PARAM_DECLS, false, NetContext, Kind);  /*this list is used in Type, too; */
	  Inside_FuncDef = false;

	  if(Kind==NETWORK)
	    agNetworkParamList = Tree->MPC_Function.Type->MPC_FunctionType.NetworkParamList;
	  CurrentFunction = Tree;
	  RC |= Go(Tree->MPC_Function.Stats, STATS, Kind==BASIC?true:false, NetContext, Kind);
	  agNetworkParamList = NoTree;
	  if(Kind!=NODAL)  /* make additional checks and attribute reevaluations: */
	    RC |= Go2Stats(Tree->MPC_Function.Stats, STATS, NetContext, NO);
	  /* check on unused labels: */
	  tmp = Tree->MPC_Function.LabelList;
	  while(tmp!=NoTree && tmp->Kind==kMPC_IdentLabel) {
	    if(!tmp->MPC_IdentLabel.Used) {
	      LABEL_WarningI((34, xxWarning, tmp->MPC_Label.Pos,
			      xxIdent, (char*)&(tmp->MPC_IdentLabel.Ident), tmp));
		/* "Label not used" */
	    }
	    tmp = tmp->MPC_IdentLabel.NextLabel;
	  }
	}
	RC |= Go(Tree->MPC_Function.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_Ellipsis:
    /*****************/
	TRACE("MPC_Ellipsis")
	if(Context!=PROTOTYPE && Context!=PARAM_DECLS) {
	  RC = 1;
	  Make_Message(485 ,xxError,Tree->MPC_Ellipsis.Pos, Tree);
		/* "Ellipsis not in proper place" */
	}
	if(!Tree_IsType(Tree->MPC_Ellipsis.Next,kMPC_FreeNode)) {
	  RC = 1;
	  Make_Message(428 ,xxError,Tree->MPC_Ellipsis.Pos, Tree);
		/* "Ellipsis not at end of parameter list" */
	}
	break;
    case kMPC_NetDecl:
    /****************/
	TRACE("MPC_NetDecl")
	if(!NetPossible && !(Tree->MPC_NetDecl.Flag.Extern)) {
	  Tree->MPC_NetDecl.Flag.Ignore = YES;
	  Make_Message(429 , xxError, Tree->MPC_NetDecl.Pos, Tree);
		/* "Net definition is possible only at global level or in basic function" */
	}
	CHECK_TRANSIT(Tree->MPC_NetDecl)
	switch(Tree->MPC_NetDecl.NetClass) {
	  case AUTO:
		Tree->MPC_NetDecl.Flag.Auto = YES; CurrentClass = AUTO; break;
	  case LOCAL_STATIC:
		CurrentClass = STATIC;
	  case GLOBAL_STATIC:	if(!Tree->MPC_NetDecl.Flag.Exported)
				  Tree->MPC_NetDecl.Flag.Static = YES;
				break;
	  case EXTERN:		Tree->MPC_NetDecl.Flag.Extern = YES; break;
	}
	RC |= Go(Tree->MPC_NetDecl.NetTypeSpecifier, Context, NetPossible, NetContext, FKind);
	Pattern = Tree->MPC_NetDecl.NetTypeSpecifier->MPC_NetTypeSpecifier.ArgList;
			/* -- for checks of compatibility of arg & net distribution; */
	RC |= Go(Tree->MPC_NetDecl.Net, Context, NetPossible, NetContext, FKind);
	CurrentClass = UNDEFINED;
	RC |= Go(Tree->MPC_NetDecl.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_SubnetDecl:
    /*******************/
	TRACE("MPC_SubnetDecl")
	CHECK_TRANSIT(Tree->MPC_SubnetDecl)
	switch(Tree->MPC_SubnetDecl.SubnetClass) {
	  case EXTERN:
		Tree->MPC_SubnetDecl.Flag.Extern = YES; CurrentClass = EXTERN; break;
	  case AUTO:
		Tree->MPC_SubnetDecl.Flag.Auto = YES; CurrentClass = AUTO; break;
	  case FLEXIBLE:
		Tree->MPC_SubnetDecl.Flag.Auto = YES;
		Tree->MPC_SubnetDecl.SubnetClass = AUTO;
		CurrentClass = FLEXIBLE;
		break;
	  case GLOBAL_STATIC:
	  case LOCAL_STATIC:
		if(!Tree->MPC_SubnetDecl.Flag.Exported)
		  Tree->MPC_SubnetDecl.Flag.Static = YES;
		CurrentClass = STATIC;
		break;
	  default:
		Make_Message(430, xxError, Tree->MPC_SubnetDecl.Pos, Tree);
		/* "Invalid class of computing space in subnet declaration" */
	}
	RC |= Go(Tree->MPC_SubnetDecl.Subnet, Context, NetPossible, NetContext, FKind);
	CurrentClass = UNDEFINED;
	RC |= Go(Tree->MPC_SubnetDecl.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_RelDecl:
    /****************/
	TRACE("MPC_RelDecl")
	RC |= Go(Tree->MPC_RelDecl.Relation, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_RelDecl.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_NetType:
    /****************/
	TRACE("MPC_NetType")
	if(Context==GLOBAL_DECLS) {
	  RC |= Go(Tree->MPC_NetType.ParamList, TOPO_PARAMS, false, NetContext, FKind);
	  TopoParams = Tree->MPC_NetType.ParamList;
	  RC |= Go(Tree->MPC_NetType.CoordDecl, COORD_DECL, false, NetContext, FKind);
	  Coords = Tree->MPC_NetType.CoordDecl;
	  AbsoluteNodes = RelativeNodes = false;
	  RC |= Go(Tree->MPC_NetType.NodeDecl, NODE_DECL, false, NetContext, FKind);
	  Tree->MPC_NetType.Bench = AbsoluteNodes ? true : false ;
	  RC |= Go(Tree->MPC_NetType.LinkDecl, LINK_DECL, false, NetContext, FKind);
	  RC |= Go(Tree->MPC_NetType.StartDecl, PARENT_DECL, false, NetContext, FKind);
	  if(Tree->MPC_NetType.StartDecl!=NoTree && Tree->MPC_NetType.StartDecl->Kind==kMPC_CoordDecl)
	    RC |= Check_NodeSpecifier(Tree->MPC_NetType.StartDecl, Coords, NoTree/*only in first call;*/);
	  RC |= Go(Tree->MPC_NetType.SchemeDecl, SCHEME_DECL, false, SINGLE_NODE, FKind);
#ifndef __CB_COMPILER__
	  if(!RC) {
	    Tree->MPC_NetType.TopoFunctions =
		  mMPC_TopoFunctions(
			NoTree, NoTree, NoTree, Emit_Power(Tree),
			NoTree, NoTree, NoTree
		  );
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Node_Coord_Def = Emit_Coord(Tree);
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Node_Number_Def = Emit_Number(Tree);
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Node_Def = Emit_Node(Tree);
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Link_Def = Emit_Link(Tree);
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Main_Node_Def = Emit_Parent(Tree);
	    Tree->MPC_NetType.TopoFunctions->
		  MPC_TopoFunctions.Mapping_Def = Emit_Mapping(Tree);
	  }
#endif
	  AbsoluteNodes = RelativeNodes = false;
	}
	else {
	  RC = 1;
	  Make_Message(431, xxError, Tree->MPC_NetType.Pos, Tree);
		/* "Declaration of net type is possible only at global level" */
	}
	RC |= Go(Tree->MPC_NetType.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_NetTypeSpecifier:
    /*************************/
	TRACE("MPC_NetTypeSpecifier")
	Pattern = Tree->MPC_NetTypeSpecifier.NetType->
			MPC_NetType.ParamList;  /* for checks of ArgList: */
	if(Pattern!=NoTree && Pattern->Kind!=kMPC_FreeNode && 
	   !(Tree->MPC_NetTypeSpecifier.ArgList!=NoTree &&
	     Tree->MPC_NetTypeSpecifier.ArgList->Kind!=kMPC_FreeNode)) {
	  RC = 1;
	  Make_MessageI(432, xxError, Tree->MPC_Decls.Pos, xxIdent,
			(char*)&(Tree->MPC_NetTypeDecl.Ident), Tree);
		/* "Net type has parameters, but argument list is missing" */
	}
	CurrentTopology = CONST;
	RC |= Go(Tree->MPC_NetTypeSpecifier.ArgList, NET_ARG_LIST, false, NetContext, FKind);
	break;
    case kMPC_TopoFunctions:
    /**********************/
	TRACE("MPC_TopoFunctions")
/***/	break; /***/
	RC |= Go(Tree->MPC_TopoFunctions.Node_Def, Context, false, NO_NET, UNDEFINED);
	RC |= Go(Tree->MPC_TopoFunctions.Link_Def, Context, false, NO_NET, UNDEFINED);
	RC |= Go(Tree->MPC_TopoFunctions.Main_Node_Def, Context, false, NO_NET, UNDEFINED);
	RC |= Go(Tree->MPC_TopoFunctions.Power_Def, Context, false, NO_NET, UNDEFINED);
	RC |= Go(Tree->MPC_TopoFunctions.Node_Number_Def, Context, false, NO_NET, UNDEFINED);
	RC |= Go(Tree->MPC_TopoFunctions.Node_Coord_Def, Context, false, NO_NET, UNDEFINED);
	break;
    case kMPC_EnumConst:
    /******************/
	while(Tree->Kind==kMPC_EnumConst) {
	  TRACE("MPC_EnumConst")
	  if(Tree->MPC_EnumConst.Next!=NoTree && Tree->MPC_EnumConst.Next->Kind==kMPC_EnumConst)
	    Tree = Tree->MPC_EnumConst.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_EnumConst.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_SU_MemberDecl:
    /**********************/
	while(Tree->Kind==kMPC_SU_MemberDecl) {
	  TRACE("MPC_SU_MemberDecl")
	  RC |= Go(Tree->MPC_SU_MemberDecl.Member, Context, false, NetContext, FKind);
	  if(Tree->MPC_SU_MemberDecl.Next!=NoTree && Tree->MPC_SU_MemberDecl.Next->Kind==kMPC_SU_Member)
	    Tree = Tree->MPC_SU_MemberDecl.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_SU_MemberDecl.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_SU_Member:
    /******************/
	while(Tree->Kind==kMPC_SU_Member) {
	  TRACE("MPC_SU_Member")
	  GO_TO_TYPE(Tree->MPC_SU_Member.Type,Context,NetContext);
	  if(Is_VoidType(TerminalType(Tree->MPC_SU_Member.Type))) {
	    Make_MessageI(433, xxError, Tree->MPC_SU_Member.Pos, xxIdent,
			  (char*)&(Tree->MPC_SU_Member.Name), Tree);
		/* "Struct/union member declared void or array of void" */
	    RC = 1;
	  }
	  local_RC = Check_Type(Tree->MPC_SU_Member.Type, Context);
	  if(local_RC)
	    Make_Message(434, xxError, Tree->MPC_SU_Member.Pos, Tree);
		/* "This struct/union member declaration introduces an array or pointer type, which has dynamic size or step" */
	  RC |= Check_SelfAccess(Tree->MPC_SU_Member.Type, Pattern, Tree->MPC_SU_Member.Pos);
	  {
	    tTree type, nested_pattern;
	    type = TerminalType(Tree->MPC_SU_Member.Type);
	    if(type->Kind==kMPC_StructType || type->Kind==kMPC_UnionType) {
	      nested_pattern = Pattern;
 	      RC |= Go(type->MPC_StructType.MemberDecls, Context, false, NetContext, FKind);
	      RC |= Go(type/*Tree->MPC_SU_Member.Type*/, Context, false, NetContext, FKind);
	      Pattern = nested_pattern;
	    }
	  }
	  if(Tree->MPC_SU_Member.Next!=NoTree && Tree->MPC_SU_Member.Next->Kind==kMPC_SU_Member)
	    Tree = Tree->MPC_SU_Member.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_SU_Member.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_Var:
    /************/
	TRACE("MPC_Var")
	CHECK_TRANSIT(Tree->MPC_Var)
	GO_TO_TYPE(Tree->MPC_Var.Type,Context,NetContext);
	if(Current_FunctionType!=NoTree) {
	  int Kind = Current_FunctionType->MPC_FunctionType.Kind;
	  tTree NetContext = Current_FunctionType->MPC_FunctionType.NetParam;
	  if(NetContext==COMPUTING_SPACE)
	    Kind = BASIC;
	  if(Current_FunctionType->MPC_FunctionType.NetParam==NoTree)
	    Kind = NODAL, NetContext = SINGLE_NODE;
	  RC |= Go(Current_FunctionType->MPC_FunctionType.ParamList,
		  PARAM_DECLS, false, NetContext, Kind);
	}
	Current_FunctionType = NoTree;
	if(Is_VoidType(TerminalType(Tree->MPC_Var.Type))) {
	  Make_MessageI(435, xxError, Tree->MPC_Var.Pos, xxIdent,
			(char*)&(Tree->MPC_Var.Ident), Tree);
		/* "Variable declared void or array of void" */
	  RC = 1;
	}
	local_RC = Check_Type(Tree->MPC_Var.Type, Context);
	if(local_RC && Context==GLOBAL_DECLS && DeclSpecifier_OK) {
	  RC = 1;
	  Tree->MPC_Var.Flag.Ignore = YES;
	  Make_Message(436, xxError, Tree->MPC_Var.Pos, Tree);
		/* "The declarator introduces at global level an array or pointer type, which has dynamic size or step" */
	}
	/* check on complete struct/union specifier: */
	{
	  tTree full_type, curr_type;
	  Disable_SUE_Typedef();
	  Push_PurePattern(Tree->MPC_Var.Type);
	  curr_type = TerminalType(Make_Type());
	  Enable_SUE_Typedef();
	  if((curr_type->Kind==kMPC_StructType || curr_type->Kind==kMPC_UnionType) &&
	     !curr_type->MPC_StructType.MemberDecls) {  /* find complete specifier: */
	    full_type = curr_type->MPC_Type.EquivType;
	    while(full_type!=NoTree /* No 'EqualType' ? */ &&
		  !full_type->MPC_StructType.MemberDecls &&
		  full_type!=curr_type)
	      full_type = full_type->MPC_Type.EquivType;
	    if(full_type==NoTree  ||
	       full_type->MPC_StructType.MemberDecls==NoTree &&
	       !Tree->MPC_Var.Flag.Extern) {
	      RC = 1; Tree->MPC_Var.Flag.Ignore = YES;
	      Make_MessageI(437, xxError, Tree->MPC_Var.Pos, xxIdent,
			    (char*)&(Tree->MPC_Var.Ident), Tree);
		/* "Invalid type in declaration or definition of variable" */
	      Make_Message(7, xxInformation, Tree->MPC_Var.Pos, Tree);
		/* "   (Struct/union not declared)" */
	    }
	  }
	}
	if(Tree->MPC_Var.Distribution!=NO_NET &&
	   Tree->MPC_Var.Distribution->Kind==kMPC_Subnet &&
	   Tree->MPC_Var.Distribution->MPC_Subnet.Flexible)  /* evaluate subnet attributes: */
	  RC |= Go(Tree->MPC_Var.Distribution, Context, false, NetContext, FKind);
	if(Is_FunctionType(Tree->MPC_Var.Type)) { /* function prototype: */
	  /* Check on pointer to function: */
	  tTree ftype=Tree->MPC_Var.Type;
	  while(ftype->Kind!=kMPC_FunctionType) {
	    switch(ftype->Kind) {
	      case kMPC_Typedef:
		ftype = ftype->MPC_Typedef.Type;
		break;
	      case kMPC_PointerType:
		ftype = ftype->MPC_PointerType.ElementType;
		break;
	      case kMPC_ArrayType:
		ftype = ftype->MPC_ArrayType.ElementType;
		break;
	      case kMPC_VectorType:
		ftype = ftype->MPC_VectorType.ElementType;
		break;
	      default:
		CompilerError("Type detected as function-dependent but MPC_FunctionType not found",
			      Tree->MPC_Var.Pos);
	    }
	  }
	  if(Tree->MPC_Var.Distribution==NO_NET)
	    Tree->MPC_Var.Distribution = SINGLE_NODE;
	  if(ftype->MPC_FunctionType.NetParam==NO_NET)
	    Set_FunctionKind(Tree->MPC_Var.Type,NODAL);
	  else if(ftype->MPC_FunctionType.NetParam==COMPUTING_SPACE)
		 Set_FunctionKind(Tree->MPC_Var.Type,BASIC);
	  else
		 Set_FunctionKind(Tree->MPC_Var.Type,NETWORK);
	}
	if(Context==TOPO_PARAMS) {
	  Tree->MPC_Var.Flag.Parameter = YES;
	  Tree->MPC_Var.Distribution = SINGLE_NODE;
	}
	if(Context==PARAM_DECLS || Context==PROTOTYPE) {
	  if(Tree->MPC_Var.Type->Kind==kMPC_ArrayType) { /* change type to pointer: */
	    Push_Pattern(
		mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1, 1,
				 Tree->MPC_Var.Type->MPC_ArrayType.ElementType)
	    );
	    TopType()->MPC_PointerType.DynStep = Tree->MPC_Var.Type->MPC_ArrayType.DynStep;
	    TopType()->MPC_PointerType.GeneratedFrom = Tree->MPC_Var.Type;   /*** +++ ***/
	    Tree->MPC_Var.Type = Make_Type();
	  }
	  Tree->MPC_Var.Flag.Parameter = YES;
	  if(Tree->MPC_Var.Distribution == NO_NET) {
	    Tree->MPC_Var.Distribution = FKind==NODAL ? SINGLE_NODE : NetContext ;
	    Tree->MPC_Var.Flag.Distributed = FKind==NETWORK ||
					     Tree->MPC_Var.Distribution==COMPUTING_SPACE;
	  }
	  else if(FKind==BASIC && Tree->MPC_Var.Distribution==COMPUTING_SPACE)
	    Tree->MPC_Var.Flag.Distributed = YES;
	  else if(FKind==NODAL && Tree->MPC_Var.Distribution==SINGLE_NODE)
	    Tree->MPC_Var.Flag.Distributed = NO;
	  else if(Tree->MPC_Var.Flag.ExplDistr &&
		  !(FKind==BASIC && (Tree->MPC_Var.Distribution==HOST ||
				     Tree->MPC_Var.Distribution==COMPUTING_SPACE) ||
		    Is_PointerType(Tree->MPC_Var.Type) && Tree->MPC_Var.Type->
			MPC_PointerType.ElementType->Kind==kMPC_FunctionType)) {
	    RC = 1;
	    Make_Message(438, xxError, Tree->MPC_Var.Pos, Tree);
		/* "Invalid parameter declaration (declared with distribution)" */
	    Tree->MPC_Var.Flag.Ignore = YES;
	  }
	}
	if(Context==LOCAL_DECLS) {
	  if(Tree->MPC_Var.Distribution==NO_NET)
	    Tree->MPC_Var.Distribution = FKind==NODAL ? SINGLE_NODE : NetContext ;
	  if(FKind==NODAL && Tree->MPC_Var.Distribution!=SINGLE_NODE) {
	    RC = 1;
	    Make_Message(439, xxError, Tree->MPC_Var.Pos, Tree);
		/* "Distributed local variable in nodal function" */
	  }
	  else
	    Tree->MPC_Var.Flag.Distributed = YES;  /*** ??? ***/
	  if(FKind==NETWORK && Tree->MPC_Var.Distribution!=NetContext &&
	     Tree->MPC_Var.Distribution!=NetContext->MPC_NetOrSubnet.Distribution /*parent*/ &&
	     !(Tree->MPC_Var.Distribution->Kind==kMPC_Subnet &&
	       Is_Subnet(Tree->MPC_Var.Distribution,NetContext)) &&
	     !(Tree->MPC_Var.Type->Kind==kMPC_FunctionType &&
	       Tree->MPC_Var.Type->MPC_FunctionType.Kind==NODAL)
	    ) {
	    RC = 1;
	    Make_Message( 440, xxError, Tree->MPC_Var.Pos, Tree);
		/* "Invalid or missing distribution of local variable in network function" */
	  }
	  else
	    Tree->MPC_Var.Flag.Distributed = YES;
	  if(Tree->MPC_Var.Flag.Static &&
	     NetOrSubnet_Class(Tree->MPC_Var.Distribution)==AUTO) {
	    RC = 1;
	    Make_MessageI(441, xxError, Tree->MPC_Var.Pos,
			  xxIdent, (char*)&(Tree->MPC_Var.Ident), Tree);
		/* "Specifier of automatic net or subnet is used in declaration of following static variable" */
	  }
	}
	if(Context==GLOBAL_DECLS) {
 	  if(Tree->MPC_Var.Distribution==NO_NET)
	    Tree->MPC_Var.Distribution = SINGLE_NODE;
	  if(Tree->MPC_Var.Distribution!=NO_NET &&
	     Tree->MPC_Var.Distribution!=HOST)
	    Tree->MPC_Var.Flag.Distributed = YES;
	}
	/* Check initializer (INSERT ACTIONS!!!!): */
	{
	  tTree Type = Tree->MPC_Var.Type;
	  if(Type->Kind==kMPC_ArrayType &&
	     Type->MPC_ArrayType.NumberOfComponents==UNDEFINED &&
	     Tree->MPC_Var.Init!=NoTree && Tree->MPC_Var.Init->Kind==kMPC_InitList) {
	    Push_Pattern(Type);
	    TopType()->MPC_ArrayType.NumberOfComponents = Tree->MPC_Var.Init->MPC_InitList.Length;
	    Tree->MPC_Var.Type = Make_Type();
	  }
	}
	PatternRoot = Tree;
	Pattern = Tree->MPC_Var.Type;
	RC |= Go(Tree->MPC_Var.Init, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_Var.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_CoordDecl:
    /******************/
	TRACE("MPC_CoordDecl")
	if(!Tree->MPC_CoordDecl.Range->MPC_Expr.Flag.Ignore)
	  GO_TO_EXPR(Tree->MPC_CoordDecl.Range,Context,NetContext);
	if(Tree->MPC_CoordDecl.Range->MPC_Expr.Flag.Ignore) RC = 1;
        if(!Is_IntegralType(Tree->MPC_CoordDecl.Range->MPC_Expr.Type)) {
          Make_Message(498, xxError, Tree->MPC_CoordDecl.Range->MPC_Expr.Pos, Tree);
          /* "Not integral expression in coord declaration" */
          RC = 1;
        }
	if(Tree_IsType(Tree->MPC_CoordDecl.Prev,kMPC_FreeNode))
	  Tree->MPC_CoordDecl.CoordNumber = 0;
	else
	  Tree->MPC_CoordDecl.CoordNumber =
		Tree->MPC_CoordDecl.Prev->MPC_CoordDecl.CoordNumber + 1;
	RC |= Go(Tree->MPC_CoordDecl.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_Node:
    /*************/
	TRACE("MPC_Node")
	if(Tree->MPC_Node.Predicate) {  /* maybe 'default' !!! */
	  GO_TO_EXPR(Tree->MPC_Node.Predicate,Context,NetContext);
	}
	else {  /* "default" node declaration: */
	  /* check the case of "node { default: void; };"  */
          if(Tree->MPC_Node.Next->Kind==kMPC_FreeNode &&
	     Tree->MPC_Node.Prev->Kind==kMPC_FreeNode && /* no other node decls... */
	     Tree->MPC_Node.NodeType==VOID_NODE) {
	    RC = 1;
	    Make_Message(497, xxError, Tree->MPC_Node.Pos, Tree);
			 /* "Node declaration declares only void nodes" */
	  }
	}
	if(Tree->MPC_Node.DynamicType)
	  GO_TO_EXPR(Tree->MPC_Node.NodeQual->MPC_NodeQual.CapacityExpr,Context,NetContext);
	if(Tree->MPC_Node.NodeQual!=NoTree &&
	   Tree->MPC_Node.NodeQual->Kind==kMPC_BenchQual) {
	  if(RelativeNodes)
	    RC = 1,
	    Make_Message(442,xxError,Tree->MPC_Node.NodeQual->MPC_NodeQual.Pos,
			 Tree->MPC_Node.NodeQual);
		/* "Both absolute and relative node performances specified in one topology" */
	  else
	    AbsoluteNodes = true;
	}
	else if(Tree->MPC_Node.NodeQual!=NoTree &&
	   Tree->MPC_Node.NodeQual->Kind==kMPC_NodeTypeQual) {
	  if(AbsoluteNodes)
	    RC = 1,
	    Make_Message(442,xxError,Tree->MPC_Node.NodeQual->MPC_NodeQual.Pos,
			 Tree->MPC_Node.NodeQual);
		/* "Both absolute and relative node performances specified in one topology" */
	  else
	    RelativeNodes = true;
	}

	RC |= Go(Tree->MPC_Node.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_LinkDecl:
    /*****************/
	TRACE("MPC_LinkDecl")
	if(RelativeNodes || !AbsoluteNodes) {
	  DECL_Warning((482, xxWarning, Tree->MPC_LinkDecl.Pos, Tree));
		/* "Link declaration has no effect when relative node performance specified or when node declaration is absent" */
	}
	RC |= Go(Tree->MPC_LinkDecl.FreeCoord, Context, false, NetContext, FKind);
	FreeCoords = Tree->MPC_LinkDecl.FreeCoord;
	RC |= Go(Tree->MPC_LinkDecl.LinkDeclaringList, Context, false, NetContext, FKind);
	break;
    case kMPC_LinkDeclaringList:
    /**************************/
	TRACE("MPC_LinkDeclaringList")
	if(Tree->MPC_LinkDeclaringList.Predicate)
	  GO_TO_EXPR(Tree->MPC_LinkDeclaringList.Predicate,Context,NetContext);
	if(Tree->MPC_LinkDeclaringList.LinkLengthSpecifier!=NoTree
	   /**&& Tree->MPC_LinkDeclaringList.DynamicLength**/)
	  GO_TO_EXPR(Tree->MPC_LinkDeclaringList.LinkLengthSpecifier->MPC_LinkLengthSpecifier.LinkLengthExpr,Context,NetContext);
	RC |= Go(Tree->MPC_LinkDeclaringList.LinkDeclarator, Context,false,NetContext,FKind);
	RC |= Go(Tree->MPC_LinkDeclaringList.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_LinkDeclarator:
    /***********************/
	TRACE("MPC_LinkDeclarator")
	RC |= Go(Tree->MPC_LinkDeclarator.LeftNode, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_LinkDeclarator.RightNode, Context, false, NetContext, FKind);
	RC |= Go(Tree->MPC_LinkDeclarator.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_Scheme:
    /***************/
	TRACE("MPC_Scheme")
	if(RelativeNodes || !AbsoluteNodes) {
	  DECL_Warning((494, xxWarning, Tree->MPC_Scheme.Pos, Tree));
			/* "Scheme declaration has no effect when relative node performance specified"
			   " or when node declaration is absent"*/
	}
	RC |= Go(Tree->MPC_Scheme.Body, Context, false, NetContext, NODAL);
	break;
    case kMPC_NetList:
    /****************/
	TRACE("MPC_NetList")
	RC |= Go(Tree->MPC_NetList.Net, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_NetList.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_Net:
    /************/
	TRACE("MPC_Net")
	if(! Tree->MPC_Net.UniqueNumber) {
	  if(Context==LOCAL_DECLS && CurrentClass==STATIC) {
	    /* check on automatic parent net: */
	    tTree parentnet;
	    parentnet = Tree->MPC_Net.Distribution;
	    do {
	      if(NetOrSubnet_Class(parentnet)==AUTO) {
	        Make_Message(443, xxError, Tree->MPC_Net.Pos, Tree);
		             /* "The net is declared static but has automatic or flexible parent net(s)" */
	        RC = 1;
	        break;
	      }
	      parentnet = parentnet->MPC_Net.Distribution;
	    } while(parentnet);
	  }
	  Tree->MPC_Net.UniqueNumber = Make_UniqueNumber(Tree), Add_Net(Tree);
	  if(Tree->MPC_Net.Distribution==NO_NET)
	    Tree->MPC_Net.Distribution = HOST;
	  else if(Tree->MPC_Net.Distribution==COMPUTING_SPACE) {
	    Make_Message(444, xxError, Tree->MPC_Net.Pos, Tree);
		         /* "Invalid distribution [*] in net declaration" */
	    RC = 1;
	  }
	  else if(Tree->MPC_Net.Distribution!=HOST)
	    RC |= Go(Tree->MPC_Net.Distribution, Context, false, NetContext, FKind);
	  /* check the compatibility of Net.Distribution and of ALL Arg.StoreNet: */
	  {
	    tTree arg=Pattern;
	    while(arg!=NoTree && arg->Kind==kMPC_Exprs) {
	      if(!Is_Subnet(Tree->MPC_Net.Distribution, arg->MPC_Exprs.Expr->MPC_Expr.StoreNet)) {
	        Make_Message(445, xxError, Tree->MPC_Net.Pos, Tree);
		     /* "Distribution of the declared net and argument(s) of net type specifier are incompatible" */
	        RC = 1;
	        break;
	      }
	      arg = arg->MPC_Exprs.Next;
	    }
	  }
	  if(Tree->MPC_Net.Topology==UNDEFINED)
	    Tree->MPC_Net.Topology = CurrentTopology;
	}
	RC |= Go(Tree->MPC_Net.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_Subnet:
    /***************/
	TRACE("MPC_Subnet")
	if(! Tree->MPC_Subnet.UniqueNumber) {
	  if(CurrentClass==FLEXIBLE) Tree->MPC_Subnet.Flexible = -1 /*-true; */;
	  if(Context==LOCAL_DECLS && !Tree->MPC_Subnet.Flexible && CurrentClass==STATIC) {
	    /* check on automatic supernet: */
	    tTree supernet;
	    supernet = Tree->MPC_Subnet.Distribution;
	    do {
	      if(NetOrSubnet_Class(supernet)==AUTO) {
	        Make_Message(446, xxError, Tree->MPC_Subnet.Pos, Tree);
		            /* "The subnet is declared static but has automatic or flexible supernet(s)" */
	        RC = 1;
	        break;
	      }
	      supernet = supernet->MPC_Subnet.Distribution;
	    } while(supernet->Kind==kMPC_Subnet);
	  }
	  GO_TO_EXPR(Tree->MPC_Subnet.Predicate,PREDICATE,Tree->MPC_Subnet.Distribution);
	  if(Tree->MPC_Subnet.Predicate->MPC_Expr.Flag.Ignore)
	    RC = 1;
	  else {
	    Tree->MPC_Subnet.SingleNode = !Is_DistributedNet(Tree->MPC_Subnet.Distribution) &&
					  Is_SingleNode_Predicate(Tree /***->MPC_Subnet.Predicate***/);
	    Tree->MPC_Subnet.Predicate = Replace_Coords(Tree->MPC_Subnet.Predicate);
	  }
	  Tree->MPC_Subnet.UniqueNumber = Make_UniqueNumber(Tree);
	  Add_Net(Tree);
	}
	RC |= Go(Tree->MPC_Subnet.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_Relation:
    /*****************/
	TRACE("MPC_Relation")
	if(!(Tree->MPC_Relation.LNet!=NoTree &&
	     Tree_IsType(Tree->MPC_Relation.LNet, kMPC_NetOrSubnet))) {
	  RC = 1;
	  Make_MessageI(447, xxError, Tree->MPC_Relation.Pos, xxIdent,
			(char*)&(Tree->MPC_Relation.LNet->MPC_NetOrSubnet.Ident), Tree);
		/* "Identifier of net or subnet in left part of relation not declared" */
	}
	if(!(Tree->MPC_Relation.RNet!=NoTree &&
	     Tree_IsType(Tree->MPC_Relation.RNet, kMPC_NetOrSubnet))) {
	  RC = 1;
	  Make_MessageI(448, xxError, Tree->MPC_Relation.Pos, xxIdent,
			(char*)&(Tree->MPC_Relation.RNet->MPC_NetOrSubnet.Ident), Tree);
		/* "Identifier of net or subnet in right part of relation not declared" */
	}
	if(!RC) {
	  int RelCode;
	  switch(Tree->MPC_Relation.RelCode) {
	    case EQUAL:		RelCode = EQUAL_NET; break;
	    case NOT_EQUAL:	RelCode = NO_RELATION; break;
	    case GREAT_THEN:
	    case GREAT_OR_EQ:	RelCode = SUPERNET; break;
	    case LESS_THEN:
	    case LESS_OR_EQ:	RelCode = SUBNET; break;
	    default:
		CompilerError("Invalid 'RelCode' in MPC_Relation", Tree->MPC_Relation.Pos);
		exit(1);
	  }
	  RC |= Set_Relation(
			RelCode, Tree->MPC_Relation.LNet,
			Tree->MPC_Relation.RNet, Tree->MPC_Relation.Pos
		);
	}
	RC |= Go(Tree->MPC_Relation.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_ExprStat:
    /*****************/
	TRACE("MPC_ExprStat")
	CHECK_TRANSIT(Tree->MPC_ExprStat)
	if(Tree->MPC_ExprStat.Expr) {
	  if(Tree->MPC_ExprStat.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Tree->MPC_Stat.Flag.Ignore = YES;
	  }
	  CHECK_TRANSIT(Tree->MPC_ExprStat)
	  agNetContext =  (Tree->MPC_Stat.ExecNet!=NoTree &&
			   Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			  (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_ExprStat.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_ExprStat.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expr. */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  CHECK_TRANSIT(Tree->MPC_ExprStat)
	  REMAKE_IF_BLOCKING(&Tree->MPC_ExprStat.Expr);
	  Tree->MPC_Stat.ExecNet = Tree->MPC_ExprStat.Expr->MPC_Expr.EvalNet;
	  if(Tree->MPC_ExprStat.Expr->MPC_Expr.Flag.Distributed)
	    Tree->MPC_ExprStat.Flag.Distributed = YES;
	  if(Tree->MPC_ExprStat.Expr->MPC_Expr.Flag.Asynchr)
	    Tree->MPC_ExprStat.Flag.Asynchr = YES;
	  if(Tree->MPC_ExprStat.Expr->MPC_Expr.Flag.PartAsynchr)
	    Tree->MPC_ExprStat.Flag.PartAsynchr = YES;
	}
	else {  /* empty statement: */
	  if(Tree->MPC_Stat.ExecNet==NoTree || Tree->MPC_Stat.ExecNet->Kind!=kMPC_NetList)
	    Tree->MPC_Stat.ExecNet = CONST_NET_LIST;
	  Tree->MPC_Stat.Flag.Distributed = YES;
	  Tree->MPC_Stat.Flag.Asynchr = YES;
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_If:
    /***********/
	TRACE("MPC_If")
	CHECK_TRANSIT(Tree->MPC_If)
	Save_ReturnStatus = No_ReturnStats;
	if(Tree->MPC_If.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	else {
	  agNetContext = (Tree->MPC_Stat.ExecNet!=NoTree &&
			  Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			 (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_If.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_If.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else if(!Is_ScalarType(Tree->MPC_If.Expr->MPC_Expr.Type)) {
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(602, xxError,
                         SourcePosition(Tree->MPC_If.Expr->MPC_Expr.Pos, Tree->MPC_If.Expr),
			 Tree->MPC_If.Expr);
		/* "Expression in selection statement has not a scalar type" */
	  }
	  else if(Tree->MPC_If.Expr->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_If.Expr->MPC_Expr.Repl &&
		    Tree->MPC_If.Expr->MPC_Expr.StoreNet==NetContext))
	    No_ReturnStats++,
	    ControlExpr = (ControlExpr==NoTree ? Tree->MPC_If.Expr : ControlExpr);
	}
	REMAKE_IF_BLOCKING(&Tree->MPC_If.Expr);
	RC |= Go(Tree->MPC_If.Stats, Context/*STATS*/, NetPossible, NetContext, FKind);
	No_ReturnStats = Save_ReturnStatus;
	Set_StatErrorFlag(Tree);
	if(!No_ReturnStats) ControlExpr = NoTree;
	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree expr_netlist, stat_netlist;
	  expr_netlist = Make_NetList(Tree->MPC_If.Expr->MPC_Expr.StoreNet);
	  stat_netlist = Tree->MPC_If.Stats->MPC_Stat.ExecNet;
	  Eval_StatDistribution(
		Tree, Tree->MPC_If.Expr->MPC_Expr.Repl,
		expr_netlist, Tree->MPC_If.Expr->MPC_Expr.EvalNet,
		&(Tree->MPC_If.Expr->MPC_Expr.Flag),
		stat_netlist, &(Tree->MPC_If.Stats->MPC_Stat.Flag)
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  if(Tree->MPC_Stat.ExecNet!=expr_netlist) Release_NetList(expr_netlist);
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_IfElse:
    /***************/
	TRACE("MPC_IfElse")
	CHECK_TRANSIT(Tree->MPC_IfElse)
	Save_ReturnStatus = No_ReturnStats;
	if(Tree->MPC_IfElse.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	else {
	  agNetContext = (Tree->MPC_Stat.ExecNet!=NoTree &&
			  Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			 (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_IfElse.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_IfElse.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else if(!Is_ScalarType(Tree->MPC_IfElse.Expr->MPC_Expr.Type)) {
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(602, xxError,
                         SourcePosition(Tree->MPC_IfElse.Expr->MPC_Expr.Pos, Tree->MPC_IfElse.Expr),
			 Tree->MPC_IfElse.Expr);
		/* "Expression in selection statement has not a scalar type" */
	  }
	  else if(Tree->MPC_IfElse.Expr->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_IfElse.Expr->MPC_Expr.Repl &&
		    Tree->MPC_IfElse.Expr->MPC_Expr.StoreNet==NetContext))
	    No_ReturnStats++,
	    ControlExpr = (ControlExpr==NoTree ? Tree->MPC_IfElse.Expr : ControlExpr);

	}
	REMAKE_IF_BLOCKING(&Tree->MPC_IfElse.Expr);
	RC |= Go(Tree->MPC_IfElse.Then, Context/*STATS*/, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_IfElse.Else, Context/*STATS*/, NetPossible, NetContext, FKind);
	No_ReturnStats = Save_ReturnStatus;
	Set_StatErrorFlag(Tree);
	if(!No_ReturnStats) ControlExpr = NoTree;
	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree expr_netlist, stat_netlist;
	  tStatFlags stat_flag;
	  expr_netlist = Make_NetList(Tree->MPC_IfElse.Expr->MPC_Expr.StoreNet);
	  stat_netlist = Join_NetList(
				Tree->MPC_IfElse.Then->MPC_Stat.ExecNet,
				Tree->MPC_IfElse.Else->MPC_Stat.ExecNet
			 );
	  stat_flag = Tree->MPC_IfElse.Then->MPC_Stat.Flag;
	  stat_flag.Distributed |= Tree->MPC_IfElse.Else->MPC_Stat.Flag.Distributed;
	  stat_flag.Asynchr &= Tree->MPC_IfElse.Else->MPC_Stat.Flag.Asynchr;
	  stat_flag.PartAsynchr =
		stat_flag.Asynchr && Tree->MPC_IfElse.Else->MPC_Stat.Flag.PartAsynchr ||
		stat_flag.PartAsynchr && Tree->MPC_IfElse.Else->MPC_Stat.Flag.Asynchr ||
		stat_flag.PartAsynchr && Tree->MPC_IfElse.Else->MPC_Stat.Flag.PartAsynchr;
	  Eval_StatDistribution(
		Tree, Tree->MPC_IfElse.Expr->MPC_Expr.Repl,
		expr_netlist, Tree->MPC_IfElse.Expr->MPC_Expr.EvalNet,
		&(Tree->MPC_IfElse.Expr->MPC_Expr.Flag),
		stat_netlist, &stat_flag
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  if(Tree->MPC_Stat.ExecNet!=expr_netlist) Release_NetList(expr_netlist);
	  if(Tree->MPC_Stat.ExecNet!=stat_netlist) Release_NetList(stat_netlist);
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Switch:
    /***************/
	TRACE("MPC_Switch")
	CHECK_TRANSIT(Tree->MPC_Switch)
	Save_ReturnStatus = No_ReturnStats;
	if(Tree->MPC_Switch.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	else {
	  agNetContext = (Tree->MPC_Stat.ExecNet!=NoTree &&
			  Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			 (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_Switch.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_Switch.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else if(!Is_IntegralType(Tree->MPC_Switch.Expr->MPC_Expr.Type)) {
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(603, xxError,
                         SourcePosition(Tree->MPC_Switch.Expr->MPC_Expr.Pos, Tree->MPC_Switch.Expr),
			 Tree->MPC_Switch.Expr);
		/* "Expression in switch statement has not integral type" */
	  }
	  else if(Tree->MPC_Switch.Expr->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_Switch.Expr->MPC_Expr.Repl &&
		    Tree->MPC_Switch.Expr->MPC_Expr.StoreNet==NetContext))
	    No_ReturnStats++,
	    ControlExpr = (ControlExpr==NoTree ? Tree->MPC_Switch.Expr : ControlExpr);

	}
	REMAKE_IF_BLOCKING(&Tree->MPC_Switch.Expr);
	BreakPossible++;
	RC |= Go(Tree->MPC_Switch.Stats, Context/*STATS*/, NetPossible, NetContext, FKind);
	BreakPossible--;
	Set_StatErrorFlag(Tree);
	No_ReturnStats = Save_ReturnStatus;
	if(!No_ReturnStats) ControlExpr = NoTree;
	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree expr_netlist, stat_netlist;
	  expr_netlist = Make_NetList(Tree->MPC_Switch.Expr->MPC_Expr.StoreNet);
	  stat_netlist = Tree->MPC_Switch.Stats->MPC_Stat.ExecNet;
	  Eval_StatDistribution(
		Tree, Tree->MPC_Switch.Expr->MPC_Expr.Repl,
		expr_netlist, Tree->MPC_Switch.Expr->MPC_Expr.EvalNet,
		&(Tree->MPC_Switch.Expr->MPC_Expr.Flag),
		stat_netlist, &(Tree->MPC_Switch.Stats->MPC_Stat.Flag)
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  if(Tree->MPC_Stat.ExecNet!=expr_netlist) Release_NetList(expr_netlist);
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_While:
    /**************/
	TRACE("MPC_While")
	CHECK_TRANSIT(Tree->MPC_While)
	Save_ReturnStatus = No_ReturnStats;
	if(Tree->MPC_While.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	else {
	  agNetContext = (Tree->MPC_Stat.ExecNet!=NoTree &&
			  Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			 (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_While.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_While.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else if(!Is_ScalarType(Tree->MPC_While.Expr->MPC_Expr.Type)) {
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(604, xxError,
                         SourcePosition(Tree->MPC_While.Expr->MPC_Expr.Pos, Tree->MPC_While.Expr),
			 Tree->MPC_While.Expr);
		/* "Expression in iteration statement has not scalar type" */
	  }
	  else if(Tree->MPC_While.Expr->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_While.Expr->MPC_Expr.Repl &&
		    Tree->MPC_While.Expr->MPC_Expr.StoreNet==NetContext))
	    No_ReturnStats++,
	    ControlExpr = (ControlExpr==NoTree ? Tree->MPC_While.Expr : ControlExpr);

	}
	REMAKE_IF_BLOCKING(&Tree->MPC_While.Expr);
	BreakPossible++;
	ContinuePossible++;
	RC |= Go(Tree->MPC_While.Stats, Context/*STATS*/, NetPossible, NetContext, FKind);
	ContinuePossible--;
	BreakPossible--;
	Set_StatErrorFlag(Tree);
	No_ReturnStats = Save_ReturnStatus;
	if(!No_ReturnStats) ControlExpr = NoTree;
	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree expr_netlist, stat_netlist;
	  expr_netlist = Make_NetList(Tree->MPC_While.Expr->MPC_Expr.StoreNet);
	  stat_netlist = Tree->MPC_While.Stats->MPC_Stat.ExecNet;
	  Eval_StatDistribution(
		Tree, Tree->MPC_While.Expr->MPC_Expr.Repl,
		expr_netlist, Tree->MPC_While.Expr->MPC_Expr.EvalNet,
		&(Tree->MPC_While.Expr->MPC_Expr.Flag),
		stat_netlist, &(Tree->MPC_While.Stats->MPC_Stat.Flag)
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  if(Tree->MPC_Stat.ExecNet!=expr_netlist) Release_NetList(expr_netlist);
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_DoWhile:
    /****************/
	TRACE("MPC_DoWhile")
	CHECK_TRANSIT(Tree->MPC_DoWhile)
	Save_ReturnStatus = No_ReturnStats;
	if(Tree->MPC_DoWhile.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	CHECK_TRANSIT(Tree->MPC_DoWhile)
	agNetContext = 	(Tree->MPC_Stat.ExecNet!=NoTree &&
			 Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			(Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	GO_TO_EXPR(Tree->MPC_DoWhile.Expr,Context/*STATS*/,agNetContext);
	if(Tree->MPC_DoWhile.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	else if(!Is_ScalarType(Tree->MPC_DoWhile.Expr->MPC_Expr.Type)) {
	  Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	  Make_Message(604, xxError,
                         SourcePosition(Tree->MPC_DoWhile.Expr->MPC_Expr.Pos, Tree->MPC_DoWhile.Expr),
			Tree->MPC_DoWhile.Expr);
		/* "Expression in iteration statement has not scalar type" */
	}
	else if(Tree->MPC_DoWhile.Expr->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_DoWhile.Expr->MPC_Expr.Repl &&
		    Tree->MPC_DoWhile.Expr->MPC_Expr.StoreNet==NetContext)) {
	    No_ReturnStats++,
	    ControlExpr = (ControlExpr==NoTree ? Tree->MPC_DoWhile.Expr : ControlExpr);
	}
	REMAKE_IF_BLOCKING(&Tree->MPC_DoWhile.Expr);

	BreakPossible++;
	ContinuePossible++;
	RC |= Go(Tree->MPC_DoWhile.Stats, Context/*STATS*/, NetPossible, NetContext, FKind);
	ContinuePossible--;
	BreakPossible--;
	Set_StatErrorFlag(Tree);
	No_ReturnStats = Save_ReturnStatus;
	if(!No_ReturnStats) ControlExpr = NoTree;

	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree expr_netlist, stat_netlist;
	  expr_netlist = Make_NetList(Tree->MPC_DoWhile.Expr->MPC_Expr.StoreNet);
	  stat_netlist = Tree->MPC_DoWhile.Stats->MPC_Stat.ExecNet;
	  Eval_StatDistribution(
		Tree, Tree->MPC_DoWhile.Expr->MPC_Expr.Repl,
		expr_netlist, Tree->MPC_DoWhile.Expr->MPC_Expr.EvalNet,
		&(Tree->MPC_DoWhile.Expr->MPC_Expr.Flag),
		stat_netlist, &(Tree->MPC_DoWhile.Stats->MPC_Stat.Flag)
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  if(Tree->MPC_Stat.ExecNet!=expr_netlist) Release_NetList(expr_netlist);
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_For:
    /************/
	TRACE("MPC_For")
	CHECK_TRANSIT(Tree->MPC_For)
	Save_ReturnStatus = No_ReturnStats;
	agNetContext = (Tree->MPC_Stat.ExecNet!=NoTree &&
			Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
		       (Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	if(Tree->MPC_For.Init) {  /* not empty expression: */
	  if(Tree->MPC_For.Init->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_For.Init,Context/*STATS*/,agNetContext);
	    if(Tree->MPC_For.Init->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_For.Init->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(604, xxError,
                           SourcePosition(Tree->MPC_For.Init->MPC_Expr.Pos, Tree->MPC_For.Init),
			   Tree->MPC_For.Init);
		/* "Expression in iteration statement has not scalar type" */
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_For.Init);
	  }
	}   /* end 'Init' */
	if(Tree->MPC_For.Cond) {  /* not empty expression: */
	  if(Tree->MPC_For.Cond->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_For.Cond,Context/*STATS*/,agNetContext);
	    if(Tree->MPC_For.Cond->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_For.Cond->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(604, xxError,
                           SourcePosition(Tree->MPC_For.Cond->MPC_Expr.Pos, Tree->MPC_For.Cond),
			   Tree->MPC_For.Cond);
		/* "Expression in iteration statement has not scalar type" */
	    }
	    else if(Tree->MPC_For.Cond->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_For.Cond->MPC_Expr.Repl &&
		    Tree->MPC_For.Cond->MPC_Expr.StoreNet==NetContext)) {
	      No_ReturnStats++,
	      ControlExpr = (ControlExpr==NoTree ? Tree->MPC_For.Cond : ControlExpr);
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_For.Cond);

	  }
	}   /* end 'Cond' */
	if(Tree->MPC_For.Reinit) {  /* not empty expression: */
	  if(Tree->MPC_For.Reinit->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_For.Reinit,Context/*STATS*/,agNetContext);
	    if(Tree->MPC_For.Reinit->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_For.Reinit->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(604, xxError,
                           SourcePosition(Tree->MPC_For.Reinit->MPC_Expr.Pos, Tree->MPC_For.Reinit),
			   Tree->MPC_For.Reinit);
		/* "Expression in iteration statement has not scalar type" */
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_For.Reinit);
	  }
	}   /* end 'Reinit' */
	BreakPossible++;
	ContinuePossible++;
	RC |= Go(Tree->MPC_For.Stats, Context/*STATS*/, NetPossible, NetContext, FKind);
	ContinuePossible--;
	BreakPossible--;
	Set_StatErrorFlag(Tree);
	No_ReturnStats = Save_ReturnStatus;
	if(!No_ReturnStats) ControlExpr = NoTree;
	/****************************/
	if(!Tree->MPC_Stat.Flag.Ignore) {  /* check & evaluate distribution: */
	  tTree e1_netlist, e2_netlist, e3_netlist, stat_netlist, tmp;
	  bool repl = false;
	  tExprFlags expr_flag = NoExprFlag;
	  tStatFlags stat_flag;
	  if(Tree->MPC_For.Init)
	    e1_netlist = Make_NetList(Tree->MPC_For.Init->MPC_Expr.StoreNet);
	  else
	    e1_netlist = CONST_NET_LIST;
	  if(Tree->MPC_For.Cond) {
	    e2_netlist = Make_NetList(Tree->MPC_For.Cond->MPC_Expr.StoreNet);
	    repl = Tree->MPC_For.Cond->MPC_Expr.Repl;
	    expr_flag = Tree->MPC_For.Cond->MPC_Expr.Flag;
	  }else
	    e2_netlist = CONST_NET_LIST, repl = true;
	  if(Tree->MPC_For.Reinit)
	    e3_netlist = Make_NetList(Tree->MPC_For.Reinit->MPC_Expr.StoreNet);
	  else
	    e3_netlist = CONST_NET_LIST;
	  stat_netlist = Join_NetList(
				Tree->MPC_For.Stats->MPC_Stat.ExecNet, e3_netlist
			 );
	  stat_flag = Tree->MPC_For.Stats->MPC_Stat.Flag;
	  if(Tree->MPC_For.Reinit) {
	    stat_flag.Distributed |= Tree->MPC_For.Reinit->MPC_Expr.Flag.Distributed;
	    stat_flag.Asynchr &= Tree->MPC_For.Reinit->MPC_Expr.Flag.Asynchr;
	    stat_flag.PartAsynchr =
		stat_flag.Asynchr && Tree->MPC_For.Reinit->MPC_Expr.Flag.PartAsynchr ||
		stat_flag.PartAsynchr && Tree->MPC_For.Reinit->MPC_Expr.Flag.Asynchr ||
		stat_flag.PartAsynchr && Tree->MPC_For.Reinit->MPC_Expr.Flag.PartAsynchr;
	  }
	  Eval_StatDistribution(  /* of equivalent while statement without Init-expr; */
		Tree, repl, e2_netlist,
		(Tree->MPC_For.Cond ? Tree->MPC_For.Cond->MPC_Expr.EvalNet : CONST_NET_LIST),
		&expr_flag, stat_netlist, &stat_flag
	  );
	  RC |= Tree->MPC_Stat.Flag.Ignore;
	  Tree->MPC_Stat.ExecNet = Join_NetList(Tree->MPC_Stat.ExecNet, e1_netlist);
	  if(Tree->MPC_For.Init) {
	    Tree->MPC_Stat.Flag.Asynchr &= Tree->MPC_For.Init->MPC_Expr.Flag.Asynchr;
	    Tree->MPC_Stat.Flag.PartAsynchr =
		Tree->MPC_Stat.Flag.Asynchr&&Tree->MPC_For.Init->MPC_Expr.Flag.PartAsynchr ||
		Tree->MPC_Stat.Flag.PartAsynchr&&Tree->MPC_For.Init->MPC_Expr.Flag.Asynchr ||
		Tree->MPC_Stat.Flag.PartAsynchr&&Tree->MPC_For.Init->MPC_Expr.Flag.PartAsynchr;
	    if(Tree->MPC_Stat.ExecNet!=e1_netlist) Release_NetList(e1_netlist);
	  }
	  if(Tree->MPC_Stat.ExecNet!=e2_netlist) Release_NetList(e2_netlist);
	  if(Tree->MPC_Stat.ExecNet!=e3_netlist) Release_NetList(e3_netlist);
	  if(!(stat_netlist==Tree->MPC_For.Stats->MPC_Stat.ExecNet ||
	       stat_netlist==e3_netlist)) {
	    tmp = stat_netlist;
	    while(tmp->Kind==kMPC_NetList) {
	      tmp->MPC_NetList.Net = NoTree;
	      tmp = tmp->MPC_NetList.Next;
	    }
	    if(Tree->MPC_Stat.ExecNet!=stat_netlist) Release_NetList(stat_netlist);
	  }
	}
	/****************************/
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;

    case kMPC_Goto:
    /*************/
	TRACE("MPC_Goto")
	CHECK_TRANSIT(Tree->MPC_Goto)
	{
	  tTree label=CurrentFunction->MPC_Function.LabelList;
	  while(label) {
	    if(label->MPC_IdentLabel.Ident==Tree->MPC_Goto.Ident) {
	      Tree->MPC_Goto.LabelDef = label;
	      label->MPC_IdentLabel.Used = true;
	      break;
	    }
	    label = label->MPC_Label.NextLabel;
	  }
	  if(label==NoTree) {
	    Make_MessageI(605, xxError, Tree->MPC_Stat.Pos, xxIdent,
			  (char*)&(Tree->MPC_Goto.Ident), Tree);
		/* "Label undeclared" */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    RC = 1;
	  }

	  if(Tree->MPC_Stat.ExecNet!=NoTree &&
	     !Tree->MPC_Stat.ExecNet->MPC_NetOrSubnet.SingleNode ||
	     FKind==BASIC || FKind==NETWORK && !NetContext->MPC_NetOrSubnet.SingleNode)
	    Tree->MPC_Stat.Flag.Distributed = YES , Tree->MPC_Stat.Flag.Asynchr = YES;
	  if(!Tree->MPC_Stat.ExecNet)
	    Tree->MPC_Stat.ExecNet = Make_NetList(NetContext); /** !!!!!!!! **/
	  else if(FKind==NODAL && Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) {
	    Make_Message(606, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Invalid distributed 'goto' inside of nodal function" */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    RC = 1;
	  }
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Continue:
    /*****************/
	TRACE("MPC_Continue")
	CHECK_TRANSIT(Tree->MPC_Continue)
	if(!ContinuePossible) {
	  Make_Message(607, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "'continue' outside of iteration statement" */
	  RC = 1;
	  Tree->MPC_Stat.Flag.Ignore = YES;
	} 
	if(Tree->MPC_Stat.ExecNet!=NoTree &&
	   !Tree->MPC_Stat.ExecNet->MPC_NetOrSubnet.SingleNode ||
	   FKind==BASIC || FKind==NETWORK && !NetContext->MPC_NetOrSubnet.SingleNode)
	  Tree->MPC_Stat.Flag.Distributed = YES , Tree->MPC_Stat.Flag.Asynchr = YES;
	if(!Tree->MPC_Stat.ExecNet)
	  Tree->MPC_Stat.ExecNet = Make_NetList(NetContext); /** !!!!!!!! **/
	else if(FKind==NODAL && Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) {
	  Make_Message(608, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Invalid distributed 'continue' inside of nodal function" */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Break:
    /**************/
	TRACE("MPC_Break")
	CHECK_TRANSIT(Tree->MPC_Break)
	if(!BreakPossible) {
	  Make_Message(609, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "'break' outside of 'switch' or iteration statement" */
	  RC = 1;
	  Tree->MPC_Stat.Flag.Ignore = YES;
	} 
	if(Tree->MPC_Stat.ExecNet!=NoTree &&
	   !Tree->MPC_Stat.ExecNet->MPC_NetOrSubnet.SingleNode ||
	   FKind==BASIC || FKind==NETWORK && !NetContext->MPC_NetOrSubnet.SingleNode)
	  Tree->MPC_Stat.Flag.Distributed = YES , Tree->MPC_Stat.Flag.Asynchr = YES;
	if(!Tree->MPC_Stat.ExecNet)
	  Tree->MPC_Stat.ExecNet = Make_NetList(NetContext); /** !!!!!!!! **/
	else if(FKind==NODAL && Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) {
	  Make_Message(610, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Invalid distributed 'break' inside of nodal function" */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_BreakFan:
    /*****************/
	TRACE("MPC_BreakFan")
	CHECK_TRANSIT(Tree->MPC_BreakFan)
	if(!BreakFanPossible) {
	  Make_Message(611, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "'break?' outside of 'fan' statement" */
	  RC = 1;
	  Tree->MPC_Stat.Flag.Ignore = YES;
	}
	if(Tree->MPC_Stat.ExecNet!=NoTree &&
	   !Tree->MPC_Stat.ExecNet->MPC_NetOrSubnet.SingleNode ||
	   FKind==BASIC || FKind==NETWORK && !NetContext->MPC_NetOrSubnet.SingleNode)
	  Tree->MPC_Stat.Flag.Distributed = YES , Tree->MPC_Stat.Flag.Asynchr = YES;
 	if(!Tree->MPC_Stat.ExecNet)
	  Tree->MPC_Stat.ExecNet = Make_NetList(NetContext); /** !!!!!!!! **/
	else if(FKind==NODAL && Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) {
	  Make_Message(612, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Invalid distributed 'break?' inside of nodal function" */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Return:
    /***************/
	TRACE("MPC_Return")
	CHECK_TRANSIT(Tree->MPC_Return)
	if(No_ReturnStats) {
	  tPosition rpos;
	  if(ControlExpr==NoTree)
	    CompilerError("Cannot check this statement (invalid internal data)",
			  Tree->MPC_Stat.Pos);
	  rpos = RealPosition(ControlExpr->MPC_Expr.Pos);
	  Make_Message(613, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Forbidden 'return' inside of selection or iteration statement" */
	  if(FKind==BASIC)
	    Make_Message(8, xxInformation, Tree->MPC_Stat.Pos, Tree);
		/* "   Maybe the control expression of selection/iteration statement inside of basic function is not replicated or not [*]-distributed" */
	  else if(FKind==NETWORK)
	    Make_Message(9, xxInformation, Tree->MPC_Stat.Pos, Tree);
		/* "   Maybe the control expression of selection/iteration statement inside of network function is not replicated or its distribution is subnet of the network parameter" */
	  Make_MessageI(10, xxInformation, Tree->MPC_Stat.Pos, xxShort, (char*)&(rpos.Line), Tree);
		/* "   This control expression is located in line" */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	if(Tree->MPC_Stat.ExecNet!=NoTree && Tree->MPC_Stat.ExecNet!=ErrorNetList) {
	  Make_Message(614, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "Invalid distributed 'return' statement (with net/subnet specifier)" */
	  Tree->MPC_Stat.Flag.Ignore = YES;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	}
	if(Tree->MPC_Return.Expr) {
	  if(Tree->MPC_Return.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  CHECK_TRANSIT(Tree->MPC_Return)
	  agNetContext=	(Tree->MPC_Stat.ExecNet!=NoTree &&
			 Tree->MPC_Stat.ExecNet!=SINGLE_NODE_LIST) ?
			(Tree->MPC_Stat.ExecNet->MPC_NetList.Net) : NetContext ;
	  GO_TO_EXPR(Tree->MPC_Return.Expr,Context/*STATS*/,agNetContext);
	  if(Tree->MPC_Return.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  CHECK_TRANSIT(Tree->MPC_Return);
	  REMAKE_IF_BLOCKING(&Tree->MPC_Return.Expr);
	  if(Tree->MPC_Return.Expr->MPC_Expr.StoreNet!=NetContext &&
	     Tree->MPC_Return.Expr->MPC_Expr.StoreNet!=CONST_NET) {
	    Tree->MPC_Return.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(615, xxError,
                         SourcePosition(Tree->MPC_Return.Expr->MPC_Expr.Pos, Tree->MPC_Return.Expr),
                         Tree);
		/* "Invalid distribution of expression in return statement" */
	  }
	  if(Tree->MPC_Return.Expr->MPC_Expr.StoreNet==CONST_NET) {
	    Tree->MPC_Stat.ExecNet = Make_NetList(NetContext);
	    if(!NetContext->MPC_NetOrSubnet.SingleNode)
	      Tree->MPC_Return.Flag.Distributed = YES;
	  }
	  else {
	    Tree->MPC_Stat.ExecNet = Tree->MPC_Return.Expr->MPC_Expr.EvalNet;
	    if(Tree->MPC_Return.Expr->MPC_Expr.Flag.Distributed)
	      Tree->MPC_Return.Flag.Distributed = YES;
	  }
	  if(Tree->MPC_Return.Expr->MPC_Expr.Flag.Asynchr)
	    Tree->MPC_Return.Flag.Asynchr = YES;
	  if(Tree->MPC_Return.Expr->MPC_Expr.Flag.PartAsynchr)
	    Tree->MPC_Return.Flag.PartAsynchr = YES;
	  if(CurrentFunction->MPC_Function.Type->MPC_FunctionType.ResultType->MPC_Type.Flag.Repl &&
	     !Tree->MPC_Return.Expr->MPC_Expr.Repl) {
	    Tree->MPC_Stat.Flag.Ignore = YES;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	    Make_Message(616, xxError,
                         SourcePosition(Tree->MPC_Return.Expr->MPC_Expr.Pos,Tree->MPC_Return.Expr),
                         Tree);
		/* "Invalid type of expression in return statement" */
	    Make_Message(11, xxInformation,
                         SourcePosition(Tree->MPC_Return.Expr->MPC_Expr.Pos,Tree->MPC_Return.Expr),
                         Tree);
		/* "   (This function must return only replicated value)" */
	  }
	}
	else {
	  Tree->MPC_Stat.ExecNet = Make_NetList(NetContext);
	  Tree->MPC_Stat.Flag.Distributed =
		NetContext!=HOST && NetContext!=SINGLE_NODE;
	  Tree->MPC_Stat.Flag.Asynchr = YES;
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Compound:
    /*****************/
	TRACE("MPC_Compound")
	CHECK_TRANSIT(Tree->MPC_Compound)
	if(!Tree->MPC_Compound.UniqueNumber)
	  Tree->MPC_Compound.UniqueNumber = Make_UniqueNumber(Tree);
	if(!Tree->MPC_Compound.ExecNet) {
	  if(FKind==BASIC) Tree->MPC_Stat.ExecNet = COMPUTING_SPACE_LIST;
	  if(FKind==NODAL) Tree->MPC_Stat.ExecNet = SINGLE_NODE_LIST;
	  if(FKind==NETWORK) {
	    tTree tmp;
	    tmp = mMPC_FreeNode(Tree);
	    Tree->MPC_Stat.ExecNet =
		Clean_OutAttributes( mMPC_NetList(tmp, tmp, NetContext) );
	  }
	}

	RC |= Go(Tree->MPC_Compound.Decls, LOCAL_DECLS, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Compound.Stats, Context, NetPossible, NetContext, FKind);
	Set_StatErrorFlag(Tree);
	Check_On_NetDefinitions(Tree);
	if(!Tree->MPC_Compound.FunctionBody)
	  Tree->MPC_Stat.ExecNet = Eval_Block_Distribution(Tree);
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_CompScheme:
    /*******************/
	TRACE("MPC_CompScheme")
	if(Context!=SCHEME_DECL) {
	  RC = 1;
	  Tree->MPC_Stat.Flag.Ignore = YES;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	  Make_Message(627, xxError, Tree->MPC_Stat.Pos, Tree);
		       /* "'%%' statement outside of scheme declaration" */
	}
	else {
	  if(Tree->MPC_CompScheme.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_CompScheme.Expr,SCHEME_DECL/*STATS*/,SINGLE_NODE);
	    if(Tree->MPC_CompScheme.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else {
	      Go(Tree->MPC_CompScheme.Node, SCHEME_DECL, false, SINGLE_NODE, NODAL);
	    }
	  }
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_CommScheme:
    /*******************/
	TRACE("MPC_CommScheme")
	if(Context!=SCHEME_DECL) {
	  RC = 1;
	  Tree->MPC_Stat.Flag.Ignore = YES;
	  Tree->MPC_Stat.ExecNet = ErrorNetList;
	  Make_Message(627, xxError, Tree->MPC_Stat.Pos, Tree);
		       /* "'%%' statement outside of scheme declaration" */
	}
	else {
	  if(Tree->MPC_CommScheme.Expr->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_CommScheme.Expr,SCHEME_DECL/*STATS*/,SINGLE_NODE);
	    if(Tree->MPC_CommScheme.Expr->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else {
	      Go(Tree->MPC_CommScheme.From, SCHEME_DECL, false, SINGLE_NODE, NODAL);
	      Go(Tree->MPC_CommScheme.To,   SCHEME_DECL, false, SINGLE_NODE, NODAL);
	    }
	  }
	}
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_ParScheme:
    /******************/
	TRACE("MPC_ParScheme")
	if(Context!=SCHEME_DECL) {
	  RC = 1;
	  Make_Message(628, xxError, Tree->MPC_Stat.Pos, Tree);
		      /* "'par' statement outside of scheme declaration" */
	}
	CHECK_TRANSIT(Tree->MPC_ParScheme)
	Save_ReturnStatus = No_ReturnStats;
	agNetContext = SINGLE_NODE;
	if(Tree->MPC_ParScheme.Init) {  /* not empty expression: */
	  if(Tree->MPC_ParScheme.Init->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_ParScheme.Init,SCHEME_DECL/*STATS*/,agNetContext);
	    if(Tree->MPC_ParScheme.Init->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_ParScheme.Init->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(629, xxError,
                           SourcePosition(Tree->MPC_ParScheme.Init->MPC_Expr.Pos,Tree->MPC_ParScheme.Init),
                           Tree->MPC_ParScheme.Init);
			   /* "Expression in 'par' statement has not scalar type" */
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_ParScheme.Init);
	  }
	}   /* end 'Init' */
	if(Tree->MPC_ParScheme.Cond) {  /* not empty expression: */
	  if(Tree->MPC_ParScheme.Cond->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_ParScheme.Cond,SCHEME_DECL/*STATS*/,agNetContext);
	    if(Tree->MPC_ParScheme.Cond->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_ParScheme.Cond->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(629, xxError,
                           SourcePosition(Tree->MPC_ParScheme.Cond->MPC_Expr.Pos,Tree->MPC_ParScheme.Cond),
                           Tree->MPC_ParScheme.Cond);
			   /* "Expression in 'par' statement has not scalar type" */
	    }
	    else if(Tree->MPC_ParScheme.Cond->MPC_Expr.Flag.Distributed &&
		  !(Tree->MPC_ParScheme.Cond->MPC_Expr.Repl &&
		    Tree->MPC_ParScheme.Cond->MPC_Expr.StoreNet==NetContext)) {
	      No_ReturnStats++,
	      ControlExpr = (ControlExpr==NoTree ? Tree->MPC_ParScheme.Cond : ControlExpr);
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_ParScheme.Cond);

	  }
	}   /* end 'Cond' */
	if(Tree->MPC_ParScheme.Reinit) {  /* not empty expression: */
	  if(Tree->MPC_ParScheme.Reinit->MPC_Expr.Flag.Ignore) {  /* syntax error in expression */
	    Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	    Tree->MPC_Stat.ExecNet = ErrorNetList;
	  }
	  else {
	    GO_TO_EXPR(Tree->MPC_ParScheme.Reinit,SCHEME_DECL/*STATS*/,agNetContext);
	    if(Tree->MPC_ParScheme.Reinit->MPC_Expr.Flag.Ignore) {  /* semantic error in expression */
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	    }
	    else if(!Is_ScalarType(Tree->MPC_ParScheme.Reinit->MPC_Expr.Type)) {
	      Tree->MPC_Stat.Flag.Ignore = YES, RC = 1;
	      Tree->MPC_Stat.ExecNet = ErrorNetList;
	      Make_Message(629, xxError,
                           SourcePosition(Tree->MPC_ParScheme.Reinit->MPC_Expr.Pos,
                                          Tree->MPC_ParScheme.Reinit),
                           Tree->MPC_ParScheme.Reinit);
			   /* "Expression in 'par' statement has not scalar type" */
	    }
	    REMAKE_IF_BLOCKING(&Tree->MPC_ParScheme.Reinit);
	  }
	}   /* end 'Reinit' */
	BreakPossible++;    /**???**/
	ContinuePossible++; /**???**/
	RC |= Go(Tree->MPC_ParScheme.Stats, Context, NetPossible, NetContext, FKind);
	ContinuePossible--; /*******/
	BreakPossible--;    /*******/
	Set_StatErrorFlag(Tree);
	No_ReturnStats = Save_ReturnStatus;
	if(!No_ReturnStats) ControlExpr = NoTree;
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context, NetPossible, NetContext, FKind);
	break;
    case kMPC_Fan:
    /************/
	TRACE("MPC_Fan")
	CHECK_TRANSIT(Tree->MPC_Fan)
	RC |= Go(Tree->MPC_Stat.ExecNet, Context, NetPossible, NetContext, FKind);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_IdentLabel:
    /*******************/
	TRACE("MPC_IdentLabel")
	RC |= Go(Tree->MPC_Stats.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_CaseLabel:
    /******************/
	TRACE("MPC_CaseLabel")
	GO_TO_EXPR(Tree->MPC_CaseLabel.Expr,Context/*STATS*/,NetContext);
	if(!Tree->MPC_CaseLabel.Expr->MPC_Expr.Flag.Ignore) {
	  if(!Is_IntegralType(Tree->MPC_CaseLabel.Expr->MPC_Expr.Type)) {
	    Make_Message(617, xxError,
                         SourcePosition(Tree->MPC_CaseLabel.Expr->MPC_Expr.Pos, Tree->MPC_CaseLabel.Expr),
			 Tree->MPC_CaseLabel.Expr);
		/* "Expression in case label has not integral type" */
	    RC = 1;
	  }
	  RC |= Check_UniqueCaseLabel(Tree);
	  REMAKE_IF_BLOCKING(&Tree->MPC_CaseLabel.Expr);
	}
	RC |= Go(Tree->MPC_Stats.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Default:
    /****************/
	TRACE("MPC_Default")
	RC |= Check_SingleDefaultLabel(Tree);
	RC |= Go(Tree->MPC_Stat.Next, Context/*STATS*/, NetPossible, NetContext, FKind);
	break;
    case kMPC_Exprs:
    /**************/
	TRACE("MPC_Exprs")
	GO_TO_EXPR(Tree->MPC_Exprs.Expr,Context,NetContext);
	if(Tree->MPC_Exprs.Expr->MPC_Expr.Flag.Ignore) {  /* Error in expression; */
	  RC |= Go(Tree->MPC_Exprs.Next, Context, false, NetContext, FKind);
	  break;
	}
	REMAKE_IF_BLOCKING(&Tree->MPC_Exprs.Expr);
	if(Context==NET_ARG_LIST && FKind==UNDEFINED /* Global level */ &&
	   !Tree->MPC_Exprs.Expr->MPC_Expr.Flag.Const) {
	  Make_Message(449, xxError, Tree->MPC_Exprs.Pos, Tree->MPC_Exprs.Expr);
		/* "Not constant argument in net type specifier at global level" */
	  RC=1 ;
	}

	if(Context==NET_ARG_LIST) {
	  if(!Pattern || Pattern->Kind==kMPC_FreeNode) {
	    Make_Message(450,xxError, Tree->MPC_Exprs.Pos, Tree), RC=1;
		/* "Too many arguments in net type specifier" */
	    break;
	  }
	  else if(Check_ArgumentType(NET_ARG_LIST, Pattern, Tree->MPC_Exprs.Expr)) {
	    RC = 1;
	  }
	  if(!Inside_TimeofExpr  &&
	     !Tree->MPC_Exprs.Expr->MPC_Expr.Repl  &&
	     !((Tree->MPC_Exprs.Expr->MPC_Expr.Type->Kind==kMPC_ArrayType ||
	        Tree->MPC_Exprs.Expr->MPC_Expr.Type->Kind==kMPC_VectorType) &&
	       TerminalType(Tree->MPC_Exprs.Expr->MPC_Expr.Type)->MPC_Type.Flag.Repl ||
	       Tree->MPC_Exprs.Expr->MPC_Expr.Type->Kind==kMPC_PointerType &&
		Tree->MPC_Exprs.Expr->MPC_Expr.Type->MPC_PointerType.ElementType->
		MPC_Type.Flag.Repl)  &&
	     !Tree->MPC_Exprs.Expr->MPC_Expr.StoreNet->MPC_NetOrSubnet.SingleNode)
	    Make_Message(451, xxError, Tree->MPC_Exprs.Pos,
			 Tree->MPC_Exprs.Expr), RC = 1 ;
		/* "Invalid (not replicated) distributed argument in net type specifier" */
	  if(!(Tree->MPC_Exprs.Expr->MPC_Expr.Flag.Const) &&
	     (CurrentTopology==CONST || CurrentTopology==SPACE_REPLICATED) &&
	     Tree->MPC_Exprs.Expr->MPC_Expr./*Type->MPC_Type.Flag.*/Repl)
	    CurrentTopology = SPACE_REPLICATED;
	  else if(!(Tree->MPC_Exprs.Expr->MPC_Expr.Flag.Const))
	    CurrentTopology = DYNAMIC;
	  /**************  T M P :  ***************/
	  if(Tree->MPC_Exprs.Expr->MPC_Expr.Type!=NoTree &&
	     Tree->MPC_Exprs.Expr->MPC_Expr.Type->Kind!=kMPC_BasicType)
	   Tree->MPC_Exprs.Expr->MPC_Expr.Type = Pattern->MPC_Var.Type;
	  /****************************************/
	  Pattern = Pattern->MPC_Var.Next;
	  if(Pattern!=NoTree && Pattern->Kind!=kMPC_FreeNode &&
	     Tree->MPC_Exprs.Next->Kind==kMPC_FreeNode) {
	    Make_Message(452,xxError, Tree->MPC_Exprs.Pos, Tree), RC = 1;
		/* "Too few arguments in net type specifier" */
	  }
	}
	RC |= Go(Tree->MPC_Exprs.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_SimpleInit:
    /*******************/
	while(Tree->Kind==kMPC_SimpleInit) {
	  TRACE("MPC_SimpleInit")
	  GO_TO_EXPR(Tree->MPC_SimpleInit.Expr,STATS,NetContext);
	  if(Tree->MPC_SimpleInit.Expr->MPC_Expr.Flag.Ignore) RC = 1;  /* Error in expression; */
	  /* 'PatternRoot' is the tree of the initialized MPC_Var: */
	  /*** TMP: DISABLED UNTIL NEXT VERSION
	  if((PatternRoot->MPC_Var.Flag.Static || PatternRoot->MPC_Var.Flag.Exported ||
	     !Is_ScalarType(PatternRoot->MPC_Var.Type)) *** ...then const expr expected: ***
	     && !Tree->MPC_SimpleInit.Expr->MPC_Expr.Flag.Const) {
	    Make_Message("Not constant initializer for an object that has static storage duration or aggregate type",
			 xxError, Tree->MPC_SimpleInit.Pos, PatternRoot);
	    RC = 1;
	  }
	  ***/
	  REMAKE_IF_BLOCKING(&Tree->MPC_SimpleInit.Expr);
	  if(Tree->MPC_SimpleInit.Next!=NoTree && Tree->MPC_SimpleInit.Next->Kind==kMPC_SimpleInit)
	    Tree = Tree->MPC_SimpleInit.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_Initializer.Next, Context, false, NetContext, FKind);
	break;
    case kMPC_InitList:
    /*****************/
	while(Tree->Kind==kMPC_InitList) {
	  tTree SavePattern=Pattern;
	  TRACE("MPC_InitList")
	  RC |= Check_InitList(Tree, Pattern);
	  Pattern = Reduce_TypePattern(Pattern);  /** By now works only for arrays; **/
	  RC |= Go(Tree->MPC_InitList.List, Context, false, NetContext, FKind);
	  Pattern = SavePattern;
	  if(Tree->MPC_InitList.Next!=NoTree && Tree->MPC_InitList.Next->Kind==kMPC_InitList)
	    Tree = Tree->MPC_InitList.Next;
	  else
	    break;
	}
	RC |= Go(Tree->MPC_Initializer.Next, Context, false, NetContext, FKind);
	break;
    default:
    /******/
	TRACE("UNDEFINED_NODE")
	break;
  } /* end switch(Tree->Kind) */

  /* Check on asynchr. when statement && 'recon': */
  if(Tree_IsType(Tree, kMPC_Stat) && Tree->MPC_Stat.Benchmark) {
    if( ! Tree->MPC_Stat.Flag.Asynchr) {
      Make_Message(618, xxError, Tree->MPC_Stat.Pos, Tree);
		/* "The statement after 'recon' is not asynchronous" */
/***QueryTree(Tree);****/
      RC = 1;
    }
  }

  return RC;
}


/*******************/
static tTree PureStat		/* skip all labels before statement: */
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Stat)
#else
	(Stat)
	tTree Stat;
#endif
{
  while(Tree_IsType(Stat, kMPC_Label))
    Stat = Stat->MPC_Stats.Next;
  return Stat;
}

/***************************/
static void Set_StatErrorFlag
/***************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Stat)
#else
	(Stat)
	tTree Stat;
#endif
{
  tTree node;
  switch(Stat->Kind) {
    case kMPC_If:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_If.Expr->MPC_Expr.Flag.Ignore ||
				      PureStat(Stat->MPC_If.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_IfElse:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_If.Expr->MPC_Expr.Flag.Ignore ||
				      PureStat(Stat->MPC_IfElse.Then)->MPC_Stat.Flag.Ignore ||
				      PureStat(Stat->MPC_IfElse.Else)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_Switch:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_Switch.Expr->MPC_Expr.Flag.Ignore ||
				      PureStat(Stat->MPC_Switch.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_While:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_While.Expr->MPC_Expr.Flag.Ignore ||
				      PureStat(Stat->MPC_While.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_DoWhile:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_DoWhile.Expr->MPC_Expr.Flag.Ignore ||
				      PureStat(Stat->MPC_DoWhile.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_For:
	Stat->MPC_Stat.Flag.Ignore |= (Stat->MPC_For.Init==NoTree ?
					0 : Stat->MPC_For.Init->MPC_Expr.Flag.Ignore)
				   || (Stat->MPC_For.Cond==NoTree ?
					0 : Stat->MPC_For.Cond->MPC_Expr.Flag.Ignore)
				   || (Stat->MPC_For.Reinit==NoTree ?
					0 : Stat->MPC_For.Reinit->MPC_Expr.Flag.Ignore)
				   || PureStat(Stat->MPC_For.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_Compound:
	node = Stat->MPC_Compound.Stats;
	while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
	  if(Tree_IsType(node, kMPC_Stat) && node->MPC_Stat.Flag.Ignore) {
	    Stat->MPC_Stat.Flag.Ignore = YES;
	    break;
	  }
	  node = node->MPC_Stats.Next;
	}
	break;
    case kMPC_CompScheme:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_CompScheme.Expr->MPC_Expr.Flag.Ignore;
	node = Stat->MPC_CompScheme.Node;
	while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
	  Stat->MPC_Stat.Flag.Ignore |= node->MPC_Exprs.Expr->MPC_Expr.Flag.Ignore;
	}
	break;
    case kMPC_CommScheme:
	Stat->MPC_Stat.Flag.Ignore |= Stat->MPC_CommScheme.Expr->MPC_Expr.Flag.Ignore;
	node = Stat->MPC_CommScheme.From;
	while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
	  Stat->MPC_Stat.Flag.Ignore |= node->MPC_Exprs.Expr->MPC_Expr.Flag.Ignore;
	}
	node = Stat->MPC_CommScheme.To;
	while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
	  Stat->MPC_Stat.Flag.Ignore |= node->MPC_Exprs.Expr->MPC_Expr.Flag.Ignore;
	}
	break;
    case kMPC_ParScheme:
	Stat->MPC_Stat.Flag.Ignore |= (Stat->MPC_ParScheme.Init==NoTree ?
					0 : Stat->MPC_ParScheme.Init->MPC_Expr.Flag.Ignore)
				   || (Stat->MPC_ParScheme.Cond==NoTree ?
					0 : Stat->MPC_ParScheme.Cond->MPC_Expr.Flag.Ignore)
				   || (Stat->MPC_ParScheme.Reinit==NoTree ?
					0 : Stat->MPC_ParScheme.Reinit->MPC_Expr.Flag.Ignore)
				   || PureStat(Stat->MPC_ParScheme.Stats)->MPC_Stat.Flag.Ignore;
	break;
    case kMPC_Fan:
	Stat->MPC_Stat.Flag.Ignore |= PureStat(Stat->MPC_Fan.Body)->MPC_Stat.Flag.Ignore;
	break;
  }
  if(Stat->MPC_Stat.Flag.Ignore && Stat->MPC_Stat.ExecNet==NoTree)
    Stat->MPC_Stat.ExecNet = ErrorNetList;
}


/***********************/
static int Reset_ExecNet
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Stat, tTree NetContext, int Total)
#else
	(Stat, NetContext, Total)
	tTree Stat, NetContext;
#endif
{
  int RC = 0;
  tTree control_expr = NoTree;
  if(Total && NetContext==COMPUTING_SPACE &&
     (Stat->MPC_Stat.Flag.CreateAutoNet || Stat->MPC_Stat.Flag.CreateStaticNet)) {
    Stat->MPC_Stat.ExecNet = COMPUTING_SPACE_LIST;
    switch(Stat->Kind) {
	case kMPC_If:		control_expr = Stat->MPC_If.Expr;	break;
	case kMPC_IfElse:	control_expr = Stat->MPC_IfElse.Expr;	break;
	case kMPC_Switch:	control_expr = Stat->MPC_Switch.Expr;	break;
	case kMPC_While:	control_expr = Stat->MPC_While.Expr;	break;
	case kMPC_DoWhile:	control_expr = Stat->MPC_DoWhile.Expr;	break;
	case kMPC_For:		control_expr = Stat->MPC_For.Cond;	break;
    }
    if(control_expr!=NoTree && control_expr->MPC_Expr.Flag.Distributed &&
       control_expr->MPC_Expr.StoreNet!=COMPUTING_SPACE) {
      RC = 1;
      Stat->MPC_Stat.Flag.Ignore = YES;
      Make_Message(619, xxError, Stat->MPC_Stat.Pos, Stat);
		/* "Control expression(s) and statement(s) in selection or iteration statement are of different distribution" */
      Make_Message(12, xxInformation, Stat->MPC_Stat.Pos, Stat);
		/* "   (This is a case of [*]-distributed statement(s))" */
    }
  }
  return RC;
}

/**********/
int Go2Stats
/**********/
#if defined __STDC__ | defined __cplusplus
	(tTree Tree, int Context, tTree NetContext, int Total)
#else
	(Tree, Context, NetContext, Total)
	tTree Tree, NetContext;
	int Context, Total;
#endif
{
  int RC=0;

  if(Tree==NoTree) {
    TRACE("NO_TREE__LINK")
    return RC;
  }

  switch(Tree->Kind) {

    case kMPC_FreeNode:
    /*****************/
	TRACE("MPC_FreeNode - 2")
	break;
    case kMPC_ExprStat:
    /*****************/
	TRACE("MPC_ExprStat - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_ExprStat)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_If:
    /***********/
	TRACE("MPC_If - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_If)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_If.Stats, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_IfElse:
    /***************/
	TRACE("MPC_IfElse - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_IfElse)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_IfElse.Then, STATS, NetContext, Total);
	RC |= Go2Stats(Tree->MPC_IfElse.Else, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Switch:
    /***************/
	TRACE("MPC_Switch - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Switch)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Switch.Stats, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_While:
    /**************/
	TRACE("MPC_While - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_While)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_While.Stats, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_DoWhile:
    /****************/
	TRACE("MPC_DoWhile - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_DoWhile)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_DoWhile.Stats, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_For:
    /************/
	TRACE("MPC_For - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_For)
	Reset_ExecNet(Tree, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_For.Stats, STATS, NetContext, Total);
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Goto:
    /*************/
	TRACE("MPC_Goto - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Goto)
	if(!Tree->MPC_Stat.Flag.Ignore) {
	      static char lab[100];
	      tPosition lab_pos;
	      tTree label, stat, netlist;
	      label = Tree->MPC_Goto.LabelDef;
	      stat = PureStat(label);
	      netlist = stat->MPC_Stat.ExecNet;
	      while(netlist!=NoTree && netlist->Kind==kMPC_NetList) {
	        if(netlist/*->MPC_NetList*/!=CONST_NET_LIST &&
		   !Is_Subnet(netlist->MPC_NetList.Net,
			      Tree->MPC_Stat.ExecNet->MPC_NetList.Net)) {
		  lab_pos = RealPosition(label->MPC_Label.Pos);
		  GetString(Tree->MPC_Goto.Ident, lab);
		  Make_MessageI(626, xxError, Tree->MPC_Stat.Pos, xxString, lab, Tree);
			/* The 'goto' statement has different distribution with the statement after label */
		  Make_MessageI(13, xxInformation, Tree->MPC_Stat.Pos, xxString,
				SourceFile(label->MPC_Label.Pos), label);
		/* "   This label is declared in file" */
		  Make_MessageI(14, xxInformation, Tree->MPC_Stat.Pos,
				xxShort, (char*)&(lab_pos.Line), label);
		/* "   in line" */
		  Tree->MPC_Stat.Flag.Ignore = YES;
		  RC = 1;
		}
		netlist = netlist->MPC_NetList.Next;
	      }
	}
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Continue:
    /*****************/
	TRACE("MPC_Continue - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Continue)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Break:
    /**************/
	TRACE("MPC_Break - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Break)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_BreakFan:
    /*****************/
	TRACE("MPC_BreakFan - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_BreakFan)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Return:
    /***************/
	TRACE("MPC_Return - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Return)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Compound:
    /*****************/
	TRACE("MPC_Compound - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Compound)
	Reset_ExecNet(Tree, NetContext, Total);
	{
	  int TotalSave=Total;
	  if(!(Tree->MPC_Compound.Stats->MPC_Stat.Flag.CreateAutoNet ||
	       Tree->MPC_Compound.Stats->MPC_Stat.Flag.CreateStaticNet))
	    Total = NO;
	  RC |= Go2Stats(Tree->MPC_Compound.Stats, STATS,
		         Tree->MPC_Stat.ExecNet==COMPUTING_SPACE_LIST ?
		         COMPUTING_SPACE : NetContext, Total);
	  Total = TotalSave;
	}
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_Fan:
    /************/
	TRACE("MPC_Fan - 2")
	CHECK_STAT_TRANSIT(Tree->MPC_Fan)
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    case kMPC_IdentLabel:
    /*******************/
	TRACE("MPC_IdentLabel - 2")
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stats.Next, STATS, NetContext, Total);
	break;
    case kMPC_CaseLabel:
    /******************/
	TRACE("MPC_CaseLabel - 2")
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stats.Next, STATS, NetContext, Total);
	break;
    case kMPC_Default:
    /****************/
	TRACE("MPC_Default - 2")
	Set_Total(Tree);
	RC |= Go2Stats(Tree->MPC_Stat.Next, STATS, NetContext, Total);
	break;
    default:
    /******/
	TRACE("UNDEFINED_NODE - 2")
	break;
  } /* end switch(Tree->Kind) */

  return RC;
}

/******************/
int Check_SelfAccess
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, tTree Pattern, tPosition Pos)
#else
	(Type, Pattern, Pos)
	tTree Type;
	tTree Pattern;
	tPosition Pos;
#endif
{
  tTree UpperType = NoTree;

  while(Type->Kind==kMPC_ArrayType ||
	Type->Kind==kMPC_PointerType) {
    UpperType = Type;
    Type = Type->MPC_PointerType.ElementType;
  }
  if(Type->Kind!=kMPC_StructType && Type->Kind!=kMPC_UnionType  ||
     (Type->Kind==kMPC_StructType || Type->Kind==kMPC_UnionType) &&
     (Type->MPC_StructType.SU_Tag!=Pattern->MPC_StructType.SU_Tag ||
      Type->MPC_StructType.SU_Tag==NoIdent && Pattern->MPC_StructType.SU_Tag==NoIdent))
    return 0;
  else if(Type->Kind==Pattern->Kind && UpperType!=NoTree
	  && UpperType->Kind==kMPC_PointerType &&
     	  Type->MPC_StructType.SU_Tag==Pattern->MPC_StructType.SU_Tag &&
     	  !Type->MPC_StructType.MemberDecls && Pattern->MPC_StructType.MemberDecls!=NoTree) {
    /**Type->MPC_Type.EquivType = Pattern; -- already done!!! **/
    return 0;
  }
  else if(Type->Kind==Pattern->Kind && (!UpperType ||
	  UpperType->Kind!=kMPC_PointerType || Type->MPC_StructType.MemberDecls!=NoTree)) {
    Make_Message(453, xxError, Pos, Type);
		/* "Illegal use of struct or union specifier inside struct or union" */
    return 1;
  }
  else if(Type->Kind==kMPC_StructType && Pattern->Kind==kMPC_UnionType &&
	  Type->MPC_StructType.SU_Tag==Pattern->MPC_StructType.SU_Tag) {
    Make_MessageI(454, xxError, Pos,
		  xxIdent, (char *)&Type->MPC_StructType.SU_Tag, Type);
		/* "Identifier is previously declared as 'union'" */
    return 1;
  }
  else if(Type->Kind==kMPC_UnionType && Pattern->Kind==kMPC_StructType &&
	  Type->MPC_StructType.SU_Tag==Pattern->MPC_StructType.SU_Tag) {
    Make_MessageI(455, xxError, Pos,
		  xxIdent, (char *)&Type->MPC_StructType.SU_Tag, Type);
		/* "Identifier is previously declared as 'struct'" */
    return 1;
  }

  return 0;
}

/*******************/
int Make_UniqueNumber
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Node)
#else
	(Node)
	tTree Node;
#endif
{
  static int TypeNumber  ;
  static int NetNumber   ;
  static int StatNumber  ;
  static int MembNumber  ;
  static int ScopeNumber ;

  if(Node==NoTree) {  /* init numeration: */
    TypeNumber  = 0;
    NetNumber   = 0;
    StatNumber  = 0;
    MembNumber  = 0;
    ScopeNumber = 0;
  }

  if(Tree_IsType(Node, kMPC_Type))		return ++TypeNumber;
  if(Tree_IsType(Node, kMPC_NetOrSubnet))	return ++NetNumber;
  if(Tree_IsType(Node, kMPC_Compound))		return ++StatNumber;
  if(Tree_IsType(Node, kMPC_SU_Member))		return ++MembNumber;
  if(Tree_IsType(Node, kMPC_FreeNode))		return ++ScopeNumber;  /** !!! **/

  return UNDEFINED;
}

/*************************/
void Check_On_NetDefinitions
/*************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Block)
#else
	(Block)
	tTree Block;
#endif
{
  tTree node;

  node = Block->MPC_Compound.Decls;
  while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
    if(Block->MPC_Stat.Flag.CreateAutoNet &&
       Block->MPC_Stat.Flag.CreateStaticNet &&
       Block->MPC_Stat.Flag.CreateSubnet)
      return;
    if(node->Kind==kMPC_NetDecl) {
      if(node->MPC_NetDecl.NetClass == AUTO)
	Block->MPC_Stat.Flag.CreateAutoNet = YES;
      if(node->MPC_NetDecl.NetClass == LOCAL_STATIC)
	Block->MPC_Stat.Flag.CreateStaticNet = YES;
    }
    if(node->Kind==kMPC_SubnetDecl &&
       node->MPC_SubnetDecl.SubnetClass!=FLEXIBLE)
      Block->MPC_Stat.Flag.CreateSubnet = YES;
    node = node->MPC_Decls.Next;
  }
  node = Block->MPC_Compound.Stats;
  while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
    if(Block->MPC_Stat.Flag.CreateAutoNet && Block->MPC_Stat.Flag.CreateStaticNet &&
       Block->MPC_Stat.Flag.CreateSubnet)
      return;
    if(Tree_IsType(node,kMPC_Stat)) {
      Block->MPC_Stat.Flag.CreateAutoNet   |= node->MPC_Stat.Flag.CreateAutoNet;
      Block->MPC_Stat.Flag.CreateStaticNet |= node->MPC_Stat.Flag.CreateStaticNet;
      Block->MPC_Stat.Flag.CreateSubnet    |= node->MPC_Stat.Flag.CreateSubnet;
    }
    node = node->MPC_Stats.Next;
  }
}

/***************************/
tTree Eval_Block_Distribution
/***************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Block)
#else
	(Block)
	tTree Block;
#endif
{
  tTree list=CONST_NET_LIST, node, net, tmp;

  if(Block->MPC_Stat.Flag.DistrLabel)
    list = Block->MPC_Stat.ExecNet;

  if(Block->MPC_Stat.Flag.CreateAutoNet || Block->MPC_Stat.Flag.CreateStaticNet)
    return COMPUTING_SPACE_LIST;

  if(!(Block->MPC_Stat.Flag.CreateStaticNet || Block->MPC_Stat.Flag.CreateAutoNet ||
       Block->MPC_Stat.Flag.CreateSubnet)) {
    Block->MPC_Stat.Flag.Asynchr = YES;
  }
  else {  /* net(s) or subnet(s) declared: */
    node = Block->MPC_Compound.Decls;
    while(node->Kind!=kMPC_FreeNode){
      if(node->Kind==kMPC_NetDecl) {
	net = node->MPC_NetDecl.Net;
	while(net->Kind==kMPC_Net) {
	  Reduce_NetList = NO;
	  tmp = Make_UnreduceableNetList(net);
	  list = Join_NetList(list, tmp);
	  Reduce_NetList = YES;
	  if(list!=tmp) Release_NetList(tmp);
	  Reduce_NetList = NO;
	  tmp = Make_UnreduceableNetList(net->MPC_Net.Distribution);
	  list = Join_NetList(list, tmp);
	  Reduce_NetList = YES;
	  if(list!=tmp) Release_NetList(tmp);
	  net = net->MPC_Net.Next;
	}
      }
      else if(node->Kind==kMPC_SubnetDecl) {
	net = node->MPC_SubnetDecl.Subnet;
	while(net->Kind==kMPC_Subnet) {
	  list = Join_NetList(list, tmp=Make_NetList(net->MPC_Subnet.Distribution));
	  if(list!=tmp) Release_NetList(tmp);
	  net = net->MPC_Subnet.Next;
	}
      }
      node = node->MPC_Decls.Next;
    }
  }

  node = Block->MPC_Compound.Stats;
  while(node!=NoTree && node->Kind!=kMPC_FreeNode) {
    while(Tree_IsType(node,kMPC_Label))
      node = node->MPC_Stats.Next;
    list = Join_NetList(list, node->MPC_Stat.ExecNet);
    if(!node->MPC_Stat.Flag.Asynchr) Block->MPC_Stat.Flag.Asynchr = NO;
    node = node->MPC_Stats.Next;
  }

  list->MPC_NetList.Prev->MPC_FreeNode.Parent = Block;
  return list;
}

/******************/
tTree Replace_Coords
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr)
	tTree Expr;
#endif
{
  tTree Make_CoordExpr(tTree Expr);

  switch(Expr->Kind) {
    case kMPC_IntConst:
    case kMPC_UIntConst:
    case kMPC_FloatConst:
    case kMPC_StringLiteral:
    case kMPC_CoordExpr:
    case kMPC_Size_Of_Type:
	break;
    case kMPC_Ident:
	Expr = Make_CoordExpr(Expr);
	break;
    case kMPC_CastExpr:
	Expr->MPC_CastExpr.Operand = Make_CoordExpr(Expr->MPC_CastExpr.Operand);
	break;
    case kMPC_NetCastExpr:
	Expr->MPC_NetCastExpr.Operand = Make_CoordExpr(Expr->MPC_NetCastExpr.Operand);
	break;
    case kMPC_Size_Of_Value:
	Expr->MPC_Size_Of_Value.Operand = Make_CoordExpr(Expr->MPC_Size_Of_Value.Operand);
	break;
    case kMPC_UnaryExpr:
	Expr->MPC_UnaryExpr.Operand = Make_CoordExpr(Expr->MPC_UnaryExpr.Operand);
	break;
    case kMPC_BinaryExpr:
	Expr->MPC_BinaryExpr.Loperand = Make_CoordExpr(Expr->MPC_BinaryExpr.Loperand);
	Expr->MPC_BinaryExpr.Roperand = Make_CoordExpr(Expr->MPC_BinaryExpr.Roperand);
	break;
    case kMPC_TernaryExpr:
	Expr->MPC_TernaryExpr.Foperand = Make_CoordExpr(Expr->MPC_TernaryExpr.Foperand);
	Expr->MPC_TernaryExpr.Soperand = Make_CoordExpr(Expr->MPC_TernaryExpr.Soperand);
	Expr->MPC_TernaryExpr.Toperand = Make_CoordExpr(Expr->MPC_TernaryExpr.Toperand);
	break;
    case kMPC_CallExpr:
	Expr->MPC_CallExpr.Function = Make_CoordExpr(Expr->MPC_CallExpr.Function);
	if(Expr->MPC_CallExpr.ArgList) Replace_Coords(Expr->MPC_CallExpr.ArgList);
	if(Expr->MPC_CallExpr.NetworkArgList) Replace_Coords(Expr->MPC_CallExpr.NetworkArgList);
	break;
    case kMPC_Exprs:
	Expr->MPC_Exprs.Expr = Make_CoordExpr(Expr->MPC_Exprs.Expr);
	Replace_Coords(Expr->MPC_Exprs.Next);
	break;
    case kMPC_FreeNode:
	break;
    default:
	CompilerError("Invalid 'Expr' in Replace_Coords()", Expr->MPC_Expr.Pos);
  }
  return Expr;
}

/******************/
tTree Make_CoordExpr
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Expr)
#else
	(Expr)
	tTree Expr;
#endif
{
  tTree old = Expr;

  if(Expr->Kind==kMPC_Ident && Expr->MPC_Ident.Store->Kind==kMPC_CoordDecl) {
    /*** change MPC_Ident node to MPC_CoordExpr node: ***/
    Expr = mMPC_CoordExpr(
		Expr->MPC_Expr.Pos, Expr->MPC_Expr.Flag, Expr->MPC_Expr.TmpName, IntType,
		Expr->MPC_Expr.EvalNet, Expr->MPC_Expr.StoreNet, Expr->MPC_Ident.Ident, Expr
	 );
    Expr->MPC_Expr.Flag.Ignore |= Eval_CoordNumber(
					Expr, &Expr->MPC_CoordExpr.CoordNumber
				  );
    Expr->MPC_CoordExpr.BegPos = old->MPC_Expr.BegPos;  /*K*/
  }
  else if(old->Kind!=kMPC_Ident)
    Expr = Replace_Coords(Expr);
  return Expr;
}


/************************************************************************/
/*******************   W O R K   F U N C T I O N S   ********************/
/********************** for attribute computation ***********************/

/****************/
tTree TerminalType
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree type)
#else
	(type)
	tTree type;
#endif
{
  while(type->Kind==kMPC_ArrayType || type->Kind==kMPC_VectorType)
    if(type->Kind==kMPC_ArrayType)
      type = type->MPC_ArrayType.ElementType;
    else
      type = type->MPC_VectorType.ElementType;
  return type;
}

/*****************/
tTree NewVectorType
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree old_type, tTree new_element_type)
#else
	(old_type, new_element_type)
	tTree old_type, new_element_type;
#endif
{
  if(!old_type)
    CompilerError("Bad 'old_type' in call to NewVectorType()", NoPosition);
  if(old_type->Kind!=kMPC_VectorType && old_type->Kind!=kMPC_ArrayType) {
    Push_Pattern(new_element_type);
    return Make_Type();
  }
  else{
    tTree elem_type, dyn_size;
    if(old_type->Kind==kMPC_ArrayType) {
      elem_type = old_type->MPC_ArrayType.ElementType;
      dyn_size = old_type->MPC_ArrayType.ArraySize;
    }
    else {
      elem_type = old_type->MPC_VectorType.ElementType;
      dyn_size = old_type->MPC_VectorType.VectorSize;
    }
    Push_Pattern(
	mMPC_VectorType(
		NoPosition, NoTree, NoTree, old_type->MPC_Type.Flag,
		old_type->MPC_DerivedType.NumberOfComponents, elem_type
	)
    );
    TopType()->MPC_VectorType.VectorSize = dyn_size;
    TopType()->MPC_VectorType.Flag.ExplStep = NO;
    TopType()->MPC_VectorType.Flag.DynStep = NO;
    return NewVectorType(elem_type, new_element_type);
  }
}

/***********************/
int Is_CorrectBlockedType
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree type)
#else
	(type)
	tTree type;
#endif
 {
  if(type->Kind==kMPC_ArrayType ||
     type->Kind==kMPC_PointerType  /* array, converted to pointer!!! */)
    return YES;
  else
    if(type->Kind==kMPC_VectorType)
      return Is_CorrectBlockedType(type->MPC_VectorType.ElementType);
  else
    return NO;
}

/***********************/
int Is_CorrectBlockedExpr
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree type;

  Push_PurePattern(expr->MPC_Expr.Type);
  type = Make_Type();

  if(expr->MPC_Expr.Flag.Lvalue && type->Kind!=kMPC_PointerType)
    return NO;
  else
    return Is_CorrectBlockedType(type);
}

/***********************/
tTree Remake_BlockingExpr
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree *TreePtr)
#else
	(TreePtr)
	tTree *TreePtr;
#endif
{
  tTree op=(*TreePtr)->MPC_UnaryExpr.Operand,
	op_type=(*TreePtr)->MPC_UnaryExpr.Operand->MPC_Expr.Type,
	eval_net=(*TreePtr)->MPC_UnaryExpr.Operand->MPC_Expr.EvalNet,
	store_net=(*TreePtr)->MPC_UnaryExpr.Operand->MPC_Expr.StoreNet;
  int dim;

  /** Check whether BLOCK_TO_GRID option is ON: **/
  if(!BLOCK_TO_GRID)
    return *TreePtr;  /* Don't replace [] with [:]...[:]! */

  /* 1.Count op_type dimension: */
  if(op_type->Kind==kMPC_PointerType)
    dim = 1;
  else
    for(dim=0; op_type->Kind==kMPC_ArrayType||op_type->Kind==kMPC_VectorType; dim++)
      op_type = (op_type->Kind==kMPC_ArrayType) ? op_type->MPC_ArrayType.ElementType
						: op_type->MPC_VectorType.ElementType;

  /* 2.Generate couple of the corresponding grid operators: */
  for(; dim; dim--) {
    op = mMPC_QuaternaryExpr((*TreePtr)->MPC_UnaryExpr.Pos, (*TreePtr)->MPC_UnaryExpr.Flag,
			     EmptyString, NoTree, eval_net, store_net,
			     GRID, op, NoTree, NoTree, NoTree);
    op->MPC_QuaternaryExpr.Operand2 = mMPC_FreeNode(op);
    op->MPC_QuaternaryExpr.Operand3 = mMPC_FreeNode(op);
    op->MPC_QuaternaryExpr.Operand4 = mMPC_FreeNode(op);
    Eval_TypeOfGridExpr(op);
  }
  
  /* 3.Evaluate some attributes of grid expression: */
  op->MPC_QuaternaryExpr.Repl = op->MPC_QuaternaryExpr.Operand1->MPC_Expr.Repl;

  return op;
}


/***********************/
int Is_CorrectGridOperand
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree type;

  Push_PurePattern(expr->MPC_Expr.Type);
  type = Make_Type();
  return Is_CorrectBlockedType(type);
}

/**********************************/
tTree Type_Of_LvectorIndexedByScalar
/**********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type, int *IsLvalue)
#else
	(type, IsLvalue)
	tTree type;
	int * IsLvalue;
#endif
{
  tTree ElementType, DynSize;

  if(type->Kind==kMPC_ArrayType) {
    ElementType = type->MPC_ArrayType.ElementType;
    DynSize = type->MPC_ArrayType.ArraySize;
  }
  else if(type->Kind==kMPC_VectorType) {
    ElementType = type->MPC_VectorType.ElementType;
    DynSize = type->MPC_VectorType.VectorSize;
  }
  else if(type->Kind==kMPC_PointerType) {
    ElementType = type->MPC_PointerType.ElementType;
    DynSize = NoTree;
  }
  else
    ElementType = DynSize = NoTree;

  *IsLvalue = YES;
  Push_Pattern(
    mMPC_VectorType(
	NoPosition, NoTree, NoTree, NoTypeFlag,
	type->MPC_DerivedType.NumberOfComponents, NoTree
    )
  );
  if(DynSize!=NoTree && DynSize->Kind!=kMPC_FreeNode) {
    TopType()->MPC_VectorType.VectorSize = DynSize;
    TopType()->MPC_VectorType.Flag.DynArray = YES;
  }
  if(ElementType->Kind==kMPC_PointerType) {
    ElementType = ElementType->MPC_PointerType.ElementType;    
    if(ElementType->Kind==kMPC_ArrayType)
      *IsLvalue = NO;
    Push_Pattern(ElementType);
    return Make_Type();
  }
  else
    if(ElementType->Kind==kMPC_ArrayType ||
       ElementType->Kind==kMPC_VectorType)
      return Type_Of_LvectorIndexedByScalar(ElementType,IsLvalue);
    else
      Clean_TypeStack();
  return NoTree;
}

/*********************************/
tTree Type_Of_VectorIndexedByScalar
/*********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type, int *IsLvalue)
#else
	(type, IsLvalue)
	tTree type;
	int * IsLvalue;
#endif
{
  tTree ElementType, DynSize;

  if(type->Kind==kMPC_ArrayType) {
    ElementType = type->MPC_ArrayType.ElementType;
    DynSize = type->MPC_ArrayType.ArraySize;
  }
  else if(type->Kind==kMPC_VectorType) {
    ElementType = type->MPC_VectorType.ElementType;
    DynSize = type->MPC_VectorType.VectorSize;
  }
  else if(type->Kind==kMPC_PointerType) {
    ElementType = type->MPC_PointerType.ElementType;
    DynSize = NoTree;
  }
  else
    ElementType = DynSize = NoTree;

  *IsLvalue = YES;
  Push_Pattern(
    mMPC_VectorType(
	NoPosition, NoTree, NoTree, NoTypeFlag,
	type->MPC_DerivedType.NumberOfComponents, NoTree
    )
  );
  if(DynSize!=NoTree && DynSize->Kind!=kMPC_FreeNode) {
    TopType()->MPC_VectorType.VectorSize = DynSize;
    TopType()->MPC_VectorType.Flag.DynArray = YES;
  }
  if(ElementType->Kind==kMPC_PointerType ||
     ElementType->Kind==kMPC_ArrayType) {
    if(ElementType->Kind==kMPC_ArrayType)
	ElementType = ElementType->MPC_ArrayType.ElementType;
    if(ElementType->Kind==kMPC_PointerType)
	ElementType = ElementType->MPC_PointerType.ElementType;
    if(ElementType->Kind==kMPC_ArrayType)
      *IsLvalue = NO;
    Push_Pattern(ElementType);
    return Make_Type();
  }
  else
    if(ElementType->Kind==kMPC_VectorType)
      return Type_Of_VectorIndexedByScalar(ElementType,IsLvalue);
    else
      Clean_TypeStack();
  return NoTree;
}

/*********************************/
tTree Type_Of_ScalarIndexedByVector
/*********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type, tTree index_type, int *IsLvalue)
#else
	(type, index_type, IsLvalue)
	tTree type, index_type;
	int * IsLvalue;
#endif
{
  tTree ElementType, DynSize=NoTree;

  if(type->Kind==kMPC_ArrayType)
    ElementType = type->MPC_ArrayType.ElementType;
  else if(type->Kind==kMPC_VectorType)
    ElementType = type->MPC_VectorType.ElementType;
  else if(type->Kind==kMPC_PointerType)
    ElementType = type->MPC_PointerType.ElementType;
  else
    ElementType = NoTree;

  if(ElementType!=NoTree &&
     ElementType->Kind!=kMPC_ArrayType &&
     ElementType->Kind!=kMPC_FunctionType)
    *IsLvalue = YES;
  else
    *IsLvalue = NO;

  do{
    if(index_type->Kind!=kMPC_ArrayType && index_type->Kind!=kMPC_VectorType)
      return NoTree;
    Push_Pattern(
	mMPC_VectorType(
		NoPosition, NoTree, NoTree, NoTypeFlag,
		index_type->MPC_DerivedType.NumberOfComponents, NoTree
	)
    );
    if(index_type->Kind==kMPC_ArrayType)
	index_type = index_type->MPC_ArrayType.ElementType,
	DynSize = type->MPC_ArrayType.ArraySize;
    if(index_type->Kind==kMPC_VectorType)
	index_type = index_type->MPC_VectorType.ElementType,
	DynSize = type->MPC_VectorType.VectorSize;
    if(index_type->Kind==kMPC_Typedef)
	index_type = index_type->MPC_Typedef.Type, DynSize = NoTree;
    if(DynSize!=NoTree && DynSize->Kind!=kMPC_FreeNode) {
      TopType()->MPC_VectorType.VectorSize = DynSize;
      TopType()->MPC_VectorType.Flag.DynArray = YES;
    }
  } while(Tree_IsType(index_type,kMPC_DerivedType));

  if(!Tree_IsType(index_type,kMPC_BasicType) ||
     index_type->MPC_BasicType.TypeConstructor > CHAR ||
     index_type->MPC_BasicType.TypeConstructor < UNSIGNED_LONG) {
    Clean_TypeStack();
    return NoTree;
  }
  else {
    Push_Pattern(ElementType);
    return Make_Type();
  }
}

/**********************************/
tTree Type_Of_LvectorIndexedByVector
/**********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type, tTree index_type, int *IsLvalue)
#else
	(type, index_type, IsLvalue)
	tTree type, index_type;
	int * IsLvalue;
#endif
{
  tTree ElementType, IndexElType, DynSize, IndexDynSize, Vector_DynSize;
  int Vector_NumberOfComponents;

  if(type->Kind==kMPC_ArrayType) {
    ElementType = type->MPC_ArrayType.ElementType;
    DynSize = type->MPC_ArrayType.ArraySize;
  }
  else if(type->Kind==kMPC_VectorType) { 
    ElementType = type->MPC_VectorType.ElementType;
    DynSize = type->MPC_VectorType.VectorSize;
  }
  else if(type->Kind==kMPC_PointerType) {
    ElementType = type->MPC_PointerType.ElementType;
    DynSize = NoTree;
  }
  else
    ElementType = DynSize = NoTree;

  if(index_type->Kind==kMPC_ArrayType) { 
	IndexElType = index_type->MPC_ArrayType.ElementType;
	IndexDynSize = index_type->MPC_ArrayType.ArraySize;
  }
  else if(index_type->Kind==kMPC_VectorType) {
	IndexElType = index_type->MPC_VectorType.ElementType;
	IndexDynSize = index_type->MPC_VectorType.VectorSize;
  }
  else if(index_type->Kind==kMPC_PointerType) {
	IndexElType = index_type->MPC_PointerType.ElementType;
	IndexDynSize = NoTree;
  }
  else
    IndexElType = IndexDynSize = NoTree;

  if(type->MPC_DerivedType.NumberOfComponents >
     index_type->MPC_DerivedType.NumberOfComponents) {
    Vector_NumberOfComponents = type->MPC_DerivedType.NumberOfComponents;
    Vector_DynSize = DynSize;
  }
  else {
    Vector_NumberOfComponents = index_type->MPC_DerivedType.NumberOfComponents;
    Vector_DynSize = IndexDynSize;
  }

  Push_Pattern(
    mMPC_VectorType(
	NoPosition, NoTree, NoTree, NoTypeFlag,
	Vector_NumberOfComponents, NoTree
    )
  );
  TopType()->MPC_VectorType.VectorSize = Vector_DynSize;

  if(ElementType->Kind==kMPC_PointerType   &&
     ( IndexElType->Kind==kMPC_BasicType &&
	IndexElType->MPC_BasicType.TypeConstructor <= CHAR &&
       IndexElType->Kind==kMPC_BasicType &&
	IndexElType->MPC_BasicType.TypeConstructor >= UNSIGNED_LONG )) {
    if(ElementType->Kind==kMPC_ArrayType)  ElementType=ElementType->MPC_ArrayType.ElementType;
    if(ElementType->Kind==kMPC_VectorType) ElementType=ElementType->MPC_VectorType.ElementType;
    if(ElementType->Kind==kMPC_PointerType)ElementType=ElementType->MPC_PointerType.ElementType;
    if(ElementType->Kind==kMPC_ArrayType)
      *IsLvalue = NO;
    else
      *IsLvalue = YES;
    Push_Pattern(ElementType);
    return Make_Type();
  }
  else if(ElementType->Kind==kMPC_PointerType)
    return Type_Of_ScalarIndexedByVector(ElementType, IndexElType, IsLvalue);
  else if(ElementType->Kind==kMPC_ArrayType || ElementType->Kind==kMPC_VectorType) {
    if(IndexElType->Kind==kMPC_BasicType &&
       IndexElType->MPC_BasicType.TypeConstructor <= CHAR &&
       IndexElType->MPC_BasicType.TypeConstructor >= UNSIGNED_LONG)
      return Type_Of_LvectorIndexedByScalar(ElementType, IsLvalue);
    else if(IndexElType->Kind==kMPC_VectorType || IndexElType->Kind==kMPC_ArrayType)
      return Type_Of_LvectorIndexedByVector(ElementType, IndexElType, IsLvalue);
    else
      Clean_TypeStack();
  }
  else
    Clean_TypeStack();
  return NoTree;
}

/*********************************/
tTree Type_Of_VectorIndexedByVector
/*********************************/
#if defined __STDC__ | defined __cplusplus
	(tTree type, tTree index_type, int *IsLvalue)
#else
	(type, index_type, IsLvalue)
	tTree type, index_type;
	int * IsLvalue;
#endif
{
  tTree ElementType, IndexElType, DynSize, IndexDynSize, Vector_DynSize;
  int Vector_NumberOfComponents;

  if(type->Kind==kMPC_ArrayType) {
    ElementType = type->MPC_ArrayType.ElementType;
    DynSize = type->MPC_ArrayType.ArraySize;
  }
  else if(type->Kind==kMPC_VectorType) {
    ElementType = type->MPC_VectorType.ElementType;
    DynSize = type->MPC_VectorType.VectorSize;
  }
  else if(type->Kind==kMPC_PointerType) {
    ElementType = type->MPC_PointerType.ElementType;
    DynSize = NoTree;
  }
  else
    ElementType = DynSize = NoTree;

  if(index_type->Kind==kMPC_ArrayType) {
	IndexElType = index_type->MPC_ArrayType.ElementType;
	IndexDynSize = index_type->MPC_ArrayType.ArraySize;
  }
  else if(index_type->Kind==kMPC_VectorType) {
	IndexElType = index_type->MPC_VectorType.ElementType;
	IndexDynSize = index_type->MPC_VectorType.VectorSize;
  }
  else if(index_type->Kind==kMPC_PointerType) {
	IndexElType = index_type->MPC_PointerType.ElementType;
	IndexDynSize = NoTree;
  }
  else
    IndexElType = IndexDynSize = NoTree;

  if(type->MPC_DerivedType.NumberOfComponents >
     index_type->MPC_DerivedType.NumberOfComponents) {
    Vector_NumberOfComponents = type->MPC_DerivedType.NumberOfComponents;
    Vector_DynSize = DynSize;
  }
  else {
    Vector_NumberOfComponents = index_type->MPC_DerivedType.NumberOfComponents;
    Vector_DynSize = IndexDynSize;
  }

  Push_Pattern(
    mMPC_VectorType(
	NoPosition, NoTree, NoTree, NoTypeFlag,
	Vector_NumberOfComponents, NoTree
    )
  );
  TopType()->MPC_VectorType.VectorSize = Vector_DynSize;

  if((ElementType->Kind==kMPC_PointerType || ElementType->Kind==kMPC_ArrayType) &&
    	(IndexElType->Kind==kMPC_BasicType &&
	 IndexElType->MPC_BasicType.TypeConstructor <= CHAR &&
	 IndexElType->MPC_BasicType.TypeConstructor >= UNSIGNED_LONG )) {
    ElementType = ElementType->MPC_ArrayType.ElementType;  /* eq. for PointerType; */
    if(ElementType->Kind==kMPC_ArrayType)
      *IsLvalue = NO;
    else
      *IsLvalue = YES;
    Push_Pattern(ElementType);
    return Make_Type();
  }
  else if(ElementType->Kind==kMPC_PointerType || ElementType->Kind==kMPC_ArrayType)
    return Type_Of_ScalarIndexedByVector(ElementType, IndexElType, IsLvalue);
  else if(ElementType->Kind==kMPC_VectorType) {
    if(IndexElType->Kind==kMPC_BasicType &&
       IndexElType->MPC_BasicType.TypeConstructor <= CHAR &&
       IndexElType->MPC_BasicType.TypeConstructor >= UNSIGNED_LONG  )
      return Type_Of_VectorIndexedByScalar(ElementType, IsLvalue);
    else if(IndexElType->Kind==kMPC_VectorType || IndexElType->Kind==kMPC_ArrayType)
      return Type_Of_VectorIndexedByVector(ElementType, IndexElType, IsLvalue);
    else
      Clean_TypeStack();
  }
  else
    Clean_TypeStack();
  return NoTree;
}

/***********************/
void Eval_TypeOfIndexExpr
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  int Lvalue;
  tTree type, index_type;

  type = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Type;
  index_type = expr->MPC_BinaryExpr.Roperand->MPC_Expr.Type;

  if(type==ErrorType || index_type==ErrorType) {
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }

  if(index_type->Kind==kMPC_BasicType) { /* scalar index; array or vector 'Loperand'? */
    if(index_type->MPC_BasicType.TypeConstructor < UNSIGNED_LONG ||
       index_type->MPC_BasicType.TypeConstructor > CHAR) {
      Make_Message(207, xxError,
                   SourcePosition(expr->MPC_BinaryExpr.Roperand->MPC_Expr.Pos,
                                  expr->MPC_BinaryExpr.Roperand),
		   expr);
		/* "Invalid type of index" */
      expr->MPC_Expr.Flag.Ignore = YES;
      expr->MPC_Expr.Type = ErrorType;
      return;
    }
    if(type->Kind != kMPC_PointerType &&
       type->Kind != kMPC_ArrayType   &&
       type->Kind != kMPC_VectorType) {
      Make_Message(208, xxError,
                   SourcePosition(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Pos,
                                  expr->MPC_BinaryExpr.Loperand),
		   expr);
		/* "Invalid type of expression before '['" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }else if(type->Kind==kMPC_VectorType) {
      expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
      if(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Lvalue)
	expr->MPC_Expr.Type = Type_Of_LvectorIndexedByScalar(type, &Lvalue);
      else
	expr->MPC_Expr.Type = Type_Of_VectorIndexedByScalar(type, &Lvalue);
      expr->MPC_Expr.Flag.Lvalue = Lvalue;
      if(!expr->MPC_Expr.Type || expr->MPC_Expr.Type->Kind==kMPC_BasicType) {
        expr->MPC_Expr.Type = ErrorType;
	expr->MPC_Expr.Flag.Ignore = YES;
	Make_Message(208, xxError,
                     SourcePosition(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Pos,
                                  expr->MPC_BinaryExpr.Loperand),
		     expr);
		/* "Invalid type of expression before '['" */
        return;
      }
    }else if(type->Kind==kMPC_ArrayType &&
	     expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Lvalue) {
      expr->MPC_Expr.Type = Type_Of_LvectorIndexedByScalar(type, &Lvalue);
      expr->MPC_Expr.Flag.Lvalue = Lvalue;
      expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
      if(!expr->MPC_Expr.Type || expr->MPC_Expr.Type->Kind==kMPC_BasicType) {
        expr->MPC_Expr.Type = ErrorType;
	expr->MPC_Expr.Flag.Ignore = YES;
	Make_Message(208, xxError,
                     SourcePosition(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Pos,
                                  expr->MPC_BinaryExpr.Loperand),
		     expr);
		/* "Invalid type of expression before '['" */
        return;
      }
    }else{
      expr->MPC_Expr.Type = type->MPC_ArrayType.ElementType;  /* == for MPC_VectorType; */
      expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
      if(!(expr->MPC_Expr.Type->Kind==kMPC_BasicType &&
	   expr->MPC_Expr.Type->MPC_BasicType.TypeConstructor==VOID) &&
	 expr->MPC_Expr.Type->Kind != kMPC_ArrayType &&
	 expr->MPC_Expr.Type->Kind != kMPC_Function)
	expr->MPC_Expr.Flag.Lvalue = YES;
      else
	expr->MPC_Expr.Flag.Lvalue = NO;
    }
  }else if((index_type->Kind==kMPC_VectorType ||
	    index_type->Kind==kMPC_ArrayType &&
	    expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Lvalue)  &&
	   type->Kind != kMPC_BasicType  &&
	   (type->Kind==kMPC_PointerType || type->Kind==kMPC_ArrayType &&
	    ! expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Lvalue)) { 
					/* non-scalar 'Loperand' and 'Roperand'; */
    expr->MPC_Expr.Type = Type_Of_ScalarIndexedByVector(type, index_type, &Lvalue);
    expr->MPC_Expr.Flag.Lvalue = Lvalue;
    expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
    if(!expr->MPC_Expr.Type || expr->MPC_Expr.Type->Kind == kMPC_BasicType) {
      Make_Message(209, xxError,
                   SourcePosition(expr->MPC_BinaryExpr.Roperand->MPC_Expr.Pos,
                                  expr->MPC_BinaryExpr.Roperand),
		   expr);
		/* "Invalid type of index expression" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
  }else if((index_type->Kind==kMPC_VectorType ||
	    index_type->Kind==kMPC_ArrayType &&
	    expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Lvalue)  &&
	   type->Kind!=kMPC_BasicType  &&  type->Kind==kMPC_ArrayType  &&
	   expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Lvalue) {
    expr->MPC_Expr.Type = Type_Of_LvectorIndexedByVector(type,index_type,&Lvalue);
    expr->MPC_Expr.Flag.Lvalue = Lvalue;
    expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
    if(!expr->MPC_Expr.Type || expr->MPC_Expr.Type->Kind == kMPC_BasicType) {
      Make_Message(210, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type(s) of operand(s) of indexing operator" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
  }else if((index_type->Kind==kMPC_VectorType ||
	    index_type->Kind==kMPC_ArrayType &&
	    expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Lvalue) &&
	   type->Kind==kMPC_VectorType) {
    if(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Lvalue)
      expr->MPC_Expr.Type = Type_Of_LvectorIndexedByVector(type,index_type,&Lvalue);
    else
      expr->MPC_Expr.Type = Type_Of_VectorIndexedByVector(type,index_type,&Lvalue);
    expr->MPC_Expr.Flag.Lvalue = Lvalue;
    expr->MPC_Expr.Flag.Const = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Const;
    if(!expr->MPC_Expr.Type || expr->MPC_Expr.Type->Kind==kMPC_BasicType) {
      Make_Message(210, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type(s) of operand(s) of indexing operator" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
  }
  else {
    Make_Message(207,xxError,
                 SourcePosition(expr->MPC_BinaryExpr.Roperand->MPC_Expr.Pos,
                                expr->MPC_BinaryExpr.Roperand), expr);
		/* "Invalid type of index" */
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
  }

}

/***********************/
void Eval_TypeOfUnaryExpr
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree operand, op_type /*terminal...*/, operand_type/*pure...*/;
  bool vector_operation = false;

  if(expr->MPC_UnaryExpr.Operand->MPC_Expr.Flag.Ignore ||
     expr->MPC_Expr.Flag.Ignore) {
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }
  operand = expr->MPC_UnaryExpr.Operand;

  Push_PurePattern(operand->MPC_Expr.Type);
  operand_type = Make_Type();

  expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;

  if(operand_type->Kind==kMPC_VectorType ||
     operand_type->Kind==kMPC_ArrayType && operand->MPC_Expr.Flag.Lvalue)
    op_type = TerminalType(operand_type), vector_operation = true;
  else
    op_type = operand_type;

  while(op_type->Kind==kMPC_Typedef)
    op_type = op_type->MPC_Typedef.Type;

  if(op_type->Kind==kMPC_ArrayType) {
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		 op_type->MPC_ArrayType.Step,
		 op_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op_type->MPC_ArrayType.DynStep;
    op_type = Make_Type();
  }

  switch(expr->MPC_UnaryExpr.OpCode) {    /* checks & res. type evaluation: */
  case BRACKETS:
    if(operand->MPC_Expr.Type->Kind==kMPC_PointerType) {
      Push_Pattern(
	mMPC_ArrayType(NoPosition, NoTree, NoTree, NoTypeFlag, UNDEFINED,
		operand->MPC_Expr.Type->MPC_PointerType.Step,
		operand->MPC_Expr.Type->MPC_PointerType.ElementType
	)
      );
      TopType()->MPC_ArrayType.ArraySize = nMPC_FreeNode();
      TopType()->MPC_ArrayType.DynStep = operand->MPC_Expr.Type->MPC_PointerType.DynStep;
      expr->MPC_Expr.Type = Make_Type();
    }
    else
      expr->MPC_Expr.Type = operand->MPC_Expr.Type;
    if(Is_CorrectBlockedExpr(operand))
      expr->MPC_Expr.Flag.Lvalue = YES;
    else {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(211, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid operand of the unary '[]'" */
      return;
    }
    expr->MPC_Expr.Flag.Const = NO;
    break;
  case POST_INC:
  case PRE_INC:
    if(!operand->MPC_Expr.Flag.Lvalue || operand->MPC_Expr.Flag.Const) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(212, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Operand of '++' is constant expression or not lvalue" */
      return;
    }
    if(op_type->Kind!=kMPC_BasicType && op_type->Kind!=kMPC_PointerType) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(213, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of '++'" */
      return;
    }
    break;
  case POST_DEC:
  case PRE_DEC:
    if(!operand->MPC_Expr.Flag.Lvalue || operand->MPC_Expr.Flag.Const) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(214, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Operand of '--' is constant expression or not lvalue" */
      return;
    }
    if(op_type->Kind!=kMPC_BasicType && op_type->Kind!=kMPC_PointerType) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(215, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of '--'" */
      return;
    }
    break;
  case ADDRESS:
    if(operand->Kind==kMPC_Ident &&
       operand->MPC_Ident.Store->MPC_Var.Flag.Register) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(216, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Storage class of operand of unary '&' is 'register'" */
      return;
    }
    if(!operand->MPC_Expr.Flag.Lvalue && operand->MPC_Expr.Type->Kind!=kMPC_ArrayType) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(217, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Operand of unary '&' is not lvalue" */
      return;
    }
    else if(operand->MPC_Expr.Type->Kind==kMPC_ArrayType && !operand->MPC_Expr.Flag.Lvalue) {
      /* special case of operand - no convertion array to pointer: */
      Push_Pattern(
	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag, 1, 1, operand->MPC_Expr.Type
	)
      );
      TopType()->MPC_PointerType.DynStep = operand->MPC_Expr.Type->MPC_ArrayType.DynStep;
      expr->MPC_Expr.Type = Make_Type();
      expr->MPC_Expr.Flag.Const = NO;
    }
    else {   /* general case - scalar or lvector operand: */
      int step = 1;
      tTree DynStep;
      if(operand->MPC_Expr.Type->Kind==kMPC_ArrayType) {
	step = operand->MPC_Expr.Type->MPC_ArrayType.Step;
	DynStep = operand->MPC_Expr.Type->MPC_ArrayType.DynStep;
      }
      else
	DynStep = nMPC_FreeNode();
      Push_Pattern(
	mMPC_PointerType(
		NoPosition, NoTree, NoTree, NoTypeFlag, 1, step, op_type
	)
      );
      TopType()->MPC_PointerType.DynStep = DynStep;
      expr->MPC_Expr.Type = NewVectorType(operand->MPC_Expr.Type, Make_Type()); /*vector!*/
      expr->MPC_Expr.Flag.Const = NO;
    }
    break;
  case STAR:
    if(!(op_type->Kind==kMPC_PointerType ||
	 operand->MPC_Expr.Type->Kind==kMPC_ArrayType && !operand->MPC_Expr.Flag.Lvalue) ||
	op_type->Kind==kMPC_PointerType &&
	op_type->MPC_PointerType.ElementType->Kind==kMPC_BasicType &&
	op_type->MPC_BasicType.TypeConstructor==VOID) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(218, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of unary '*'" */
      return;
    }
    else if(operand->MPC_Expr.Type->Kind==kMPC_ArrayType &&
	    !operand->MPC_Expr.Flag.Lvalue)  /* array, conversed to pointer: */
      expr->MPC_Expr.Type = operand->MPC_Expr.Type->MPC_ArrayType.ElementType;
    else
      expr->MPC_Expr.Type = NewVectorType(operand->MPC_Expr.Type,
					  op_type->MPC_ArrayType.ElementType);
    if(operand_type->Kind==kMPC_PointerType &&
       operand_type->MPC_PointerType.ElementType->Kind==kMPC_ArrayType)
      expr->MPC_Expr.Flag.Lvalue = NO; /* result_expr.Type is ARRAY ... */
    else
      expr->MPC_Expr.Flag.Lvalue = YES;
    if(expr->MPC_Expr.Type->MPC_Type.Flag.Const)
      expr->MPC_Expr.Flag.Const = YES;
    break;
  case PLUS:  /* unary '+' (has no effect): */
    if(!(op_type->Kind==kMPC_BasicType &&
	 op_type->MPC_BasicType.TypeConstructor<VOID ||
	 op_type->Kind==kMPC_PointerType)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(219, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of unary '+'" */
      return;
    }
    expr->MPC_Expr.Flag.Lvalue = NO;
    expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;
    break;
  case NEG:
    if(!(op_type->Kind==kMPC_BasicType && op_type->MPC_BasicType.TypeConstructor<VOID)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(220, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of unary '-'" */
      return;
    }
    expr->MPC_Expr.Flag.Lvalue = NO;
    expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;
    break;
  case NOT:
    if(!(op_type->Kind==kMPC_BasicType &&
	 op_type->MPC_BasicType.TypeConstructor<VOID &&
	 op_type->MPC_BasicType.TypeConstructor>=UNSIGNED_LONG)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(221, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of operator '~'" */
      return;
    }
    expr->MPC_Expr.Flag.Lvalue = NO;
    expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;
    break;
  case LOG_NOT:
    if(!(op_type->Kind==kMPC_BasicType &&
	 op_type->MPC_BasicType.TypeConstructor<VOID ||
	 op_type->Kind==kMPC_PointerType)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(222, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of operator '!'" */
      return;
    }
    expr->MPC_Expr.Type = NewVectorType(operand->MPC_Expr.Type,IntType);
    expr->MPC_Expr.Flag.Lvalue = NO;
    expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;
    break;
  case LIN_AND:
  case LIN_EXCL_OR:
  case LIN_INCL_OR:
  case LIN_LOG_AND:
  case LIN_LOG_OR:
  case DISTR_LIN_AND:
  case DISTR_LIN_EXCL_OR:
  case DISTR_LIN_INCL_OR:
  case DISTR_LIN_LOG_AND:
  case DISTR_LIN_LOG_OR:
    if(!(op_type->Kind==kMPC_BasicType &&
	 op_type->MPC_BasicType.TypeConstructor>=UNSIGNED_LONG &&
	 op_type->MPC_BasicType.TypeConstructor<VOID)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(223, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
	      	/* "Non-integral type (or type of element) of operand of the vector reduce operator" */
      return;
    }
  case LIN_MULT:
  case LIN_PLUS:
  case LIN_MAX:
  case LIN_MIN:
  case DISTR_LIN_MULT:
  case DISTR_LIN_PLUS:
  case DISTR_LIN_MAX:
  case DISTR_LIN_MIN:
    if(!(op_type->Kind==kMPC_BasicType && op_type->MPC_BasicType.TypeConstructor<VOID)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(224, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of operand of linear operator" */
      return;
    }
    if(expr->MPC_UnaryExpr.OpCode<DISTRIBUTED) { /* vector reduce operator: */
      if(operand->MPC_Expr.Type->Kind==kMPC_VectorType)
	expr->MPC_Expr.Type = operand->MPC_Expr.Type->MPC_VectorType.ElementType;
      else if(operand->MPC_Expr.Type->Kind==kMPC_ArrayType &&
	      operand->MPC_Expr.Flag.Lvalue  /* blocked array; */ )
	expr->MPC_Expr.Type = operand->MPC_Expr.Type->MPC_ArrayType.ElementType;
      else{
        expr->MPC_Expr.Type = ErrorType;
        expr->MPC_Expr.Flag.Ignore = YES;
        Make_Message(225, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Operand of linear operator is not vector" */
        return;
      }
      expr->MPC_Expr.Type = NewVectorType(expr->MPC_Expr.Type,op_type); 
    }
    expr->MPC_Expr.Flag.Lvalue = NO;
    expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;
    break;

  default:
    CompilerError("Invalid or unimplemented code of unary operator",
                  SourcePosition(expr->MPC_Expr.Pos, expr));
  }
  
  /*************** all checks are done; ****************/

  if(!expr->MPC_Expr.Type) { /* type of ADDRESS,STAR,BRACKETS & lin.oper. is ready; */
    if(op_type->Kind==kMPC_BasicType &&
       op_type->MPC_BasicType.TypeConstructor>INT) {  /* make integral promotion: */
      if(vector_operation)
        expr->MPC_Expr.Type = NewVectorType(operand->MPC_Expr.Type, IntType);
      else
        expr->MPC_Expr.Type = operand->MPC_Expr.Type;
    }
    else
      expr->MPC_Expr.Type = operand->MPC_Expr.Type;
    if(expr->MPC_Expr.Type->Kind==kMPC_ArrayType &&
       expr->MPC_UnaryExpr.OpCode!=BRACKETS)
      expr->MPC_Expr.Type = NewVectorType(operand->MPC_Expr.Type, op_type);
  }
  if(operand->MPC_Expr.Repl && operand_type->MPC_Type.Flag.Repl &&
     !expr->MPC_Expr.Type->MPC_Type.Flag.Repl) {  /* reevaluate 'Type': */
    tTree new_type;
    new_type = MakeTree(expr->MPC_Expr.Type->Kind);
    *new_type = *(expr->MPC_Expr.Type);
    new_type->MPC_Type.Flag.Repl = YES;
    Push_Pattern(new_type);
    expr->MPC_Expr.Type = Make_Type();
  }
 
}

/************************/
void Eval_TypeOfBinaryExpr
/************************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree tmp;
  tTree target_type = NoTree;
  tTree op1, op2;
  tTree op1_type, op2_type;  /* operands terminal types -- for cast; */
  int is_const, lvalue = NO;
  bool vector_operation = false;

  if(expr->MPC_Expr.Flag.Ignore ||
     expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Ignore ||
     expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Ignore) {
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }

  op1 = expr->MPC_BinaryExpr.Loperand;
  op2 = expr->MPC_BinaryExpr.Roperand;
  is_const = op1->MPC_Expr.Flag.Const & op2->MPC_Expr.Flag.Const;

  if(op1->MPC_Expr.Type->Kind==kMPC_VectorType ||
     op1->MPC_Expr.Type->Kind==kMPC_ArrayType && op1->MPC_Expr.Flag.Lvalue) {
    vector_operation = true;
    op1_type = TerminalType(op1->MPC_Expr.Type);
    if((op2->MPC_Expr.Type->Kind==kMPC_VectorType ||
        op2->MPC_Expr.Type->Kind==kMPC_ArrayType && op2->MPC_Expr.Flag.Lvalue) &&
       op1->MPC_Expr.Type->MPC_DerivedType.NumberOfComponents !=
       op2->MPC_Expr.Type->MPC_DerivedType.NumberOfComponents &&
       !(op1->MPC_Expr.Type->MPC_Type.Flag.DynArray || op2->MPC_Expr.Type->MPC_Type.Flag.DynArray) &&
       expr->MPC_BinaryExpr.OpCode!=ASSIGN /*This is a special case !!! */ ) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(226, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Vector operands of the binary operator have different length" */
      return;
    }
  }
  else
    op1_type = op1->MPC_Expr.Type;

  if(op2->MPC_Expr.Type->Kind==kMPC_VectorType ||
     op2->MPC_Expr.Type->Kind==kMPC_ArrayType && op2->MPC_Expr.Flag.Lvalue) {
    vector_operation = true;
    op2_type = TerminalType(op2->MPC_Expr.Type);
  }
  else
    op2_type = op2->MPC_Expr.Type;

  Disable_SUE_Typedef();
  Push_PurePattern(op1_type); op1_type = Make_Type();
  Push_PurePattern(op2_type); op2_type = Make_Type();
  Enable_SUE_Typedef();

  if(op1_type->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		op1_type->MPC_ArrayType.Step, op1_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op1_type->MPC_ArrayType.DynStep;
    op1_type = Make_Type();
  }
  if(op2_type->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		op2_type->MPC_ArrayType.Step, op2_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op2_type->MPC_ArrayType.DynStep;
    op2_type = Make_Type();
  }

  switch(expr->MPC_BinaryExpr.OpCode) {
  case DOT:
    op1_type = op1->MPC_Expr.Type;      /* '.' is not available for vector operand; */
    while(op1_type->Kind==kMPC_Typedef)
      op1_type = op1_type->MPC_Typedef.Type;

    /* find full struct/union type declaration: */
    {
      tTree eq_type = op1_type;
      while((op1_type->Kind==kMPC_StructType || op1_type->Kind==kMPC_UnionType) &&
	    op1_type->MPC_StructType.MemberDecls==NoTree &&
	    op1_type->MPC_Type.EquivType!=NoTree &&
	    op1_type->MPC_Type.EquivType!=eq_type)
	op1_type = op1_type->MPC_Type.EquivType;
    }

    if(op1_type->Kind!=kMPC_StructType && op1_type->Kind!=kMPC_UnionType) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(227, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of '.' is not struct or union" */
      return;
    }
    else if(!(tmp=Find_Member(op2->MPC_Ident.Ident,
	      op1_type->MPC_StructType.MemberDecls))) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_MessageI(228, xxError, SourcePosition(expr->MPC_Expr.Pos, expr),
		    xxIdent, (char*)&op2->MPC_Ident.Ident, expr);
		/* "Struct or union has no member named" */
      return;
    }
    else {
      tTree tmp_type;
      op2->MPC_Ident.Store = tmp;
      Push_PurePattern(tmp->MPC_SU_Member.Type);
      tmp_type = Make_Type();
      expr->MPC_Expr.Type = op2->MPC_Expr.Type = tmp_type;
      lvalue = expr->MPC_Expr.Type->Kind==kMPC_ArrayType ? NO : YES;
      is_const = expr->MPC_Expr.Type->MPC_Type.Flag.Const;
    }
    break;
  case ARROW:
    {
      tTree elem_type, eq_type;
      op1_type = op1->MPC_Expr.Type;	/* '->' is not available for vector operand; */
      while(op1_type->Kind==kMPC_Typedef)
        op1_type = op1_type->MPC_Typedef.Type;
      if(!op1->MPC_Expr.Flag.Lvalue &&
	 op1_type->Kind==kMPC_ArrayType) {  /* convert array to pointer */
        Push_Pattern(
	  mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		op1_type->MPC_ArrayType.Step, op1_type->MPC_ArrayType.ElementType
	  )
        );
        TopType()->MPC_PointerType.DynStep = op1_type->MPC_ArrayType.DynStep;
        op1_type = Make_Type();
      }
      if(op1_type->Kind==kMPC_PointerType)
	elem_type = op1_type->MPC_PointerType.ElementType;
      else
        elem_type = op1_type;  /* for error ... */
      while(elem_type->Kind==kMPC_Typedef)
        elem_type = elem_type->MPC_Typedef.Type;

      /* find full struct/union type declaration: */
      eq_type = elem_type;
      while((elem_type->Kind==kMPC_StructType || elem_type->Kind==kMPC_UnionType) &&
	    elem_type->MPC_StructType.MemberDecls==NoTree &&
	    elem_type->MPC_Type.EquivType!=NoTree &&
	    elem_type->MPC_Type.EquivType!=eq_type)
	elem_type = elem_type->MPC_Type.EquivType;

      if(!(op1_type->Kind==kMPC_PointerType &&
          (elem_type->Kind==kMPC_StructType || elem_type->Kind==kMPC_UnionType))) {
        expr->MPC_Expr.Type = ErrorType;
        expr->MPC_Expr.Flag.Ignore = YES;
        Make_Message(229, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of '->' is not pointer to struct or union" */
        return;
      }
      else if(!(tmp=Find_Member(op2->MPC_Ident.Ident,
				elem_type->MPC_StructType.MemberDecls))) {
        expr->MPC_Expr.Type = ErrorType;
        expr->MPC_Expr.Flag.Ignore = YES;
        Make_MessageI(228, xxError, SourcePosition(expr->MPC_Expr.Pos, expr),
		      xxIdent, (char*)&op2->MPC_Ident.Ident, expr);
		/* "Struct or union has no member named" */
        return;
      }
      else {
        tTree tmp_type;
        op2->MPC_Ident.Store = tmp;
        Push_PurePattern(tmp->MPC_SU_Member.Type);
        tmp_type = Make_Type();
        expr->MPC_Expr.Type = op2->MPC_Expr.Type = tmp_type;
        lvalue = expr->MPC_Expr.Type->Kind==kMPC_ArrayType ? NO : YES;
        is_const = expr->MPC_Expr.Type->MPC_Type.Flag.Const;
      }
      break;
    }
  case MULT:
  case DIV:
    if(op1_type->Kind!=kMPC_BasicType || op1_type->MPC_BasicType.TypeConstructor==VOID) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(230, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of left operand of the multiplicative operator" */
      return;
    }
    if(op2_type->Kind!=kMPC_BasicType || op2_type->MPC_BasicType.TypeConstructor==VOID) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(231, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of right operand of the multiplicative operator" */
      return;
    }
    break;
  case MOD:
    if(!(op1_type->Kind==kMPC_BasicType &&
	 op1_type->MPC_BasicType.TypeConstructor<VOID &&
	 op1_type->MPC_BasicType.TypeConstructor>FLOAT)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(232, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of left operand of '%'" */
      return;
    }
    if(!(op1_type->Kind==kMPC_BasicType &&
	 op1_type->MPC_BasicType.TypeConstructor<VOID &&
	 op1_type->MPC_BasicType.TypeConstructor>FLOAT)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(233, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of right operand of '%'" */
      return;
    }
    break;
  case PLUS:
    if(op2->MPC_Expr.Type->Kind==kMPC_ArrayType &&
       !op2->MPC_Expr.Flag.Lvalue  /* array, converted to pointer */  &&
       !Is_IntegralType(op1_type)  ||
       op1_type->Kind!=kMPC_BasicType && op1_type->Kind!=kMPC_PointerType  ||
       op2_type->Kind==kMPC_PointerType && !Is_IntegralType(op1_type)  ||
       op1_type->Kind==kMPC_BasicType && op1_type->MPC_BasicType.TypeConstructor==VOID) {
      Make_Message(234, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of left operand of binary '+'" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
    if(op1->MPC_Expr.Type->Kind==kMPC_ArrayType &&
       !op1->MPC_Expr.Flag.Lvalue  /* array, converted to pointer */  &&
       !Is_IntegralType(op2_type)  ||
       op2_type->Kind!=kMPC_BasicType && op2_type->Kind!=kMPC_PointerType  ||
       op1_type->Kind==kMPC_PointerType && !Is_IntegralType(op2_type)  ||
       op2_type->Kind==kMPC_BasicType && op2_type->MPC_BasicType.TypeConstructor==VOID) {
      Make_Message(235, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of right operand of binary '+'" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
    else if(op1->MPC_Expr.Type->Kind==kMPC_ArrayType && !op1->MPC_Expr.Flag.Lvalue) {
      Push_Pattern(
	mMPC_PointerType(
		NoPosition, NoTree, NoTree, op1->MPC_Expr.Type->MPC_Type.Flag, 1,
		op1->MPC_Expr.Type->MPC_ArrayType.Step,
		op1->MPC_Expr.Type->MPC_ArrayType.ElementType
	)
      );
      TopType()->MPC_PointerType.DynStep = op1->MPC_Expr.Type->MPC_ArrayType.DynStep;
      expr->MPC_Expr.Type = Eval_TypeConversion(Make_Type(), op2->MPC_Expr.Type);
    }
    else if(op2->MPC_Expr.Type->Kind==kMPC_ArrayType && !op2->MPC_Expr.Flag.Lvalue) {
      Push_Pattern(
	mMPC_PointerType(
		NoPosition, NoTree, NoTree, op2->MPC_Expr.Type->MPC_Type.Flag, 1,
		op2->MPC_Expr.Type->MPC_ArrayType.Step,
		op2->MPC_Expr.Type->MPC_ArrayType.ElementType
	)
      );
      TopType()->MPC_PointerType.DynStep = op2->MPC_Expr.Type->MPC_ArrayType.DynStep;
      expr->MPC_Expr.Type = Eval_TypeConversion(op1->MPC_Expr.Type, Make_Type());
    }
    else if(op1_type->Kind==kMPC_PointerType && !vector_operation)
      expr->MPC_Expr.Type = op1->MPC_Expr.Type;
    else if(op2_type->Kind==kMPC_PointerType && !vector_operation)
      expr->MPC_Expr.Type = op2->MPC_Expr.Type;
    break;
  case MINUS:
    if(!(Is_ArithmeticType(op1_type) && Is_ArithmeticType(op2_type)  ||
	 op1_type->Kind==kMPC_PointerType &&
	 (op2_type->Kind==kMPC_PointerType &&
	  op1_type->MPC_PointerType.ElementType==op2_type->MPC_PointerType.ElementType &&
	  op1_type->MPC_PointerType.Step==op2_type->MPC_PointerType.Step
	  || Is_IntegralType(op2_type)))) {
      Make_Message(236, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible types of operands of binary '-'" */
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      return;
    }
    else if(op1_type->Kind==kMPC_PointerType)
      if(op2_type->Kind==kMPC_PointerType)
	expr->MPC_Expr.Type = PTRDIFF_T;
      else  /* op2_type is integer: */
	if(vector_operation)
	  expr->MPC_Expr.Type = Eval_TypeConversion(
					NewVectorType(op1->MPC_Expr.Type,op1_type),
					op2->MPC_Expr.Type
				);
	else
	  expr->MPC_Expr.Type = Eval_TypeConversion(op1_type,op2->MPC_Expr.Type);
    break;
  case LEFT_SHIFT:
  case RIGHT_SHIFT:
    if(!Is_IntegralType(op1_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(237, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of left operand of the shift operator" */
      return;
    }
    if(!Is_IntegralType(op2_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(238, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of right operand of the shift operator" */
      return;
    }
    break;
  case LESS_THEN:
  case GREAT_THEN:
  case LESS_OR_EQ:
  case GREAT_OR_EQ:
    if(!(Is_ArithmeticType(op1_type) && Is_ArithmeticType(op2_type)  ||
	 op1_type->Kind==kMPC_PointerType && op1_type->Kind==kMPC_PointerType &&
	 op1_type->MPC_PointerType.ElementType==op2_type->MPC_PointerType.ElementType)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(239, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible types of operands of the relational operator" */
      return;
    }
    expr->MPC_Expr.Type = vector_operation   ?
			  NewVectorType(
				ResultVectorType(op1->MPC_Expr.Type,op2->MPC_Expr.Type),
				IntType
			  )   :   IntType;
    break;
  case EQUAL:
  case NOT_EQUAL:
    if(!(Is_ArithmeticType(op1_type) && Is_ArithmeticType(op2_type)  ||
	 op1_type->Kind==kMPC_PointerType && op2_type->Kind==kMPC_PointerType &&
	 op1_type->MPC_PointerType.ElementType==op2_type->MPC_PointerType.ElementType  ||
	 op1_type->Kind==kMPC_PointerType &&
	 !Is_VoidType(op1_type->MPC_PointerType.ElementType) &&
	 op2_type->Kind==kMPC_PointerType &&
	 Is_VoidType(op2_type->MPC_PointerType.ElementType) ||
	 op2_type->Kind==kMPC_PointerType &&
	 !Is_VoidType(op2_type->MPC_PointerType.ElementType) &&
	 op1_type->Kind==kMPC_PointerType &&
	 Is_VoidType(op1_type->MPC_PointerType.ElementType) ||
	 op1_type->Kind==kMPC_PointerType && Is_IntegralType(op2_type) &&
	 (op2->Kind==kMPC_IntConst && op2->MPC_IntConst.Value==NULL_POINTER ||
	  op2->Kind==kMPC_UIntConst && op2->MPC_UIntConst.Value==NULL_POINTER) ||
	 op2_type->Kind==kMPC_PointerType && Is_IntegralType(op1_type) &&
	 (op1->Kind==kMPC_IntConst && op1->MPC_IntConst.Value==NULL_POINTER ||
	  op1->Kind==kMPC_UIntConst && op1->MPC_UIntConst.Value==NULL_POINTER))) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(240, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible types of operands of the equality operator" */
      return;
    }
    expr->MPC_Expr.Type = vector_operation   ?
			  NewVectorType(
				ResultVectorType(op1->MPC_Expr.Type,op2->MPC_Expr.Type),
				IntType
			  )   :   IntType ;
    break;
  case AND:
  case EXCL_OR:
  case INCL_OR:
  case LOG_AND:
  case LOG_OR:
    if(!Is_IntegralType(op1_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(241, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of left operand of the logical operator" */
      return;
    }
    if(!Is_IntegralType(op2_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(242, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid type of right operand of the logical operator" */
      return;
    }
    break;
  case ASSIGN:
    if( !(Is_ArithmeticType(op1_type) && Is_ArithmeticType(op2_type)  ||
	  op1_type==op2_type && op1_type->Kind!=kMPC_FunctionType  ||
	  op1_type->Kind==kMPC_PointerType && op2_type->Kind==kMPC_PointerType &&
	  Is_EqualType(op1_type->MPC_PointerType.ElementType,
		       op2_type->MPC_PointerType.ElementType, false/*strict*/)  ||
	  op1_type->Kind==kMPC_PointerType && Is_IntegralType(op2_type) &&
	  (op2->Kind==kMPC_IntConst && op2->MPC_IntConst.Value==NULL_POINTER ||
	   op2->Kind==kMPC_UIntConst && op2->MPC_UIntConst.Value==NULL_POINTER)  ||
	  op1_type->Kind==kMPC_PointerType &&
	  op2_type->Kind==kMPC_PointerType &&
	  (Is_VoidType(op1_type->MPC_PointerType.ElementType) ||
	   Is_VoidType(op2_type->MPC_PointerType.ElementType)) ||
	  op1->MPC_Expr.Type->Kind==kMPC_PointerType &&
	  op2->MPC_Expr.Type->Kind==kMPC_ArrayType && !(op2->MPC_Expr.Flag.Lvalue)  ||
	  Is_Same_PointerToFunction(op1_type, op2_type) ||
	  (op1_type->Kind==kMPC_StructType || op1_type->Kind==kMPC_UnionType) &&
		 Is_EqualType(op1_type, op2_type, true/*strict*/)  /* the same S/U-type... */
	 ) ||
	!CompatibleVectorsInAssign(op1, op2) ) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(243, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible types of operands of '='" */
      return;
    }
    if(!op1->MPC_Expr.Flag.Lvalue) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(244, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of '=' is not lvalue" */
      return;
    }
    if(op1->MPC_Expr.Flag.Const) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(245, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of '=' is read-only" */
      return;
    }
    else if(op1->MPC_Expr.Type->Kind==kMPC_ArrayType)
      expr->MPC_Expr.Type = NewVectorType(op1->MPC_Expr.Type,op1_type);
    else
      expr->MPC_Expr.Type = op1->MPC_Expr.Type;
    target_type = op1->MPC_Expr.Type;
    is_const = NO;
    break;
  case MOD_ASSIGN:
  case LSHIFT_ASSIGN:
  case RSHIFT_ASSIGN:
  case AND_ASSIGN:
  case EXCL_OR_ASSIGN:
  case INCL_OR_ASSIGN:
    if(!Is_IntegralType(op1_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(246, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of compound assignment has not integral type" */
      return;
    }
    if(!Is_IntegralType(op2_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(247, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Right operand of compound assignment has not integral type" */
      return;
    }
  case MULT_ASSIGN:
  case DIV_ASSIGN:
    if(!Is_ArithmeticType(op1_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(248, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of compound assignment has not arithmetic type" */
      return;
    }
    if(!Is_ArithmeticType(op2_type)) {
      expr->MPC_Expr.Type = ErrorType;
     expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(249, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Right operand of compound assignment has not arithmetic type" */
      return;
    }
  case PLUS_ASSIGN:
  case MINUS_ASSIGN:
    if(Is_PointerType(op1_type)) {
      if(!Is_IntegralType(op2_type)) {
        expr->MPC_Expr.Type = ErrorType;
        expr->MPC_Expr.Flag.Ignore = YES;
        Make_Message(250, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid (not integral) type of right operand of compound assignment" */
        return;
      }
    }
    else if(!Is_ArithmeticType(op1_type) || !Is_ArithmeticType(op2_type)) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(251, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible operand types in compound assignment" */
      return;
    }
    if(!op1->MPC_Expr.Flag.Lvalue) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(252, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of compound assignment is not lvalue" */
      return;
    }
    if(op1->MPC_Expr.Flag.Const) {
      expr->MPC_Expr.Type = ErrorType;
      expr->MPC_Expr.Flag.Ignore = YES;
      Make_Message(253, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Left operand of compound assignment is declared with 'const' qualifier" */
      return;
    }
    else if(op1->MPC_Expr.Type->Kind==kMPC_ArrayType)
      expr->MPC_Expr.Type = NewVectorType(op1->MPC_Expr.Type,op1_type);
    else
      expr->MPC_Expr.Type = op1->MPC_Expr.Type;
    target_type = op1->MPC_Expr.Type;
    is_const = NO;
    break;
  case COMMA:
    expr->MPC_Expr.Type = op2->MPC_Expr.Type;
    is_const = op2->MPC_Expr.Flag.Const;
    break;
  default :
    CompilerError("Invalid or unimplemented binary operator", SourcePosition(expr->MPC_Expr.Pos, expr));
  }

  /************ all checks are done **************/

  if(expr->MPC_Expr.Flag.Ignore) return;
  if(!expr->MPC_Expr.Type)
    expr->MPC_Expr.Type = Eval_TypeConversion(op1->MPC_Expr.Type, op2->MPC_Expr.Type);
  if(op1->MPC_Expr.Repl && op2->MPC_Expr.Repl &&
     !expr->MPC_Expr.Type->MPC_Type.Flag.Repl) {  /* reevaluate 'Type': */
    tTree new_type;
    new_type = MakeTree(expr->MPC_Expr.Type->Kind);
    *new_type = *(expr->MPC_Expr.Type);
    new_type->MPC_Type.Flag.Repl = YES;
    Push_Pattern(new_type);
    expr->MPC_Expr.Type = Make_Type();
  }
  expr->MPC_Expr.Flag.Lvalue = lvalue;
  expr->MPC_Expr.Flag.Const = is_const;

}

/*************************/
void Eval_TypeOfTernaryExpr
/*************************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree target_type = NoTree;
  tTree op1, op2, op3;
  tTree op1_type, op2_type, op3_type;  /* operand's terminal types -- for cast; */
  int is_const;
  bool vector_operation = false;

  if(expr->MPC_TernaryExpr.OpCode!=CONDITION) {
    Make_Message(254, xxRestriction, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Sorry, this operator is not implemented" */
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }
  op1 = expr->MPC_TernaryExpr.Foperand;
  op2 = expr->MPC_TernaryExpr.Soperand;
  op3 = expr->MPC_TernaryExpr.Toperand;

  if(expr->MPC_Expr.Flag.Ignore || op1->MPC_Expr.Flag.Ignore ||
     op2->MPC_Expr.Flag.Ignore  || op3->MPC_Expr.Flag.Ignore) {
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }

  is_const = op1->MPC_Expr.Flag.Const & op2->MPC_Expr.Flag.Const &&
	     op3->MPC_Expr.Flag.Const;

  Disable_SUE_Typedef();
  Push_PurePattern(op1->MPC_Expr.Type); op1_type = Make_Type();
  Push_PurePattern(op2->MPC_Expr.Type); op2_type = Make_Type();
  Push_PurePattern(op3->MPC_Expr.Type); op3_type = Make_Type();
  Enable_SUE_Typedef();

  if(op1->MPC_Expr.Flag.Lvalue || op1_type->Kind!=kMPC_ArrayType)
    op1_type = TerminalType(op1_type);
  if(op2->MPC_Expr.Flag.Lvalue || op2_type->Kind!=kMPC_ArrayType)
    op2_type = TerminalType(op2_type);
  if(op3->MPC_Expr.Flag.Lvalue || op3_type->Kind!=kMPC_ArrayType)
    op3_type = TerminalType(op3_type);

  if(op2_type->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		op2_type->MPC_ArrayType.Step, op2_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op2_type->MPC_ArrayType.DynStep;
    op2_type = Make_Type();
  }
  if(op3_type->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, NoTypeFlag, 1,
		op3_type->MPC_ArrayType.Step, op3_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op3_type->MPC_ArrayType.DynStep;
    op3_type = Make_Type();
  }

 /**** check on correct. of VECTOR operands!!! (size,dimension,...) ****/

  if((op1->MPC_Expr.Type->Kind==kMPC_ArrayType &&
      op1->MPC_Expr.Flag.Lvalue ||
      op1->MPC_Expr.Type->Kind==kMPC_VectorType)  ||
     op2!=NoTree && (op2->MPC_Expr.Type->Kind==kMPC_ArrayType &&
	             op2->MPC_Expr.Flag.Lvalue ||
		     op2->MPC_Expr.Type->Kind==kMPC_VectorType)  ||
     op3!=NoTree && (op3->MPC_Expr.Type->Kind==kMPC_ArrayType &&
	             op3->MPC_Expr.Flag.Lvalue ||
		     op3->MPC_Expr.Type->Kind==kMPC_VectorType)) {

    int length[3], max_length, i;

    vector_operation = true;

    length[0] = op1!=NoTree && (op1->MPC_Expr.Type->Kind==kMPC_ArrayType ||
	 		        op1->MPC_Expr.Type->Kind==kMPC_VectorType)  ?
                op1->MPC_Expr.Type->MPC_DerivedType.NumberOfComponents  :  0;
    length[1] = op2!=NoTree && (op2->MPC_Expr.Type->Kind==kMPC_ArrayType ||
	 		        op2->MPC_Expr.Type->Kind==kMPC_VectorType)  ?
                op2->MPC_Expr.Type->MPC_DerivedType.NumberOfComponents  :  0;
    length[2] = op3!=NoTree && (op3->MPC_Expr.Type->Kind==kMPC_ArrayType ||
	 		        op3->MPC_Expr.Type->Kind==kMPC_VectorType)  ?
                op3->MPC_Expr.Type->MPC_DerivedType.NumberOfComponents  :  0;

    for(i=1,max_length=length[0]; i<3; i++) {
      if(max_length && length[i] && max_length!=length[i]) {
	Make_Message(255, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Different length of vector operands of operator '?:'" */
        expr->MPC_Expr.Type = ErrorType;
	expr->MPC_Expr.Flag.Ignore = YES;
	return;
      }
      max_length = Max(max_length,length[i]);
    }
    if(op1!=NoTree && op2!=NoTree && op3!=NoTree)
      expr->MPC_Expr.Type = ResultVectorType(op1->MPC_Expr.Type,
				       ResultVectorType(op2->MPC_Expr.Type,
							  op3->MPC_Expr.Type));
    else if(!op2)
      expr->MPC_Expr.Type = ResultVectorType(op1->MPC_Expr.Type,op3->MPC_Expr.Type);
    else /*** if(!operand3) ***/
      expr->MPC_Expr.Type = ResultVectorType(op1->MPC_Expr.Type,op2->MPC_Expr.Type);
    expr->MPC_Expr.Type = NewVectorType(expr->MPC_Expr.Type,TerminalType(expr->MPC_Expr.Type));
  } /* VECTOR CHECKS DONE. */

  if(!Is_ScalarType(op1_type)) {
    Make_Message(256, xxError, SourcePosition(op1->MPC_Expr.Pos, op1), expr);
		/* "Invalid type of condition in conditional expression" */
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }
  else if(!(Is_ArithmeticType(op2_type) && Is_ArithmeticType(op3_type) ||
	    Is_VoidType(op2_type) && Is_VoidType(op3_type) ||
	    op2_type==op3_type || Is_EqualType(op2_type, op3_type, false/*strict*/) ||
	    Is_PointerType(op2_type) && Is_VoidPointerType(op3_type) ||
	    Is_PointerType(op3_type) && Is_VoidPointerType(op2_type) ||
	    Is_PointerType(op2_type) && Is_PointerType(op3_type) &&
		(Is_NULL(op2) || Is_NULL(op3))
	   )) {
    Make_Message(257, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid or incompatible types of operands #2 and #3 of conditional expression" */
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }
  else {  /* all right! */
    /******************** TMP: ************************/
    expr->MPC_Expr.Flag.Const = expr->MPC_TernaryExpr.Soperand->MPC_Expr.Flag.Const &&
				expr->MPC_TernaryExpr.Toperand->MPC_Expr.Flag.Const;
    expr->MPC_Expr.Flag.Lvalue = expr->MPC_TernaryExpr.Soperand->MPC_Expr.Flag.Lvalue &&
				expr->MPC_TernaryExpr.Toperand->MPC_Expr.Flag.Lvalue;
    if(expr->MPC_Expr.Type==NoTree /* scalar operands of one type: */
       && op2->MPC_Expr.Type==op3->MPC_Expr.Type && !Is_ArithmeticType(op2->MPC_Expr.Type)) 
      expr->MPC_Expr.Type = op2->MPC_Expr.Type;
    else if(expr->MPC_Expr.Type==NoTree /* scalar operands of diff. types: */ )
      expr->MPC_Expr.Type = Eval_TypeConversion(op2->MPC_Expr.Type,op3->MPC_Expr.Type);
    if(op2_type!=op3_type || op2_type!=NoTree && op2_type->Kind==kMPC_BasicType &&
       op2_type->MPC_BasicType.TypeConstructor<INT) { /* make int.promotion or cast:*/
      target_type = Eval_TypeConversion(op2_type,op3_type);
      if(expr->MPC_Expr.Type->Kind!=kMPC_BasicType) /* vector operands with diff.elem.types: */
	expr->MPC_Expr.Type = NewVectorType(expr->MPC_Expr.Type, target_type);
    }
  }

}

/**********************/
void Eval_TypeOfGridExpr
/**********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;
#endif
{
  tTree operand, op_type /*terminal...*/, operand_type/*pure...*/;
  bool vector_operation = false,
       replicated = true;

  if(expr->MPC_QuaternaryExpr.Operand1->MPC_Expr.Flag.Ignore ||
     expr->MPC_Expr.Flag.Ignore) {
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = YES;
    return;
  }
  operand = expr->MPC_QuaternaryExpr.Operand1;

  Push_PurePattern(operand->MPC_Expr.Type);
  operand_type = Make_Type();

  expr->MPC_Expr.Flag.Const = operand->MPC_Expr.Flag.Const;


  op_type = operand_type;
  while(op_type->Kind==kMPC_VectorType ||	/* ?????????????????????? */
        op_type->Kind==kMPC_ArrayType && operand->MPC_Expr.Flag.Lvalue) {
    tTree NewPattern;
      NewPattern = MakeTree(op_type->Kind);
      *NewPattern = *op_type;
    Push_Pattern(NewPattern);
    if(op_type->Kind==kMPC_VectorType)
      op_type = op_type->MPC_VectorType.ElementType;
    else
      op_type = op_type->MPC_ArrayType.ElementType;
    vector_operation = true;
  }

  while(op_type->Kind==kMPC_Typedef)
    op_type = op_type->MPC_Typedef.Type;

  if(op_type->Kind==kMPC_ArrayType) {	/* ????? */
    NestedType_ON();
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree,
                 op_type->MPC_ArrayType.Flag, 1,
		 op_type->MPC_ArrayType.Step,
		 op_type->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = op_type->MPC_ArrayType.DynStep;
    TopType()->MPC_PointerType.GeneratedFrom = op_type;
    op_type = Make_Type();
    NestedType_OFF();
  }

  replicated = op_type->MPC_Type.Flag.Repl;

  if(op_type->Kind!=kMPC_PointerType) {
    operand->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.Flag.Ignore = operand->MPC_Expr.Flag.Ignore = YES;
    Make_Message(258, xxError, SourcePosition(operand->MPC_Expr.Pos, operand), operand);
		/* "Invalid type of first operand of grid operator [:]" */
    /**Make_Message("First operand of grid operator [:] is not pointer or vector of pointers",	**/
    /**              xxError, operand->MPC_Expr.Pos, operand);					**/
    return;
  }

  /******************************************/
    {
      bool dynamic = false,   /* whether the resulting type is dynamic array... */
           dynamic_step = false;
      tTree  size, tmp,
             lbound = expr->MPC_QuaternaryExpr.Operand2,
             ubound = expr->MPC_QuaternaryExpr.Operand3,
             grid_step = expr->MPC_QuaternaryExpr.Operand4;
      tTree  size_net = CONST_NET,
             size_net_list = CONST_NET_LIST,
             step_net = CONST_NET,
             step_net_list = CONST_NET_LIST;
      
      long   size_value = UNDEFINED,  /* may be 0 when dynamic array... */
             lbound_value = 0,
             ubound_value = UNDEFINED,
             step_value = 1;
      bool max_ubound = false;  /* whether expr 'ubound' is equal to array 'ubound' */

      if(lbound->Kind==kMPC_IntConst)
        lbound_value = lbound->MPC_IntConst.Value;
      else if(lbound->Kind==kMPC_UIntConst)
        lbound_value = lbound->MPC_UIntConst.Value;
      else if(lbound->Kind==kMPC_FreeNode)
        ;  /* lbound_value = 0 -- ready; */
      else {
        dynamic = true;
        lbound_value = UNDEFINED;
        size_net = lbound->MPC_Expr.StoreNet;
        size_net_list = lbound->MPC_Expr.EvalNet;
        replicated &= (lbound->MPC_Expr.Repl || lbound->MPC_Expr.Type->MPC_Type.Flag.Repl);
      }

      if(ubound->Kind==kMPC_IntConst) {
        ubound_value = ubound->MPC_IntConst.Value;
      }
      else if(ubound->Kind==kMPC_UIntConst) {
        ubound_value = ubound->MPC_UIntConst.Value;
      }
      else if(ubound->Kind==kMPC_FreeNode) {
	max_ubound = true;
        /* get ubound and ubound_value from the corresponding array type (if present): */
        if(op_type->MPC_PointerType.GeneratedFrom!=NoTree &&
           op_type->MPC_PointerType.GeneratedFrom->Kind==kMPC_ArrayType) {
          ubound = op_type->MPC_PointerType.GeneratedFrom->MPC_ArrayType.ArraySize;
          ubound_value = op_type->MPC_PointerType.GeneratedFrom->MPC_ArrayType.NumberOfComponents;
          if(ubound_value!=UNDEFINED && ubound_value!=0)
            ubound_value--;
          if(ubound!=NoTree && ubound->Kind!=kMPC_FreeNode) {
            dynamic = true;
            replicated &= (ubound->MPC_Expr.Repl || ubound->MPC_Expr.Type->MPC_Type.Flag.Repl);
          }
        }
        else
          ubound_value = UNDEFINED;
      }
      else {
        size_net = dynamic ? size_net : ubound->MPC_Expr.StoreNet;
        size_net_list = dynamic ? size_net_list : ubound->MPC_Expr.EvalNet;
        dynamic = true;
        replicated &= (ubound->MPC_Expr.Repl || ubound->MPC_Expr.Type->MPC_Type.Flag.Repl);
      }

      if(grid_step->Kind==kMPC_IntConst)
        step_value = grid_step->MPC_IntConst.Value;
      else if(grid_step->Kind==kMPC_UIntConst)
        step_value = grid_step->MPC_UIntConst.Value;
      else if(grid_step->Kind==kMPC_FreeNode)
        ;  /* step_value = 1 -- ready; */
      else {
        dynamic_step = dynamic = true;
        replicated &= (grid_step->MPC_Expr.Repl || grid_step->MPC_Expr.Type->MPC_Type.Flag.Repl);
        step_net = lbound->MPC_Expr.StoreNet;       /* ??? */
        step_net_list = lbound->MPC_Expr.EvalNet;   /* ??? */
      }

      if(dynamic) {
	size_value = 0;
        if(lbound_value)
          size = mMPC_BinaryExpr(NoPosition, NoExprFlag, EmptyString, IntType,
			         size_net_list, size_net, MINUS, ubound, lbound);
	else if(max_ubound && lbound_value==0) {
	  tmp = mMPC_IntConst(NoPosition, NoExprFlag, EmptyString, IntType,
			      CONST_NET_LIST, CONST_NET, Symbolic_IntConst[1], 1);
          size = mMPC_BinaryExpr(NoPosition, NoExprFlag, EmptyString, IntType,
			         size_net_list, size_net, MINUS, ubound, tmp);
	}
        else {  /* lbound_value is 0, but max_ubound==false */
	  size = ubound;
	}
        if(step_value!=1 || dynamic_step) {
          size->MPC_Expr.Flag.InParentheses = YES;
          size = mMPC_BinaryExpr(NoPosition, NoExprFlag, EmptyString, IntType,
			         size_net_list, size_net, DIV, size, grid_step);
        }
        tmp = mMPC_IntConst(NoPosition, NoExprFlag, EmptyString, IntType,
			    CONST_NET_LIST, CONST_NET, Symbolic_IntConst[1], 1);
        size = mMPC_BinaryExpr(NoPosition, NoExprFlag, EmptyString, IntType,
			       size_net_list, size_net, PLUS, size, tmp);
      }
      else {  /* lbound, ubound and grid_step are constants: */
        size_value = (ubound_value - lbound_value) / step_value + 1 ;
        size = mMPC_FreeNode(NoTree);
      }

      /* all type attributes are ready, but ElementType may be array... check and convert to * : *
       * -- this action is disabled in the current version  because grid semantic is changed !!! *
       * <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

      op_type = op_type->MPC_PointerType.ElementType;

      while(op_type->Kind==kMPC_Typedef)
        op_type = op_type->MPC_Typedef.Type;

      if(op_type->Kind==kMPC_ArrayType) {
        NestedType_ON();
        Push_Pattern(
	  mMPC_PointerType(NoPosition, NoTree, NoTree,
                 op_type->MPC_ArrayType.Flag, 1,
		 op_type->MPC_ArrayType.Step,
		 op_type->MPC_ArrayType.ElementType
	  )
        );
        TopType()->MPC_PointerType.DynStep = op_type->MPC_ArrayType.DynStep;
        TopType()->MPC_PointerType.GeneratedFrom = op_type;
        op_type = Make_Type();
        NestedType_OFF();
      }
      >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> end of disabled action; */

      Push_Pattern(
	mMPC_VectorType(expr->MPC_Expr.Pos, NoTree, NoTree, op_type->MPC_Type.Flag,
                      size_value, /*step_value,*/ op_type->MPC_PointerType.ElementType
        )
      );
      TopType()->MPC_VectorType.VectorSize = size;
      TopType()->MPC_Type.Flag.Repl = replicated;

      /*** previous version:
      Push_Pattern(
	mMPC_ArrayType(expr->MPC_Expr.Pos, NoTree, NoTree, op_type->MPC_Type.Flag,
                      size_value, step_value, op_type **->MPC_PointerType.ElementType**
        )
      );
      TopType()->MPC_ArrayType.ArraySize = size;
      TopType()->MPC_ArrayType.DynStep = grid_step;
      TopType()->MPC_Type.Flag.Repl = replicated;
      ***/

      expr->MPC_Expr.Type = Make_Type();

      if(Is_CorrectGridOperand(operand))
        expr->MPC_Expr.Flag.Lvalue =
	      ( op_type->MPC_PointerType.ElementType->Kind==kMPC_ArrayType ? NO : YES );
      else {
        expr->MPC_Expr.Type = ErrorType;
        expr->MPC_Expr.Flag.Ignore = YES;
        Make_Message(259, xxError, SourcePosition(expr->MPC_Expr.Pos, expr), expr);
		/* "Invalid first operand of grid operator '[:]'" */
        return;
      }
      expr->MPC_Expr.Flag.Const = NO;
    }
  /******************************************/
  
  if(replicated && !expr->MPC_Expr.Type->MPC_Type.Flag.Repl) {  /* reevaluate 'Type': */
    tTree new_type;
    new_type = MakeTree(expr->MPC_Expr.Type->Kind);
    *new_type = *(expr->MPC_Expr.Type);
    new_type->MPC_Type.Flag.Repl = YES;
    Push_Pattern(new_type);
    expr->MPC_Expr.Type = Make_Type();
  }
 
}


/***************************/
int CompatibleVectorsInAssign
/***************************/
#if defined __STDC__ | defined __cplusplus
	(tTree op1, tTree op2)
#else
	(op1, op2)
	tTree op1, op2;
#endif
{
  int v2_len;
  tTree type1, type2, t1, t2;
  tTree net1, net2;
  bool type_reduced = false;

  type1 = op1->MPC_Expr.Type;
  type2 = op2->MPC_Expr.Type;
  net1  = op1->MPC_Expr.StoreNet;
  net2  = op2->MPC_Expr.StoreNet;

  start_check:
  t1 = type1;
  t2 = type2;
  while((t1->Kind==kMPC_VectorType ||
        t1->Kind==kMPC_ArrayType && op1->MPC_Expr.Flag.Lvalue) &&
	(t2->Kind==kMPC_VectorType ||
        t2->Kind==kMPC_ArrayType && op2->MPC_Expr.Flag.Lvalue)) {
    if(t2->Kind==kMPC_ArrayType)
      v2_len = t2->MPC_ArrayType.NumberOfComponents;
    else
      v2_len = t2->MPC_VectorType.NumberOfComponents;
    if(t1->Kind==kMPC_VectorType && t1->MPC_VectorType.NumberOfComponents!=v2_len ||
       t1->Kind==kMPC_ArrayType && t1->MPC_ArrayType.NumberOfComponents!=v2_len)
      goto check_distribution;
    if(t1->Kind==kMPC_ArrayType)
      t1 = t1->MPC_ArrayType.ElementType;
    else
      t1 = t1->MPC_VectorType.ElementType;
    if(t2->Kind==kMPC_ArrayType)
      t2 = t2->MPC_ArrayType.ElementType;
    else
      t2 = t2->MPC_VectorType.ElementType;
  }
  if(t1->Kind!=kMPC_VectorType && t1->Kind!=kMPC_ArrayType /* scalar Lop */ &&
     (t2->Kind==kMPC_VectorType ||
        t2->Kind==kMPC_ArrayType && op2->MPC_Expr.Flag.Lvalue) /* vector Rop */ &&
     op1->MPC_Expr.StoreNet==op2->MPC_Expr.StoreNet )
    return NO;
  else
    return YES;

  check_distribution:
  if(type_reduced)
    return NO;
  if(net1 != net2) {
    if(net1->MPC_NetOrSubnet.SingleNode &&
       !(net2->MPC_NetOrSubnet.SingleNode ||
	 net2==COMPUTING_SPACE || net2==CONST_NET)) {       /* reduce type1 'level' : */
      type1 = type1->Kind==kMPC_ArrayType ? type1->MPC_ArrayType.ElementType
					  : type1->MPC_VectorType.ElementType;
      net2 = net2->MPC_NetOrSubnet.Distribution;
      type_reduced = true;
      goto start_check;
    }
    else
    if(net2->MPC_NetOrSubnet.SingleNode &&
       !(net1->MPC_NetOrSubnet.SingleNode ||
	 net1==COMPUTING_SPACE || net1==CONST_NET)) {       /* reduce type2 'level' : */
      type2 = type2->Kind==kMPC_ArrayType ? type2->MPC_ArrayType.ElementType
					  : type2->MPC_VectorType.ElementType;
      net1 = net1->MPC_NetOrSubnet.Distribution;
      type_reduced = true;
      goto start_check;
    }
  }
  return NO;

}

/***********************/
tTree Eval_TypeConversion
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2)
#else
	(type1, type2)
	tTree type1, type2;
#endif
{
  tTree t1, t2, result_type;
  int tc1=UNDEFINED, tc2=UNDEFINED;

  t1 = type1;
  t2 = type2;

  if(type1->Kind==kMPC_VectorType || type1->Kind==kMPC_ArrayType)
    t1 = TerminalType(type1);
  if(type2->Kind==kMPC_VectorType || type2->Kind==kMPC_ArrayType)
    t2 = TerminalType(type2);
  if(!(Is_ScalarType(t1)&&Is_ScalarType(t2)))
    CompilerError("in function Eval_TypeConversion", NoPosition);
  if(Is_ArithmeticType(t1)) tc1 = t1->MPC_BasicType.TypeConstructor;
  if(Is_ArithmeticType(t2)) tc2 = t2->MPC_BasicType.TypeConstructor;

  if(t1->Kind==kMPC_PointerType)
    result_type = t1;
  else if(t2->Kind==kMPC_PointerType)
    result_type = t2;
  else if(tc1==LONG_DOUBLE || tc2==LONG_DOUBLE)
    result_type = LongDoubleType;
  else if(tc1==DOUBLE || tc2==DOUBLE)
    result_type = DoubleType;
  else if(tc1==FLOAT || tc2==FLOAT)
    result_type = FloatType;
  else if(tc1==UNSIGNED_LONG || tc2==UNSIGNED_LONG)
    result_type = UnsignedLongType;
  else if(tc1==LONG || tc2==LONG)
    result_type = LongType;
  else if(tc1==UNSIGNED || tc2==UNSIGNED)
    result_type = UnsignedType;
  else
    result_type = IntType;

  if((type1->Kind==kMPC_VectorType || type1->Kind==kMPC_ArrayType)  ||
     (type2->Kind==kMPC_VectorType || type2->Kind==kMPC_ArrayType))
    return NewVectorType(ResultVectorType(type1,type2), result_type);
  else
    return result_type;
}

/********************/
tTree ResultVectorType
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree type1, tTree type2)
#else
	(type1, type2)
	tTree type1, type2;
#endif
{
  tTree t1,t2, size1, size2;
  tTree longest_type;
  
  t1 = type1;
  t2 = type2;

  /* evaluate the 'longest' type: */
  while((t1->Kind==kMPC_VectorType || t1->Kind==kMPC_ArrayType) &&
	(t2->Kind==kMPC_VectorType || t2->Kind==kMPC_ArrayType)) {
    t1 = t1->Kind==kMPC_VectorType ? t1->MPC_VectorType.ElementType
				   : t1->MPC_ArrayType.ElementType;
    t2 = t2->Kind==kMPC_VectorType ? t2->MPC_VectorType.ElementType
				   : t2->MPC_ArrayType.ElementType;
  }
  if(t2->Kind==kMPC_ArrayType || t2->Kind==kMPC_VectorType) {
    longest_type = t2 = type2;
    t1 = type1;
  }
  else  { /* also in case of equal 'length'... */
    longest_type = t1 = type1;   /* Left operand allways has priority... */
    t2 = type2;
  }

  while((t1->Kind==kMPC_VectorType || t1->Kind==kMPC_ArrayType) &&
	(t2->Kind==kMPC_VectorType || t2->Kind==kMPC_ArrayType)) {

    size1 = t1->Kind==kMPC_VectorType ? t1->MPC_VectorType.VectorSize
				      : t1->MPC_ArrayType.ArraySize;
    size2 = t2->Kind==kMPC_VectorType ? t2->MPC_VectorType.VectorSize
				      : t2->MPC_ArrayType.ArraySize;

    /* check on dynamic array type and make type of result (if possible - STATIC array type): */
    if((t1->MPC_Type.Flag.DynArray && size1!=NoTree && size1->Kind!=kMPC_FreeNode ||
        t1->MPC_Type.Flag.DynStep)  &&
       !(t2->MPC_Type.Flag.DynArray && size2!=NoTree && size2->Kind!=kMPC_FreeNode ||
        t2->MPC_Type.Flag.DynStep))
      Push_Pattern(t2);
    else
      if(!(t1->MPC_Type.Flag.DynArray && size1!=NoTree && size1->Kind!=kMPC_FreeNode ||
           t1->MPC_Type.Flag.DynStep)  &&
	   (t2->MPC_Type.Flag.DynArray && size2!=NoTree && size2->Kind!=kMPC_FreeNode ||
            t2->MPC_Type.Flag.DynStep))
        Push_Pattern(t1);
    else
	Push_Pattern(longest_type);

    t1 = t1->Kind==kMPC_VectorType ? t1->MPC_VectorType.ElementType
				   : t1->MPC_ArrayType.ElementType;
    t2 = t2->Kind==kMPC_VectorType ? t2->MPC_VectorType.ElementType
				   : t2->MPC_ArrayType.ElementType;
    longest_type = longest_type->Kind==kMPC_VectorType ?
			     longest_type->MPC_VectorType.ElementType :
			     longest_type->MPC_ArrayType.ElementType;

  }

  /** add tail of longest type to TypeStack: **/
  Push_Pattern(longest_type);
  return Make_Type();
/*** TMP, ADD CHECKS AND ARRAY-TO-VECTOR CONVERSION (IF NECESSARY) ***/
}

/********************/
int Check_ArgumentType
/********************/
#if defined __STDC__ | defined __cplusplus
	(int context, tTree par, tTree arg)
#else
	(context, par, arg)
	tTree par, arg;
#endif
{
  /* This function checks args and network args of function and arguments of
     net type specifier on compatibility with prototype and has 2 diag modes */

  tTree partype, argtype=arg->MPC_Expr.Type, arg_elem_type;
  bool bad_type=false;
  tPosition par_pos;

  /* global static tmpexpr is used for correct work of CompatibleVectorsInAssign(); */

  /* check on errors detected before Check_ArgumentType() */
  /* (the following checks may cause fatal errors).       */
  if(par->Kind==kMPC_VarDecl && par->MPC_VarDecl.Flag.Ignore ||
     par->Kind==kMPC_Var && par->MPC_Var.Flag.Ignore)
    return true;

  if(arg->MPC_Expr.Flag.Ignore) {
    arg->MPC_Expr.Type = ErrorType;
    return true;
  }

  if(par->Kind==kMPC_VarDecl) {
    partype = par->MPC_VarDecl.DeclSpecifier;
    par_pos = RealPosition(par->MPC_VarDecl.Pos);
  }
  else {
    partype = par->MPC_Var.Type;
    par_pos = RealPosition(par->MPC_Var.Pos);
  }

  Disable_SUE_Typedef();
  Push_PurePattern(partype); partype = Make_Type();
  Push_PurePattern(argtype); argtype = arg_elem_type = Make_Type();
  Enable_SUE_Typedef();

  tmpexpr->MPC_Expr.Type = partype;

  if(partype->Kind==kMPC_VectorType ||
     partype->Kind==kMPC_ArrayType && partype->MPC_Type.Flag.ExplStep) /* => vector param */
    partype = TerminalType(partype);

  if(argtype->Kind==kMPC_VectorType ||
     argtype->Kind==kMPC_ArrayType && arg->MPC_Expr.Flag.Lvalue) /* => vector arg */
    argtype = arg_elem_type = TerminalType(argtype);

  if(partype->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, partype->MPC_Type.Flag, 1,
		partype->MPC_ArrayType.Step, partype->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = partype->MPC_ArrayType.DynStep;
    partype = Make_Type();
  }
  if(argtype->Kind==kMPC_ArrayType) {  /* convert array to pointer */
    Push_Pattern(
	mMPC_PointerType(NoPosition, NoTree, NoTree, argtype->MPC_Type.Flag, 1,
		argtype->MPC_ArrayType.Step, arg_elem_type=argtype->MPC_ArrayType.ElementType
	)
    );
    TopType()->MPC_PointerType.DynStep = argtype->MPC_ArrayType.DynStep;
    argtype = Make_Type();
  }

    if( !(Is_ArithmeticType(partype) && Is_ArithmeticType(argtype)  ||
	  partype==argtype && partype->Kind!=kMPC_FunctionType  ||
	  partype->Kind==kMPC_PointerType && argtype->Kind==kMPC_PointerType &&
	  Is_EqualType(partype->MPC_PointerType.ElementType,
		       argtype->MPC_PointerType.ElementType, false/*strict*/)  ||
	  partype->Kind==kMPC_PointerType && Is_IntegralType(argtype) &&
	  (arg->Kind==kMPC_IntConst && arg->MPC_IntConst.Value==NULL_POINTER ||
	   arg->Kind==kMPC_UIntConst && arg->MPC_UIntConst.Value==NULL_POINTER)  ||
	  partype->Kind==kMPC_PointerType &&
	  argtype->Kind==kMPC_PointerType &&
	  (Is_VoidType(partype->MPC_PointerType.ElementType) ||
	   Is_VoidType(argtype->MPC_PointerType.ElementType)) ||
	  partype->Kind==kMPC_PointerType &&
	  argtype->Kind==kMPC_ArrayType && !(arg->MPC_Expr.Flag.Lvalue)  ||
	  Is_Same_PointerToFunction(partype, argtype)
	 ) ||
	!CompatibleVectorsInAssign(tmpexpr, arg) )
      bad_type = true; /* for all values of context; */

  arg_elem_type = TerminalType(arg_elem_type);
  while(arg_elem_type!=NoTree && arg_elem_type->Kind==kMPC_PointerType) {
    arg_elem_type = TerminalType(arg_elem_type->MPC_PointerType.ElementType);
    /* for context == NET_ or NETWORK_ARG_LIST: */
  } 

  if((context==NET_ARG_LIST || context==NETWORK_ARG_LIST) &&
     !Is_IntegralType(arg_elem_type) &&
     !(Is_ArithmeticType(arg_elem_type) && arg_elem_type->MPC_BasicType.TypeConstructor==DOUBLE))
    bad_type = true;

  if(bad_type) {
    tPosition par_pos;
    par_pos = RealPosition(par->MPC_Var.Pos);
    arg->MPC_Expr.Flag.Ignore = YES;
    if(context==ARG_LIST || context==NETWORK_ARG_LIST) {
      Make_Message(260, xxError, SourcePosition(arg->MPC_Expr.Pos,arg), arg);
		/* "Type of argument in function call is wrong or incompatible with prototype" */
      Make_MessageI(15, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		    xxString, SourceFile(par->MPC_Var.Pos), par);
		/* "   This function or its prototype is declared in file" */
      Make_MessageI(16, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		    xxShort, (char *)&(par_pos.Line), par);
		/* "   and parameter declaration starts in line" */
    }
    else if(context==NET_ARG_LIST) {
      Make_Message(261, xxError, SourcePosition(arg->MPC_Expr.Pos,arg), arg);
		/* "Type of argument is wrong or incompatible with topology declaration" */
      Make_MessageI(17, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		    xxString, SourceFile(par->MPC_Var.Pos), par);
		/* "   This topology declaration is located in file" */
      Make_MessageI(16, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		    xxShort, (char *)&(par_pos.Line), par);
		/* "   and parameter declaration starts in line" */
    }
    else
      CompilerError("Invalid value of 'context' in check of arg type. "
		    "Can't generate the corresponding error message",
                    SourcePosition(arg->MPC_Expr.Pos,arg));
  }

  if(partype->MPC_Type.Flag.Repl && !arg->MPC_Expr.Repl &&
     !arg->MPC_Expr.StoreNet->MPC_NetOrSubnet.SingleNode) {
    bad_type = true;
    Make_Message(262, xxError, SourcePosition(arg->MPC_Expr.Pos,arg), arg);
		/* "Parameter is declared 'repl' and argument is not 'repl'" */
    Make_MessageI(18, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		  xxString, SourceFile(par->MPC_Var.Pos), par);
		/* "   This parameter declaration is located in file" */
    Make_MessageI(3, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		 xxShort, (char *)&(par_pos.Line), par);
		/* "   and starts in line" */
  }
  if(argtype->Kind==kMPC_PointerType &&
     argtype->MPC_PointerType.ElementType->MPC_Type.Flag.Repl &&
     partype->Kind==kMPC_PointerType &&
     !partype->MPC_PointerType.ElementType->MPC_Type.Flag.Repl &&
     !partype->MPC_PointerType.ElementType->MPC_Type.Flag.Const ) {
    ARGS_Warning((314, xxWarning, arg->MPC_Expr.Pos, arg));
		/* "Passing the argument discards 'repl' from pointer target type" */
    ARGS_WarningI((35, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg), xxString,
		   SourceFile(par->MPC_Var.Pos), par));
		/* "   The corresponding non-repl parameter declaration is located in file" */
    ARGS_WarningI((3, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		   xxShort, (char *)&(par_pos.Line), par));
		/* "   and starts in line" */
  }

  if( arg->MPC_Expr.Flag.Const &&
     (arg->MPC_Expr.Flag.Lvalue || arg->Kind==kMPC_Ident) &&
     partype->Kind==kMPC_PointerType &&
     !partype->MPC_PointerType.ElementType->MPC_Type.Flag.Const) {
    ARGS_Warning((315, xxWarning, arg->MPC_Expr.Pos, arg));
		/* "Passing the argument discards 'const' from pointer target type" */
    ARGS_WarningI((36, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg), xxString,
		   SourceFile(par->MPC_Var.Pos), par));
		/* "   The corresponding non-const parameter declaration is located in file" */
    ARGS_WarningI((3, xxInformation, SourcePosition(arg->MPC_Expr.Pos,arg),
		   xxShort, (char *)&(par_pos.Line), par));
		/* "   and starts in line" */
  }

  return bad_type;
}

/******************/
int Check_Expression
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;	/* pointer to root of checked expression; */
#endif
{
  return 0; /* tmp - no checks, treat the tree as right expression; */
}

/********************/
void Eval_Distribution
/********************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;	/* pointer to root of distributed expression; */
#endif
{
  if(expr->MPC_Expr.Flag.Ignore) {
    expr->MPC_Expr.StoreNet = ErrorNet;
    expr->MPC_Expr.EvalNet = ErrorNetList;
    return;
  }

  if(expr->Kind==kMPC_BinaryExpr) {

    tTree lop, rop;
    lop = expr->MPC_BinaryExpr.Loperand;
    rop = expr->MPC_BinaryExpr.Roperand;

    /*** Check on replicated assignment (only on the same net): ***/
    if(expr->MPC_BinaryExpr.OpCode>=ASSIGN &&
       expr->MPC_BinaryExpr.OpCode<=INCL_OR_ASSIGN &&
       lop->MPC_Expr.StoreNet==rop->MPC_Expr.StoreNet &&
       !lop->MPC_Expr.StoreNet->MPC_NetOrSubnet.SingleNode &&
       lop->MPC_Expr.Repl && !rop->MPC_Expr.Repl &&
       lop->MPC_Expr.Type->MPC_Type.Flag.Repl /*if not, lop may be pointer to repl ...*/ ) {
      Make_Message(263, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Left operand of assignment is repl and right operand isn't" */
      expr->MPC_Expr.Flag.Ignore = YES;
    }

    if(expr->MPC_Expr.Flag.Ignore ||
       lop->MPC_Expr.Flag.Ignore || rop->MPC_Expr.Flag.Ignore) {
      expr->MPC_Expr.StoreNet = ErrorNet;
      expr->MPC_Expr.EvalNet = ErrorNetList;
    }


    /* Check on special case ( '.' or '->'): */
    if(expr->MPC_BinaryExpr.OpCode==DOT || expr->MPC_BinaryExpr.OpCode==ARROW) {
      expr->MPC_BinaryExpr.Roperand->MPC_Expr.EvalNet =
	expr->MPC_Expr.EvalNet = expr->MPC_BinaryExpr.Loperand->MPC_Expr.EvalNet;
      expr->MPC_BinaryExpr.Roperand->MPC_Expr.StoreNet =
	expr->MPC_Expr.StoreNet = expr->MPC_BinaryExpr.Loperand->MPC_Expr.StoreNet;
      expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Distributed =
				expr->MPC_Expr.Flag.Distributed =
				expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Distributed;
      expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Asynchr =
	expr->MPC_Expr.Flag.Asynchr = expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Asynchr;
      return;
    }
    if(expr->MPC_BinaryExpr.OpCode==COMMA) {
      expr->MPC_Expr.StoreNet = expr->MPC_BinaryExpr.Roperand->MPC_Expr.StoreNet;
      expr->MPC_Expr.EvalNet  = Join_NetList(
					expr->MPC_BinaryExpr.Loperand->MPC_Expr.EvalNet,
					expr->MPC_BinaryExpr.Roperand->MPC_Expr.EvalNet
				);
      expr->MPC_Expr.Flag.Distributed =
			  expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Distributed ||
			  expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Distributed;
      expr->MPC_Expr.Flag.Asynchr =
			  expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Asynchr &&
			  expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Asynchr;
      return;
    }

    expr->MPC_Expr.Flag.Asynchr =
			lop->MPC_Expr.Flag.Asynchr && rop->MPC_Expr.Flag.Asynchr;
    if(expr->MPC_BinaryExpr.OpCode==ASSIGN &&
       lop->MPC_Expr.StoreNet!=rop->MPC_Expr.StoreNet)
      expr->MPC_Expr.Flag.Asynchr = NO;
    expr->MPC_Expr.Flag.PartAsynchr =
			lop->MPC_Expr.Flag.PartAsynchr && rop->MPC_Expr.Flag.PartAsynchr;

    if(expr->MPC_BinaryExpr.OpCode!=ASSIGN  ||
       expr->MPC_BinaryExpr.OpCode==ASSIGN &&
	(lop->MPC_Expr.StoreNet==rop->MPC_Expr.StoreNet ||
	 Is_Equal_Net(lop->MPC_Expr.StoreNet,rop->MPC_Expr.StoreNet))) {
      if(expr->MPC_BinaryExpr.OpCode==ASSIGN &&
	 lop->MPC_Expr.StoreNet!=rop->MPC_Expr.StoreNet)
	Eval_AssignDistribution(expr);
      else if(expr->MPC_Expr.Flag.Asynchr) {
        if(Is_Subnet(lop->MPC_Expr.StoreNet,rop->MPC_Expr.StoreNet) &&
	   !rop->MPC_Expr.Flag.SideEffects && !rop->MPC_Expr.Flag.Peculiarity) {
	  expr->MPC_Expr.EvalNet = lop->MPC_Expr.EvalNet;
	  expr->MPC_Expr.StoreNet = lop->MPC_Expr.StoreNet;
	  return;  /* DONE for expr without 'SideEffects' */
        }
        else if(Is_Subnet(rop->MPC_Expr.StoreNet,lop->MPC_Expr.StoreNet) &&
	        !lop->MPC_Expr.Flag.SideEffects && !lop->MPC_Expr.Flag.Peculiarity) {
	  expr->MPC_Expr.EvalNet = rop->MPC_Expr.EvalNet;
	  expr->MPC_Expr.StoreNet = rop->MPC_Expr.StoreNet;
	  return;  /* DONE for expr without 'SideEffects' */
        }
        else  /* Side effects in operands, => */
          expr->MPC_Expr.EvalNet = Join_NetList(lop->MPC_Expr.EvalNet,rop->MPC_Expr.EvalNet);
      }
      else  /* not Asynchr: */
        expr->MPC_Expr.EvalNet = Join_NetList(lop->MPC_Expr.EvalNet,rop->MPC_Expr.EvalNet);
    }

    if(lop->MPC_Expr.StoreNet==rop->MPC_Expr.StoreNet ||
       Is_Equal_Net(lop->MPC_Expr.StoreNet,rop->MPC_Expr.StoreNet)) {
      expr->MPC_Expr.StoreNet = lop->MPC_Expr.StoreNet;
    }
    else if(expr->MPC_BinaryExpr.OpCode!=ASSIGN &&
	    Is_Subnet(lop->MPC_Expr.StoreNet, rop->MPC_Expr.StoreNet))
      expr->MPC_Expr.StoreNet = lop->MPC_Expr.StoreNet;
    else if(expr->MPC_BinaryExpr.OpCode!=ASSIGN &&
	    Is_Subnet(rop->MPC_Expr.StoreNet, lop->MPC_Expr.StoreNet))
      expr->MPC_Expr.StoreNet = rop->MPC_Expr.StoreNet;
    else if(expr->MPC_BinaryExpr.OpCode==ASSIGN) /* special case of '=' */
      Eval_AssignDistribution(expr);
    else {  /* invalid distribution of lop and rop: */
      expr->MPC_Expr.Flag.Ignore = YES;
      expr->MPC_Expr.StoreNet = ErrorNet;
      expr->MPC_Expr.EvalNet = ErrorNetList;
      Make_Message(264, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Invalid distribution of operands of binary operator" */
      return;
    }

    /*** one of operands may have other EvalNet (not subnet of expr->MPC_Expr.EvalNet): ***/

    expr->MPC_Expr.EvalNet =
	  Join_NetList(
		Join_NetList(
			expr->MPC_Expr.EvalNet,
			expr->MPC_BinaryExpr.Roperand->MPC_Expr.EvalNet
		),
		expr->MPC_BinaryExpr.Loperand->MPC_Expr.EvalNet
	  );

    /***************************************************************************************/

  }  /* end MPC_BinaryExpr */

  if(expr->MPC_Expr.StoreNet!=HOST && expr->MPC_Expr.StoreNet!=SINGLE_NODE)
    expr->MPC_Expr.Flag.Distributed = YES;

}

/**************************/
void Eval_AssignDistribution
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr)
#else
	(expr)
	tTree expr;	/* pointer to root of '=' expression; */
#endif
{
  tTree lnet=NoTree, rnet=NoTree, supernet=NoTree, ltype=NoTree, rtype=NoTree;
  bool OK=false;

  expr->MPC_Expr.Flag.Distributed =
		 expr->MPC_BinaryExpr.Loperand->MPC_Expr.Flag.Distributed ||
		 expr->MPC_BinaryExpr.Roperand->MPC_Expr.Flag.Distributed;
  expr->MPC_Expr.StoreNet = lnet = expr->MPC_BinaryExpr.Loperand->MPC_Expr.StoreNet;
  rnet = expr->MPC_BinaryExpr.Roperand->MPC_Expr.StoreNet;

  /* Check special cases of simple assignment: */

  /* 1. Lop on R , Rop on node of supernet(R) ?  -- Or   *
   *    Rop on R (distr. net), Lop on parent net of R ?  */
  if(lnet!=HOST && lnet!=SINGLE_NODE &&
     (rnet->Kind==kMPC_Subnet && rnet->MPC_Subnet.SingleNode || rnet==HOST) ||
     lnet->Kind==kMPC_Net && lnet->MPC_Net.Distribution==rnet) {
    /* check subnet/supernet relations: */
    supernet = lnet;
    if(Is_Subnet(rnet, supernet)) OK = true;
    while(!OK && supernet->Kind==kMPC_Subnet) {
      supernet = supernet->MPC_Subnet.Distribution;
      if(Is_Subnet(rnet, supernet)) OK = true;
    }
    Push_PurePattern(expr->MPC_BinaryExpr.Roperand->MPC_Expr.Type);
    rtype = Make_Type();
    if((rtype->Kind==kMPC_ArrayType || rtype->Kind==kMPC_VectorType) &&  /* ltype - lvector? */
	    !CompatibleVectorsInAssign(expr->MPC_BinaryExpr.Loperand,
				       expr->MPC_BinaryExpr.Roperand) &&
	    !lnet->MPC_NetOrSubnet.SingleNode) {
     /* right operand is blocked array or lvector and left - scalar, check size: */
      int arr_size;
      arr_size = rtype->MPC_ArrayType.NumberOfComponents;
      if(arr_size != NetSize(lnet) && arr_size!=UNDEFINED && NetSize(lnet)!=UNDEFINED) {
        Make_Message(265, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Incompatible size of left (sub)net and right undistributed vector" */
	expr->MPC_Expr.Flag.Ignore = YES;
	expr->MPC_Expr.StoreNet = ErrorNet;
	expr->MPC_Expr.EvalNet = ErrorNetList;
        return;
      }
      else if(arr_size != NetSize(lnet) && NetSize(lnet)==UNDEFINED && lnet!=COMPUTING_SPACE)
	SIZE_Warning((37, xxWarning, SourcePosition(expr->MPC_Expr.Pos,expr), expr));
		/* "Invalid size of right undistributed operand of '=' possible (cannot check size of left (sub)net)" */
    }
  }

  /* 2. Lop on S1, Rop on S2 : S1=subnet(R), S2=subnet(R) ? */
  else if(lnet->Kind==kMPC_Subnet && !lnet->MPC_Subnet.SingleNode &&
            rnet->Kind==kMPC_Subnet && !rnet->MPC_Subnet.SingleNode  /***||
	  lnet->Kind==kMPC_Subnet && !lnet->MPC_Subnet.SingleNode &&
            rnet->Kind==kMPC_Net && !rnet->MPC_Net.SingleNode  ||
	  lnet->Kind==kMPC_Net && !lnet->MPC_Net.SingleNode &&
            rnet->Kind==kMPC_Subnet && !rnet->MPC_Subnet.SingleNode ***/) {
    /* check on common supernet: */
    tTree l, r;
    l = lnet;
    while(!OK && l->Kind==kMPC_Subnet) {
      l = l->MPC_Subnet.Distribution;
      r = rnet;
      while(!OK && r->Kind==kMPC_Subnet) {
	r = r->MPC_Subnet.Distribution;
	if(l==r || Is_Compatible_Net(l,r)) { OK = true; supernet = l; }
      }
    }
    /* Compare size of lnet to size of rnet: */
    if(NetSize(lnet) != NetSize(rnet)) {
      if(NetSize(lnet)==UNDEFINED)
        DISTR_Warning((38, xxWarning, expr->MPC_Expr.Pos, expr))
		/* "Incorrect distribution of operands of '=' possible (cannot check size of left net or subnet)" */
      else if(NetSize(rnet)==UNDEFINED)
        DISTR_Warning((39, xxWarning, expr->MPC_Expr.Pos, expr))
		/* "Incorrect distribution of operands of '=' possible (cannot check size of right net or subnet)" */
      else {
	expr->MPC_Expr.Flag.Ignore = YES;
        expr->MPC_Expr.StoreNet = ErrorNet;
        expr->MPC_Expr.EvalNet = ErrorNetList;
	Make_Message(266, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Invalid distribution of operands of '=' (different size of left and right (sub)nets)" */
        return;
      }
    }
  }

  /* ??????????????????????????????????????????????????????? */
  /* 2a. Lop on N1, Rop on N2 : N1=subnet(R), N2=subnet(R) ? */
  /* ????????????? only for network functions ?????????????? */
  else if(lnet->MPC_NetOrSubnet.SingleNode && rnet->MPC_NetOrSubnet.SingleNode &&
	  lnet!=HOST && rnet!=HOST) {
    if(lnet==SINGLE_NODE) {
      supernet = rnet;
      while(supernet->Kind==kMPC_Subnet) supernet = supernet->MPC_Subnet.Distribution;
      OK = true;
    }
    else if(rnet==SINGLE_NODE) {
      supernet = lnet;
      while(supernet->Kind==kMPC_Subnet) supernet = supernet->MPC_Subnet.Distribution;
      OK = true;
    }
    else {
      /* check on common supernet: */
      tTree l, r;
      l = lnet;
      while(!OK && l->Kind==kMPC_Subnet) {
        l = l->MPC_Subnet.Distribution;
        r = rnet;
        while(!OK && r->Kind==kMPC_Subnet) {
	  r = r->MPC_Subnet.Distribution;
	  if(l==r || Is_Compatible_Net(l,r)) { OK = true; supernet = l; }
        }
      }
    }
  }

  /* 3. Rop on R , Lop on node of supernet(R) ?  -- Or   *
   *    Rop on R (distr. net), Lop on parent net of R ?  */
  else if((lnet->Kind==kMPC_Subnet && lnet->MPC_Subnet.SingleNode || lnet==HOST) &&
	  rnet!=HOST && rnet!=SINGLE_NODE  ||
	  rnet->Kind==kMPC_Net && rnet->MPC_Net.Distribution==lnet) {
    /* check subnet/supernet relations: */
    supernet = rnet;
    if(Is_Subnet(lnet, supernet)) OK = true;
    while(!OK && supernet->Kind==kMPC_Subnet) {
      supernet = supernet->MPC_Subnet.Distribution;
      if(Is_Subnet(lnet, supernet)) OK = true;
    }
    Push_PurePattern(expr->MPC_BinaryExpr.Loperand->MPC_Expr.Type);
    ltype = Make_Type();
    if(!(ltype->Kind==kMPC_ArrayType || ltype->Kind==kMPC_VectorType) &&
       !rnet->MPC_NetOrSubnet.SingleNode) {
      Make_Message(267, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Left undistributed operand of distributed assignment is not lvector" */
      expr->MPC_Expr.Flag.Ignore = YES;
      expr->MPC_Expr.StoreNet = ErrorNet;
      expr->MPC_Expr.EvalNet = ErrorNetList;
      return;
    }
    else if((ltype->Kind==kMPC_ArrayType || ltype->Kind==kMPC_VectorType) &&
	    !rnet->MPC_NetOrSubnet.SingleNode) {
     /* left operand is blocked array or lvector, check size: */
      int arr_size;
      arr_size = ltype->MPC_ArrayType.NumberOfComponents;
      if(arr_size != NetSize(rnet) && arr_size!=UNDEFINED && NetSize(rnet)!=UNDEFINED) {
        Make_Message(268, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Incompatible size of left undistributed lvector and right (sub)net" */
	expr->MPC_Expr.Flag.Ignore = YES;
	expr->MPC_Expr.StoreNet = ErrorNet;
	expr->MPC_Expr.EvalNet = ErrorNetList;
        return;
      }
      else if(arr_size != NetSize(rnet) && NetSize(rnet)==UNDEFINED)
	SIZE_Warning((40, xxWarning, SourcePosition(expr->MPC_Expr.Pos,expr), expr))
		/* "Invalid size of left undistributed operand of '=' possible (cannot check size of right (sub)net)" */
    }
  }

  
  if(OK) {
    tTree tmp;
    /********************************/
    if(expr->MPC_Expr.EvalNet) return;  /* -- EvalNet ready;*/
    /********************************/
    if(supernet) {
      tmp = mMPC_FreeNode(expr);
      expr->MPC_Expr.EvalNet = Clean_OutAttributes( mMPC_NetList(tmp, tmp, supernet) );
    }
  }
  else {
    expr->MPC_Expr.Flag.Ignore = YES;
    expr->MPC_Expr.StoreNet = ErrorNet;
    expr->MPC_Expr.EvalNet = ErrorNetList;
    Make_Message(269, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Invalid or incompatible distribution of operands of '='" */
  }

  /* Check the correctness of right type (must be without any pointers): */
  if(Pointer_Dependent(expr->MPC_BinaryExpr.Roperand->MPC_Expr.Type)) {
    expr->MPC_Expr.Flag.Ignore = YES;
    expr->MPC_Expr.Type = ErrorType;
    expr->MPC_Expr.StoreNet = ErrorNet;
    expr->MPC_Expr.EvalNet = ErrorNetList;
    Make_Message(270, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), expr);
		/* "Invalid type in synchronous assignment (right operand is pointer-dependent and can't be transmitted)" */
  }

}

/******************/
int Eval_CoordNumber
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree expr, short *num)
#else
	(expr, num)
	tTree expr;
	short *num;
#endif
{
  tTree coord, net;

  net = expr->MPC_CoordExpr.Operand->MPC_Expr.StoreNet;
  while(net->Kind==kMPC_Subnet)
    net = net->MPC_Subnet.Distribution;
  if(net->Kind!=kMPC_Net)
    CompilerError("Eval_CoordNumber(): Bad tree structure in StoreNet", expr->MPC_Expr.Pos);
  if(!net->MPC_Net.NetType || !net->MPC_Net.NetType->MPC_NetTypeSpecifier.NetType)
    return 1;  /* Errors detected on pass1; */
  coord = net->MPC_Net.NetType->MPC_NetTypeSpecifier.NetType->MPC_NetType.CoordDecl;
  while(!(coord->Kind==kMPC_FreeNode ||
	  coord->MPC_CoordDecl.Ident==expr->MPC_CoordExpr.CoordName))
    coord = coord->MPC_CoordDecl.Next;
  if(coord->Kind==kMPC_CoordDecl) {
    *num = coord->MPC_CoordDecl.CoordNumber;
    return 0;  /* normal exit; */
  }
  else {  /* error: */
    Make_MessageI(271, xxError, SourcePosition(expr->MPC_Expr.Pos,expr), xxIdent,
		  (char *)&expr->MPC_CoordExpr.CoordName, expr);
		/* "No such coordinate in this topology" */
    return 1;  /* error flag; */
  }
}

/*******************/
bool Is_Equal_NetList
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree list1, tTree list2)
#else
	(list1, list2)
	tTree list1, list2;
#endif
{
  if(list1==NoTree || list2==NoTree) {
    /******/
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
    if(DEBUG)
		CompilerError("Empty NetList in call to Is_Equal_NetList()",NoPosition);
    exit(1);
    /******/
  }

  if(list1==ErrorNetList || list2==ErrorNetList)
    return true;  /* No diagnostic for this case (all necess. mess. are already printed); */
  
  if(list1==list2) return true;
  while(list1->Kind==kMPC_NetList && list2->Kind==kMPC_NetList) {
    if(list1->MPC_NetList.Net != list2->MPC_NetList.Net &&
       !Is_Equal_Net(list1->MPC_NetList.Net, list2->MPC_NetList.Net)) return false;
    list1 = list1->MPC_NetList.Next;
    list2 = list2->MPC_NetList.Next;
  }
  if(list1->Kind != list2->Kind) return false; /* not end of one list; */
  return true;
}

/****************/
tTree Join_NetList
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree list1, tTree list2)
#else
	(list1, list2)
	tTree list1, list2;
#endif
{
  tTree result, tmp,   DL1, DL2;

  DL1=list1;
  DL2=list2;

  if(list1==NoTree || list2==NoTree) {
    /******/
    if(STORE_MESSAGES) Print_Messages();
    Message("Too bad errors, compilation terminated", xxInformation, NoPosition);
    if(DEBUG)
      CompilerError("Empty NetList in call to Join_NetList()",NoPosition);
    exit(1);
    /******/
  }

  if(list1==list2) return list1;
  if(list1==ErrorNetList) return list2;
  if(list2==ErrorNetList) return list1;
  if(list1==COMPUTING_SPACE_LIST || list2==COMPUTING_SPACE_LIST)
    return COMPUTING_SPACE_LIST;
  if(list1==CONST_NET_LIST) return list2;
  if(list2==CONST_NET_LIST) return list1;
  if(list1==HOST_LIST && list2==HOST_LIST) return HOST_LIST;

  /* copy list1 to resulting list: */

  result = nMPC_FreeNode();
  while(list1->Kind==kMPC_NetList) {
    result = mMPC_NetList(result, result, list1->MPC_NetList.Net);  /* not Make_NetList() !!! */
    result->MPC_NetList.UnReduceable = list1->MPC_NetList.UnReduceable;
    list1 = list1->MPC_NetList.Next;
  }

  /* add some nodes from list2 to resulting list: */

  while(list2->Kind==kMPC_NetList) {

    tmp = result;
    while(tmp->Kind==kMPC_NetList) {

      if(list2->MPC_NetList.Net == tmp->MPC_NetList.Net ||
	 Is_Equal_Net(list2->MPC_NetList.Net, tmp->MPC_NetList.Net) ||
	 Is_Subnet(list2->MPC_NetList.Net, tmp->MPC_NetList.Net) &&
	   !(list2->MPC_NetList.UnReduceable) || /*parent net:*/
	 tmp->MPC_NetList.Net->Kind==kMPC_Net &&
	 tmp->MPC_NetList.Net->MPC_Net.Distribution==list2->MPC_NetList.Net &&
	 Reduce_NetList && !(list2->MPC_NetList.UnReduceable))

	break; /* the resulting list contains this node; */

      if(Is_Subnet(tmp->MPC_NetList.Net, list2->MPC_NetList.Net) &&
	   !(tmp->MPC_NetList.UnReduceable) || /*parent net:*/
	 list2->MPC_NetList.Net->Kind==kMPC_Net &&
	 list2->MPC_NetList.Net->MPC_Net.Distribution==tmp->MPC_NetList.Net &&
	 Reduce_NetList && !(tmp->MPC_NetList.UnReduceable)) {

	/* check rest of list 'tmp' on list2->MPC_NetList.Net or its supernet: */

	tTree prev, rest=tmp->MPC_NetList.Next;
	while(rest->Kind!=kMPC_FreeNode) {
	  if(list2->MPC_NetList.Net == rest->MPC_NetList.Net ||
	     Is_Equal_Net(list2->MPC_NetList.Net, rest->MPC_NetList.Net) ||
	     Is_Subnet(list2->MPC_NetList.Net, rest->MPC_NetList.Net) &&
		!(list2->MPC_NetList.UnReduceable) || /*parent net:*/
	     rest->MPC_NetList.Net->Kind==kMPC_Net &&
	     rest->MPC_NetList.Net->MPC_Net.Distribution==list2->MPC_NetList.Net &&
	     Reduce_NetList && !(list2->MPC_NetList.UnReduceable))
	    goto CONTINUE; /* the resulting list contains this node; */
	  rest = rest->MPC_NetList.Next;
	} /* end while */

	/* list2->MPC_NetList.Net is not found in rest of 'tmp': */
	tmp->MPC_NetList.Net = list2->MPC_NetList.Net;   /* overwrite subnet to supernet; */
	tmp->MPC_NetList.UnReduceable = list2->MPC_NetList.UnReduceable;

	/* check rest of list 'tmp' on tmp->MPC_NetList.Net or its subnet: */

	prev = tmp;
	rest = tmp->MPC_NetList.Next;
	while(rest->Kind!=kMPC_FreeNode) {
	  if(!(rest->MPC_NetList.UnReduceable) &&
	     (rest->MPC_NetList.Net==tmp->MPC_NetList.Net ||
	      Is_Equal_Net(rest->MPC_NetList.Net, tmp->MPC_NetList.Net) ||
	      Is_Subnet(rest->MPC_NetList.Net, tmp->MPC_NetList.Net) )) { /* remove 'rest': */
	    prev->MPC_NetList.Next = prev->MPC_NetList.Prev = rest->MPC_NetList.Next;
	  }
	  prev = rest;
	  rest = rest->MPC_NetList.Next;
	}

	break;

      } /* end if */
      tmp = tmp->MPC_NetList.Next;

    } /* end while */

    CONTINUE:
    if(tmp->Kind==kMPC_FreeNode) { /* add net to resulting list: */
      result = mMPC_NetList(result, result, list2->MPC_NetList.Net);
      result->MPC_NetList.UnReduceable = list2->MPC_NetList.UnReduceable;
    }
    list2 = list2->MPC_NetList.Next;

  } /* end while */

  return ReverseTree(result);
}

/******************/
void Release_NetList
/******************/
#if defined __STDC__ | defined __cplusplus
	(tTree list)
#else
	(list)
	tTree list;
#endif
{
  tTree node = list;
  if(!list || list==HOST_LIST || list==SINGLE_NODE_LIST ||
     list==CONST_NET_LIST || list==COMPUTING_SPACE_LIST) return;  /* predefined NetList!!! */
  if(node->MPC_NetList.Prev!=NoTree &&
     node->MPC_NetList.Prev->Kind==kMPC_FreeNode &&
     node->MPC_NetList.Prev->MPC_FreeNode.Parent!=NoTree)   return;  /* Not own NetList!!! */
  while(node->Kind==kMPC_NetList) {
    node->MPC_NetList.Net = NoTree;
    node = node->MPC_NetList.Next;
  }
  return;
}

/****************/
bool Is_SubnetList
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree subnetlist, tTree supernetlist)
#else
	(subnetlist, supernetlist)
	tTree subnetlist, supernetlist;
#endif
{  /*** ATTENTION : 'supernetlist' contains only one MPC_NetList node !!! ***/
   /*** (this function is used by check of condition/iteration statement) ***/
  while(subnetlist->Kind==kMPC_NetList){
    if(!Is_Subnet(subnetlist->MPC_NetList.Net, supernetlist->MPC_NetList.Net)) return false;
    subnetlist = subnetlist->MPC_NetList.Next;
  }
  return true;
}

/************************/
void Eval_StatDistribution
/************************/
#if defined __STDC__ | defined __cplusplus
	(tTree stat, bool repl/*expr!*/, tTree expr_net/*list~StoreNet*/,
	 tTree expr_evalnet/*EvalNet of control expr*/, tExprFlags *expr_flag,
	 tTree body_net/*summary NetList!*/, tStatFlags *body_flag)
#else
	(stat, repl, expr_net, expr_evalnet, expr_flag, body_net, body_flag)
	tTree stat, expr_net, expr_evalnet, body_net;
	bool repl;
	tExprFlags *expr_flag;
	tStatFlags *body_flag;
#endif
{
  if(expr_flag->Distributed && expr_net!=HOST_LIST) { /* check Stats on asynchronism: */
    if(body_net==CONST_NET_LIST || Is_Equal_NetList(expr_net, body_net) ||
       Is_SubnetList(body_net, expr_net) || PartAsynchr_Possible(expr_net, body_net)) {
      if(body_flag->Asynchr && expr_flag->Asynchr)
	stat->MPC_Stat.Flag.Asynchr = YES;
      else if(body_flag->PartAsynchr && expr_flag->Asynchr)
	stat->MPC_Stat.Flag.PartAsynchr = YES;
      else if(!expr_flag->Asynchr && (body_flag->Asynchr || body_flag->PartAsynchr))
	stat->MPC_Stat.Flag.Asynchr = NO;
      else if(!(repl || body_net==CONST_NET_LIST)) {
	stat->MPC_Stat.Flag.Ignore = YES;
	stat->MPC_Stat.ExecNet = ErrorNetList;
	Make_Message(272, xxError, stat->MPC_Stat.Pos, stat);
		/* "Statement with unreplicated distributed control expression should be acynchronous" */
      }
    }
    else {
      stat->MPC_Stat.Flag.Ignore = YES;
      stat->MPC_Stat.ExecNet = ErrorNetList;
      Make_Message(273, xxError, stat->MPC_Stat.Pos, stat);
		/* "Control expression(s) and statement(s) in selection or iteration statement are of different distribution" */
      return;
    }
  }
  else if((!expr_flag->Distributed || expr_net==HOST_LIST) &&
	  Is_Equal_NetList(expr_net, body_net))
    stat->MPC_Stat.Flag.Asynchr = body_flag->Asynchr && expr_flag->Asynchr;

  stat->MPC_Stat.Flag.CreateAutoNet = body_flag->CreateAutoNet;
  stat->MPC_Stat.Flag.CreateStaticNet = body_flag->CreateStaticNet;

  if((stat->MPC_Stat.Flag.CreateAutoNet || stat->MPC_Stat.Flag.CreateStaticNet) &&
     stat->MPC_Stat.Prev->Kind!=kMPC_FreeNode &&
     stat->MPC_Stat.Prev->MPC_Stat.ExecNet==COMPUTING_SPACE_LIST)
    stat->MPC_Stat.ExecNet = COMPUTING_SPACE_LIST;
  else
    stat->MPC_Stat.ExecNet = Join_NetList(expr_evalnet, body_net);

  if((expr_net==HOST_LIST || expr_net->MPC_NetList.Net->MPC_NetOrSubnet.SingleNode) &&
     body_net!=CONST_NET_LIST && !Is_Equal_NetList(expr_net, body_net)) {
    /* reevaluate Stat.ExecNet  (broadcasting of value of control expr): */
    int done = NO;
    while(!done) {
      tTree curr = stat->MPC_Stat.ExecNet;
      /* 1. Find subnet: */
      while(curr->Kind==kMPC_NetList) {
	if(curr->MPC_NetList.Net->Kind==kMPC_Subnet) {
	  /* 2. Find its supernet (MPC_Net): */
	  tTree s = curr->MPC_NetList.Net, tmp;
	  while(s->Kind==kMPC_Subnet) s = s->MPC_Subnet.Distribution;
	  tmp = Join_NetList(stat->MPC_Stat.ExecNet, Make_NetList(s));
	  if(stat->MPC_Stat.ExecNet != tmp)
	    Release_NetList(stat->MPC_Stat.ExecNet), stat->MPC_Stat.ExecNet = tmp;
	  break;
	}
	curr = curr->MPC_NetList.Next;
      }
      if(curr->Kind==kMPC_FreeNode) done = YES;
    } /* end while(!done) */
  } 
}

/***********************/
bool PartAsynchr_Possible
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree parent_net_list, tTree net_list)
#else
	(parent_net_list, net_list)
	tTree parent_net_list, net_list;  /* parent_net_list contains one net (StoreNet); */
#endif
{
  tTree parent_net;

  parent_net = parent_net_list->MPC_NetList.Net;
  while(net_list->Kind==kMPC_NetList) {
    if(net_list->MPC_NetList.Net!=parent_net &&
       net_list->MPC_NetList.Net->MPC_NetOrSubnet.Distribution!=parent_net) return false;
    net_list = net_list->MPC_NetList.Next;
  }
  return true;
}

/**************************/
static int NetOrSubnet_Class
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Net)
#else
	(Net)
	tTree Net;
#endif
{
  tTree NetDecl;
  tPosition Pos=Net->MPC_NetOrSubnet.Pos;
  if(Net==HOST || Net==COMPUTING_SPACE || Net==SINGLE_NODE || Net==CONST_NET) return EXTERN;
  if(Net->Kind==kMPC_Net && Net->MPC_Net.Topology==PARAMETER) return AUTO;
  if(Net->Kind==kMPC_Subnet && Net->MPC_Subnet.Flexible) return AUTO;
  while(Net->Kind!=kMPC_FreeNode)
    Net = Net->MPC_NetOrSubnet.Next;
  if(NetDecl=Net->MPC_FreeNode.Parent) {
    if(NetDecl->Kind==kMPC_NetDecl)
      return NetDecl->MPC_NetDecl.NetClass;
    else if(NetDecl->Kind==kMPC_SubnetDecl)
      return NetDecl->MPC_SubnetDecl.SubnetClass;
    else
      CompilerError("Invalid tree generated for a net", Pos);
      return UNDEFINED;  /* needed only to reduce warnings because CompilerError() stops execution... */
  }
  else
    return UNDEFINED;
}

/*******************/
static int Check_Type
/*******************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type, int Context)
#else
	(Type, Context)
	tTree Type;
#endif
	/* 1.return YES when Type contains dyn.array, and NO     *
         *   in other case or when type has bad tree structure;  *
	 * 2.set Flag.MemCopy for array types (=YES if Step==1). */
{
  int dyn_array = NO;
  tTree size, step;
  tTree n1, n2;
  int FKind=BASIC, RC=0;  /* for GO_TO_EXPR(); */

  if(Context==TOPO_PARAMS || Context==STATS || Type==NoTree || Type==ErrorType)
    return NO;
  if(Type->MPC_Type.Flag.Checked)
    if(Type->MPC_Type.Flag.DynArray || Type->MPC_Type.Flag.DynStep)
      return YES;
    else
      return NO;

  switch(Type->Kind) {
    case kMPC_BasicType:
    case kMPC_EnumType:
	Type->MPC_Type.Flag.MemCopy = YES;
	return NO;
    case kMPC_Typedef:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	dyn_array = Check_Type(Type->MPC_Typedef.Type,Context);
  /***/ Type->MPC_Type.Flag.DynArray = Type->MPC_Typedef.Type->MPC_Type.Flag.DynArray; /***/
  /***/ Type->MPC_Type.Flag.DynStep = Type->MPC_Typedef.Type->MPC_Type.Flag.DynStep; /***/
	Type->MPC_Type.Flag.MemCopy = Type->MPC_Typedef.Type->MPC_Type.Flag.MemCopy;
	return dyn_array;
    case kMPC_ArrayType:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	size = Type->MPC_ArrayType.ArraySize;
	step = Type->MPC_ArrayType.DynStep;
	if(size!=NoTree && size->Kind!=kMPC_FreeNode && !size->MPC_Expr.Flag.Ignore) {
	  GO_TO_EXPR(size,LOCAL_DECLS,COMPUTING_SPACE);  /* -- only the type must be evaluated */
	  size->MPC_Expr.Flag.Ignore = RC;
	  REMAKE_IF_BLOCKING(&size);
	  if(!size->MPC_Expr.Flag.Ignore && !Is_IntegralType(size->MPC_Expr.Type))
	    Type->MPC_Type.Flag.Ignore = size->MPC_Expr.Flag.Ignore = YES,
	    Make_Message(274, xxError, SourcePosition(size->MPC_Expr.Pos,size), size);
		/* "Invalid (not integral) size of array" */
	  if(!size->MPC_Expr.Flag.Const) {
	    Type->MPC_Type.Flag.DynArray = dyn_array = YES;
	    if(!size->MPC_Expr.Flag.Ignore && !IsTypedef && Context!=LOCAL_DECLS && Context!=PARAM_DECLS)
	      Type->MPC_Type.Flag.Ignore = size->MPC_Expr.Flag.Ignore = YES,
	      Type->MPC_Type.Flag.Checked = YES,
	      Make_Message(275, xxError, SourcePosition(size->MPC_Expr.Pos,size), size);
		/* "This array type is used in global declarations but its size is not constant" */
	  }
	}
	if(step!=NoTree && step->Kind!=kMPC_FreeNode && !step->MPC_Expr.Flag.Ignore) {
	  GO_TO_EXPR(step,LOCAL_DECLS,COMPUTING_SPACE);  /* -- only the type must be evaluated */
	  step->MPC_Expr.Flag.Ignore = RC;
	  REMAKE_IF_BLOCKING(&step);
	  if(!step->MPC_Expr.Flag.Ignore && !Is_IntegralType(step->MPC_Expr.Type))
	    Type->MPC_Type.Flag.Ignore = step->MPC_Expr.Flag.Ignore = YES,
	    Make_Message(276, xxError, SourcePosition(step->MPC_Expr.Pos,step), step);
		/* "Invalid (not integral) step of array" */
	  if(!step->MPC_Expr.Flag.Const) {
	    dyn_array = YES;
	    Type->MPC_Type.Flag.DynStep = YES;
	    if(!step->MPC_Expr.Flag.Ignore && !IsTypedef && Context!=LOCAL_DECLS && Context!=PARAM_DECLS)
	      Type->MPC_Type.Flag.Ignore = step->MPC_Expr.Flag.Ignore = YES,
	      Type->MPC_Type.Flag.Checked = YES,
	      Make_Message(277, xxError, SourcePosition(step->MPC_Expr.Pos,step), step);
		/* "This array type is used in global declarations but its step is not constant" */
	  }
	}
	if((size==NoTree || size->Kind==kMPC_FreeNode) &&
	   (step==NoTree || step->Kind==kMPC_FreeNode))
	  dyn_array = Type->MPC_Type.Flag.DynArray = NO;

	/*****  P R E V I O U S    V E R S I O N : *****
	if((size==NoTree || size->Kind==kMPC_FreeNode) &&
	   (step==NoTree || step->Kind==kMPC_FreeNode)) {
	  Type->MPC_Type.Flag.DynArray = NO;
	  return NO;
	}
	***********************************************/
	dyn_array |= Check_Type(Type->MPC_ArrayType.ElementType, Context);
  /***/ Type->MPC_Type.Flag.DynArray |= Type->MPC_ArrayType.ElementType->MPC_Type.Flag.DynArray; /***/
  /***/ Type->MPC_Type.Flag.DynStep |= Type->MPC_ArrayType.ElementType->MPC_Type.Flag.DynStep; /***/
	Type->MPC_Type.Flag.MemCopy = (!Type->MPC_Type.Flag.DynStep &&
				       (Type->MPC_ArrayType.Step==0||Type->MPC_ArrayType.Step==1)) &&
					 Type->MPC_ArrayType.ElementType->MPC_Type.Flag.MemCopy;
	return dyn_array;
    case kMPC_VectorType:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	size = Type->MPC_VectorType.VectorSize;
	if(size!=NoTree && size->Kind!=kMPC_FreeNode)
	  Type->MPC_Type.Flag.DynArray = dyn_array = YES;
	dyn_array |= Check_Type(Type->MPC_VectorType.ElementType,Context);
  /***/ Type->MPC_Type.Flag.DynArray |= Type->MPC_VectorType.ElementType->MPC_Type.Flag.DynArray; /***/
	Type->MPC_Type.Flag.MemCopy = YES;
	return dyn_array;
    case kMPC_PointerType:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	if(Type->MPC_PointerType.DynStep!=NoTree &&
	   Type->MPC_PointerType.DynStep->Kind!=kMPC_FreeNode) {
	  dyn_array = YES;
	  Type->MPC_Type.Flag.DynStep = YES;
	  if(Context==GLOBAL_DECLS &&
	     !Type->MPC_PointerType.DynStep->MPC_Expr.Flag.Ignore) {
	    Type->MPC_Type.Flag.Ignore =
		  Type->MPC_PointerType.DynStep->MPC_Expr.Flag.Ignore = YES;
	    Make_Message(278, xxError,
                         SourcePosition(Type->MPC_PointerType.DynStep->MPC_Expr.Pos,
                                        Type->MPC_PointerType.DynStep),
                         Type->MPC_PointerType.DynStep);
		/* "This pointer type is used in global declarations but its step is not constant" */
	  }
	}
	dyn_array |= Check_Type(Type->MPC_PointerType.ElementType,Context);
	dyn_array |= Check_Type(Type->MPC_ArrayType.ElementType, Context);
  /***/ Type->MPC_Type.Flag.DynArray |= Type->MPC_PointerType.ElementType->MPC_Type.Flag.DynArray; /***/
  /***/ Type->MPC_Type.Flag.DynStep |= Type->MPC_PointerType.ElementType->MPC_Type.Flag.DynStep; /***/
	Type->MPC_Type.Flag.MemCopy = YES;
	return dyn_array;
    case kMPC_StructType:
    case kMPC_UnionType:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	Type->MPC_Type.Flag.MemCopy = YES;
	n1 = Type->MPC_StructType.MemberDecls;
	while(n1!=NoTree && n1->Kind!=kMPC_FreeNode) {
	  n2 = n1->MPC_SU_MemberDecl.Member;
	  while(n2!=NoTree && n2->Kind!=kMPC_FreeNode) {
	    dyn_array |= Check_Type(n2->MPC_SU_Member.Type, Context);  /*** ??? ***/
	    n2 = n2->MPC_SU_Member.Next;
	  }
	  n1 = n1->MPC_SU_MemberDecl.Next;
	}
	return (Type->MPC_Type.Flag.DynArray = dyn_array);
    case kMPC_FunctionType:
	if(!IsTypedef)
	  Type->MPC_Type.Flag.Checked = YES;
	Type->MPC_Type.Flag.MemCopy = YES;
	n1 = Type->MPC_FunctionType.ParamList;
	while(n1!=NoTree && n1->Kind!=kMPC_FreeNode) {
	  if(n1->Kind==kMPC_Typedef)
	    /*dyn_array |=*/ (void)Check_Type(n1->MPC_Typedef.Type, PARAM_DECLS);
	  else if(n1->Kind==kMPC_VarDecl) {
	    /*dyn_array |=*/ (void)Check_Type(n1->MPC_VarDecl.DeclSpecifier, PARAM_DECLS);
	    if(n1->MPC_VarDecl.Var!=NoTree && n1->MPC_VarDecl.Var->Kind==kMPC_Var)
	      /*dyn_array |=*/ (void)Check_Type(n1->MPC_VarDecl.Var->MPC_Var.Type, PARAM_DECLS);
	  }  /* else kMPC_Ellipsis -- no work; */
	  n1 = n1->MPC_Decls.Next;
	}
	return ( Type->MPC_Type.Flag.DynArray = dyn_array ||
			 Check_Type(Type->MPC_FunctionType.ResultType, Context) );
    default:
	return NO;
  }

  return NO;
}

/**************************/
bool  Check_NetTypeSpecifier
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetDecl)
#else
	(NetDecl)  tTree NetDecl;
#endif
{
  if(NetDecl->MPC_NetDecl.NetClass!=AUTO) {
    DECL_Warning((316, xxWarning, NetDecl->MPC_NetDecl.Pos, NetDecl));
		/* "Net class ignored inside of timeof expression" */
  }
  return false;   /* all errors should be detected before call of this function; */
}

/*********************/
int Check_NodeSpecifier  /* returns 1 when error */
/*********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Exprs, tTree Coords, tTree PrevExprs)
#else
	(Exprs, Coords, PrevExprs)
	tTree Exprs, Coords, PrevExprs;
#endif
{
  if( Exprs==NoTree || Coords==NoTree )
    return 1;
  if( Exprs->Kind==kMPC_FreeNode && Coords->Kind==kMPC_FreeNode )
    return 0;
  else if( Exprs->Kind==kMPC_FreeNode && Coords->Kind!=kMPC_FreeNode ) {
    Make_Message(493, xxError, PrevExprs->MPC_Exprs.EndPos, PrevExprs);
		 /* "Node specifier is too short" */
    return 1;
  }
  else if( Exprs->Kind!=kMPC_FreeNode && Coords->Kind==kMPC_FreeNode ) {
    Make_Message(492, xxError, Exprs->MPC_Exprs.BegPos, Exprs);
		 /* "Node specifier is too long" */
    return 1;
  }
  else {  /** check type and value (if constant expr and constant coord range) **/
    if( !Is_IntegralType(Exprs->MPC_Exprs.Expr->MPC_Expr.Type )) {
      Make_Message(494, xxError, Exprs->MPC_Exprs.Pos, Exprs->MPC_Exprs.Expr);
                   /* "Not integral expression in node specifier" */
      (void)Check_NodeSpecifier(Exprs->MPC_Exprs.Next, Coords->MPC_CoordDecl.Next, Exprs);
      return 1; 
    }
    if( Exprs->MPC_Exprs.Expr->MPC_Expr.Flag.Const &&
          (Exprs->MPC_Exprs.Expr->Kind==kMPC_IntConst || Exprs->MPC_Exprs.Expr->Kind==kMPC_UIntConst) &&
        Coords->MPC_CoordDecl.Range->MPC_Expr.Flag.Const &&
          (Coords->MPC_CoordDecl.Range->Kind==kMPC_IntConst || Coords->MPC_CoordDecl.Range->Kind==kMPC_UIntConst) &&
        (Exprs->MPC_Exprs.Expr->MPC_IntConst.Value >= Coords->MPC_CoordDecl.Range->MPC_IntConst.Value ||
         Exprs->MPC_Exprs.Expr->MPC_IntConst.Value < 0) ) {
      Make_Message(495, xxError, Exprs->MPC_Exprs.Pos, Exprs->MPC_Exprs.Expr);
                   /* "Expression in node specifier out of range" */
      (void)Check_NodeSpecifier(Exprs->MPC_Exprs.Next, Coords->MPC_CoordDecl.Next, Exprs);
      return 1; 
    }
  }
  return Check_NodeSpecifier(Exprs->MPC_Exprs.Next, Coords->MPC_CoordDecl.Next, Exprs);
}

/**************************/
bool  Check_SingleNodeParent
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree NetDecl)
#else
	(NetDecl)  tTree NetDecl;
#endif
{
  if(NetDecl->MPC_NetDecl.Net==NoTree ||
     NetDecl->MPC_NetDecl.Net->Kind==kMPC_FreeNode ||
     NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution==NoTree ||
     NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution->Kind==kMPC_FreeNode ||
     /**NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution!=NoTree &&**/
     NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution->MPC_NetOrSubnet.SingleNode)
    return false;   /* All right! */
  else {
    Make_Message(279, xxError, NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution->MPC_NetOrSubnet.Pos,
		 NetDecl->MPC_NetDecl.Net->MPC_Net.Distribution);
		/* "The distributed net can't be specified inside of timeof expression" */
    return true;
  }
}

/***********************/
int Check_UniqueCaseLabel
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tTree Label)
#else
	(Label) tTree Label;
#endif
{
  int RC=0;
  tTree Stat;
  unsigned long LabValue;
  tPosition pos;

  if(Label->MPC_CaseLabel.Expr->Kind!=kMPC_IntConst &&
     Label->MPC_CaseLabel.Expr->Kind!=kMPC_UIntConst)
    return 0;  /* No checks; */

  if(Label->MPC_CaseLabel.Expr->Kind==kMPC_IntConst)
    LabValue = Label->MPC_CaseLabel.Expr->MPC_IntConst.Value;
  else
    LabValue = Label->MPC_CaseLabel.Expr->MPC_UIntConst.Value;

  for(Stat=Label->MPC_Stats.Prev; Stat->Kind!=kMPC_FreeNode; Stat=Stat->MPC_Stats.Prev) {
    if(Stat->Kind==kMPC_CaseLabel) {
      if(Stat->MPC_CaseLabel.Expr->Kind==kMPC_IntConst &&
	   LabValue==Stat->MPC_CaseLabel.Expr->MPC_IntConst.Value  ||
	 Stat->MPC_CaseLabel.Expr->Kind==kMPC_UIntConst &&
	   LabValue==Stat->MPC_CaseLabel.Expr->MPC_UIntConst.Value) {
        RC = 1;
	pos = RealPosition(Stat->MPC_Stats.Pos);
	Make_Message(620, xxError, Label->MPC_Stats.Pos, Label);
		/* "Case label duplicated" */
	Make_MessageI(20, xxInformation, Label->MPC_Stats.Pos, xxString,
			 SourceFile(Stat->MPC_Stats.Pos), Stat);
		/* "   The case label with the same value is declared in file" */
        Make_MessageI(14, xxInformation, Label->MPC_Stats.Pos, xxShort,
		/* "   in line" */
		      (char*)&pos.Line, Stat);
      }
    }
  }

  return RC;
}

/**************************/
int Check_SingleDefaultLabel
/**************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Label)
#else
	(Label) tTree Label;
#endif
{
  int RC=0;
  tTree Stat;
  tPosition pos;

  for(Stat=Label->MPC_Stats.Prev; Stat->Kind!=kMPC_FreeNode; Stat=Stat->MPC_Stats.Prev) {
    if(Stat->Kind==kMPC_Default) {
      RC = 1;
      pos = RealPosition(Stat->MPC_Stats.Pos);
      Make_Message(621, xxError, Label->MPC_Stats.Pos, Label);
		/* "'default' label duplicated" */
      Make_MessageI(21, xxInformation,
		/* "   The previous 'default' label is declared in file" */
		    Label->MPC_Stats.Pos, xxString, SourceFile(Stat->MPC_Stats.Pos), Stat);
      Make_MessageI(14, xxInformation, Label->MPC_Stats.Pos, xxShort,
		    (char*)&pos.Line, Stat);
		/* "   in line" */
    }
  }
  return RC;
}

/**********************/
tTree Reduce_TypePattern
/**********************/
#if defined __STDC__ | defined __cplusplus
	(tTree TypePattern)
#else
	(TypePattern) tTree TypePattern;
#endif
{
  if(TypePattern->Kind==kMPC_ArrayType)
    TypePattern = TypePattern->MPC_ArrayType.ElementType;
  /** and it's all by now... ADD OTHER AGGREGATE TYPES **/

  return TypePattern;
}

/*****************/
int  Check_InitList
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tTree List, tTree TypePattern)
#else
	(List, TypePattern)
#endif
{
  tTree item;
  int inum;
  if(Is_ScalarType(TypePattern) && List->Kind==kMPC_InitList && List->MPC_InitList.Length > 1) {
    Make_Message(486, xxError, List->MPC_Initializer.Pos, List);
		/* "Scalar (or scalar element of aggregate object) initialized by the list" */
    return 1;
  }
  if(TypePattern->Kind==kMPC_ArrayType && List->Kind==kMPC_InitList &&
     TypePattern->MPC_ArrayType.NumberOfComponents < List->MPC_InitList.Length) {
    item = List->MPC_InitList.List;
    for(inum=0; inum<TypePattern->MPC_ArrayType.NumberOfComponents; inum++)
      item = item->MPC_Initializer.Next;
    Make_Message(22, xxError, item->MPC_Initializer.Pos, item);
		/* "Too many elements in initializer list" */
    return 1;
  }
  return 0;
}
