#define __C_2_MPC_C__

#include "mpc_diag.h"

#include "c2mpC.h"

#include <stdio.h>

bool C_2_MPC_SOURCE = true; 
bool HEADER_NAME_GENERATED = true;
bool PRAGMA_SOURCE_GENERATED = true;
bool EmptyHeader = false;
tString CurrentHeaderName;

int mpC_PrintMode = PRETTY;
static
int PrettyLayout     = 0;

FILE *outfile = NULL; /* -- TMP -- */
                      /* NULL may cause problems as well as stdout  *
                       * when using gcc 2.8.1 and above on Linux;   */

#define  PRINT  if(C_2_MPC_SOURCE)fprintf
#define  MAKE_LAYOUT  {int i; for(i=PrettyLayout; i; i--)PRINT(outfile," ");}


    /** Work functions used by print_mpC(): **/

static  void  print_TypeSpecifier  ARGS((tTree Type));
static  void  print_Declarator     ARGS((tIdent Name, tTree Type));
 

/************/
void print_mpC
/************/
#if defined __STDC__ | defined __cplusplus
	(tTree Tree)
#else
	(Tree) tTree Tree;
#endif
{
  if(Tree==NoTree || Tree->Kind==kMPC_FreeNode) return;
  if(outfile==NULL)
    outfile = stdout;  /***TMP***/

  switch(Tree->Kind) {

    case kMPC_UncompString:
    /*+++++++++++++++++++*/
	if(!strcmp(Tree->MPC_UncompString.uString, END_OF_HEADER_STRING))
	  C_2_MPC_SOURCE = true;
	else {
	  PRINT(outfile, "#include %s\n", Tree->MPC_UncompString.uString);
	  C_2_MPC_SOURCE = false;
	}
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_EnumType:
    /*---------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_Typedef:
    /*++++++++++++++*/
	MAKE_LAYOUT;
	PRINT(outfile, "typedef ");
	print_TypeSpecifier(Tree->MPC_Typedef.Type);
	print_Declarator(Tree->MPC_Typedef.TypedefName, Tree->MPC_Typedef.Type);
	PRINT(outfile, ";\n");
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_StructType:
    /*-----------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_UnionType:
    /*----------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_VarDecl:
    /*--------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_Function:
    /*---------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_Ellipsis:
    /*---------------*/
	print_mpC(Tree->MPC_Decls.Next);
	break;
    case kMPC_EnumConst:
    /*----------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_EnumConst.Next);
	break;
    case kMPC_SU_MemberDecl:
    /*--------------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_SU_MemberDecl.Next);
	break;
    case kMPC_SU_Member:
    /*----------------*/
	print_mpC(Tree->MPC_SU_Member.Next);
	break;
    case kMPC_Var:
    /*----------*/
	print_mpC(Tree->MPC_Var.Next);
	break;
    case kMPC_Net:
    /*----------*/
	break;
    case kMPC_ExprStat:
    /*---------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_If:
    /*---------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_IfElse:
    /*-------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Switch:
    /*-------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_While:
    /*------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_DoWhile:
    /*--------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_For:
    /*----------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Goto:
    /*-----------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Continue:
    /*---------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Break:
    /*------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Return:
    /*-------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Compound:
    /*---------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_IdentLabel:
    /*-----------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_CaseLabel:
    /*----------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_Default:
    /*--------------*/
	MAKE_LAYOUT;
	print_mpC(Tree->MPC_Stats.Next);
	break;
    case kMPC_IntConst:
    case kMPC_UIntConst:
    case kMPC_FloatConst:
    /*---------------*/
	break;
    case kMPC_StringLiteral:
    /*--------------------*/
	break;
    case kMPC_Ident:
    /*------------*/
	break;
    case kMPC_CastExpr:
    /*---------------*/
	break;
    case kMPC_NetCastExpr:
    /*------------------*/
	break;
    case kMPC_Size_Of_Value:
    /*--------------------*/
	break;
    case kMPC_Size_Of_Type:
    /*-------------------*/
	break;
    case kMPC_UnaryExpr:
    /*----------------*/
	break;
    case kMPC_BinaryExpr:
    /*-----------------*/
	break;
    case kMPC_TernaryExpr:
    /*------------------*/
	break;
    case kMPC_QuaternaryExpr:
    /*---------------------*/
	break;
    case kMPC_CallExpr:
    /*---------------*/
	break;
    case kMPC_Exprs:
    /*------------*/
	print_mpC(Tree->MPC_Exprs.Next);
	break;
    case kMPC_SimpleInit:
    /*-----------------*/
	print_mpC(Tree->MPC_Initializer.Next);
	break;
    case kMPC_InitList:
    /*---------------*/
	print_mpC(Tree->MPC_Initializer.Next);
	break;
    
    default:
    /*----*/
	fprintf(stderr, "c2mpC: Unsupported tree node in print_mpC()\n");
	/***
	Make_Message("This tree node isn't supported yet by print_mpC()",
		     xxRestriction, Tree->MPC_Decls.Pos, Tree);
	***/
	/*QueryTree(Tree);*/

  } /* end switch(Tree->Kind) */

}  /** END print_mpC **/


    /*********************************************************/
    /********   Work functions used by print_mpC():   ********/
    /*********************************************************/

/*******************************/
static  void  print_TypeSpecifier
/*******************************/
#if defined __STDC__ | defined __cplusplus
	(tTree Type)
#else
	(Type) tTree Type;
#endif
{

}

/****************************/
static  void  print_Declarator
/****************************/
#if defined __STDC__ | defined __cplusplus
	(tIdent Name, tTree Type)
#else
	(Name, Type)
	tIdent Name;
	tTree  Type;
#endif
{

}
