# ifndef yyTree
# define yyTree

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# include <stdio.h>
/* line 5 "mpc.ast" */


# include "context.h"



# ifndef bool
# define bool char
# endif
# define NoTree (tTree) 0L
# define kMPC_AstNode 1
# define kMPC_Root 2
# define kMPC_Source 3
# define kMPC_Messages 4
# define kMPC_ErrorMessage 5
# define kMPC_ErrorMessageI 6
# define kMPC_Message 7
# define kMPC_MessageI 8
# define kMPC_FreeNode 9
# define kMPC_Decls 10
# define kMPC_UncompString 11
# define kMPC_Type 12
# define kMPC_BasicType 13
# define kMPC_EnumType 14
# define kMPC_Typedef 15
# define kMPC_DerivedType 16
# define kMPC_ArrayType 17
# define kMPC_VectorType 18
# define kMPC_PointerType 19
# define kMPC_StructType 20
# define kMPC_UnionType 21
# define kMPC_FunctionType 22
# define kMPC_VarDecl 23
# define kMPC_Function 24
# define kMPC_Ellipsis 25
# define kMPC_NetDecl 26
# define kMPC_SubnetDecl 27
# define kMPC_RelDecl 28
# define kMPC_NetTypeDecl 29
# define kMPC_NetType 30
# define kMPC_NetTypeSpecifier 31
# define kMPC_TopoFunctions 32
# define kMPC_EnumConst 33
# define kMPC_SU_MemberDecl 34
# define kMPC_SU_Member 35
# define kMPC_Var 36
# define kMPC_CoordDecl 37
# define kMPC_Node 38
# define kMPC_NodeQual 39
# define kMPC_NodeTypeQual 40
# define kMPC_BenchQual 41
# define kMPC_LinkDecl 42
# define kMPC_LinkDeclaringList 43
# define kMPC_LinkDeclarator 44
# define kMPC_LinkLengthSpecifier 45
# define kMPC_Scheme 46
# define kMPC_NetList 47
# define kMPC_NetOrSubnet 48
# define kMPC_Net 49
# define kMPC_Subnet 50
# define kMPC_Relation 51
# define kMPC_Stats 52
# define kMPC_Stat 53
# define kMPC_ExprStat 54
# define kMPC_If 55
# define kMPC_IfElse 56
# define kMPC_Switch 57
# define kMPC_While 58
# define kMPC_DoWhile 59
# define kMPC_For 60
# define kMPC_Goto 61
# define kMPC_Continue 62
# define kMPC_Break 63
# define kMPC_BreakFan 64
# define kMPC_Return 65
# define kMPC_Compound 66
# define kMPC_CompScheme 67
# define kMPC_CommScheme 68
# define kMPC_ParScheme 69
# define kMPC_Fan 70
# define kMPC_Label 71
# define kMPC_IdentLabel 72
# define kMPC_CaseLabel 73
# define kMPC_Default 74
# define kMPC_Expr 75
# define kMPC_Const 76
# define kMPC_IntConst 77
# define kMPC_UIntConst 78
# define kMPC_FloatConst 79
# define kMPC_StringLiteral 80
# define kMPC_Ident 81
# define kMPC_CastExpr 82
# define kMPC_NetCastExpr 83
# define kMPC_CoordExpr 84
# define kMPC_SizeofExpr 85
# define kMPC_Size_Of_Value 86
# define kMPC_Size_Of_Type 87
# define kMPC_TimeofExpr 88
# define kMPC_UnaryExpr 89
# define kMPC_BinaryExpr 90
# define kMPC_TernaryExpr 91
# define kMPC_QuaternaryExpr 92
# define kMPC_CallExpr 93
# define kMPC_Exprs 94
# define kMPC_Initializer 95
# define kMPC_SimpleInit 96
# define kMPC_InitList 97

typedef unsigned char Tree_tKind;
typedef unsigned short Tree_tMark;
typedef unsigned short Tree_tLabel;
typedef union Tree_Node * tTree;
typedef void (* Tree_tProcTree) ARGS((tTree));
/* line 266 "mpc.ast" */

  typedef void * pVoid;
  extern tTree Clean_OutAttributes(tTree node);


# ifndef Tree_NodeHead
# define Tree_NodeHead
# endif
typedef struct { Tree_tKind yyKind; Tree_tMark yyMark; Tree_NodeHead } Tree_tNodeHead;
typedef struct { Tree_tNodeHead yyHead; } yMPC_AstNode;
typedef struct { Tree_tNodeHead yyHead; tTree Decls; tTree Source; tTree Messages; tTree Host; tTree SingleNode; tTree ComputingSpace; tTree Const; tTree Recon; tTree HostList; tTree SingleNodeList; tTree ComputingSpaceList; tTree ConstList; tTree ReconList; } yMPC_Root;
typedef struct { Tree_tNodeHead yyHead; tString FileName; tPosition VirtPos; tPosition RealPos; tTree Next; tTree Prev; } yMPC_Source;
typedef struct { Tree_tNodeHead yyHead; int ErrorClass; tPosition Pos; tTree Next; tTree Prev; tTree Tree; } yMPC_Messages;
typedef struct { Tree_tNodeHead yyHead; int ErrorClass; tPosition Pos; tTree Next; tTree Prev; tTree Tree; int ErrorCode; } yMPC_ErrorMessage;
typedef struct { Tree_tNodeHead yyHead; int ErrorClass; tPosition Pos; tTree Next; tTree Prev; tTree Tree; int ErrorCode; int InfoClass; tString Info; } yMPC_ErrorMessageI;
typedef struct { Tree_tNodeHead yyHead; int ErrorClass; tPosition Pos; tTree Next; tTree Prev; tTree Tree; short MessageNumber; } yMPC_Message;
typedef struct { Tree_tNodeHead yyHead; int ErrorClass; tPosition Pos; tTree Next; tTree Prev; tTree Tree; short MessageNumber; int InfoClass; tString Info; } yMPC_MessageI;
typedef struct { Tree_tNodeHead yyHead; tTree Parent; } yMPC_FreeNode;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; } yMPC_Decls;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tString uString; } yMPC_UncompString;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; } yMPC_Type;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; short TypeConstructor; } yMPC_BasicType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; tIdent EnumTag; tTree EnumList; } yMPC_EnumType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; tIdent TypedefName; tTree Type; } yMPC_Typedef;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; } yMPC_DerivedType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; short Step; tTree ElementType; tTree ArraySize; tTree DynStep; } yMPC_ArrayType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; tTree ElementType; tTree VectorSize; } yMPC_VectorType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; short Step; tTree ElementType; tTree DynStep; tTree GeneratedFrom; } yMPC_PointerType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; tIdent SU_Tag; tTree MemberDecls; } yMPC_StructType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; tIdent SU_Tag; tTree MemberDecls; } yMPC_UnionType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTypeFlags Flag; bool Buffer; MPC_unsigned_short UniqueNumber; tTree EquivType; pVoid pType; int NumberOfComponents; short Kind; tTree ResultType; tTree NetParamType; tTree NetParam; tTree NetworkParamList; tTree ParamList; } yMPC_FunctionType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tClass Class; tDeclFlags Flag; tTree DeclSpecifier; tTree Var; } yMPC_VarDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; short Kind; tDeclFlags Flag; tTree Distribution; tTree Name; tTree Type; tTree ParamList; tTree Stats; tTree LabelList; } yMPC_Function;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; } yMPC_Ellipsis;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tClass NetClass; tDeclFlags Flag; tTree NetTypeSpecifier; tTree Net; } yMPC_NetDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tClass SubnetClass; tDeclFlags Flag; tTree Subnet; } yMPC_SubnetDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree Relation; } yMPC_RelDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tIdent Ident; } yMPC_NetTypeDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tIdent Ident; tClass Class; tTree ParamList; tTree CoordDecl; tTree NodeDecl; tTree LinkDecl; tTree StartDecl; tTree SchemeDecl; bool Bench; tTree TopoFunctions; } yMPC_NetType;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tIdent Ident; tTree NetType; tTree ArgList; } yMPC_NetTypeSpecifier;
typedef struct { Tree_tNodeHead yyHead; tTree Node_Def; tTree Link_Def; tTree Main_Node_Def; tTree Power_Def; tTree Node_Coord_Def; tTree Node_Number_Def; tTree Mapping_Def; } yMPC_TopoFunctions;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Name; bool WithValue; int Value; tTree Next; tTree Prev; tPosition EndPos; } yMPC_EnumConst;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tTree Member; tPosition EndPos; } yMPC_SU_MemberDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Name; short BitFieldLength; tTree Next; tTree Prev; tTree Type; tTree BitFieldSize; tPosition EndPos; MPC_unsigned_short UniqueNumber; } yMPC_SU_Member;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Ident; tDeclFlags Flag; tTree Next; tTree Prev; tTree Type; tTree Distribution; tTree Init; tPosition EndPos; } yMPC_Var;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Ident; tTree Next; tTree Prev; tTree Range; tPosition EndPos; short CoordNumber; } yMPC_CoordDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tNodeType NodeType; bool DynamicType; tTree Next; tTree Prev; tTree Predicate; tTree NodeQual; tPosition EndPos; } yMPC_Node;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree CapacityExpr; tPosition EndPos; } yMPC_NodeQual;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree CapacityExpr; tPosition EndPos; bool Fast; int Capacity; } yMPC_NodeTypeQual;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree CapacityExpr; tPosition EndPos; double Capacity; } yMPC_BenchQual;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree FreeCoord; tTree LinkDeclaringList; tPosition EndPos; } yMPC_LinkDecl;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tLinkType LinkType; bool DynamicLength; tTree Next; tTree Prev; tTree Predicate; tTree LinkLengthSpecifier; tTree LinkDeclarator; tPosition EndPos; } yMPC_LinkDeclaringList;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tTree LeftNode; tTree RightNode; tPosition EndPos; } yMPC_LinkDeclarator;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tLinkType LinkLength; tTree LinkLengthExpr; tPosition EndPos; } yMPC_LinkLengthSpecifier;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Body; tPosition EndPos; } yMPC_Scheme;
typedef struct { Tree_tNodeHead yyHead; tTree Next; tTree Prev; tTree Net; tPosition Pos; bool UnReduceable; } yMPC_NetList;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Ident; bool BigCreate; tTree Distribution; tTree Next; tTree Prev; tPosition EndPos; MPC_unsigned_short UniqueNumber; bool WithNumber; bool SingleNode; bool IsParent; pVoid pGen; tTree NextUse; tTree PrevUse; tTree MyList; } yMPC_NetOrSubnet;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Ident; bool BigCreate; tTree Distribution; tTree Next; tTree Prev; tPosition EndPos; MPC_unsigned_short UniqueNumber; bool WithNumber; bool SingleNode; bool IsParent; pVoid pGen; tTree NextUse; tTree PrevUse; tTree MyList; short Topology; tTree NetType; } yMPC_Net;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tIdent Ident; bool BigCreate; tTree Distribution; tTree Next; tTree Prev; tPosition EndPos; MPC_unsigned_short UniqueNumber; bool WithNumber; bool SingleNode; bool IsParent; pVoid pGen; tTree NextUse; tTree PrevUse; tTree MyList; tIdent NetOrSubnetName; bool Flexible; tTree Predicate; } yMPC_Subnet;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; int RelCode; tTree Next; tTree Prev; tTree LNet; tTree RNet; tPosition EndPos; } yMPC_Relation;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; } yMPC_Stats;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; } yMPC_Stat;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; } yMPC_ExprStat;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree Stats; } yMPC_If;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree Then; tTree Else; } yMPC_IfElse;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree Stats; } yMPC_Switch;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree Stats; } yMPC_While;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Stats; tTree Expr; } yMPC_DoWhile;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Init; tTree Cond; tTree Reinit; tTree Stats; } yMPC_For;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tIdent Ident; tTree LabelDef; tTree NextUse; tTree PrevUse; } yMPC_Goto;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; } yMPC_Continue;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; } yMPC_Break;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; } yMPC_BreakFan;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; } yMPC_Return;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; int FunctionBody; tTree Decls; tTree Stats; } yMPC_Compound;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree Node; } yMPC_CompScheme;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Expr; tTree From; tTree To; } yMPC_CommScheme;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Init; tTree Cond; tTree Reinit; tTree Stats; } yMPC_ParScheme;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tStatFlags Flag; tTree ExecNet; tTree ActualExecNet; tTree RootNet; tTree PropNet; bool Benchmark; MPC_unsigned_short UniqueNumber; tTree Body; } yMPC_Fan;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree NextLabel; tTree PrevLabel; } yMPC_Label;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree NextLabel; tTree PrevLabel; tIdent Ident; tTree NextUse; bool Used; } yMPC_IdentLabel;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree NextLabel; tTree PrevLabel; long CaseValue; tTree Expr; } yMPC_CaseLabel;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree NextLabel; tTree PrevLabel; } yMPC_Default;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; } yMPC_Expr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tString SymbolicForm; } yMPC_Const;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tString SymbolicForm; long Value; } yMPC_IntConst;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tString SymbolicForm; MPC_long_unsigned Value; } yMPC_UIntConst;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tString SymbolicForm; MPC_long_double Value; } yMPC_FloatConst;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tString String; short FullSize; tTree Next; tTree Prev; } yMPC_StringLiteral;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tIdent Ident; tTree Store; tTree NextUse; tTree PrevUse; } yMPC_Ident;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tTree TypeName; tTree Operand; } yMPC_CastExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; bool Flexible; tTree Operand; pVoid ExprPtr; } yMPC_NetCastExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tIdent CoordName; tTree Operand; short CoordNumber; } yMPC_CoordExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; bool CompileTime; int Value; } yMPC_SizeofExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; bool CompileTime; int Value; tTree Operand; } yMPC_Size_Of_Value;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; bool CompileTime; int Value; tTree Operand; } yMPC_Size_Of_Type;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tTree NetDecl; } yMPC_TimeofExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; short OpCode; tTree Operand; } yMPC_UnaryExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; short OpCode; tTree Loperand; tTree Roperand; } yMPC_BinaryExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; short OpCode; tTree Foperand; tTree Soperand; tTree Toperand; } yMPC_TernaryExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; short OpCode; tTree Operand1; tTree Operand2; tTree Operand3; tTree Operand4; } yMPC_QuaternaryExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tExprFlags Flag; tString TmpName; tTree Type; tTree EvalNet; tTree StoreNet; tPosition BegPos; tPosition EndPos; tTree ActualEvalNet; char Pass; bool Repl; tOptm_Attribute Optm_Attribute; tTree Function; tTree ArgList; tTree NetworkArgList; } yMPC_CallExpr;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tTree Expr; tPosition BegPos; tPosition EndPos; } yMPC_Exprs;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; } yMPC_Initializer;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; tTree Expr; } yMPC_SimpleInit;
typedef struct { Tree_tNodeHead yyHead; tPosition Pos; tTree Next; tTree Prev; tPosition EndPos; int Length; tTree List; } yMPC_InitList;

union Tree_Node {
 Tree_tKind Kind;
 Tree_tNodeHead yyHead;
 yMPC_AstNode MPC_AstNode;
 yMPC_Root MPC_Root;
 yMPC_Source MPC_Source;
 yMPC_Messages MPC_Messages;
 yMPC_ErrorMessage MPC_ErrorMessage;
 yMPC_ErrorMessageI MPC_ErrorMessageI;
 yMPC_Message MPC_Message;
 yMPC_MessageI MPC_MessageI;
 yMPC_FreeNode MPC_FreeNode;
 yMPC_Decls MPC_Decls;
 yMPC_UncompString MPC_UncompString;
 yMPC_Type MPC_Type;
 yMPC_BasicType MPC_BasicType;
 yMPC_EnumType MPC_EnumType;
 yMPC_Typedef MPC_Typedef;
 yMPC_DerivedType MPC_DerivedType;
 yMPC_ArrayType MPC_ArrayType;
 yMPC_VectorType MPC_VectorType;
 yMPC_PointerType MPC_PointerType;
 yMPC_StructType MPC_StructType;
 yMPC_UnionType MPC_UnionType;
 yMPC_FunctionType MPC_FunctionType;
 yMPC_VarDecl MPC_VarDecl;
 yMPC_Function MPC_Function;
 yMPC_Ellipsis MPC_Ellipsis;
 yMPC_NetDecl MPC_NetDecl;
 yMPC_SubnetDecl MPC_SubnetDecl;
 yMPC_RelDecl MPC_RelDecl;
 yMPC_NetTypeDecl MPC_NetTypeDecl;
 yMPC_NetType MPC_NetType;
 yMPC_NetTypeSpecifier MPC_NetTypeSpecifier;
 yMPC_TopoFunctions MPC_TopoFunctions;
 yMPC_EnumConst MPC_EnumConst;
 yMPC_SU_MemberDecl MPC_SU_MemberDecl;
 yMPC_SU_Member MPC_SU_Member;
 yMPC_Var MPC_Var;
 yMPC_CoordDecl MPC_CoordDecl;
 yMPC_Node MPC_Node;
 yMPC_NodeQual MPC_NodeQual;
 yMPC_NodeTypeQual MPC_NodeTypeQual;
 yMPC_BenchQual MPC_BenchQual;
 yMPC_LinkDecl MPC_LinkDecl;
 yMPC_LinkDeclaringList MPC_LinkDeclaringList;
 yMPC_LinkDeclarator MPC_LinkDeclarator;
 yMPC_LinkLengthSpecifier MPC_LinkLengthSpecifier;
 yMPC_Scheme MPC_Scheme;
 yMPC_NetList MPC_NetList;
 yMPC_NetOrSubnet MPC_NetOrSubnet;
 yMPC_Net MPC_Net;
 yMPC_Subnet MPC_Subnet;
 yMPC_Relation MPC_Relation;
 yMPC_Stats MPC_Stats;
 yMPC_Stat MPC_Stat;
 yMPC_ExprStat MPC_ExprStat;
 yMPC_If MPC_If;
 yMPC_IfElse MPC_IfElse;
 yMPC_Switch MPC_Switch;
 yMPC_While MPC_While;
 yMPC_DoWhile MPC_DoWhile;
 yMPC_For MPC_For;
 yMPC_Goto MPC_Goto;
 yMPC_Continue MPC_Continue;
 yMPC_Break MPC_Break;
 yMPC_BreakFan MPC_BreakFan;
 yMPC_Return MPC_Return;
 yMPC_Compound MPC_Compound;
 yMPC_CompScheme MPC_CompScheme;
 yMPC_CommScheme MPC_CommScheme;
 yMPC_ParScheme MPC_ParScheme;
 yMPC_Fan MPC_Fan;
 yMPC_Label MPC_Label;
 yMPC_IdentLabel MPC_IdentLabel;
 yMPC_CaseLabel MPC_CaseLabel;
 yMPC_Default MPC_Default;
 yMPC_Expr MPC_Expr;
 yMPC_Const MPC_Const;
 yMPC_IntConst MPC_IntConst;
 yMPC_UIntConst MPC_UIntConst;
 yMPC_FloatConst MPC_FloatConst;
 yMPC_StringLiteral MPC_StringLiteral;
 yMPC_Ident MPC_Ident;
 yMPC_CastExpr MPC_CastExpr;
 yMPC_NetCastExpr MPC_NetCastExpr;
 yMPC_CoordExpr MPC_CoordExpr;
 yMPC_SizeofExpr MPC_SizeofExpr;
 yMPC_Size_Of_Value MPC_Size_Of_Value;
 yMPC_Size_Of_Type MPC_Size_Of_Type;
 yMPC_TimeofExpr MPC_TimeofExpr;
 yMPC_UnaryExpr MPC_UnaryExpr;
 yMPC_BinaryExpr MPC_BinaryExpr;
 yMPC_TernaryExpr MPC_TernaryExpr;
 yMPC_QuaternaryExpr MPC_QuaternaryExpr;
 yMPC_CallExpr MPC_CallExpr;
 yMPC_Exprs MPC_Exprs;
 yMPC_Initializer MPC_Initializer;
 yMPC_SimpleInit MPC_SimpleInit;
 yMPC_InitList MPC_InitList;
};

extern tTree TreeRoot;
extern unsigned long Tree_HeapUsed;
extern char * Tree_PoolFreePtr, * Tree_PoolMaxPtr;
extern unsigned short Tree_NodeSize [97 + 1];
extern char * Tree_NodeName [97 + 1];

extern void (* Tree_Exit) ();
extern tTree Tree_Alloc ();
extern tTree MakeTree ARGS((Tree_tKind yyKind));
extern bool Tree_IsType ARGS((register tTree yyt, register Tree_tKind yyKind));

extern tTree nMPC_AstNode ();
extern tTree nMPC_Root ();
extern tTree nMPC_Source ();
extern tTree nMPC_Messages ();
extern tTree nMPC_ErrorMessage ();
extern tTree nMPC_ErrorMessageI ();
extern tTree nMPC_Message ();
extern tTree nMPC_MessageI ();
extern tTree nMPC_FreeNode ();
extern tTree nMPC_Decls ();
extern tTree nMPC_UncompString ();
extern tTree nMPC_Type ();
extern tTree nMPC_BasicType ();
extern tTree nMPC_EnumType ();
extern tTree nMPC_Typedef ();
extern tTree nMPC_DerivedType ();
extern tTree nMPC_ArrayType ();
extern tTree nMPC_VectorType ();
extern tTree nMPC_PointerType ();
extern tTree nMPC_StructType ();
extern tTree nMPC_UnionType ();
extern tTree nMPC_FunctionType ();
extern tTree nMPC_VarDecl ();
extern tTree nMPC_Function ();
extern tTree nMPC_Ellipsis ();
extern tTree nMPC_NetDecl ();
extern tTree nMPC_SubnetDecl ();
extern tTree nMPC_RelDecl ();
extern tTree nMPC_NetTypeDecl ();
extern tTree nMPC_NetType ();
extern tTree nMPC_NetTypeSpecifier ();
extern tTree nMPC_TopoFunctions ();
extern tTree nMPC_EnumConst ();
extern tTree nMPC_SU_MemberDecl ();
extern tTree nMPC_SU_Member ();
extern tTree nMPC_Var ();
extern tTree nMPC_CoordDecl ();
extern tTree nMPC_Node ();
extern tTree nMPC_NodeQual ();
extern tTree nMPC_NodeTypeQual ();
extern tTree nMPC_BenchQual ();
extern tTree nMPC_LinkDecl ();
extern tTree nMPC_LinkDeclaringList ();
extern tTree nMPC_LinkDeclarator ();
extern tTree nMPC_LinkLengthSpecifier ();
extern tTree nMPC_Scheme ();
extern tTree nMPC_NetList ();
extern tTree nMPC_NetOrSubnet ();
extern tTree nMPC_Net ();
extern tTree nMPC_Subnet ();
extern tTree nMPC_Relation ();
extern tTree nMPC_Stats ();
extern tTree nMPC_Stat ();
extern tTree nMPC_ExprStat ();
extern tTree nMPC_If ();
extern tTree nMPC_IfElse ();
extern tTree nMPC_Switch ();
extern tTree nMPC_While ();
extern tTree nMPC_DoWhile ();
extern tTree nMPC_For ();
extern tTree nMPC_Goto ();
extern tTree nMPC_Continue ();
extern tTree nMPC_Break ();
extern tTree nMPC_BreakFan ();
extern tTree nMPC_Return ();
extern tTree nMPC_Compound ();
extern tTree nMPC_CompScheme ();
extern tTree nMPC_CommScheme ();
extern tTree nMPC_ParScheme ();
extern tTree nMPC_Fan ();
extern tTree nMPC_Label ();
extern tTree nMPC_IdentLabel ();
extern tTree nMPC_CaseLabel ();
extern tTree nMPC_Default ();
extern tTree nMPC_Expr ();
extern tTree nMPC_Const ();
extern tTree nMPC_IntConst ();
extern tTree nMPC_UIntConst ();
extern tTree nMPC_FloatConst ();
extern tTree nMPC_StringLiteral ();
extern tTree nMPC_Ident ();
extern tTree nMPC_CastExpr ();
extern tTree nMPC_NetCastExpr ();
extern tTree nMPC_CoordExpr ();
extern tTree nMPC_SizeofExpr ();
extern tTree nMPC_Size_Of_Value ();
extern tTree nMPC_Size_Of_Type ();
extern tTree nMPC_TimeofExpr ();
extern tTree nMPC_UnaryExpr ();
extern tTree nMPC_BinaryExpr ();
extern tTree nMPC_TernaryExpr ();
extern tTree nMPC_QuaternaryExpr ();
extern tTree nMPC_CallExpr ();
extern tTree nMPC_Exprs ();
extern tTree nMPC_Initializer ();
extern tTree nMPC_SimpleInit ();
extern tTree nMPC_InitList ();

extern tTree mMPC_AstNode ARGS(());
extern tTree mMPC_Root ARGS((tTree pDecls, tTree pSource, tTree pMessages, tTree pHost, tTree pSingleNode, tTree pComputingSpace, tTree pConst, tTree pRecon, tTree pHostList, tTree pSingleNodeList, tTree pComputingSpaceList, tTree pConstList, tTree pReconList));
extern tTree mMPC_Source ARGS((tString pFileName, tPosition pVirtPos, tPosition pRealPos, tTree pNext, tTree pPrev));
extern tTree mMPC_Messages ARGS((int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_ErrorMessage ARGS((int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, int pErrorCode));
extern tTree mMPC_ErrorMessageI ARGS((int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, int pErrorCode, int pInfoClass, tString pInfo));
extern tTree mMPC_Message ARGS((int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, short pMessageNumber));
extern tTree mMPC_MessageI ARGS((int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, short pMessageNumber, int pInfoClass, tString pInfo));
extern tTree mMPC_FreeNode ARGS((tTree pParent));
extern tTree mMPC_Decls ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_UncompString ARGS((tPosition pPos, tTree pNext, tTree pPrev, tString puString));
extern tTree mMPC_Type ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag));
extern tTree mMPC_BasicType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, short pTypeConstructor));
extern tTree mMPC_EnumType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, tIdent pEnumTag, tTree pEnumList));
extern tTree mMPC_Typedef ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, tIdent pTypedefName, tTree pType));
extern tTree mMPC_DerivedType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents));
extern tTree mMPC_ArrayType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pStep, tTree pElementType));
extern tTree mMPC_VectorType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tTree pElementType));
extern tTree mMPC_PointerType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pStep, tTree pElementType));
extern tTree mMPC_StructType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tIdent pSU_Tag, tTree pMemberDecls));
extern tTree mMPC_UnionType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tIdent pSU_Tag, tTree pMemberDecls));
extern tTree mMPC_FunctionType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pKind, tTree pResultType, tTree pNetParamType, tTree pNetParam, tTree pNetworkParamList, tTree pParamList));
extern tTree mMPC_VarDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tClass pClass, tDeclFlags pFlag, tTree pDeclSpecifier, tTree pVar));
extern tTree mMPC_Function ARGS((tPosition pPos, tTree pNext, tTree pPrev, short pKind, tDeclFlags pFlag, tTree pDistribution, tTree pName, tTree pType, tTree pParamList, tTree pStats));
extern tTree mMPC_Ellipsis ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_NetDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tClass pNetClass, tDeclFlags pFlag, tTree pNetTypeSpecifier, tTree pNet));
extern tTree mMPC_SubnetDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tClass pSubnetClass, tDeclFlags pFlag, tTree pSubnet));
extern tTree mMPC_RelDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTree pRelation));
extern tTree mMPC_NetTypeDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent));
extern tTree mMPC_NetType ARGS((tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent, tClass pClass, tTree pParamList, tTree pCoordDecl, tTree pNodeDecl, tTree pLinkDecl, tTree pStartDecl, tTree pSchemeDecl));
extern tTree mMPC_NetTypeSpecifier ARGS((tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent, tTree pNetType, tTree pArgList));
extern tTree mMPC_TopoFunctions ARGS((tTree pNode_Def, tTree pLink_Def, tTree pMain_Node_Def, tTree pPower_Def, tTree pNode_Coord_Def, tTree pNode_Number_Def, tTree pMapping_Def));
extern tTree mMPC_EnumConst ARGS((tPosition pPos, tIdent pName, bool pWithValue, int pValue, tTree pNext, tTree pPrev));
extern tTree mMPC_SU_MemberDecl ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTree pMember));
extern tTree mMPC_SU_Member ARGS((tPosition pPos, tIdent pName, short pBitFieldLength, tTree pNext, tTree pPrev, tTree pType, tTree pBitFieldSize));
extern tTree mMPC_Var ARGS((tPosition pPos, tIdent pIdent, tDeclFlags pFlag, tTree pNext, tTree pPrev, tTree pType, tTree pDistribution, tTree pInit));
extern tTree mMPC_CoordDecl ARGS((tPosition pPos, tIdent pIdent, tTree pNext, tTree pPrev, tTree pRange));
extern tTree mMPC_Node ARGS((tPosition pPos, tNodeType pNodeType, bool pDynamicType, tTree pNext, tTree pPrev, tTree pPredicate, tTree pNodeQual));
extern tTree mMPC_NodeQual ARGS((tPosition pPos, tTree pCapacityExpr));
extern tTree mMPC_NodeTypeQual ARGS((tPosition pPos, tTree pCapacityExpr, bool pFast, int pCapacity));
extern tTree mMPC_BenchQual ARGS((tPosition pPos, tTree pCapacityExpr, double pCapacity));
extern tTree mMPC_LinkDecl ARGS((tPosition pPos, tTree pFreeCoord, tTree pLinkDeclaringList));
extern tTree mMPC_LinkDeclaringList ARGS((tPosition pPos, tLinkType pLinkType, bool pDynamicLength, tTree pNext, tTree pPrev, tTree pPredicate, tTree pLinkLengthSpecifier, tTree pLinkDeclarator));
extern tTree mMPC_LinkDeclarator ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTree pLeftNode, tTree pRightNode));
extern tTree mMPC_LinkLengthSpecifier ARGS((tPosition pPos, tLinkType pLinkLength, tTree pLinkLengthExpr));
extern tTree mMPC_Scheme ARGS((tPosition pPos, tTree pBody));
extern tTree mMPC_NetList ARGS((tTree pNext, tTree pPrev, tTree pNet));
extern tTree mMPC_NetOrSubnet ARGS((tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev));
extern tTree mMPC_Net ARGS((tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev, short pTopology, tTree pNetType));
extern tTree mMPC_Subnet ARGS((tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev, tIdent pNetOrSubnetName, bool pFlexible, tTree pPredicate));
extern tTree mMPC_Relation ARGS((tPosition pPos, int pRelCode, tTree pNext, tTree pPrev, tTree pLNet, tTree pRNet));
extern tTree mMPC_Stats ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_Stat ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet));
extern tTree mMPC_ExprStat ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr));
extern tTree mMPC_If ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats));
extern tTree mMPC_IfElse ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pThen, tTree pElse));
extern tTree mMPC_Switch ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats));
extern tTree mMPC_While ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats));
extern tTree mMPC_DoWhile ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pStats, tTree pExpr));
extern tTree mMPC_For ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pInit, tTree pCond, tTree pReinit, tTree pStats));
extern tTree mMPC_Goto ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tIdent pIdent));
extern tTree mMPC_Continue ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet));
extern tTree mMPC_Break ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet));
extern tTree mMPC_BreakFan ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet));
extern tTree mMPC_Return ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr));
extern tTree mMPC_Compound ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, int pFunctionBody, tTree pDecls, tTree pStats));
extern tTree mMPC_CompScheme ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pNode));
extern tTree mMPC_CommScheme ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pFrom, tTree pTo));
extern tTree mMPC_ParScheme ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pInit, tTree pCond, tTree pReinit, tTree pStats));
extern tTree mMPC_Fan ARGS((tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pBody));
extern tTree mMPC_Label ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_IdentLabel ARGS((tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent));
extern tTree mMPC_CaseLabel ARGS((tPosition pPos, tTree pNext, tTree pPrev, long pCaseValue, tTree pExpr));
extern tTree mMPC_Default ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_Expr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet));
extern tTree mMPC_Const ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm));
extern tTree mMPC_IntConst ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, long pValue));
extern tTree mMPC_UIntConst ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, MPC_long_unsigned pValue));
extern tTree mMPC_FloatConst ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, MPC_long_double pValue));
extern tTree mMPC_StringLiteral ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pString, short pFullSize, tTree pNext, tTree pPrev));
extern tTree mMPC_Ident ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tIdent pIdent, tTree pStore));
extern tTree mMPC_CastExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pTypeName, tTree pOperand));
extern tTree mMPC_NetCastExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pFlexible, tTree pOperand));
extern tTree mMPC_CoordExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tIdent pCoordName, tTree pOperand));
extern tTree mMPC_SizeofExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue));
extern tTree mMPC_Size_Of_Value ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue, tTree pOperand));
extern tTree mMPC_Size_Of_Type ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue, tTree pOperand));
extern tTree mMPC_TimeofExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pNetDecl));
extern tTree mMPC_UnaryExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pOperand));
extern tTree mMPC_BinaryExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pLoperand, tTree pRoperand));
extern tTree mMPC_TernaryExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pFoperand, tTree pSoperand, tTree pToperand));
extern tTree mMPC_QuaternaryExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pOperand1, tTree pOperand2, tTree pOperand3, tTree pOperand4));
extern tTree mMPC_CallExpr ARGS((tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pFunction, tTree pArgList, tTree pNetworkArgList));
extern tTree mMPC_Exprs ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTree pExpr));
extern tTree mMPC_Initializer ARGS((tPosition pPos, tTree pNext, tTree pPrev));
extern tTree mMPC_SimpleInit ARGS((tPosition pPos, tTree pNext, tTree pPrev, tTree pExpr));
extern tTree mMPC_InitList ARGS((tPosition pPos, tTree pNext, tTree pPrev, int pLength, tTree pList));

extern void ReleaseTree ARGS((tTree yyt));
extern void ReleaseTreeModule ();
extern void WriteTree ARGS((FILE * yyyf, tTree yyt));
extern tTree ReadTree ARGS((FILE * yyyf));
extern void PutTree ARGS((FILE * yyyf, tTree yyt));
extern tTree GetTree ARGS((FILE * yyyf));
extern void TraverseTreeTD ARGS((tTree yyt, Tree_tProcTree yyyProc));
extern void TraverseTreeBU ARGS((tTree yyt, Tree_tProcTree yyyProc));
extern tTree ReverseTree ARGS((tTree yyt));
extern void ForallTree ARGS((tTree yyt, Tree_tProcTree yyProc));
extern tTree CopyTree ARGS((tTree yyt));
extern void BeginTree ();
extern void CloseTree ();

# endif
