#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>
#include <string.h>

#define BUFSIZE 256
#define PLENGTH 2560
static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

//rreddy
//For OpenMPI
static char openmpi[]="OPENMPI";

main(int argc, char **argv)
{
  char command[PLENGTH], mycommand[PLENGTH];

  int i;
  FILE *fp;
  char *point, *hpoint;
/* Group data */
        MPI_Group MPI_GROUP_WORLD;
        int nprocs, myrank;
        MPI_Status status;
        char *mpctopo, vasya[BUFSIZE], *whichmpi;
/*
 * Initialize the World.
 */
	MPI_Init(&argc, &argv);
	MPI_Comm_group(MPI_COMM_WORLD, &MPI_GROUP_WORLD);
	MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);

        command[0]='\0';
        mycommand[0]='\0';
        if(myrank==0)
          {
            whichmpi=getenv("WHICHMPI");
            mpctopo=getenv("MPCTOPO");
            strcpy(vasya, mpctopo);
            strcat(vasya, "/MPCshemazagruzki.vasya");
            
            fp=fopen(vasya, "r");
            if(fp==NULL)
              {
                printf("Cannot open file '%s'\n", vasya);
                exit(-1);
              }
            fscanf(fp, "%[^\n]\n", command);
            if(!strcmp(whichmpi,lam63))
              {
                point=strstr(command, " mpcld ");
                hpoint=strstr(point+=7, " -host ");
              }
            else
              {
                point=strstr(command, " -- ");
                hpoint=strstr(point+=4, " -host ");
              }
            if(hpoint!=NULL)
              memmove(hpoint, hpoint+6, strlen(hpoint+5));
            strcpy(mycommand, point);
          }
        for(i=1; i<nprocs; i++)
          {
            if(myrank==0)
              {
                fscanf(fp, "%[^\n]\n", command);
                if(!strcmp(whichmpi,lam63))
                  {
                    point=strstr(command, " mpcld ");
                    hpoint=strstr(point+=7, " -host ");
                  }
                else
                  {
                    point=strstr(command, " -- ");
                    hpoint=strstr(point+=4, " -host ");
                  }
                if(hpoint!=NULL)
                  {
                    char *cur;
                    
                    *hpoint='\0';
                    for(cur=strstr(point, "_host"); cur!=NULL; cur=strstr(cur+6, "_host"))
                      memcpy(cur, "_node", 5);
                  }
                MPI_Send(point, PLENGTH, MPI_CHAR, i, 0, MPI_COMM_WORLD);
              }
            if(myrank==i)
              {
                MPI_Recv(mycommand, PLENGTH, MPI_CHAR, 0, 0, MPI_COMM_WORLD, &status);
                system(mycommand);
              }
          }
        if(myrank==0)
        {
          system(mycommand);
        }
        MPI_Finalize();
        exit(0);
}
