#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>
#include <limits.h>
#include <sys/utsname.h>
#include <string.h>

#define MAX_NNL 256
#define Kb 1024
#define BUFSIZE (4*Kb) /**/
#define HOST 0

static int myrank, N, error, sumerr, *numps, *ranks, *filesizes;

#define IF_HOST if(myrank==HOST)

static char (*nodenames)[MAX_NNL], myname[MAX_NNL];

static char buf[BUFSIZE], (*buffer)[BUFSIZE];
static char name[MAX_NNL];


main(int argc, char **argv)
{
  FILE *fp;
  char *mpctopo, *mpcload;
  int nprocs;
  /* Group data */
  MPI_Group MPI_GROUP_WORLD;
  struct utsname node_info;
  int i, hm=-1, filesize;
        
  mpctopo=getenv("MPCTOPO");
  mpcload=getenv("MPCLOAD");
  
  uname(&node_info);
  strcpy(myname, node_info.nodename);
  /*
   * Initialize the World.
   */
  MPI_Init( &argc, &argv);
  MPI_Comm_group(MPI_COMM_WORLD, &MPI_GROUP_WORLD);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
  N=nprocs;

  IF_HOST
    {
      buffer=calloc(N, BUFSIZE);
      filesizes=calloc(N, sizeof(int));
      nodenames=calloc(N, MAX_NNL);
      strcpy(name, mpctopo);
      strcat(name, "/");
      strcat(name, argv[1]);
      strcat(name, ".def");
      if((fp=fopen(name,"r"))==NULL)
        {
          sumerr=1;
          printf("mpcload: can't open file %s\n", name);
        }
      else
        {
          for(i=0; i<N; i++)
            fgets(nodenames[i], MAX_NNL, fp);
          fclose(fp);
        }
    }
  MPI_Bcast(&sumerr, 1, MPI_INT, HOST, MPI_COMM_WORLD);
  if(sumerr)
    {
      MPI_Finalize();
      exit(-1);
    }
    
    {
      filesize=0;
      strcpy(name, mpcload);
      strcat(name, "/mpcload.log");
      {
        if(myrank==HOST)
          {
            if((fp=fopen(name, "r"))==NULL)
              {
                error=1;
                hm=myrank;
                printf("mpcload: cannot open file %s:%s.\n", myname, name);
              }
            else
              {
                filesize=fread(buf, 1, BUFSIZE, fp);
                if(ferror(fp))
                  {
                    error=1;
                    hm=myrank;
                    printf("mpcload: error during reading file %s:%s.\n", myname, name);
                  }
              }
          }
        else
          if((fp=fopen(name, "r"))==NULL)
            {
              error=1;
              hm=myrank;
            }
          else
            {
              filesize=fread(buf, 1, BUFSIZE, fp);
              if(ferror(fp))
                {
                  error=1;
                  hm=myrank;
                }              
            }
        MPI_Reduce(&error, &sumerr, 1, MPI_INT, MPI_SUM, HOST, MPI_COMM_WORLD);
        IF_HOST {
          int j;
          if(sumerr)
            printf("mpcload: problems with file $MPCLOAD/mpcload.log on %d computers:\n",
                   sumerr);
          ranks=calloc(N, sizeof(int));
          for(j=0; j<N; j++)
            ranks[j]=-1;
        }
        MPI_Gather(&hm, 1, MPI_INT, ranks, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        IF_HOST {
          int j;
          if(sumerr)
            for(j=0; j<N; j++)
              if(ranks[j]>=0)
                printf("          %s\n", nodenames[ranks[j]]);
          free(ranks);
        }
        MPI_Bcast(&sumerr, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        if(sumerr)
          {
            MPI_Finalize();
            exit(-1);
          }
        MPI_Gather(buf, BUFSIZE, MPI_CHAR, buffer, BUFSIZE, MPI_CHAR, HOST, MPI_COMM_WORLD);
        MPI_Gather(&filesize, 1, MPI_INT, filesizes, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        if(myrank==HOST) {
          for(i=0; i<N; i++)
            {
              buffer[i][BUFSIZE-1]='\0';
              if(filesizes[i])
                printf("Report from %s%s\n", nodenames[i], buffer[i]);
            }
          free(buffer);
        }
      }
    }
  MPI_Finalize();
  exit(0);
}
