#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>
#define BUFSIZE 1024

static char buf[BUFSIZE];
static char name[BUFSIZE];
static char myname[BUFSIZE];
static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

// rreddy
// For OpenMPI
static char openmpi[] = "OPENMPI";

void rgetenv(char *machine, char *par, char *outbuf)
{
  char *mpctopo, filename[BUFSIZE], command[BUFSIZE];
  FILE *f;
  
  mpctopo=getenv("MPCTOPO");
  strcpy(filename, mpctopo);
  strcat(filename, "/MPCtemp");
  strcpy(command, "ssh ");
  strcat(command, name);
  strcat(command, " echo");
  strcat(command, par);
  strcat(command, " > ");
  strcat(command, filename);
  system(command);
  f=fopen(filename, "r");
  if(f==NULL)
    {
      printf("rgetenv: cannot create a working file in directory %s.\n", mpctopo);
      exit(-1);
    }
  fscanf(f, "%[^ \n\t\b]", outbuf);
  fclose(f);
  remove(filename);
}

int MPC_Is_comment(const char* buffer)
{
  if (strlen(buffer) == 0) return 1;
  while(isspace(*buffer))
    buffer++;
  if (*buffer== '#')
    return 1;
  else
    return 0;
}  

int MPC_Is_left_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='{')
    return 1;
  else
    return 0;
}

int MPC_Is_right_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='}')
    return 1;
  else
    return 0;
}

main(int argc, char **argv)
{
  FILE *finput, *foutput, *foutput1, *foutput2, *fp, *machines_mpc,
    *fp4, *fp41, *fp42, *fp43;
  FILE *fp4_2, *fp41_2, *fp42_2, *fp43_2;
  char pgfile[BUFSIZE], pgfile1[BUFSIZE],
    pgfile2[BUFSIZE], pgfile3[BUFSIZE];
  char pgfile_2[BUFSIZE], pgfile1_2[BUFSIZE],
    pgfile2_2[BUFSIZE], pgfile3_2[BUFSIZE];
  int i=0, j=0;
  int num, totalnum=0;
  char *mpctopo, *whichmpi, *mpidir, *mpcload, *mpchome;
  struct utsname node_info;

  mpcload=getenv("MPCLOAD");
  if(mpcload==NULL)
    {
      printf("mpccreate: MPCLOAD not defined.\n");
      exit(-1);
    }
  strcpy(buf, mpcload);
  strcat(buf, "/MPCzyuzya.6");
  fp=fopen(buf, "w");
  if(fp==NULL)
    {
      printf("mpccreate: cannot create a working file in directory %s.\n", mpcload);
      exit(-1);
    }
  whichmpi=getenv("WHICHMPI");
  if(whichmpi==NULL)
    {
      whichmpi=lam;
      printf("mpccreate: WHICHMPI not defined (LAM selected).\n");
    }
  if(argv[1]==NULL)
    {
      printf("mpccreate: usage --> mpccreate <parallel-machine>\n");
      exit(-1);
    }
  if(!strcmp(whichmpi, mpich))
    {
      mpidir=getenv("MPIDIR");
      if(mpidir==NULL)
        {
          printf("mpccreate: MPIDIR not defined.\n");
          exit(-1);
        }
      strcpy(buf, mpidir);
      strcat(buf, "/util/machines/machines.mpc");
      if((machines_mpc=fopen(buf, "w"))==NULL)
        {
          printf("mpccreate: cannot create file %s\n", buf);
          exit(-1);
        }
    }
  //
  //rreddy
  //Added for OpenMPI
  else if ((!strcmp(whichmpi, mpich_p4))
           || (!strcmp(whichmpi, openmpi)
          )
       )
    {
      mpidir=getenv("MPIDIR");
      if(mpidir==NULL)
        {
          printf("mpccreate: MPIDIR not defined.\n");
          exit(-1);
        }
      mpchome=getenv("MPCHOME");
      if(mpchome==NULL)
        {
          printf("mpccreate: MPCHOME not defined.\n");
          exit(-1);
        }
    }
  else if(strcmp(whichmpi,lam) && strcmp(whichmpi,lam63))
    {
      printf("mpccreate: unsupported MPI implementation %s\n", whichmpi);
      exit(-1);
    }  
  
  uname(&node_info);
  strcpy(myname, node_info.nodename);
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpccreate: MPCTOPO not defined.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/");
  strcat(buf, argv[1]);
  if((finput=fopen(buf, "r"))==NULL)
    {
      printf("mpccreate: can not open file %s\n", buf);
      exit(-1);
    }
  strcpy(buf, mpctopo);
  strcat(buf, "/");
  strcat(buf, argv[1]);
  strcat(buf, ".def");
  if((foutput=fopen(buf, "w"))==NULL)
    {
      printf("mpccreate: can not create file %s\n", buf);
      exit(-1);
    }
  if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63) || !strcmp(whichmpi, mpich_p4))
    {
      strcpy(buf, mpctopo);
      strcat(buf, "/");
      strcat(buf, argv[1]);
      strcat(buf, ".ts");
      if((foutput1=fopen(buf, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s\n", buf);
          exit(-1);
        }
    }

  // 
  // rreddy
  // For OpenMPI
  if (!strcmp(whichmpi, openmpi))
    {
      strcpy(buf, mpctopo);
      strcat(buf, "/");
      strcat(buf, argv[1]);
      strcat(buf, ".ts_proc");
      if((foutput1=fopen(buf, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s\n", buf);
          exit(-1);
        }

      strcpy(buf, mpctopo);
      strcat(buf, "/");
      strcat(buf, argv[1]);
      strcat(buf, ".ts_run");
      if((foutput2=fopen(buf, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s\n", buf);
          exit(-1);
        }
    }

  if ((!strcmp(whichmpi,mpich_p4)))
    {
      strncpy(pgfile, "", BUFSIZE);
      strcpy(pgfile, mpctopo);
      strcat(pgfile, "/");
      strcat(pgfile, argv[1]);
      strcat(pgfile, ".p4");
      if((fp4=fopen(pgfile, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n", pgfile);
          exit(-1);
        }
      strncpy(pgfile1, "", BUFSIZE);
      strcpy(pgfile1, mpctopo);
      strcat(pgfile1, "/");
      strcat(pgfile1, argv[1]);
      strcat(pgfile1, ".p41");
      if((fp41=fopen(pgfile1, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile1);
          exit(-1);
        }
      strncpy(pgfile2, "", BUFSIZE);
      strcpy(pgfile2, mpctopo);
      strcat(pgfile2, "/");
      strcat(pgfile2, argv[1]);
      strcat(pgfile2, ".p42");
      if((fp42=fopen(pgfile2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile2);
          exit(-1);
        }
      strncpy(pgfile3, "", BUFSIZE);
      strcpy(pgfile3, mpctopo);
      strcat(pgfile3, "/");
      strcat(pgfile3, argv[1]);
      strcat(pgfile3, ".p43");
      if((fp43=fopen(pgfile3, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile3);
          exit(-1);
        }
    }
  
  if (!strcmp(whichmpi,openmpi))
    {
      strncpy(pgfile, "", BUFSIZE);
      strcpy(pgfile, mpctopo);
      strcat(pgfile, "/");
      strcat(pgfile, argv[1]);
      strcat(pgfile, ".p4_proc");
      if((fp4=fopen(pgfile, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n", pgfile);
          exit(-1);
        }

      strncpy(pgfile_2, "", BUFSIZE);
      strcpy(pgfile_2, mpctopo);
      strcat(pgfile_2, "/");
      strcat(pgfile_2, argv[1]);
      strcat(pgfile_2, ".p4_run");
      if((fp4_2=fopen(pgfile_2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n", pgfile_2);
          exit(-1);
        }

      strncpy(pgfile1, "", BUFSIZE);
      strcpy(pgfile1, mpctopo);
      strcat(pgfile1, "/");
      strcat(pgfile1, argv[1]);
      strcat(pgfile1, ".p41_proc");
      if((fp41=fopen(pgfile1, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile1);
          exit(-1);
        }

      strncpy(pgfile1_2, "", BUFSIZE);
      strcpy(pgfile1_2, mpctopo);
      strcat(pgfile1_2, "/");
      strcat(pgfile1_2, argv[1]);
      strcat(pgfile1_2, ".p41_run");
      if((fp41_2=fopen(pgfile1_2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile1_2);
          exit(-1);
        }

      strncpy(pgfile2, "", BUFSIZE);
      strcpy(pgfile2, mpctopo);
      strcat(pgfile2, "/");
      strcat(pgfile2, argv[1]);
      strcat(pgfile2, ".p42_proc");
      if((fp42=fopen(pgfile2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile2);
          exit(-1);
        }

      strncpy(pgfile2_2, "", BUFSIZE);
      strcpy(pgfile2_2, mpctopo);
      strcat(pgfile2_2, "/");
      strcat(pgfile2_2, argv[1]);
      strcat(pgfile2_2, ".p42_run");
      if((fp42_2=fopen(pgfile2_2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile2_2);
          exit(-1);
        }

      strncpy(pgfile3, "", BUFSIZE);
      strcpy(pgfile3, mpctopo);
      strcat(pgfile3, "/");
      strcat(pgfile3, argv[1]);
      strcat(pgfile3, ".p43_proc");
      if((fp43=fopen(pgfile3, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile3);
          exit(-1);
        }

      strncpy(pgfile3_2, "", BUFSIZE);
      strcpy(pgfile3_2, mpctopo);
      strcat(pgfile3_2, "/");
      strcat(pgfile3_2, argv[1]);
      strcat(pgfile3_2, ".p43_run");
      if((fp43_2=fopen(pgfile3_2, "w"))==NULL)
        {
          printf("mpccreate: can not create file %s.\n\n",pgfile3_2);
          exit(-1);
        }
    }
  
  while(fgets(buf, BUFSIZE, finput)!=NULL)
    {
      i++;
      if(strlen(buf)==BUFSIZE)
        {
          printf("mpccreate: too long string %d in file %s%s%s\n", i,
                 mpctopo, "/", argv[1]);
          fclose(foutput);
          strcpy(buf, mpctopo);
          strcat(buf, "/");
          strcat(buf, argv[1]);
          strcat(buf, ".def");
          remove(buf);
          if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63) || !strcmp(whichmpi, mpich_p4))
            {
              strcpy(buf, mpctopo);
              strcat(buf, "/");
              strcat(buf, argv[1]);
              strcat(buf, ".ts");
              remove(buf);
              exit(-1);
            }
          else if(!strcmp(whichmpi, openmpi))
            {
              strcpy(buf, mpctopo);
              strcat(buf, "/");
              strcat(buf, argv[1]);
              strcat(buf, ".ts_proc");
              remove(buf);

              strcpy(buf, mpctopo);
              strcat(buf, "/");
              strcat(buf, argv[1]);
              strcat(buf, ".ts_run");
              remove(buf);

              exit(-1);
            }
          else if(!strcmp(whichmpi, mpich))
            {
              strcpy(buf, mpidir);
              strcat(buf, "/util/machines/machines.mpc");
              remove(buf);
              exit(-1);
            }
        }
      if(MPC_Is_comment(buf) || MPC_Is_left_brace(buf) || MPC_Is_right_brace(buf))
        continue;
      else
        {
          sscanf(buf, "%[^ \t\b]", name);
          if(name[0]=='\n')
            continue;
          if(name[strlen(name)-1]=='\n')
            {
              printf("mpccreate: Wrong line %d in file %s/%s\n", i, mpctopo, argv[1]);
              printf("           (probably, the number of processes omitted)\n");
            out:
              fclose(foutput);
              strcpy(buf, mpctopo);
              strcat(buf, "/");
              strcat(buf, argv[1]);
              strcat(buf, ".def");
              remove(buf);
              if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63) || !strcmp(whichmpi, mpich_p4))
                {
                  strcpy(buf, mpctopo);
                  strcat(buf, "/");
                  strcat(buf, argv[1]);
                  strcat(buf, ".ts");
                  remove(buf);
                  exit(-1);
                }
              else if (!strcmp(whichmpi, openmpi))
                {
                  strcpy(buf, mpctopo);
                  strcat(buf, "/");
                  strcat(buf, argv[1]);
                  strcat(buf, ".ts_proc");
                  remove(buf);

                  strcpy(buf, mpctopo);
                  strcat(buf, "/");
                  strcat(buf, argv[1]);
                  strcat(buf, ".ts_run");
                  remove(buf);
                  exit(-1);
                }
              else if(!strcmp(whichmpi, mpich))
                {
                  strcpy(buf, mpidir);
                  strcat(buf, "/util/machines/machines.mpc");
                  remove(buf);
                  exit(-1);
                }
            }

          
          
          if(j==0 && strcmp(myname, name))
            {
              printf("mpccreate: You can create parallel machine \'%s\'\n", argv[1]);
              printf("           only from host \'%s\'.  Sorry.\n", name);
              goto out;
            }
          sscanf(buf+strlen(name), "%d", &num);
          if(num<=0) {
            printf("mpccreate: Wrong number of processes in line %d of file %s/%s\n",
                   i, mpctopo, argv[1]);
            goto out;
          }
          fprintf(foutput, "%s\n", name);
          if(!strcmp(whichmpi,lam))
            fprintf(foutput1, "crttopo -c %d -s n%d n%d -- %s\n", num, j, j, argv[1]);
          else if(!strcmp(whichmpi,lam63))
            fprintf(foutput1, "-np %d -s n%d n%d crttopo %s\n", num, j, j, argv[1]);
          else if(!strcmp(whichmpi,mpich))
            {
              int mynum;

              mynum=num;
              while(mynum--)
                fprintf(machines_mpc, "%s\n", name);  
            }
          else if(!strcmp(whichmpi,mpich_p4))
            {
              char rmpchome[BUFSIZE], rmpcload[BUFSIZE];
              int mynum;
              static procs=0, p4procs=0;

              if(!strcmp(myname, name))
                {
                  strcpy(rmpchome,mpchome);
                  strcpy(rmpcload,mpcload);
                }
              else
                {
                  rgetenv(name,"mpcload", rmpcload);
                  rgetenv(name,"mpchome", rmpchome);
                }
              mynum=num;
              while(mynum--)
                {
                  fprintf(foutput1, "%s %d %s/bin/crttopo\n", name, procs, rmpchome);
                  fprintf(fp43, "%s %d %s/fignya\n", name, procs, rmpcload);
                  if(procs==0)
                    procs=1;
                }
              fprintf(fp4, "%s %d %s/bin/mpcld\n", name, p4procs, rmpchome);
              fprintf(fp41, "%s %d %s/bin/gather\n", name, p4procs, rmpchome);
              fprintf(fp42, "%s %d %s/bin/bcast\n", name, p4procs, rmpchome);
              if(p4procs==0)
                p4procs=1;
            }
          else if(!strcmp(whichmpi,openmpi))
            {
              char rmpchome[BUFSIZE], rmpcload[BUFSIZE];
              int mynum;
              static procs=0, p4procs=0;

              if(!strcmp(myname, name))
                {
                  strcpy(rmpchome,mpchome);
                  strcpy(rmpcload,mpcload);
                }
              else
                {
                  rgetenv(name,"mpcload", rmpcload);
                  rgetenv(name,"mpchome", rmpchome);
                }
              mynum=num;
              while(mynum--)
                {
                  fprintf(foutput1, "%s\n", name);
                  fprintf(foutput2, "%s %d %s/bin/crttopo %s\n", "-np", 1, rmpchome, argv[1]);

                  fprintf(fp43, "%s\n", name);
                  fprintf(fp43_2, "%s %d %s/fignya\n", "-np", 1, rmpcload);
                }
              fprintf(fp4, "%s\n", name);
              fprintf(fp4_2, "%s %d %s/bin/mpcld\n", "-np", 1, rmpchome);

              fprintf(fp41, "%s\n", name);
              fprintf(fp41_2, "%s %d %s/bin/gather\n", "-np", 1, rmpchome);

              fprintf(fp42, "%s\n", name);
              fprintf(fp42_2, "%s %d %s/bin/bcast\n", "-np", 1, rmpchome);
            }
          j++;
          totalnum+=num;
        }
    }
  if(j==0)
    {
       printf("mpccreate: no information in file %s%s%s\n", mpctopo, "/", argv[1]);
       fclose(foutput);
       strcpy(buf, mpctopo);
       strcat(buf, "/");
       strcat(buf, argv[1]);
       strcat(buf, ".def");
       remove(buf);
       if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63) || !strcmp(whichmpi, mpich_p4))
         {
           strcpy(buf, mpctopo);
           strcat(buf, "/");
           strcat(buf, argv[1]);
           strcat(buf, ".ts");
           remove(buf);
           exit(-1);
         }
       else if(!strcmp(whichmpi, mpich))
         {
           strcpy(buf, mpidir);
           strcat(buf, "/util/machines/machines.mpc");
           remove(buf);
           exit(-1);
         }
       if(!strcmp(whichmpi,mpich_p4))
         {
           fclose(fp4);
           fclose(fp41);
           fclose(fp42);
           fclose(fp43);
           remove(pgfile);
           remove(pgfile1);
           remove(pgfile2);
           remove(pgfile3);
           exit(-1);
         }
       if(!strcmp(whichmpi,openmpi))
         {
           fclose(fp4);
           fclose(fp41);
           fclose(fp42);
           fclose(fp43);
           remove(pgfile);
           remove(pgfile1);
           remove(pgfile2);
           remove(pgfile3);

           fclose(fp4_2);
           fclose(fp41_2);
           fclose(fp42_2);
           fclose(fp43_2);
           remove(pgfile_2);
           remove(pgfile1_2);
           remove(pgfile2_2);
           remove(pgfile3_2);

           exit(-1);
         }
    }
  printf("mpccreate: net definition %s%s%s%s  created.\n",
         mpctopo, "/", argv[1], ".def");
  if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63) || !strcmp(whichmpi, mpich_p4))
    printf("mpccreate: scheme %s%s%s%s created.\n",
           mpctopo, "/",  argv[1], ".ts");

  if(!strcmp(whichmpi,openmpi))
    {
    printf("mpccreate: scheme %s%s%s%s created.\n", mpctopo, "/",  argv[1], ".ts_proc");
    printf("mpccreate: scheme %s%s%s%s created.\n", mpctopo, "/",  argv[1], ".ts_run");
    }

  if(!strcmp(whichmpi,mpich_p4))
    {
    printf("mpccreate: scheme %s created.\n", pgfile);
    printf("mpccreate: scheme %s created.\n", pgfile1);
    printf("mpccreate: scheme %s created.\n", pgfile2);
    printf("mpccreate: scheme %s created.\n", pgfile3);
    }

  if(!strcmp(whichmpi,openmpi))
    {
    printf("mpccreate: scheme %s created.\n", pgfile);
    printf("mpccreate: scheme %s created.\n", pgfile1);
    printf("mpccreate: scheme %s created.\n", pgfile2);
    printf("mpccreate: scheme %s created.\n", pgfile3);
    printf("mpccreate: scheme %s created.\n", pgfile_2);
    printf("mpccreate: scheme %s created.\n", pgfile1_2);
    printf("mpccreate: scheme %s created.\n", pgfile2_2);
    printf("mpccreate: scheme %s created.\n", pgfile3_2);
    }

  if(!strcmp(whichmpi, lam) || !strcmp(whichmpi, lam63))
    fprintf(fp, "$MPIDIR/bin/recon $MPCTOPO/%s.def && $MPIDIR/bin/lamboot $MPCTOPO/%s.def && $MPIDIR/bin/mpirun -w $MPIFLAGS $MPCTOPO/%s.ts && $MPCHOME/bin/logopen %s",
            argv[1], argv[1], argv[1], argv[1]);
  else if(!strcmp(whichmpi, mpich))
    fprintf(fp, "$MPIDIR/bin/mpirun -arch mpc -np %d $MPCHOME/bin/crttopo %s && $MPCHOME/bin/logopen %s",
              totalnum, argv[1], argv[1]);
  else if(!strcmp(whichmpi, mpich_p4))
    fprintf(fp, "$MPIDIR/bin/mpirun -p4pg $MPCTOPO/%s.ts $MPCHOME/bin/crttopo %s && $MPCHOME/bin/logopen %s",
            argv[1], argv[1], argv[1]);
  else if(!strcmp(whichmpi, openmpi))
    fprintf(fp, "$MPIDIR/bin/mpirun --hostfile $MPCTOPO/%s.ts_proc --app $MPCTOPO/%s.ts_run && $MPCHOME/bin/logopen %s", argv[1], argv[1], argv[1]);
  else
    fprintf(fp, "echo Wrong MPI implementation!");
  
  exit(0);
}
