#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFSIZE 256

static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

//rreddy
//For OPENMPI
static char openmpi[]="OPENMPI";

main(int argc, char **argv)
{
  char buf[BUFSIZE];
  FILE *finput, *fp;
  char *mpctopo, *whichmpi, *mpcload;

  if(argv[1]==NULL)
    {
      printf("mpcopen: usage --> mpcopen <parallel-machine>\n");
      exit(-1);
    }
  whichmpi=getenv("WHICHMPI");
  if(whichmpi==NULL)
    {
      whichmpi=lam;
      printf("mpcopen: Environmental variable WHICHMPI not defined (LAM selected).\n");
    }
  if(strcmp(whichmpi,lam)&&strcmp(whichmpi,lam63)&&strcmp(whichmpi,mpich)&&strcmp(whichmpi,mpich_p4)&& strcmp(whichmpi,openmpi))
    {
      printf("mpcopen: unsupported MPI implementation %s\n", whichmpi);
      exit(-1);
    }
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpcopen: cannot find environmental variable MPCTOPO.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((finput=fopen(buf, "r"))!=NULL)
    {
      fscanf(finput, "%s", buf);
      if(strcmp(argv[1], buf))
        printf("mpcopen: before opening \'%s\', close \'%s\'\n", argv[1], buf);
      else
        printf("mpcopen: \'%s\' is already opened.\n", buf);
      fclose(finput);
      exit(-1);
    }
  mpcload=getenv("MPCLOAD");
  if(mpcload==NULL)
    {
      printf("mpcopen: MPCLOAD not defined.\n");
      exit(-1);
    }
  strcpy(buf, mpcload);
  strcat(buf, "/MPCzyuzya.4");
  fp=fopen(buf, "w");
  if(fp==NULL)
    {
      printf("mpcopen: cannot create a working file in directory %s.\n", mpcload);
      exit(-1);
    }
  if(!strcmp(whichmpi,lam) || !strcmp(whichmpi,lam63))
    {
      fprintf(fp,
              "$MPIDIR/bin/recon $MPCTOPO/%s.def && $MPIDIR/bin/lamboot $MPCTOPO/%s.def && $MPCHOME/bin/logopen %s",
              argv[1], argv[1], argv[1]);
    }
  else if(!strcmp(whichmpi,mpich) || !strcmp(whichmpi,mpich_p4) || !strcmp(whichmpi,openmpi))
    {
      fprintf(fp, "ls $MPCTOPO/%s.def >/dev/null && $MPCHOME/bin/logopen %s", argv[1], argv[1]);
    }
  fclose(fp);
  exit(0);
}
