#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define BUFSIZE 1024

char buf[BUFSIZE];

int MPC_Is_comment(const char* buffer)
{
  if (strlen(buffer) == 0) return 1;
  while(isspace(*buffer))
    buffer++;
  if (*buffer== '#')
    return 1;
  else
    return 0;
}  

int MPC_Is_left_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='{')
    return 1;
  else
    return 0;
}

int MPC_Is_right_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='}')
    return 1;
  else
    return 0;
}

main(int argc, char **argv)
{
  FILE *f;
  char *mpctopo;
  int level, descr;

  if(argv[1]==NULL)
    {
      printf("mpccreate: usage --> mpccreate <parallel-machine>\n");
      exit(-1);
    }
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpccreat: environmental variable MPCTOPO not defined\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((f=fopen(buf, "r"))!=NULL)
    {
      fscanf(f, "%s", buf);
      if(strcmp(argv[1], buf))
        printf("mpccreate: before creating \'%s\', close \'%s\'\n",
               argv[1], buf);
      else
        printf("mpccreate: \'%s\' is now opened. Close it before.\n",
               buf);
      fclose(f);
      exit(-1);
    }
  strcpy(buf, mpctopo);
  strcat(buf, "/");
  strcat(buf, argv[1]);
  if((f=fopen(buf, "r"))==NULL)
    {
      printf("mpccreate: can not open file %s\n", buf);
      exit(-1);
    }
  level=0;
  descr=0;
  while (!feof(f))
    {
      buf[0] = (char)0;
      fgets(buf,BUFSIZE,f);
      if (MPC_Is_comment(buf))
        ;
      else if(MPC_Is_left_brace(buf))
        {
          level++;
          descr=0;
        }
      else if(MPC_Is_right_brace(buf))
        {
          level--;
          if(level<0)
            {
              printf
                ("mpccreate: not balanced braces in the '%s' description\n",
                 argv[1]);
              fclose(f);
              exit(-1);
            }
          if(descr==0)
            {
              printf
                ("mpccreate: empty cluster in the '%s' description\n",
                 argv[1]);
              fclose(f);
              exit(-1);
            }
        }
      else 
        descr++;
    } /* while */
  if(level!=0)
    {
      printf("mpccreate: not balanced braces in the '%s' description\n",argv[1]);
      fclose(f);
      exit(-1);
    }
  fclose(f);
  
  exit(0);
}
