#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFS 256

static char buf[BUFS];

main()
{
  FILE *fp;
  char *mpctopo, *whichmpi;

  whichmpi=getenv("WHICHMPI");
  if(whichmpi!=NULL && strcmp(whichmpi, "LAM") && strcmp(whichmpi, "LAM6.3"))
    {
      printf("mpcclean makes sense only for LAM MPI.\n");
      exit(-1);
    }
  mpctopo=getenv("MPCTOPO");
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((fp=fopen(buf, "r"))==NULL)
    {
      printf("mpcclean: there are not any open machines.\n");
      exit(-1);
    }
  else
    {
      if(fgets(buf, BUFS, fp)==NULL)
        {
          printf("mpcclean: can't read file '%s/topo/log/current'.\n", mpctopo);
          exit(-1);
        }
      else
        {
          printf("mpcclean: cleaning machine '%s'\n", buf);
          exit(0);
        }
    }
}
