#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/utsname.h>

#define BUFSIZE 8192
#define BUFSI 256
static char buf[BUFSI], buf1[BUFSI], buf2[BUFSI], buf3[BUFSI];
static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

//
//rreddy
//For OpenMPI
static char openmpi[]="OPENMPI";

int main(int argc, char **argv)
{
  FILE *fp, *fp1, *fpw;
  char *mpctopo, *whichmpi, *myname, *p1, *p2, *mpcload;
  struct utsname node_info;
  int i;

  if(argc<1)
    {
      printf("mpcbcast: usage --> mpcbcast <file1> [<file2>...]\n");
      exit(-1);
    }

  mpcload=getenv("MPCLOAD");
  if(mpcload==NULL)
    {
      printf("mpcbcast: MPCLOAD not defined.\n");
      exit(-1);
    }
  uname(&node_info);
  myname=node_info.nodename;

  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpcbcast: MPCTOPO not defined.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");

  whichmpi=getenv("WHICHMPI");
  if(whichmpi==NULL)
    {
      whichmpi=lam;
      printf("mpcbcast: WHICHMPI not defined (LAM selected).\n");
    }
  if((fp=fopen(buf, "r"))==NULL)
    {
      printf("mpcbcast: no open machine.\n");
      exit(-1);
    }
  else
    {
      fscanf(fp, "%s", buf1);
        {
          strncpy(buf, "", BUFSI);
          strcpy(buf, mpctopo);
          strcat(buf, "/");
          strcat(buf, buf1);
          strcat(buf, ".def");
          if((fp1=fopen(buf, "r"))==NULL)
            {
              printf("mpcbcast: can not open file %s.\n", buf);
              exit(-1);
            }
          fscanf(fp1, "%s", buf2);
          if(strcmp(buf2, myname))
            {
              printf("mpcbcast: you can broadcast files only from host \'%s\'. Sorry. Bye!\n",
                     buf2);
              exit(-1);
            }
        }
    }
  fclose(fp);
  strncpy(buf, "", BUFSI);
  strcat(buf, "-m ");
  strcat(buf, buf1);
  strcat(buf, " ");
  
  for(i=1; i<argc; i++)
    {
      strcat(buf, argv[i]);
      strcat(buf, " ");
    }
  if(!strcmp(whichmpi,lam)|| !strcmp(whichmpi,lam63))
    {
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCshemazagruzki.petya");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot create a working file in directory %s.\n", mpcload);
          exit(-1);
        }
      fp=fopen(buf3, "w");
      i=0;
      if(!strcmp(whichmpi,lam))
        do
          {
            fprintf(fp, "bcast -c 1 -s n%d n%d -- %s\n", i, i, buf);
            i++;
          }
        while(fscanf(fp1, "%s", buf2)==1);
      else
        do
          {
            fprintf(fp, "-np 1 -s n%d n%d bcast %s\n", i, i, buf);
            i++;
          }
        while(fscanf(fp1, "%s", buf2)==1);
      fclose(fp);
      fclose(fp1);
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCzyuzya.3");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot create a working file in directory %s.\n", mpcload);
          exit(-1);
        }
      fprintf(fp,"$MPIDIR/bin/mpirun -w $MPIFLAGS $MPCLOAD/MPCshemazagruzki.petya && rm $MPCLOAD/MPCshemazagruzki.petya");
      fclose(fp);
    }
  else if(!strcmp(whichmpi,mpich))
    {
      i=0;
      do i++; while(fscanf(fp1, "%s", buf2)==1);
      fclose(fp1);
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCzyuzya.3");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot create a working file in directory %s.\n", mpcload);
          exit(-1);
        }
      fprintf(fp, "cp $MPCTOPO/%s.def $MPIDIR/bin/machines/machines.%s && $MPIDIR/bin/mpirun -arch %s -np %d $MPCHOME/bin/bcast %s && rm $MPIDIR/bin/machines/machines.%s",
              buf1, buf1, buf1, i, buf, buf1);
      fclose(fp);
    }
  else if(!strcmp(whichmpi,mpich_p4))
    {
      char pgfile2[BUFSI];
      
      strncpy(pgfile2, "", BUFSI);
      strcpy(pgfile2, mpctopo);
      strcat(pgfile2, "/");
      strcat(pgfile2, buf1);
      strcat(pgfile2, ".p42");
      fp=fopen(pgfile2, "r");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot open file %s.\n", pgfile2);
          exit(-1);
        }
      fclose(fp);

      i=0;
      do i++; while(fscanf(fp1, "%s", buf2)==1);
      fclose(fp1);
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCzyuzya.3");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot create a working file in directory %s.\n", mpcload);
          exit(-1);
        }
      fprintf(fp, "$MPIDIR/bin/mpirun -p4pg %s $MPCHOME/bin/bcast %s",
              pgfile2, buf);
      fclose(fp);
    }
  else if(!strcmp(whichmpi,openmpi))
    {
      char pgfile2[BUFSI];
      char pgfile2_2[BUFSI];
      char pgfile2_3[BUFSI];
      char temp[BUFSIZE];
      
      strncpy(pgfile2, "", BUFSI);
      strcpy(pgfile2, mpctopo);
      strcat(pgfile2, "/");
      strcat(pgfile2, buf1);
      strcat(pgfile2, ".p42_proc");
      fp=fopen(pgfile2, "r");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot open file %s.\n", pgfile2);
          exit(-1);
        }
      fclose(fp);

      strncpy(pgfile2_2, "", BUFSI);
      strcpy(pgfile2_2, mpctopo);
      strcat(pgfile2_2, "/");
      strcat(pgfile2_2, buf1);
      strcat(pgfile2_2, ".p42_run");
      fp=fopen(pgfile2_2, "r");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot open file %s.\n", pgfile2_2);
          exit(-1);
        }

      strcpy(pgfile2_3, mpcload);
      strcat(pgfile2_3, "/");
      strcat(pgfile2_3, "MPCzyuzya.9");
      fpw=fopen(pgfile2_3, "w");
      if(fpw==NULL)
        {
          printf("mpcbcast: cannot open file %s.\n", pgfile2_3);
          exit(-1);
        }

      while((fgets(temp, BUFSIZE, fp))!=NULL) { 
           int i = 0;
           while (temp[i] != '\n')
           {
              fprintf(fpw, "%c", temp[i]);
              i++;
           }
           fprintf(fpw, " %s\n", buf); 
      }

      fclose(fp);
      fclose(fpw);

      i=0;
      do i++; while(fscanf(fp1, "%s", buf2)==1);
      fclose(fp1);
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCzyuzya.3");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcbcast: cannot create a working file in directory %s.\n", mpcload);
          exit(-1);
        }
      fprintf(fp, "$MPIDIR/bin/mpirun --hostfile %s --app %s && /bin/rm $MPCLOAD/MPCzyuzya.9", pgfile2, pgfile2_3);
      fclose(fp);
    }
  else
    {
      printf("mpcbcast: unsupported MPI implementation %s\n", whichmpi);
      exit(-1);
    }
  exit(0);
}

