/*
 * $Id: stack.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


/* stack for net */
/* Coded by A.Kalinov 2.96 */

#include "be_print.h"

#define StackControl(pointer) \
  ((void) ((pointer != NULL) ? 0 : \
   print_and_abort(pointer, __FILE__, __LINE__)))


void Net_stack_Init(Net_stack* stack) {
  int size=NET_STACK_LEN;
  if(prt) printf("Net_stack_Init stack=%p\n",stack); 
  StackControl(stack);
  stack->len=size;
  stack->head=0;
  /*  stack->base=malloc(sizeof(Net_rec)*NET_STACK_LEN);*/
  if(prt) printf("Net_stack_Init size=%d\n",size);
  stack->base=malloc(sizeof(Net_rec)*size);
  if(prt) printf("Net_stack_Init stack=%p stack->base=%p\n",stack,stack->base); 
}

void Net_stack_Push(Net_stack* stack, Net_rec* rec) {
  if(prt) printf("Net_stack_Push stack=%p rec=%p\n",stack,rec); 
  StackControl(stack);
  StackControl(rec);
  if(stack->head == stack->len-1) {
  stack->len*=2;
    stack->base=realloc(stack->base,
                          sizeof(Net_rec)*stack->len);
  }
  (stack->base)[stack->head++]=*rec;
}

Net_rec Net_stack_Pop(Net_stack* stack) {
  StackControl(stack);
  if(prt) printf("Net_stack_Pop stack=%p stack->head=%d\n",
         stack,stack->head); 
  if(stack->head <1) {
    fprintf(stderr,"Network stack is empty \n");
    internal_error();
  }
  return (stack->base)[--stack->head];
}

int Net_stack_Is_empty(Net_stack* stack) {
  StackControl(stack);
  if(prt) printf("Net_stack_Is_empty stack=%p stack->head=%d\n",
         stack,stack->head); 
  return stack->head == 0;
}

void Net_stack_Free(Net_stack* stack) {
  if(prt) printf("Net_stack_Free stack=%p\n",stack); 
  StackControl(stack);
  free(stack->base);
}

void Stat_stack_Init() {
  int size=STAT_STACK_LEN;
  if(prt) printf("Stat_stack_Init stack=%p\n",&statement_stack); 
  statement_stack.len=STAT_STACK_LEN;
  statement_stack.head=0;
  /*  statement_stack.base=malloc(sizeof(Net_rec)*STAT_STACK_LEN);*/
  if(prt) printf("Stat_stack_Init size=%d\n",size);
  statement_stack.base=malloc(sizeof(Net_rec)*size);
  if(prt) printf("Stat_stack_Init stack=%p stack->base=%p\n",
         &statement_stack,statement_stack.base); 
}

void Stat_stack_Push(Stat_rec* rec) {
  if(prt) printf("Stat_stack_Push rec=%p stack->head=%d\n",
         *rec,statement_stack.head); 
  StackControl(rec);
  if(statement_stack.head == statement_stack.len-1) {
  statement_stack.len*=2;
    statement_stack.base=realloc(statement_stack.base,
                          sizeof(Net_rec)*statement_stack.len);
  }
  (statement_stack.base)[statement_stack.head++]=*rec;
}

void Stat_stack_Pop() {
  if(prt) printf("Stat_stack_Pop stack->head=%d\n",
         statement_stack.head); 
  if(statement_stack.head <1) {
    fprintf(stderr,"Network stack is empty \n");
    internal_error();
  }
  --statement_stack.head;
}

int Stat_stack_Is_empty() {
  if(prt) printf("Stat_stack_Is_empty stack->head=%d\n",
         statement_stack.head); 
  return statement_stack.head == 0;
}

void Stat_stack_Free() {
  if(prt) printf("Stat_stack_Free stack=%p\n",&statement_stack); 
  free(statement_stack.base);
}

int Stat_stack_Number() {
  if(prt) printf("Stat_stack_Head stack->head=%d\n",
         statement_stack.head); 
  return statement_stack.head-1;
}

Stat_rec Stat_stack_Element(int num) {
  if(prt) printf("Stat_stack_Pop stack->head=%d\n",
         statement_stack.head); 
  if(statement_stack.head <1) {
    fprintf(stderr,"Network stack is empty \n");
    internal_error();
  }
  if(statement_stack.head <=num) {
    fprintf(stderr,"Network stack element number > head \n");
    internal_error();
  }
  return (statement_stack.base)[num];
}
